/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileFilter;
import com.huawei.dc.common.components.dialog.fileselection.model.DCFileInfo;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.sam.model.SAMBrowseFileTableInfo;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.huawei.dc.taskmgmt.util.TaskOperCommonUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class SAMFileSelectBrowseDlg
extends FileSelectionBrowseDlg {
    private static final long serialVersionUID = -7988688801829048912L;
    private int m_iSAMOperationID = 0;
    private String m_strSelectedContentTypeId;
    private DeviceTypeInfo m_oSelectedDevType;

    public SAMFileSelectBrowseDlg(DeviceTypeInfo oDeviceTypeInfo, int iSAMOperationID, String strSelectedContentTypeId, String initPath) throws DCException {
        super(oDeviceTypeInfo.getDevDomain(), !DCFrameWorkUtil.getIsSingleClient(), false, "ImportSoftwareForSAM", initPath);
        this.m_oSelectedDevType = oDeviceTypeInfo;
        this.m_iSAMOperationID = iSAMOperationID;
        this.m_strSelectedContentTypeId = strSelectedContentTypeId;
        this.jInit();
    }

    private void jInit() {
        if (this.m_isShowDestination) {
            String strDescText = ResourceManager.getInstance().getResString("BROWSE_SELECT_FILE_DESC_LABEL");
            JLabel oDescLabel = new JLabel(strDescText);
            this.getContentPane().add((Component)oDescLabel, "North");
        }
        String strDescription = ResourceManager.getInstance().getResString(this.m_oSelectedDevType, this.m_strSelectedContentTypeId);
        String strFilter = TaskOperCommonUtil.generateFilterSuffix(this.m_iDomain, this.m_strSelectedContentTypeId);
        boolean isAddFilter = true;
        if ("".equals(strFilter)) {
            isAddFilter = false;
        }
        DCFileFilter oFileFilter = null;
        if (isAddFilter) {
            oFileFilter = new DCFileFilter(strFilter, strDescription);
        }
        this.m_oSelectServerFilePanel.updateTableModel(new DCTableModel(new SAMBrowseFileTableInfo()));
        this.m_oSelectServerFilePanel.setFileTypeFilterVisible(true);
        if (isAddFilter) {
            this.m_oSelectServerFilePanel.addFileFilter(oFileFilter);
        }
        this.m_oSelectServerFilePanel.setRootDir(this.m_oSelectServerFilePanel.getFileView().getCurrentPath());
        this.m_oSelectServerFilePanel.setSelectFileFilter(0);
        this.initSelectLocalFilePanel();
        if (isAddFilter) {
            this.m_oSelectLocalFilePanel.addFileFilter(oFileFilter);
        }
        if (null != this.m_oSelectDestPanel) {
            this.m_oSelectDestPanel.setSelectedDestination(DESTINATION_NMS_CLIENT);
        }
    }

    public String generateFilterSuffix(int iDevDomain, String sFileContentType) {
        StringBuffer filterFileSuffex = new StringBuffer();
        if (4 == iDevDomain) {
            filterFileSuffex.append("*.pkg");
        } else if (2 == iDevDomain) {
            if ("PROGRAM".equals(sFileContentType)) {
                filterFileSuffex.append("*.cc");
            } else if ("PATCH".equals(sFileContentType)) {
                filterFileSuffex.append("*.pat");
            } else {
                filterFileSuffex.append("*.txt");
            }
        } else if ("PROGRAM".equals(sFileContentType)) {
            filterFileSuffex.append("*.lma");
        } else if ("PACKETFILE".equals(sFileContentType)) {
            filterFileSuffex.append("*.bin");
            filterFileSuffex.append("; ");
            filterFileSuffex.append("*.Packet");
            filterFileSuffex.append("; ");
            filterFileSuffex.append("*.zip");
        } else if ("DBUPDATE".equals(sFileContentType)) {
            filterFileSuffex.append("*.zip");
        } else if (1 == this.m_iSAMOperationID) {
            filterFileSuffex.append("*.ini");
        }
        return filterFileSuffex.toString();
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (this.m_oBrowseDlgInterface instanceof SAMFileInfoImportPanel) {
            SAMFileInfoImportPanel oFileImportPanel = (SAMFileInfoImportPanel)this.m_oBrowseDlgInterface;
            switch (this.m_iSAMOperationID) {
                case 4: {
                    List<DCFileInfo> oFileInfos = this.m_oCurrentSelectFilePanel.getAllFileInCurrentPath();
                    ArrayList<String> oFilePathLst = new ArrayList<String>();
                    if (IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(this.getDestination())) {
                        File[] oFiles;
                        DCFileInfo oFileInfo = oFileInfos.get(0);
                        File oFile = new File(oFileInfo.getAbsolutePath());
                        for (File oTmpFile : oFiles = oFile.getParentFile().listFiles()) {
                            String strPath = oTmpFile.getAbsolutePath();
                            if (oTmpFile.isDirectory() || strPath.toLowerCase().endsWith(".pkg")) continue;
                            oFilePathLst.add(strPath);
                        }
                    } else {
                        for (DCFileInfo oFileInfo : oFileInfos) {
                            oFilePathLst.add(oFileInfo.getAbsolutePath());
                        }
                    }
                    oFileImportPanel.setFileListForSFTP(oFilePathLst);
                    break;
                }
            }
        }
        super.oKButton_ActionPerformed();
    }
}

