/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeNameInfo;
import com.huawei.dc.deviceinfo.DeviceTypeVersionInfo;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.huawei.dc.sam.view.SAMImportTreeNodeInfo;
import com.huawei.dc.sam.view.SeriesInfo;
import com.swimap.external.common.adapter.message.util.EmfColorFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SAMFileInfoTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree m_oDeviceTypeTree;
    private JScrollPane m_oScrollPane;
    private DefaultTreeModel m_oDeviceTypeTreeModel;
    private DefaultMutableTreeNode m_oRoot;
    private SortedMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> m_oDeviceTypeMap;
    private boolean m_bAlreadyVisited = false;
    private transient MouseListener m_oSAMTreeMouseListener;
    private int m_iCallType = 0;
    private DeviceTypeInfo m_oDevTypeForSaveBackupFile = null;
    private List<DeviceTypeInfo> m_oSelectedDeviceTypeList = new ArrayList<DeviceTypeInfo>(0);
    private SAMFileInfoImportPanel m_oFileImportPanel;

    public SAMFileInfoTreePanel(SortedMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> oDeviceTypeMap) {
        this.initializeDeviceTypeTree();
        this.setLayout(new GridLayout(0, 1));
        this.m_oDeviceTypeMap = oDeviceTypeMap;
        this.populateDeviceTypeTree();
        this.expandPathOfTree();
        this.addMouseListener();
        this.addKeyListener();
        this.add(this.m_oScrollPane);
    }

    private void expandPathOfTree() {
        TreePath oTreePath;
        if (null != this.m_oDeviceTypeTree && !this.m_oDeviceTypeTree.isExpanded(oTreePath = this.m_oDeviceTypeTree.getPathForRow(0))) {
            this.m_oDeviceTypeTree.expandPath(oTreePath);
        }
    }

    private void initializeDeviceTypeTree() {
        this.m_oDeviceTypeTree = new JTree();
        this.m_oDeviceTypeTree.setName("SAM_SAMFileInfoTreePanel_m_oDeviceTypeTree");
        this.m_oDeviceTypeTree.setShowsRootHandles(true);
        this.m_oDeviceTypeTreeModel = (DefaultTreeModel)this.m_oDeviceTypeTree.getModel();
        this.m_oDeviceTypeTree.getSelectionModel().setSelectionMode(1);
        this.m_oRoot = new DefaultMutableTreeNode();
        SAMImportTreeNodeInfo oRootNode = new SAMImportTreeNodeInfo(DCFrameWorkUtil.getLocalizedString("DEVICE_TYPE_TREE_TITLE"));
        this.m_oRoot.setUserObject(oRootNode);
        this.m_oDeviceTypeTreeModel.setRoot(this.m_oRoot);
        this.m_oDeviceTypeTree.setSelectionRow(0);
        this.m_oDeviceTypeTree.setCellRenderer(this.generateRenderer());
        this.m_oScrollPane = new JScrollPane(this.m_oDeviceTypeTree);
        this.m_oScrollPane.setName("SAM_SAMFileInfoTreePanel_m_oScrollPane");
    }

    private void populateDeviceTypeTree() {
        if (null == this.m_oDeviceTypeMap) {
            return;
        }
        HashMap<String, DefaultMutableTreeNode> devSeriesNodeMap = this.getSupportedSeries();
        Set<DeviceTypeNameInfo> oDevTypeNameInfoSet = this.m_oDeviceTypeMap.keySet();
        Iterator<DeviceTypeNameInfo> oIterator = oDevTypeNameInfoSet.iterator();
        DefaultMutableTreeNode oDevTypeNameNode = null;
        DefaultMutableTreeNode oVerNode = null;
        DeviceTypeNameInfo oDevTypeNameInfo = null;
        SAMImportTreeNodeInfo oNodeInfo = null;
        List oDevTypeVerNameList = null;
        DeviceTypeVersionInfo oDeviceTypeVersionInfo = null;
        SAMImportTreeNodeInfo oVerNodeInfo = null;
        while (oIterator.hasNext()) {
            oDevTypeNameInfo = oIterator.next();
            String strKey = String.valueOf(oDevTypeNameInfo.getDevTypeId());
            oNodeInfo = new SAMImportTreeNodeInfo(oDevTypeNameInfo);
            oDevTypeNameNode = new DefaultMutableTreeNode(oNodeInfo);
            if (!devSeriesNodeMap.containsKey(strKey)) continue;
            DefaultMutableTreeNode oSeriesNode = devSeriesNodeMap.get(strKey);
            oSeriesNode.add(oDevTypeNameNode);
            oDevTypeVerNameList = (List)this.m_oDeviceTypeMap.get(oDevTypeNameInfo);
            int iVerListSize = oDevTypeVerNameList.size();
            for (int i = 0; i < iVerListSize; ++i) {
                oDeviceTypeVersionInfo = (DeviceTypeVersionInfo)oDevTypeVerNameList.get(i);
                oVerNodeInfo = new SAMImportTreeNodeInfo(oDeviceTypeVersionInfo);
                oVerNode = new DefaultMutableTreeNode(oVerNodeInfo);
                oDevTypeNameNode.add(oVerNode);
            }
        }
        int iSeriesNodeCount = this.m_oRoot.getChildCount();
        int i = 0;
        while (i < iSeriesNodeCount) {
            if (0 >= this.m_oRoot.getChildAt(i).getChildCount()) {
                this.m_oRoot.remove(i);
                iSeriesNodeCount = this.m_oRoot.getChildCount();
                continue;
            }
            ++i;
        }
    }

    public HashMap<String, DefaultMutableTreeNode> getSupportedSeries() {
        HashMap<String, DefaultMutableTreeNode> devSeriesMap = new HashMap<String, DefaultMutableTreeNode>();
        ArrayList<SeriesInfo> oSeriesInfos = DeviceInfoManagerImplHelper.getSessionInfo();
        int iSize = oSeriesInfos.size();
        Object[] strSeriesInfoList = new SeriesInfo[iSize];
        oSeriesInfos.toArray(strSeriesInfoList);
        Arrays.sort(strSeriesInfoList);
        for (int i = 0; i < iSize; ++i) {
            String[] strDevTypesList = ((SeriesInfo)strSeriesInfoList[i]).getDevTypes();
            SAMImportTreeNodeInfo oNodeInfo = new SAMImportTreeNodeInfo(((SeriesInfo)strSeriesInfoList[i]).getSeriesName(), ((SeriesInfo)strSeriesInfoList[i]).getSeriesID());
            DefaultMutableTreeNode oDevSeriesNode = new DefaultMutableTreeNode(oNodeInfo);
            int iCount = strDevTypesList.length;
            for (int j = 0; j < iCount; ++j) {
                this.m_oRoot.add(oDevSeriesNode);
                devSeriesMap.put(strDevTypesList[j], oDevSeriesNode);
            }
        }
        return devSeriesMap;
    }

    private void addMouseListener() {
        this.m_oSAMTreeMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                SAMFileInfoTreePanel.this.mouseClicked_SAMTree(oMouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SAMFileInfoTreePanel.this.m_bAlreadyVisited = false;
                if (4 != e.getModifiers()) {
                    if (0 == (e.getModifiers() & 0x10) && 0 == (e.getModifiers() & 8) && e.getID() == 500 && e.getClickCount() == 1) {
                        SAMFileInfoTreePanel.this.m_oDeviceTypeTree.setSelectionPath(null);
                        return;
                    }
                    int x = e.getX();
                    int y = e.getY();
                    int row = SAMFileInfoTreePanel.this.m_oDeviceTypeTree.getRowForLocation(x, y);
                    Rectangle rec = SAMFileInfoTreePanel.this.m_oDeviceTypeTree.getRowBounds(row);
                    if (null == rec) {
                        SAMFileInfoTreePanel.this.m_bAlreadyVisited = true;
                    }
                    return;
                }
                DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)SAMFileInfoTreePanel.this.m_oDeviceTypeTree.getLastSelectedPathComponent();
                SAMFileInfoTreePanel.this.sendNotificationToTreeListeners(nodeObject);
            }
        };
        this.m_oDeviceTypeTree.addMouseListener(this.m_oSAMTreeMouseListener);
    }

    public MouseListener getMouseListener() {
        return this.m_oSAMTreeMouseListener;
    }

    protected void mouseClicked_SAMTree(MouseEvent oMouseEvent) {
        DCDebugTracer.trace("Method mouseClicked_SAMTree start");
        int x = oMouseEvent.getX();
        int y = oMouseEvent.getY();
        int iRow = this.m_oDeviceTypeTree.getRowForLocation(x, y);
        if (0 > iRow) {
            iRow = this.m_oDeviceTypeTree.getRowForLocation(x + 20, y);
        }
        if (0 > iRow) {
            return;
        }
        Rectangle rec = this.m_oDeviceTypeTree.getRowBounds(iRow);
        DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)this.m_oDeviceTypeTree.getLastSelectedPathComponent();
        if (this.m_bAlreadyVisited) {
            if (!(this.m_oDeviceTypeTree.getLastSelectedPathComponent() instanceof DefaultMutableTreeNode) || rec == null) {
                this.sendNotificationToTreeListeners(nodeObject);
            }
            return;
        }
        if (4 == oMouseEvent.getModifiers()) {
            return;
        }
        if (0 == (oMouseEvent.getModifiers() & 0x10) && 0 == (oMouseEvent.getModifiers() & 8) && oMouseEvent.getID() == 500 && oMouseEvent.getClickCount() == 1) {
            this.m_oDeviceTypeTree.setSelectionPath(null);
            return;
        }
        double iCheckX = rec.getMinX();
        JCheckBox check = new JCheckBox();
        Dimension d_Check = check.getPreferredSize();
        if ((double)x > iCheckX && (double)x < iCheckX + d_Check.getWidth()) {
            SAMImportTreeNodeInfo nodeInfo = (SAMImportTreeNodeInfo)nodeObject.getUserObject();
            if (0 == nodeInfo.getNodeType()) {
                return;
            }
            if (1 == this.getCallType()) {
                int iDevTypeID = -1;
                iDevTypeID = 2 == nodeInfo.getNodeType() ? nodeInfo.getDeviceTypeNameInfo().getDevTypeId() : nodeInfo.getDeviceTypeVersionInfo().getDevTypeNameInfo().getDevTypeId();
                if (-1 != iDevTypeID && iDevTypeID != this.getDevTypeForSaveBackupFile().getDevTypeID()) {
                    return;
                }
            }
            int selectedState = nodeInfo.getSelectedState();
            Enumeration<TreeNode> childrens = nodeObject.breadthFirstEnumeration();
            this.handleSelection(nodeObject, nodeInfo, selectedState, childrens);
            if (1 == this.getCallType()) {
                this.handleSelectionForBackupFile(this.getUserObject());
            }
            this.updateTree();
            this.sendNotificationToTreeListeners(nodeObject);
            DCDebugTracer.trace("Method mouseClicked_SAMTree end");
        }
    }

    private void handleSelectionForBackupFile(Object object) {
        if (!(object instanceof SAMImportTreeNodeInfo)) {
            return;
        }
        SAMImportTreeNodeInfo oTreeNodeInfo = (SAMImportTreeNodeInfo)object;
        if (2 == oTreeNodeInfo.getNodeType()) {
            DeviceTypeNameInfo oDevTypeNameInfo = oTreeNodeInfo.getDeviceTypeNameInfo();
            DeviceTypeInfo oDevTypeInfo = null;
            DeviceTypeVersionInfo oDevTypeVerInfo = oTreeNodeInfo.getDeviceTypeVersionInfo();
            int iDevTypeID = oDevTypeNameInfo.getDevTypeId();
            int iDevTypeVerID = oDevTypeVerInfo.getVersionId();
            oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            if (0 == oTreeNodeInfo.getSelectedState()) {
                if (!this.getSelectedDeviceTypeList().contains(oDevTypeInfo)) {
                    this.getSelectedDeviceTypeList().add(oDevTypeInfo);
                }
            } else if (2 == oTreeNodeInfo.getSelectedState()) {
                this.getSelectedDeviceTypeList().remove(oDevTypeInfo);
            }
        } else if (3 == oTreeNodeInfo.getNodeType()) {
            DeviceTypeVersionInfo oDevTypeVerInfo = oTreeNodeInfo.getDeviceTypeVersionInfo();
            int iDevTypeID = oDevTypeVerInfo.getDevTypeNameInfo().getDevTypeId();
            int iDevTypeVerID = oDevTypeVerInfo.getVersionId();
            DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            if (0 == oTreeNodeInfo.getSelectedState()) {
                if (!this.getSelectedDeviceTypeList().contains(oDevTypeInfo)) {
                    this.getSelectedDeviceTypeList().add(oDevTypeInfo);
                }
            } else if (2 == oTreeNodeInfo.getSelectedState()) {
                this.getSelectedDeviceTypeList().remove(oDevTypeInfo);
            }
        } else {
            return;
        }
    }

    private void handleSelection(DefaultMutableTreeNode nodeObject, SAMImportTreeNodeInfo nodeInfo, int selectedState, Enumeration<DefaultMutableTreeNode> childrens) {
        switch (selectedState) {
            case 0: {
                this.handleAllSelect(nodeObject, nodeInfo, childrens);
                break;
            }
            case 1: 
            case 2: {
                this.handleNoneSelect(nodeObject, nodeInfo, childrens);
                break;
            }
        }
    }

    private void handleAllSelect(DefaultMutableTreeNode nodeObject, SAMImportTreeNodeInfo nodeInfo, Enumeration<DefaultMutableTreeNode> childrens) {
        DCDebugTracer.trace("Method handleAllSelect start");
        nodeInfo.setSelectedState(2);
        while (childrens.hasMoreElements()) {
            ((SAMImportTreeNodeInfo)childrens.nextElement().getUserObject()).setSelectedState(2);
        }
        SAMFileInfoTreePanel.propogateSelectionToParentNode(nodeObject, 2);
        DCDebugTracer.trace("Method handleAllSelect end");
    }

    private void handleNoneSelect(DefaultMutableTreeNode nodeObject, SAMImportTreeNodeInfo nodeInfo, Enumeration<DefaultMutableTreeNode> childrens) {
        DCDebugTracer.trace("Method handleNoneSelect start");
        nodeInfo.setSelectedState(0);
        while (childrens.hasMoreElements()) {
            DefaultMutableTreeNode node = childrens.nextElement();
            SAMImportTreeNodeInfo tempNode = (SAMImportTreeNodeInfo)node.getUserObject();
            tempNode.setSelectedState(0);
        }
        SAMFileInfoTreePanel.propogateSelectionToParentNode(nodeObject, 0);
        DCDebugTracer.trace("Method handleNoneSelect end");
    }

    public static void propogateSelectionToParentNode(DefaultMutableTreeNode childNode, int typeOfSelection) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)childNode.getParent();
        SAMImportTreeNodeInfo child = null;
        if (null == parentNode) {
            child = (SAMImportTreeNodeInfo)childNode.getUserObject();
            child.setSelectedState(typeOfSelection);
            return;
        }
        SAMFileInfoTreePanel.updateSelectionForParent(parentNode);
    }

    public void setNodeState(DeviceTypeInfo oDevTypeInfo, boolean bSelected) {
        if (null == this.m_oRoot || null == oDevTypeInfo) {
            return;
        }
        if (1 == this.getCallType()) {
            this.m_oSelectedDeviceTypeList.add(oDevTypeInfo);
        }
        int iOriginalDevTypeID = oDevTypeInfo.getDevTypeID();
        int iOriginalDevTypeVerID = oDevTypeInfo.getDevTypeVersionId();
        DefaultMutableTreeNode oNode = null;
        SAMImportTreeNodeInfo oTreeNode = null;
        Enumeration<TreeNode> oChildren = this.m_oRoot.depthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            DeviceTypeNameInfo oDevTypeNameInfo;
            DeviceTypeVersionInfo oDeviceTypeVersionInfo;
            Object oUserObject;
            oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (null == oNode || null == (oUserObject = oNode.getUserObject()) || !(oUserObject instanceof SAMImportTreeNodeInfo) || null == (oDeviceTypeVersionInfo = (oTreeNode = (SAMImportTreeNodeInfo)oUserObject).getDeviceTypeVersionInfo()) || null == (oDevTypeNameInfo = oDeviceTypeVersionInfo.getDevTypeNameInfo())) continue;
            int iDevTypeID = oDevTypeNameInfo.getDevTypeId();
            int iDevTypeVerID = oDeviceTypeVersionInfo.getVersionId();
            if (iDevTypeID != iOriginalDevTypeID || iDevTypeVerID != iOriginalDevTypeVerID) continue;
            oTreeNode.setSelectedState(0);
            SAMFileInfoTreePanel.propogateSelectionToParentNode(oNode, 1);
            DefaultMutableTreeNode oParentNode = (DefaultMutableTreeNode)oNode.getParent();
            TreePath trePath = new TreePath(oParentNode.getPath());
            this.m_oDeviceTypeTree.setSelectionPath(trePath);
            this.m_oDeviceTypeTree.expandPath(trePath);
            this.m_oDeviceTypeTree.scrollPathToVisible(trePath);
            this.notifyEvent(new DCDeviceTreeNodeSelectionEventObject(oTreeNode));
            break;
        }
        this.updateTree();
        this.repaint();
    }

    private static void updateSelectionForParent(DefaultMutableTreeNode parentNode) {
        DCDebugTracer.trace("Method updateSelectionForParent start");
        if (null == parentNode) {
            return;
        }
        DefaultMutableTreeNode oChildNode = null;
        SAMImportTreeNodeInfo oChildNodeInfo = null;
        boolean isAnyChildSelected = false;
        boolean isPartiallySelected = false;
        boolean isAnyChildDeselected = false;
        int iChildCount = parentNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            oChildNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            oChildNodeInfo = (SAMImportTreeNodeInfo)oChildNode.getUserObject();
            if (oChildNodeInfo.getSelectedState() == 1) {
                isPartiallySelected = true;
                ((SAMImportTreeNodeInfo)parentNode.getUserObject()).setSelectedState(1);
                SAMFileInfoTreePanel.propogateSelectionToParentNode(parentNode, 1);
                break;
            }
            if (oChildNodeInfo.getSelectedState() == 0) {
                isAnyChildSelected = true;
                if (!isAnyChildDeselected) continue;
                break;
            }
            if (oChildNodeInfo.getSelectedState() != 2) continue;
            isAnyChildDeselected = true;
            if (isAnyChildSelected) break;
        }
        SAMFileInfoTreePanel.populateNodeForChildSelection(parentNode, isAnyChildSelected, isPartiallySelected, isAnyChildDeselected);
        DCDebugTracer.trace("Method updateSelectionForParent end");
    }

    private static void populateNodeForChildSelection(DefaultMutableTreeNode oParentNode, boolean isAnyChildSelected, boolean isPartiallySelected, boolean isAnyChildDeselected) {
        if (null == oParentNode) {
            return;
        }
        if (!isPartiallySelected) {
            SAMImportTreeNodeInfo oNodeInfo = (SAMImportTreeNodeInfo)oParentNode.getUserObject();
            if (isAnyChildSelected && isAnyChildDeselected) {
                oNodeInfo.setSelectedState(1);
                SAMFileInfoTreePanel.propogateSelectionToParentNode(oParentNode, 1);
            } else if (isAnyChildSelected && !isAnyChildDeselected) {
                oNodeInfo.setSelectedState(0);
                SAMFileInfoTreePanel.propogateSelectionToParentNode(oParentNode, 0);
            } else if (!isAnyChildSelected && isAnyChildDeselected) {
                oNodeInfo.setSelectedState(2);
                SAMFileInfoTreePanel.propogateSelectionToParentNode(oParentNode, 2);
            }
        }
    }

    private void addKeyListener() {
        this.m_oDeviceTypeTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (32 == arg0.getKeyCode()) {
                    DefaultMutableTreeNode nodeObject = (DefaultMutableTreeNode)SAMFileInfoTreePanel.this.m_oDeviceTypeTree.getLastSelectedPathComponent();
                    SAMImportTreeNodeInfo nodeInfo = (SAMImportTreeNodeInfo)nodeObject.getUserObject();
                    if (0 == nodeInfo.getNodeType()) {
                        return;
                    }
                    int selectedState = nodeInfo.getSelectedState();
                    Enumeration<TreeNode> childrens = nodeObject.breadthFirstEnumeration();
                    SAMFileInfoTreePanel.this.handleSelection(nodeObject, nodeInfo, selectedState, childrens);
                    SAMFileInfoTreePanel.this.updateTree();
                    SAMFileInfoTreePanel.this.notifyEvent(new DCDeviceTreeNodeSelectionEventObject(nodeInfo));
                }
            }
        });
    }

    public void sendNotificationToTreeListeners(DefaultMutableTreeNode oNode) {
        if (null == oNode || 1 == this.getCallType()) {
            return;
        }
        Object oUserObject = this.getUserObject();
        this.notifyEvent(new DCDeviceTreeNodeSelectionEventObject(oUserObject));
    }

    private void notifyEvent(DCEventObject oDCEvent) {
        if (null != this.m_oFileImportPanel) {
            this.m_oFileImportPanel.onTreeNodeSelection(oDCEvent);
        }
    }

    private Object getUserObject() {
        TreePath oPath = this.m_oDeviceTypeTree.getSelectionPath();
        DefaultMutableTreeNode oSelectedNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
        Object oUserObject = oSelectedNode.getUserObject();
        return oUserObject;
    }

    private TreeCellRenderer generateRenderer() {
        return new TreeCellRenderer(){
            private EmfColorFilter m_oFilter = null;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
                if (!(aValue instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
                Object oNodeUserObject = oNode.getUserObject();
                if (!(oNodeUserObject instanceof SAMImportTreeNodeInfo)) {
                    return null;
                }
                SAMImportTreeNodeInfo oNodeInfo = (SAMImportTreeNodeInfo)oNodeUserObject;
                JPanel oPanel = new JPanel();
                oPanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
                JLabel oLabel = this.initializeLabelForNode(oNodeInfo, anIsSelected, leaf, anIsExpanded, tree.getBackground());
                oLabel.setText(oNodeInfo.getNodeName());
                oPanel.setLayout(new BorderLayout());
                oPanel.add(oLabel);
                return oPanel;
            }

            protected JLabel initializeLabelForNode(SAMImportTreeNodeInfo oUserObject, boolean anIsSelected, boolean bIsLeaf, boolean anIsExpanded, Color oBGColor) {
                JLabel oLabel = this.createLabelWithIcon(oUserObject, bIsLeaf, anIsExpanded, oBGColor);
                if (anIsSelected) {
                    oLabel.setForeground(Color.BLUE);
                } else {
                    oLabel.setForeground(Color.BLACK);
                }
                return oLabel;
            }

            protected JLabel createLabelWithIcon(SAMImportTreeNodeInfo oUserObject, boolean bIsLeaf, boolean anIsExpanded, Color oBGColor) {
                JLabel oLabel = new JLabel();
                ImageIcon oCheckBoxIcon = null;
                if (0 == oUserObject.getNodeType()) {
                    oCheckBoxIcon = ResourceManager.getInstance().getImage("");
                    oLabel.setIcon(oCheckBoxIcon);
                } else {
                    int iNodeSelectedState = oUserObject.getSelectedState();
                    switch (iNodeSelectedState) {
                        case 0: {
                            oCheckBoxIcon = ResourceManager.getInstance().getImage("all.gif");
                            break;
                        }
                        case 1: {
                            oCheckBoxIcon = ResourceManager.getInstance().getImage("part.gif");
                            break;
                        }
                        case 2: {
                            oCheckBoxIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                            break;
                        }
                        default: {
                            oCheckBoxIcon = ResourceManager.getInstance().getImage("noneselect.gif");
                        }
                    }
                    Image iNodeImage = this.getFilterImage(oCheckBoxIcon.getImage(), oBGColor);
                    oLabel.setIcon(new ImageIcon(iNodeImage));
                }
                return oLabel;
            }

            private Image getFilterImage(Image oImage, Color oColor) {
                if (null == oColor) {
                    return oImage;
                }
                this.m_oFilter = new EmfColorFilter(true, 40, 20.0, oColor);
                Image oNodeDrawingImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(oImage.getSource(), (ImageFilter)this.m_oFilter));
                oImage.flush();
                oNodeDrawingImage.flush();
                return oNodeDrawingImage;
            }
        };
    }

    private void updateTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SAMFileInfoTreePanel.this.m_oDeviceTypeTree.treeDidChange();
            }
        });
    }

    public void handleParentNodeSelectionForError(SAMImportTreeNodeInfo oSAMImportTreeNodeInfo, List<DeviceTypeInfo> oSelectedDeviceTypeList) {
        DCDebugTracer.trace("Method handleParentNodeSelectionForError start");
        TreePath oPath = this.m_oDeviceTypeTree.getSelectionPath();
        DefaultMutableTreeNode oSelectedNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
        SAMImportTreeNodeInfo oUserObject = (SAMImportTreeNodeInfo)oSelectedNode.getUserObject();
        if (oUserObject.equals(oSAMImportTreeNodeInfo)) {
            if (1 == oUserObject.getNodeType()) {
                Enumeration<TreeNode> childrens = oSelectedNode.breadthFirstEnumeration();
                while (childrens.hasMoreElements()) {
                    SAMImportTreeNodeInfo oNode = (SAMImportTreeNodeInfo)((DefaultMutableTreeNode)childrens.nextElement()).getUserObject();
                    if (2 == oNode.getNodeType() && oNode.getSelectedState() != 2 && null != oNode.getDeviceTypeNameInfo()) {
                        int iDevTypeID = oNode.getDeviceTypeNameInfo().getDevTypeId();
                        this.removeDevTypeFromLst(iDevTypeID, oSelectedDeviceTypeList);
                    }
                    oNode.setSelectedState(2);
                }
            } else if (3 == oUserObject.getNodeType()) {
                SAMFileInfoTreePanel.propogateSelectionToParentNode(oSelectedNode, 2);
            } else if (2 == oUserObject.getNodeType()) {
                Enumeration<TreeNode> childrens = oSelectedNode.breadthFirstEnumeration();
                while (childrens.hasMoreElements()) {
                    ((SAMImportTreeNodeInfo)((DefaultMutableTreeNode)childrens.nextElement()).getUserObject()).setSelectedState(2);
                }
                SAMFileInfoTreePanel.propogateSelectionToParentNode(oSelectedNode, 2);
            }
        }
        DCDebugTracer.trace("Method handleParentNodeSelectionForError end");
    }

    public void setTreeEnable(boolean bFlag) {
        this.m_oDeviceTypeTree.setEnabled(bFlag);
        if (!bFlag) {
            this.m_oDeviceTypeTree.removeMouseListener(this.m_oSAMTreeMouseListener);
            KeyListener[] oLis = this.m_oDeviceTypeTree.getKeyListeners();
            for (int i = 0; i < oLis.length; ++i) {
                this.m_oDeviceTypeTree.removeKeyListener(oLis[i]);
            }
        } else {
            this.addMouseListener();
            this.addKeyListener();
        }
    }

    public void doCleanUp() {
        this.m_oDeviceTypeTree = null;
        this.m_oScrollPane = null;
        this.m_oDeviceTypeTreeModel = null;
        this.m_oRoot = null;
        this.m_oDeviceTypeMap = null;
    }

    public JTree getTree() {
        return this.m_oDeviceTypeTree;
    }

    public void setCallType(int iCallType) {
        this.m_iCallType = iCallType;
    }

    public int getCallType() {
        return this.m_iCallType;
    }

    public void setDevTypeForSaveBackupFile(DeviceTypeInfo oDevType) {
        this.m_oDevTypeForSaveBackupFile = oDevType;
    }

    public DeviceTypeInfo getDevTypeForSaveBackupFile() {
        return this.m_oDevTypeForSaveBackupFile;
    }

    public void setSelectedDeviceTypeList(List<DeviceTypeInfo> oSelectedDeviceTypeList) {
        this.m_oSelectedDeviceTypeList = oSelectedDeviceTypeList;
    }

    public List<DeviceTypeInfo> getSelectedDeviceTypeList() {
        return this.m_oSelectedDeviceTypeList;
    }

    public void setImportPanel(SAMFileInfoImportPanel oFileImportPanel) {
        this.m_oFileImportPanel = oFileImportPanel;
    }

    private void removeDevTypeFromLst(int iDevTypeID, List<DeviceTypeInfo> oSelectedDeviceTypeList) {
        if (null == oSelectedDeviceTypeList) {
            return;
        }
        Iterator<DeviceTypeInfo> itor = oSelectedDeviceTypeList.iterator();
        DeviceTypeInfo oDevTypeInfo = null;
        while (itor.hasNext()) {
            oDevTypeInfo = itor.next();
            if (null == oDevTypeInfo || oDevTypeInfo.getDevTypeID() != iDevTypeID) continue;
            itor.remove();
            break;
        }
    }
}

