/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfoLst;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.file.util.SaveAsFileUtil;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMChangeEventListener;
import com.huawei.dc.sam.event.ISAMEventListener;
import com.huawei.dc.sam.event.SAMChangeEventReceiver;
import com.huawei.dc.sam.event.SAMEvent;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.ColumnSorter;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.sam.view.SAMFileInfoTablePanelHelper;
import com.huawei.dc.sam.view.SAMFileTableCellRenderer;
import com.huawei.dc.sam.view.SAMOperationProgressDlg;
import com.huawei.dc.sam.view.SAMPopupManager;
import com.huawei.dc.sam.view.SaveAsSAMFile;
import com.huawei.dc.sam.view.SoftwareArchiveMgmtPanel;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SAMFileInfoTablePanel
extends JPanel
implements DCTreeEventListener,
ISAMChangeEventListener,
ISAMEventListener {
    private static final long serialVersionUID = 7334291356595155510L;
    private JScrollPane m_oFileInfoScrollPane;
    private JTable m_oFileInfoTable;
    private SortButtonRenderer m_oSortButtonRenderer;
    protected DefaultTableModel m_oTableModel;
    private ISAMDataModel m_oSAMDataModel;
    private SAMPopupManager m_oSAMPopupMenuMgr;
    private JPopupMenu m_oSAMPopupMenu;
    private SoftwareArchiveMgmtPanel m_oSoftwareArchiveMgmtPanel;
    private DCDeviceTreeNodeSelectionEventObject m_oDeviceTreeSelectionEvent;
    private ISAMManager m_oSAMManager;
    private int[] m_iarrSelectedRow;
    private JPanel m_ButtonPane;
    private JButton importButton;
    private JButton updateButton;
    private JButton deleteButton;
    private JButton saveASButton;
    private JLabel oSoftCountLabel;
    private String strSoftCountText;
    private List<String> m_oVersrionLst = new LinkedList<String>();
    private char[] m_oSynVersrionLst = new char[0];
    private String strdate = "";
    private SaveAsFileUtil oSaveAsFileUtil = new SaveAsFileUtil();

    private JLabel createTaskCountLabel() {
        this.oSoftCountLabel = new JLabel();
        this.oSoftCountLabel.setPreferredSize(new Dimension(580, 23));
        this.oSoftCountLabel.setMinimumSize(new Dimension(580, 23));
        this.strSoftCountText = ResourceManager.getInstance().getResString("LBL_SELECT_SOFT_COUNT");
        this.refreshSelectedSoftLabel();
        return this.oSoftCountLabel;
    }

    public void refreshSelectedSoftLabel() {
        if (null == this.oSoftCountLabel) {
            return;
        }
        int iSelectedCount = 0;
        int[] arrSelectedRows = this.m_oFileInfoTable.getSelectedRows();
        if (null != arrSelectedRows) {
            iSelectedCount = arrSelectedRows.length;
        }
        int iSoftCount = this.m_oFileInfoTable.getRowCount();
        int iSelectCurRow = 0;
        if (iSelectedCount > 0) {
            iSelectCurRow = arrSelectedRows[0] + 1;
        }
        String strDeviceCountMsg = MessageFormat.format(this.strSoftCountText, "" + iSelectCurRow, "" + iSoftCount, "" + iSelectedCount, "" + this.strdate);
        this.oSoftCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
    }

    JPanel getButtonPanel() {
        if (null == this.m_ButtonPane) {
            this.m_ButtonPane = new JPanel();
            this.m_ButtonPane.setLayout(new GridBagLayout());
            this.m_ButtonPane.add((Component)this.createTaskCountLabel(), new GridBagConstraints(0, 0, 1, 5, 1.0, 0.0, 17, 1, new Insets(10, 12, 10, 0), 0, 0));
            this.m_ButtonPane.add((Component)this.getImportButton(), new GridBagConstraints(1, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 10, 0), 0, 0));
            this.m_ButtonPane.add((Component)this.getUpdateButton(), new GridBagConstraints(2, 0, 1, 5, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
            if (DCFrameWorkUtil.getIsSingleClient()) {
                this.m_ButtonPane.add((Component)this.getDeleteButton(), new GridBagConstraints(3, 0, 1, 5, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 12), 0, 0));
            } else {
                this.m_ButtonPane.add((Component)this.getDeleteButton(), new GridBagConstraints(3, 0, 1, 5, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 0), 0, 0));
            }
            this.m_ButtonPane.add((Component)this.getSaveasButton(), new GridBagConstraints(4, 0, 1, 5, 0.0, 0.0, 10, 0, new Insets(10, 12, 10, 12), 0, 0));
        }
        this.changeButtonStatus();
        return this.m_ButtonPane;
    }

    private JButton getImportButton() {
        if (null == this.importButton) {
            this.importButton = new JButton(DCFrameWorkUtil.getLocalizedString("SAM_POPUP_MENU_ITEM_IMPORT"));
            this.importButton.setMnemonic('P');
            this.importButton.setEnabled(true);
            this.importButton.setPreferredSize(new Dimension(110, 23));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SAMFileInfoTablePanel.this.importFile();
                }
            });
        }
        return this.importButton;
    }

    private JButton getUpdateButton() {
        if (null == this.updateButton) {
            this.updateButton = new JButton(DCFrameWorkUtil.getLocalizedString("SAM_POPUP_MENU_ITEM_UPDATE"));
            this.updateButton.setMnemonic('m');
            this.updateButton.setEnabled(false);
            this.updateButton.setPreferredSize(new Dimension(110, 23));
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SAMFileInfoTablePanel.this.updateFileInfo();
                }
            });
        }
        return this.updateButton;
    }

    private JButton getDeleteButton() {
        if (null == this.deleteButton) {
            this.deleteButton = new JButton(DCFrameWorkUtil.getLocalizedString("SAM_POPUP_MENU_ITEM_DELETE"));
            this.deleteButton.setMnemonic('d');
            this.deleteButton.setEnabled(false);
            this.deleteButton.setPreferredSize(new Dimension(110, 23));
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SAMFileInfoTablePanel.this.deleteFileInfo();
                }
            });
        }
        return this.deleteButton;
    }

    private JButton getSaveasButton() {
        if (null == this.saveASButton) {
            this.saveASButton = new JButton(DCFrameWorkUtil.getLocalizedString("SAM_POPUP_MENU_ITEM_SAVE"));
            this.saveASButton.setMnemonic('s');
            this.saveASButton.setPreferredSize(new Dimension(120, 23));
            this.saveASButton.setEnabled(false);
            this.saveASButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SAMFileInfoTablePanel.this.saveFileInfo();
                }
            });
        }
        return this.saveASButton;
    }

    void changeButtonStatus() {
        this.refreshSelectedSoftLabel();
        try {
            this.m_oSAMPopupMenuMgr.loadMenu();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCFrameWorkUtil.updateUI(this.m_oFileInfoTable);
            return;
        }
        boolean isimport = this.m_oSAMPopupMenuMgr.getMenuItemForID("Import").isEnabled();
        this.getImportButton().setEnabled(isimport);
        boolean isUpdate = this.m_oSAMPopupMenuMgr.getMenuItemForID("Update").isEnabled();
        this.getUpdateButton().setEnabled(isUpdate);
        boolean isDel = this.m_oSAMPopupMenuMgr.getMenuItemForID("Delete").isEnabled();
        this.getDeleteButton().setEnabled(isDel);
        boolean isSaveEnable = this.m_oSAMPopupMenuMgr.getMenuItemForID("Save").isEnabled();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.getSaveasButton().setVisible(false);
        } else {
            String value = ResourceManager.getInstance().getResString("ENABLE_SAM_SAVEAS", "config").trim();
            this.getSaveasButton().setVisible(false);
            if (value.equals("1")) {
                this.getSaveasButton().setVisible(true);
                this.getSaveasButton().setEnabled(isSaveEnable);
            }
        }
    }

    public SAMFileInfoTablePanel(SoftwareArchiveMgmtPanel oSAMPanel) {
        this.m_oSAMDataModel = SAMDataModel.getInstance();
        this.m_oSoftwareArchiveMgmtPanel = oSAMPanel;
        this.m_oSAMManager = SAMManager.getInstance();
        this.jbInit();
        ArrayList oFileInfoLst = this.m_oSAMDataModel.getFileInfoLst();
        this.populateAllFileInfoFromDataModel(oFileInfoLst);
        this.initializePopupMenuManager();
        this.m_oSAMManager.addSAMEventListener(this);
        this.addListenerForSAMFileChange();
    }

    private void jbInit() {
        this.createTableModel();
        this.createTable();
        this.initializeSelectionModel();
        this.initializeScrollPane();
        this.setLayout(new GridLayout());
        this.setName("SAM_SAMFileInfoTablePanel_this");
    }

    private void initializeScrollPane() {
        this.m_oFileInfoScrollPane = new JScrollPane(this.m_oFileInfoTable);
        this.m_oFileInfoScrollPane.setName("SAM_SAMFileInfoTablePanel_m_oFileInfoScrollPane");
        this.m_oFileInfoScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oFileInfoScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oFileInfoScrollPane = new JScrollPane(this.m_oFileInfoTable);
        this.m_oFileInfoScrollPane.getViewport().addMouseListener(this.generateMouseAdapterForTable());
        this.m_oFileInfoTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.registerForDeviceTreeEventNotifiaction();
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oFileInfoTable.registerKeyboardAction(this.generateKeyListenerAdapter(), oDeleteKeyStroke, 0);
        this.add(this.m_oFileInfoScrollPane);
    }

    private void registerForDeviceTreeEventNotifiaction() {
        DeviceTreePanel oDeviceTreePanel = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel();
        oDeviceTreePanel.addDCEventListener(this);
    }

    private void createTableModel() {
        Object[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_ICON_COLUMN"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_TYPE"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_VERSION"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_PATCH_VERSION"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_SIZE"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_DESCRIPTION"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_DEVICE_TYPE"), DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_DBVERSION")};
        this.m_oTableModel = new DefaultTableModel(strColumnNames, 0){
            private static final long serialVersionUID = 3145122201671069826L;

            @Override
            public boolean isCellEditable(int iRow, int iColumn) {
                return false;
            }
        };
    }

    private void initializeSelectionModel() {
        DefaultListSelectionModel devSelection = new DefaultListSelectionModel();
        devSelection.setSelectionMode(2);
        this.m_oFileInfoTable.setSelectionModel(devSelection);
    }

    public void populateAllFileInfoFromDataModel(ArrayList oFileInfoLst) {
        this.m_oTableModel.getDataVector().clear();
        this.m_oFileInfoTable.clearSelection();
        if (null == oFileInfoLst || oFileInfoLst.isEmpty()) {
            this.refreshTable();
            return;
        }
        int iSize = oFileInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            this.populateFileInfoInTable((ISAMFileInfo)oFileInfoLst.get(i));
        }
        this.refreshTable();
    }

    private void populateFileInfoInTable(ISAMFileInfo oSAMFileInfo) {
        Object[] oFileInfoRecord = this.fillCellDataInTable(oSAMFileInfo);
        this.m_oTableModel.addRow(oFileInfoRecord);
    }

    private Object[] fillCellDataInTable(ISAMFileInfo oSAMFileInfo) {
        if (null == oSAMFileInfo) {
            Object[] oReturn = null;
            return oReturn;
        }
        Object[] oCellData = new Object[]{"", oSAMFileInfo.getFileName(), oSAMFileInfo.getFileType(), oSAMFileInfo.getVersion(), oSAMFileInfo.getPatchVer(), oSAMFileInfo.getFileSize(), oSAMFileInfo.getFileDescription(), oSAMFileInfo.getDeviceTypeInfo(), oSAMFileInfo.getBDVersion()};
        return oCellData;
    }

    private void createTable() {
        this.m_oFileInfoTable = new JTable(this.m_oTableModel);
        this.m_oFileInfoTable.setName("SAM_SAMFileInfoTablePanel_m_oFileInfoTable");
        this.m_oFileInfoTable.setOpaque(true);
        this.m_oFileInfoTable.setFocusable(true);
        this.m_oFileInfoTable.setRowSelectionAllowed(true);
        this.m_oFileInfoTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.m_oFileInfoTable.getTableHeader().setReorderingAllowed(false);
        this.m_oFileInfoTable.getColumnModel().getColumn(8).setPreferredWidth(0);
        this.m_oFileInfoTable.getColumnModel().getColumn(8).setMinWidth(0);
        this.m_oFileInfoTable.getColumnModel().getColumn(8).setMaxWidth(0);
        this.initializeCellRenderers();
        this.initializeMouseAdapters();
        TableCustomizer oTableCustomizer = new TableCustomizer(this.m_oFileInfoTable, "conf/dc/saminfo_table.xml");
        ArrayList<TableColumn> oTableColumns = new ArrayList<TableColumn>();
        ArrayList<TableColumn> oTableColumnsForNotVisible = new ArrayList<TableColumn>();
        for (int i = 0; i < this.m_oFileInfoTable.getColumnModel().getColumnCount(); ++i) {
            if (this.m_oFileInfoTable.getColumnName(i).equals(DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_HEADER_ICON_COLUMN"))) {
                oTableColumns.add(this.m_oFileInfoTable.getColumnModel().getColumn(i));
                oTableColumnsForNotVisible.add(this.m_oFileInfoTable.getColumnModel().getColumn(i));
                continue;
            }
            if (this.m_oFileInfoTable.getColumnName(i).equals(DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_FILE_NAME"))) {
                oTableColumns.add(this.m_oFileInfoTable.getColumnModel().getColumn(i));
                continue;
            }
            if (!this.m_oFileInfoTable.getColumnName(i).equals(DCFrameWorkUtil.getLocalizedString("SAM_TABLE_COLUMN_DBVERSION"))) continue;
            oTableColumns.add(this.m_oFileInfoTable.getColumnModel().getColumn(i));
            oTableColumnsForNotVisible.add(this.m_oFileInfoTable.getColumnModel().getColumn(i));
        }
        oTableCustomizer.setNotAllowCustomizedColumns(oTableColumns);
        oTableCustomizer.setColumnNotVisibleInMenuAndSettingDlg(oTableColumnsForNotVisible);
    }

    private void initializeCellRenderers() {
        this.m_oSortButtonRenderer = new SortButtonRenderer();
        this.m_oSortButtonRenderer.setName("SAM_SAMFileInfoTablePanel_m_oSortButtonRenderer");
        SAMFileTableCellRenderer oDefaultCellRenderer = new SAMFileTableCellRenderer(this);
        SAMFileTableCellRenderer oDefaultCellRendererFilesize = new SAMFileTableCellRenderer(this);
        oDefaultCellRendererFilesize.setHorizontalAlignment(4);
        int iColumnCount = this.m_oFileInfoTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            if (i != 0 && i != 6 && i != 4) {
                this.m_oFileInfoTable.getColumnModel().getColumn(i).setHeaderRenderer((TableCellRenderer)this.m_oSortButtonRenderer);
            }
            if (i == 5) {
                this.m_oFileInfoTable.getColumnModel().getColumn(i).setCellRenderer(oDefaultCellRendererFilesize);
                continue;
            }
            this.m_oFileInfoTable.getColumnModel().getColumn(i).setCellRenderer(oDefaultCellRenderer);
        }
    }

    private void initializeMouseAdapters() {
        this.m_oFileInfoTable.getTableHeader().addMouseListener(this.generateMouseAdapterForTableHeader());
        this.m_oFileInfoTable.getTableHeader().addMouseMotionListener(this.generateMouseMotionAdapterForTableHeader());
        this.m_oFileInfoTable.addMouseMotionListener(this.generateMouseListenerAdapter());
        this.m_oFileInfoTable.addMouseListener(this.generateMouseAdapterForTable());
    }

    private ActionListener generateKeyListenerAdapter() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                SAMFileInfoTablePanel.this.deleteFileInfo();
            }
        };
    }

    private MouseMotionAdapter generateMouseListenerAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                SAMFileInfoTablePanel.this.setToolTipForTable(oEvent);
            }
        };
    }

    private MouseMotionAdapter generateMouseMotionAdapterForTableHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                SAMFileInfoTablePanel.this.setToolTipForTableHeader(oEvent);
            }
        };
    }

    private void setToolTipForTable(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        int iHitColumnIndex = this.m_oFileInfoTable.columnAtPoint(oPoint);
        int iHitRowIndex = this.m_oFileInfoTable.rowAtPoint(oPoint);
        Object oToolTipValue = this.m_oFileInfoTable.getModel().getValueAt(iHitRowIndex, iHitColumnIndex);
        this.m_oFileInfoTable.setToolTipText(oToolTipValue.toString());
    }

    private MouseAdapter generateMouseAdapterForTableHeader() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SAMFileInfoTablePanel.this.fileInfoTableHeader_MousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SAMFileInfoTablePanel.this.setCursorState();
            }
        };
    }

    private void setToolTipForTableHeader(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        JTableHeader oTableHeader = this.m_oFileInfoTable.getTableHeader();
        int iColumnIndex = oTableHeader.getColumnModel().getColumnIndexAtX((int)oPoint.getX());
        Object oToolTipValue = oTableHeader.getColumnModel().getColumn(iColumnIndex).getHeaderValue();
        oTableHeader.setToolTipText(oToolTipValue.toString());
    }

    protected void setCursorState() {
        DCFrameWorkUtil.setCursor(this, Cursor.getPredefinedCursor(0));
    }

    public JTable getSAMFileInfoTable() {
        return this.m_oFileInfoTable;
    }

    private void fileInfoTableHeader_MousePressed(MouseEvent oMouseEvent) {
        if (0 == (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        if (this.m_oFileInfoTable.getRowCount() <= 0) {
            return;
        }
        int iCurrentColumn = this.m_oFileInfoTable.getTableHeader().columnAtPoint(oMouseEvent.getPoint());
        iCurrentColumn = this.m_oFileInfoTable.getColumnModel().getColumn(iCurrentColumn).getModelIndex();
        if (0 == iCurrentColumn || 6 == iCurrentColumn) {
            return;
        }
        boolean bSortType = this.m_oSortButtonRenderer.getState(iCurrentColumn) == 1;
        this.sortAllRowsBy(this.m_oTableModel, iCurrentColumn, bSortType);
        this.m_oSortButtonRenderer.setSelectedColumn(iCurrentColumn);
        this.refreshTable();
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        Collections.sort(data, new ColumnSorter(colIndex, ascending));
    }

    public void refreshTable() {
        if (0 == this.m_oFileInfoTable.getRowCount()) {
            this.clearSortFlag();
        } else {
            this.setDefaultSelection();
        }
        this.updateTable();
    }

    public void clearSortFlag() {
        this.m_oSortButtonRenderer.clearSortFlag();
    }

    private void setDefaultSelection() {
        if (this.m_oFileInfoTable.getRowCount() > 0) {
            this.m_oFileInfoTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SAMFileInfoTablePanel.this.m_oFileInfoTable.getTableHeader().repaint();
                SAMFileInfoTablePanel.this.m_oFileInfoTable.updateUI();
                SAMFileInfoTablePanel.this.setRefreshDateTime();
            }
        });
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        if (!(oEventObject.getSource() instanceof TreeNodeInfo) || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject)) {
            return;
        }
        this.m_oDeviceTreeSelectionEvent = (DCDeviceTreeNodeSelectionEventObject)oEventObject;
        ArrayList oFileInfoLst = null;
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)this.m_oDeviceTreeSelectionEvent.getSource();
        if (1 == this.m_oDeviceTreeSelectionEvent.getEventType()) {
            DeviceTypeInfo oDevTypeInfo = oTreeNodeInfo.getDeviceTypeInfo();
            oFileInfoLst = this.m_oSAMDataModel.getFileInfoLst(oDevTypeInfo);
        } else if (2 == this.m_oDeviceTreeSelectionEvent.getEventType()) {
            DeviceTypeInfo oDevTypeInfo = oTreeNodeInfo.getDeviceTypeInfo();
            String strDeviceVersion = oTreeNodeInfo.getVersion();
            oFileInfoLst = this.m_oSAMDataModel.getFileInfoLst(oDevTypeInfo, strDeviceVersion, null);
        } else {
            oFileInfoLst = this.m_oSAMDataModel.getFileInfoLst();
        }
        this.populateAllFileInfoFromDataModel(oFileInfoLst);
    }

    private void initializePopupMenuManager() {
        this.m_oSAMPopupMenuMgr = new SAMPopupManager(this, this.m_oFileInfoTable);
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                SAMFileInfoTablePanel.this.fileInfoTable_MousePressed(oMouseEvent);
            }
        };
    }

    private void fileInfoTable_MousePressed(MouseEvent oMouseEvent) {
        if (!oMouseEvent.isPopupTrigger() && 0 != (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        int iClickedRow = this.m_oFileInfoTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oFileInfoTable.getSelectedRows();
        if (nRows.length > 1) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected) {
            ListSelectionModel selectionModel = this.m_oFileInfoTable.getSelectionModel();
            selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        this.getMenuItems();
        this.m_oSAMPopupMenu.show(this.m_oFileInfoTable, oMouseEvent.getX(), oMouseEvent.getY());
    }

    private void getMenuItems() {
        this.m_oSAMPopupMenu = this.m_oSAMPopupMenuMgr.loadMenu();
        this.m_oSAMPopupMenu.setName("SAM_SAMFileInfoTablePanel_m_oSAMPopupMenu");
    }

    public void importFile() {
        if (TaskCommUtil.checkOtherSAMFileInfoTablePanelHasShow()) {
            return;
        }
        String strTitle = DCFrameWorkUtil.getLocalizedString("IMPORT_FILE_TITLE");
        final SAMFileInfoImportDlg oSAMFileInfoImportDlg = new SAMFileInfoImportDlg();
        oSAMFileInfoImportDlg.setTitle(strTitle);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    oSAMFileInfoImportDlg.setVisible(true);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                    oSAMFileInfoImportDlg.closeDialog();
                }
                finally {
                    TaskCommUtil.setSamFileImportShow(0);
                }
            }
        });
    }

    public void saveAsSAM() {
        ResourceManager oRes = ResourceManager.getInstance();
        String strFileName = this.oSaveAsFileUtil.getSelectFileName(oRes.getResString("SAM_INFO"));
        if (null != strFileName) {
            this.saveSAMInfo(strFileName);
        }
    }

    private void saveSAMInfo(final String sFileName) {
        final Vector oDataVct = this.getSelectedData();
        int iColumnCount = this.m_oFileInfoTable.getColumnCount();
        if (this.m_oFileInfoTable.getColumnModel().getColumn(iColumnCount - 1).getPreferredWidth() <= 0) {
            --iColumnCount;
        }
        final String[] sTableHearders = new String[--iColumnCount];
        for (int i = 0; i < iColumnCount; ++i) {
            sTableHearders[i] = this.m_oFileInfoTable.getColumnName(i + 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SAMFileInfoTablePanel.this.oSaveAsFileUtil.saveAsInFile(oDataVct, ResourceManager.getInstance().getResString("SAM_INFO"), sTableHearders, sFileName);
            }
        });
    }

    private Vector getSelectedData() {
        Vector oSelectedDataVct = new Vector();
        Vector oVectorTmp = new Vector();
        Vector<String> oVector = null;
        int[] iRows = this.m_oFileInfoTable.getSelectedRows();
        int iCurRows = this.m_oFileInfoTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iRows.length; ++i) {
            oVector = new Vector<String>();
            oVectorTmp = this.m_oTableModel.getDataVector().get(iRows[i]);
            int index = 0;
            for (int j = 1; j < iCurRows; ++j) {
                index = this.m_oFileInfoTable.getColumnModel().getColumn(j).getModelIndex();
                if (8 == index) continue;
                oVector.add(oVectorTmp.get(index).toString());
            }
            oSelectedDataVct.add(oVector);
        }
        return oSelectedDataVct;
    }

    public void updateFileInfo() {
        SAMFileInfo oSAMFileInfo = new SAMFileInfo();
        int iSelectedRow = this.m_oFileInfoTable.getSelectedRow();
        DeviceTypeInfo oDevTypeInfo = this.getDeviceType(iSelectedRow);
        oSAMFileInfo.setDeviceTypeInfo(oDevTypeInfo);
        oSAMFileInfo.setCurrentVersion(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 3)));
        oSAMFileInfo.setFileDescription(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 6)));
        oSAMFileInfo.setFileName(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 1)));
        oSAMFileInfo.setFileSize(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 5)));
        oSAMFileInfo.setFileType((ContentType)this.m_oTableModel.getValueAt(iSelectedRow, 2));
        oSAMFileInfo.setVersion(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 3)));
        oSAMFileInfo.setPatchVer(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 4)));
        oSAMFileInfo.setBDVersion(String.valueOf(this.m_oTableModel.getValueAt(iSelectedRow, 8)));
        final SAMFileInfoImportDlg oSAMFileInfoImportUpdateDlg = new SAMFileInfoImportDlg(oSAMFileInfo);
        String strTitle = DCFrameWorkUtil.getLocalizedString("UPDATE_DIALOG_TITLE");
        oSAMFileInfoImportUpdateDlg.setTitle(strTitle);
        String[] oVersionList = SAMDataModel.getInstance().getVersionLst(oDevTypeInfo);
        if (oVersionList.length > 1) {
            oSAMFileInfoImportUpdateDlg.getSAMFileImportPanel().enableUseExistingVerCheckBox(true);
        }
        new Thread(){

            @Override
            public void run() {
                oSAMFileInfoImportUpdateDlg.setVisible(true);
            }
        }.start();
    }

    public void saveFileInfo() {
        SaveAsSAMFile oSaveAsSAMFile = SaveAsSAMFile.getInstance();
        oSaveAsSAMFile.setSAMFileInfoPanel(this);
        oSaveAsSAMFile.saveSAMFile();
    }

    public void deleteFileInfo() {
        if (0 == this.m_oFileInfoTable.getModel().getRowCount()) {
            return;
        }
        this.m_iarrSelectedRow = this.m_oFileInfoTable.getSelectedRows();
        int iSelectedRowCount = this.m_iarrSelectedRow.length;
        ArrayList<ISAMFileInfo> oFileDeletionList = new ArrayList<ISAMFileInfo>(1);
        for (int index = 0; index < iSelectedRowCount; ++index) {
            oFileDeletionList.add(this.getFileInfoAtRow(this.m_iarrSelectedRow[index]));
        }
        boolean isNeedPrompt = false;
        for (int i = 0; i < oFileDeletionList.size(); ++i) {
            if (2 != ((ISAMFileInfo)oFileDeletionList.get(i)).getDeviceTypeInfo().getDevDomain() && 1 != ((ISAMFileInfo)oFileDeletionList.get(i)).getDeviceTypeInfo().getDevDomain()) continue;
            isNeedPrompt = true;
            break;
        }
        int iConfirm = -1;
        iConfirm = isNeedPrompt && !DCFrameWorkUtil.getIsSingleClient() ? DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_MODIFY_VERSION_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRMATION_DIALOG_TITLE"), 0) : DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_CONFIRM_DELETE_FILES"), DCFrameWorkUtil.getLocalizedString("CONFIRMATION_DIALOG_TITLE"), 0);
        if (iConfirm != 0) {
            return;
        }
        SAMUtil.getInstance().samFileDelete(oFileDeletionList);
    }

    public void processFileDeletionRsp(ISAMFileInfo oSAMFileInfo) {
        this.deleteFileInfoFromLocalFileLst(oSAMFileInfo);
        DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oDeviceTree.getLastSelectedPathComponent();
        this.populateTableData(oTreeNode);
    }

    private synchronized void populateTableData(DefaultMutableTreeNode oTreeNode) {
        int iLevel = oTreeNode.getLevel();
        TreeNodeInfo oNodeInfo = (TreeNodeInfo)oTreeNode.getUserObject();
        ISAMDataModel oSAMDataModel = SAMDataModel.getInstance();
        ArrayList oFileLst = new ArrayList(0);
        oFileLst = 1 == iLevel ? oSAMDataModel.getFileInfoLst(oNodeInfo.getDeviceTypeInfo()) : (2 == iLevel ? oSAMDataModel.getFileInfoLst(oNodeInfo.getDeviceTypeInfo(), oNodeInfo.getVersion(), null) : oSAMDataModel.getFileInfoLst());
        this.populateAllFileInfoFromDataModel(oFileLst);
    }

    public void deleteFileInfoFromLocalFileLst(ISAMFileInfo oSAMFileInfo) {
        ConcurrentHashMap oDevTypeMap = this.m_oSAMDataModel.getSAMDevTypeMap();
        ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)oDevTypeMap.get(oSAMFileInfo.getDeviceTypeInfo());
        if (null == oDevVersionMap) {
            return;
        }
        ArrayList oFileInfoLst = (ArrayList)oDevVersionMap.get(oSAMFileInfo.getVersion());
        if (null == oFileInfoLst) {
            return;
        }
        int iFileCount = oFileInfoLst.size();
        for (int index = 0; index < iFileCount; ++index) {
            SAMFileInfo oFileInfo = (SAMFileInfo)oFileInfoLst.get(index);
            if (!oFileInfo.equals(oSAMFileInfo)) continue;
            oFileInfoLst.remove(oSAMFileInfo);
            break;
        }
        DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oSelectedTreeNode = (DefaultMutableTreeNode)oDeviceTree.getLastSelectedPathComponent();
        DefaultMutableTreeNode oRootNode = oDeviceTree.getRoot();
        DefaultMutableTreeNode oDevTypeNode = SAMFileInfoTablePanelHelper.getTreeNode(oRootNode, oSAMFileInfo.getDeviceTypeInfo().toString());
        DefaultMutableTreeNode oDevVersionNode = SAMFileInfoTablePanelHelper.getTreeNode(oDevTypeNode, oSAMFileInfo.getVersion());
        int iLevel = oSelectedTreeNode.getLevel();
        if (0 == oFileInfoLst.size()) {
            if (2 == iLevel && oSelectedTreeNode.equals(oDevVersionNode)) {
                this.selectDeviceTypeNode(oSAMFileInfo.getDeviceTypeInfo());
            }
            this.deleteVersionNodeFromSAMDeviceTree(oSAMFileInfo.getVersion(), oSAMFileInfo.getDeviceTypeInfo());
            oDevVersionMap.remove(oSAMFileInfo.getVersion());
            if (0 == oDevVersionMap.size()) {
                oDevTypeMap.remove(oSAMFileInfo.getDeviceTypeInfo());
                this.deleteDevTypeNodeFromSAMDeviceTree(oSAMFileInfo.getDeviceTypeInfo());
            }
        }
    }

    private void deleteDevTypeNodeFromSAMDeviceTree(DeviceTypeInfo oDevTypeInfo) {
        DeviceTree oSAMDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oRootNode = oSAMDeviceTree.getRoot();
        DefaultMutableTreeNode oDeviceTypeNode = SAMFileInfoTablePanelHelper.getTreeNode(oRootNode, oDevTypeInfo.toString());
        if (null != oDeviceTypeNode) {
            oRootNode.remove(oDeviceTypeNode);
        }
        DCFrameWorkUtil.updateUI(oSAMDeviceTree);
    }

    public DeviceTypeInfo getDeviceType(int iSelectedRow) {
        return (DeviceTypeInfo)this.m_oTableModel.getValueAt(iSelectedRow, 7);
    }

    public String getDeviceVersion(int iSelectedRow) {
        return (String)this.m_oTableModel.getValueAt(iSelectedRow, 3);
    }

    public void selectRootNode() {
        try {
            final DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
            DefaultMutableTreeNode oRootTreeNode = oDeviceTree.getRoot();
            TreePath oTreepath = new TreePath(oRootTreeNode.getPath());
            oDeviceTree.setSelectionPath(oTreepath);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDeviceTree.repaint();
                }
            });
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return;
        }
    }

    public void selectDeviceTypeNode(DeviceTypeInfo oDeviceTypeInfo) {
        final DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oRootTreeNode = oDeviceTree.getRoot();
        int iDeviceTypesCount = oRootTreeNode.getChildCount();
        Collator oEquals = Collator.getInstance();
        for (int i = 0; i < iDeviceTypesCount; ++i) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oRootTreeNode.getChildAt(i);
            if (!oEquals.equals(oTreeNode.toString(), oDeviceTypeInfo.toString())) continue;
            try {
                TreePath oTreePath = new TreePath(oTreeNode.getPath());
                oDeviceTree.setSelectionPath(oTreePath);
                oDeviceTree.scrollPathToVisible(oTreePath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        oDeviceTree.repaint();
                    }
                });
                continue;
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                return;
            }
        }
    }

    public void selectDeviceTypeNode(DeviceTypeInfo oDeviceTypeInfo, String strVersion) {
        final DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oRootTreeNode = oDeviceTree.getRoot();
        int iDeviceTypesCount = oRootTreeNode.getChildCount();
        Collator oEquals = Collator.getInstance();
        for (int i = 0; i < iDeviceTypesCount; ++i) {
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oRootTreeNode.getChildAt(i);
            if (!oEquals.equals(oTreeNode.toString(), oDeviceTypeInfo.toString())) continue;
            int iVersionCount = oTreeNode.getChildCount();
            for (int j = 0; j < iVersionCount; ++j) {
                DefaultMutableTreeNode oVerTreeNode = (DefaultMutableTreeNode)oTreeNode.getChildAt(j);
                if (!oEquals.equals(oVerTreeNode.toString(), strVersion)) continue;
                try {
                    TreePath oVerTreePath = new TreePath(oVerTreeNode.getPath());
                    oDeviceTree.setSelectionPath(oVerTreePath);
                    oDeviceTree.scrollPathToVisible(oVerTreePath);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            oDeviceTree.repaint();
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                    return;
                }
            }
        }
    }

    public TableModel getTableModel() {
        return this.m_oTableModel;
    }

    public JTable getTable() {
        return this.m_oFileInfoTable;
    }

    public void showRow(int iRow) {
        this.m_oFileInfoScrollPane.validate();
        JScrollBar vScroll = this.m_oFileInfoScrollPane.getVerticalScrollBar();
        vScroll.setValue(DCGUIUtil.calculateScrollValue(iRow, vScroll.getMaximum(), this.m_oFileInfoTable.getRowCount()));
        DCFrameWorkUtil.updateUI(vScroll);
        DCFrameWorkUtil.updateUI(this.m_oFileInfoScrollPane);
    }

    public void deleteVersionNodeFromSAMDeviceTree(String strVersion, DeviceTypeInfo oDevTypeInfo) {
        DeviceTree oSAMDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oRootNode = oSAMDeviceTree.getRoot();
        DefaultMutableTreeNode oDeviceTypeNode = SAMFileInfoTablePanelHelper.getTreeNode(oRootNode, oDevTypeInfo.toString());
        DefaultMutableTreeNode oDevVersion = SAMFileInfoTablePanelHelper.getTreeNode(oDeviceTypeNode, strVersion);
        if (null != oDevVersion) {
            oDeviceTypeNode.remove(oDevVersion);
        }
        DCFrameWorkUtil.updateUI(oSAMDeviceTree);
    }

    private void addListenerForSAMFileChange() {
        SAMChangeEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    public void breakPacketFiles() {
        int[] iarrSelectedRow = this.m_oFileInfoTable.getSelectedRows();
        ArrayList<ISAMFileInfo> oFileList = new ArrayList<ISAMFileInfo>(1);
        for (int index = 0; index < iarrSelectedRow.length; ++index) {
            oFileList.add(this.getFileInfoAtRow(iarrSelectedRow[index]));
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        SAMOperationProgressDlg oProgressDlg = new SAMOperationProgressDlg(oFileList, 43973);
        oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("BREAK_PACKET_PROGRESS_DLG_TITLE"));
        oProgressDlg.setProgressDlgId(iReqId);
        oProgressDlg.initResultTable();
        try {
            this.m_oSAMManager.breakPacketFiles(iReqId, oFileList);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        oProgressDlg.setVisible(true);
    }

    public ISAMFileInfo getFileInfoAtRow(int iRowIndex) {
        String strFileName = this.m_oFileInfoTable.getModel().getValueAt(iRowIndex, 1).toString();
        String strVersion = this.m_oFileInfoTable.getModel().getValueAt(iRowIndex, 3).toString();
        String strPatchVersion = this.m_oFileInfoTable.getModel().getValueAt(iRowIndex, 4).toString();
        DeviceTypeInfo oDevTypeInfo = this.getDeviceType(iRowIndex);
        ContentType oContentType = (ContentType)this.m_oFileInfoTable.getModel().getValueAt(iRowIndex, 2);
        return SAMDataModel.getInstance().getSAMFileInfo(oDevTypeInfo, strVersion, strPatchVersion, oContentType, strFileName);
    }

    @Override
    public void onSAMEvent(SAMEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        switch (oEvent.getEventType()) {
            case 0: {
                this.updateTable();
                break;
            }
            case 1: {
                if (!(oEvent.getSource() instanceof SAMFileInfo)) break;
                SAMFileInfo oFileInfo = (SAMFileInfo)oEvent.getSource();
                if (0 != oEvent.getErrorCode()) break;
                this.processFileDeletionRsp(oFileInfo);
                break;
            }
        }
    }

    public void disposePanel() {
        SAMChangeEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel()) {
            this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().removeDCEventListener(this);
        }
        this.m_oSAMManager.removeSAMEventListener(this);
        this.m_oDeviceTreeSelectionEvent = null;
        this.m_oSAMManager = null;
        if (null != this.m_oFileInfoTable) {
            this.m_oFileInfoTable.removeAll();
        }
        if (null != this.m_oSAMPopupMenuMgr) {
            this.m_oSAMPopupMenuMgr.cleanUp();
            this.m_oSAMPopupMenuMgr = null;
        }
        this.m_oSAMDataModel = null;
    }

    public SoftwareArchiveMgmtPanel getSoftwareArchiveMgmtPanel() {
        return this.m_oSoftwareArchiveMgmtPanel;
    }

    @Override
    public void handleDeleteSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        DCDebugTracer.trace("SelectTimeAndVersionPanel Method handleDeleteSAMFileNotification srart");
        DCDebugTracer.trace("asnSAMFileInfoLst");
        this.changeButtonStatus();
        DCDebugTracer.trace("Method handleDeleteSAMFileNotification end..");
    }

    @Override
    public void handleImportSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        DCDebugTracer.trace("SAMFileInfoTablePanel Method handleImportSAMFileNotification srart");
        DCDebugTracer.trace("SAMFileInfoTablePanel asnSAMFileInfoLst");
        ArrayList<DeviceTypeInfo> devTypeInfoLst = new ArrayList<DeviceTypeInfo>(0);
        this.addSAMFileListToLocal(asnSAMFileInfoLst, devTypeInfoLst);
        this.refreshByDevTypeLst(devTypeInfoLst);
        this.changeButtonStatus();
        DCDebugTracer.trace("SAMFileInfoTablePanel Method handleImportSAMFileNotification end..");
    }

    @Override
    public void handleUpdateSAMFileNotification(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst) {
        DCDebugTracer.trace("SAMFileInfoTablePanel Method handleUpdateSAMFileNotification srart");
        ArrayList<DeviceTypeInfo> devTypeInfoLst = new ArrayList<DeviceTypeInfo>(0);
        this.deleteSAMFileListFromLocal(asnSAMFileInfoLst, devTypeInfoLst, 2);
        this.addSAMFileListToLocal(asnSAMFileInfoLst, devTypeInfoLst);
        this.refreshByDevTypeLst(devTypeInfoLst);
        this.changeButtonStatus();
        DCDebugTracer.trace("SAMFileInfoTablePanel Method handleUpdateSAMFileNotification end..");
    }

    private void deleteSAMFileListFromLocal(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst, List<DeviceTypeInfo> devTypeInfoLst, int type) {
        DCDebugTracer.trace("Method deleteSAMFileListFromLocal srart");
        if (devTypeInfoLst == null || asnSAMFileInfoLst == null) {
            DCDebugTracer.trace("devTypeInfoLst or asnSAMFileInfoLst is null");
            return;
        }
        devTypeInfoLst.clear();
        int iFileType = -1;
        for (AsnSAMFileUpdateInfo oAsnSAMFileUpdateInfo : asnSAMFileInfoLst) {
            String strDevVersion = new String(oAsnSAMFileUpdateInfo.strDevVersion);
            ArrayList<SAMFileInfo> oSAMFileInfoList = new ArrayList<SAMFileInfo>(0);
            this.converAsnSAMFileInfoToSAMFileInfo(oAsnSAMFileUpdateInfo, oSAMFileInfoList, type);
            SAMFileInfo oSAMFileInfo = null;
            for (int i = 0; i < oSAMFileInfoList.size(); ++i) {
                oSAMFileInfo = oSAMFileInfoList.get(i);
                devTypeInfoLst.add(oSAMFileInfo.getDeviceTypeInfo());
                ContentType contentType = oSAMFileInfo.getFileType();
                if (null != contentType) {
                    iFileType = contentType.getContentTypeCode();
                }
                this.deleteFileInfoFromLocalFileLst(iFileType, strDevVersion, oSAMFileInfo);
            }
        }
        DCDebugTracer.trace("Method deleteSAMFileListFromLocal end..");
    }

    private void refreshByDevTypeLst(List<DeviceTypeInfo> devTypeInfoLst) {
        DCDebugTracer.trace("Method refreshByDevTypeLst srart");
        if (devTypeInfoLst == null || devTypeInfoLst.isEmpty() || null == this.m_oSAMManager) {
            DCDebugTracer.trace("devTypeInfoLst is null or devTypeInfoLst is empty or m_oSAMManager is null");
            return;
        }
        ConcurrentHashMap oDevTypeMap = this.m_oSAMManager.getDataModel().getSAMDevTypeMap();
        if (oDevTypeMap == null) {
            this.populateAllFileInfoFromDataModel(null);
            DCDebugTracer.trace("oDevTypeMap is null");
            return;
        }
        Set oAllDevTypeSet = oDevTypeMap.keySet();
        if (oAllDevTypeSet.isEmpty()) {
            this.populateAllFileInfoFromDataModel(null);
            DCDebugTracer.trace("oAllDevTypeSet isEmpty");
            return;
        }
        for (DeviceTypeInfo deviceTypeInfo : oAllDevTypeSet) {
            if (!devTypeInfoLst.contains(deviceTypeInfo)) continue;
            ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)oDevTypeMap.get(deviceTypeInfo);
            Set strVerSet = oDevVersionMap.keySet();
            for (String strVersion : strVerSet) {
                if (null == this.m_oVersrionLst || !this.m_oVersrionLst.contains(strVersion)) continue;
                this.refreshSAMTreeByDeviceType(deviceTypeInfo, strVersion);
                this.refreshSAMTableByDeviceType(deviceTypeInfo, strVersion);
            }
        }
        DCDebugTracer.trace("Method refreshByDevTypeLst end..");
    }

    public void refreshSAMTableData() {
        DeviceTree oDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oDeviceTree.getLastSelectedPathComponent();
        this.populateTableData(oTreeNode);
    }

    private synchronized void converAsnSAMFileInfoToSAMFileInfo(AsnSAMFileUpdateInfo oAsnSAMFileInfo, ArrayList<SAMFileInfo> oSAMFileInfoList, int operationType) {
        DCDebugTracer.trace("Method converAsnSAMFileInfoToSAMFileInfo srart");
        if (oAsnSAMFileInfo == null || oSAMFileInfoList == null) {
            DCDebugTracer.trace("Method converAsnSAMFileInfoToSAMFileInfo end..");
            return;
        }
        this.clearVersionLst();
        int iSize = oAsnSAMFileInfo.oDevTypeIdInfoList.size();
        AbstractDeviceInfoManager deviceInfoManager = (AbstractDeviceInfoManager)DCFrameWorkUtil.getDeviceInfoManager();
        SAMFileInfo oSAMFileInfo = null;
        AsnDevTypeIdInfo oAsnDevTypeIdInfo = null;
        DeviceTypeInfo typeInfo = null;
        ContentType oContentType = null;
        String patchVer = null;
        for (int i = 0; i < iSize; ++i) {
            oSAMFileInfo = new SAMFileInfo();
            oAsnDevTypeIdInfo = (AsnDevTypeIdInfo)oAsnSAMFileInfo.oDevTypeIdInfoList.get(i);
            int iDevTypeId = oAsnDevTypeIdInfo.iDevTypeId.intValue();
            int iDevTypeVersionId = oAsnDevTypeIdInfo.iDevTypeVerId.intValue();
            typeInfo = deviceInfoManager.getDeviceTypeInfo(iDevTypeId, iDevTypeVersionId);
            oSAMFileInfo.setDeviceTypeInfo(typeInfo);
            DCDebugTracer.trace("SAMFileInfoTablePanel:typeInfo:" + typeInfo);
            if (operationType == 1 || operationType == 0) {
                oContentType = SAMUtil.getFileTypeObj(typeInfo, oAsnSAMFileInfo.oFileInfo.iFileType.intValue());
                if (null == oContentType) {
                    oContentType = new ContentType(oAsnSAMFileInfo.oFileInfo.iFileType.intValue(), oAsnSAMFileInfo.oFileInfo.iFileType.toString());
                }
                oSAMFileInfo.setFileType(oContentType);
                oSAMFileInfo.setFileName(new String(oAsnSAMFileInfo.oFileInfo.strFileName));
                oSAMFileInfo.setFileSize(new String(oAsnSAMFileInfo.oFileInfo.strSize));
                oSAMFileInfo.setFileDescription(new String(oAsnSAMFileInfo.oFileInfo.strDescription));
                oSAMFileInfo.setVersion(new String(oAsnSAMFileInfo.oFileInfo.strVersion));
                patchVer = null != oAsnSAMFileInfo.oFileInfo.strPatchVersion ? new String(oAsnSAMFileInfo.oFileInfo.strPatchVersion) : "";
                oSAMFileInfo.setPatchVer(patchVer);
                oSAMFileInfo.setBDVersion(new String(oAsnSAMFileInfo.oFileInfo.strBDVersion));
            } else {
                oContentType = SAMUtil.getFileTypeObj(typeInfo, oAsnSAMFileInfo.oOldFileInfo.iFileType.intValue());
                if (null == oContentType) {
                    oContentType = new ContentType(oAsnSAMFileInfo.oOldFileInfo.iFileType.intValue(), oAsnSAMFileInfo.oOldFileInfo.iFileType.toString());
                }
                oSAMFileInfo.setFileType(oContentType);
                oSAMFileInfo.setFileName(new String(oAsnSAMFileInfo.oOldFileInfo.strFileName));
                oSAMFileInfo.setFileSize(String.valueOf(oAsnSAMFileInfo.oOldFileInfo.strSize));
                oSAMFileInfo.setFileDescription(new String(oAsnSAMFileInfo.oOldFileInfo.strDescription));
                oSAMFileInfo.setVersion(new String(oAsnSAMFileInfo.oOldFileInfo.strVersion));
                oSAMFileInfo.setBDVersion(new String(oAsnSAMFileInfo.oOldFileInfo.strBDVersion));
            }
            this.addVersion(oSAMFileInfo.getVersion());
            oSAMFileInfoList.add(oSAMFileInfo);
        }
        DCDebugTracer.trace("Method converAsnSAMFileInfoToSAMFileInfo end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVersion(String sVersion) {
        char[] cArray = this.m_oSynVersrionLst;
        synchronized (this.m_oSynVersrionLst) {
            this.m_oVersrionLst.add(sVersion);
            DCDebugTracer.trace("add version " + sVersion);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearVersionLst() {
        char[] cArray = this.m_oSynVersrionLst;
        synchronized (this.m_oSynVersrionLst) {
            this.m_oVersrionLst.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void deleteFileInfoFromLocalFileLst(int iFileType, String strDevVersion, SAMFileInfo oSAMFileInfo) {
        DCDebugTracer.trace("Method deleteFileInfoFromLocalFileLst srart");
        DCDebugTracer.trace("delete strDevVersion : " + strDevVersion);
        try {
            String strVersion = strDevVersion;
            DeviceTypeInfo oDeviceTypeInfo = oSAMFileInfo.getDeviceTypeInfo();
            if (this.m_oSAMManager == null) {
                DCDebugTracer.trace("m_oSAMManager is empty!");
                return;
            }
            if (this.m_oSAMManager.getDataModel() == null) {
                DCDebugTracer.trace("m_oSAMManager.getDataModel() is empty!");
                return;
            }
            ConcurrentHashMap oDevTypeMap = this.m_oSAMManager.getDataModel().getSAMDevTypeMap();
            if (oDevTypeMap == null) {
                DCDebugTracer.trace("Method deleteFileInfoFromLocalFileLst end..");
                return;
            }
            ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)oDevTypeMap.get(oDeviceTypeInfo);
            if (oDevVersionMap == null) {
                DCDebugTracer.trace("Method deleteFileInfoFromLocalFileLst end..");
                return;
            }
            ArrayList oFileInfoLst = (ArrayList)oDevVersionMap.get(strVersion);
            if (null == oFileInfoLst) {
                DCDebugTracer.trace("Method deleteFileInfoFromLocalFileLst end..");
                return;
            }
            Iterator iterator = oFileInfoLst.iterator();
            while (iterator.hasNext()) {
                SAMFileInfo oTmpSAMFileInfo = (SAMFileInfo)iterator.next();
                if (!oTmpSAMFileInfo.equals(oSAMFileInfo)) continue;
                iterator.remove();
                break;
            }
            if (oFileInfoLst.isEmpty()) {
                oDevVersionMap.remove(strVersion);
                this.deleteVersionNodeFromSAMDeviceTree(strVersion, oDeviceTypeInfo);
                if (oDevVersionMap.isEmpty()) {
                    this.selectRootNode();
                    oDevTypeMap.remove(oDeviceTypeInfo);
                    this.deleteDevTypeNodeFromSAMDeviceTree(oDeviceTypeInfo);
                }
            }
        }
        catch (Exception e) {
            return;
        }
        DCDebugTracer.trace("Method deleteFileInfoFromLocalFileLst end..");
    }

    private void refreshSAMTreeByDeviceType(DeviceTypeInfo oDeviceTypeInfo, String strVersion) {
        DCDebugTracer.trace("Method refreshSAMTreeByDeviceType srart");
        if (oDeviceTypeInfo == null || strVersion == null) {
            DCDebugTracer.trace("oDeviceTypeInfo or strVersion in null");
            return;
        }
        DCDebugTracer.trace("oDeviceTypeInfo :" + oDeviceTypeInfo + " version=" + strVersion);
        DeviceTree m_oSAMDeviceTree = this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel().getDeviceTree();
        DefaultMutableTreeNode oRootNode = m_oSAMDeviceTree.getRoot();
        DefaultMutableTreeNode oDeviceTypeNode = this.getDeviceTypeNode(oRootNode, oDeviceTypeInfo.toString());
        if (null == oDeviceTypeNode) {
            DCDebugTracer.trace("oDeviceTypeNode is null");
            TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(oDeviceTypeInfo);
            oDeviceTypeNode = new DefaultMutableTreeNode();
            oDeviceTypeNode.setUserObject(oTreeNodeInfo);
            oRootNode.add(oDeviceTypeNode);
        }
        boolean bisDevVersionNodeExist = false;
        DefaultMutableTreeNode oDevVersionNode = null;
        int iDevVersionCount = oDeviceTypeNode.getChildCount();
        for (int index = 0; index < iDevVersionCount; ++index) {
            oDevVersionNode = (DefaultMutableTreeNode)oDeviceTypeNode.getChildAt(index);
            if (!oDevVersionNode.toString().equals(strVersion)) continue;
            bisDevVersionNodeExist = true;
            break;
        }
        TreePath oTreePath = null;
        if (!bisDevVersionNodeExist) {
            DCDebugTracer.trace("add tree version node");
            try {
                DefaultMutableTreeNode oDeviceVersionNode = new DefaultMutableTreeNode();
                TreeNodeInfo oTreeNodeInfo = new TreeNodeInfo(strVersion, oDeviceTypeInfo);
                oDeviceVersionNode.setUserObject(oTreeNodeInfo);
                oDeviceTypeNode.add(oDeviceVersionNode);
                oTreePath = new TreePath(oDeviceVersionNode.getPath());
                this.expandTargetPath(m_oSAMDeviceTree, oTreePath);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                return;
            }
        }
        try {
            if (null != oDevVersionNode) {
                oTreePath = new TreePath(oDevVersionNode.getPath());
                this.expandTargetPath(m_oSAMDeviceTree, oTreePath);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return;
        }
        DCDebugTracer.trace("Method refreshSAMTreeByDeviceType end..");
    }

    private void expandTargetPath(final DeviceTree m_oSAMDeviceTree, TreePath oTreePath) {
        m_oSAMDeviceTree.setSelectionPath(oTreePath);
        m_oSAMDeviceTree.scrollPathToVisible(oTreePath);
        m_oSAMDeviceTree.expandPath(oTreePath);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                m_oSAMDeviceTree.updateUI();
                m_oSAMDeviceTree.repaint();
            }
        });
    }

    public void refreshSAMTableByDeviceType(DeviceTypeInfo oDeviceTypeInfo, String strVersion) {
        DCDebugTracer.trace("Method refreshSAMTableByDeviceType srart");
        if (oDeviceTypeInfo == null || strVersion == null) {
            DCDebugTracer.trace("oDeviceTypeInfo or strVersion is null");
            return;
        }
        ISAMDataModel oSAMDataModel = this.m_oSAMManager.getDataModel();
        ArrayList oFileInfoLst = oSAMDataModel.getFileInfoLst(oDeviceTypeInfo, strVersion, null);
        this.populateAllFileInfoFromDataModel(oFileInfoLst);
    }

    public DefaultMutableTreeNode getDeviceTypeNode(DefaultMutableTreeNode oRootNode, String strDevType) {
        DCDebugTracer.trace("Method getDeviceTypeNode srart");
        DCDebugTracer.trace("strDevType : " + strDevType);
        DefaultMutableTreeNode oDevTypeNode = null;
        boolean bNodePresent = false;
        int iDevTypeCount = oRootNode.getChildCount();
        for (int index = 0; index < iDevTypeCount; ++index) {
            oDevTypeNode = (DefaultMutableTreeNode)oRootNode.getChildAt(index);
            if (!oDevTypeNode.toString().equals(strDevType)) continue;
            bNodePresent = true;
            break;
        }
        if (!bNodePresent) {
            DCDebugTracer.trace("Method getDeviceTypeNode is null");
            return null;
        }
        DCDebugTracer.trace("Method getDeviceTypeNode end..");
        return oDevTypeNode;
    }

    private void addSAMFileListToLocal(AsnSAMFileUpdateInfoLst asnSAMFileInfoLst, List<DeviceTypeInfo> devTypeInfoLst) {
        DCDebugTracer.trace("Method addSAMFileListToLocal srart");
        if (devTypeInfoLst == null || asnSAMFileInfoLst == null) {
            DCDebugTracer.trace("devTypeInfoLst or asnSAMFileInfoLst is null");
            return;
        }
        devTypeInfoLst.clear();
        Iterator iterator = asnSAMFileInfoLst.iterator();
        AsnSAMFileUpdateInfo oAsnSAMFileUpdateInfo = null;
        ArrayList<SAMFileInfo> oSAMFileInfoList = null;
        SAMFileInfo oSAMFileInfo = null;
        while (iterator.hasNext()) {
            oAsnSAMFileUpdateInfo = (AsnSAMFileUpdateInfo)iterator.next();
            oSAMFileInfoList = new ArrayList<SAMFileInfo>(0);
            this.converAsnSAMFileInfoToSAMFileInfo(oAsnSAMFileUpdateInfo, oSAMFileInfoList, 0);
            for (int i = 0; i < oSAMFileInfoList.size(); ++i) {
                oSAMFileInfo = oSAMFileInfoList.get(i);
                devTypeInfoLst.add(oSAMFileInfo.getDeviceTypeInfo());
                if (this.m_oSAMManager == null) continue;
                this.m_oSAMManager.addSAMFileInfoToDataModel(oSAMFileInfo);
            }
        }
        DCDebugTracer.trace("Method addSAMFileListToLocal end..");
    }

    public DeviceTreePanel getDeviceTreePanel() {
        return this.m_oSoftwareArchiveMgmtPanel.getSAMDeviceTreePanel();
    }

    public void updateFileInfoTable(DeviceTypeInfo oDeviceTypeInfo, ISAMFileInfo oSAMFileInfo) {
        ISAMDataModel oSAMDataModel = SAMDataModel.getInstance();
        ArrayList oFileInfoLst = oSAMDataModel.getFileInfoLst(oDeviceTypeInfo, oSAMFileInfo.getVersion(), null);
        this.populateAllFileInfoFromDataModel(oFileInfoLst);
    }

    public void setRefreshDateTime() {
        this.strdate = DeviceTableUtil.getCurDateTimeStr();
        this.refreshSelectedSoftLabel();
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (SAMFileInfoTablePanel.this.m_ButtonPane != null) {
                SAMFileInfoTablePanel.this.changeButtonStatus();
            }
        }
    }
}

