/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.asndatacenter.AsnDevTypeFileInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetFileDetailsRsp;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.OperationResultDlg;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class SAMFileInfoImportPanelHelper {
    public static void displayMessage(List<String> oFileNameLst) {
        int iNosFiles = oFileNameLst.size();
        final StringBuffer strFileNameBuffer = new StringBuffer();
        for (int fileIndex = 0; fileIndex < iNosFiles; ++fileIndex) {
            strFileNameBuffer.append(oFileNameLst.get(fileIndex));
            strFileNameBuffer.append("\n");
        }
        Thread oDisplayMsgThread = new Thread(new Runnable(){

            @Override
            public void run() {
                OperationResultDlg operationResultDialog = new OperationResultDlg((Component)DCFrameWorkUtil.getMainFrame(), true);
                operationResultDialog.setTitle(DCFrameWorkUtil.getLocalizedString("ERROR"));
                operationResultDialog.setDisplayInfo(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_FILE_NOT_FOUND"), DCFrameWorkUtil.getLocalizedString(strFileNameBuffer.toString()));
            }
        });
        oDisplayMsgThread.start();
    }

    public static String extractPath(String strFilePath) {
        File oFile = new File(strFilePath);
        return oFile.getParent();
    }

    public static void showErrorForSoftwareCheck(AsnSAMGetFileDetailsRsp oFileDetailsRsp) {
        String strTitle = DCFrameWorkUtil.getLocalizedString("ERROR");
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("SAM_CHECK_SW_ERROR_DLG_DEV_TYPE_COLUMN_HEADING"), DCFrameWorkUtil.getLocalizedString("SAM_CHECK_SW_ERROR_DLG_FILE_COLUMN_HEADING")};
        final TaskOperationResultDialog oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
        oOpResultDlg.setMessage(ErrorCodeReader.getInstance().getErrorDesc(oFileDetailsRsp.oErrorInfo.iErrorNo));
        int iSize = oFileDetailsRsp.oAsnDevTypeFileInfoList.size();
        AsnDevTypeFileInfo oAsnDevTypeFileInfo = null;
        AsnDevTypeIdInfo oAsnDevTypeIdInfo = null;
        String strFileName = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnDevTypeFileInfo = (AsnDevTypeFileInfo)oFileDetailsRsp.oAsnDevTypeFileInfoList.get(i);
            strFileName = new String(oAsnDevTypeFileInfo.strFileName);
            int iDevTypeSize = oAsnDevTypeFileInfo.oAsnDevTypeIdInfoList.size();
            for (int j = 0; j < iDevTypeSize; ++j) {
                oAsnDevTypeIdInfo = (AsnDevTypeIdInfo)oAsnDevTypeFileInfo.oAsnDevTypeIdInfoList.get(j);
                int iDevTypeID = oAsnDevTypeIdInfo.iDevTypeId.intValue();
                int iDevTypeVerID = oAsnDevTypeIdInfo.iDevTypeVerId.intValue();
                oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
                oOpResultDlg.addRowInModel(oDeviceTypeInfo.toString(), strFileName);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oOpResultDlg.setVisible(true);
            }
        });
    }

    public static boolean isNameValid(String strName) {
        String[] strIllegalCharArr = new String[]{":", "/", "\"", "<", ">", "|", "?", "*", "\\", "%", "[", "]", "'", " ", "_"};
        for (int i = 0; i < strIllegalCharArr.length; ++i) {
            if (strName.indexOf(strIllegalCharArr[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static List getContentTypesFromXMLConfig(DeviceTypeInfo oDeviceTypeInfo, int iOperationID, boolean isTelnet) {
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, null);
        if (null != deviceTypeConfigModel) {
            int iOpID = 26 == iOperationID ? 5 : 1;
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(iOpID, iOperationID);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (null != arrParaVals) {
                oContTypeLst = Arrays.asList(arrParaVals);
            }
        }
        return oContTypeLst;
    }

    public static String getCorrectDevTypeVer(DeviceTypeInfo oDeviceTypeInfo, boolean isTelnet) {
        String strDevTypeVersion = oDeviceTypeInfo.getDevTypeVersionName();
        if (isTelnet && oDeviceTypeInfo.isDMSDomain() && !strDevTypeVersion.endsWith("_telnet")) {
            strDevTypeVersion = strDevTypeVersion + "_telnet";
        }
        return strDevTypeVersion;
    }

    public static void deleteDBUpdateFileInfoFrmLocalFileList(ISAMFileInfo oSAMFileInfo) {
        ConcurrentHashMap oDevTypeMap = SAMDataModel.getInstance().getSAMDevTypeMap();
        ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)oDevTypeMap.get(oSAMFileInfo.getDeviceTypeInfo());
        if (null == oDevVersionMap) {
            return;
        }
        ArrayList oFileInfoLst = (ArrayList)oDevVersionMap.get(oSAMFileInfo.getVersion());
        if (null == oFileInfoLst) {
            return;
        }
        int iFileCount = oFileInfoLst.size();
        for (int index = 0; index < iFileCount; ++index) {
            SAMFileInfo oFileInfo = (SAMFileInfo)oFileInfoLst.get(index);
            if (!oFileInfo.getFileType().equals(oSAMFileInfo.getFileType())) continue;
            oSAMFileInfo.setFileName(oFileInfo.getFileName());
            oFileInfoLst.remove(oSAMFileInfo);
            break;
        }
        if (0 == oFileInfoLst.size()) {
            oDevVersionMap.remove(oSAMFileInfo.getVersion());
            if (0 == oDevVersionMap.size()) {
                oDevTypeMap.remove(oSAMFileInfo.getDeviceTypeInfo());
            }
        }
    }

    public static void deleteFileInfoFromLocalFileLst(ISAMFileInfo oSAMFileInfo) {
        ConcurrentHashMap oDevTypeMap = SAMDataModel.getInstance().getSAMDevTypeMap();
        ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)oDevTypeMap.get(oSAMFileInfo.getDeviceTypeInfo());
        if (null == oDevVersionMap) {
            return;
        }
        ArrayList oFileInfoLst = (ArrayList)oDevVersionMap.get(oSAMFileInfo.getVersion());
        if (null == oFileInfoLst) {
            return;
        }
        int iFileCount = oFileInfoLst.size();
        for (int index = 0; index < iFileCount; ++index) {
            SAMFileInfo oFileInfo = (SAMFileInfo)oFileInfoLst.get(index);
            if (!oFileInfo.equals(oSAMFileInfo)) continue;
            oFileInfoLst.remove(oSAMFileInfo);
            break;
        }
        if (0 == oFileInfoLst.size()) {
            oDevVersionMap.remove(oSAMFileInfo.getVersion());
            if (0 == oDevVersionMap.size()) {
                oDevTypeMap.remove(oSAMFileInfo.getDeviceTypeInfo());
            }
        }
    }

    public static DefaultMutableTreeNode getDeviceTypeNode(DefaultMutableTreeNode oRootNode, String strDevType) {
        DefaultMutableTreeNode oDevTypeNode = null;
        boolean bNodePresent = false;
        int iDevTypeCount = oRootNode.getChildCount();
        for (int index = 0; index < iDevTypeCount; ++index) {
            oDevTypeNode = (DefaultMutableTreeNode)oRootNode.getChildAt(index);
            if (!oDevTypeNode.toString().equals(strDevType)) continue;
            bNodePresent = true;
            break;
        }
        if (!bNodePresent) {
            return null;
        }
        return oDevTypeNode;
    }

    public static boolean isDeviceVersionNodeExists(DefaultMutableTreeNode oDeviceTypeNode, String strVersion) {
        DefaultMutableTreeNode oDevVersionNode = null;
        boolean isDevVersionExist = false;
        int iDevVersionCount = oDeviceTypeNode.getChildCount();
        for (int index = 0; index < iDevVersionCount; ++index) {
            oDevVersionNode = (DefaultMutableTreeNode)oDeviceTypeNode.getChildAt(index);
            if (!oDevVersionNode.toString().equals(strVersion)) continue;
            isDevVersionExist = true;
            break;
        }
        return isDevVersionExist;
    }

    public static boolean isImportWholeVersionSupported(DeviceTypeInfo oDeviceTypeInfo, boolean isTelnet) {
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, null);
        if (null == deviceTypeConfigModel) {
            return false;
        }
        IOtherOperation oOperationObj = (IOtherOperation)deviceTypeConfigModel.getOperationObj(5, 25);
        if (null == oOperationObj) {
            return false;
        }
        return oOperationObj.isSupported();
    }

    public static boolean isNameValidFileName(String strName) {
        String[] strIllegalCharArr = new String[]{":", "/", "\"", "<", ">", "|", "?", "*", "\\", "%", "[", "]", "'", " "};
        for (int i = 0; i < strIllegalCharArr.length; ++i) {
            if (strName.indexOf(strIllegalCharArr[i]) == -1) continue;
            return false;
        }
        return true;
    }
}

