/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnFileInfo;
import com.huawei.dc.common.asndatacenter.AsnFileLst;
import com.huawei.dc.common.asndatacenter.AsnImportModeEnum;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMFileModifyRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetFileDetailsRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMImportFileReq;
import com.huawei.dc.common.asndatacenter.AsnSAMImportFileRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMT2000FileLst;
import com.huawei.dc.common.components.dialog.IBrowseDlgInterafce;
import com.huawei.dc.common.components.dialog.fileselection.FileSelectionBrowseDlg;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeNameInfo;
import com.huawei.dc.deviceinfo.DeviceTypeVersionInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.DevOpObjectStore;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.sam.SAMFileTransHandler;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.AbstractSAMFileInfoImportPanel;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.sam.view.SAMFileInfoImportPanelHelper;
import com.huawei.dc.sam.view.SAMFileInfoTreePanel;
import com.huawei.dc.sam.view.SAMFileSelectBrowseDlg;
import com.huawei.dc.sam.view.SAMImportTreeNodeInfo;
import com.huawei.dc.sam.view.SoftwareArchiveMgmtPanel;
import com.swimap.iview.util.DebugTracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class SAMFileInfoImportPanel
extends AbstractSAMFileInfoImportPanel
implements IBrowseDlgInterafce,
DCTreeEventListener,
INotifyTransferProgress {
    private static final long serialVersionUID = 8918138601850432835L;
    private long m_lFileSize;
    private Map<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> m_oDeviceTypeMap;
    private String m_strGetFileInfoTemplete = DCFrameWorkUtil.getLocalizedString("SAM_IMPORTING_FILES");
    private SAMFileInfo m_oSelectedSAMFileInfo;
    private static String strLastPath = "";
    private boolean bisFromBackupDlg = false;
    private String strSamVersion = "";
    private String strSamPatchVer = "";

    public SAMFileInfoImportPanel(SAMFileInfoImportDlg oSAMFileInfoImportDlg, int iContentTypeCode, boolean isTelnet, SAMFileInfo oSAMFileInfo) {
        this.mIsTelnet = isTelnet;
        this.m_oSelectedSAMFileInfo = oSAMFileInfo;
        this.m_oSyncObject = new Object();
        this.m_iContentTypeCode = iContentTypeCode;
        XFtpManager.getInstance().setTransferCancelled(false);
        this.m_oSAMFileInfoImportDlg = oSAMFileInfoImportDlg;
        this.m_oSAMManager = SAMManager.getInstance();
        this.jbInit();
    }

    public SAMFileInfoImportPanel(SAMFileInfoImportDlg oSAMFileInfoImportDlg, int iContentTypeCode, boolean isTelnet) {
        this(oSAMFileInfoImportDlg, iContentTypeCode, isTelnet, null);
    }

    public void updateComponentsForImport() {
        this.m_oDeviceTypeComboBox.setVisible(false);
        this.m_oDeviceTypeLabel.setVisible(false);
    }

    public void updateComponentsForUpdate() {
        this.m_oFilePathTextField.setPreferredSize(new Dimension(255, 21));
        this.m_oFilePathTextField.setMinimumSize(new Dimension(255, 21));
        this.m_oFilePathBrowseButton.setVisible(false);
        this.m_oDeviceTypeComboBox.setVisible(true);
        this.m_oDeviceTypeLabel.setVisible(true);
        this.m_oDevPatchVersionTextField.setVisible(true);
        this.m_oDevPatchVersionTextField.setEditable(false);
        this.m_oDevicePatchVersionLabel.setVisible(true);
        if (null != this.m_oSelectedSAMFileInfo) {
            this.m_oDeviceTypeComboBox.addItem(this.m_oSelectedSAMFileInfo.getDeviceTypeInfo());
            this.m_oContentTypeComboBox.addItem(this.m_oSelectedSAMFileInfo.getFileType());
            this.disableFilePath(this.m_oSelectedSAMFileInfo.getFileName());
            this.m_oDevVersionTextField.setText(this.m_oSelectedSAMFileInfo.getCurrentVersion());
            this.m_oDevPatchVersionTextField.setText(this.m_oSelectedSAMFileInfo.getPatchVer());
            this.m_oDescriptionTextArea.setText(this.m_oSelectedSAMFileInfo.getFileDescription());
        }
        this.disableDeviceType();
        this.disableContentType();
    }

    public ComboBoxWithToolTip getContentTypeComboBox() {
        return this.m_oContentTypeComboBox;
    }

    public ComboBoxWithToolTip getDeviceTypeComboBox() {
        return this.m_oDeviceTypeComboBox;
    }

    public void disableDeviceType() {
        this.m_oDeviceTypeComboBox.setEnabled(false);
    }

    public void disableContentType() {
        this.m_oContentTypeComboBox.setEnabled(false);
    }

    public void disableFilePath(String strFilePath) {
        this.m_oFilePathBrowseButton.setEnabled(false);
        this.m_oFilePathBrowseButton.setVisible(false);
        this.m_oFilePathLabel.setText(DCFrameWorkUtil.getLocalizedString("SAM_FILENAME_LABEL"));
        this.m_oFilePathTextField.setText(strFilePath);
        this.m_oFilePathTextField.setEditable(false);
        this.m_oFilePathTextField.setDisabledTextColor(Color.GRAY);
        this.m_oFilePathTextField.setBackground(this.m_oSAMFileInfoImportDlg.getBackground());
    }

    public void setVersion(String strVersion) {
        this.m_oDevVersionTextField.setText(strVersion);
    }

    public void setPatchVersion(String strVersion) {
        this.m_oDevPatchVersionTextField.setText(strVersion);
    }

    public void disablePatchVersion() {
        if (null != this.m_oDevPatchVersionTextField) {
            this.m_oDevPatchVersionTextField.setVisible(false);
        }
        if (null != this.m_oDevicePatchVersionLabel) {
            this.m_oDevicePatchVersionLabel.setVisible(false);
        }
    }

    public void setDescription(String strDescription) {
        this.m_oDescriptionTextArea.setText(strDescription);
    }

    @Override
    public void setFileOrDirectory(String strFilePath, String strVersion, boolean file) {
        this.m_oFilePathTextField.setText(strFilePath);
    }

    public void setFileProgressInfo(int iTotalFileCount, int iCompleteFileCount) {
        if (StringUtils.isNullOrEmptyStr(this.m_oFilePathTextField.getText())) {
            DCDebugTracer.trace("skip unwanted sam import file info msg");
            return;
        }
        if (1 < iTotalFileCount) {
            this.m_oImportFileProgressBar.setValue(0);
            this.m_oImportFileProgressBar.setText(MessageFormat.format(this.m_strGetFileInfoTemplete, String.valueOf(iCompleteFileCount), String.valueOf(iTotalFileCount)));
        }
        this.m_oImportFileProgressBar.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileDetailsRsp(AsnSAMGetFileDetailsRsp oFileDetailsRsp) {
        DCDebugTracer.trace("SAM  method processFileDetailsRsp start");
        Object object = this.m_oSyncObject;
        synchronized (object) {
            int iErrorCode;
            if (this.m_oSAMFileInfoImportDlg.isCancelButtonClicked() || !Collator.getInstance().equals(this.extractFileName(new String(oFileDetailsRsp.oSAMFileInfo.strFileName)), this.extractFileName(this.m_oFilePathTextField.getPath().trim()))) {
                this.m_oSAMManager.deleteTempFiles(new String(oFileDetailsRsp.oSAMFileInfo.strFileName), this.m_iReqID);
                if (!this.m_oSAMFileInfoImportDlg.isCancelButtonClicked()) {
                    if (0 == oFileDetailsRsp.oErrorInfo.iErrorNo.intValue()) {
                        DCDebugTracer.trace("SAM dialog is not closed");
                        return;
                    }
                } else {
                    DCDebugTracer.trace("SAM dialog is closed");
                    return;
                }
            }
            if (0 == (iErrorCode = oFileDetailsRsp.oErrorInfo.iErrorNo.intValue()) || 998244385 == iErrorCode || 998244370 == iErrorCode || 989859183 == iErrorCode) {
                this.m_strNewFilePath = new String(oFileDetailsRsp.oSAMFileInfo.strFileName);
                this.m_oDescriptionTextArea.setText(new String(oFileDetailsRsp.oSAMFileInfo.strDescription));
                this.m_oDevVersionTextField.setText(new String(oFileDetailsRsp.oSAMFileInfo.strVersion));
                this.m_autoObtainVersion = this.m_oDevVersionTextField.getText().trim();
                this.m_oDevVersionTextField.grabFocus();
                if (null != oFileDetailsRsp.oSAMFileInfo.strPatchVersion) {
                    this.m_oDevPatchVersionTextField.setText(new String(oFileDetailsRsp.oSAMFileInfo.strPatchVersion));
                }
                if (null == oFileDetailsRsp.oAsnFileLst) {
                    this.setSAMFileInfo(oFileDetailsRsp);
                    this.setImportPanelWithoutProgressBar();
                    this.m_oSAMManager.unregisterForFileDetailsNtfn();
                    if (989859183 == iErrorCode || 998244385 == iErrorCode) {
                        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), iErrorCode, DCFrameWorkUtil.getLocalizedString("INFORMATION"), 1);
                    }
                } else {
                    ArrayList<String> oFileNameLst = new ArrayList<String>(0);
                    this.fillWholeVersionFileListMap(oFileDetailsRsp.oAsnFileLst, oFileNameLst);
                    if (!this.m_bClientFile && 0 >= this.m_oWholeVersionFileList.size()) {
                        this.setImportPanelWithoutProgressBar();
                        this.m_oSAMManager.unregisterForFileDetailsNtfn();
                        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_WHOLE_VERSION_FILES_NOT_FOUND"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                        this.setTextFieldsEmpty();
                        return;
                    }
                    if (!oFileNameLst.isEmpty()) {
                        if (!this.isSelectWholeVersion() && 0 == iErrorCode) {
                            this.setTextFieldsEmpty();
                        }
                        SAMFileInfoImportPanelHelper.displayMessage(oFileNameLst);
                    }
                    if (this.m_bClientFile && this.isSelectWholeVersion()) {
                        String strSource = SAMFileInfoImportPanelHelper.extractPath(this.m_oFilePathTextField.getPath());
                        String strDest = SAMFileInfoImportPanelHelper.extractPath(new String(oFileDetailsRsp.oSAMFileInfo.strFileName));
                        SAMFileTransHandler.getInstance().setSAMFileImportPanel(this);
                        SAMFileTransHandler.getInstance().startTransferingFiles(this.m_oWholeVersionFileList, strSource, strDest);
                        return;
                    }
                    this.setImportPanelWithoutProgressBar();
                    this.m_oSAMManager.unregisterForFileDetailsNtfn();
                }
            } else {
                this.setImportPanelWithoutProgressBar();
                this.m_oSAMManager.unregisterForFileDetailsNtfn();
                if (null == oFileDetailsRsp.oAsnDevTypeFileInfoList) {
                    DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                } else {
                    SAMFileInfoImportPanelHelper.showErrorForSoftwareCheck(oFileDetailsRsp);
                }
                this.m_oFilePathTextField.setText("");
                DCFrameWorkUtil.updateUI(this);
            }
        }
        DCDebugTracer.trace("DC:: SAM  method processFileDetailsRsp end..");
    }

    public void updateWholeVersionFileListMap(List<String> oFileNameLst) {
        int iSize = oFileNameLst.size();
        String strFileName = null;
        for (int i = 0; i < iSize; ++i) {
            strFileName = oFileNameLst.get(i);
            this.m_oWholeVersionFileListMap.remove(strFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCancelBtnActinPerformed() {
        DCDebugTracer.trace("SAMFileInfoImportPanel#handleCancelBtnActinPerformed...");
        Object object = this.m_oSyncObject;
        synchronized (object) {
            DeviceTypeInfo oDevTypeInfo = null;
            if (0 == this.m_oSelectedDeviceTypeList.size()) {
                return;
            }
            oDevTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
            String strVersion = this.m_oDevVersionTextField.getText().toUpperCase().trim();
            ContentType oContentType = null;
            SAMFileInfo oSAMFileInfo = new SAMFileInfo();
            oSAMFileInfo.setDeviceTypeInfo(oDevTypeInfo);
            oSAMFileInfo.setVersion(strVersion);
            oSAMFileInfo.setFileName(this.m_strNewFilePath);
            if (!this.isSelectWholeVersion()) {
                oContentType = (ContentType)this.m_oContentTypeComboBox.getSelectedItem();
            }
            oSAMFileInfo.setFileType(oContentType);
            if (this.isSelectWholeVersion()) {
                this.cancelImportOperation(oSAMFileInfo, 1);
                return;
            }
            if (null == oContentType) {
                return;
            }
            if (4 == oDevTypeInfo.getDevDomain() || "DBUPDATE".equals(oContentType.getId())) {
                if (4 == oDevTypeInfo.getDevDomain()) {
                    if (this.m_bClientFile) {
                        XFtpManager.getInstance().setTransferCancelled(true);
                    }
                    this.cancelImportOperation(oSAMFileInfo, 0);
                } else if ("DBUPDATE".equals(oContentType.getId())) {
                    this.cancelImportOperation(oSAMFileInfo, 2);
                }
                return;
            }
            if (!this.m_strNewFilePath.equalsIgnoreCase("")) {
                this.m_oSAMManager.deleteTempFiles(this.m_strNewFilePath, this.m_iReqID);
            }
        }
    }

    public void handleUpdateOkBtnAcionPerformed() {
        boolean bRetVal = this.validateFieldsForUpdate();
        if (!bRetVal) {
            return;
        }
        boolean bOverwrite = false;
        int iErrorCode = -1;
        String strDescription = this.m_oDescriptionTextArea.getText().trim();
        String strVersion = this.m_oDevVersionTextField.getText().toUpperCase().trim();
        if (this.m_oUseExistingVerCheckBox.isSelected()) {
            strVersion = (String)this.m_oDevVersionComboBox.getSelectedItem();
        }
        String strPatchVersion = this.m_oDevPatchVersionTextField.getText();
        boolean isModifyVersion = this.m_oSelectedSAMFileInfo.getDeviceTypeInfo().getDevDomain() != 4 && (!this.m_oSelectedSAMFileInfo.getVersion().equals(strVersion) || !this.m_oSelectedSAMFileInfo.getPatchVer().equals(strPatchVersion));
        int Confirm = 0;
        if (isModifyVersion && !DCFrameWorkUtil.getIsSingleClient()) {
            Confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_MODIFY_VERSION_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRMATION_DIALOG_TITLE"), 0);
        }
        if (Confirm != 0) {
            return;
        }
        this.m_oSelectedSAMFileInfo.setVersion(strVersion);
        this.m_oSelectedSAMFileInfo.setPatchVer(strPatchVersion);
        this.m_oSelectedSAMFileInfo.setFileDescription(strDescription);
        AsnSAMFileModifyRsp oAsnSAMFileModifyRsp = this.m_oSAMManager.sendSAMFileModifyReq(this.m_oSelectedSAMFileInfo, bOverwrite);
        if (null == oAsnSAMFileModifyRsp) {
            return;
        }
        this.m_strNewFilePath = DCCommonUtil.convertByteArrayToStr(oAsnSAMFileModifyRsp.oFileInfo.strFileName);
        iErrorCode = oAsnSAMFileModifyRsp.oErrorInfo.iErrorNo.intValue();
        if (989855899 == iErrorCode) {
            int iConfirm = -1;
            iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_OVERWRITE_CONFIRNMATION_MESSAGE"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
            if (iConfirm != 0) {
                return;
            }
            bOverwrite = true;
            oAsnSAMFileModifyRsp = this.m_oSAMManager.sendSAMFileModifyReq(this.m_oSelectedSAMFileInfo, bOverwrite);
            iErrorCode = oAsnSAMFileModifyRsp.oErrorInfo.iErrorNo.intValue();
        }
        if (0 == iErrorCode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)((Object)SAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("OPERATION_SUCCESSFUL"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
                    SAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.dispose();
                }
            });
        } else {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOkBtnActinPerformed(boolean oApplyClicked) {
        boolean bFlag = this.validateFields();
        if (!bFlag) {
            return;
        }
        DeviceTypeInfo oDevTypeInfo = null;
        oDevTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
        if (!this.m_strNewFilePath.equalsIgnoreCase("")) {
            int iCmdCode = 43919;
            AsnSAMImportFileReq oAsnSAMImportFileReq = this.getSAMImportReq();
            Object object = this.m_oSyncObject;
            synchronized (object) {
                block20: {
                    if (this.isSelectWholeVersion()) {
                        iCmdCode = 43975;
                        this.m_oSAMManager.registerForWholeVersionImportNtfn(this);
                    } else if (oDevTypeInfo.isT2000Domain()) {
                        if (this.m_bClientFile) {
                            Vector oFileVec = new Vector(1);
                            oFileVec.addAll(this.m_oFileListForSFTP);
                            DevOpObjectStore.getInstance().putObjectInstance(43919, oFileVec);
                            XFtpManager.getInstance().setTransferCancelled(false);
                            XFtpManager.getInstance().registerForNotification(43867);
                        }
                        this.m_oSAMManager.registerForImportFileNtfn(this);
                    } else if (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE")) {
                        this.m_oSAMManager.registerForImportFileNtfn(this);
                    }
                    try {
                        this.m_iReqID = this.m_oSAMManager.importSoftware(oAsnSAMImportFileReq, iCmdCode);
                    }
                    catch (DCException e) {
                        boolean iImportSuccess = this.handImportFileFailed(oDevTypeInfo, iCmdCode, oAsnSAMImportFileReq, e);
                        if (iImportSuccess) break block20;
                        return;
                    }
                }
                if (this.isSelectWholeVersion() || oDevTypeInfo.isT2000Domain() || ((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE")) {
                    this.enableUseExistingVerCheckBox(false);
                    this.enableComponentsForGettingFileInfo(false);
                    this.setVisibleProgressBar();
                    this.setApplyButtonClicked(oApplyClicked);
                    this.m_oImportFileProgressBar.setText(DCFrameWorkUtil.getLocalizedString("SAM_IMPORTING_FILE"));
                    return;
                }
                this.m_oSAMFileInfoImportDlg.setConfirmMessage(false);
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("OPERATION_SUCCESSFUL"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
                if (!oApplyClicked) {
                    this.m_oSAMFileInfoImportDlg.dispose();
                } else if (oDevTypeInfo.isDMSDomain()) {
                    this.setTextFieldsEmpty();
                } else if (null != this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                    this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(false);
                }
            }
            if (oApplyClicked && 4 != oDevTypeInfo.getDevDomain()) {
                this.setTextFieldsEmpty();
            }
        }
    }

    public boolean validateFields() {
        boolean bRetVal = true;
        if (this.m_oUseExistingVerCheckBox.isSelected()) {
            String VersionComboBoxText = (String)this.m_oDevVersionComboBox.getSelectedItem();
            this.m_oDevVersionTextField.setText(VersionComboBoxText);
        }
        if (0 == this.m_oSelectedDeviceTypeList.size()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_DEVICE_TYPE"));
            bRetVal = false;
            return bRetVal;
        }
        if (this.m_oContentTypeComboBox.isEnabled() && -1 == this.m_oContentTypeComboBox.getSelectedIndex()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_CONTENT_TYPE"));
            bRetVal = false;
        } else if (0 == this.m_oFilePathTextField.getText().trim().length()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_FILE_PATH"));
            bRetVal = false;
        } else if (null != this.m_oSAMFileInfo && !this.m_oSAMFileInfo.isHaveMultiDevVer() && !this.m_oUseExistingVerCheckBox.isSelected() && 0 == this.m_oDevVersionTextField.getText().trim().length()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_VERSION"));
            bRetVal = false;
        } else if (this.m_oUseExistingVerCheckBox.isSelected() && -1 == this.m_oDevVersionComboBox.getSelectedIndex()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_VERSION"));
            bRetVal = false;
        } else if (!SAMFileInfoImportPanelHelper.isNameValid(this.m_oDevVersionTextField.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_VERSION"));
            bRetVal = false;
        }
        if (null != this.m_oDevPatchVersionTextField && !SAMFileInfoImportPanelHelper.isNameValid(this.m_oDevPatchVersionTextField.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_PatchVersion"));
            bRetVal = false;
        }
        if (!SAMFileInfoImportPanelHelper.isNameValid(this.m_oDescriptionTextArea.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_DESCRIPTION"));
            bRetVal = false;
        }
        return bRetVal;
    }

    public void setFileListForSFTP(List<String> oFileList) {
        this.m_oFileListForSFTP = oFileList;
    }

    public void setFileSize(long lFileSize) {
        this.m_lFileSize = lFileSize;
    }

    public void setClientFile(boolean bFlag) {
        this.m_bClientFile = bFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImportFileRsp(AsnDCSyncRsp oAsnRsp) {
        Object object = this.m_oSyncObject;
        synchronized (object) {
            if (null == oAsnRsp || null == oAsnRsp.oReqID || this.m_iReqID != oAsnRsp.oReqID.intValue()) {
                if (null == oAsnRsp) {
                    DCDebugTracer.trace("<datacenter>oAsnDCOpertionRsp is null.");
                } else {
                    if (null == oAsnRsp.oReqID) {
                        DCDebugTracer.trace("<datacenter>oAsnDCOpertionRsp.iRequestID is null");
                    } else {
                        DCDebugTracer.trace("<datacenter>oAsnDCOpertionRsp.iRequestID is " + oAsnRsp.oReqID);
                    }
                    DCDebugTracer.trace(oAsnRsp.toString());
                    DCDebugTracer.trace("<datacenter>the actual request id is " + this.m_iReqID);
                }
                return;
            }
            this.m_oSAMFileInfoImportDlg.setConfirmMessage(false);
            if (this.m_bIsCancelled) {
                return;
            }
            DeviceTypeInfo oDevTypeInfo = null;
            SAMFileInfo oSAMFileInfo = null;
            if (0 == oAsnRsp.oErrorInfo.iErrorNo.intValue()) {
                int iSize = this.m_oSelectedDeviceTypeList.size();
                for (int i = 0; i < iSize; ++i) {
                    oDevTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(i);
                    oSAMFileInfo = new SAMFileInfo();
                    oSAMFileInfo.setDeviceTypeInfo(oDevTypeInfo);
                    oSAMFileInfo.setFileName(this.extractFileName(this.m_oSAMFileInfo.getFileName()));
                    oSAMFileInfo.setFileType((ContentType)this.m_oContentTypeComboBox.getSelectedItem());
                    String strVersion = this.m_oDevVersionTextField.getText().toUpperCase().trim();
                    if (this.m_oUseExistingVerCheckBox.isSelected()) {
                        strVersion = (String)this.m_oDevVersionComboBox.getSelectedItem();
                    }
                    strVersion = this.getVersionNodeForUpdate(strVersion);
                    oSAMFileInfo.setVersion(strVersion);
                    oSAMFileInfo.setFileDescription(this.m_oDescriptionTextArea.getText().trim());
                    oSAMFileInfo.setFileSize(this.m_oSAMFileInfo.getFileSize());
                    oSAMFileInfo.setBDVersion(this.m_oSAMFileInfo.getBDVersion());
                    oSAMFileInfo.setPatchVer(this.m_oDevPatchVersionTextField.getText());
                    this.m_oSAMManager.addSAMFileInfoToDataModel(oSAMFileInfo);
                    this.updateSAMFileInfo(oDevTypeInfo, oSAMFileInfo);
                }
                this.setImportPanelWithoutProgressBar();
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("OPERATION_SUCCESSFUL"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
                if (!this.m_oApplyClicked) {
                    this.m_oSAMFileInfoImportDlg.dispose();
                } else {
                    this.setTextFieldsEmpty();
                    if (null != this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                        this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(false);
                    }
                }
            } else {
                this.setImportPanelWithoutProgressBar();
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), oAsnRsp.oErrorInfo.iErrorNo.intValue(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.setTextFieldsEmpty();
            }
        }
    }

    public void setClientBrowsePath(String strPath) {
        this.m_strClientBrowsePath = strPath;
    }

    public void setServerBrowsePath(String strPath) {
        this.m_strServerBrowsePath = strPath;
    }

    public long getFileSize() {
        return this.m_lFileSize;
    }

    public void setImportPanelWithoutProgressBar() {
        this.m_oImportFileProgressBar.setVisible(false);
        this.enableComponentsForGettingFileInfo(true);
        this.loadDevVersionDropDown();
        if (0 == this.m_oSelectedDeviceTypeList.size() || this.m_oDevVersionComboBox.getItemCount() == 0) {
            this.enableUseExistingVerCheckBox(false);
        } else {
            this.enableUseExistingVerCheckBox(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWholeVersionRsp(AsnSAMImportFileRsp oAsnSAMImportFileRsp) {
        Object object = this.m_oSyncObject;
        synchronized (object) {
            this.m_oSAMFileInfoImportDlg.setConfirmMessage(false);
            if (this.m_bIsCancelled) {
                return;
            }
            DeviceTypeInfo oDevTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
            if (0 == oAsnSAMImportFileRsp.oErrorInfo.iErrorNo.intValue()) {
                AsnSAMFileInfoLst oAsnSAMFileInfoLst = oAsnSAMImportFileRsp.oFileInfoLst;
                int iSize = oAsnSAMFileInfoLst.size();
                for (int i = 0; i < iSize; ++i) {
                    AsnSAMFileInfo oAsnSAMFileInfo = (AsnSAMFileInfo)oAsnSAMFileInfoLst.get(i);
                    ISAMFileInfo oSAMFileInfo = SAMUtil.getInstance().fillFileInfoObject(oDevTypeInfo.getDevTypeID(), oDevTypeInfo.getDevTypeVersionId(), oAsnSAMFileInfo);
                    this.m_oSAMManager.addSAMFileInfoToDataModel(oSAMFileInfo);
                    this.updateSAMFileInfo(oDevTypeInfo, oSAMFileInfo);
                }
                this.setImportPanelWithoutProgressBar();
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("OPERATION_SUCCESSFUL"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
                if (!this.m_oApplyClicked) {
                    this.m_oSAMFileInfoImportDlg.dispose();
                } else {
                    this.setTextFieldsEmpty();
                    if (null != this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                        this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(false);
                    }
                }
            } else {
                this.setImportPanelWithoutProgressBar();
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), oAsnSAMImportFileRsp.oErrorInfo.iErrorNo.intValue(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.setTextFieldsEmpty();
            }
        }
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        if (null == this.m_oDeviceTypeMap) {
            return;
        }
        if (!(oEventObject.getSource() instanceof SAMImportTreeNodeInfo)) {
            return;
        }
        SAMImportTreeNodeInfo oTreeNodeInfo = (SAMImportTreeNodeInfo)oEventObject.getSource();
        if (1 == oTreeNodeInfo.getNodeType()) {
            String sSeriesID = oTreeNodeInfo.getNodeName();
            String[] sDevTypeIDs = DeviceInfoManagerImplHelper.getSupportDevTypeIDs(sSeriesID);
            boolean bFinishFlag = true;
            for (String sDevTypeID : sDevTypeIDs) {
                Set<DeviceTypeNameInfo> keySet = this.m_oDeviceTypeMap.keySet();
                Iterator<DeviceTypeNameInfo> itor = keySet.iterator();
                String sDestID = "";
                DeviceTypeNameInfo oDevTypeNameInfo = null;
                while (itor.hasNext()) {
                    oDevTypeNameInfo = itor.next();
                    if (null == oDevTypeNameInfo || !sDevTypeID.equals(sDestID = "" + oDevTypeNameInfo.getDevTypeId())) continue;
                    List<DeviceTypeVersionInfo> oDevTypeVerInfoList = this.m_oDeviceTypeMap.get(oDevTypeNameInfo);
                    int iSize = oDevTypeVerInfoList.size();
                    DeviceTypeInfo oDevTypeInfo = null;
                    DeviceTypeVersionInfo oDevTypeVerInfo = null;
                    for (int i = 0; i < iSize; ++i) {
                        oDevTypeVerInfo = oDevTypeVerInfoList.get(i);
                        int iDevTypeID = oDevTypeVerInfo.getDevTypeNameInfo().getDevTypeId();
                        int iDevTypeVerID = oDevTypeVerInfo.getVersionId();
                        oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
                        if (0 == oTreeNodeInfo.getSelectedState()) {
                            bFinishFlag = this.addToSelectedDeviceTypeList(oTreeNodeInfo, oDevTypeInfo);
                        } else if (2 == oTreeNodeInfo.getSelectedState()) {
                            this.m_oSelectedDeviceTypeList.remove(oDevTypeInfo);
                        }
                        if (!bFinishFlag) {
                            this.m_oSelectedDeviceTypeList.remove(oDevTypeInfo);
                        }
                        this.updatePatchVersionFiled(oDevTypeInfo);
                        this.curDevTypeInfo = oDevTypeInfo;
                    }
                }
            }
        } else if (2 == oTreeNodeInfo.getNodeType()) {
            DeviceTypeNameInfo oDevTypeNameInfo = oTreeNodeInfo.getDeviceTypeNameInfo();
            List<DeviceTypeVersionInfo> oDevTypeVerInfoList = this.m_oDeviceTypeMap.get(oDevTypeNameInfo);
            int iSize = oDevTypeVerInfoList.size();
            DeviceTypeInfo oDevTypeInfo = null;
            DeviceTypeVersionInfo oDevTypeVerInfo = null;
            for (int i = 0; i < iSize; ++i) {
                oDevTypeVerInfo = oDevTypeVerInfoList.get(i);
                int iDevTypeID = oDevTypeVerInfo.getDevTypeNameInfo().getDevTypeId();
                int iDevTypeVerID = oDevTypeVerInfo.getVersionId();
                oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
                if (0 == oTreeNodeInfo.getSelectedState()) {
                    this.addToSelectedDeviceTypeList(oTreeNodeInfo, oDevTypeInfo);
                } else if (2 == oTreeNodeInfo.getSelectedState()) {
                    this.m_oSelectedDeviceTypeList.remove(oDevTypeInfo);
                }
                this.updatePatchVersionFiled(oDevTypeInfo);
                this.curDevTypeInfo = oDevTypeInfo;
            }
        } else if (3 == oTreeNodeInfo.getNodeType()) {
            DeviceTypeVersionInfo oDevTypeVerInfo = oTreeNodeInfo.getDeviceTypeVersionInfo();
            int iDevTypeID = oDevTypeVerInfo.getDevTypeNameInfo().getDevTypeId();
            int iDevTypeVerID = oDevTypeVerInfo.getVersionId();
            DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            if (0 == oTreeNodeInfo.getSelectedState()) {
                this.addToSelectedDeviceTypeList(oTreeNodeInfo, oDevTypeInfo);
            } else if (2 == oTreeNodeInfo.getSelectedState()) {
                this.m_oSelectedDeviceTypeList.remove(oDevTypeInfo);
            }
            this.updatePatchVersionFiled(oDevTypeInfo);
            this.curDevTypeInfo = oDevTypeInfo;
        } else {
            return;
        }
        this.updateContentTypeComboBox();
    }

    private void updateSAMFileInfo(DeviceTypeInfo oDeviceTypeInfo, ISAMFileInfo oSAMFileInfo) {
        SoftwareArchiveMgmtPanel oSWMgtPanel = DCFrameWorkUtil.getDCModuleManager().getSoftwareArchMgrPanel();
        if (null != oSWMgtPanel) {
            oSWMgtPanel.updateSAMFileInfo(oDeviceTypeInfo, oSAMFileInfo);
        }
    }

    public void updateContentTypeComboBox() {
        int iSize = this.m_oSelectedDeviceTypeList.size();
        if (0 != iSize) {
            this.fillContentTypeComboBox();
        } else {
            this.m_oContentTypeComboBox.removeAllItems();
        }
        if (0 == this.m_oContentTypeComboBox.getItemCount()) {
            this.disableContentType();
            this.m_oFilePathBrowseButton.setEnabled(false);
            this.m_oDevVersionComboBox.setEnabled(false);
            this.m_oDevVersionTextField.setEnabled(false);
            this.m_oDescriptionTextArea.setEnabled(false);
            this.m_oSAMFileInfoImportDlg.setOkButtonEnable(false);
            this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(false);
        } else {
            this.m_oContentTypeComboBox.setEnabled(true);
            this.m_oFilePathBrowseButton.setEnabled(true);
            this.m_oDevVersionComboBox.setEnabled(true);
            this.m_oDevVersionTextField.setEnabled(true);
            this.m_oDescriptionTextArea.setEnabled(true);
            this.m_oSAMFileInfoImportDlg.setOkButtonEnable(true);
            this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(true);
        }
        if (this.getIsFromBackImageDlg()) {
            this.m_oContentTypeComboBox.setEnabled(false);
        }
    }

    public void setFromBackImageDlg(boolean m_bisFromBackupDlg) {
        this.bisFromBackupDlg = m_bisFromBackupDlg;
    }

    public boolean getIsFromBackImageDlg() {
        return this.bisFromBackupDlg;
    }

    public void setDeviceTypeList(List<DeviceTypeInfo> oDevTypeInfoList) {
        this.m_oSelectedDeviceTypeList.addAll(oDevTypeInfoList);
    }

    public void setDeviceTypeMap(SortedMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> oDeviceTypeMap) {
        this.m_oDeviceTypeMap = oDeviceTypeMap;
    }

    public void setSAMFileInfoTreePanel(SAMFileInfoTreePanel fileInfoTreePanel) {
        this.m_oSAMFileInfoTreePanel = fileInfoTreePanel;
    }

    public void setVersionComponnetState(boolean bEnable) {
        this.m_oDevVersionTextField.setEnabled(bEnable);
        this.m_oDescriptionTextArea.setEnabled(bEnable);
    }

    public void doCleanUp() {
        this.m_oFilePathLabel = null;
        this.m_oFilePathLabel_Asterisk = null;
        this.m_oDeviceTypeLabel = null;
        this.m_oDeviceVersionLabel = null;
        this.m_oDeviceVersionLabel_Asterisk = null;
        this.m_oContentTypeLabel = null;
        this.m_oContentTypeLabel_Asterisk = null;
        this.m_oDescriptionLabel = null;
        this.m_oFilePathTextField = null;
        this.m_oDevVersionTextField = null;
        this.m_oDevVersionComboBox = null;
        this.m_oDevVersionTextFilter = null;
        this.m_oDescriptionTextArea = null;
        this.m_oDescriptionTextFilter = null;
        this.m_oDeviceTypeComboBox = null;
        this.m_oContentTypeComboBox = null;
        this.m_oUseExistingVerCheckBox = null;
        this.m_oFilePathBrowseButton = null;
        this.m_oImportFileProgressBar = null;
        this.m_strNewFilePath = null;
        this.m_oSAMFileInfo = null;
        this.m_oFileListForSFTP = null;
        this.m_strServerBrowsePath = null;
        this.m_strClientBrowsePath = null;
        this.m_oWholeVersionFileList = null;
        this.m_oWholeVersionFileListMap = null;
        this.m_oSelectedDeviceTypeList = null;
        this.m_oDeviceTypeMap = null;
        this.m_oSAMFileInfoTreePanel = null;
        this.m_oDevicePatchVersionLabel = null;
        this.m_oDevPatchVersionTextField = null;
    }

    public void setOperationIDForContentType(int iOperationID) {
        this.m_iOperationID = iOperationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFileDetails(boolean bIsClientFile) {
        boolean bIsGetFileDetailsOk = false;
        String strFilePath = this.m_oFilePathTextField.getText().trim();
        strFilePath = strFilePath.replace('\\', '/');
        if (bIsClientFile) {
            Vector<String> oFileVec = new Vector<String>(1);
            oFileVec.add(strFilePath);
            DevOpObjectStore.getInstance().putObjectInstance(0, oFileVec);
            XFtpManager.getInstance().registerForNotification(43867);
            DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("SAM_COPY_FILE_SUGGESTION"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
        }
        Object object = this.m_oSyncObject;
        synchronized (object) {
            this.m_oSAMManager.registerForFileDetailsNtfn(this);
            int iContentType = 0;
            int iWholeVersion = 1;
            if (!this.isSelectWholeVersion()) {
                iContentType = ((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getContentTypeCode();
                iWholeVersion = 0;
            } else {
                iWholeVersion = 1;
            }
            this.m_iReqID = DCFrameWorkUtil.generateRequestId();
            try {
                this.m_oSAMManager.getSAMFileDetails(this.m_iReqID, bIsClientFile, strFilePath, this.m_oSelectedDeviceTypeList, iContentType, iWholeVersion);
                bIsGetFileDetailsOk = true;
            }
            catch (DCException e) {
                if (bIsClientFile) {
                    XFtpManager.getInstance().unregisterForNotification(43867);
                }
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.m_oFilePathTextField.setText("");
                return bIsGetFileDetailsOk;
            }
            this.enableUseExistingVerCheckBox(false);
            this.enableComponentsForGettingFileInfo(false);
            this.setVisibleProgressBar();
            this.m_oImportFileProgressBar.setText(DCFrameWorkUtil.getLocalizedString("SAM_GETTING_FILE_INFO"));
            return bIsGetFileDetailsOk;
        }
    }

    private FileSelectionBrowseDlg openFileBrowseDlg(ContentType oContentType) throws DCException {
        if (0 == this.m_oSelectedDeviceTypeList.size()) {
            return null;
        }
        DeviceTypeInfo oDeviceTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
        int iSAMOperId = 0;
        if (oDeviceTypeInfo.isT2000Domain()) {
            iSAMOperId = 4;
        }
        if (this.isSelectWholeVersion()) {
            iSAMOperId = 1;
        } else if (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE")) {
            iSAMOperId = 2;
        } else if (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("PACKETTOOL")) {
            iSAMOperId = 3;
        }
        String strContentType = "";
        if (null != oContentType && !this.isSelectWholeVersion()) {
            strContentType = oContentType.getId();
        }
        SAMFileSelectBrowseDlg oFilePathBrowseDlg = new SAMFileSelectBrowseDlg(oDeviceTypeInfo, iSAMOperId, strContentType, strLastPath);
        oFilePathBrowseDlg.setTitle(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_SELECT_FILE_TITLE"));
        oFilePathBrowseDlg.registBrowseDlgInterface(this);
        oFilePathBrowseDlg.setVisible(true);
        return oFilePathBrowseDlg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void browseBtnActionPerformed() {
        ContentType oContentType = (ContentType)this.m_oContentTypeComboBox.getSelectedItem();
        if (this.m_oContentTypeComboBox.isEnabled() && (null == oContentType || 0 == oContentType.toString().length())) {
            DCOptionPane.showErrorDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_CONTENT_TYPE"));
            return;
        }
        try {
            if (0 != this.m_oFilePathTextField.getText().trim().length()) {
                int iSelectedOption = DCOptionPane.showConfirmDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_DEVICE_TYPE_CHANGE_CONFIRM"), DCFrameWorkUtil.getLocalizedString("SAM_DEVICE_TYPE_CHANGE_CONFIRM_TITLE"), 0);
                if (0 != iSelectedOption) return;
                DCDebugTracer.trace("SAMFileInfoImportPanel#browseBtnActionPerformed...");
                this.m_oSAMManager.deleteTempFiles(this.m_strNewFilePath, this.m_iReqID);
                this.setTextFieldsEmpty();
                this.m_strClientBrowsePath = "";
                this.m_strServerBrowsePath = "";
            } else {
                this.m_strClientBrowsePath = "";
                this.m_strServerBrowsePath = "";
            }
            FileSelectionBrowseDlg oFilePathBrowseDlg = this.openFileBrowseDlg(oContentType);
            if (this.m_oFilePathTextField.getPath().length() > 0) {
                strLastPath = FileUtil.getPath(this.m_oFilePathTextField.getPath());
            }
            if (0 == this.m_oSelectedDeviceTypeList.size()) {
                return;
            }
            DeviceTypeInfo oDeviceTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
            if (!oFilePathBrowseDlg.isOKOption()) {
                return;
            }
            try {
                String strFileName = this.m_oFilePathTextField.getPath();
                File oFile = new File(strFileName);
                strFileName = oFile.getName();
                boolean bisValidFileName = SAMFileInfoImportPanelHelper.isNameValidFileName(strFileName);
                if (!bisValidFileName) {
                    DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("INVALID_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                    this.m_oFilePathTextField.setText("");
                    return;
                }
            }
            catch (Exception e) {
                DCOptionPane.showMessageDialog((Component)this, DCFrameWorkUtil.getLocalizedString("INVALID_FILE_NAME"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.m_oFilePathTextField.setText("");
                DebugTracer.trace((String)e.getMessage());
            }
            if (Collator.getInstance().equals(this.m_oFilePathTextField.getText().trim(), "")) return;
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                this.m_bClientFile = IUpdateDestinationListener.DESTINATION_NMS_CLIENT.equals(oFilePathBrowseDlg.getDestination());
            } else if (4 != oDeviceTypeInfo.getDevDomain()) {
                this.m_bClientFile = false;
            }
            this.m_oImportFileProgressBar.setDestination(oFilePathBrowseDlg.getDestination());
            this.getFileDetails(this.m_bClientFile);
            this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(false);
            DeviceTypeInfo devType = null;
            if (null != this.m_oSelectedDeviceTypeList) {
                devType = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(0);
            }
            this.updatePatchVersionFiled(devType);
            return;
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    private AsnSAMImportFileReq getSAMImportReq() {
        String strSelectedFileName;
        int iLastIndex;
        AsnSAMImportFileReq oAsnSAMImportFileReq = new AsnSAMImportFileReq();
        int iImportMode = 0;
        DeviceTypeInfo oDevTypeInfo = null;
        String strPatchVer = "";
        int iDevTypeSize = this.m_oSelectedDeviceTypeList.size();
        for (int i = 0; i < iDevTypeSize; ++i) {
            oDevTypeInfo = (DeviceTypeInfo)this.m_oSelectedDeviceTypeList.get(i);
            AsnDevTypeIdInfo oAsnDevTypeIdInfo = new AsnDevTypeIdInfo();
            oAsnDevTypeIdInfo.iDevTypeId = BigInteger.valueOf(oDevTypeInfo.getDevTypeID());
            oAsnDevTypeIdInfo.iDevTypeVerId = BigInteger.valueOf(oDevTypeInfo.getDevTypeVersionId());
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oDevTypeIdInfoList.add((Object)oAsnDevTypeIdInfo);
        }
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strFileName = this.m_strNewFilePath.getBytes();
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strDescription = this.m_oDescriptionTextArea.getText().trim().getBytes();
        String strVersion = this.m_oDevVersionTextField.getText().toUpperCase().trim();
        if (this.m_oUseExistingVerCheckBox.isSelected()) {
            strVersion = (String)this.m_oDevVersionComboBox.getSelectedItem();
        }
        this.strSamVersion = strVersion = this.getVersionNodeForUpdate(strVersion);
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strVersion = strVersion.getBytes();
        this.strSamPatchVer = strPatchVer = this.m_oDevPatchVersionTextField.getText().trim();
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strPatchVersion = strPatchVer.getBytes();
        if (null != this.m_oSAMFileInfo) {
            if (this.m_oSAMFileInfo.isHaveMultiDevVer()) {
                strVersion = (String)this.oDevVersionComboBox.getSelectedItem();
                oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strVersion = strVersion.getBytes();
                oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strBDVersion = "".getBytes();
            } else {
                oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strBDVersion = this.m_oSAMFileInfo.getBDVersion().getBytes();
            }
        } else {
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strBDVersion = "".getBytes();
        }
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oSAMT2000FileLst = new AsnSAMT2000FileLst();
        if (this.isSelectWholeVersion()) {
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.iFileType = BigInteger.valueOf(0L);
            String strFileSize = "0";
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strSize = strFileSize.getBytes();
            iImportMode = 1;
        } else {
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.iFileType = BigInteger.valueOf(this.m_oSAMFileInfo.getFileType().getContentTypeCode());
            oAsnSAMImportFileReq.oAsnSAMFileInfo.oFileInfo.strSize = this.m_oSAMFileInfo.getFileSize().getBytes();
            iImportMode = 0;
        }
        AsnImportModeEnum oAsnImportModeEnum = new AsnImportModeEnum();
        oAsnImportModeEnum.value = iImportMode;
        oAsnSAMImportFileReq.oAsnSAMFileInfo.enImportMode = oAsnImportModeEnum;
        oAsnSAMImportFileReq.oAsnSAMFileInfo.oAsnFileLst = new AsnFileLst();
        if (this.isSelectWholeVersion()) {
            Set oSAMFileNameSet = this.m_oWholeVersionFileListMap.keySet();
            for (String strFileName : oSAMFileNameSet) {
                int iContentType = (Integer)this.m_oWholeVersionFileListMap.get(strFileName);
                AsnFileInfo oAsnFileInfo = new AsnFileInfo();
                oAsnFileInfo.strFileName = strFileName.getBytes();
                oAsnFileInfo.iContentType = BigInteger.valueOf(iContentType);
                oAsnSAMImportFileReq.oAsnSAMFileInfo.oAsnFileLst.add((Object)oAsnFileInfo);
            }
        } else if (null != oDevTypeInfo && oDevTypeInfo.isT2000Domain()) {
            int iSize = this.m_oFileListForSFTP.size();
            for (int i = 0; i < iSize; ++i) {
                oAsnSAMImportFileReq.oAsnSAMFileInfo.oSAMT2000FileLst.add((Object)((String)this.m_oFileListForSFTP.get(i)).getBytes());
            }
        }
        String strBasePath = -1 == (iLastIndex = (strSelectedFileName = this.m_oFilePathTextField.getText().trim().replace('/', '\\')).lastIndexOf(92)) ? this.m_oFilePathTextField.getText().trim() : this.m_oFilePathTextField.getText().trim().substring(0, iLastIndex + 1);
        oAsnSAMImportFileReq.oAsnSAMFileInfo.strBasePath = strBasePath.getBytes();
        oAsnSAMImportFileReq.oAsnSAMFileInfo.bOverWrite = false;
        oAsnSAMImportFileReq.oAsnSAMFileInfo.bIsClientFile = this.m_bClientFile;
        oAsnSAMImportFileReq.oAsnSAMFileInfo._bIsClientFile = this.m_bClientFile;
        return oAsnSAMImportFileReq;
    }

    @Override
    public void notifyProgress(int iProgress) {
        if (null != this.m_oImportFileProgressBar) {
            this.m_oImportFileProgressBar.setValue(iProgress);
        }
    }

    public String getSAMVersion() {
        return this.strSamVersion;
    }

    public String getSAMPatchVer() {
        return this.strSamPatchVer;
    }

    public void clearPath() {
        strLastPath = "";
    }
}

