/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeNameInfo;
import com.huawei.dc.deviceinfo.DeviceTypeVersionInfo;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.huawei.dc.sam.view.SAMFileInfoTreePanel;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.border.TitledBorder;

public class SAMFileInfoImportDlg
extends DCModalDialog {
    private static final long serialVersionUID = -4091852139951509713L;
    protected JButton m_oApplyBtn;
    private SAMFileInfoImportPanel m_oFileInfoImportPanel;
    private SAMFileInfoTreePanel m_oImportTreePanel;
    private String m_strOperation = "Import";
    private boolean m_oCancelClicked;
    private boolean m_oApplyClicked;
    private static final char APPLY_BUTTON_MNEMONIC = 'p';
    private boolean m_bConfirmMessage;
    private int m_iContentTypeCode = -100;
    private String strSamVersion = null;
    private String strSamPatchVer = null;
    private SAMFileInfo m_oSelectedSAMFileInfo;
    private boolean mIsTelnet = false;

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        if (this.m_strOperation.equals("Import")) {
            strHelpFileName = "HELP_TOPIC_SAM_IMPORT_FILE";
        } else if (this.m_strOperation.equals("Update")) {
            strHelpFileName = "HELP_TOPIC_SAM_UPDATE_FILE";
        }
        return strHelpFileName;
    }

    public SAMFileInfoImportDlg() {
        TaskCommUtil.setSamFileImportShow(1);
        this.m_strOperation = "Import";
        this.setCancelButtonClicked(false);
        this.setConfirmMessage(false);
        this.jbInit();
        this.setApplyButtonEnable(false);
        this.enableHelpKeyValue();
        this.setDefaultCloseOperation(2);
        ObjectStore.getInstance().putObjectInstance("SAMFileInfoImportDlg", (Object)this);
    }

    public SAMFileInfoImportDlg(SAMFileInfo oSAMFileInfo) {
        this.m_oSelectedSAMFileInfo = oSAMFileInfo;
        this.m_strOperation = "Update";
        this.setCancelButtonClicked(false);
        this.setConfirmMessage(false);
        this.jbInit();
        this.setApplyButtonEnable(false);
        this.enableHelpKeyValue();
        this.setDefaultCloseOperation(0);
        ObjectStore.getInstance().putObjectInstance("SAMFileInfoImportDlg", (Object)this);
        this.m_oFileInfoImportPanel.updatePatchVersionFiled(this.m_oSelectedSAMFileInfo.getDeviceTypeInfo());
    }

    public SAMFileInfoImportDlg(DCModalDialog parentDlg, int iContentTypeCode, boolean isTelnet) {
        super(parentDlg);
        TaskCommUtil.setSamFileImportShow(2);
        this.mIsTelnet = isTelnet;
        this.m_iContentTypeCode = iContentTypeCode;
        this.m_strOperation = "Import";
        this.setCancelButtonClicked(false);
        this.setConfirmMessage(false);
        this.jbInit();
        this.setApplyButtonEnable(false);
        this.enableHelpKeyValue();
        ObjectStore.getInstance().putObjectInstance("SAMFileInfoImportDlg", (Object)this);
    }

    public SAMFileInfoImportPanel getPanel() {
        return this.m_oFileInfoImportPanel;
    }

    private void enableHelpKeyValue() {
        if (this.m_strOperation.equals("Import")) {
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SAM_IMPORT_FILE");
        } else if (this.m_strOperation.equals("Update")) {
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SAM_UPDATE_FILE");
        }
    }

    public void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_oFileInfoImportPanel = new SAMFileInfoImportPanel(this, this.m_iContentTypeCode, this.mIsTelnet, this.m_oSelectedSAMFileInfo);
        SortedMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> oDeviceTypeMap = this.getDeviceTypeMap();
        this.m_oFileInfoImportPanel.setDeviceTypeMap(oDeviceTypeMap);
        this.m_oImportTreePanel = new SAMFileInfoTreePanel(oDeviceTypeMap);
        this.m_oImportTreePanel.setName("SAM_SAMFileInfoTreePanel_m_oImportTreePanel");
        this.m_oFileInfoImportPanel.setBorder(new TitledBorder(""));
        XFtpManager.getInstance().setNotifyProgressObj(this.m_oFileInfoImportPanel);
        this.addButtons();
        if (this.m_strOperation.equals("Import")) {
            this.m_oFileInfoImportPanel.setPreferredSize(new Dimension(365, 270));
            this.m_oFileInfoImportPanel.setMinimumSize(new Dimension(365, 270));
            this.setSize(600, 350);
            this.getContentPane().add((Component)this.m_oFileInfoImportPanel, new GridBagConstraints(2, 0, 4, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 10, 5), 0, 0));
            this.m_oImportTreePanel.setPreferredSize(new Dimension(200, 270));
            this.m_oImportTreePanel.setMinimumSize(new Dimension(200, 270));
            this.m_oImportTreePanel.setImportPanel(this.m_oFileInfoImportPanel);
            this.m_oFileInfoImportPanel.setSAMFileInfoTreePanel(this.m_oImportTreePanel);
            this.m_oFileInfoImportPanel.updateComponentsForImport();
            this.getContentPane().add((Component)this.m_oApplyBtn, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 110, 0, 10), 0, 0));
            this.m_oFileInfoImportPanel.updateContentTypeComboBox();
            this.getContentPane().add((Component)this.m_oImportTreePanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        } else {
            this.m_oFileInfoImportPanel.setPreferredSize(new Dimension(365, 262));
            this.m_oFileInfoImportPanel.setMinimumSize(new Dimension(365, 262));
            this.setSize(392, 343);
            this.getContentPane().add((Component)this.m_oFileInfoImportPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 18, 0, new Insets(5, 10, 10, 5), 0, 0));
            this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 205, 0, 10), 0, 0));
            this.m_oFileInfoImportPanel.updateComponentsForUpdate();
        }
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void addButtons() {
        this.m_oApplyBtn = new JButton();
        this.m_oApplyBtn.setFocusable(false);
        this.m_oApplyBtn.setText(DCFrameWorkUtil.getLocalizedString("SYS_SETTING_APPLY_BTN"));
        this.m_oApplyBtn.setMnemonic('p');
        this.m_oApplyBtn.setFocusable(true);
        this.m_oApplyBtn.setName("SAM_SAMFileInfoImportDlg_m_oApplyBtn");
        this.m_oApplyBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oApplyBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BTN"));
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setName("SAM_SAMFileInfoImportDlg_m_oCancelBtn");
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setName("SAM_SAMFileInfoImportDlg_m_oOKBtn");
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                SAMFileInfoImportDlg.this.m_oApplyClicked = false;
                SAMFileInfoImportDlg.this.okBtnActionPerformed();
            }
        });
        this.m_oApplyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAMFileInfoImportDlg.this.m_oApplyClicked = true;
                SAMFileInfoImportDlg.this.okBtnActionPerformed();
            }
        });
    }

    public void okBtnActionPerformed() {
        if (null != this.m_oFileInfoImportPanel) {
            if (this.m_strOperation.equals("Import")) {
                if (!this.m_oFileInfoImportPanel.validateFields()) {
                    return;
                }
                if (!this.m_oApplyBtn.isEnabled()) {
                    this.m_oCancelBtn.setEnabled(false);
                    super.closeDialog();
                } else {
                    this.m_oFileInfoImportPanel.handleOkBtnActinPerformed(this.m_oApplyClicked);
                }
            } else if (this.m_strOperation.equals("Update")) {
                this.m_oFileInfoImportPanel.handleUpdateOkBtnAcionPerformed();
            }
            this.strSamVersion = this.m_oFileInfoImportPanel.getSAMVersion();
            this.strSamPatchVer = this.m_oFileInfoImportPanel.getSAMPatchVer();
        }
    }

    public SAMFileInfoImportPanel getSAMFileImportPanel() {
        return this.m_oFileInfoImportPanel;
    }

    public SAMFileInfoTreePanel getSAMFileTreePanel() {
        return this.m_oImportTreePanel;
    }

    public void setCancelButtonClicked(boolean bClicked) {
        this.m_oCancelClicked = bClicked;
    }

    public boolean isCancelButtonClicked() {
        return this.m_oCancelClicked;
    }

    @Override
    protected void closeDialog() {
        DCDebugTracer.trace("SAMFileInfoImportDlg#closeDialog start ...");
        if (null != this.m_oFileInfoImportPanel) {
            DCDebugTracer.trace("SAMFileInfoImportDlg#closeDialog#m_oFileInfoImportPanel is not null...");
            this.m_oFileInfoImportPanel.clearPath();
            if (this.isConfirmMessage()) {
                this.setConfirmMessage(false);
            }
            if (!this.m_oCancelBtn.isEnabled()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("OPERATION_IN_PROGRESS_MSG"), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 0);
                return;
            }
            this.m_oCancelBtn.setEnabled(false);
            this.setCancelButtonClicked(true);
            this.m_oFileInfoImportPanel.handleCancelBtnActinPerformed();
            XFtpManager.getInstance().setNotifyProgressObj(null);
            super.closeDialog();
        }
        DCDebugTracer.trace("SAMFileInfoImportDlg#closeDialog end ...");
    }

    public void setOkButtonEnable(boolean bFlag) {
        this.m_oOKBtn.setEnabled(bFlag);
    }

    public void setApplyButtonEnable(boolean bFlag) {
        this.m_oApplyBtn.setEnabled(bFlag);
    }

    public JButton getApplyButton() {
        return this.m_oApplyBtn;
    }

    public void setCancelButtonEnable(boolean bFlag) {
        this.m_oCancelBtn.setEnabled(bFlag);
    }

    public boolean isConfirmMessage() {
        return this.m_bConfirmMessage;
    }

    public void setConfirmMessage(boolean bConfirmMessage) {
        this.m_bConfirmMessage = bConfirmMessage;
    }

    private SortedMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> getDeviceTypeMap() {
        TreeMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>> oDeviceTypeMap = new TreeMap<DeviceTypeNameInfo, List<DeviceTypeVersionInfo>>();
        DeviceTypeInfo[] deviceTypeList = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypes();
        if (null == deviceTypeList) {
            return null;
        }
        ArrayList<DeviceTypeVersionInfo> oDevTypeVerList = null;
        int iDevTypeSize = deviceTypeList.length;
        DeviceTypeNameInfo oDeviceTypeNameInfo = null;
        DeviceTypeVersionInfo oDevTypeVerInfo = null;
        String strDevTypeName = null;
        String strDevTypeVersionName = null;
        for (int i = 0; i < iDevTypeSize; ++i) {
            strDevTypeName = deviceTypeList[i].getDevTypeName();
            int iDevTypeId = deviceTypeList[i].getDevTypeID();
            int iDevDomain = deviceTypeList[i].getDevDomain();
            oDeviceTypeNameInfo = new DeviceTypeNameInfo(iDevTypeId, StringUtils.removePostfix(strDevTypeName, "_telnet"), iDevDomain);
            oDevTypeVerList = (ArrayList<DeviceTypeVersionInfo>)oDeviceTypeMap.get(oDeviceTypeNameInfo);
            if (null == oDevTypeVerList) {
                oDevTypeVerList = new ArrayList<DeviceTypeVersionInfo>(0);
                oDeviceTypeMap.put(oDeviceTypeNameInfo, oDevTypeVerList);
            }
            int iDevTypeVersionId = deviceTypeList[i].getDevTypeVersionId();
            strDevTypeVersionName = deviceTypeList[i].getDevTypeVersionName();
            oDevTypeVerInfo = new DeviceTypeVersionInfo(iDevTypeVersionId, StringUtils.removePostfix(strDevTypeVersionName, "_telnet"), oDeviceTypeNameInfo);
            oDevTypeVerList.add(oDevTypeVerInfo);
        }
        return oDeviceTypeMap;
    }

    public String getOperation() {
        return this.m_strOperation;
    }

    @Override
    public void doCleanUp() {
        ObjectStore.getInstance().removeObjectInstance("SAMFileInfoImportDlg");
        DCCleanupUtil.cleanupComponent(this.m_oApplyBtn);
        this.m_oApplyBtn = null;
        this.m_oFileInfoImportPanel.doCleanUp();
        this.m_oFileInfoImportPanel = null;
        this.m_oImportTreePanel.doCleanUp();
        this.m_oImportTreePanel = null;
        TaskCommUtil.setSamFileImportShow(0);
        super.doCleanUp();
    }

    public void updateTaskTargetVersion() {
        TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
        if (null != oTaskMgmtOperationSelecPanel) {
            if (null != this.m_oFileInfoImportPanel) {
                this.strSamVersion = this.m_oFileInfoImportPanel.getSAMVersion();
                this.strSamPatchVer = this.m_oFileInfoImportPanel.getSAMPatchVer();
            }
            oTaskMgmtOperationSelecPanel.setTargetVersionComboBox(this.strSamVersion, this.strSamPatchVer, true, this.isCancelButtonClicked());
        }
    }

    public void setStrSamVersion(String str) {
        this.strSamVersion = str;
    }

    public String getStrSamVersion(String str) {
        return this.strSamVersion;
    }
}

