/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnFileInfo;
import com.huawei.dc.common.asndatacenter.AsnFileLst;
import com.huawei.dc.common.asndatacenter.AsnSAMGetFileDetailsRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMImportFileReq;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TextFieldFilter;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.sam.view.SAMFileInfoImportPanelHelper;
import com.huawei.dc.sam.view.SAMFileInfoTreePanel;
import com.huawei.dc.sam.view.SAMImportTreeNodeInfo;
import com.huawei.dc.sam.view.SAMProgressBar;
import com.huawei.u2000.framework.help.HelpLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;

public abstract class AbstractSAMFileInfoImportPanel
extends JPanel {
    private static final long serialVersionUID = 5558759425230596542L;
    protected JLabel m_oFilePathLabel = null;
    protected JLabel m_oFilePathLabel_Asterisk;
    protected JLabel m_oDeviceTypeLabel;
    protected JLabel m_oDeviceVersionLabel;
    public JLabel m_oDevicePatchVersionLabel;
    public JTextField m_oDevPatchVersionTextField;
    protected JLabel m_oDeviceVersionLabel_Asterisk;
    protected JLabel m_oContentTypeLabel;
    protected JLabel m_oContentTypeLabel_Asterisk;
    protected JLabel m_oDescriptionLabel;
    public DCFilePathTextField m_oFilePathTextField = null;
    public JTextField m_oDevVersionTextField = null;
    protected ComboBoxWithToolTip m_oDevVersionComboBox = null;
    protected ComboBoxWithToolTip oDevVersionComboBox = null;
    protected TextFieldFilter m_oDevVersionTextFilter;
    public JTextField m_oDescriptionTextArea = null;
    protected TextFieldFilter m_oDescriptionTextFilter;
    protected ComboBoxWithToolTip m_oDeviceTypeComboBox = null;
    protected ComboBoxWithToolTip m_oContentTypeComboBox = null;
    protected JCheckBox m_oUseExistingVerCheckBox = null;
    protected JButton m_oFilePathBrowseButton = null;
    protected SAMProgressBar m_oImportFileProgressBar = null;
    protected SAMFileInfoImportDlg m_oSAMFileInfoImportDlg;
    protected String m_strNewFilePath = "";
    protected String m_autoObtainVersion = "";
    protected ISAMFileInfo m_oSAMFileInfo;
    protected DeviceTypeInfo curDevTypeInfo = null;
    protected ISAMManager m_oSAMManager;
    protected Object m_oSyncObject;
    protected List<String> m_oFileListForSFTP = new ArrayList<String>(0);
    protected boolean m_bClientFile = false;
    protected boolean m_oApplyClicked;
    protected String m_strServerBrowsePath = "";
    protected String m_strClientBrowsePath = "";
    protected List<String> m_oWholeVersionFileList;
    protected Map m_oWholeVersionFileListMap = new HashMap(0);
    protected int m_iReqID = -1;
    protected boolean m_bIsCancelled = false;
    protected int m_iContentTypeCode = 0;
    protected List<DeviceTypeInfo> m_oSelectedDeviceTypeList = new ArrayList<DeviceTypeInfo>(0);
    protected SAMFileInfoTreePanel m_oSAMFileInfoTreePanel;
    protected int m_iOperationID = 26;
    private HelpLabel filetypehelpLable = null;
    protected boolean mIsTelnet = false;
    protected boolean bAutoChange = false;
    private Color originFieldBGColor = null;

    public AbstractSAMFileInfoImportPanel() {
        this.setLayout(new GridBagLayout());
        this.setName("SAM_SAMFileInfoImportPanel_this");
    }

    protected void jbInit() {
        this.initializeLabels();
        this.initializeTextFields();
        this.initCheckBox();
        this.initializeComboBoxes();
        this.initializeButtons();
        this.initializeProgressBar();
        this.setPreferredSizeForComponents();
        this.setMinimumSizeForComponents();
        this.addComponents();
        this.updatePatchVersionFiled(null);
        this.updateUI();
    }

    private void addComponents() {
        int y = 0;
        this.add((Component)this.m_oDeviceTypeLabel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oDeviceTypeComboBox, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_oContentTypeLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 21, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oContentTypeComboBox, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        if (!DCFrameWorkUtil.isHelpIDFormSA()) {
            this.add((Component)this.filetypehelpLable, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        }
        this.add((Component)this.m_oContentTypeLabel_Asterisk, new GridBagConstraints(5, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_oFilePathLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oFilePathTextField, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 1), 0, 0));
        this.add((Component)this.m_oFilePathBrowseButton, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 17, 3, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_oFilePathLabel_Asterisk, new GridBagConstraints(5, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_oUseExistingVerCheckBox, new GridBagConstraints(0, ++y, 4, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.add((Component)this.m_oDeviceVersionLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oDevVersionTextField, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_oDeviceVersionLabel_Asterisk, new GridBagConstraints(5, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_oDevicePatchVersionLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oDevPatchVersionTextField, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_oDescriptionLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_oDescriptionTextArea, new GridBagConstraints(1, y, 4, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.m_oImportFileProgressBar, new GridBagConstraints(0, ++y, 5, 2, 1.0, 0.0, 10, 0, new Insets(0, 5, 10, 0), 0, 0));
    }

    private void setMinimumSizeForComponents() {
        this.m_oDeviceTypeComboBox.setMinimumSize(new Dimension(255, 21));
        this.m_oContentTypeComboBox.setMinimumSize(new Dimension(230, 21));
        this.filetypehelpLable.setMinimumSize(new Dimension(21, 21));
        this.m_oFilePathTextField.setMinimumSize(new Dimension(230, 21));
        this.m_oFilePathBrowseButton.setMinimumSize(new Dimension(20, 20));
        this.m_oUseExistingVerCheckBox.setMinimumSize(new Dimension(250, 20));
        this.m_oDevVersionTextField.setMinimumSize(new Dimension(255, 21));
        this.m_oDevPatchVersionTextField.setMinimumSize(new Dimension(255, 21));
        this.m_oDevVersionComboBox.setMinimumSize(new Dimension(255, 21));
        this.oDevVersionComboBox.setMinimumSize(new Dimension(255, 21));
        this.m_oDescriptionTextArea.setMinimumSize(new Dimension(255, 21));
        this.m_oDeviceTypeLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oContentTypeLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oContentTypeLabel_Asterisk.setMinimumSize(new Dimension(10, 20));
        this.m_oFilePathLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oFilePathLabel_Asterisk.setMinimumSize(new Dimension(10, 20));
        this.m_oDeviceVersionLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oDeviceVersionLabel_Asterisk.setMinimumSize(new Dimension(10, 20));
        this.m_oDevicePatchVersionLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oDescriptionLabel.setMinimumSize(new Dimension(100, 20));
        this.m_oImportFileProgressBar.setMinimumSize(new Dimension(345, 40));
    }

    private void setPreferredSizeForComponents() {
        this.m_oDeviceTypeComboBox.setPreferredSize(new Dimension(255, 21));
        this.m_oContentTypeComboBox.setPreferredSize(new Dimension(230, 21));
        this.filetypehelpLable.setPreferredSize(new Dimension(21, 21));
        this.m_oFilePathTextField.setPreferredSize(new Dimension(230, 21));
        this.m_oFilePathBrowseButton.setPreferredSize(new Dimension(20, 20));
        this.m_oUseExistingVerCheckBox.setPreferredSize(new Dimension(250, 20));
        this.m_oDevVersionTextField.setPreferredSize(new Dimension(255, 21));
        this.m_oDevPatchVersionTextField.setPreferredSize(new Dimension(255, 21));
        this.m_oDevVersionComboBox.setPreferredSize(new Dimension(255, 21));
        this.oDevVersionComboBox.setMinimumSize(new Dimension(255, 21));
        this.m_oDescriptionTextArea.setPreferredSize(new Dimension(255, 21));
        this.m_oDeviceTypeLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oContentTypeLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oContentTypeLabel_Asterisk.setPreferredSize(new Dimension(10, 20));
        this.m_oFilePathLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oFilePathLabel_Asterisk.setPreferredSize(new Dimension(10, 20));
        this.m_oDeviceVersionLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oDeviceVersionLabel_Asterisk.setPreferredSize(new Dimension(10, 20));
        this.m_oDescriptionLabel.setPreferredSize(new Dimension(100, 20));
        this.m_oImportFileProgressBar.setPreferredSize(new Dimension(345, 40));
    }

    private void initCheckBox() {
        this.m_oUseExistingVerCheckBox = new JCheckBox();
        this.m_oUseExistingVerCheckBox.setName("SAM_SAMFileInfoImportPanel_m_oUseExistingVerCheckBox");
        this.m_oUseExistingVerCheckBox.setText(DCFrameWorkUtil.getLocalizedString("SAM_USE_EXISTING_CHECKBOX_LABEL"));
        this.m_oUseExistingVerCheckBox.addActionListener(this.generateActionListenerForUseVersionCheckBox());
        this.m_oUseExistingVerCheckBox.setFocusable(false);
        this.enableUseExistingVerCheckBox(false);
    }

    private ActionListener generateActionListenerForUseVersionCheckBox() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractSAMFileInfoImportPanel.this.m_oUseExistingVerCheckBox.isSelected()) {
                    AbstractSAMFileInfoImportPanel.this.removeComponentToPanel(AbstractSAMFileInfoImportPanel.this.m_oDevVersionTextField);
                    AbstractSAMFileInfoImportPanel.this.removeComponentToPanel(AbstractSAMFileInfoImportPanel.this.oDevVersionComboBox);
                    AbstractSAMFileInfoImportPanel.this.addComponentToPanel(AbstractSAMFileInfoImportPanel.this.m_oDevVersionComboBox);
                    AbstractSAMFileInfoImportPanel.this.loadDevVersionDropDown();
                } else {
                    AbstractSAMFileInfoImportPanel.this.m_oDevVersionTextField.setText(AbstractSAMFileInfoImportPanel.this.m_autoObtainVersion);
                    DCDebugTracer.trace("reset version info!");
                    AbstractSAMFileInfoImportPanel.this.removeComponentToPanel(AbstractSAMFileInfoImportPanel.this.m_oDevVersionComboBox);
                    if (null != AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfo && AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfo.isHaveMultiDevVer()) {
                        AbstractSAMFileInfoImportPanel.this.initDevVersionList();
                        AbstractSAMFileInfoImportPanel.this.removeComponentToPanel(AbstractSAMFileInfoImportPanel.this.m_oDevVersionTextField);
                        AbstractSAMFileInfoImportPanel.this.addComponentToPanel(AbstractSAMFileInfoImportPanel.this.oDevVersionComboBox);
                    } else {
                        AbstractSAMFileInfoImportPanel.this.removeComponentToPanel(AbstractSAMFileInfoImportPanel.this.oDevVersionComboBox);
                        AbstractSAMFileInfoImportPanel.this.addComponentToPanel(AbstractSAMFileInfoImportPanel.this.m_oDevVersionTextField);
                    }
                }
                AbstractSAMFileInfoImportPanel.this.updatePanelUI();
            }
        };
    }

    private void addComponentToPanel(Component oComponent) {
        this.add(oComponent, new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void removeComponentToPanel(Component oComponent) {
        this.remove(oComponent);
    }

    private void updatePanelUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractSAMFileInfoImportPanel.this.updateUI();
            }
        });
    }

    private void initializeProgressBar() {
        this.m_oImportFileProgressBar = new SAMProgressBar();
        this.m_oImportFileProgressBar.setName("SAM_SAMFileInfoImportPanel_m_oImportFileProgressBar");
        this.m_oImportFileProgressBar.setVisible(false);
    }

    private void initializeLabels() {
        this.m_oDeviceTypeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_DEVICE_TYPE_LABEL"));
        this.m_oContentTypeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_CONTENT_TYPE_LABEL"));
        this.m_oContentTypeLabel_Asterisk = new JLabel("*");
        this.m_oContentTypeLabel_Asterisk.setForeground(Color.RED);
        this.m_oFilePathLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_FILE_PATH_LABEL"));
        this.m_oFilePathLabel_Asterisk = new JLabel("*");
        this.m_oFilePathLabel_Asterisk.setForeground(Color.RED);
        this.m_oDeviceVersionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_DEVICE_VERSION_LABEL"));
        this.m_oDeviceVersionLabel_Asterisk = new JLabel("*");
        this.m_oDeviceVersionLabel_Asterisk.setForeground(Color.RED);
        this.m_oDevicePatchVersionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_PATCH_VERSION_LABEL"));
        this.m_oDescriptionLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("SAM_IMPORT_PANEL_DESCRIPTION_LABEL"));
    }

    private void initializeTextFields() {
        this.initPathTextField();
        this.initDevVerTextField();
        this.initPatchDevVerTextField();
        this.initDescTextField();
    }

    private void initDescTextField() {
        this.m_oDescriptionTextArea = new JTextField();
        this.m_oDescriptionTextArea.setName("SAM_SAMFileInfoImportPanel_m_oDescriptionTextArea");
        AbstractDocument aoDesc = (AbstractDocument)this.m_oDescriptionTextArea.getDocument();
        this.m_oDescriptionTextFilter = new TextFieldFilter(100);
        aoDesc.setDocumentFilter(this.m_oDescriptionTextFilter);
        this.m_oDescriptionTextArea.addMouseMotionListener(this.generateMouseListenerAdapter(this.m_oDescriptionTextArea));
        this.m_oDescriptionTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (null != AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                    AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(true);
                }
            }
        });
    }

    private void initDevVerTextField() {
        this.m_oDevVersionTextField = new JTextField();
        this.m_oDevVersionTextField.setName("SAM_SAMFileInfoImportPanel_m_oDevVersionTextField");
        AbstractDocument aoVer = (AbstractDocument)this.m_oDevVersionTextField.getDocument();
        this.m_oDevVersionTextFilter = new TextFieldFilter(100);
        aoVer.setDocumentFilter(this.m_oDevVersionTextFilter);
        this.m_oDevVersionTextField.addMouseMotionListener(this.generateMouseListenerAdapter(this.m_oDevVersionTextField));
        this.m_oDevVersionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (null != AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                    AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(true);
                }
            }
        });
    }

    private void initPatchDevVerTextField() {
        this.m_oDevPatchVersionTextField = new JTextField();
        this.m_oDevPatchVersionTextField.setName("SAM_SAMFileInfoImportPanel_m_oDevPatchVersionTextField");
        this.m_oDevPatchVersionTextField.addMouseMotionListener(this.generateMouseListenerAdapter(this.m_oDevPatchVersionTextField));
        this.m_oDevPatchVersionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (null != AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                    AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(true);
                }
            }
        });
        this.originFieldBGColor = this.m_oDevPatchVersionTextField.getBackground();
    }

    private void initPathTextField() {
        this.m_oFilePathTextField = new DCFilePathTextField();
        this.m_oFilePathTextField.setEditable(false);
        this.m_oFilePathTextField.setDisabledTextColor(Color.BLACK);
        this.m_oFilePathTextField.addMouseMotionListener(this.generateMouseListenerAdapter(this.m_oFilePathTextField));
        this.m_oFilePathTextField.setName("SAM_SAMFileInfoImportPanel_m_oFilePathTextField");
    }

    private void initializeComboBoxes() {
        this.m_oDeviceTypeComboBox = new ComboBoxWithToolTip();
        this.m_oDeviceTypeComboBox.setName("SAM_SAMFileInfoImportPanel_m_oDeviceTypeComboBox");
        this.createContentTypeDropDown();
        this.createPatchVerComboBox();
        this.createUseExistingVerComboBox();
    }

    private void createUseExistingVerComboBox() {
        this.m_oDevVersionComboBox = new ComboBoxWithToolTip();
        this.m_oDevVersionComboBox.setName("SAM_SAMFileInfoImportPanel_m_oDevVersionComboBox");
    }

    private void createPatchVerComboBox() {
        this.oDevVersionComboBox = new ComboBoxWithToolTip();
        this.oDevVersionComboBox.setName("SAM_SAMFileInfoImportPanel_oDevVersionComboBox");
        this.oDevVersionComboBox.setEditable(true);
    }

    private void initializeButtons() {
        this.m_oFilePathBrowseButton = new JButton("...");
        this.m_oFilePathBrowseButton.setName("SAM_SAMFileInfoImportPanel_m_oFilePathBrowseButton");
        this.m_oFilePathBrowseButton.setToolTipText(DCFrameWorkUtil.getLocalizedString("BROWSE_TOOLTIP"));
        this.addFilePathBtnActionListener();
    }

    private void addFilePathBtnActionListener() {
        this.m_oFilePathBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSAMFileInfoImportPanel.this.browseBtnActionPerformed();
            }
        });
    }

    protected abstract void browseBtnActionPerformed();

    public void setTextFieldsEmpty() {
        this.m_oFilePathTextField.setText("");
        this.m_oDevVersionComboBox.removeAllItems();
        this.oDevVersionComboBox.removeAllItems();
        this.m_oDescriptionTextArea.setText("");
        this.m_oDevVersionTextField.setText("");
        this.m_oDevPatchVersionTextField.setText("");
        this.m_oUseExistingVerCheckBox.setSelected(false);
        this.enableUseExistingVerCheckBox(false);
        this.removeComponentToPanel(this.m_oDevVersionComboBox);
        this.addComponentToPanel(this.m_oDevVersionTextField);
        this.updatePanelUI();
    }

    protected void setVisibleProgressBar() {
        this.m_oImportFileProgressBar.setValue(0);
        this.m_oImportFileProgressBar.setVisible(true);
    }

    protected void fillWholeVersionFileListMap(AsnFileLst oAsnFileLst, List<String> oFileNameLst) {
        this.m_oWholeVersionFileList = new ArrayList<String>(0);
        this.m_oWholeVersionFileList.clear();
        this.m_oWholeVersionFileListMap.clear();
        int iSize = oAsnFileLst.size();
        String strFileName = null;
        for (int i = 0; i < iSize; ++i) {
            AsnFileInfo oAsnFileInfo = (AsnFileInfo)oAsnFileLst.get(i);
            strFileName = new String(oAsnFileInfo.strFileName).trim();
            int iContentType = oAsnFileInfo.iContentType.intValue();
            boolean bIsFileExist = oAsnFileInfo.bIsExist;
            if (this.m_bClientFile) {
                if (!bIsFileExist) {
                    this.m_oWholeVersionFileList.add(strFileName);
                    if (!this.isSelectWholeVersion()) {
                        oFileNameLst.add(strFileName);
                    }
                }
                this.m_oWholeVersionFileListMap.put(strFileName, iContentType);
                continue;
            }
            if (bIsFileExist) {
                this.m_oWholeVersionFileListMap.put(strFileName, iContentType);
                this.m_oWholeVersionFileList.add(strFileName);
                continue;
            }
            oFileNameLst.add(strFileName);
        }
    }

    protected void setSAMFileInfo(AsnSAMGetFileDetailsRsp oFileDetailsRsp) {
        this.m_oSAMFileInfo = new SAMFileInfo();
        if (0 != this.m_oSelectedDeviceTypeList.size()) {
            this.m_oSAMFileInfo.setDeviceTypeInfo(this.m_oSelectedDeviceTypeList.get(0));
        }
        this.m_oSAMFileInfo.setFileName(new String(oFileDetailsRsp.oSAMFileInfo.strFileName));
        this.m_oSAMFileInfo.setFileSize(new String(oFileDetailsRsp.oSAMFileInfo.strSize));
        this.m_oSAMFileInfo.setFileType((ContentType)this.m_oContentTypeComboBox.getSelectedItem());
        this.m_oSAMFileInfo.setFileDescription(new String(oFileDetailsRsp.oSAMFileInfo.strDescription));
        this.m_oSAMFileInfo.setVersion(new String(oFileDetailsRsp.oSAMFileInfo.strVersion));
        this.m_oSAMFileInfo.setBDVersion(new String(oFileDetailsRsp.oSAMFileInfo.strBDVersion));
        DCStringList vers = oFileDetailsRsp.oSAMFileInfo.strMultiVersionLst;
        int length = vers.size();
        Vector<String> verList = new Vector<String>();
        byte[] strVer = null;
        for (int i = 0; i < length; ++i) {
            strVer = (byte[])vers.get(i);
            verList.add(new String(strVer));
        }
        this.m_oSAMFileInfo.setMultiVersionLst(verList);
        if (this.m_oSAMFileInfo.isHaveMultiDevVer()) {
            this.initDevVersionList();
            this.removeComponentToPanel(this.m_oDevVersionTextField);
            this.addComponentToPanel(this.oDevVersionComboBox);
        } else {
            if (null != oFileDetailsRsp.oSAMFileInfo.strPatchVersion) {
                this.m_oSAMFileInfo.setPatchVer(new String(oFileDetailsRsp.oSAMFileInfo.strPatchVersion));
            }
            this.removeComponentToPanel(this.oDevVersionComboBox);
            this.addComponentToPanel(this.m_oDevVersionTextField);
        }
        this.updatePanelUI();
    }

    protected void initDevVersionList() {
        this.oDevVersionComboBox.removeAllItems();
        List<String> verList = this.m_oSAMFileInfo.getMultiVersionLst();
        int length = verList.size();
        for (int i = 0; i < length; ++i) {
            this.oDevVersionComboBox.addItem(verList.get(i));
        }
    }

    protected void enableComponentsForGettingFileInfo(boolean bFlag) {
        this.m_oSAMFileInfoTreePanel.setTreeEnable(bFlag);
        this.m_oContentTypeComboBox.setEnabled(bFlag);
        this.m_oFilePathBrowseButton.setEnabled(bFlag);
        if (null != this.m_oDevPatchVersionTextField) {
            this.m_oDevPatchVersionTextField.setEnabled(bFlag);
        }
        this.m_oDevVersionTextField.setEnabled(bFlag);
        this.m_oDescriptionTextArea.setEnabled(bFlag);
        if (null != this.m_oSAMFileInfoImportDlg.getApplyButton()) {
            this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(bFlag);
        }
        this.m_oSAMFileInfoImportDlg.setOkButtonEnable(bFlag);
    }

    protected void cancelImportOperation(final ISAMFileInfo oSAMFileInfo, final int iOperationID) {
        DCDebugTracer.trace("AbstractSAMFileInfoImportPanel#cancelImportOperation");
        this.m_oImportFileProgressBar.setText(DCFrameWorkUtil.getLocalizedString("SAM_CANCELLING_IMPORT_FILES"));
        this.m_bIsCancelled = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractSAMFileInfoImportPanel.this.m_oSAMManager.deleteTempFiles(oSAMFileInfo, AbstractSAMFileInfoImportPanel.this.m_iReqID, iOperationID);
            }
        });
    }

    protected boolean validateFieldsForUpdate() {
        boolean bRetVal = true;
        if (!this.m_oUseExistingVerCheckBox.isSelected() && 0 == this.m_oDevVersionTextField.getText().trim().length()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_VERSION"));
            bRetVal = false;
        } else if (this.m_oUseExistingVerCheckBox.isSelected() && -1 == this.m_oDevVersionComboBox.getSelectedIndex()) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_ERROR_BLANK_VERSION"));
            bRetVal = false;
        } else if (!SAMFileInfoImportPanelHelper.isNameValid(this.m_oDevVersionTextField.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_VERSION"));
            bRetVal = false;
        }
        if (null != this.m_oDevPatchVersionTextField && !SAMFileInfoImportPanelHelper.isNameValid(this.m_oDevPatchVersionTextField.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_PatchVersion"));
            bRetVal = false;
        }
        if (!SAMFileInfoImportPanelHelper.isNameValid(this.m_oDescriptionTextArea.getText())) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("INVALID_CHAR_IN_DESCRIPTION"));
            bRetVal = false;
        }
        return bRetVal;
    }

    protected boolean handImportFileFailed(DeviceTypeInfo oDevTypeInfo, int iCmdCode, AsnSAMImportFileReq oAsnSAMImportFileReq, DCException e) {
        boolean isFailed = false;
        if (989855899 == e.getErrorCode()) {
            isFailed = this.handFileRepeat(oDevTypeInfo, iCmdCode, oAsnSAMImportFileReq);
        } else {
            if (!this.isSelectWholeVersion() && (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE") || oDevTypeInfo.isT2000Domain()) && this.m_bClientFile) {
                XFtpManager.getInstance().unregisterForNotification(43867);
            }
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            isFailed = true;
        }
        return isFailed;
    }

    private boolean handFileRepeat(DeviceTypeInfo oDevTypeInfo, int iCmdCode, AsnSAMImportFileReq oAsnSAMImportFileReq) {
        boolean isOverWrite = false;
        int iConfirm = -1;
        iConfirm = !this.isSelectWholeVersion() ? DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_OVERWRITE_CONFIRNMATION_MESSAGE"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0) : DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_VERSION_OVERWRITE_CONFIRNMATION_MESSAGE"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0);
        if (iConfirm != 0) {
            return isOverWrite;
        }
        this.m_oSAMFileInfoImportDlg.setConfirmMessage(true);
        if (!this.isSelectWholeVersion()) {
            oAsnSAMImportFileReq.oAsnSAMFileInfo.bOverWrite = true;
            try {
                this.m_iReqID = this.m_oSAMManager.importSoftware(oAsnSAMImportFileReq, iCmdCode);
                isOverWrite = true;
            }
            catch (DCException e1) {
                if (!this.isSelectWholeVersion() && (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE") || oDevTypeInfo.isT2000Domain()) && this.m_bClientFile) {
                    XFtpManager.getInstance().unregisterForNotification(43867);
                }
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), e1.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.m_oSAMFileInfoImportDlg.setConfirmMessage(false);
                isOverWrite = false;
                return isOverWrite;
            }
            SAMFileInfo oSAMFileInfo = new SAMFileInfo();
            oSAMFileInfo.setDeviceTypeInfo(oDevTypeInfo);
            String strVersion = this.m_oDevVersionTextField.getText().toUpperCase().trim();
            if (this.m_oUseExistingVerCheckBox.isSelected()) {
                strVersion = (String)this.m_oDevVersionComboBox.getSelectedItem();
            }
            strVersion = this.getVersionNodeForUpdate(strVersion);
            oSAMFileInfo.setVersion(strVersion);
            if (this.isSelectWholeVersion()) {
                oSAMFileInfo.setFileType(new ContentType(0, ""));
            } else {
                oSAMFileInfo.setFileType(this.m_oSAMFileInfo.getFileType());
            }
            oSAMFileInfo.setFileName(this.extractFileName(this.m_oFilePathTextField.getPath().trim()));
            oSAMFileInfo.setFileDescription(this.m_oDescriptionTextArea.getText().trim());
            if (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE") || oDevTypeInfo.isT2000Domain() || oDevTypeInfo.isDMSDomain()) {
                SAMFileInfoImportPanelHelper.deleteDBUpdateFileInfoFrmLocalFileList(oSAMFileInfo);
            } else {
                SAMFileInfoImportPanelHelper.deleteFileInfoFromLocalFileLst(oSAMFileInfo);
            }
        } else {
            oAsnSAMImportFileReq.oAsnSAMFileInfo.bOverWrite = true;
            try {
                this.m_iReqID = this.m_oSAMManager.importSoftware(oAsnSAMImportFileReq, iCmdCode);
                isOverWrite = true;
            }
            catch (DCException e1) {
                if (!this.isSelectWholeVersion() && (((ContentType)this.m_oContentTypeComboBox.getSelectedItem()).getId().equals("DBUPDATE") || oDevTypeInfo.isT2000Domain()) && this.m_bClientFile) {
                    XFtpManager.getInstance().unregisterForNotification(43867);
                }
                DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), e1.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
                this.m_oSAMFileInfoImportDlg.setConfirmMessage(false);
                isOverWrite = false;
                return isOverWrite;
            }
        }
        return isOverWrite;
    }

    protected void setApplyButtonClicked(boolean bFlag) {
        this.m_oApplyClicked = bFlag;
    }

    private MouseMotionAdapter generateMouseListenerAdapter(final JTextField oTextField) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                if (oTextField == AbstractSAMFileInfoImportPanel.this.m_oDevVersionTextField) {
                    oTextField.setToolTipText(ResourceManager.getInstance().getResString("SAM_IMPORT_PANEL_DEVICE_VERSION_TIP"));
                } else {
                    AbstractSAMFileInfoImportPanel.this.setToolTip(oEvent, oTextField);
                }
            }
        };
    }

    private void setToolTip(MouseEvent oEvent, JTextField oTextField) {
        oTextField.setToolTipText(oTextField.getText().trim());
    }

    protected String extractFileName(String fileName) {
        return new File(fileName).getName();
    }

    private void createContentTypeDropDown() {
        this.m_oContentTypeComboBox = new ComboBoxWithToolTip();
        this.m_oContentTypeComboBox.setName("SAM_SAMFileInfoImportPanel_m_oContentTypeComboBox");
        this.m_oContentTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int iSelectedOption;
                if (this.isNeedMessage() && !AbstractSAMFileInfoImportPanel.this.bAutoChange && 0 == (iSelectedOption = DCOptionPane.showConfirmDialog((Component)((Object)AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("SAM_DEVICE_TYPE_CHANGE_CONFIRM"), DCFrameWorkUtil.getLocalizedString("CONFIRM"), 0))) {
                    DCDebugTracer.trace("SAMFileInfoImportPanel#createContentTypeDropDown...");
                    AbstractSAMFileInfoImportPanel.this.m_oSAMManager.deleteTempFiles(AbstractSAMFileInfoImportPanel.this.m_strNewFilePath, AbstractSAMFileInfoImportPanel.this.m_iReqID);
                    AbstractSAMFileInfoImportPanel.this.setTextFieldsEmpty();
                }
                AbstractSAMFileInfoImportPanel.this.updatePatchVersionFiled(AbstractSAMFileInfoImportPanel.this.curDevTypeInfo);
                if (null != AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.getApplyButton()) {
                    AbstractSAMFileInfoImportPanel.this.m_oSAMFileInfoImportDlg.setApplyButtonEnable(true);
                }
            }

            private boolean isNeedMessage() {
                String filePath = AbstractSAMFileInfoImportPanel.this.m_oFilePathTextField.getText().trim();
                if (filePath.startsWith("slave#cfcard") || filePath.startsWith("cfcard") || filePath.startsWith("hd") || filePath.startsWith("flash") || filePath.startsWith("slot")) {
                    return false;
                }
                return AbstractSAMFileInfoImportPanel.this.m_oContentTypeComboBox.getItemCount() > 0 && !filePath.isEmpty();
            }
        });
        String strfiletypeHelpID = ResourceManager.getInstance().getResString("HELP_TOPIC_SOFT_UPGRADE_TYPE_LBL", "helpmapfile");
        this.filetypehelpLable = new HelpLabel("", strfiletypeHelpID);
        this.filetypehelpLable.setIcon((Icon)ResourceManager.getInstance().getImage("help1.png"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int loadDevVersionDropDown() {
        this.m_oDevVersionComboBox.removeAllItems();
        DeviceTypeInfo oDeviceTypeInfo = null;
        if (this.m_oSAMFileInfoImportDlg.getOperation().equals("Import")) {
            if (1 != this.m_oSelectedDeviceTypeList.size()) return 0;
            oDeviceTypeInfo = this.m_oSelectedDeviceTypeList.get(0);
        } else {
            oDeviceTypeInfo = (DeviceTypeInfo)this.m_oDeviceTypeComboBox.getSelectedItem();
        }
        String[] oVersionList = SAMDataModel.getInstance().getVersionLst(oDeviceTypeInfo);
        if (null == oVersionList) {
            return 0;
        }
        int iNoOfVersion = oVersionList.length;
        for (int j = 0; j < iNoOfVersion; ++j) {
            this.m_oDevVersionComboBox.addItem(oVersionList[j]);
        }
        if (this.m_oDevVersionComboBox.getItemCount() > 0) return 1;
        return 0;
    }

    protected String getVersionNodeForUpdate(String strVersion) {
        String strNode = strVersion;
        DeviceTypeInfo oDeviceTypeInfo = null;
        if (0 == this.m_oSelectedDeviceTypeList.size()) {
            return strNode;
        }
        oDeviceTypeInfo = this.m_oSelectedDeviceTypeList.get(0);
        String[] oVersionList = SAMDataModel.getInstance().getVersionLst(oDeviceTypeInfo);
        if (null == oVersionList) {
            return strNode;
        }
        int iNoOfVersion = oVersionList.length;
        for (int j = 0; j < iNoOfVersion; ++j) {
            if (!oVersionList[j].equalsIgnoreCase(strVersion)) continue;
            strNode = oVersionList[j];
            break;
        }
        return strNode;
    }

    private void addContentTypesToComboBox(List oContentTypeList) {
        int iNoOfXMLContentTypes = oContentTypeList.size();
        int iDefaultSelectIndex = 0;
        for (int j = 0; j < iNoOfXMLContentTypes; ++j) {
            this.bAutoChange = j < iNoOfXMLContentTypes - 1;
            ContentType oContType = (ContentType)oContentTypeList.get(j);
            this.m_oContentTypeComboBox.addItem(oContType);
            if (null == oContType || oContType.getContentTypeCode() != this.m_iContentTypeCode) continue;
            iDefaultSelectIndex = j;
        }
        this.m_oContentTypeComboBox.setSelectedIndex(iDefaultSelectIndex);
    }

    public void enableUseExistingVerCheckBox(boolean bFlag) {
        this.m_oUseExistingVerCheckBox.setEnabled(bFlag);
    }

    public void updatePatchVersionFiled(DeviceTypeInfo oDevTypeInfo) {
        if (null == oDevTypeInfo) {
            this.m_oDevPatchVersionTextField.setEnabled(false);
            DCDebugTracer.trace("updatePatchVersionFiled->oDevTypeInfo is null.");
            return;
        }
        this.m_oDevicePatchVersionLabel.setVisible(true);
        this.m_oDevPatchVersionTextField.setVisible(true);
        this.m_oDevPatchVersionTextField.setEnabled(false);
        this.m_oDevPatchVersionTextField.setEditable(false);
        ContentType oContentType = (ContentType)this.m_oContentTypeComboBox.getSelectedItem();
        if (null == oContentType) {
            DCDebugTracer.trace("updatePatchVersionFiled->oContentType is null.");
            this.m_oDevPatchVersionTextField.setBackground(this.getBackground());
            return;
        }
        String strContentID = oContentType.getId();
        if (oDevTypeInfo.isBMSDomain()) {
            if ("PATCH".equals(strContentID) || "PROGRAM".equals(strContentID) || "PACKETFILE".equals(strContentID)) {
                this.m_oDevPatchVersionTextField.setEnabled(true);
                this.m_oDevPatchVersionTextField.setEditable(true);
                this.m_oDevPatchVersionTextField.setBackground(this.originFieldBGColor);
            } else {
                this.m_oDevPatchVersionTextField.setBackground(this.getBackground());
            }
        } else if (oDevTypeInfo.isDMSDomain()) {
            if ("PATCH".equals(strContentID)) {
                this.m_oDevPatchVersionTextField.setEnabled(true);
                this.m_oDevPatchVersionTextField.setEditable(true);
                this.m_oDevPatchVersionTextField.setBackground(this.originFieldBGColor);
            } else {
                this.m_oDevPatchVersionTextField.setBackground(this.getBackground());
            }
        } else if (oDevTypeInfo.isT2000Domain()) {
            if ("PATCH".equals(strContentID)) {
                this.m_oDevPatchVersionTextField.setEnabled(true);
                this.m_oDevPatchVersionTextField.setEditable(true);
                this.m_oDevPatchVersionTextField.setBackground(this.originFieldBGColor);
            } else {
                this.m_oDevPatchVersionTextField.setBackground(this.getBackground());
            }
        } else {
            DCDebugTracer.trace("do not need handle this!");
        }
    }

    public void fillContentTypeComboBox() {
        ArrayList oContentTypeList = new ArrayList(0);
        List oContentTypeLst = null;
        int iSize = 1;
        for (int i = 0; i < iSize; ++i) {
            DeviceTypeInfo oDeviceTypeInfo = this.m_oSelectedDeviceTypeList.get(i);
            if (null == oContentTypeList) continue;
            if (0 == oContentTypeList.size()) {
                oContentTypeLst = SAMFileInfoImportPanelHelper.getContentTypesFromXMLConfig(oDeviceTypeInfo, this.m_iOperationID, this.mIsTelnet);
                if (null == oContentTypeLst) continue;
                oContentTypeList.addAll(oContentTypeLst);
                continue;
            }
            oContentTypeLst = SAMFileInfoImportPanelHelper.getContentTypesFromXMLConfig(oDeviceTypeInfo, this.m_iOperationID, this.mIsTelnet);
            if (null != oContentTypeLst && 0 != oContentTypeLst.size()) {
                oContentTypeList.retainAll(oContentTypeLst);
                continue;
            }
            oContentTypeList.clear();
            break;
        }
        if (null != oContentTypeList && 0 != oContentTypeList.size()) {
            this.m_oContentTypeComboBox.removeAllItems();
            this.addContentTypesToComboBox(oContentTypeList);
        }
    }

    protected boolean addToSelectedDeviceTypeList(SAMImportTreeNodeInfo oTreeNodeInfo, DeviceTypeInfo oDevTypeInfo) {
        if (oTreeNodeInfo.getNodeType() != 1) {
            if (this.canSelectDeviceType(oDevTypeInfo)) {
                if (!this.m_oSelectedDeviceTypeList.contains(oDevTypeInfo)) {
                    this.m_oSelectedDeviceTypeList.add(oDevTypeInfo);
                }
                return true;
            }
            oTreeNodeInfo.setSelectedState(2);
            this.m_oSAMFileInfoTreePanel.handleParentNodeSelectionForError(oTreeNodeInfo, this.m_oSelectedDeviceTypeList);
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSAMFileInfoImportDlg), DCFrameWorkUtil.getLocalizedString("MULTIPLE_DEVICE_TYPE_SELECTION_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return false;
        }
        this.m_oSAMFileInfoTreePanel.handleParentNodeSelectionForError(oTreeNodeInfo, this.m_oSelectedDeviceTypeList);
        return false;
    }

    private boolean canSelectDeviceType(DeviceTypeInfo oDevTypeInfo) {
        boolean bCanSelect = true;
        int iSelectedDevTypes = this.m_oSelectedDeviceTypeList.size();
        if (0 != iSelectedDevTypes) {
            for (int i = 0; i < iSelectedDevTypes; ++i) {
                DeviceTypeInfo oDeviceTypeInfo = this.m_oSelectedDeviceTypeList.get(i);
                if (oDevTypeInfo.getDevTypeID() == oDeviceTypeInfo.getDevTypeID()) continue;
                bCanSelect = false;
                break;
            }
        }
        return bCanSelect;
    }

    protected boolean isSelectWholeVersion() {
        ContentType oSelectedContentType = (ContentType)this.m_oContentTypeComboBox.getSelectedItem();
        return null != oSelectedContentType && "WholeVersion".equals(oSelectedContentType.getId());
    }
}

