/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.model;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.sam.model.BreakPacketInfo;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMFileInfoUtil;
import java.text.Collator;
import java.util.List;
import java.util.Vector;

public class SAMFileInfo
implements ISAMFileInfo {
    private static final long serialVersionUID = -3859340548405405531L;
    private List<String> strMultiVersionLst = new Vector<String>();
    private DeviceTypeInfo m_oDeviceTypeInfo = null;
    private String m_strFileName;
    private String m_PatchVer = "";
    private ContentType m_oFileType;
    private String m_strVersion;
    private String m_strFileSize;
    private String m_strFileDescription;
    private String m_strCurrentVersion;
    private String m_strBDVersion;
    private BreakPacketInfo m_oBreakPacketInfo;
    private List<String> m_oPatchVersion;

    @Override
    public List<String> getMultiVersionLst() {
        return this.strMultiVersionLst;
    }

    @Override
    public void setMultiVersionLst(List<String> strMultiVersionLst) {
        this.strMultiVersionLst = null == strMultiVersionLst ? new Vector<String>() : strMultiVersionLst;
    }

    @Override
    public void setDeviceTypeInfo(int iDeviceTypeId, int iDeviceTypeVersionId) {
        this.m_oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDeviceTypeId, iDeviceTypeVersionId);
        this.setIfSupportsBreakPacket();
    }

    @Override
    public void setDeviceTypeInfo(DeviceTypeInfo oDeviceTypeInfo) {
        this.m_oDeviceTypeInfo = oDeviceTypeInfo;
        this.setIfSupportsBreakPacket();
    }

    @Override
    public DeviceTypeInfo getDeviceTypeInfo() {
        return this.m_oDeviceTypeInfo;
    }

    @Override
    public void setFileName(String strFileName) {
        this.m_strFileName = strFileName;
    }

    @Override
    public String getFileName() {
        return this.m_strFileName;
    }

    @Override
    public String getBDVersion() {
        return this.m_strBDVersion;
    }

    @Override
    public void setBDVersion(String strBDVersion) {
        this.m_strBDVersion = strBDVersion;
    }

    @Override
    public void setFileType(ContentType oFileType) {
        this.m_oFileType = oFileType;
        this.setIfSupportsBreakPacket();
    }

    @Override
    public ContentType getFileType() {
        return this.m_oFileType;
    }

    @Override
    public void setVersion(String strVersion) {
        this.m_strVersion = strVersion;
    }

    @Override
    public String getVersion() {
        return this.m_strVersion;
    }

    @Override
    public void setFileSize(String strFileSize) {
        this.m_strFileSize = strFileSize;
    }

    @Override
    public String getFileSize() {
        return this.m_strFileSize;
    }

    @Override
    public void setFileDescription(String strFileDescription) {
        this.m_strFileDescription = strFileDescription;
    }

    @Override
    public String getFileDescription() {
        return this.m_strFileDescription;
    }

    @Override
    public void setCurrentVersion(String strVersion) {
        this.m_strCurrentVersion = strVersion;
    }

    @Override
    public String getCurrentVersion() {
        return this.m_strCurrentVersion;
    }

    @Override
    public BreakPacketInfo getBreakPacketInfo() {
        return this.m_oBreakPacketInfo;
    }

    private void setIfSupportsBreakPacket() {
        if (null != this.m_oDeviceTypeInfo && null != this.m_oFileType && SAMFileInfoUtil.doesFileSupportBreakPacket(this)) {
            this.m_oBreakPacketInfo = new BreakPacketInfo();
        }
    }

    @Override
    public List<String> getPatchVersion() {
        return this.m_oPatchVersion;
    }

    @Override
    public void setPatchVersion(List<String> patchVersion) {
        this.m_oPatchVersion = patchVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_oDeviceTypeInfo == null ? 0 : this.m_oDeviceTypeInfo.hashCode());
        result = 31 * result + (this.m_oFileType == null ? 0 : this.m_oFileType.hashCode());
        result = 31 * result + (this.m_strFileName == null ? 0 : this.m_strFileName.hashCode());
        result = 31 * result + (this.m_strVersion == null ? 0 : this.m_strVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAMFileInfo other = (SAMFileInfo)obj;
        if (this.m_oDeviceTypeInfo == null ? other.m_oDeviceTypeInfo != null : !this.m_oDeviceTypeInfo.equals(other.m_oDeviceTypeInfo)) {
            return false;
        }
        if (this.m_oFileType == null ? other.m_oFileType != null : !this.m_oFileType.equals(other.m_oFileType)) {
            return false;
        }
        if (this.m_strFileName == null ? other.m_strFileName != null : !Collator.getInstance().equals(this.m_strFileName, other.m_strFileName)) {
            return false;
        }
        return !(this.m_strVersion == null ? other.m_strVersion != null : !this.m_strVersion.equals(other.m_strVersion));
    }

    @Override
    public String getPatchVer() {
        return this.m_PatchVer;
    }

    @Override
    public void setPatchVer(String patchVer) {
        if (null != patchVer) {
            this.m_PatchVer = patchVer;
        }
    }

    @Override
    public boolean isHaveMultiDevVer() {
        return this.strMultiVersionLst.size() > 0;
    }
}

