/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.model;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMFileInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SAMDataModel
implements ISAMDataModel,
IDCObjectDeallocator {
    private static final long serialVersionUID = 1L;
    private static ISAMDataModel m_oSAMDataModel = null;
    private ConcurrentHashMap m_oSAMDevTypeMap = new ConcurrentHashMap(0);

    private SAMDataModel() {
    }

    public static synchronized ISAMDataModel getInstance() {
        if (null == m_oSAMDataModel) {
            m_oSAMDataModel = new SAMDataModel();
            DCObjectDestructor.getInstance().addObjectForDestructor((SAMDataModel)m_oSAMDataModel);
        }
        return m_oSAMDataModel;
    }

    @Override
    public void addVersionHashMap(DeviceTypeInfo stDevTypeInfo, ConcurrentHashMap mapVersion) {
        this.m_oSAMDevTypeMap.put(stDevTypeInfo, mapVersion);
    }

    @Override
    public ConcurrentHashMap getSAMDevTypeMap() {
        return this.m_oSAMDevTypeMap;
    }

    @Override
    public ConcurrentHashMap getVersionHashMap(DeviceTypeInfo stDevTypeInfo) {
        return (ConcurrentHashMap)this.m_oSAMDevTypeMap.get(stDevTypeInfo);
    }

    @Override
    public void setToNULL() {
        this.m_oSAMDevTypeMap = null;
        m_oSAMDataModel = null;
    }

    @Override
    public String[] getVersionLst(DeviceTypeInfo stDevTypeInfo) {
        String[] oVersionLst = null;
        if (0 == this.m_oSAMDevTypeMap.size()) {
            return oVersionLst;
        }
        if (this.m_oSAMDevTypeMap.containsKey(stDevTypeInfo)) {
            ConcurrentHashMap oVersionHashMap = this.getVersionHashMap(stDevTypeInfo);
            if (null == oVersionHashMap) {
                return oVersionLst;
            }
            oVersionLst = new String[oVersionHashMap.size()];
            int i = 0;
            Set oVersionSet = oVersionHashMap.keySet();
            Iterator oVersionIterator = oVersionSet.iterator();
            while (oVersionIterator.hasNext()) {
                oVersionLst[i] = (String)oVersionIterator.next();
                ++i;
            }
        }
        if (null == oVersionLst || 0 == oVersionLst.length) {
            oVersionLst = null;
        }
        return oVersionLst;
    }

    @Override
    public ArrayList getFileInfoLst() {
        ArrayList oFileInfoLst = new ArrayList(0);
        if (0 == this.m_oSAMDevTypeMap.size()) {
            return null;
        }
        Set oSAMDevTypeSet = this.m_oSAMDevTypeMap.keySet();
        Iterator oSAMDevTypeIterator = oSAMDevTypeSet.iterator();
        while (oSAMDevTypeIterator.hasNext()) {
            ConcurrentHashMap oVersionHashMap = this.getVersionHashMap((DeviceTypeInfo)oSAMDevTypeIterator.next());
            if (null == oVersionHashMap) continue;
            Set oVersionSet = oVersionHashMap.keySet();
            Iterator oVersionIterator = oVersionSet.iterator();
            while (oVersionIterator.hasNext()) {
                ArrayList oFileInfoArrayList = (ArrayList)oVersionHashMap.get((String)oVersionIterator.next());
                if (null == oFileInfoArrayList) continue;
                oFileInfoLst.addAll(oFileInfoArrayList);
            }
        }
        if (0 == oFileInfoLst.size()) {
            return null;
        }
        return oFileInfoLst;
    }

    @Override
    public ArrayList getFileInfoLst(DeviceTypeInfo stDevTypeInfo) {
        ArrayList oFileInfoLst = new ArrayList(0);
        if (0 == this.m_oSAMDevTypeMap.size()) {
            return null;
        }
        if (this.m_oSAMDevTypeMap.containsKey(stDevTypeInfo)) {
            ConcurrentHashMap oVersionHashMap = this.getVersionHashMap(stDevTypeInfo);
            if (null == oVersionHashMap) {
                return null;
            }
            Set oVersionSet = oVersionHashMap.keySet();
            Iterator oVersionIterator = oVersionSet.iterator();
            while (oVersionIterator.hasNext()) {
                ArrayList oFileInfoArrayList = (ArrayList)oVersionHashMap.get((String)oVersionIterator.next());
                if (null == oFileInfoArrayList) continue;
                oFileInfoLst.addAll(oFileInfoArrayList);
            }
        }
        if (0 == oFileInfoLst.size()) {
            return null;
        }
        return oFileInfoLst;
    }

    @Override
    public ArrayList getFileInfoLst(DeviceTypeInfo stDevTypeInfo, String strDevVersion, String strPatchVersion) {
        ArrayList<ISAMFileInfo> oFileInfoLst = new ArrayList<ISAMFileInfo>(0);
        if (0 == this.m_oSAMDevTypeMap.size()) {
            return null;
        }
        if (this.m_oSAMDevTypeMap.containsKey(stDevTypeInfo)) {
            ConcurrentHashMap oVersionHashMap = this.getVersionHashMap(stDevTypeInfo);
            if (null == oVersionHashMap) {
                return null;
            }
            if (oVersionHashMap.containsKey(strDevVersion)) {
                ArrayList oFileInfoArrayList = (ArrayList)oVersionHashMap.get(strDevVersion);
                if (null == oFileInfoArrayList) {
                    return null;
                }
                if (null == strPatchVersion) {
                    oFileInfoLst.addAll(oFileInfoArrayList);
                } else {
                    for (int i = 0; i < oFileInfoArrayList.size(); ++i) {
                        ISAMFileInfo tmpSAMFileInfo = (ISAMFileInfo)oFileInfoArrayList.get(i);
                        if (!strPatchVersion.equals(tmpSAMFileInfo.getPatchVer())) continue;
                        oFileInfoLst.add(tmpSAMFileInfo);
                    }
                }
            }
        }
        if (0 == oFileInfoLst.size()) {
            return null;
        }
        return oFileInfoLst;
    }

    @Override
    public void addNewFileInfo(ISAMFileInfo oSAMFileInfo) {
        ConcurrentHashMap oVerHashMap = m_oSAMDataModel.getVersionHashMap(oSAMFileInfo.getDeviceTypeInfo());
        if (null == oVerHashMap) {
            ConcurrentHashMap oVerMap = new ConcurrentHashMap(0);
            ArrayList<ISAMFileInfo> oFileInfoLst = new ArrayList<ISAMFileInfo>(1);
            oFileInfoLst.add(oSAMFileInfo);
            oVerMap.put(oSAMFileInfo.getVersion(), oFileInfoLst);
            m_oSAMDataModel.addVersionHashMap(oSAMFileInfo.getDeviceTypeInfo(), oVerMap);
        } else if (oVerHashMap.containsKey(oSAMFileInfo.getVersion())) {
            ArrayList oFileInfoLst = this.getFileInfoLst(oSAMFileInfo.getDeviceTypeInfo(), oSAMFileInfo.getVersion(), null);
            if (null == oFileInfoLst) {
                oFileInfoLst = (ArrayList)oVerHashMap.get(oSAMFileInfo.getVersion());
                if (null != oFileInfoLst) {
                    oFileInfoLst.add(oSAMFileInfo);
                    oVerHashMap.put(oSAMFileInfo.getVersion(), oFileInfoLst);
                }
            } else {
                if (!oFileInfoLst.isEmpty()) {
                    for (int i = 0; i < oFileInfoLst.size(); ++i) {
                        ISAMFileInfo tmpSAMFileInfo = (ISAMFileInfo)oFileInfoLst.get(i);
                        if (!tmpSAMFileInfo.equals(oSAMFileInfo) || !tmpSAMFileInfo.getPatchVer().equals(oSAMFileInfo.getPatchVer())) continue;
                        oFileInfoLst.remove(i);
                        break;
                    }
                }
                oFileInfoLst.add(oSAMFileInfo);
                oVerHashMap.put(oSAMFileInfo.getVersion(), oFileInfoLst);
            }
        } else {
            ArrayList<ISAMFileInfo> oFileInfoLst = new ArrayList<ISAMFileInfo>(0);
            oFileInfoLst.add(oSAMFileInfo);
            oVerHashMap.put(oSAMFileInfo.getVersion(), oFileInfoLst);
        }
    }

    @Override
    public DeviceTypeInfo getDeviceType(String strFileName, String strVersion) {
        for (DeviceTypeInfo oDeviceTypeInfo : this.m_oSAMDevTypeMap.keySet()) {
            ConcurrentHashMap oDevVersionMap = (ConcurrentHashMap)this.m_oSAMDevTypeMap.get(oDeviceTypeInfo);
            if (null == oDevVersionMap) continue;
            Iterator oDevVersionIterator = oDevVersionMap.keySet().iterator();
            while (oDevVersionIterator.hasNext()) {
                ArrayList oFileList;
                String strDeviceVersion = oDevVersionIterator.next().toString();
                if (!strDeviceVersion.equals(strVersion) || null == (oFileList = (ArrayList)oDevVersionMap.get(strDeviceVersion))) continue;
                for (int index = 0; index < oFileList.size(); ++index) {
                    String strSAMFileName = ((SAMFileInfo)oFileList.get(index)).getFileName();
                    if (!Collator.getInstance().equals(strSAMFileName, strFileName)) continue;
                    return oDeviceTypeInfo;
                }
            }
        }
        return null;
    }

    @Override
    public ISAMFileInfo getSAMFileInfo(DeviceTypeInfo oDeviceType, String strVersion, String strPatchVersion, ContentType oType, String strFileName) {
        ArrayList oFileList = this.getFileInfoLst(oDeviceType, strVersion, strPatchVersion);
        if (null == oFileList || 0 == oFileList.size() || null == oType || null == strFileName) {
            return null;
        }
        int iFileCount = oFileList.size();
        ISAMFileInfo oFileInfo = null;
        Collator oEquals = Collator.getInstance();
        for (int i = 0; i < iFileCount; ++i) {
            oFileInfo = (ISAMFileInfo)oFileList.get(i);
            if (!oEquals.equals(strFileName, oFileInfo.getFileName()) || !oType.equals(oFileInfo.getFileType())) continue;
            return oFileInfo;
        }
        return null;
    }
}

