/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.event;

import com.huawei.dc.common.asndatacenter.AsnDCSAMChangeNotify;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfoLst;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.sam.event.ISAMChangeEventListener;
import com.swimap.iview.communicate.MSGPacketExt;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class SAMChangeEventReceiver
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private HashSet<Object> m_RegisteredPanelClassSet = new HashSet();
    private static SAMChangeEventReceiver m_oDevConfListenerInstance;

    private SAMChangeEventReceiver() {
        super(43989);
    }

    public static synchronized SAMChangeEventReceiver getInstance() {
        if (null == m_oDevConfListenerInstance) {
            m_oDevConfListenerInstance = new SAMChangeEventReceiver();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oDevConfListenerInstance);
        }
        return m_oDevConfListenerInstance;
    }

    @Override
    public void setToNULL() {
        if (null != m_oDevConfListenerInstance) {
            Object[] array = this.m_RegisteredPanelClassSet.toArray();
            for (int i = 0; i < array.length; ++i) {
                this.unResigterForConfigChangeEvent((ISAMChangeEventListener)array[i]);
            }
            this.m_RegisteredPanelClassSet.clear();
            m_oDevConfListenerInstance.closeReceiver();
            m_oDevConfListenerInstance = null;
        }
    }

    public void resigterForConfigChangeEvent(ISAMChangeEventListener oSAMChagelistener) {
        if (null == oSAMChagelistener) {
            return;
        }
        this.m_RegisteredPanelClassSet.add(oSAMChagelistener);
    }

    public void processMessage(MSGPacketExt oPacketExt) {
        try {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
            byte[] arrReceivedData = oPacketExt.getData();
            if (null != arrReceivedData && 0 != arrReceivedData.length) {
                AsnDCSAMChangeNotify oAsnSAMChangeNtfn = new AsnDCSAMChangeNotify();
                BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
                if (null == oCommManager) {
                    return;
                }
                int iErrorCode = oCommManager.decodeAsn1Data((FStruct)oAsnSAMChangeNtfn, arrReceivedData);
                if (iErrorCode == 0) {
                    if (oAsnSAMChangeNtfn.bisCanceled) {
                        return;
                    }
                    if (null != oAsnSAMChangeNtfn.oSAMFileInfoLst) {
                        this.processNotification(oAsnSAMChangeNtfn.enNotifyType.value, oAsnSAMChangeNtfn.oSAMFileInfoLst);
                    }
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void processNotification(int iEventType, AsnSAMFileUpdateInfoLst oAsnSAMFileInfoLst) {
        DCDebugTracer.trace("Method processNotification start");
        DCDebugTracer.trace("iEventType=" + iEventType);
        if (null == oAsnSAMFileInfoLst || 0 == oAsnSAMFileInfoLst.size()) {
            return;
        }
        Set<Object> oSyncSet = Collections.synchronizedSet(new HashSet<Object>(this.m_RegisteredPanelClassSet));
        Iterator<Object> oSetItr = oSyncSet.iterator();
        switch (iEventType) {
            case 0: {
                while (oSetItr.hasNext()) {
                    ISAMChangeEventListener listener = (ISAMChangeEventListener)oSetItr.next();
                    if (null == listener) continue;
                    try {
                        listener.handleImportSAMFileNotification(oAsnSAMFileInfoLst);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
                oAsnSAMFileInfoLst.clear();
                break;
            }
            case 1: {
                while (oSetItr.hasNext()) {
                    ISAMChangeEventListener listener = (ISAMChangeEventListener)oSetItr.next();
                    if (null == listener) continue;
                    try {
                        listener.handleDeleteSAMFileNotification(oAsnSAMFileInfoLst);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
                oAsnSAMFileInfoLst.clear();
                break;
            }
            case 2: {
                while (oSetItr.hasNext()) {
                    ISAMChangeEventListener listener = (ISAMChangeEventListener)oSetItr.next();
                    DCDebugTracer.trace("[SAM] listener is " + listener);
                    if (null == listener) continue;
                    try {
                        listener.handleUpdateSAMFileNotification(oAsnSAMFileInfoLst);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
                oAsnSAMFileInfoLst.clear();
                break;
            }
            default: {
                DCDebugTracer.traceError("Unknow Operation Type..");
            }
        }
        DCDebugTracer.trace("Method processNotification end..");
    }

    public void unResigterForConfigChangeEvent(ISAMChangeEventListener oDevChagelistener) {
        if (null == oDevChagelistener) {
            return;
        }
        this.m_RegisteredPanelClassSet.remove(oDevChagelistener);
    }
}

