/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.controller;

import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMTargerVersionDirLst;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.taskmgmt.model.ITask;
import java.math.BigInteger;

public final class TargetVersionPathGetter {
    private static final int PACKAGE = 1;
    private static final int SIMULATION = 2;
    private static final int PATCH = 3;
    private static final int VALID = -1;

    private static int getFileTypeID(ITask oTask) {
        int fileType = -1;
        if (oTask.getTaskTypeId() == 3) {
            fileType = 2;
        } else if (oTask.getTaskTypeId() == 4 || oTask.getTaskTypeId() == 5 || oTask.getTaskTypeId() == 12 || oTask.getTaskTypeId() == 13) {
            fileType = 1;
        } else if (oTask.getTaskTypeId() == 2) {
            fileType = 3;
        } else if (oTask.getTaskTypeId() == 0) {
            fileType = 1;
        }
        return fileType;
    }

    public static String getTargetVersionDir(DeviceType oDeviceType, String strTargetVersion, ITask m_oParentTask) {
        AsnSAMTargerVersionDirLst oTargerVersionDirLst;
        DCDebugTracer.trace("method SynMsgSender#getTargetVersionDir start");
        DCDebugTracer.trace("oDeviceType : " + oDeviceType.toString());
        DCDebugTracer.trace("strTargetVersion : " + strTargetVersion);
        AsnDCGetTargetVersionDirReq oAsnDCGetTargetVersionDirReq = new AsnDCGetTargetVersionDirReq();
        oAsnDCGetTargetVersionDirReq.iDeviceTypeId = new BigInteger(String.valueOf(oDeviceType.getDeviceTypeID()));
        oAsnDCGetTargetVersionDirReq.iDeviceTypeVersionID = new BigInteger(String.valueOf(oDeviceType.getDeviceTypeVersionID()));
        if (m_oParentTask.isBMSDomain()) {
            oAsnDCGetTargetVersionDirReq.strTargetVersionName = strTargetVersion.getBytes();
            oAsnDCGetTargetVersionDirReq.strPatchVersionName = "".getBytes();
        } else if (2 == m_oParentTask.getTaskTypeId()) {
            String[] versionInfo = DCCommonUtil.breakPatchTargetVersion(strTargetVersion);
            if (null == versionInfo) {
                DCDebugTracer.trace("LoadPatchOperation#getTargetVersionDir->strTargetVersion is null");
                oAsnDCGetTargetVersionDirReq.strTargetVersionName = "".getBytes();
                oAsnDCGetTargetVersionDirReq.strPatchVersionName = "".getBytes();
            } else {
                oAsnDCGetTargetVersionDirReq.strTargetVersionName = versionInfo[0].getBytes();
                oAsnDCGetTargetVersionDirReq.strPatchVersionName = versionInfo.length > 1 ? (null != versionInfo[1] ? versionInfo[1].getBytes() : "".getBytes()) : "".getBytes();
            }
        } else {
            oAsnDCGetTargetVersionDirReq.strTargetVersionName = strTargetVersion.getBytes();
            oAsnDCGetTargetVersionDirReq.strPatchVersionName = "".getBytes();
        }
        oAsnDCGetTargetVersionDirReq.iFileContentType = new BigInteger(String.valueOf(TargetVersionPathGetter.getFileTypeID(m_oParentTask)));
        ISAMManager oSAManager = SAMManager.getInstance();
        String strPath = "";
        AsnDCGetTargetVersionDirRsp oAsnDCGetTargetVersionDirRsp = oSAManager.getAsnSAMGetTargetVersionDir(oAsnDCGetTargetVersionDirReq);
        if (oAsnDCGetTargetVersionDirRsp != null && (oTargerVersionDirLst = oAsnDCGetTargetVersionDirRsp.oTargerVersionDirLst) != null && oTargerVersionDirLst.size() > 0) {
            byte[] strDir = (byte[])oTargerVersionDirLst.get(0);
            strPath = new String(strDir);
        }
        DCDebugTracer.trace("method SynMsgSender#getTargetVersionDir end.. strPath : " + strPath);
        return strPath;
    }
}

