/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCancelTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacket;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketNtf;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketReq;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketResult;
import com.huawei.dc.common.asndatacenter.AsnDCGetASMDCInfoInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetDCInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionDirRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfoList;
import com.huawei.dc.common.asndatacenter.AsnGetSWFileInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnImportModeEnum;
import com.huawei.dc.common.asndatacenter.AsnSAMDeleteTempFileReq;
import com.huawei.dc.common.asndatacenter.AsnSAMFileDeleteReq;
import com.huawei.dc.common.asndatacenter.AsnSAMFileDeleteRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileModifyReq;
import com.huawei.dc.common.asndatacenter.AsnSAMFileModifyRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetFileDetailsReq;
import com.huawei.dc.common.asndatacenter.AsnSAMGetFileDetailsRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstReq;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionReq;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMImportFileReq;
import com.huawei.dc.common.asndatacenter.AsnSAMImportFileRsp;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.event.ISAMEventListener;
import com.huawei.dc.sam.event.SAMEvent;
import com.huawei.dc.sam.model.BreakPacketInfo;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class SAMManager
extends AbstractDCMSGReceiver
implements ISAMManager,
IDCObjectDeallocator {
    private BaseCommManager m_oCommManager;
    private static ISAMManager m_oSAMFileInfoController;
    private ISAMDataModel m_oSAMDataModel;
    private SAMFileInfoImportPanel m_SAMFileInfoImportPanel = null;
    private SAMUtil m_oSAMUtil;
    private List m_oNotificationListenerList;
    private static final byte[] m_oGetSAMSyncObj;
    private long firstOpenClientTime = System.nanoTime();
    private static final int[] COMMAND_CODES;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SAMManager other = (SAMManager)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    private SAMManager() {
        super(COMMAND_CODES);
        this.m_oSAMUtil = SAMUtil.getInstance();
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.m_oNotificationListenerList = new ArrayList(0);
    }

    public static synchronized ISAMManager getInstance() {
        if (null == m_oSAMFileInfoController) {
            m_oSAMFileInfoController = new SAMManager();
            DCObjectDestructor.getInstance().addObjectForDestructor((SAMManager)m_oSAMFileInfoController);
        }
        return m_oSAMFileInfoController;
    }

    @Override
    public void registerForFileDetailsNtfn(SAMFileInfoImportPanel oImportPanel) {
        this.m_oCommManager.addMessageListener(43917, (MSGListener)this);
        this.m_SAMFileInfoImportPanel = oImportPanel;
    }

    @Override
    public void registerForImportFileNtfn(SAMFileInfoImportPanel oImportPanel) {
        this.m_oCommManager.addMessageListener(43919, (MSGListener)this);
        this.m_SAMFileInfoImportPanel = oImportPanel;
    }

    @Override
    public void registerForWholeVersionImportNtfn(SAMFileInfoImportPanel oImportPanel) {
        this.m_oCommManager.addMessageListener(43975, (MSGListener)this);
        this.m_SAMFileInfoImportPanel = oImportPanel;
    }

    @Override
    public void registerForFileDeleteNtfn() {
        this.m_oCommManager.addMessageListener(43948, (MSGListener)this);
    }

    @Override
    public void unregisterForFileDeleteNtfn() {
        if (null != this.m_oCommManager) {
            this.m_oCommManager.removeMessageListener(43948, (MSGListener)this);
        }
    }

    @Override
    public void unregisterForImportFileNtfn() {
        if (null != this.m_oCommManager) {
            this.m_oCommManager.removeMessageListener(43919, (MSGListener)this);
        }
        this.m_SAMFileInfoImportPanel = null;
    }

    @Override
    public void unregisterForFileDetailsNtfn() {
        if (null != this.m_oCommManager) {
            this.m_oCommManager.removeMessageListener(43917, (MSGListener)this);
        }
        this.m_SAMFileInfoImportPanel = null;
    }

    @Override
    public void unregisterForWholeVersionImportNtfn() {
        if (null != this.m_oCommManager) {
            this.m_oCommManager.removeMessageListener(43975, (MSGListener)this);
        }
        this.m_SAMFileInfoImportPanel = null;
    }

    protected void processMessage(MSGPacketExt oMsgPacket) {
        DCDebugTracer.trace("[SAM] receive asyn msg cmdCode= " + oMsgPacket.mheader.cmdCode);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        try {
            this.processAsynMessage(oMsgPacket);
        }
        catch (Exception e) {
            if (43917 == oMsgPacket.mheader.cmdCode && null != this.m_SAMFileInfoImportPanel) {
                this.m_SAMFileInfoImportPanel.setImportPanelWithoutProgressBar();
                this.unregisterForFileDetailsNtfn();
            }
            DCDebugTracer.trace(e);
        }
    }

    protected void processAsynMessage(MSGPacketExt oMsgPacket) {
        switch (oMsgPacket.mheader.cmdCode) {
            case 43917: {
                this.handleGetFileDetails(oMsgPacket);
                break;
            }
            case 43919: {
                this.handleImportFile(oMsgPacket);
                break;
            }
            case 43975: {
                this.handleWholeVersionImport(oMsgPacket);
                break;
            }
            case 43973: {
                this.handleBreakPacket(oMsgPacket);
                break;
            }
            case 43948: {
                this.handleDeleteFile(oMsgPacket);
                break;
            }
            case 43916: {
                this.handleInitSAMInfo(oMsgPacket);
                break;
            }
            default: {
                DCDebugTracer.trace("[SAM] receive asyn msg cmdCode= " + oMsgPacket.mheader.cmdCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleInitSAMInfo(MSGPacketExt oMsgPacket) {
        AsnGetSWFileInfoRsp oAsnGetSWFileInfoRsp = new AsnGetSWFileInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnGetSWFileInfoRsp, oMsgPacket.getData());
        if (0 != iErrorCode) {
            return;
        }
        SAMUtil oSAMUtil = SAMUtil.getInstance();
        if (null == this.m_oSAMDataModel) {
            this.m_oSAMDataModel = SAMDataModel.getInstance();
        }
        oSAMUtil.refreshSAMDataModel(this.m_oSAMDataModel, oAsnGetSWFileInfoRsp);
        boolean isFinal = oAsnGetSWFileInfoRsp.bFinal;
        DCDebugTracer.trace("DC::oAsnGetSWFileInfoRsp-bFinal:" + isFinal);
        if (!isFinal) return;
        byte[] byArray = m_oGetSAMSyncObj;
        synchronized (m_oGetSAMSyncObj) {
            m_oGetSAMSyncObj.notifyAll();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            DCFrameWorkUtil.getDCModuleManager().checkXFTPStatus();
            return;
        }
    }

    private void handleDeleteFile(MSGPacketExt oMsgPacket) {
        AsnSAMFileDeleteRsp oAsnSAMFileDeleteRsp = new AsnSAMFileDeleteRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSAMFileDeleteRsp, oMsgPacket.getData());
        if (0 == iErrorcode) {
            this.processDeleteFileResponse(oAsnSAMFileDeleteRsp);
        }
    }

    private void handleBreakPacket(MSGPacketExt oMsgPacket) {
        AsnDCBreakPacketNtf oAsnDCBreakPacketNtf = new AsnDCBreakPacketNtf();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCBreakPacketNtf, oMsgPacket.getData());
        if (0 == iErrorcode) {
            this.processBreakPacketResponse(oAsnDCBreakPacketNtf);
        }
    }

    private void handleWholeVersionImport(MSGPacketExt oMsgPacket) {
        AsnSAMImportFileRsp oAsnSAMImportFileRsp = new AsnSAMImportFileRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSAMImportFileRsp, oMsgPacket.getData());
        if (0 == iErrorcode && null != this.m_SAMFileInfoImportPanel) {
            this.m_SAMFileInfoImportPanel.processWholeVersionRsp(oAsnSAMImportFileRsp);
        }
    }

    private void handleImportFile(MSGPacketExt oMsgPacket) {
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnRsp, oMsgPacket.getData());
        if (0 == iErrorcode && null != this.m_SAMFileInfoImportPanel) {
            this.m_SAMFileInfoImportPanel.processImportFileRsp(oAsnRsp);
        }
    }

    private void handleGetFileDetails(MSGPacketExt oMsgPacket) {
        AsnSAMGetFileDetailsRsp oFileDetailsRsp = new AsnSAMGetFileDetailsRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oFileDetailsRsp, oMsgPacket.getData());
        if (0 == iErrorcode && null != this.m_SAMFileInfoImportPanel) {
            this.m_SAMFileInfoImportPanel.processFileDetailsRsp(oFileDetailsRsp);
        }
    }

    private synchronized void processDeleteFileResponse(AsnSAMFileDeleteRsp oAsnSAMFileDeleteRsp) {
        if (null == oAsnSAMFileDeleteRsp) {
            return;
        }
        ISAMFileInfo oFileInfo = this.m_oSAMUtil.fillFileInfoObject(oAsnSAMFileDeleteRsp.iDevTypeId.intValue(), oAsnSAMFileDeleteRsp.iDevTypeVersionId.intValue(), oAsnSAMFileDeleteRsp.oFileInfo);
        if (null == oFileInfo) {
            return;
        }
        SAMEvent oEvent = new SAMEvent(oFileInfo, 1);
        oEvent.setErrorCode(oAsnSAMFileDeleteRsp.oErrorInfo.iErrorNo.intValue());
        oEvent.setFinal(oAsnSAMFileDeleteRsp.bIsFinal);
        this.notifySAMEvent(oEvent);
    }

    @Override
    public void deleteTempFiles(String strFilePath, int iReqID) {
        DCDebugTracer.trace("SAMManager#deleteTempFiles->strFilePath start...");
        AsnSAMDeleteTempFileReq oAsnSAMDeleteTempFileReq = new AsnSAMDeleteTempFileReq();
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        oAsnSAMDeleteTempFileReq.strFilePath = strFilePath.getBytes();
        oAsnSAMDeleteTempFileReq.oReqID = BigInteger.valueOf(iReqID);
        oAsnSAMDeleteTempFileReq.enCancelType = new AsnCancelTypeEnum();
        oAsnSAMDeleteTempFileReq.enCancelType.value = 3;
        this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43918), (FStruct)oAsnSAMDeleteTempFileReq, (FStruct)oAsnRsp);
        DCDebugTracer.trace("SAMManager#deleteTempFiles->strFilePath end...");
    }

    @Override
    public void deleteTempFiles(ISAMFileInfo oSAMFileInfo, int iReqID, int iOperationType) {
        DCDebugTracer.trace("SAMManager#deleteTempFiles->oSAMFileInfo start...");
        AsnSAMDeleteTempFileReq oAsnSAMDeleteTempFileReq = new AsnSAMDeleteTempFileReq();
        AsnDCSyncRsp oAsnDCOpertionRsp = new AsnDCSyncRsp();
        oAsnSAMDeleteTempFileReq.strFilePath = oSAMFileInfo.getFileName().getBytes();
        oAsnSAMDeleteTempFileReq.iDevTypeId = BigInteger.valueOf(oSAMFileInfo.getDeviceTypeInfo().getDevTypeID());
        oAsnSAMDeleteTempFileReq.iDevTypeVersionId = BigInteger.valueOf(oSAMFileInfo.getDeviceTypeInfo().getDevTypeVersionId());
        oAsnSAMDeleteTempFileReq.strVersion = oSAMFileInfo.getVersion().getBytes();
        oAsnSAMDeleteTempFileReq.oReqID = BigInteger.valueOf(iReqID);
        oAsnSAMDeleteTempFileReq.iContentType = 1 == iOperationType ? BigInteger.valueOf(0L) : BigInteger.valueOf(oSAMFileInfo.getFileType().getContentTypeCode());
        oAsnSAMDeleteTempFileReq.enCancelType = new AsnCancelTypeEnum();
        oAsnSAMDeleteTempFileReq.enCancelType.value = iOperationType;
        this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43918), (FStruct)oAsnSAMDeleteTempFileReq, (FStruct)oAsnDCOpertionRsp);
        DCDebugTracer.trace("SAMManager#deleteTempFiles->oSAMFileInfo end...");
    }

    @Override
    public void getSAMFileDetails(int iReqId, boolean bIsClient, String strFilePath, List<DeviceTypeInfo> oDevTypeInfoList, int iContentType, int iImportMode) throws DCException {
        AsnImportModeEnum oAsnImportModeEnum;
        DCDebugTracer.trace("Method getSAMFileDetails srart");
        final AsnSAMGetFileDetailsReq oAsnSAMGetFileDetailsReq = new AsnSAMGetFileDetailsReq();
        DCDebugTracer.trace("SAMManager.getSAMFileDetails(the request id is " + iReqId + ")");
        oAsnSAMGetFileDetailsReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnSAMGetFileDetailsReq.bIsClientFile = bIsClient;
        oAsnSAMGetFileDetailsReq.strFilePath = strFilePath.getBytes();
        oAsnSAMGetFileDetailsReq.oDevTypeIdInfoList = new AsnDevTypeIdInfoList();
        DeviceTypeInfo oDevTypeInfo = null;
        int iDevTypeSize = oDevTypeInfoList.size();
        for (int i = 0; i < iDevTypeSize; ++i) {
            oDevTypeInfo = oDevTypeInfoList.get(i);
            AsnDevTypeIdInfo oAsnDevTypeIdInfo = new AsnDevTypeIdInfo();
            oAsnDevTypeIdInfo.iDevTypeId = BigInteger.valueOf(oDevTypeInfo.getDevTypeID());
            oAsnDevTypeIdInfo.iDevTypeVerId = BigInteger.valueOf(oDevTypeInfo.getDevTypeVersionId());
            oAsnSAMGetFileDetailsReq.oDevTypeIdInfoList.add((Object)oAsnDevTypeIdInfo);
        }
        oAsnSAMGetFileDetailsReq.iContentType = BigInteger.valueOf(iContentType);
        oAsnSAMGetFileDetailsReq.enImportMode = oAsnImportModeEnum = new AsnImportModeEnum(iImportMode);
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = SAMManager.this.m_oCommManager;
                SAMManager.this.m_oCommManager;
                int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43917), (FStruct)oAsnSAMGetFileDetailsReq, (FStruct)oAsnRsp);
                return errorCode;
            }
        };
        int iErrorCode = 0;
        DCDebugTracer.trace("Send request to server for get SAM file details");
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCDebugTracer.trace("Get Sync response from server for get SAM file details");
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            DCDebugTracer.trace("Send request to server for get file details failed");
            throw new DCException(iErrorCode, DCFrameWorkUtil.getLocalizedString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCDebugTracer.trace("Error in getSAMFiledetails request : " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        DCDebugTracer.trace("Method getSAMFileDetails end");
    }

    @Override
    public int importSoftware(final AsnSAMImportFileReq oAsnSAMImportFileReq, final int iCmdCode) throws DCException {
        int iRequestId = DCFrameWorkUtil.generateRequestId();
        oAsnSAMImportFileReq.oReqID = BigInteger.valueOf(iRequestId);
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = SAMManager.this.m_oCommManager;
                SAMManager.this.m_oCommManager;
                int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), (FStruct)oAsnSAMImportFileReq, (FStruct)oAsnRsp);
                return errorCode;
            }
        };
        int iErrorCode = 0;
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, DCFrameWorkUtil.getLocalizedString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        iRequestId = oAsnRsp.oReqID.intValue();
        return iRequestId;
    }

    @Override
    public int getSAMFileInfoRequest() {
        int iErrorCode = -1;
        AsnGetSWFileInfoRsp oAsnGetSWFileInfoRsp = new AsnGetSWFileInfoRsp();
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43916), null, (FStruct)oAsnGetSWFileInfoRsp);
        if (0 != iErrorCode) {
            return iErrorCode;
        }
        int iServerErrorCode = oAsnGetSWFileInfoRsp.oErrorInfo.iErrorNo.intValue();
        if (iServerErrorCode != 0) {
            return iServerErrorCode;
        }
        return iServerErrorCode;
    }

    public void setSAMFileInfo(AsnGetSWFileInfoRsp oAsnFetSWFileInfoRsp) {
    }

    @Override
    public void addSAMFileInfoToDataModel(ISAMFileInfo oSAMFileInfo) {
        if (null == this.m_oSAMDataModel) {
            this.m_oSAMDataModel = SAMDataModel.getInstance();
        }
        this.m_oSAMDataModel.addNewFileInfo(oSAMFileInfo);
    }

    @Override
    public ISAMDataModel getDataModel() {
        return this.m_oSAMDataModel;
    }

    @Override
    public void sendSAMFiledeleteReq(int iReqId, ArrayList oDeleteFileLst) throws DCException {
        final AsnSAMFileDeleteReq oAsnSAMFileDeleteReq = this.m_oSAMUtil.getAsnSAMFileDeleteReq(oDeleteFileLst);
        oAsnSAMFileDeleteReq.oReqID = BigInteger.valueOf(iReqId);
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = SAMManager.this.m_oCommManager;
                SAMManager.this.m_oCommManager;
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43948), (FStruct)oAsnSAMFileDeleteReq, (FStruct)oAsnRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            int returnCode = (Integer)syncCommand.getResult();
            if (0 != returnCode) {
                throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(returnCode)));
            }
            if (0 != oAsnRsp.oErrorInfo.iErrorNo.intValue()) {
                throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
            }
        }
    }

    @Override
    public AsnSAMFileModifyRsp sendSAMFileModifyReq(SAMFileInfo oSAMFileInfo, boolean bOverWrite) {
        int iErrorCode = -1;
        String strMessageType = DCFrameWorkUtil.getLocalizedString("ERROR");
        int iMessageType = 0;
        AsnSAMFileModifyReq oAsnSAMFileModifyReq = this.m_oSAMUtil.getAsnSAMFileModifyReq(oSAMFileInfo, bOverWrite);
        AsnSAMFileModifyRsp oAsnSAMFileModifyRsp = new AsnSAMFileModifyRsp();
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43925), (FStruct)oAsnSAMFileModifyReq, (FStruct)oAsnSAMFileModifyRsp);
        if (0 != iErrorCode) {
            this.showMessage(iErrorCode, strMessageType, iMessageType);
            return null;
        }
        return oAsnSAMFileModifyRsp;
    }

    @Override
    public AsnDCGetTargetVersionDirRsp getAsnSAMGetTargetVersionDir(AsnDCGetTargetVersionDirReq oAsnDCGetTargetVersionDirReq) {
        int iErrorCode = -1;
        AsnDCGetTargetVersionDirRsp oAsnDCGetTargetVersionDirRsp = new AsnDCGetTargetVersionDirRsp();
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43979), (FStruct)oAsnDCGetTargetVersionDirReq, (FStruct)oAsnDCGetTargetVersionDirRsp);
        if (0 != iErrorCode) {
            return null;
        }
        if (0 != oAsnDCGetTargetVersionDirRsp.oErrorInfo.iErrorNo.intValue()) {
            return null;
        }
        return oAsnDCGetTargetVersionDirRsp;
    }

    @Override
    public AsnSAMGetVersionRsp getAsnSAMGetVersionReq(SAMFileInfo oSAMFileInfo, int iTaskTypeId) {
        int iErrorCode = -1;
        String strMessageType = DCFrameWorkUtil.getLocalizedString("ERROR");
        int iMessageType = 0;
        AsnSAMGetVersionReq oAsnSAMFileModifyReq = this.m_oSAMUtil.getAsnSAMGetVersionReq(oSAMFileInfo, iTaskTypeId);
        AsnSAMGetVersionRsp oAsnSAMGetVersionRsp = new AsnSAMGetVersionRsp();
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43929), (FStruct)oAsnSAMFileModifyReq, (FStruct)oAsnSAMGetVersionRsp);
        if (0 != iErrorCode) {
            this.showMessage(iErrorCode, strMessageType, iMessageType);
            return null;
        }
        return oAsnSAMGetVersionRsp;
    }

    @Override
    public AsnSAMGetVersionFileLstRsp getAsnSAMDeviceVersionFileReq(SAMFileInfo oSAMFileInfo) {
        int iErrorCode = -1;
        String strMessageType = DCFrameWorkUtil.getLocalizedString("ERROR");
        int iMessageType = 0;
        AsnSAMGetVersionFileLstReq oAsnSAMFileModifyReq = this.m_oSAMUtil.getAsnSAMGetVeersionFileLstReq(oSAMFileInfo);
        AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = new AsnSAMGetVersionFileLstRsp();
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43930), (FStruct)oAsnSAMFileModifyReq, (FStruct)oAsnSAMGetVersionFileLstRsp);
        if (0 != iErrorCode) {
            this.showMessage(iErrorCode, strMessageType, iMessageType);
            return null;
        }
        return oAsnSAMGetVersionFileLstRsp;
    }

    private void showMessage(int iErrorCode, String strMessageType, int iMessageType) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, strMessageType, iMessageType);
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oNotificationListenerList) {
            this.m_oNotificationListenerList.clear();
            this.m_oNotificationListenerList = null;
        }
        this.closeReceiver();
        m_oSAMFileInfoController = null;
        this.m_oSAMUtil = null;
        this.m_oCommManager = null;
        this.m_oSAMDataModel = null;
    }

    @Override
    public boolean isLoadPatchFilesPresent(SAMFileInfo oSAMFileInfo) {
        boolean isPatchPresent = false;
        AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = this.getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
        int iNoOfFile = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.size();
        String sPatchContentType = ResourceManager.getInstance().getResString("PATCH_FILE_TYPE_BROWSE_TABLE").trim();
        for (int index = 0; index < iNoOfFile; ++index) {
            AsnSAMFileInfo oSAMFileInfoFromServer = (AsnSAMFileInfo)oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.get(index);
            ContentType oContentType = SAMUtil.getInstance().getContentType(oSAMFileInfo.getDeviceTypeInfo(), oSAMFileInfoFromServer.iFileType.intValue(), true, null);
            if (null == oContentType || !oContentType.getStrContentType().trim().equalsIgnoreCase(sPatchContentType)) continue;
            isPatchPresent = true;
        }
        return isPatchPresent;
    }

    @Override
    public boolean isLoadSoftwaresPresent(SAMFileInfo oSAMFileInfo) {
        boolean isFilePresent = false;
        AsnSAMGetVersionFileLstRsp oAsnSAMGetVersionFileLstRsp = this.getAsnSAMDeviceVersionFileReq(oSAMFileInfo);
        int iNoOfFile = oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.size();
        for (int index = 0; index < iNoOfFile; ++index) {
            AsnSAMFileInfo oSAMFileInfoFromServer = (AsnSAMFileInfo)oAsnSAMGetVersionFileLstRsp.oAsnSAMFileInfoLst.get(index);
            ContentType oContentType = SAMUtil.getInstance().getContentType(oSAMFileInfo.getDeviceTypeInfo(), oSAMFileInfoFromServer.iFileType.intValue(), false, null);
            if (null == oContentType) continue;
            isFilePresent = true;
        }
        return isFilePresent;
    }

    @Override
    public AsnDCGetASMDCInfoInfoRsp getSAMDCInfoFiles(AsnDCGetDCInfoReq oAsnDCGetDCInfoReq) {
        int returnCode;
        final AsnDCGetDCInfoReq req = oAsnDCGetDCInfoReq;
        final AsnDCGetASMDCInfoInfoRsp oAsnDCGetASMDCInfoInfoRsp = new AsnDCGetASMDCInfoInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = SAMManager.this.m_oCommManager;
                SAMManager.this.m_oCommManager;
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43967), (FStruct)req, (FStruct)oAsnDCGetASMDCInfoInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            return null;
        }
        return oAsnDCGetASMDCInfoInfoRsp;
    }

    @Override
    public void breakPacketFiles(int iReqId, List<ISAMFileInfo> oFileList) throws DCException {
        int returnCode;
        final AsnDCBreakPacketReq oAsnDCBreakPacketReq = SAMUtil.getBreakPacketRequestForFiles(iReqId, oFileList);
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        this.m_oCommManager.addMessageListener(43973, (MSGListener)this);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = SAMManager.this.m_oCommManager;
                SAMManager.this.m_oCommManager;
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43973), (FStruct)oAsnDCBreakPacketReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && 0 != (returnCode = ((Integer)syncCommand.getResult()).intValue())) {
            this.m_oCommManager.removeMessageListener(43973, (MSGListener)this);
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(returnCode)));
        }
        if (0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            this.m_oCommManager.removeMessageListener(43973, (MSGListener)this);
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(oRsp.oErrorInfo.iErrorNo));
        }
    }

    private synchronized void processBreakPacketResponse(AsnDCBreakPacketNtf oAsnDCBreakPacketNtf) {
        if (null == oAsnDCBreakPacketNtf) {
            return;
        }
        AsnDCBreakPacket oAsnDCBreakPacket = oAsnDCBreakPacketNtf.oBreakPacket;
        ISAMFileInfo oFileInfoInModel = this.m_oSAMUtil.getSAMFileFromModel(oAsnDCBreakPacketNtf.oBreakPacket.oFileInfo, oAsnDCBreakPacket.iDevTypeId.intValue(), oAsnDCBreakPacket.iDevTypeVersionId.intValue());
        if (null == oFileInfoInModel) {
            return;
        }
        if (null != oFileInfoInModel.getBreakPacketInfo() && null != oAsnDCBreakPacket.oFileInfo.oBreakPacketResult) {
            AsnDCBreakPacketResult oBreakPktResult = oAsnDCBreakPacket.oFileInfo.oBreakPacketResult;
            BreakPacketInfo oBreakPacketInfo = oFileInfoInModel.getBreakPacketInfo();
            int iBreakOperationStatus = SAMUtil.getBreakPacketStatus(oBreakPktResult);
            if (3 == oBreakPktResult.enStatus.value) {
                oBreakPacketInfo.setOperationStatus(iBreakOperationStatus);
            }
            oBreakPacketInfo.setErrorCode(oBreakPktResult.oErrorInfo.iErrorNo.intValue());
        }
        ISAMFileInfo oFileInfoRsp = this.m_oSAMUtil.fillFileInfoObject(oAsnDCBreakPacket.iDevTypeId.intValue(), oAsnDCBreakPacket.iDevTypeVersionId.intValue(), oAsnDCBreakPacketNtf.oBreakPacket.oFileInfo);
        SAMEvent oEvent = new SAMEvent(oFileInfoRsp, 0);
        oEvent.setFinal(oAsnDCBreakPacketNtf.bIsFinal);
        this.notifySAMEvent(oEvent);
        if (oAsnDCBreakPacketNtf.bIsFinal) {
            this.m_oCommManager.removeMessageListener(43973, (MSGListener)this);
        }
    }

    @Override
    public void addSAMEventListener(ISAMEventListener oListener) {
        if (null != oListener && !this.m_oNotificationListenerList.contains(oListener)) {
            this.m_oNotificationListenerList.add(oListener);
        }
    }

    @Override
    public void notifySAMEvent(SAMEvent oEvent) {
        int noOfListener = this.m_oNotificationListenerList.size();
        DCDebugTracer.trace("noOfListener count : " + noOfListener);
        for (int index = noOfListener - 1; index >= 0; --index) {
            Object oListenerObj = this.m_oNotificationListenerList.get(index);
            if (!(oListenerObj instanceof ISAMEventListener)) continue;
            DCDebugTracer.trace("Listener Name : " + oListenerObj.getClass().getName());
            ((ISAMEventListener)oListenerObj).onSAMEvent(oEvent);
        }
    }

    @Override
    public void removeSAMEventListener(ISAMEventListener oListener) {
        if (null != oListener && null != this.m_oNotificationListenerList) {
            this.m_oNotificationListenerList.remove(oListener);
        }
    }

    @Override
    public Object getSAMSyncObj() {
        return m_oGetSAMSyncObj;
    }

    static {
        m_oGetSAMSyncObj = new byte[0];
        COMMAND_CODES = new int[]{43916, 43917, 43919, 43975, 43948};
    }
}

