/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacket;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketReq;
import com.huawei.dc.common.asndatacenter.AsnDCBreakPacketResult;
import com.huawei.dc.common.asndatacenter.AsnGetSWFileInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMDevTypeFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMDevTypeFileInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMDevVerFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMDevVerFileInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMFileDeleteInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileDeleteReq;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMFileModifyReq;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstReq;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionReq;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.BreakPacketInfo;
import com.huawei.dc.sam.model.ISAMDataModel;
import com.huawei.dc.sam.model.ISAMFileInfo;
import com.huawei.dc.sam.model.SAMDataModel;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.sam.view.SAMOperationProgressDlg;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class SAMUtil
implements IDCObjectDeallocator {
    private static SAMUtil m_oSAMUtil;

    private SAMUtil() {
    }

    public static synchronized SAMUtil getInstance() {
        if (null == m_oSAMUtil) {
            m_oSAMUtil = new SAMUtil();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oSAMUtil);
        }
        return m_oSAMUtil;
    }

    public void refreshSAMDataModel(ISAMDataModel oSAMDataModel, AsnGetSWFileInfoRsp oAsnGetSWFileInfoResp) {
        AsnSAMDevTypeFileInfoLst oDeviceTypeLst = oAsnGetSWFileInfoResp.oDevTypeFileInfoLst;
        AsnSAMDevVerFileInfoLst oDevVersionLst = null;
        ISAMFileInfo oFileInfo = null;
        ArrayList<ISAMFileInfo> oFileInfoList = null;
        AsnSAMDevTypeFileInfo oAsnSAMDevTypeFileInfo = null;
        AsnSAMDevVerFileInfo oAsnSAMDevVerFileInfo = null;
        String strDevVersion = "";
        int iDevTypeID = -1;
        int iDevTypeVerID = -1;
        ConcurrentHashMap oDeviceVerMap = null;
        for (int iDevTypeindex = 0; iDevTypeindex < oDeviceTypeLst.size(); ++iDevTypeindex) {
            oAsnSAMDevTypeFileInfo = (AsnSAMDevTypeFileInfo)oDeviceTypeLst.get(iDevTypeindex);
            iDevTypeID = oAsnSAMDevTypeFileInfo.iDevTypeId.intValue();
            DeviceTypeInfo[] oSupportedDevTypes = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByTypeID(iDevTypeID);
            if (null == oSupportedDevTypes || 0 >= oSupportedDevTypes.length) continue;
            iDevTypeVerID = oAsnSAMDevTypeFileInfo.iDevTypeVersionId.intValue();
            DeviceTypeInfo oStDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            oDevVersionLst = oAsnSAMDevTypeFileInfo.oDevVerFileInfoLst;
            oDeviceVerMap = new ConcurrentHashMap(0);
            for (int iDevVersionindex = 0; iDevVersionindex < oDevVersionLst.size(); ++iDevVersionindex) {
                oAsnSAMDevVerFileInfo = (AsnSAMDevVerFileInfo)oDevVersionLst.get(iDevVersionindex);
                strDevVersion = new String(oAsnSAMDevVerFileInfo.strDevVersion);
                AsnSAMFileInfoLst oAsnFileList = oAsnSAMDevVerFileInfo.oFileInfoLst;
                if (null == oAsnFileList || 0 == oAsnFileList.size()) continue;
                int iFileCount = oAsnFileList.size();
                if (oDeviceVerMap.containsKey(strDevVersion)) {
                    oFileInfoList = (ArrayList<ISAMFileInfo>)oDeviceVerMap.get(strDevVersion);
                    if (null == oFileInfoList) {
                        oFileInfoList = new ArrayList(0);
                    }
                } else {
                    oFileInfoList = new ArrayList<ISAMFileInfo>(0);
                }
                for (int i = 0; i < iFileCount; ++i) {
                    AsnSAMFileInfo oAsnFileInfo = (AsnSAMFileInfo)oAsnFileList.get(i);
                    oFileInfo = this.fillFileInfoObject(iDevTypeID, iDevTypeVerID, oAsnFileInfo);
                    if (!strDevVersion.equals(oFileInfo.getVersion())) continue;
                    oFileInfoList.add(oFileInfo);
                }
                if (0 == oFileInfoList.size()) continue;
                oDeviceVerMap.put(strDevVersion, oFileInfoList);
            }
            if (0 >= oDeviceVerMap.size()) continue;
            oSAMDataModel.addVersionHashMap(oStDevTypeInfo, oDeviceVerMap);
        }
    }

    public ISAMFileInfo fillFileInfoObject(int iDevTypeID, int iDevTypeVerID, AsnSAMFileInfo oAsnFileInfo) {
        SAMFileInfo oFileInfo = new SAMFileInfo();
        oFileInfo.setDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
        oFileInfo.setFileName(new String(oAsnFileInfo.strFileName));
        DCDebugTracer.trace("fillFileInfoObject:iDevTypeID:" + iDevTypeID + "  iDevTypeVerID:" + iDevTypeVerID);
        DCDebugTracer.trace("fillFileInfoObject:oFileInfo.getDeviceTypeInfo( ):" + oFileInfo.getDeviceTypeInfo());
        ContentType oContentType = SAMUtil.getFileTypeObj(oFileInfo.getDeviceTypeInfo(), oAsnFileInfo.iFileType.intValue());
        if (null == oContentType) {
            oContentType = new ContentType(oAsnFileInfo.iFileType.intValue(), oAsnFileInfo.iFileType.toString());
        }
        oFileInfo.setFileType(oContentType);
        oFileInfo.setVersion(new String(oAsnFileInfo.strVersion));
        if (null != oAsnFileInfo.strPatchVersion) {
            oFileInfo.setPatchVer(new String(oAsnFileInfo.strPatchVersion));
        } else {
            oFileInfo.setPatchVer("");
        }
        oFileInfo.setFileSize(new String(oAsnFileInfo.strSize));
        oFileInfo.setFileDescription(new String(oAsnFileInfo.strDescription));
        oFileInfo.setBDVersion(new String(oAsnFileInfo.strBDVersion));
        if (null != oAsnFileInfo.oBreakPacketResult && null != oFileInfo.getBreakPacketInfo()) {
            BreakPacketInfo oBreakPacketInfo = oFileInfo.getBreakPacketInfo();
            oBreakPacketInfo.setOperationStatus(SAMUtil.getBreakPacketStatus(oAsnFileInfo.oBreakPacketResult));
            oBreakPacketInfo.setErrorCode(oAsnFileInfo.oBreakPacketResult.oErrorInfo.iErrorNo.intValue());
        }
        return oFileInfo;
    }

    public static ContentType getFileTypeObj(DeviceTypeInfo oDeviceTypeInfo, int iContentType) {
        ContentType oContentType = null;
        if (null == oDeviceTypeInfo) {
            return null;
        }
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, null);
        if (null != deviceTypeConfigModel) {
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(5, 26);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (arrParaVals == null || arrParaVals.length == 0) {
                DCDebugTracer.trace("DC:: getFileTypeObj::arrParaVals->null/length = 0");
                return null;
            }
            oContentType = ParamUtil.getInstance().getContentType(arrParaVals, iContentType);
        }
        return oContentType;
    }

    public AsnSAMFileDeleteReq getAsnSAMFileDeleteReq(ArrayList oSAMFileDeleteLst) {
        AsnSAMFileDeleteReq oAsnSAMFileDeleteReq = new AsnSAMFileDeleteReq();
        AsnSAMFileDeleteInfo oAsnSAMFileDeleteInfo = null;
        SAMFileInfo oSAMFileInfo = null;
        for (int index = 0; index < oSAMFileDeleteLst.size(); ++index) {
            oAsnSAMFileDeleteInfo = new AsnSAMFileDeleteInfo();
            oSAMFileInfo = (SAMFileInfo)oSAMFileDeleteLst.get(index);
            oAsnSAMFileDeleteInfo.iDevTypeId = BigInteger.valueOf(oSAMFileInfo.getDeviceTypeInfo().getDevTypeID());
            oAsnSAMFileDeleteInfo.iDevTypeVersionId = BigInteger.valueOf(oSAMFileInfo.getDeviceTypeInfo().getDevTypeVersionId());
            oAsnSAMFileDeleteInfo.oFileInfo.strVersion = oSAMFileInfo.getVersion().getBytes();
            oAsnSAMFileDeleteInfo.oFileInfo.strPatchVersion = oSAMFileInfo.getPatchVer().getBytes();
            oAsnSAMFileDeleteInfo.oFileInfo.strFileName = oSAMFileInfo.getFileName().getBytes();
            oAsnSAMFileDeleteInfo.oFileInfo.strBDVersion = oSAMFileInfo.getBDVersion().getBytes();
            String strDesc = "";
            if (null != oSAMFileInfo.getFileDescription()) {
                strDesc = oSAMFileInfo.getFileDescription();
            }
            oAsnSAMFileDeleteInfo.oFileInfo.strDescription = strDesc.getBytes();
            oAsnSAMFileDeleteInfo.oFileInfo.iFileType = BigInteger.valueOf(oSAMFileInfo.getFileType().getContentTypeCode());
            String strFileSize = "0";
            oAsnSAMFileDeleteInfo.oFileInfo.strSize = strFileSize.getBytes();
            oAsnSAMFileDeleteReq.oSAMFileDeleteInfoLst.add((Object)oAsnSAMFileDeleteInfo);
        }
        return oAsnSAMFileDeleteReq;
    }

    public AsnSAMFileModifyReq getAsnSAMFileModifyReq(SAMFileInfo oSAMFileInfo, boolean bOverWrite) {
        int iDevTypeId = -1;
        int iDevTypeVersionId = -1;
        AsnSAMFileModifyReq oAsnSAMFileModifyReq = new AsnSAMFileModifyReq();
        iDevTypeId = oSAMFileInfo.getDeviceTypeInfo().getDevTypeID();
        iDevTypeVersionId = oSAMFileInfo.getDeviceTypeInfo().getDevTypeVersionId();
        oAsnSAMFileModifyReq.iDevTypeId = BigInteger.valueOf(iDevTypeId);
        oAsnSAMFileModifyReq.iDevTypeVersionId = BigInteger.valueOf(iDevTypeVersionId);
        oAsnSAMFileModifyReq.bOverWrite = bOverWrite;
        oAsnSAMFileModifyReq.strCurrentFileVersion = oSAMFileInfo.getCurrentVersion().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.strFileName = oSAMFileInfo.getFileName().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.strVersion = oSAMFileInfo.getVersion().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.strPatchVersion = oSAMFileInfo.getPatchVer().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.strDescription = oSAMFileInfo.getFileDescription().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.strBDVersion = oSAMFileInfo.getBDVersion().getBytes();
        oAsnSAMFileModifyReq.oFileInfo.iFileType = BigInteger.valueOf(oSAMFileInfo.getFileType().getContentTypeCode());
        oAsnSAMFileModifyReq.oFileInfo.strSize = oSAMFileInfo.getFileSize().getBytes();
        return oAsnSAMFileModifyReq;
    }

    public AsnSAMGetVersionReq getAsnSAMGetVersionReq(SAMFileInfo oFileInfo, int iTaskTypeId) {
        AsnSAMGetVersionReq oAsnSAMGetVersionReq = new AsnSAMGetVersionReq();
        DeviceTypeInfo oDeviceTypeInfo = oFileInfo.getDeviceTypeInfo();
        oAsnSAMGetVersionReq.iDevTypeId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeID());
        oAsnSAMGetVersionReq.iDevTypeVersionId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeVersionId());
        oAsnSAMGetVersionReq.enTaskType = TaskCommUtil.getEnumForTaskType(iTaskTypeId);
        return oAsnSAMGetVersionReq;
    }

    public AsnSAMGetVersionFileLstReq getAsnSAMGetVeersionFileLstReq(SAMFileInfo oFileInfo) {
        AsnSAMGetVersionFileLstReq oAsnSAMGetVersionFileLstReq = new AsnSAMGetVersionFileLstReq();
        DeviceTypeInfo oDeviceTypeInfo = oFileInfo.getDeviceTypeInfo();
        oAsnSAMGetVersionFileLstReq.iDevTypeId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeID());
        oAsnSAMGetVersionFileLstReq.iDevTypeVersionId = BigInteger.valueOf(oDeviceTypeInfo.getDevTypeVersionId());
        oAsnSAMGetVersionFileLstReq.strSWVersion = oFileInfo.getVersion().getBytes();
        oAsnSAMGetVersionFileLstReq.strPatchVersion = oFileInfo.getPatchVer().getBytes();
        if (null != oFileInfo.getFileType()) {
            oAsnSAMGetVersionFileLstReq.iContentType = BigInteger.valueOf(oFileInfo.getFileType().getContentTypeCode());
        }
        return oAsnSAMGetVersionFileLstReq;
    }

    public ContentType getContentType(DeviceTypeInfo oDevTypeInfo, int iContentType, boolean bisPatchTask, int[] iDeviceIdLst) {
        List oContentTypeLst = this.getContentTypesFromXMLConfig(oDevTypeInfo, bisPatchTask, iDeviceIdLst);
        int iSize = oContentTypeLst.size();
        ContentType oContentType = null;
        for (int index = 0; index < iSize; ++index) {
            oContentType = (ContentType)oContentTypeLst.get(index);
            if (iContentType == oContentType.getContentTypeCode()) {
                return oContentType;
            }
            oContentType = null;
        }
        return oContentType;
    }

    private List getContentTypesFromXMLConfig(DeviceTypeInfo oDevTypeInfo, boolean bisPatchTask, int[] iDeviceIdLst) {
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo, null);
        if (null != deviceTypeConfigModel) {
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(5, 26);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (null != arrParaVals) {
                oContTypeLst = Arrays.asList(arrParaVals);
            }
        }
        return oContTypeLst;
    }

    public static AsnDCBreakPacketReq getBreakPacketRequestForFiles(int iReqId, List<ISAMFileInfo> oFiles) {
        if (null == oFiles || 0 == oFiles.size()) {
            return null;
        }
        AsnDCBreakPacketReq oAsnDCBreakPacketReq = new AsnDCBreakPacketReq();
        oAsnDCBreakPacketReq.oReqID = BigInteger.valueOf(iReqId);
        ISAMFileInfo oFileInfo = null;
        AsnDCBreakPacket oAsnDCBreakPacket = null;
        DeviceTypeInfo oTypeInfo = null;
        int iFileCount = oFiles.size();
        for (int i = 0; i < iFileCount; ++i) {
            oAsnDCBreakPacket = new AsnDCBreakPacket();
            oFileInfo = oFiles.get(i);
            oTypeInfo = oFileInfo.getDeviceTypeInfo();
            if (null == oTypeInfo) continue;
            oAsnDCBreakPacket.iDevTypeId = BigInteger.valueOf(oTypeInfo.getDevTypeID());
            oAsnDCBreakPacket.iDevTypeVersionId = BigInteger.valueOf(oTypeInfo.getDevTypeVersionId());
            oAsnDCBreakPacket.oFileInfo = SAMUtil.getAsnSAMFileInfoFromFileInfo(oFileInfo);
            oAsnDCBreakPacketReq.oAsnDCBreakPacketLst.add((Object)oAsnDCBreakPacket);
        }
        return oAsnDCBreakPacketReq;
    }

    public static AsnSAMFileInfo getAsnSAMFileInfoFromFileInfo(ISAMFileInfo oSAMFileInfo) {
        AsnSAMFileInfo oAsnSAMFileInfo = new AsnSAMFileInfo();
        oAsnSAMFileInfo.strFileName = oSAMFileInfo.getFileName().getBytes();
        oAsnSAMFileInfo.strVersion = oSAMFileInfo.getVersion().getBytes();
        String strPatch = "";
        if (null != oSAMFileInfo.getPatchVer()) {
            strPatch = oSAMFileInfo.getPatchVer();
        }
        oAsnSAMFileInfo.strPatchVersion = strPatch.getBytes();
        String strDesc = "";
        if (null != oSAMFileInfo.getFileDescription()) {
            strDesc = oSAMFileInfo.getFileDescription();
        }
        oAsnSAMFileInfo.strDescription = strDesc.getBytes();
        int iFileType = 0;
        ContentType oContentType = oSAMFileInfo.getFileType();
        if (null != oContentType) {
            iFileType = oContentType.getContentTypeCode();
        }
        oAsnSAMFileInfo.iFileType = BigInteger.valueOf(iFileType);
        String strFileSize = "0";
        oAsnSAMFileInfo.strSize = strFileSize.getBytes();
        String BDVersion = oSAMFileInfo.getBDVersion();
        if (BDVersion == null) {
            BDVersion = "";
        }
        oAsnSAMFileInfo.strBDVersion = BDVersion.getBytes();
        return oAsnSAMFileInfo;
    }

    public ISAMFileInfo getSAMFileFromModel(AsnSAMFileInfo oAsnSAMFileInfo, int iDeviceTypeId, int iDeviceTypeVersionId) {
        String strFileName = new String(oAsnSAMFileInfo.strFileName);
        String strVersion = new String(oAsnSAMFileInfo.strVersion);
        String strPatchVersion = "";
        if (null != oAsnSAMFileInfo.strPatchVersion) {
            strPatchVersion = new String(oAsnSAMFileInfo.strPatchVersion);
        }
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDeviceTypeId, iDeviceTypeVersionId);
        DCDebugTracer.trace("getSAMFileFromModel:iDeviceTypeId:" + iDeviceTypeId + "  iDeviceTypeVersionId:" + iDeviceTypeVersionId);
        DCDebugTracer.trace("getSAMFileFromModel:oDeviceTypeInfo:" + oDeviceTypeInfo);
        DCDebugTracer.trace("getSAMFileFromModel:oAsnSAMFileInfo.oFileInfo.iFileType:" + oAsnSAMFileInfo.toString());
        ContentType oContentType = SAMUtil.getFileTypeObj(oDeviceTypeInfo, oAsnSAMFileInfo.iFileType.intValue());
        return SAMDataModel.getInstance().getSAMFileInfo(oDeviceTypeInfo, strVersion, strPatchVersion, oContentType, strFileName);
    }

    public static int getBreakPacketStatus(AsnDCBreakPacketResult oBreakPacketResult) {
        switch (oBreakPacketResult.enStatus.value) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                int iErrorCode = oBreakPacketResult.oErrorInfo.iErrorNo.intValue();
                if (0 == iErrorCode) {
                    return 3;
                }
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void setToNULL() {
        m_oSAMUtil = null;
    }

    public void samFileDelete(ArrayList<ISAMFileInfo> oFileDeletionList) {
        SAMOperationProgressDlg oProgressDlg = new SAMOperationProgressDlg(oFileDeletionList, 43948);
        oProgressDlg.setTitle(DCFrameWorkUtil.getLocalizedString("SAM_DELETE_PROGRESS_DIALOG_TITLE"));
        oProgressDlg.setColumnShowForDelete();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oProgressDlg.setProgressDlgId(iReqId);
        try {
            SAMManager.getInstance().sendSAMFiledeleteReq(iReqId, oFileDeletionList);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return;
        }
        oProgressDlg.setVisible(true);
    }
}

