/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.sam;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.sam.ISAMFileTransfer;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.huawei.dc.sam.view.SAMFileInfoImportPanelHelper;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class SAMFileTransHandler
implements IDCObjectDeallocator {
    private static SAMFileTransHandler m_oSAMFileTransHandler = new SAMFileTransHandler();
    private static byte[] m_oSyncObject = new byte[0];
    private HashMap m_ReqidCancelSelectedMap = new HashMap(0);
    private boolean m_bCancelSelected = false;
    private int m_iOpRequestId = -1;
    private static int m_iErrorcode = -1;
    private SAMFileInfoImportPanel m_oSAMFileInfoImportPanel;

    public void setSAMFileImportPanel(SAMFileInfoImportPanel oSAMFileInfoImportPanel) {
        this.m_oSAMFileInfoImportPanel = oSAMFileInfoImportPanel;
        DCObjectDestructor.getInstance().addObjectForDestructor(m_oSAMFileTransHandler);
    }

    public static SAMFileTransHandler getInstance() {
        return m_oSAMFileTransHandler;
    }

    @Override
    public void setToNULL() {
        if (null != this.m_ReqidCancelSelectedMap) {
            this.m_ReqidCancelSelectedMap.clear();
            this.m_ReqidCancelSelectedMap = null;
        }
        m_oSAMFileTransHandler = null;
    }

    public void startTransferingFiles(List<String> oFileList, String strSource, String strDest) {
        boolean isSomeFilePresent = this.checkIfFilesPresent(oFileList, strSource);
        if (!isSomeFilePresent) {
            this.m_oSAMFileInfoImportPanel.setImportPanelWithoutProgressBar();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("SAM_WHOLE_VERSION_FILES_NOT_FOUND"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            this.m_oSAMFileInfoImportPanel.setTextFieldsEmpty();
            return;
        }
        SFTPFileTransferHandler progressHandler = new SFTPFileTransferHandler(oFileList, strSource, strDest);
        progressHandler.start();
    }

    private boolean checkIfFilesPresent(List<String> oFileNameLst, String strSource) {
        int iSizeOfLst = oFileNameLst.size();
        ArrayList<String> oFileNotPresentLst = new ArrayList<String>(0);
        ArrayList<String> oFileNameNotPresentLst = new ArrayList<String>(0);
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            String strFileName = oFileNameLst.get(i);
            strFileName = strSource + File.separatorChar + strFileName;
            File oCheckFileObj = new File(strFileName);
            if (oCheckFileObj.exists()) continue;
            oFileNotPresentLst.add(strFileName);
            oFileNameNotPresentLst.add(oFileNameLst.get(i));
            oFileNameLst.remove(i);
        }
        if (0 < oFileNotPresentLst.size()) {
            if (iSizeOfLst == oFileNotPresentLst.size()) {
                return false;
            }
            this.m_oSAMFileInfoImportPanel.updateWholeVersionFileListMap(oFileNameNotPresentLst);
            SAMFileInfoImportPanelHelper.displayMessage(oFileNotPresentLst);
        }
        return true;
    }

    private int generateReqId() {
        Calendar oCal = Calendar.getInstance();
        StringBuffer strReqId = new StringBuffer(100);
        strReqId.append(oCal.get(10));
        strReqId.append(oCal.get(12));
        strReqId.append(oCal.get(13));
        return Integer.parseInt(strReqId.toString());
    }

    public void resetReqIdOnCancel() {
        this.m_bCancelSelected = true;
        this.m_ReqidCancelSelectedMap.put(this.m_iOpRequestId, this.m_bCancelSelected);
        this.m_iOpRequestId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFileTransferProgress(int iErrorCode) {
        m_iErrorcode = iErrorCode;
        byte[] byArray = m_oSyncObject;
        synchronized (m_oSyncObject) {
            m_oSyncObject.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    class SaveAsFileTransferThreadExt
    implements Runnable {
        private String m_strSourcePath;
        private ClientFileOperations oclientFileOperations;
        private String strRootDir;
        private String m_strDestFileName;
        private ISAMFileTransfer m_oFileTransfer;

        public SaveAsFileTransferThreadExt(String strDestinationFilename, String strFilePath, ISAMFileTransfer oFileTransfer) {
            this.m_oFileTransfer = oFileTransfer;
            this.m_strDestFileName = strDestinationFilename;
            this.m_strSourcePath = strFilePath;
            this.oclientFileOperations = new ClientFileOperations();
            SystemManager sysMgr = new SystemManager();
            this.strRootDir = sysMgr.getSystemServerFTPRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int iSAMFileErrorcode = 0;
            int iOperationRequestId = -1;
            int iFileIndex = this.strRootDir.length();
            this.m_strDestFileName = this.m_strDestFileName.substring(iFileIndex);
            iOperationRequestId = SAMFileTransHandler.this.m_iOpRequestId;
            SAMFileTransHandler.this.m_ReqidCancelSelectedMap.put(iOperationRequestId, Boolean.FALSE);
            this.oclientFileOperations.putFilesForSAMWholeVersion(this.m_strSourcePath, this.m_strDestFileName, SAMFileTransHandler.this.m_iOpRequestId, SAMFileTransHandler.this.m_oSAMFileInfoImportPanel);
            byte[] byArray = m_oSyncObject;
            synchronized (byArray) {
                try {
                    m_oSyncObject.wait(DCConstants.DEFAULT_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            iSAMFileErrorcode = m_iErrorcode;
            SAMFileTransHandler.this.m_bCancelSelected = (Boolean)SAMFileTransHandler.this.m_ReqidCancelSelectedMap.get(iOperationRequestId);
            if (!SAMFileTransHandler.this.m_bCancelSelected) {
                if (0 == iSAMFileErrorcode) {
                    this.m_oFileTransfer.onSuccess();
                } else {
                    this.m_oFileTransfer.onFailure(iSAMFileErrorcode);
                }
            } else {
                this.m_oFileTransfer.onCancel();
            }
            SAMFileTransHandler.this.m_ReqidCancelSelectedMap.remove(iOperationRequestId);
        }
    }

    private class SFTPFileTransferHandler
    implements ISAMFileTransfer {
        private List<String> m_oFileList;
        private String m_strSource;
        private String m_strDestination;
        private int iCurIndex = 0;
        private int iFileCount;

        SFTPFileTransferHandler(List<String> oFileLst, String strSource, String strDest) {
            this.m_oFileList = oFileLst;
            this.iFileCount = oFileLst.size();
            this.m_strSource = strSource;
            this.m_strDestination = strDest;
        }

        public void start() {
            SAMFileTransHandler.this.m_iOpRequestId = SAMFileTransHandler.this.generateReqId();
            SaveAsFileTransferThreadExt oSaveasFileTransferThreadExt = this.getNext();
            Thread oThread = new Thread(oSaveasFileTransferThreadExt);
            oThread.start();
        }

        private SaveAsFileTransferThreadExt getNext() {
            if (this.iCurIndex < this.iFileCount) {
                SAMFileTransHandler.this.m_iOpRequestId = SAMFileTransHandler.this.generateReqId();
                String strSourcePath = this.m_strSource + "/" + this.m_oFileList.get(this.iCurIndex);
                String destSourcePath = this.m_strDestination + "/" + this.m_oFileList.get(this.iCurIndex);
                SaveAsFileTransferThreadExt oSaveasFileTransferThreadExt = new SaveAsFileTransferThreadExt(destSourcePath, strSourcePath, this);
                ++this.iCurIndex;
                SAMFileTransHandler.this.m_oSAMFileInfoImportPanel.setFileProgressInfo(this.iFileCount, this.iCurIndex);
                return oSaveasFileTransferThreadExt;
            }
            return null;
        }

        @Override
        public void onCancel() {
        }

        @Override
        public void onFailure(int iSAMFileErrorcode) {
            SAMFileTransHandler.this.m_oSAMFileInfoImportPanel.handleCancelBtnActinPerformed();
            SAMFileTransHandler.this.m_oSAMFileInfoImportPanel.setTextFieldsEmpty();
            SAMFileTransHandler.this.m_oSAMFileInfoImportPanel.setImportPanelWithoutProgressBar();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iSAMFileErrorcode, DCFrameWorkUtil.getLocalizedString("BACKUP_FILES_SFTP_ERROR"), 0);
        }

        @Override
        public void onSuccess() {
            if (this.iCurIndex == this.iFileCount) {
                SAMFileTransHandler.this.m_oSAMFileInfoImportPanel.setImportPanelWithoutProgressBar();
            } else {
                Thread oThread = new Thread(this.getNext());
                oThread.start();
            }
        }
    }
}

