/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.policy.controller.PolicyConstants;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TimerCommonPanel
extends JPanel {
    private static final long serialVersionUID = 2539949778523592522L;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private String m_sBorderTitle = "";
    private JLabel m_oInfoLbl = null;
    private JLabel m_oPeriodLbl = null;
    private ComboBoxWithToolTip m_oPeriodCombox = null;
    private JLabel m_oTimeLbl = null;
    private Spinner m_oTimeSpinner = null;
    private NumericSpinnerModel m_oHourTimeModel = null;
    private NumericSpinnerModel m_oMinuteTimeModel = null;
    private boolean m_bConfigChangeBackup = false;
    private int HOUR_MIN_VAL = 1;
    private int HOUR_MAX_VAL = 24;
    private int MINUTE_MIN_VAL = 1;
    private int MINUTE_MAX_VAL = 1440;

    public TimerCommonPanel(boolean bConfigChangeBackup) {
        this.m_bConfigChangeBackup = bConfigChangeBackup;
        this.initGUI();
    }

    private void initGUI() {
        this.initMinAndMax();
        this.initComponent();
        this.addComponent();
        this.initData();
        this.addComponentActionListener();
    }

    private void initData() {
        this.m_oPeriodCombox.addItem(this.m_oRes.getResString("POLICY_CONFIG_CHANGE_HOUR_TIME_UNIT"));
        this.m_oPeriodCombox.addItem(this.m_oRes.getResString("POLICY_CONFIG_CHANGE_MINUTE_TIME_UNIT"));
    }

    private void addComponentActionListener() {
        this.m_oPeriodCombox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    return;
                }
                int iVal = (Integer)TimerCommonPanel.this.m_oTimeSpinner.getModel().getValue();
                int iPeriod = TimerCommonPanel.this.m_oPeriodCombox.getSelectedIndex();
                if (0 == iPeriod) {
                    if ((iVal /= 60) < TimerCommonPanel.this.HOUR_MIN_VAL) {
                        iVal = TimerCommonPanel.this.HOUR_MIN_VAL;
                    }
                    if (iVal > TimerCommonPanel.this.HOUR_MAX_VAL) {
                        iVal = TimerCommonPanel.this.HOUR_MAX_VAL;
                    }
                    TimerCommonPanel.this.m_oHourTimeModel.setValue((Object)iVal);
                    TimerCommonPanel.this.m_oTimeSpinner.setModel((SpinnerModel)TimerCommonPanel.this.m_oHourTimeModel);
                } else {
                    if ((iVal *= 60) < TimerCommonPanel.this.MINUTE_MIN_VAL) {
                        iVal = TimerCommonPanel.this.MINUTE_MIN_VAL;
                    }
                    if (iVal > TimerCommonPanel.this.MINUTE_MAX_VAL) {
                        iVal = TimerCommonPanel.this.MINUTE_MAX_VAL;
                    }
                    TimerCommonPanel.this.m_oMinuteTimeModel.setValue((Object)iVal);
                    TimerCommonPanel.this.m_oTimeSpinner.setModel((SpinnerModel)TimerCommonPanel.this.m_oMinuteTimeModel);
                }
            }
        });
    }

    private void initMinAndMax() {
        if (this.m_bConfigChangeBackup) {
            this.initMinAndMaxValue(1, 60);
        } else {
            this.initMinAndMaxValue(30, 43200);
        }
    }

    private void initMinAndMaxValue(int iMinVlue, int iMaxValue) {
        this.MINUTE_MIN_VAL = iMinVlue;
        this.MINUTE_MAX_VAL = iMaxValue;
        this.HOUR_MIN_VAL = 0 >= iMinVlue / 60 ? 1 : iMinVlue / 60;
        this.HOUR_MAX_VAL = 0 >= iMaxValue / 60 ? 1 : iMaxValue / 60;
    }

    private void initComponent() {
        this.m_oInfoLbl = new JLabel();
        if (this.m_bConfigChangeBackup) {
            this.m_sBorderTitle = this.m_oRes.getResString("POLICY_TIMER_DLG_CONFIG_BORDER_TLE");
            this.m_oInfoLbl.setText(this.m_oRes.getResString("POLICY_TIMER_DLG_CONFIG_INFO"));
        } else {
            this.m_sBorderTitle = this.m_oRes.getResString("POLICY_TIMER_DLG_NOT_CONFIG_BORDER_TLE");
            this.m_oInfoLbl.setText(this.m_oRes.getResString("POLICY_TIMER_DLG_NOT_CONFIG_INFO"));
        }
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, PolicyConstants.PANEL_BORDER_COLOR), this.m_sBorderTitle);
        this.setBorder(oBorder);
        this.m_oPeriodLbl = new JLabel();
        this.m_oPeriodLbl.setText(this.m_oRes.getResString("POLICY_CONFIG_CHANGE_TIME_UNIT_LABEL"));
        this.m_oPeriodLbl.setPreferredSize(new Dimension(130, 20));
        this.m_oPeriodLbl.setMinimumSize(new Dimension(130, 20));
        this.m_oTimeLbl = new JLabel();
        this.m_oTimeLbl.setText(this.m_oRes.getResString("POLICY_CONFIG_CHANGE_TIME_LABEL"));
        this.m_oPeriodCombox = new ComboBoxWithToolTip();
        this.m_oPeriodCombox.setPreferredSize(new Dimension(130, 20));
        this.m_oPeriodCombox.setMinimumSize(new Dimension(130, 20));
        this.m_oHourTimeModel = new NumericSpinnerModel(1, this.HOUR_MIN_VAL, this.HOUR_MAX_VAL, 1);
        this.m_oMinuteTimeModel = new NumericSpinnerModel(60, this.MINUTE_MIN_VAL, this.MINUTE_MAX_VAL, 1);
        this.m_oTimeSpinner = new Spinner((SpinnerModel)this.m_oMinuteTimeModel);
        this.m_oTimeSpinner.setPreferredSize(new Dimension(130, 20));
        this.m_oTimeSpinner.setMinimumSize(new Dimension(130, 20));
    }

    private void addComponent() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_oInfoLbl, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oPeriodLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oPeriodCombox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oTimeLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.add((Component)this.m_oTimeSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
    }

    public void setPeriod(int iPeriod) {
        if (iPeriod >= this.m_oPeriodCombox.getItemCount()) {
            return;
        }
        this.m_oPeriodCombox.setSelectedIndex(iPeriod);
        if (0 == iPeriod) {
            this.m_oTimeSpinner.setModel((SpinnerModel)this.m_oHourTimeModel);
        } else {
            this.m_oTimeSpinner.setModel((SpinnerModel)this.m_oMinuteTimeModel);
        }
    }

    public int getPeriod() {
        return this.m_oPeriodCombox.getSelectedIndex();
    }

    public void setTime(int iTime) {
        int iPeriod = this.m_oPeriodCombox.getSelectedIndex();
        if (0 == iPeriod) {
            this.m_oHourTimeModel.setValue((Object)iTime);
        } else {
            this.m_oMinuteTimeModel.setValue((Object)iTime);
        }
    }

    public String getTime() {
        return String.valueOf(this.m_oTimeSpinner.getValue());
    }

    public boolean validateTimeInfo() {
        boolean bValid = true;
        int iConfigPeriod = this.getPeriod();
        int iTime = (Integer)this.m_oTimeSpinner.getValue();
        if (iConfigPeriod == 1 && iTime < this.MINUTE_MIN_VAL) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("STATIC_BACKUP_TIME_ERROR"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return false;
        }
        return bValid;
    }
}

