/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.view.advanced.TimerCommonPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimerBakcupDlg
extends DCModalDialog {
    private static final long serialVersionUID = 3234855718729682412L;
    private JPanel m_oPolicyStatePanel = null;
    private JRadioButton oRunStatusRadioBtn = null;
    private JRadioButton oStopStatusRadioBtn = null;
    private TimerCommonPanel m_oConfigPanel = null;
    private TimerCommonPanel m_oNotConfigpanel = null;
    private JPanel m_oBtnPanel = null;
    private static final int WIDTH = 680;
    private static final int HEIGHT = 396;
    private static final int ZERO = 0;
    private static final double ZERODOT = 0.0;
    private static final int ONE = 1;
    private static final double ONEDOT = 1.0;
    private static final int TWELVE = 12;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int SIX = 6;
    private ConfigChangePolicyInfo m_oCofnigInfo = null;
    ResourceManager m_oRes = ResourceManager.getInstance();

    public TimerBakcupDlg(ConfigChangePolicyInfo oConfigInfo) {
        this.initGUI();
        this.addComponent();
        this.initData(oConfigInfo);
        this.setSize(680, 396);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initGUI() {
        this.m_oPolicyStatePanel = this.getPolicyStatePanel();
        this.m_oConfigPanel = new TimerCommonPanel(true);
        this.m_oNotConfigpanel = new TimerCommonPanel(false);
        this.initButtonPanel();
    }

    private void initData(ConfigChangePolicyInfo oConfigInfo) {
        this.m_oCofnigInfo = oConfigInfo;
        if (null == oConfigInfo) {
            return;
        }
        int iStatus = oConfigInfo.getBackupPolicyStatus();
        boolean bRunStatus = iStatus == 0;
        this.oRunStatusRadioBtn.setSelected(bRunStatus);
        this.oStopStatusRadioBtn.setSelected(!bRunStatus);
        int iConfigPeriod = oConfigInfo.getSpecificBackupPeriod();
        int iConfigTime = Integer.parseInt(oConfigInfo.getSpecificBackupPolicyTime());
        this.m_oConfigPanel.setPeriod(iConfigPeriod);
        this.m_oConfigPanel.setTime(iConfigTime);
        int iNotConfigPeriod = oConfigInfo.getSpecificStaticBackupPeriod();
        int iNotConfigTime = Integer.parseInt(oConfigInfo.getSpecificStaticBackupPolicyTime());
        this.m_oNotConfigpanel.setPeriod(iNotConfigPeriod);
        this.m_oNotConfigpanel.setTime(iNotConfigTime);
    }

    private void initButtonPanel() {
        this.m_oBtnPanel = new JPanel();
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oBtnPanel.setPreferredSize(new Dimension(300, 21));
        this.m_oBtnPanel.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oBtnPanel.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_oBtnPanel.add(this.m_oOKBtn);
        this.m_oBtnPanel.add(this.m_oCancelBtn);
    }

    private void addComponent() {
        this.setLayout(new GridBagLayout());
        this.setTitle(this.m_oRes.getResString("POLICY_TIMER_DLG_TLE"));
        this.getContentPane().add((Component)this.m_oPolicyStatePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oConfigPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oNotConfigpanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oBtnPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 12, 6), 0, 0));
    }

    private JPanel getPolicyStatePanel() {
        if (null != this.m_oPolicyStatePanel) {
            return this.m_oPolicyStatePanel;
        }
        JLabel m_oPolicyStateLbl = null;
        ButtonGroup oRadioBtnGroup = null;
        this.oRunStatusRadioBtn = null;
        this.oStopStatusRadioBtn = null;
        this.m_oPolicyStatePanel = new JPanel();
        this.m_oPolicyStatePanel.setLayout(new GridBagLayout());
        m_oPolicyStateLbl = new JLabel();
        m_oPolicyStateLbl.setText(this.m_oRes.getResString("NXU_MODIFY_POLICY_STATE_LBL"));
        this.oRunStatusRadioBtn = new JRadioButton();
        this.oRunStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_RUN"));
        this.oRunStatusRadioBtn.setSelected(true);
        this.oStopStatusRadioBtn = new JRadioButton();
        this.oStopStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_STOP"));
        oRadioBtnGroup = new ButtonGroup();
        oRadioBtnGroup.add(this.oRunStatusRadioBtn);
        oRadioBtnGroup.add(this.oStopStatusRadioBtn);
        this.m_oPolicyStatePanel.add((Component)m_oPolicyStateLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oPolicyStatePanel.add((Component)this.oRunStatusRadioBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oPolicyStatePanel.add((Component)this.oStopStatusRadioBtn, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        return this.m_oPolicyStatePanel;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        boolean bRunSelected = this.oRunStatusRadioBtn.isSelected();
        if (bRunSelected) {
            this.m_oCofnigInfo.setBackupPolicyStatus(0);
        } else {
            this.m_oCofnigInfo.setBackupPolicyStatus(1);
        }
        boolean isNotConfigValid = this.m_oNotConfigpanel.validateTimeInfo();
        if (!isNotConfigValid) {
            return;
        }
        int iConfigPeriod = this.m_oConfigPanel.getPeriod();
        String sConfigTime = this.m_oConfigPanel.getTime();
        this.m_oCofnigInfo.setSpecificBackupPeriod(iConfigPeriod);
        this.m_oCofnigInfo.setSpecificBackupPolicyTime(sConfigTime);
        int iNotConfigPeriod = this.m_oNotConfigpanel.getPeriod();
        String sNotConfigTime = this.m_oNotConfigpanel.getTime();
        this.m_oCofnigInfo.setSpecificStaticBackupPeriod(iNotConfigPeriod);
        this.m_oCofnigInfo.setSpecificStaticBackupPolicyTime(sNotConfigTime);
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

