/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.policy.controller.BooleanColumnRederer;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.view.advanced.AdvancedMainPanel;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RouteTablePanel
extends AdvancedMainPanel {
    private static final long serialVersionUID = 732596220868801271L;

    public RouteTablePanel(int iTabIndex, int iPolicyID, List<PolicyDevTypeProperties> odevProLst, int iCmdType) {
        super(iTabIndex, iPolicyID, odevProLst, iCmdType);
    }

    @Override
    protected void initTableModel() {
        this.m_oTableModel = new SortableTableModel(this.getColumns(), 0){
            private static final long serialVersionUID = -7719353357214830213L;

            public boolean isCellEditable(int row, int column) {
                if (RouteTablePanel.this.m_iCmdType == 1) {
                    return false;
                }
                Object oCellValue = this.getValueAt(row, column);
                if (null == oCellValue || oCellValue instanceof String && ((String)oCellValue).equals("--")) {
                    return false;
                }
                return column == 2 || column == 3 || column == 4 || column == 5 || column == 6 || column == 7;
            }
        };
    }

    @Override
    protected void initTableRender(int iRowNum) {
        super.initTableRender(iRowNum);
        this.setName("policy_RouteTablePanel");
        ChckBoxHeaderItemLstner oSaveChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oTable.getColumnModel().getColumn(5);
        this.m_oSaveCheckBoxHeader = new CheckBoxHeader((ItemListener)oSaveChckItemListener, true, this, this.m_oTable.getTableHeader().getBackground(), 5);
        oSaveCoulmn.setHeaderRenderer(this.m_oSaveCheckBoxHeader);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 28));
        this.m_oTable.getColumnModel().getColumn(5).setCellRenderer(new BooleanColumnRederer());
        ChckBoxHeaderItemLstner oConfigChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oConfigChange = this.m_oTable.getColumnModel().getColumn(6);
        this.m_oConfigCheckBoxHeader = new CheckBoxHeader((ItemListener)oConfigChckItemListener, true, this, this.m_oTable.getTableHeader().getBackground(), 6);
        oConfigChange.setHeaderRenderer(this.m_oConfigCheckBoxHeader);
        this.m_oTable.getColumnModel().getColumn(6).setMinWidth(80);
        this.m_oTable.getColumnModel().getColumn(6).setCellRenderer(new BooleanColumnRederer());
        ChckBoxHeaderItemLstner oTimerChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oTimerColumn = this.m_oTable.getColumnModel().getColumn(7);
        this.m_oTimerCheckBoxHeader = new CheckBoxHeader((ItemListener)oTimerChckItemListener, true, this, this.m_oTable.getTableHeader().getBackground(), 7);
        oTimerColumn.setHeaderRenderer(this.m_oTimerCheckBoxHeader);
        this.m_oTable.getColumnModel().getColumn(7).setCellRenderer(new BooleanColumnRederer());
        this.m_oTable.addMouseMotionListener((MouseMotionListener)new OperationTableMouseMotionListener());
    }

    @Override
    protected void initData(List<PolicyDevTypeProperties> odevProLst) {
        this.m_oDevProLst = odevProLst;
        this.m_oTableModel.getDataVector().clear();
        PolicyDevTypeProperties oDevTypePro = null;
        int iSaveSelectCount = 0;
        int iSaveNotSupportCount = 0;
        int iConfigSelectCount = 0;
        int iConfigNotSupportCount = 0;
        int iTimerSelectCount = 0;
        int iTimerNotSupportCount = 0;
        for (int i = 0; i < odevProLst.size(); ++i) {
            Object[] oCellData = new Object[this.getColumns().length];
            oDevTypePro = odevProLst.get(i);
            int iDevTypeID = oDevTypePro.getDevTypeID();
            String sDevTypeName = oDevTypePro.getDevTypeName();
            ComboBoxWithToolTip oContentTypeCombox = this.m_oContentType[i];
            ComboBoxWithToolTip oDestinationCombox = this.m_oDestinationComboBox[i];
            ComboBoxWithToolTip oMaxbackupNumBox = this.m_oMaxBackupNumComboxs[i];
            Object oSaveBeforeBackup = oDevTypePro.isSaveBeforeBackup();
            if (null == oSaveBeforeBackup) {
                ++iSaveNotSupportCount;
            } else if (null != oSaveBeforeBackup && ((Boolean)oSaveBeforeBackup).booleanValue()) {
                ++iSaveSelectCount;
            }
            int iConfigChange = oDevTypePro.getSpecialPolicyStatus(1);
            Boolean oConfigChange = null;
            if (iConfigChange == 0) {
                ++iConfigSelectCount;
                oConfigChange = true;
            } else if (iConfigChange == 1) {
                oConfigChange = false;
            } else {
                ++iConfigNotSupportCount;
                oConfigChange = null;
            }
            Boolean oTimerBackup = null;
            int iTimerBackup = oDevTypePro.getSpecialPolicyStatus(0);
            if (iTimerBackup == 0) {
                ++iTimerSelectCount;
                oTimerBackup = true;
            } else if (iTimerBackup == 1) {
                oTimerBackup = false;
            } else {
                ++iTimerNotSupportCount;
                oTimerBackup = null;
            }
            ConfigChangePolicyInfo oTimerObj = null;
            if (null != oTimerBackup) {
                oTimerObj = oDevTypePro.getConfigChangePolicyInfo(0);
            }
            oCellData[0] = iDevTypeID;
            oCellData[1] = sDevTypeName;
            oCellData[2] = oContentTypeCombox;
            oCellData[3] = oDestinationCombox;
            oCellData[4] = oMaxbackupNumBox;
            oCellData[5] = oSaveBeforeBackup;
            oCellData[6] = oConfigChange;
            oCellData[7] = oTimerObj;
            this.m_oTableModel.addRow(oCellData);
        }
        this.m_oTableModel.fireTableRowsUpdated(0, odevProLst.size() - 1);
        if (this.m_oTable.getRowCount() > 0) {
            this.m_oTable.setRowSelectionInterval(this.m_iDefaultSelectedRow, this.m_iDefaultSelectedRow);
        }
        this.initHeadStatus(5, iSaveSelectCount, iSaveNotSupportCount, this.m_oDevProLst.size());
        this.m_oSaveCheckBoxHeader.handleHeaderChckBxChanges(5);
        this.initHeadStatus(6, iConfigSelectCount, iConfigNotSupportCount, this.m_oDevProLst.size());
        this.m_oConfigCheckBoxHeader.handleHeaderChckBxChanges(6);
        this.initHeadStatus(7, iTimerSelectCount, iTimerNotSupportCount, this.m_oDevProLst.size());
        this.m_oTimerCheckBoxHeader.handleHeaderChckBxChanges(7);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RouteTablePanel.this.m_oTable.updateUI();
                RouteTablePanel.this.m_oTable.getTableHeader().repaint();
            }
        });
    }

    @Override
    protected PolicyDevTypeProperties getPolicyDevProForRow(Vector oRowVector, int iRow) {
        PolicyDevTypeProperties oDevPro = new PolicyDevTypeProperties();
        int iDevTypeID = (Integer)oRowVector.get(0);
        String sDevTypeName = oRowVector.get(1).toString();
        Object oContentTypeObj = oRowVector.get(2);
        int iBackupContentType = this.getContentTypeValueFromTable(oContentTypeObj, iRow);
        String strDestination = this.getDestinationFromTable(iRow);
        Object oMaxNumObj = oRowVector.get(4);
        int iBackuMaxNum = this.getMaxNumValueFromTable(oMaxNumObj, iRow);
        Object oSaveBefore = oRowVector.get(5);
        Object oConfigChange = oRowVector.get(6);
        Object oTimerBackup = oRowVector.get(7);
        oDevPro.setDevTypeID(iDevTypeID);
        oDevPro.setDevTypeName(sDevTypeName);
        oDevPro.setBackupContentType(iBackupContentType);
        oDevPro.setStrDestination(strDestination);
        oDevPro.setNumOfBackupCopies(iBackuMaxNum);
        oDevPro.setSaveBeforeBackup(oSaveBefore);
        if (null != oConfigChange) {
            boolean bConfigChange = (Boolean)oConfigChange;
            int iSpecialBackupStatus = bConfigChange ? 0 : 1;
            oDevPro.setConfigChangeBakcupStatus(1, iSpecialBackupStatus);
        }
        if (null != oTimerBackup) {
            ConfigChangePolicyInfo oTimeConfig = (ConfigChangePolicyInfo)oRowVector.get(7);
            oDevPro.setConfigChangeInfo(0, oTimeConfig);
        }
        return oDevPro;
    }

    @Override
    protected void refreshDevProLst(List<PolicyDevTypeProperties> oDevProLst, PolicyDevTypeProperties oDevPro) {
        for (PolicyDevTypeProperties oDevProInfo : oDevProLst) {
            if (oDevProInfo.getDevTypeID() != oDevPro.getDevTypeID()) continue;
            oDevProInfo.setBackupContentType(oDevPro.getBackupContentType());
            oDevProInfo.setStrDestination(oDevPro.getStrDestination());
            oDevProInfo.setNumOfBackupCopies(oDevPro.getNumOfBackupCopies());
            oDevProInfo.setSaveBeforeBackup(oDevPro.isSaveBeforeBackup());
            if (oDevProInfo.getSpecialPolicyStatus(1) != -1) {
                oDevProInfo.setConfigChangeBakcupStatus(1, oDevPro.getSpecialPolicyStatus(1));
            }
            if (oDevPro.getSpecialPolicyStatus(0) == -1) continue;
            oDevProInfo.setConfigChangeBakcupStatus(0, oDevPro.getSpecialPolicyStatus(0));
        }
    }

    private void handleSaveItemChange() {
        boolean bAllSelect = false;
        if (0 == this.m_iSaveSelectionType) {
            bAllSelect = false;
        } else if (1 == this.m_iSaveSelectionType || 2 == this.m_iSaveSelectionType) {
            bAllSelect = true;
        }
        this.setHeadStatus(5, bAllSelect);
        this.m_oSaveCheckBoxHeader.handleHeaderChckBxChanges(5);
    }

    private void handleConfigItemChange() {
        boolean bAllSelect = false;
        if (0 == this.m_iConfigSelectionType) {
            bAllSelect = false;
        } else if (1 == this.m_iConfigSelectionType || 2 == this.m_iConfigSelectionType) {
            bAllSelect = true;
        }
        this.setHeadStatus(6, bAllSelect);
        this.m_oConfigCheckBoxHeader.handleHeaderChckBxChanges(6);
    }

    private void handleTimerItemChange() {
        boolean bAllSelect = false;
        if (0 == this.m_iTimerSelectionType) {
            bAllSelect = false;
        } else if (1 == this.m_iTimerSelectionType || 2 == this.m_iTimerSelectionType) {
            bAllSelect = true;
        }
        this.setHeadStatus(7, bAllSelect);
        this.m_oTimerCheckBoxHeader.handleHeaderChckBxChanges(7);
    }

    @Override
    protected int getHeadStatus(int iColumn) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            ConfigChangePolicyInfo oConfig;
            Object oo = oItor.next();
            Object xx = ((Vector)oo).get(iColumn);
            if (null == xx) {
                ++iNotSupportCount;
                continue;
            }
            if (xx instanceof Boolean && ((Boolean)xx).booleanValue()) {
                ++iSelectCount;
                continue;
            }
            if (!(xx instanceof ConfigChangePolicyInfo) || !(oConfig = (ConfigChangePolicyInfo)xx).isSelected()) continue;
            ++iSelectCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
        switch (iColumn) {
            case 5: {
                return this.m_iSaveSelectionType;
            }
            case 6: {
                return this.m_iConfigSelectionType;
            }
            case 7: {
                return this.m_iTimerSelectionType;
            }
        }
        return this.m_iSaveSelectionType;
    }

    private void setHeadStatus(int iColumn, boolean bAllSelect) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            Object oo = oItor.next();
            Object iColumnObj = ((Vector)oo).get(iColumn);
            if (null != iColumnObj) {
                Object oCellObj = ((Vector)oo).get(iColumn);
                if (!(oCellObj instanceof ConfigChangePolicyInfo)) {
                    ((Vector)oo).set(iColumn, bAllSelect);
                } else {
                    ConfigChangePolicyInfo oConfig = (ConfigChangePolicyInfo)oCellObj;
                    oConfig.setSelected(bAllSelect);
                    ((Vector)oo).set(iColumn, oConfig);
                }
                if (!bAllSelect) continue;
                ++iSelectCount;
                continue;
            }
            ++iNotSupportCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
    }

    private void initHeadStatus(int iColumn, int iSelCount, int iUnSupportCount, int iTotalCount) {
        switch (iColumn) {
            case 5: {
                if (iUnSupportCount == iTotalCount) {
                    this.m_iSaveSelectionType = 2;
                    break;
                }
                if (iSelCount == iTotalCount || iSelCount + iUnSupportCount == iTotalCount) {
                    this.m_iSaveSelectionType = 0;
                    break;
                }
                if (iSelCount < iTotalCount && iSelCount != 0) {
                    this.m_iSaveSelectionType = 1;
                    break;
                }
                this.m_iSaveSelectionType = 2;
                break;
            }
            case 6: {
                if (iUnSupportCount == iTotalCount) {
                    this.m_iConfigSelectionType = 2;
                    break;
                }
                if (iSelCount == iTotalCount || iSelCount + iUnSupportCount == iTotalCount) {
                    this.m_iConfigSelectionType = 0;
                    break;
                }
                if (iSelCount < iTotalCount && iSelCount != 0) {
                    this.m_iConfigSelectionType = 1;
                    break;
                }
                this.m_iConfigSelectionType = 2;
                break;
            }
            case 7: {
                if (iUnSupportCount == iTotalCount) {
                    this.m_iTimerSelectionType = 2;
                    break;
                }
                if (iSelCount == iTotalCount || iSelCount + iUnSupportCount == iTotalCount) {
                    this.m_iTimerSelectionType = 0;
                    break;
                }
                if (iSelCount < iTotalCount && iSelCount != 0) {
                    this.m_iTimerSelectionType = 1;
                    break;
                }
                this.m_iTimerSelectionType = 2;
                break;
            }
        }
    }

    @Override
    protected void sameAsSelectedRow() {
        DCFrameWorkUtil.waitCursor();
        int iSelectRow = this.m_oTable.getSelectedRow();
        Object oBackupType = this.m_oTable.getValueAt(iSelectRow, 2);
        int iBackupType = this.getContentTypeValueFromTable(oBackupType, iSelectRow);
        Object oMaxNum = this.m_oTable.getValueAt(iSelectRow, 4);
        int iMaxNum = this.getMaxNumValueFromTable(oMaxNum, iSelectRow);
        Object oSaveBeforeBackup = this.m_oTable.getValueAt(iSelectRow, 5);
        Object oConfig = this.m_oTable.getValueAt(iSelectRow, 6);
        Object oTimer = this.m_oTable.getValueAt(iSelectRow, 7);
        String strDestination = this.getDestinationFromTable(iSelectRow);
        List oCloneDevProLst = (List)CloneUtil.getClone(this.m_oDevProLst);
        PolicyDevTypeProperties oDevPro = null;
        for (int i = 0; i < oCloneDevProLst.size(); ++i) {
            oDevPro = (PolicyDevTypeProperties)oCloneDevProLst.get(i);
            oDevPro.refreshBackupContentType(iBackupType);
            oDevPro.setNumOfBackupCopies(iMaxNum);
            oDevPro.refreshSaveBeforeBackup(oSaveBeforeBackup);
            oDevPro.refreshConfigChange(1, oConfig);
            oDevPro.refreshConfigChange(0, oTimer);
            oDevPro.setStrDestination(strDestination);
        }
        this.initContentTypeCombox(oCloneDevProLst);
        this.initMaxBackupNumCombox(oCloneDevProLst);
        this.setDefaultSelectedRow(iSelectRow);
        this.initData(oCloneDevProLst);
        DCFrameWorkUtil.defaultCursor();
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            int iRowNum;
            Object oCellObj;
            TableColumnModel columnModel;
            int viewColumn;
            Point oPoint = oMouseEvent.getPoint();
            JTable tableView = (JTable)oMouseEvent.getSource();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(oMouseEvent.getX()));
            if (column == 7 && (oCellObj = RouteTablePanel.this.m_oTable.getValueAt(iRowNum = tableView.rowAtPoint(oPoint), column)) instanceof ConfigChangePolicyInfo) {
                int xClickPoint = oMouseEvent.getX();
                int iTotalColumnWidth = columnModel.getTotalColumnWidth();
                int iTimeColumWidth = RouteTablePanel.this.m_oTable.getColumnModel().getColumn(7).getWidth();
                int iPreColumnWidth = iTotalColumnWidth - iTimeColumWidth;
                ConfigChangePolicyInfo oConfig = (ConfigChangePolicyInfo)oCellObj;
                boolean bSelected = oConfig.isSelected();
                if (RouteTablePanel.this.m_iCmdType != 1 && xClickPoint > iPreColumnWidth + 15 && bSelected) {
                    Cursor oCur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(RouteTablePanel.this.getParent(), oCur);
                    return;
                }
            }
            Cursor oCur = new Cursor(0);
            DCFrameWorkUtil.setCursor(RouteTablePanel.this.getParent(), oCur);
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof CheckBoxHeader)) {
                return;
            }
            int iColumnIndex = ((CheckBoxHeader)source).getColumn();
            switch (iColumnIndex) {
                case 5: {
                    RouteTablePanel.this.handleSaveItemChange();
                    break;
                }
                case 6: {
                    RouteTablePanel.this.handleConfigItemChange();
                    break;
                }
                case 7: {
                    RouteTablePanel.this.handleTimerItemChange();
                    break;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RouteTablePanel.this.m_oTable.repaint();
                    RouteTablePanel.this.m_oTable.getTableHeader().repaint();
                }
            });
        }
    }
}

