/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.policy.controller.BooleanColumnRederer;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.view.advanced.AdvancedMainPanel;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class OptixTablePanel
extends AdvancedMainPanel {
    private static final long serialVersionUID = -1796307912510429862L;

    public OptixTablePanel(int iTabIndex, int iPoliyID, List<PolicyDevTypeProperties> oDevProLst, int iCmdType) {
        super(iTabIndex, iPoliyID, oDevProLst, iCmdType);
    }

    @Override
    protected void initTableModel() {
        this.m_oTableModel = new SortableTableModel(this.getColumns(), 0){
            private static final long serialVersionUID = -8703420977539625527L;

            public boolean isCellEditable(int row, int column) {
                if (OptixTablePanel.this.m_iCmdType == 1) {
                    return false;
                }
                Object oCellValue = this.getValueAt(row, column);
                if (null == oCellValue || oCellValue instanceof String && ((String)oCellValue).equals("--")) {
                    return false;
                }
                return column == 2 || column == 3 || column == 4 || column == 6;
            }
        };
    }

    @Override
    protected void initTableRender(int iRowNum) {
        super.initTableRender(iRowNum);
        this.setName("policy_OptixTablePanel");
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oConfigChange = this.m_oTable.getColumnModel().getColumn(6);
        this.m_oConfigCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oTable.getTableHeader().getBackground(), 6);
        oConfigChange.setHeaderRenderer(this.m_oConfigCheckBoxHeader);
        this.m_oTable.getColumnModel().getColumn(6).setCellRenderer(new BooleanColumnRederer());
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 28));
        this.m_oTable.getColumnModel().getColumn(6).setMinWidth(80);
        this.m_oTable.getColumnModel().getColumn(5).setPreferredWidth(0);
        this.m_oTable.getColumnModel().getColumn(5).setMinWidth(0);
        this.m_oTable.getColumnModel().getColumn(5).setMaxWidth(0);
        try {
            this.m_oTable.removeColumn(this.m_oTable.getColumnModel().getColumn(7));
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    protected void initData(List<PolicyDevTypeProperties> odevProLst) {
        this.m_oDevProLst = odevProLst;
        this.m_oTableModel.getDataVector().clear();
        PolicyDevTypeProperties oDevTypePro = null;
        int iConfigSelectCount = 0;
        int iConfigNotSupportCount = 0;
        for (int i = 0; i < odevProLst.size(); ++i) {
            Object[] oCellData = new Object[this.getColumns().length];
            oDevTypePro = odevProLst.get(i);
            int iDevTypeID = oDevTypePro.getDevTypeID();
            String sDevTypeName = oDevTypePro.getDevTypeName();
            ComboBoxWithToolTip oContentTypeCombox = this.m_oContentType[i];
            ComboBoxWithToolTip oDestinationCombox = this.m_oDestinationComboBox[i];
            ComboBoxWithToolTip oMaxbackupNumBox = this.m_oMaxBackupNumComboxs[i];
            Boolean oConfigChange = null;
            int iConfigChange = oDevTypePro.getSpecialPolicyStatus(1);
            if (iConfigChange == 0) {
                ++iConfigSelectCount;
                oConfigChange = true;
            } else if (iConfigChange == 1) {
                oConfigChange = false;
            } else {
                ++iConfigNotSupportCount;
                oConfigChange = null;
            }
            oCellData[0] = iDevTypeID;
            oCellData[1] = sDevTypeName;
            oCellData[2] = oContentTypeCombox;
            oCellData[3] = oDestinationCombox;
            oCellData[4] = oMaxbackupNumBox;
            oCellData[5] = null;
            oCellData[6] = oConfigChange;
            this.m_oTableModel.addRow(oCellData);
        }
        this.m_oTableModel.fireTableRowsUpdated(0, odevProLst.size() - 1);
        if (this.m_oTable.getRowCount() > 0) {
            this.m_oTable.setRowSelectionInterval(this.m_iDefaultSelectedRow, this.m_iDefaultSelectedRow);
        }
        this.initHeadStatus(6, iConfigSelectCount, iConfigNotSupportCount, this.m_oDevProLst.size());
        this.m_oConfigCheckBoxHeader.handleHeaderChckBxChanges(6);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptixTablePanel.this.m_oTable.updateUI();
                OptixTablePanel.this.m_oTable.getTableHeader().repaint();
            }
        });
    }

    @Override
    protected PolicyDevTypeProperties getPolicyDevProForRow(Vector oRowVector, int iRow) {
        PolicyDevTypeProperties oDevPro = new PolicyDevTypeProperties();
        int iDevTypeID = (Integer)oRowVector.get(0);
        String sDevTypeName = oRowVector.get(1).toString();
        Object oContentTypeObj = oRowVector.get(2);
        int iBackupContentType = this.getContentTypeValueFromTable(oContentTypeObj, iRow);
        String strDestination = this.getDestinationFromTable(iRow);
        Object oMaxNumObj = oRowVector.get(4);
        int iBackuMaxNum = this.getMaxNumValueFromTable(oMaxNumObj, iRow);
        Object oConfigChange = oRowVector.get(6);
        oDevPro.setDevTypeID(iDevTypeID);
        oDevPro.setDevTypeName(sDevTypeName);
        oDevPro.setBackupContentType(iBackupContentType);
        oDevPro.setStrDestination(strDestination);
        oDevPro.setNumOfBackupCopies(iBackuMaxNum);
        if (null != oConfigChange) {
            boolean bConfigChange = (Boolean)oConfigChange;
            int iSpecialBackupStatus = bConfigChange ? 0 : 1;
            oDevPro.setConfigChangeBakcupStatus(1, iSpecialBackupStatus);
        }
        return oDevPro;
    }

    @Override
    protected void refreshDevProLst(List<PolicyDevTypeProperties> oDevProLst, PolicyDevTypeProperties oDevPro) {
        for (PolicyDevTypeProperties oDevProInfo : oDevProLst) {
            if (oDevProInfo.getDevTypeID() != oDevPro.getDevTypeID()) continue;
            oDevProInfo.setBackupContentType(oDevPro.getBackupContentType());
            oDevProInfo.setStrDestination(oDevPro.getStrDestination());
            oDevProInfo.setNumOfBackupCopies(oDevPro.getNumOfBackupCopies());
            oDevProInfo.setConfigChangeBakcupStatus(1, oDevPro.getSpecialPolicyStatus(1));
        }
    }

    @Override
    protected int getHeadStatus(int iColumn) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            Object oo = oItor.next();
            Object xx = ((Vector)oo).get(iColumn);
            if (null != xx) {
                if (!(xx instanceof Boolean) || !((Boolean)xx).booleanValue()) continue;
                ++iSelectCount;
                continue;
            }
            ++iNotSupportCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
        return this.m_iConfigSelectionType;
    }

    private void setHeadStatus(int iColumn, boolean bAllSelectStatus) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            Object oo = oItor.next();
            Object oColumnObj = ((Vector)oo).get(iColumn);
            if (null != oColumnObj) {
                ((Vector)oo).set(iColumn, bAllSelectStatus);
                if (!bAllSelectStatus) continue;
                ++iSelectCount;
                continue;
            }
            ++iNotSupportCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
    }

    private void initHeadStatus(int iColumn, int iSelCount, int iNotSupportCount, int iTotalCount) {
        if (iNotSupportCount == iTotalCount) {
            this.m_iSaveSelectionType = 2;
        } else {
            this.m_iConfigSelectionType = iSelCount == iTotalCount || iSelCount + iNotSupportCount == iTotalCount ? 0 : (iSelCount < iTotalCount && iSelCount != 0 ? 1 : 2);
        }
    }

    @Override
    protected void sameAsSelectedRow() {
        DCFrameWorkUtil.waitCursor();
        int iSelectRow = this.m_oTable.getSelectedRow();
        Object oBackupType = this.m_oTable.getValueAt(iSelectRow, 2);
        int iBackupType = this.getContentTypeValueFromTable(oBackupType, iSelectRow);
        String strDestination = this.getDestinationFromTable(iSelectRow);
        Object oMaxNum = this.m_oTable.getValueAt(iSelectRow, 4);
        int iMaxNum = this.getMaxNumValueFromTable(oMaxNum, iSelectRow);
        Object oConfig = this.m_oTable.getValueAt(iSelectRow, 6);
        List oCloneDevProLst = (List)CloneUtil.getClone(this.m_oDevProLst);
        PolicyDevTypeProperties oDevPro = null;
        for (int i = 0; i < oCloneDevProLst.size(); ++i) {
            oDevPro = (PolicyDevTypeProperties)oCloneDevProLst.get(i);
            oDevPro.refreshBackupContentType(iBackupType);
            oDevPro.setNumOfBackupCopies(iMaxNum);
            oDevPro.refreshConfigChange(1, oConfig);
            oDevPro.setStrDestination(strDestination);
        }
        this.initContentTypeCombox(oCloneDevProLst);
        this.initMaxBackupNumCombox(oCloneDevProLst);
        this.setDefaultSelectedRow(iSelectRow);
        this.initData(oCloneDevProLst);
        DCFrameWorkUtil.defaultCursor();
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof CheckBoxHeader)) {
                return;
            }
            int iColumnIndex = ((CheckBoxHeader)source).getColumn();
            boolean bAllSelectStatus = false;
            if (0 == OptixTablePanel.this.m_iConfigSelectionType) {
                bAllSelectStatus = false;
            } else if (1 == OptixTablePanel.this.m_iConfigSelectionType || 2 == OptixTablePanel.this.m_iConfigSelectionType) {
                bAllSelectStatus = true;
            }
            OptixTablePanel.this.setHeadStatus(iColumnIndex, bAllSelectStatus);
            OptixTablePanel.this.m_oConfigCheckBoxHeader.handleHeaderChckBxChanges(6);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptixTablePanel.this.m_oTable.repaint();
                    OptixTablePanel.this.m_oTable.getTableHeader().repaint();
                }
            });
        }
    }
}

