/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.NewGroupDlg;
import com.huawei.dc.policy.mxupolicy.ModifyMxuPolicyDlg;
import com.huawei.dc.policy.view.advanced.AdvancedMainPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    private static final long serialVersionUID = -9037873024388634583L;
    private CheckBoxHeader m_oRendererComponent = this;
    private AdvancedMainPanel m_oAdvancedMainPanel = null;
    private ModifyMxuPolicyDlg m_oModifyMxuPolicyDlg = null;
    private NewGroupDlg m_oNewGroupDlg = null;
    private Color m_oColor = null;
    private boolean mousePressed = false;
    public static final int ALL_SELECTED = 0;
    public static final int PART_SELECTED = 1;
    public static final int NONE_SELECTED = 2;
    private static final int TABLE_COLUMN_INDEX_MAX_BAKCUP_NUM = 4;
    private static final int TABLE_COLUMN_INDEX_SAVE_BEFORE_BAKCUP = 5;
    private static final int TABLE_COLUMN_INDEX_CONFIG_CHANGE = 6;
    private static final int TABLE_COLUMN_INDEX_TIMER_BAKCUP = 7;
    private int m_iColumn = 0;

    public CheckBoxHeader(ItemListener oItemLstner, boolean bSetEnable, AdvancedMainPanel oAdvancedMainPanel, Color oColor, int iColumn) {
        this.m_oRendererComponent.addItemListener(oItemLstner);
        this.m_oRendererComponent.setEnabled(bSetEnable);
        this.m_oAdvancedMainPanel = oAdvancedMainPanel;
        this.m_oColor = oColor;
        this.m_iColumn = iColumn;
        this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("noneselect.gif"));
    }

    public CheckBoxHeader(ItemListener oItemLstner, boolean bSetEnable, NewGroupDlg oNewGroupDlg, Color oColor, int iColumn) {
        this.m_oRendererComponent.addItemListener(oItemLstner);
        this.m_oRendererComponent.setEnabled(bSetEnable);
        this.m_oNewGroupDlg = oNewGroupDlg;
        this.m_oColor = oColor;
        this.m_iColumn = iColumn;
        this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("noneselect.gif"));
    }

    public CheckBoxHeader(ItemListener oItemLstner, boolean bSetEnable, ModifyMxuPolicyDlg oModifyMxuPolicyDlg, Color oColor, int iColumn) {
        this.m_oRendererComponent.addItemListener(oItemLstner);
        this.m_oRendererComponent.setEnabled(bSetEnable);
        this.m_oModifyMxuPolicyDlg = oModifyMxuPolicyDlg;
        this.m_oColor = oColor;
        this.m_iColumn = iColumn;
        this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("noneselect.gif"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.m_oRendererComponent.setForeground(header.getForeground());
            this.m_oRendererComponent.setBackground(header.getBackground());
            this.m_oRendererComponent.setFont(header.getFont());
            header.addMouseListener(this.m_oRendererComponent);
        }
        this.m_oRendererComponent.setText(value == null ? "" : value.toString());
        JButton oHeaderBtn = new JButton();
        if (200 < this.m_oColor.getRed()) {
            oHeaderBtn.setBackground(new Color(this.m_oColor.getRed() + 1, this.m_oColor.getGreen(), this.m_oColor.getBlue()));
        } else {
            oHeaderBtn.setBackground(new Color(this.m_oColor.getRed(), this.m_oColor.getGreen(), this.m_oColor.getBlue()));
        }
        Box baseBox = Box.createHorizontalBox();
        baseBox.add(this.m_oRendererComponent);
        baseBox.setBackground(this.m_oRendererComponent.getForeground());
        baseBox.setBackground(this.m_oRendererComponent.getBackground());
        oHeaderBtn.setBackground(this.m_oRendererComponent.getForeground());
        oHeaderBtn.setBackground(this.m_oRendererComponent.getBackground());
        oHeaderBtn.add(baseBox);
        oHeaderBtn.setEnabled(true);
        oHeaderBtn.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        oHeaderBtn.setHorizontalAlignment(0);
        oHeaderBtn.setToolTipText(this.m_oRendererComponent.getText());
        return oHeaderBtn;
    }

    @Override
    public void mouseClicked(final MouseEvent e) {
        this.handleClickEvent(e);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JTableHeader)e.getSource()).updateUI();
                ((JTableHeader)e.getSource()).repaint();
            }
        });
    }

    public int getColumn() {
        return this.m_iColumn;
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            TableColumnModel columnModel;
            int viewColumn;
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(e.getX()));
            if (column != this.m_iColumn) {
                return;
            }
            if (null != this.m_oAdvancedMainPanel && e.getClickCount() == 1 && this.checkColumn(column)) {
                this.doClick();
            }
            if (null != this.m_oModifyMxuPolicyDlg && e.getClickCount() == 1 && column == 1) {
                this.doClick();
            }
            if (null != this.m_oNewGroupDlg && e.getClickCount() == 1 && column == 0) {
                this.doClick();
            }
        }
    }

    private boolean checkColumn(int column) {
        return 4 == column || 5 == column || 6 == column || 7 == column;
    }

    public void handleHeaderChckBxChanges(int iColumn) {
        int iSelectionType = -1;
        if (this.m_oAdvancedMainPanel != null) {
            iSelectionType = this.m_oAdvancedMainPanel.getHeadStatus(iColumn);
        }
        if (null != this.m_oModifyMxuPolicyDlg) {
            iSelectionType = this.m_oModifyMxuPolicyDlg.getHeardStatus();
        }
        if (null != this.m_oNewGroupDlg) {
            iSelectionType = this.m_oNewGroupDlg.getHeardStatus();
        }
        this.updateIcon(iSelectionType);
    }

    public void updateIcon(int iSelectionType) {
        if (1 == iSelectionType) {
            this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("part.gif"));
        } else if (2 == iSelectionType) {
            this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("noneselect.gif"));
        } else if (0 == iSelectionType) {
            this.m_oRendererComponent.setIcon(ResourceManager.getInstance().getImage("all.gif"));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

