/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.asndatacenter.AsnDCPolicyDevIdBakNumLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.advanced.AdvancedMainPanel;
import com.huawei.dc.policy.view.advanced.AllDomainTablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.commustru.fstru.FStruct;

public class AdvancedSettingDlg
extends DCModalDialog {
    private static final long serialVersionUID = 2213043491313379537L;
    public static final int TAB_INDEX_ACCESS = 0;
    public static final int TAB_INDEX_OPTIX = 1;
    public static final int TAB_INDEX_ROUTE = 2;
    public static final int TAB_INDEX_ALLDOMAIN = 3;
    private JTabbedPane m_oSettingTabPane = null;
    AdvancedMainPanel m_oAccessNEPanel = null;
    AdvancedMainPanel m_oOptixNEPanel = null;
    AdvancedMainPanel m_oRouteNEPanel = null;
    AdvancedMainPanel m_oAllDomainNEPanel = null;
    private JPanel m_oButtonPnl = null;
    private PolicyInfo m_oPolicyInfo = null;
    private int m_iCmdType = 0;

    public AdvancedSettingDlg(PolicyInfo oPolicyInfo, int iCmdType) {
        this.m_oPolicyInfo = (PolicyInfo)CloneUtil.getClone(oPolicyInfo);
        this.m_iCmdType = iCmdType;
        this.initGUI();
    }

    private void initGUI() {
        this.setResizable(true);
        this.setSize(new Dimension(850, 550));
        this.setTitle(ResourceManager.getInstance().getResString("POLICY_ADVANCED_SETTING_DLG_TLE"));
        this.setLayout(new GridBagLayout());
        this.m_oSettingTabPane = new JTabbedPane();
        this.initButtonPanel();
        if ((null == this.m_oPolicyInfo.getPolicyDevTypePropLst() || this.m_oPolicyInfo.getPolicyDevTypePropLst().size() == 0) && this.m_oPolicyInfo.getPolicyID() == -1) {
            List<PolicyDevTypeProperties> oDevProLst = PolicyManager.getInstance().getDeVTypeProList(-1);
            List oCloneProLst = (List)CloneUtil.getClone(oDevProLst);
            this.m_oPolicyInfo.setPolicyDevTypePropLst(oCloneProLst);
        }
        int iPolicyID = this.m_oPolicyInfo.getPolicyID();
        List<PolicyDevTypeProperties> oAllDomainDevProLst = this.getDevTypePro();
        this.m_oAllDomainNEPanel = new AllDomainTablePanel(3, iPolicyID, oAllDomainDevProLst, this.m_iCmdType);
        this.getContentPane().add((Component)this.m_oAllDomainNEPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(18, 12, 12, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oButtonPnl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 12, 12), 0, 0));
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initButtonPanel() {
        DCDebugTracer.trace("Entering initButtonPanel");
        this.m_oButtonPnl = new JPanel();
        this.m_oOKBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oButtonPnl.setPreferredSize(new Dimension(300, 21));
        this.m_oButtonPnl.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oButtonPnl.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_oButtonPnl.add(this.m_oOKBtn);
        this.m_oButtonPnl.add(this.m_oCancelBtn);
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (this.m_iCmdType == 1) {
            this.dispose();
            return;
        }
        ArrayList<PolicyDevTypeProperties> oDevProLst = new ArrayList<PolicyDevTypeProperties>();
        if (null != this.m_oAllDomainNEPanel) {
            this.m_oAllDomainNEPanel.resetDevTypeProLst();
            oDevProLst.addAll(this.m_oAllDomainNEPanel.m_oDevProLst);
        }
        AsnDCPolicyDevIdBakNumLst oAsnDevNumLst = PolicyUtil.getPolicyDevIdBakNumLst(this.m_oPolicyInfo, this.m_oPolicyInfo.getDevicePolicyStateHm());
        boolean bCheckDistRoomContinue = PolicyManager.getInstance().isCheckDistRoomOK(44093, (FStruct)oAsnDevNumLst);
        if (!bCheckDistRoomContinue) {
            return;
        }
        PolicyManager.getInstance().getPolicyInfo(this.m_oPolicyInfo.getPolicyID()).setPolicyDevTypePropLst(oDevProLst);
        this.dispose();
    }

    private List<PolicyDevTypeProperties> getDevTypePro() {
        ArrayList<PolicyDevTypeProperties> oDevTypeProLst = new ArrayList<PolicyDevTypeProperties>();
        int iDevTypeID = 0;
        int iDevTypeVerID = 0;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo oDevTypeInfo = null;
        List<PolicyDevTypeProperties> mOPolicyDevTypePropLst = this.m_oPolicyInfo.getPolicyDevTypePropLst();
        for (PolicyDevTypeProperties oDevTypePro : mOPolicyDevTypePropLst) {
            iDevTypeID = oDevTypePro.getDevTypeID();
            oDevTypeInfo = oDevMgr.getDeviceTypeInfo(iDevTypeID, iDevTypeVerID = oDevMgr.getDeviceTypeVersionId(iDevTypeID));
            if (null == oDevTypeInfo) continue;
            if (this.m_oPolicyInfo.isDefaultPolicy()) {
                oDevTypeProLst.add(oDevTypePro);
                continue;
            }
            if (!this.isDevTypeExist(iDevTypeID)) continue;
            oDevTypeProLst.add(oDevTypePro);
        }
        return oDevTypeProLst;
    }

    private boolean isDevTypeExist(int iDevTypeID) {
        DeviceTypeInfo[] oDevTypes = DeviceInfoManagerImpl.getInstance().getExistDeviceTypes();
        if (null == oDevTypes || oDevTypes.length == 0) {
            return false;
        }
        DeviceTypeInfo oDevType = null;
        for (int i = 0; i < oDevTypes.length; ++i) {
            oDevType = oDevTypes[i];
            if (null == oDevType || oDevType.getDevTypeID() != iDevTypeID) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_POLICY_ADVANCED_SETTING";
    }
}

