/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.DCConfigFileParser;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.huawei.dc.policy.view.advanced.TimerBakcupDlg;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public abstract class AdvancedMainPanel
extends JPanel {
    private static final long serialVersionUID = -2521879307686912924L;
    private JScrollPane m_oTableScrollPane;
    protected DCExtendedTable m_oTable = null;
    protected SortableTableModel m_oTableModel = null;
    private int m_iTabIndex = -1;
    protected List<PolicyDevTypeProperties> m_oDevProLst = null;
    protected List<PolicyDevTypeProperties> ascendDevProLst = new ArrayList<PolicyDevTypeProperties>();
    protected Map<String, PolicyDevTypeProperties> devTypePropertiesMap = new HashMap<String, PolicyDevTypeProperties>();
    protected static final int TABLE_COLUMN_INDEX_NE_TYPE_ID = 0;
    protected static final int TABLE_COLUMN_INDEX_NE_TYPE = 1;
    protected static final int TABLE_COLUMN_INDEX_CONTENT_TYPE = 2;
    protected static final int TABLE_COLUMN_INDEX_BACKUP_DESTINATION = 3;
    protected static final int TABLE_COLUMN_INDEX_MAX_BAKCUP_NUM = 4;
    protected static final int TABLE_COLUMN_INDEX_SAVE_BEFORE_BAKCUP = 5;
    protected static final int TABLE_COLUMN_INDEX_CONFIG_CHANGE = 6;
    protected static final int TABLE_COLUMN_INDEX_TIMER_BAKCUP = 7;
    protected ComboBoxWithToolTip[] m_oContentType = null;
    protected ComboBoxWithToolTip[] m_oDestinationComboBox = null;
    protected ComboBoxWithToolTip[] m_oMaxBackupNumComboxs = null;
    protected static final int ALL_SELECTED = 0;
    protected static final int PART_SELECTED = 1;
    protected static final int NONE_SELECTED = 2;
    protected CheckBoxHeader m_oSaveCheckBoxHeader = null;
    protected CheckBoxHeader m_oConfigCheckBoxHeader = null;
    protected CheckBoxHeader m_oTimerCheckBoxHeader = null;
    protected int m_iSaveSelectionType = 2;
    protected int m_iConfigSelectionType = 2;
    protected int m_iTimerSelectionType = 2;
    protected boolean mousePressed = false;
    protected int m_iPolicyID;
    protected int m_iCmdType = 0;
    private JPanel m_oSameAsPanel = null;
    protected JButton m_oDefaultBtn = null;
    protected JButton m_oSameAsBtn = null;
    protected int m_iDefaultSelectedRow = 0;
    private int m_iLocationIndex = -1;

    public AdvancedMainPanel(int iTabIndex, int iPolicyID, List<PolicyDevTypeProperties> odevProLst, int iCmdType) {
        this.m_iTabIndex = iTabIndex;
        this.m_iPolicyID = iPolicyID;
        this.m_oDevProLst = odevProLst;
        this.m_iCmdType = iCmdType;
        this.sortDevTypeProLst();
        this.initGUI();
        this.initData(this.m_oDevProLst);
        this.initSelectionAndBtnStatus();
        this.m_oTableScrollPane.getVerticalScrollBar().setValue(0);
        this.m_oTableScrollPane.setAutoscrolls(false);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.initContentTypeCombox(this.m_oDevProLst);
        this.initMaxBackupNumCombox(this.m_oDevProLst);
        this.initTableModel();
        this.m_oTable = new DCExtendedTable(this.m_oTableModel);
        this.m_oTable.setName("policy_AdvancedMianPanel_m_oTable");
        this.m_oTable.setColumnSortable(new int[]{1}, true);
        this.m_oTable.setSortableClickCount(1);
        this.m_oTable.setUpDateSelectedRow(true);
        this.m_oTable.setNotSaveBackground(this.m_oTable.getBackground());
        this.m_oTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                AdvancedMainPanel.this.mousePressed = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                AdvancedMainPanel.this.handleMouseClicked(e);
            }
        });
        this.m_oTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                char keyCode = e.getKeyChar();
                String keyStr = String.valueOf(keyCode).toLowerCase();
                boolean bFound = false;
                for (int i = 0; i < AdvancedMainPanel.this.m_oTable.getRowCount(); ++i) {
                    if (AdvancedMainPanel.this.m_oTable.getModel().getValueAt(i, 1) == null) {
                        return;
                    }
                    String devTypeInfo = AdvancedMainPanel.this.m_oTable.getModel().getValueAt(i, 1).toString().toLowerCase();
                    if (!devTypeInfo.toLowerCase(ResourceMng.getInstance().getLocale()).startsWith(keyStr) || i == AdvancedMainPanel.this.m_iLocationIndex || i < AdvancedMainPanel.this.m_iLocationIndex) continue;
                    bFound = true;
                    AdvancedMainPanel.this.m_oTable.setRowSelectionInterval(i, i);
                    AdvancedMainPanel.this.m_iLocationIndex = i;
                    Rectangle oRect = AdvancedMainPanel.this.m_oTable.getCellRect(i, 0, true);
                    AdvancedMainPanel.this.m_oTable.scrollRectToVisible(oRect);
                    break;
                }
                if (!bFound) {
                    AdvancedMainPanel.this.m_iLocationIndex = -1;
                }
            }
        });
        this.m_oTable.setRowHeight(21);
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTableScrollPane = new JScrollPane();
        this.initTableRender(0);
        if (this.m_iCmdType == 1) {
            if (null != this.m_oSaveCheckBoxHeader) {
                this.m_oSaveCheckBoxHeader.setEnabled(false);
            }
            if (null != this.m_oConfigCheckBoxHeader) {
                this.m_oConfigCheckBoxHeader.setEnabled(false);
            }
            if (null != this.m_oTimerCheckBoxHeader) {
                this.m_oTimerCheckBoxHeader.setEnabled(false);
            }
        }
        this.add((Component)this.m_oTableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.getSameAsBtnPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 0), 0, 0));
        if (this.m_iCmdType == 1) {
            this.m_oDefaultBtn.setEnabled(false);
            this.m_oSameAsBtn.setEnabled(false);
        }
        DefaultListSelectionModel oTableRowSelection = new DefaultListSelectionModel();
        oTableRowSelection.setSelectionMode(1);
        this.m_oTable.setSelectionModel((ListSelectionModel)oTableRowSelection);
        this.m_oTable.setSelectionMode(0);
        this.m_oTableScrollPane.getViewport().setView((Component)this.m_oTable);
    }

    protected void handleMouseClicked(MouseEvent e) {
        if (this.mousePressed) {
            int iRow;
            this.mousePressed = false;
            if (this.m_iCmdType == 1) {
                return;
            }
            JTable tableView = (JTable)e.getSource();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = tableView.convertColumnIndexToModel(viewColumn);
            this.m_iLocationIndex = iRow = tableView.getSelectedRow();
            Object oCellObj = tableView.getValueAt(iRow, column);
            if (oCellObj instanceof ConfigChangePolicyInfo) {
                int xClickPoint = e.getX();
                int iTotalColumnWidth = columnModel.getTotalColumnWidth();
                int iTimeColumWidth = this.m_oTable.getColumnModel().getColumn(7).getWidth();
                int iPreColumnWidth = iTotalColumnWidth - iTimeColumWidth;
                ConfigChangePolicyInfo oConfig = (ConfigChangePolicyInfo)oCellObj;
                boolean bSelected = oConfig.isSelected();
                if (xClickPoint > iPreColumnWidth && xClickPoint < iPreColumnWidth + 15) {
                    oConfig.setSelected(!bSelected);
                } else {
                    if (bSelected) {
                        TimerBakcupDlg oTimerDlg = new TimerBakcupDlg(oConfig);
                        oTimerDlg.setVisible(true);
                        return;
                    }
                    return;
                }
            }
            if (e.getClickCount() != 1) {
                return;
            }
            if (null != oCellObj && oCellObj instanceof Boolean) {
                boolean bRtn = this.handleColumnSelectStateChange(column, (Boolean)oCellObj);
                if (!bRtn) {
                    tableView.setValueAt(true, iRow, column);
                } else {
                    tableView.setValueAt(oCellObj, iRow, column);
                }
            }
            switch (column) {
                case 5: {
                    this.m_oSaveCheckBoxHeader.handleHeaderChckBxChanges(5);
                    break;
                }
                case 6: {
                    this.m_oConfigCheckBoxHeader.handleHeaderChckBxChanges(6);
                    break;
                }
                case 7: {
                    this.m_oTimerCheckBoxHeader.handleHeaderChckBxChanges(7);
                    break;
                }
            }
            this.updateTable(iRow, iRow);
        }
    }

    protected void updateTable(final int iStratRow, final int iEndRow) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdvancedMainPanel.this.m_oTable.getTableHeader().repaint();
                AdvancedMainPanel.this.m_oTable.repaint();
                AdvancedMainPanel.this.m_oTable.setRowSelectionInterval(iStratRow, iEndRow);
            }
        });
    }

    protected void initTableRender(int iRowNum) {
        this.m_oTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.m_oTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.m_oTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.m_oTable.getColumnModel().getColumn(1).setCellRenderer(new DevTypeColumnRender());
        this.m_oTable.getColumnModel().getColumn(2).setCellRenderer(new ComboxColumnRederer(2));
        ComboBoxWithToolTip oCom = null;
        oCom = null == this.m_oContentType || this.m_oContentType.length == 0 ? new ComboBoxWithToolTip() : this.m_oContentType[iRowNum];
        this.m_oTable.getColumnModel().getColumn(2).setCellEditor(new ComboxColumnEditor(oCom, 2));
        this.m_oTable.getColumnModel().getColumn(3).setCellRenderer(new ComboxColumnRederer(3));
        ComboBoxWithToolTip oDestinationCom = null;
        oDestinationCom = null == this.m_oDestinationComboBox || this.m_oDestinationComboBox.length == 0 ? new ComboBoxWithToolTip() : this.m_oDestinationComboBox[iRowNum];
        this.m_oTable.getColumnModel().getColumn(3).setCellEditor(new ComboxColumnEditor(oDestinationCom, 3));
        this.m_oTable.getColumnModel().getColumn(4).setCellRenderer(new ComboxColumnRederer(4));
        ComboBoxWithToolTip oCom2 = null;
        oCom2 = null == this.m_oMaxBackupNumComboxs || this.m_oMaxBackupNumComboxs.length == 0 ? new ComboBoxWithToolTip() : this.m_oMaxBackupNumComboxs[iRowNum];
        this.m_oTable.getColumnModel().getColumn(4).setCellEditor(new ComboxColumnEditor(oCom2, 4));
    }

    protected void initContentTypeCombox(List<PolicyDevTypeProperties> oDevProLst) {
        this.m_oContentType = new ComboBoxWithToolTip[oDevProLst.size()];
        this.m_oDestinationComboBox = new ComboBoxWithToolTip[oDevProLst.size()];
        ExternalFTPInfo[] oExternalFTPInfos = null;
        try {
            SystemManager oSystemMgr = new SystemManager();
            oExternalFTPInfos = oSystemMgr.getExternalFTPInfos();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        PolicyDevTypeProperties oDevTypePro = null;
        List<ContentType> oBackupContentTypeLst = null;
        int iSelectedContentType = 0;
        ResourceManager oRes = ResourceManager.getInstance();
        for (int i = 0; i < oDevProLst.size(); ++i) {
            this.m_oContentType[i] = new ComboBoxWithToolTip();
            this.m_oDestinationComboBox[i] = new ComboBoxWithToolTip();
            this.m_oDestinationComboBox[i].addItem(IUpdateDestinationListener.DESTINATION_NMS_SERVER);
            oDevTypePro = oDevProLst.get(i);
            String strDestination = oDevTypePro.getStrDestination();
            if (oDevTypePro.isBackupToExternalFTP() && null != oExternalFTPInfos) {
                int index = 0;
                int indexOfSelected = 0;
                for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
                    ++index;
                    this.m_oDestinationComboBox[i].addItem(oExternalFTPInfo);
                    if (!strDestination.equals(oExternalFTPInfo.getServerName())) continue;
                    indexOfSelected = index;
                }
                this.m_oDestinationComboBox[i].setSelectedIndex(indexOfSelected);
            }
            iSelectedContentType = oDevTypePro.getBackupContentType();
            oBackupContentTypeLst = oDevTypePro.getBackupCotentTypeLst();
            if (null == oBackupContentTypeLst) continue;
            for (int j = 0; j < oBackupContentTypeLst.size(); ++j) {
                ContentType oBackupContentType = oBackupContentTypeLst.get(j);
                int iBackupContentType = oBackupContentType.getContentTypeCode();
                int iDevTypeID = oDevTypePro.getDevTypeID();
                int iDevTypeVerID = DeviceInfoManagerImpl.getInstance().getDeviceTypeVersionId(iDevTypeID);
                DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
                String sContentType = oRes.getResString(oDevTypeInfo, oBackupContentType.getStrContentType());
                oBackupContentType.setContentType(sContentType);
                this.m_oContentType[i].addItem(oBackupContentType);
                if (iSelectedContentType != iBackupContentType) continue;
                this.m_oContentType[i].setSelectedIndex(j);
            }
        }
    }

    protected ComboBoxWithToolTip initDestinationCombox(PolicyDevTypeProperties oDevTypePro, ExternalFTPInfo externalFTPInfo) {
        ComboBoxWithToolTip oDestinationComboBox = null;
        ExternalFTPInfo[] oExternalFTPInfos = null;
        try {
            SystemManager oSystemMgr = new SystemManager();
            oExternalFTPInfos = oSystemMgr.getExternalFTPInfos();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        oDestinationComboBox = new ComboBoxWithToolTip();
        oDestinationComboBox.addItem(IUpdateDestinationListener.DESTINATION_NMS_SERVER);
        String strDestination = oDevTypePro.getStrDestination();
        if (null != externalFTPInfo) {
            strDestination = externalFTPInfo.getServerName();
        }
        if (oDevTypePro.isBackupToExternalFTP() && null != oExternalFTPInfos) {
            int index = 0;
            int indexOfSelected = 0;
            for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
                ++index;
                oDestinationComboBox.addItem(oExternalFTPInfo);
                if (!strDestination.equals(oExternalFTPInfo.getServerName())) continue;
                indexOfSelected = index;
            }
            oDestinationComboBox.setSelectedIndex(indexOfSelected);
        }
        return oDestinationComboBox;
    }

    protected ComboBoxWithToolTip initContentTypeCombox(PolicyDevTypeProperties oDevTypePro, int selected) {
        ComboBoxWithToolTip oContentType = null;
        List<ContentType> oBackupContentTypeLst = null;
        int iSelectedContentType = selected;
        ResourceManager oRes = ResourceManager.getInstance();
        oContentType = new ComboBoxWithToolTip();
        if (iSelectedContentType < 0) {
            iSelectedContentType = oDevTypePro.getBackupContentType();
        }
        if (null == (oBackupContentTypeLst = oDevTypePro.getBackupCotentTypeLst())) {
            return oContentType;
        }
        for (int j = 0; j < oBackupContentTypeLst.size(); ++j) {
            ContentType oBackupContentType = oBackupContentTypeLst.get(j);
            int iBackupContentType = oBackupContentType.getContentTypeCode();
            int iDevTypeID = oDevTypePro.getDevTypeID();
            int iDevTypeVerID = DeviceInfoManagerImpl.getInstance().getDeviceTypeVersionId(iDevTypeID);
            DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            String sContentType = oRes.getResString(oDevTypeInfo, oBackupContentType.getStrContentType());
            oBackupContentType.setContentType(sContentType);
            oContentType.addItem(oBackupContentType);
            if (iSelectedContentType != iBackupContentType) continue;
            oContentType.setSelectedIndex(j);
        }
        return oContentType;
    }

    protected ComboBoxWithToolTip initMaxBackupNumCombox(PolicyDevTypeProperties oDevTypePro, int backupNum) {
        ComboBoxWithToolTip oMaxBackupNumComboxs = null;
        String sNoLminitNum = ResourceManager.getInstance().getResString("POOICY_MAX_COPIES_NUM_NO_LIMIT");
        int iMaxbackupNumInFile = DCConfigFileParser.getMaxBackNum();
        oMaxBackupNumComboxs = new ComboBoxWithToolTip();
        int iMaxNum = oDevTypePro.getNumOfBackupCopies();
        if (backupNum > 0) {
            iMaxNum = backupNum;
        }
        oMaxBackupNumComboxs.addItem(sNoLminitNum);
        for (int j = 1; j <= iMaxbackupNumInFile; ++j) {
            oMaxBackupNumComboxs.addItem(j);
        }
        if (-1 == iMaxNum) {
            oMaxBackupNumComboxs.setSelectedIndex(0);
        } else {
            oMaxBackupNumComboxs.setSelectedIndex(iMaxNum);
        }
        return oMaxBackupNumComboxs;
    }

    protected void initMaxBackupNumCombox(List<PolicyDevTypeProperties> oDevProLst) {
        if (null == oDevProLst) {
            this.m_oMaxBackupNumComboxs = new ComboBoxWithToolTip[0];
            return;
        }
        this.m_oMaxBackupNumComboxs = new ComboBoxWithToolTip[oDevProLst.size()];
        PolicyDevTypeProperties oDevTypePro = null;
        String sNoLminitNum = ResourceManager.getInstance().getResString("POOICY_MAX_COPIES_NUM_NO_LIMIT");
        int iMaxbackupNumInFile = DCConfigFileParser.getMaxBackNum();
        for (int i = 0; i < oDevProLst.size(); ++i) {
            this.m_oMaxBackupNumComboxs[i] = new ComboBoxWithToolTip();
            oDevTypePro = oDevProLst.get(i);
            int iMaxNum = oDevTypePro.getNumOfBackupCopies();
            this.m_oMaxBackupNumComboxs[i].addItem(sNoLminitNum);
            for (int j = 1; j <= iMaxbackupNumInFile; ++j) {
                this.m_oMaxBackupNumComboxs[i].addItem(j);
            }
            if (-1 == iMaxNum) {
                this.m_oMaxBackupNumComboxs[i].setSelectedIndex(0);
                continue;
            }
            this.m_oMaxBackupNumComboxs[i].setSelectedIndex(iMaxNum);
        }
    }

    protected abstract void initTableModel();

    protected String[] getColumns() {
        return new String[]{ResourceManager.getInstance().getResString("POLICY_ADVANCED_COLUMN_NE_TYPE_ID"), ResourceManager.getInstance().getResString("POLICY_ADVANCED_COLUMN_NE_TYPE"), ResourceManager.getInstance().getResString("POLICY_ADVANCED_COLUMN_BACKUP_TYPE"), ResourceManager.getInstance().getResString("PATHHEADER"), ResourceManager.getInstance().getResString("POLICY_ADVANCED_COLUMN_MAX_BACKUP_NUM"), ResourceManager.getInstance().getResString("BACKUP_TABLE_SAVE_BEFORE_BACKUP"), ResourceManager.getInstance().getResString("POLICY_CONFIG_CHANGE_BAKCUP"), ResourceManager.getInstance().getResString("POLICY_TIMER_BAKCUP")};
    }

    protected abstract int getHeadStatus(int var1);

    protected abstract void initData(List<PolicyDevTypeProperties> var1);

    protected void resetDevTypeProLst() {
        Vector oVct = this.m_oTableModel.getDataVector();
        Vector oRowVector = null;
        PolicyDevTypeProperties oDevPro = null;
        for (int i = 0; i < oVct.size(); ++i) {
            oRowVector = (Vector)oVct.get(i);
            oDevPro = this.getPolicyDevProForRow(oRowVector, i);
            this.refreshDevProLst(this.m_oDevProLst, oDevPro);
        }
    }

    protected List<PolicyDevTypeProperties> getDevProLst() {
        Vector oVct = this.m_oTableModel.getDataVector();
        Vector oRowVector = null;
        PolicyDevTypeProperties oDevPro = null;
        ArrayList<PolicyDevTypeProperties> oDevProLst = new ArrayList<PolicyDevTypeProperties>();
        for (int i = 0; i < oVct.size(); ++i) {
            oRowVector = (Vector)oVct.get(i);
            oDevPro = this.getPolicyDevProForRow(oRowVector, i);
            oDevProLst.add(oDevPro);
        }
        return oDevProLst;
    }

    protected JPanel getSameAsBtnPanel() {
        if (null != this.m_oSameAsPanel) {
            return this.m_oSameAsPanel;
        }
        this.m_oSameAsPanel = new JPanel();
        this.m_oDefaultBtn = new JButton();
        this.m_oDefaultBtn.setMinimumSize(new Dimension(130, 21));
        this.m_oDefaultBtn.setPreferredSize(new Dimension(130, 21));
        this.m_oDefaultBtn.setText(ResourceManager.getInstance().getResString("POLICY_REVERT_DEFAULT"));
        this.m_oDefaultBtn.setMnemonic('R');
        this.m_oDefaultBtn.setEnabled(true);
        this.m_oDefaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMainPanel.this.revertToDefaultForAllDomain();
            }
        });
        this.m_oSameAsBtn = new JButton();
        this.m_oSameAsBtn.setMinimumSize(new Dimension(180, 21));
        this.m_oSameAsBtn.setPreferredSize(new Dimension(180, 21));
        this.m_oSameAsBtn.setText(ResourceManager.getInstance().getResString("POLICY_SAME_AS_SELECTED_ROW"));
        this.m_oSameAsBtn.setToolTipText(ResourceManager.getInstance().getResString("POLICY_SAME_AS_SELECTED_ROW"));
        this.m_oSameAsBtn.setMnemonic('W');
        this.m_oSameAsBtn.setEnabled(true);
        this.m_oSameAsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMainPanel.this.sameAsSelectedRow();
            }
        });
        this.m_oSameAsPanel.setPreferredSize(new Dimension(320, 21));
        this.m_oSameAsPanel.setMinimumSize(new Dimension(320, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oSameAsPanel.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_oSameAsPanel.add(this.m_oDefaultBtn);
        this.m_oSameAsPanel.add(this.m_oSameAsBtn);
        return this.m_oSameAsPanel;
    }

    private void sortDevTypeProLst() {
        if (null == this.m_oDevProLst || this.m_oDevProLst.isEmpty()) {
            return;
        }
        ArrayList<PolicyDevTypeProperties> oExistLst = new ArrayList<PolicyDevTypeProperties>();
        ArrayList<PolicyDevTypeProperties> oNotExistLst = new ArrayList<PolicyDevTypeProperties>();
        int iDevTypeID = 0;
        for (PolicyDevTypeProperties oDevPro : this.m_oDevProLst) {
            if (null == oDevPro) continue;
            iDevTypeID = oDevPro.getDevTypeID();
            if (this.isDevTypeExist(iDevTypeID)) {
                oExistLst.add(oDevPro);
                continue;
            }
            oNotExistLst.add(oDevPro);
        }
        Collections.sort(oExistLst);
        Collections.sort(oNotExistLst);
        ArrayList<PolicyDevTypeProperties> oSortLst = new ArrayList<PolicyDevTypeProperties>();
        if (!oExistLst.isEmpty()) {
            oSortLst.addAll(oExistLst);
        }
        if (!oNotExistLst.isEmpty()) {
            oSortLst.addAll(oNotExistLst);
        }
        this.m_oDevProLst = oSortLst;
    }

    protected void initSelectionAndBtnStatus() {
        Vector oVct = this.m_oTableModel.getDataVector();
        if (null != oVct && !oVct.isEmpty()) {
            this.m_oTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.m_iCmdType == 1) {
            this.m_oDefaultBtn.setEnabled(false);
            this.m_oSameAsBtn.setEnabled(false);
            return;
        }
        if (null != oVct && !oVct.isEmpty()) {
            this.m_oDefaultBtn.setEnabled(true);
        } else {
            this.m_oDefaultBtn.setEnabled(false);
        }
        if (null != oVct && oVct.size() > 1) {
            this.m_oSameAsBtn.setEnabled(true);
        } else {
            this.m_oSameAsBtn.setEnabled(false);
        }
    }

    protected void revertToDefaultForAllDomain() {
        PolicyInfo oStaticPolicy = PolicyManager.getInstance().getPolicyInfo(-1);
        List<PolicyDevTypeProperties> oDevProLst = oStaticPolicy.getDevTypeProLst();
        List oCloneProLst = (List)CloneUtil.getClone(oDevProLst);
        this.initContentTypeCombox(oCloneProLst);
        this.initMaxBackupNumCombox(oCloneProLst);
        this.initData(oCloneProLst);
        TableCellEditor oColumnEditor = this.m_oTable.getCellEditor();
        if (null != oColumnEditor) {
            oColumnEditor.stopCellEditing();
            this.m_oTable.requestFocus(true);
        }
    }

    protected abstract void sameAsSelectedRow();

    protected abstract PolicyDevTypeProperties getPolicyDevProForRow(Vector var1, int var2);

    protected abstract void refreshDevProLst(List<PolicyDevTypeProperties> var1, PolicyDevTypeProperties var2);

    protected int getContentTypeValueFromTable(Object oContentTypeObj, int iRow) {
        int iBackupContentType = 0;
        ContentType oBackupContentType = (ContentType)this.m_oContentType[iRow].getSelectedItem();
        if (null != oBackupContentType) {
            iBackupContentType = oBackupContentType.getContentTypeCode();
        }
        return iBackupContentType;
    }

    protected String getDestinationFromTable(int iRow) {
        String strDestination = "";
        Object oSelectItem = this.m_oDestinationComboBox[iRow].getSelectedItem();
        if (oSelectItem instanceof ExternalFTPInfo) {
            ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)oSelectItem;
            strDestination = oExternalFTPInfo.getServerName();
        }
        return strDestination;
    }

    protected void resetContentTypeValue(int iDevTypeID, int iContentType, Object oContentTypeObj) {
        ResourceManager oRes = ResourceManager.getInstance();
        PolicyDevTypeProperties oDevPro = this.getDevPro(iDevTypeID);
        List<ContentType> oContentTypeLst = oDevPro.getBackupCotentTypeLst();
        if (null == oContentTypeLst) {
            return;
        }
        boolean bContains = false;
        ComboBoxWithToolTip oComb = new ComboBoxWithToolTip();
        for (ContentType oContentType : oContentTypeLst) {
            int iBackupContentType = oContentType.getContentTypeCode();
            int iDevTypeVerID = DeviceInfoManagerImpl.getInstance().getDeviceTypeVersionId(iDevTypeID);
            DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
            String sContentType = oRes.getResString(oDevTypeInfo, oContentType.getStrContentType());
            oContentType.setContentType(sContentType);
            oComb.addItem(oContentType);
            if (iContentType != iBackupContentType) continue;
            oComb.setSelectedItem(oContentType);
            bContains = true;
        }
        if (bContains) {
            oContentTypeObj = oComb;
        }
    }

    protected PolicyDevTypeProperties getDevPro(int iDevTypeID) {
        if (null == this.m_oDevProLst) {
            return null;
        }
        for (PolicyDevTypeProperties oDevPro : this.m_oDevProLst) {
            if (null == oDevPro || oDevPro.getDevTypeID() != iDevTypeID) continue;
            return oDevPro;
        }
        return null;
    }

    protected int getMaxNumValueFromTable(Object oMaxNumObj, int iRow) {
        int iBackuMaxNum = 5;
        if (null != this.m_oMaxBackupNumComboxs[iRow]) {
            iBackuMaxNum = this.m_oMaxBackupNumComboxs[iRow].getSelectedIndex();
        }
        return iBackuMaxNum;
    }

    private boolean isDevTypeExist(int iDevTypeID) {
        DeviceTypeInfo[] oDevTypes = DeviceInfoManagerImpl.getInstance().getExistDeviceTypes();
        if (null == oDevTypes || oDevTypes.length == 0) {
            return false;
        }
        DeviceTypeInfo oDevType = null;
        for (int i = 0; i < oDevTypes.length; ++i) {
            oDevType = oDevTypes[i];
            if (null == oDevType || oDevType.getDevTypeID() != iDevTypeID) continue;
            return true;
        }
        return false;
    }

    public void setDefaultSelectedRow(int mIDefaultSelectedRow) {
        this.m_iDefaultSelectedRow = mIDefaultSelectedRow;
    }

    protected boolean handleColumnSelectStateChange(int iColumn, boolean bSelected) {
        return true;
    }

    private class ComboxColumnEditor
    extends DefaultCellEditor {
        private int iColumnIndex;
        private static final long serialVersionUID = 739922674803241151L;

        ComboxColumnEditor(ComboBoxWithToolTip oComboBox, int iColumnIndex) {
            super(oComboBox);
            this.iColumnIndex = 0;
            this.iColumnIndex = iColumnIndex;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (this.iColumnIndex) {
                case 2: {
                    return AdvancedMainPanel.this.m_oContentType[row];
                }
                case 4: {
                    return AdvancedMainPanel.this.m_oMaxBackupNumComboxs[row];
                }
                case 3: {
                    AdvancedMainPanel.this.m_oDestinationComboBox[row].setBackground(table.getBackground());
                    return AdvancedMainPanel.this.m_oDestinationComboBox[row];
                }
            }
            return null;
        }
    }

    private class ComboxColumnRederer
    implements TableCellRenderer {
        private int iColumnIndex = 0;

        public ComboxColumnRederer(int iColumnIndex) {
            this.iColumnIndex = iColumnIndex;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SortableTableModel model = (SortableTableModel)table.getModel();
            int[] indexs = model.getIndexes();
            switch (this.iColumnIndex) {
                case 2: {
                    AdvancedMainPanel.this.m_oContentType[indexs[row]].setBackground(table.getBackground());
                    return AdvancedMainPanel.this.m_oContentType[indexs[row]];
                }
                case 4: {
                    AdvancedMainPanel.this.m_oMaxBackupNumComboxs[indexs[row]].setBackground(table.getBackground());
                    return AdvancedMainPanel.this.m_oMaxBackupNumComboxs[indexs[row]];
                }
                case 3: {
                    AdvancedMainPanel.this.m_oDestinationComboBox[indexs[row]].setBackground(table.getBackground());
                    return AdvancedMainPanel.this.m_oDestinationComboBox[indexs[row]];
                }
            }
            return null;
        }
    }

    private class DevTypeColumnRender
    implements TableCellRenderer {
        private DevTypeColumnRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int iDevTypeID;
            boolean bExist;
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setBorder(AdvancedMainPanel.this.getBorder());
            oLabel.setText(value.toString());
            if (isSelected) {
                oLabel.setBackground(table.getSelectionBackground());
            } else {
                oLabel.setBackground(table.getBackground());
            }
            Object oDevTypeIDObj = table.getValueAt(row, 0);
            if (null != oDevTypeIDObj && (bExist = AdvancedMainPanel.this.isDevTypeExist(iDevTypeID = ((Integer)oDevTypeIDObj).intValue()))) {
                oLabel.setForeground(Color.BLUE);
            }
            return oLabel;
        }
    }
}

