/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view.advanced;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.view.advanced.AdvancedMainPanel;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class AccessTablePanel
extends AdvancedMainPanel {
    private static final long serialVersionUID = 850057512222956847L;

    public AccessTablePanel(int iTabIndex, int iPolicyID, List<PolicyDevTypeProperties> odevProLst, int iCmdType) {
        super(iTabIndex, iPolicyID, odevProLst, iCmdType);
    }

    @Override
    protected void initTableModel() {
        this.m_oTableModel = new SortableTableModel(this.getColumns(), 0){
            private static final long serialVersionUID = 6576375427843979626L;

            public boolean isCellEditable(int row, int column) {
                if (AccessTablePanel.this.m_iCmdType == 1) {
                    return false;
                }
                Object oCellValue = this.getValueAt(row, column);
                if (null == oCellValue || oCellValue instanceof String && ((String)oCellValue).equals("--")) {
                    return false;
                }
                return column == 2 || column == 3 || column == 4 || column == 5;
            }
        };
    }

    @Override
    protected void initTableRender(int iRowNum) {
        super.initTableRender(iRowNum);
        this.setName("policy_AccessTablePanel");
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oTable.getColumnModel().getColumn(5);
        this.m_oSaveCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oTable.getTableHeader().getBackground(), 5);
        oSaveCoulmn.setHeaderRenderer(this.m_oSaveCheckBoxHeader);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 28));
        this.m_oTable.getColumnModel().getColumn(5).setMinWidth(80);
        try {
            this.m_oTable.removeColumn(this.m_oTable.getColumnModel().getColumn(7));
            this.m_oTable.removeColumn(this.m_oTable.getColumnModel().getColumn(6));
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::policy remove column exception");
        }
    }

    @Override
    protected void initData(List<PolicyDevTypeProperties> odevProLst) {
        this.m_oDevProLst = odevProLst;
        this.m_oTableModel.getDataVector().clear();
        PolicyDevTypeProperties oDevTypePro = null;
        int iSaveBeforeBackupSelectCount = 0;
        int iSaveNotSupportCount = 0;
        for (int i = 0; i < odevProLst.size(); ++i) {
            Object[] oCellData = new Object[this.getColumns().length];
            oDevTypePro = odevProLst.get(i);
            int iDevTypeID = oDevTypePro.getDevTypeID();
            String sDevTypeName = oDevTypePro.getDevTypeName();
            ComboBoxWithToolTip oContentTypeCombox = this.m_oContentType[i];
            ComboBoxWithToolTip oDestinationCombox = this.m_oDestinationComboBox[i];
            ComboBoxWithToolTip oMaxbackupNumBox = this.m_oMaxBackupNumComboxs[i];
            Object oSaveBeforeBackup = oDevTypePro.isSaveBeforeBackup();
            if (null != oSaveBeforeBackup) {
                if (((Boolean)oSaveBeforeBackup).booleanValue()) {
                    ++iSaveBeforeBackupSelectCount;
                }
            } else {
                ++iSaveNotSupportCount;
            }
            oCellData[0] = iDevTypeID;
            oCellData[1] = sDevTypeName;
            oCellData[2] = oContentTypeCombox;
            oCellData[3] = oDestinationCombox;
            oCellData[4] = oMaxbackupNumBox;
            oCellData[5] = oSaveBeforeBackup;
            this.m_oTableModel.addRow(oCellData);
        }
        this.m_oTableModel.fireTableRowsUpdated(0, odevProLst.size() - 1);
        if (this.m_oTable.getRowCount() > 0) {
            this.m_oTable.setRowSelectionInterval(this.m_iDefaultSelectedRow, this.m_iDefaultSelectedRow);
        }
        this.initHeadStatus(5, iSaveBeforeBackupSelectCount, iSaveNotSupportCount, odevProLst.size());
        this.m_oSaveCheckBoxHeader.handleHeaderChckBxChanges(5);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessTablePanel.this.m_oTable.updateUI();
                AccessTablePanel.this.m_oTable.getTableHeader().repaint();
            }
        });
    }

    private void initHeadStatus(int iColumn, int iSelCount, int iNotSupportCount, int iTotalCount) {
        this.m_iSaveSelectionType = iNotSupportCount == iTotalCount ? 2 : (iSelCount == iTotalCount || iSelCount + iNotSupportCount == iTotalCount ? 0 : (iSelCount < iTotalCount && iSelCount != 0 ? 1 : 2));
    }

    @Override
    protected PolicyDevTypeProperties getPolicyDevProForRow(Vector oRowVector, int iRow) {
        PolicyDevTypeProperties oDevPro = new PolicyDevTypeProperties();
        int iDevTypeID = (Integer)oRowVector.get(0);
        String sDevTypeName = oRowVector.get(1).toString();
        Object oContentTypeObj = oRowVector.get(2);
        int iBackupContentType = this.getContentTypeValueFromTable(oContentTypeObj, iRow);
        String strDestination = this.getDestinationFromTable(iRow);
        Object oMaxNumObj = oRowVector.get(4);
        int iBackuMaxNum = this.getMaxNumValueFromTable(oMaxNumObj, iRow);
        Object oSaveBefore = oRowVector.get(5);
        oDevPro.setDevTypeID(iDevTypeID);
        oDevPro.setDevTypeName(sDevTypeName);
        oDevPro.setBackupContentType(iBackupContentType);
        oDevPro.setStrDestination(strDestination);
        oDevPro.setNumOfBackupCopies(iBackuMaxNum);
        oDevPro.setSaveBeforeBackup(oSaveBefore);
        return oDevPro;
    }

    @Override
    protected void refreshDevProLst(List<PolicyDevTypeProperties> oDevProLst, PolicyDevTypeProperties oDevPro) {
        for (PolicyDevTypeProperties oDevProInfo : oDevProLst) {
            if (oDevProInfo.getDevTypeID() != oDevPro.getDevTypeID()) continue;
            oDevProInfo.setBackupContentType(oDevPro.getBackupContentType());
            oDevProInfo.setNumOfBackupCopies(oDevPro.getNumOfBackupCopies());
            oDevProInfo.setSaveBeforeBackup(oDevPro.isSaveBeforeBackup());
            oDevProInfo.setStrDestination(oDevPro.getStrDestination());
        }
    }

    @Override
    protected int getHeadStatus(int iColumn) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            Object oo = oItor.next();
            Object xx = ((Vector)oo).get(iColumn);
            if (null != xx) {
                if (!(xx instanceof Boolean) || !((Boolean)xx).booleanValue()) continue;
                ++iSelectCount;
                continue;
            }
            ++iNotSupportCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
        return this.m_iSaveSelectionType;
    }

    private void setHeadStatus(int iColumn, boolean bAllSaveStatus) {
        Vector oVct = this.m_oTableModel.getDataVector();
        Iterator oItor = oVct.iterator();
        int iSelectCount = 0;
        int iNotSupportCount = 0;
        int iTotalCount = oVct.size();
        while (oItor.hasNext()) {
            Object oo = oItor.next();
            Object oColumnObj = ((Vector)oo).get(iColumn);
            if (null != oColumnObj) {
                ((Vector)oo).set(iColumn, bAllSaveStatus);
                if (!bAllSaveStatus) continue;
                ++iSelectCount;
                continue;
            }
            ++iNotSupportCount;
        }
        this.initHeadStatus(iColumn, iSelectCount, iNotSupportCount, iTotalCount);
    }

    @Override
    protected void sameAsSelectedRow() {
        DCFrameWorkUtil.waitCursor();
        int iSelectRow = this.m_oTable.getSelectedRow();
        Object oBackupType = this.m_oTable.getValueAt(iSelectRow, 2);
        int iBackupType = this.getContentTypeValueFromTable(oBackupType, iSelectRow);
        Object oMaxNum = this.m_oTable.getValueAt(iSelectRow, 4);
        int iMaxNum = this.getMaxNumValueFromTable(oMaxNum, iSelectRow);
        Object oSaveBeforeBackup = this.m_oTable.getValueAt(iSelectRow, 5);
        String strDestination = this.getDestinationFromTable(iSelectRow);
        List oCloneDevProLst = (List)CloneUtil.getClone(this.m_oDevProLst);
        PolicyDevTypeProperties oDevPro = null;
        for (int i = 0; i < oCloneDevProLst.size(); ++i) {
            oDevPro = (PolicyDevTypeProperties)oCloneDevProLst.get(i);
            oDevPro.refreshBackupContentType(iBackupType);
            oDevPro.setNumOfBackupCopies(iMaxNum);
            oDevPro.refreshSaveBeforeBackup(oSaveBeforeBackup);
            oDevPro.setStrDestination(strDestination);
        }
        this.initContentTypeCombox(oCloneDevProLst);
        this.initMaxBackupNumCombox(oCloneDevProLst);
        this.setDefaultSelectedRow(iSelectRow);
        this.initData(oCloneDevProLst);
        DCFrameWorkUtil.defaultCursor();
    }

    @Override
    protected boolean handleColumnSelectStateChange(int iColumn, boolean bSelected) {
        if (bSelected || iColumn != 5) {
            return true;
        }
        int iConfirmRlt = DCOptionPane.showConfirmDialog((Component)this, ResourceManager.getInstance().getResString("MSG_POLICY_DESELECT_SAVE_BEFORE_BACKUP"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        return 0 == iConfirmRlt;
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof CheckBoxHeader)) {
                return;
            }
            int iColumnIndex = ((CheckBoxHeader)source).getColumn();
            boolean bAllSelectStatus = false;
            if (0 == AccessTablePanel.this.m_iSaveSelectionType) {
                boolean bRtn = AccessTablePanel.this.handleColumnSelectStateChange(iColumnIndex, false);
                if (!bRtn) {
                    return;
                }
                bAllSelectStatus = false;
            } else if (1 == AccessTablePanel.this.m_iSaveSelectionType || 2 == AccessTablePanel.this.m_iSaveSelectionType) {
                bAllSelectStatus = true;
            }
            AccessTablePanel.this.setHeadStatus(iColumnIndex, bAllSelectStatus);
            AccessTablePanel.this.m_oSaveCheckBoxHeader.handleHeaderChckBxChanges(5);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccessTablePanel.this.m_oTable.repaint();
                    AccessTablePanel.this.m_oTable.getTableHeader().repaint();
                }
            });
        }
    }
}

