/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.components.tree.renderer.DCDefaultTreeCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeHelper;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.controller.IPolicyChangeListener;
import com.huawei.dc.policy.controller.PolicyEventObject;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyTreeEventListener;
import com.huawei.dc.policy.controller.PolicyTreeMenuItemHandler;
import com.huawei.dc.policy.controller.PolicyTreePopupManager;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.PolicyTreeNodeInfo;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class PolicyTreePanel
extends JPanel
implements IPolicyChangeListener {
    private static final long serialVersionUID = 4434921085299000292L;
    private List<PolicyInfo> m_oPolicyLst = null;
    private JTree m_oPolicyTree = null;
    private DefaultTreeModel m_oPolicyTreeModel;
    private DefaultMutableTreeNode m_oRoot;
    private JScrollPane m_oScrollPane;
    private PolicyTreeMenuItemHandler m_oPolicyTreeMenuItemHandler = null;
    private PolicyTreePopupManager m_oPopupManager = null;
    private JPopupMenu m_oPolicyTreePopupMenu;
    private List m_oListenerLst = null;
    private static final int DEFAULT_SELECT_ROW = 1;

    protected PolicyTreePanel(List<PolicyInfo> oPolicyLst) {
        this.initGUI();
        this.initData(oPolicyLst, true);
        this.initPopupMenuManager();
        this.initTreeSelectListener();
        this.registerPolicyChangeListener();
    }

    private void initPopupMenuManager() {
        this.m_oPolicyTreeMenuItemHandler = new PolicyTreeMenuItemHandler(this);
        this.m_oPopupManager = new PolicyTreePopupManager(this.m_oPolicyTreeMenuItemHandler);
    }

    private void initGUI() {
        this.m_oPolicyTree = new JTree();
        this.m_oPolicyTree.setName("Policy_PolicyTreePanel_m_oPolicyTree");
        this.m_oPolicyTreeModel = (DefaultTreeModel)this.m_oPolicyTree.getModel();
        this.m_oPolicyTree.getSelectionModel().setSelectionMode(1);
        this.m_oRoot = new DefaultMutableTreeNode();
        PolicyTreeNodeInfo oRootNode = new PolicyTreeNodeInfo(ResourceManager.getInstance().getResString("POLICY_TREE_ROOT_NODE_NAME"));
        this.m_oRoot.setUserObject(oRootNode);
        this.m_oPolicyTreeModel.setRoot(this.m_oRoot);
        this.m_oPolicyTree.setBackground(Color.white);
        this.setBackground(Color.white);
        this.m_oPolicyTree.setShowsRootHandles(true);
        this.m_oPolicyTree.setCellRenderer(new PolicyTreeCellRender());
        this.m_oPolicyTree.setSelectionRow(0);
        this.m_oScrollPane = new JScrollPane(this.m_oPolicyTree);
        this.m_oScrollPane.setName("policy_PolicyTreePanel_m_oScrollPane");
        this.m_oPolicyTree.addMouseListener(this.generateMouseAdapterForTree());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setLayout(new BorderLayout());
        this.add(this.m_oScrollPane);
    }

    protected void initData(List<PolicyInfo> oPolicyLst, boolean bChangeFocus) {
        DCDebugTracer.trace("Mark::PolicyTreePanel::initData::begin");
        this.m_oPolicyLst = oPolicyLst;
        if (null == this.m_oPolicyLst || this.m_oPolicyLst.size() == 0) {
            return;
        }
        this.m_oRoot.removeAllChildren();
        SubMapInfo oMainSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
        SubMapInfo oSubmap = null;
        for (PolicyInfo oPolicyInfo : oPolicyLst) {
            int iPolicyID = oPolicyInfo.getPolicyID();
            if (iPolicyID == -1) {
                DCDebugTracer.trace("PolicyTreePanel::initData:: " + oPolicyInfo.getPolicyName() + " 's policy id is -1");
                continue;
            }
            DefaultMutableTreeNode oPolicyTreeNode = new DefaultMutableTreeNode();
            PolicyTreeNodeInfo oPolicyNode = new PolicyTreeNodeInfo(oPolicyInfo);
            oPolicyTreeNode.setUserObject(oPolicyNode);
            this.m_oRoot.add(oPolicyTreeNode);
            if (null == oPolicyInfo.getDevicePolicyStateHm() || 0 == oPolicyInfo.getDevicePolicyStateHm().size()) continue;
            this.initDevidsListForSubmap(oPolicyInfo);
            if (null == oPolicyInfo.getDevListForEverySubnet() || 0 == oPolicyInfo.getDevListForEverySubnet().size()) continue;
            oSubmap = oMainSubmap.getSubmapInfoByPoliyInfo(oPolicyInfo);
            this.populateSubmapTree(iPolicyID, oPolicyTreeNode, oSubmap);
        }
        if (bChangeFocus) {
            this.expandTreeAtRoot();
            this.m_oPolicyTree.setSelectionRow(0);
            PolicyEventObject eventObj = new PolicyEventObject(this.m_oRoot.getUserObject());
            this.notifyEvent(eventObj);
            DCFrameWorkUtil.updateUI(this.m_oPolicyTree);
        } else {
            DefaultMutableTreeNode oLastNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
            if (null == oLastNode) {
                return;
            }
            PolicyTreeNodeInfo oNodeInfo = (PolicyTreeNodeInfo)oLastNode.getUserObject();
            DefaultMutableTreeNode oNewNode = this.getNode(oNodeInfo.getPolicyID(), oNodeInfo.getSubmapID());
            if (null == oNewNode) {
                return;
            }
            TreePath oTreePath = new TreePath(oNewNode.getPath());
            this.m_oPolicyTree.setSelectionPath(oTreePath);
            this.m_oPolicyTree.expandPath(oTreePath);
            this.m_oPolicyTree.scrollPathToVisible(oTreePath);
            DCFrameWorkUtil.updateUI(this.m_oPolicyTree);
        }
        DCFrameWorkUtil.updateUI(this.m_oPolicyTree);
        DCDebugTracer.trace("Mark::PolicyTreePanel::initData::end");
    }

    private void initDevidsListForSubmap(PolicyInfo oPolicyInfo) {
        DCDebugTracer.trace("Mark::PolicyTreePanel::getSubMapIDSet::begin");
        Map<Integer, SubMapInfo> oSubMapList = DeviceInfoManagerImpl.getInstance().getSubMapList();
        TIntHashSet oDevIDLst = oPolicyInfo.getDevIDLst();
        if (null == oDevIDLst || 0 == oDevIDLst.size()) {
            return;
        }
        TIntIterator oDevIDItor = oDevIDLst.iterator();
        int iDevID = 0;
        SubMapInfo oSubMapInfo = null;
        HashMap<String, TIntHashSet> oDevListForSubMap = oPolicyInfo.getDevListForEverySubnet();
        Set<String> subMapID = oDevListForSubMap.keySet();
        Iterator<Integer> devIDItor = oSubMapList.keySet().iterator();
        int subMapIDArraySize = subMapID.size();
        if (subMapIDArraySize > 0) {
            int count = 0;
            String[] strSpecailDevSubMap = new String[subMapIDArraySize - 1];
            for (String subMapid : subMapID) {
                if (subMapid.equals("S102")) continue;
                strSpecailDevSubMap[count] = subMapid;
                ++count;
            }
            HashSet<String> oSubMapID = new HashSet<String>();
            int deviceID = 0;
            while (devIDItor.hasNext()) {
                deviceID = devIDItor.next();
                oSubMapInfo = oSubMapList.get(deviceID);
                if (!oSubMapList.containsKey(deviceID) || null == oSubMapInfo) continue;
                oSubMapID.add(oSubMapInfo.m_strSubMapID);
            }
            for (int i = 0; i < strSpecailDevSubMap.length; ++i) {
                if (strSpecailDevSubMap[i] == null || !oDevListForSubMap.containsKey(strSpecailDevSubMap[i]) || oSubMapID.contains(strSpecailDevSubMap[i])) continue;
                TIntIterator oDevListSubItor = oDevListForSubMap.get(strSpecailDevSubMap[i]).iterator();
                while (oDevListSubItor.hasNext()) {
                    oDevListSubItor.next();
                    oDevListSubItor.remove();
                }
                oDevListForSubMap.remove(strSpecailDevSubMap[i]);
            }
            List<Integer> changeDevIdList = oPolicyInfo.getChangedDevIdLst();
            if (changeDevIdList != null) {
                Iterator<Integer> changeDevidItor = changeDevIdList.iterator();
                int changeDevid = 0;
                while (changeDevidItor.hasNext()) {
                    changeDevid = changeDevidItor.next();
                    for (int i = 0; i < strSpecailDevSubMap.length; ++i) {
                        if (oSubMapList.get(changeDevid) == null || oSubMapList.get((Object)Integer.valueOf((int)changeDevid)).m_strSubMapID.equals(strSpecailDevSubMap[i]) || oDevListForSubMap.get(strSpecailDevSubMap[i]) == null || !oDevListForSubMap.get(strSpecailDevSubMap[i]).contains(changeDevid) || DeviceInfoManagerImpl.getInstance().getSubmapForID((String)strSpecailDevSubMap[i]).m_oSubMapDevIDLst.contains(changeDevid)) continue;
                        oDevListForSubMap.get(strSpecailDevSubMap[i]).remove(changeDevid);
                        if (0 != oDevListForSubMap.get(strSpecailDevSubMap[i]).size()) continue;
                        oPolicyInfo.getDevListForEverySubnet().remove(strSpecailDevSubMap[i]);
                    }
                }
            }
        }
        while (oDevIDItor.hasNext()) {
            iDevID = oDevIDItor.next();
            if (oSubMapList.containsKey(iDevID)) {
                oSubMapInfo = oSubMapList.get(iDevID);
                if (null == oSubMapInfo) continue;
                oPolicyInfo.getDevicePolicyState(iDevID).setSubMapId(oSubMapInfo.m_strSubMapID);
                if (!oDevListForSubMap.containsKey(oSubMapInfo.m_strSubMapID)) {
                    TIntHashSet oDevsSet = new TIntHashSet();
                    oDevsSet.add(iDevID);
                    oDevListForSubMap.put(oSubMapInfo.m_strSubMapID, oDevsSet);
                    continue;
                }
                oDevListForSubMap.get(oSubMapInfo.m_strSubMapID).add(iDevID);
                continue;
            }
            DCDebugTracer.trace("PolicyTreePanel::getSubMapIDSet::can not find iDev");
        }
        DCDebugTracer.trace("Mark::PolicyTreePanel::getSubMapIDSet::end");
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iChildCount = PolicyTreePanel.this.m_oRoot.getChildCount();
                for (int i = 0; i < iChildCount; ++i) {
                    DefaultMutableTreeNode oChildNode = (DefaultMutableTreeNode)PolicyTreePanel.this.m_oRoot.getChildAt(i);
                    TreePath oTreePath = new TreePath(oChildNode.getPath());
                    PolicyTreePanel.this.m_oPolicyTree.expandPath(oTreePath);
                }
            }
        });
    }

    private void populateSubmapTree(int iPolicyID, DefaultMutableTreeNode oPolicyTreeNode, SubMapInfo oSubmap) {
        DCDebugTracer.trace("Mark::PolicyTreePanel::populateSubmapTree::begin");
        if (null == oSubmap) {
            return;
        }
        DefaultMutableTreeNode oPNode = oPolicyTreeNode;
        if (!"".equals(oSubmap.m_strParentSubMapID)) {
            DefaultMutableTreeNode oSubmapTreeNode = new DefaultMutableTreeNode();
            PolicyTreeNodeInfo oSubmapNode = new PolicyTreeNodeInfo(iPolicyID, oSubmap);
            oSubmapTreeNode.setUserObject(oSubmapNode);
            oPolicyTreeNode.add(oSubmapTreeNode);
            oPNode = oSubmapTreeNode;
        }
        LinkedList<SubMapInfo> oChildSubmap = oSubmap.m_SubMapList;
        for (SubMapInfo oSub : oChildSubmap) {
            this.populateSubmapTree(iPolicyID, oPNode, oSub);
        }
        DCDebugTracer.trace("Mark::PolicyTreePanel::populateSubmapTree::end");
    }

    private void deleteDevFromPolicy(PolicyInfo oPolicyInfo, boolean isThisClientRequest) {
        DefaultMutableTreeNode oDestNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
        if (null == oDestNode) {
            return;
        }
        ArrayList<String> strSpecailDevSubMapIdLst = new ArrayList<String>();
        DevicePolicyState oPolicyState = null;
        String strSpecailDevSubMapId = null;
        int iDevID = 0;
        List<Integer> oChangeDevIdLst = oPolicyInfo.getChangedDevIdLst();
        for (int i = oChangeDevIdLst.size() - 1; i >= 0; --i) {
            iDevID = oChangeDevIdLst.get(i);
            oPolicyState = oPolicyInfo.getDevicePolicyState(iDevID);
            oPolicyInfo.removeDevice(iDevID);
            if (null == oPolicyState) continue;
            strSpecailDevSubMapId = oPolicyState.getSubMapId();
            if (null == strSpecailDevSubMapId) {
                SubMapInfo oMainSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
                SubMapInfo oSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMainSubmap, iDevID);
                if (null != oSubmap) {
                    strSpecailDevSubMapId = oSubmap.m_strSubMapID;
                }
                if (null == strSpecailDevSubMapId) continue;
            }
            if (strSpecailDevSubMapIdLst.contains(strSpecailDevSubMapId)) continue;
            strSpecailDevSubMapIdLst.add(strSpecailDevSubMapId);
            ArrayList<Integer> oChangeDevIdLstForPolicy = new ArrayList<Integer>();
            oChangeDevIdLstForPolicy.add(iDevID);
            oPolicyInfo.setChangedDevIdLst(oChangeDevIdLstForPolicy);
            this.updateChangeDev(oPolicyInfo, oDestNode, strSpecailDevSubMapId, isThisClientRequest);
        }
    }

    private void updateChangeDev(PolicyInfo oPolicyInfo, DefaultMutableTreeNode oDestNode, String strSpecailDevSubMapId, boolean isThisClientRequest) {
        Enumeration<TreeNode> oNodeEnu = oDestNode.depthFirstEnumeration();
        block0: while (oNodeEnu.hasMoreElements()) {
            int iPolicyId;
            DefaultMutableTreeNode oTmpSubmapTreeNode;
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oNodeEnu.nextElement();
            PolicyTreeNodeInfo oNodeInfo = (PolicyTreeNodeInfo)oNode.getUserObject();
            SubMapInfo oTmpSubMapInfo = (SubMapInfo)CloneUtil.getClone(oNodeInfo.getSubMapInfo());
            if (null == oTmpSubMapInfo || !oTmpSubMapInfo.m_strSubMapID.equals(strSpecailDevSubMapId)) continue;
            int iDevId = oPolicyInfo.getChangedDevIdLst().get(0);
            oTmpSubMapInfo.m_oSubMapDevIDLst.remove(iDevId);
            oPolicyInfo.removeDevice(iDevId);
            if (this.isContainSpecialDev(oPolicyInfo, oTmpSubMapInfo) || null == (oTmpSubmapTreeNode = this.getNodeForDelDevice(iPolicyId = oPolicyInfo.getPolicyID(), oTmpSubMapInfo.m_strSubMapID))) break;
            DefaultMutableTreeNode oParentNode = (DefaultMutableTreeNode)oTmpSubmapTreeNode.getParent();
            oTmpSubmapTreeNode.removeFromParent();
            while (null != oParentNode) {
                oTmpSubmapTreeNode = oParentNode;
                oParentNode = (DefaultMutableTreeNode)oTmpSubmapTreeNode.getParent();
                PolicyTreeNodeInfo oTmpSubMapNodeInfo = (PolicyTreeNodeInfo)oTmpSubmapTreeNode.getUserObject();
                SubMapInfo oCurrentSubMapInfo = oTmpSubMapNodeInfo.getSubMapInfo();
                if (null == oCurrentSubMapInfo || this.isContainSpecialDev(oPolicyInfo, oCurrentSubMapInfo) || oTmpSubMapNodeInfo.getNodeName().equals(ResourceManager.getInstance().getResString("POLICY_DEFAULT_NAME"))) break block0;
                oTmpSubmapTreeNode.removeFromParent();
            }
            break block0;
        }
        if (null == (oDestNode = this.getNodeForDelDevice(oPolicyInfo.getPolicyID(), strSpecailDevSubMapId))) {
            oDestNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
        }
        this.updateTree(oDestNode, isThisClientRequest);
    }

    private void updateChangeNode(PolicyInfo oPolicyInfo) {
        SubMapInfo oMainSubmap;
        SubMapInfo oSubmap;
        DCDebugTracer.trace("PolicyTreePanel::updateChangeNode::begin");
        DefaultMutableTreeNode oDestNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
        if (null == oDestNode) {
            DCDebugTracer.trace("PolicyTreePanel::updateChangeNode::oDestNode is null");
            return;
        }
        PolicyTreeNodeInfo oDestNodeInfo = (PolicyTreeNodeInfo)oDestNode.getUserObject();
        if (null == oDestNodeInfo) {
            DCDebugTracer.trace("PolicyTreePanel::updateChangeNode::oDestNodeInfo is null");
            return;
        }
        if (!oDestNodeInfo.getNodeName().endsWith(oPolicyInfo.getPolicyName())) {
            oDestNodeInfo.setNodeName(oPolicyInfo.getPolicyName());
        }
        if (0 < oDestNode.getChildCount()) {
            oDestNode.removeAllChildren();
        }
        this.initDevidsListForSubmap(oPolicyInfo);
        if (null != oPolicyInfo.getDevListForEverySubnet() && 0 < oPolicyInfo.getDevListForEverySubnet().size() && null != (oSubmap = (oMainSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo()).getSubmapInfoByPoliyInfo(oPolicyInfo))) {
            if (0 < oDestNode.getChildCount()) {
                oDestNode.removeAllChildren();
            }
            this.populateSubmapTree(oPolicyInfo.getPolicyID(), oDestNode, oSubmap);
        }
        DCDebugTracer.trace("PolicyTreePanel::updateChangeNode::end");
    }

    private boolean isContainSpecialDev(PolicyInfo oPolicyInfo, SubMapInfo oSubMapInfo) {
        TIntHashSet oDevIdSet = oPolicyInfo.getDevIDLst();
        for (int iTmpDevID : oDevIdSet) {
            if (null == oSubMapInfo || !oSubMapInfo.bContainsDev(iTmpDevID)) continue;
            return true;
        }
        return false;
    }

    private void initTreeSelectListener() {
        this.m_oPolicyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent oEvent) {
                TreePath oPath = oEvent.getNewLeadSelectionPath();
                if (oPath != null) {
                    Object oNode = oPath.getLastPathComponent();
                    DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oNode;
                    PolicyEventObject eventObj = new PolicyEventObject(oTreeNode.getUserObject());
                    PolicyTreePanel.this.notifyEvent(eventObj);
                }
            }
        });
    }

    private void notifyEvent(final PolicyEventObject oDCEventObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iCount = PolicyTreePanel.this.m_oListenerLst.size();
                for (int index = 0; index < iCount; ++index) {
                    PolicyTreeEventListener eventListener = (PolicyTreeEventListener)PolicyTreePanel.this.m_oListenerLst.get(index);
                    eventListener.onTreeNodeSelection(oDCEventObject);
                }
            }
        });
    }

    public JTree getPolicyTree() {
        return this.m_oPolicyTree;
    }

    private MouseListener generateMouseAdapterForTree() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                PolicyTreePanel.this.policyTree_MousePressed(oMouseEvent);
            }
        };
    }

    protected void policyTree_MousePressed(MouseEvent oMouseEvent) {
        if (SwingUtilities.isLeftMouseButton(oMouseEvent)) {
            return;
        }
        int iClickedRow = this.m_oPolicyTree.getClosestRowForLocation(oMouseEvent.getX(), oMouseEvent.getY());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oPolicyTree.getSelectionRows();
        if (null != nRows && nRows.length > 1) {
            bIsClickedRowSelected = this.isClickedRowSelected(iClickedRow, nRows);
        }
        if (!bIsClickedRowSelected) {
            TreeSelectionModel selectionModel = this.m_oPolicyTree.getSelectionModel();
            selectionModel.setSelectionPath(this.m_oPolicyTree.getPathForRow(iClickedRow));
        }
        if (iClickedRow == 0) {
            return;
        }
        this.m_oPolicyTreePopupMenu = this.m_oPopupManager.loadMenu();
        this.m_oPolicyTreePopupMenu.show(this.m_oPolicyTree, oMouseEvent.getX(), oMouseEvent.getY());
    }

    private boolean isClickedRowSelected(int iClickedRow, int[] nRows) {
        boolean bRetval = false;
        for (int i = 0; i < nRows.length; ++i) {
            if (nRows[i] != iClickedRow) continue;
            bRetval = true;
            break;
        }
        return bRetval;
    }

    private void registerPolicyChangeListener() {
        PolicyManager.getInstance().registerPolicyChangeListener(this);
    }

    @Override
    public synchronized void handleDeviceConfigNotification(PolicyEventObject oPolicyEvent) {
        PolicyInfo oPolicyInfo = null;
        Object oEventObj = oPolicyEvent.getSource();
        int iEventType = oPolicyEvent.getEventType();
        boolean isThisClientRequest = oPolicyEvent.isThisClientRequest();
        if (!(oEventObj instanceof PolicyInfo)) {
            DCDebugTracer.traceError("PolicyTreePanel#handleDeviceConfigNotification oEventObj is not instance of PolicyInfo.");
            return;
        }
        oPolicyInfo = (PolicyInfo)oEventObj;
        switch (iEventType) {
            case 0: {
                this.handlePolicyAdd(oPolicyInfo, isThisClientRequest);
                break;
            }
            case 1: {
                if (oPolicyInfo.getPolicyID() == 0) {
                    this.handlePolicyChange(oPolicyInfo, iEventType, isThisClientRequest);
                    break;
                }
                this.handlePolicyDelete(oPolicyInfo, isThisClientRequest, oPolicyEvent.isNeedRefresh());
                break;
            }
            case 2: {
                this.handlePolicyChange(oPolicyInfo, iEventType, isThisClientRequest);
                break;
            }
            case 5: {
                this.deleteDevFromPolicy(oPolicyInfo, isThisClientRequest);
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                this.handleDevMove(oPolicyInfo, iEventType, isThisClientRequest, oPolicyEvent.isNeedRefresh());
                break;
            }
            case 7: {
                this.deleteEmptySubnetFormPolicy(oPolicyInfo);
                break;
            }
        }
    }

    private void handleDevMove(PolicyInfo oPolicyInfo, int iEventType, boolean isThisClientRequest, boolean isNeedRefresh) {
        if (null == oPolicyInfo) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        PolicyTreeNodeInfo oPolicyNode = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        String sSubmapID = oPolicyNode.getSubmapID();
        this.updateChangeNode(oPolicyInfo);
        if (isNeedRefresh) {
            DefaultMutableTreeNode oDestNode = this.getNode(oPolicyInfo.getPolicyID(), sSubmapID);
            if (null == oDestNode) {
                oDestNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
            }
            this.updateTree(oDestNode, isThisClientRequest);
        }
        DCDebugTracer.trace("handleDevMove::end");
    }

    private void handlePolicyAdd(PolicyInfo oPolicyInfo, boolean isThisClientRequest) {
        DefaultMutableTreeNode oPolicyTreeNode = new DefaultMutableTreeNode();
        PolicyTreeNodeInfo oPolicyNode = new PolicyTreeNodeInfo(oPolicyInfo);
        oPolicyTreeNode.setUserObject(oPolicyNode);
        this.m_oRoot.add(oPolicyTreeNode);
        this.initDevidsListForSubmap(oPolicyInfo);
        if (null != oPolicyInfo.getDevListForEverySubnet() && 0 != oPolicyInfo.getDevListForEverySubnet().size()) {
            SubMapInfo oMainSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
            int iPolicyID = oPolicyInfo.getPolicyID();
            if (null != oMainSubmap) {
                SubMapInfo oSubmap = oMainSubmap.getSubmapInfoByPoliyInfo(oPolicyInfo);
                this.populateSubmapTree(iPolicyID, oPolicyTreeNode, oSubmap);
            }
        }
        TreePath trePath = new TreePath(oPolicyTreeNode);
        TreeHelper.expandAll(this.m_oPolicyTree, trePath, true);
        this.updateTree(oPolicyTreeNode, isThisClientRequest);
    }

    private void handlePolicyDelete(PolicyInfo oPolicyInfo, boolean isThisClientRequest, boolean isNeedRefresh) {
        int iPolicyId = oPolicyInfo.getPolicyID();
        Enumeration<TreeNode> oChildEnum = this.m_oRoot.breadthFirstEnumeration();
        while (oChildEnum.hasMoreElements()) {
            DefaultMutableTreeNode oPolicyNode = (DefaultMutableTreeNode)oChildEnum.nextElement();
            PolicyTreeNodeInfo oNodeInfo = (PolicyTreeNodeInfo)oPolicyNode.getUserObject();
            if (iPolicyId != oNodeInfo.getPolicyID()) continue;
            oPolicyNode.removeFromParent();
            break;
        }
        if (isNeedRefresh) {
            this.updateTree(null, isThisClientRequest);
            DCFrameWorkUtil.updateUI(this);
        }
    }

    private void handlePolicyChange(PolicyInfo oPolicyInfo, int iEventType, boolean isThisClientRequest) {
        if (null == oPolicyInfo) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        PolicyTreeNodeInfo oPolicyNode = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        String sSubmapID = oPolicyNode.getSubmapID();
        this.updateChangeNode(oPolicyInfo);
        DefaultMutableTreeNode oDestNode = this.getNode(oPolicyInfo.getPolicyID(), sSubmapID);
        if (null == oDestNode) {
            oDestNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
        }
        this.updateTree(oDestNode, isThisClientRequest);
    }

    private void updateTree(final DefaultMutableTreeNode oPolicyTreeNode, final boolean isThisClientRequest) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyTreePanel.this.m_oPolicyTree.updateUI();
                if (null != oPolicyTreeNode) {
                    TreePath oTreePath = null;
                    oTreePath = isThisClientRequest ? new TreePath(oPolicyTreeNode.getPath()) : new TreePath(((DefaultMutableTreeNode)PolicyTreePanel.this.m_oPolicyTree.getSelectionPath().getLastPathComponent()).getPath());
                    PolicyTreePanel.this.m_oPolicyTree.setSelectionPath(oTreePath);
                    PolicyTreePanel.this.m_oPolicyTree.expandPath(oTreePath);
                    PolicyTreePanel.this.m_oPolicyTree.scrollPathToVisible(oTreePath);
                    DCFrameWorkUtil.updateUI(PolicyTreePanel.this.m_oPolicyTree);
                } else if (isThisClientRequest) {
                    PolicyTreePanel.this.m_oPolicyTree.setSelectionRow(1);
                    int childCount = PolicyTreePanel.this.m_oRoot.getChildCount();
                    DCDebugTracer.trace("childCount->" + childCount);
                    DefaultMutableTreeNode oTreeNode = null;
                    for (int i = 0; i < childCount; ++i) {
                        oTreeNode = (DefaultMutableTreeNode)PolicyTreePanel.this.m_oRoot.getChildAt(i);
                        PolicyTreeNodeInfo oPolicyNode = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
                        DCDebugTracer.trace("oPolicyNode.getPolicyID->" + oPolicyNode.getPolicyID());
                        DCDebugTracer.trace("getNodeName->" + oPolicyNode.getNodeName());
                        if (0 != oPolicyNode.getPolicyID()) continue;
                        PolicyEventObject eventObj = new PolicyEventObject(oPolicyNode);
                        PolicyTreePanel.this.notifyEvent(eventObj);
                    }
                    DCFrameWorkUtil.updateUI(PolicyTreePanel.this.m_oPolicyTree);
                } else {
                    TreePath oTreePath = new TreePath(((DefaultMutableTreeNode)PolicyTreePanel.this.m_oPolicyTree.getSelectionPath().getLastPathComponent()).getPath());
                    PolicyTreePanel.this.m_oPolicyTree.setSelectionPath(oTreePath);
                    PolicyTreePanel.this.m_oPolicyTree.expandPath(oTreePath);
                    PolicyTreePanel.this.m_oPolicyTree.scrollPathToVisible(oTreePath);
                    DCFrameWorkUtil.updateUI(PolicyTreePanel.this.m_oPolicyTree);
                }
                DCFrameWorkUtil.updateUI(PolicyTreePanel.this.m_oPolicyTree);
            }
        });
    }

    private DefaultMutableTreeNode getNodeForDelDevice(int iPolicyID, String submapID) {
        DefaultMutableTreeNode oDestNode = null;
        PolicyTreeNodeInfo oNodeInfo = null;
        Enumeration<TreeNode> oChidEnum = this.m_oRoot.breadthFirstEnumeration();
        Collator oCol = Collator.getInstance();
        while (oChidEnum.hasMoreElements()) {
            oDestNode = (DefaultMutableTreeNode)oChidEnum.nextElement();
            oNodeInfo = (PolicyTreeNodeInfo)oDestNode.getUserObject();
            if (null == oNodeInfo || oNodeInfo.getPolicyID() != iPolicyID || !oCol.equals(oNodeInfo.getSubmapID(), submapID)) continue;
            DefaultMutableTreeNode oDestNodeTmp = oDestNode;
            PolicyTreeNodeInfo oNodeInfoTmp = null;
            for (int i = 0; i < oDestNode.getChildCount(); ++i) {
                oNodeInfoTmp = (PolicyTreeNodeInfo)(oDestNodeTmp = oDestNodeTmp.getNextNode()).getUserObject();
                if (!oNodeInfoTmp.getSubmapID().equals(submapID)) continue;
                return oDestNodeTmp;
            }
            return oDestNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getNode(int iPolicyID, String submapID) {
        DefaultMutableTreeNode oDestNode = null;
        PolicyTreeNodeInfo oNodeInfo = null;
        Enumeration<TreeNode> oChidEnum = this.m_oRoot.breadthFirstEnumeration();
        Collator oCol = Collator.getInstance();
        while (oChidEnum.hasMoreElements()) {
            oDestNode = (DefaultMutableTreeNode)oChidEnum.nextElement();
            oNodeInfo = (PolicyTreeNodeInfo)oDestNode.getUserObject();
            if (null == oNodeInfo || oNodeInfo.getPolicyID() != iPolicyID || !oCol.equals(oNodeInfo.getSubmapID(), submapID)) continue;
            return oDestNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getPolicyNode(int iPolicyID) {
        DefaultMutableTreeNode oDestNode = null;
        PolicyTreeNodeInfo oNodeInfo = null;
        Enumeration<TreeNode> oChidEnum = this.m_oRoot.breadthFirstEnumeration();
        while (oChidEnum.hasMoreElements()) {
            oDestNode = (DefaultMutableTreeNode)oChidEnum.nextElement();
            oNodeInfo = (PolicyTreeNodeInfo)oDestNode.getUserObject();
            if (oNodeInfo.getPolicyID() != iPolicyID || oNodeInfo.getNodeType() != 0) continue;
            return oDestNode;
        }
        return null;
    }

    public THashMap<Integer, DevicePolicyState> getSelectedDeviceHm(int iPolicyID, String sSubmapID) {
        PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo(iPolicyID);
        THashMap<Integer, DevicePolicyState> oDevHm = oPolicy.getDevicePolicyStateHm(sSubmapID);
        return oDevHm;
    }

    public TIntArrayList getSelectedDevIDLst(int iPolicyID, String sSubmapID) {
        PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo(iPolicyID);
        THashMap<Integer, DevicePolicyState> oDevLst = oPolicy.getDevicePolicyStateHm(sSubmapID);
        if (null == oDevLst) {
            return null;
        }
        TIntArrayList oDevIDLst = new TIntArrayList();
        Set oDevSet = oDevLst.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            oDevIDLst.add(((Integer)element.getKey()).intValue());
        }
        return oDevIDLst;
    }

    private void deleteEmptySubnetFormPolicy(PolicyInfo oPolicyInfo) {
        DefaultMutableTreeNode oPolicyNode = this.getPolicyNode(oPolicyInfo.getPolicyID());
        if (null == oPolicyNode) {
            return;
        }
        Enumeration<TreeNode> oChidEnum = oPolicyNode.depthFirstEnumeration();
        DefaultMutableTreeNode oChildNode = null;
        PolicyTreeNodeInfo oChildNodeInfo = null;
        while (oChidEnum.hasMoreElements()) {
            oChildNode = (DefaultMutableTreeNode)oChidEnum.nextElement();
            oChildNodeInfo = (PolicyTreeNodeInfo)oChildNode.getUserObject();
            if (null == oChildNodeInfo || oChildNodeInfo.getNodeType() != 1 || !oPolicyInfo.getEmptySubnetVec().contains(oChildNodeInfo.getSubmapID())) continue;
            oChildNode.removeFromParent();
        }
        oPolicyInfo.getEmptySubnetVec().clear();
    }

    public void registerDCEventListener(PolicyTreeEventListener oEventListener) {
        if (null == this.m_oListenerLst) {
            this.m_oListenerLst = new ArrayList();
        }
        if (!this.m_oListenerLst.contains(oEventListener)) {
            this.m_oListenerLst.add(oEventListener);
        }
    }

    public void unRegisterDCEventListener(DCTreeEventListener oEventListener) {
        if (null != this.m_oListenerLst && this.m_oListenerLst.contains(oEventListener)) {
            this.m_oListenerLst.remove(oEventListener);
        }
    }

    public void disposePanel() {
        PolicyManager.getInstance().unRegisterPolicyChangeListener(this);
        if (null != this.m_oPolicyLst) {
            this.m_oPolicyLst.clear();
            this.m_oPolicyLst = null;
        }
        if (null != this.m_oPopupManager) {
            this.m_oPopupManager.clearUpObject();
            this.m_oPopupManager = null;
        }
        if (null != this.m_oPolicyTreeMenuItemHandler) {
            this.m_oPolicyTreeMenuItemHandler.clearUpObject();
            this.m_oPolicyTreeMenuItemHandler = null;
        }
        if (null != this.m_oScrollPane) {
            this.m_oScrollPane.removeAll();
            this.m_oScrollPane = null;
        }
        if (null != this.m_oPolicyTree) {
            this.clearRoot();
            this.m_oPolicyTree.removeAll();
            this.m_oPolicyTree = null;
        }
        this.m_oPolicyTreeModel = null;
        this.m_oPolicyTreePopupMenu = null;
        if (null != this.m_oListenerLst) {
            this.m_oListenerLst.clear();
            this.m_oListenerLst = null;
        }
    }

    private void clearRoot() {
        if (null == this.m_oRoot) {
            return;
        }
        TreeNode obj = null;
        Object oNodeObj = null;
        PolicyTreeNodeInfo oPolicyTreeNode = null;
        Enumeration<TreeNode> oEnum = this.m_oRoot.depthFirstEnumeration();
        while (oEnum.hasMoreElements()) {
            obj = oEnum.nextElement();
            if (!(obj instanceof DefaultMutableTreeNode) || !((oNodeObj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof PolicyTreeNodeInfo)) continue;
            oPolicyTreeNode = (PolicyTreeNodeInfo)oNodeObj;
            oPolicyTreeNode.setToNull();
            oPolicyTreeNode = null;
        }
        obj = null;
        oNodeObj = null;
    }

    private class PolicyTreeCellRender
    extends DCDefaultTreeCellRenderer {
        private PolicyTreeCellRender() {
        }

        @Override
        protected JLabel createLabelWithIcon(Object oUserObject, boolean bIsLeaf, boolean anIsExpanded) {
            if (!(oUserObject instanceof PolicyTreeNodeInfo)) {
                return super.createLabelWithIcon(oUserObject, bIsLeaf, anIsExpanded);
            }
            PolicyTreeNodeInfo oPolicyTreeNodeInfo = (PolicyTreeNodeInfo)oUserObject;
            JLabel oLabel = new JLabel();
            ImageIcon oCheckBoxIcon = null;
            oCheckBoxIcon = oPolicyTreeNodeInfo.getNodeType() == -1 ? ResourceManager.getInstance().getImage("rooticon.gif") : (oPolicyTreeNodeInfo.getNodeType() == 0 ? ResourceManager.getInstance().getImage("policyNode.gif") : ResourceManager.getInstance().getImage("folderopen.gif"));
            oLabel.setIcon(oCheckBoxIcon);
            return oLabel;
        }
    }
}

