/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.model.PolicyInfo;

public class PolicyTreeNodeInfo {
    private int iNodeType = -1;
    public static final int NODE_TYPE_ROOT = -1;
    public static final int NODE_TYPE_POLICY = 0;
    public static final int NODE_TYPE_SUBMAP = 1;
    private String sNodeName = "";
    private PolicyInfo oPolicyInfo = null;
    private SubMapInfo oSubMapInfo = null;
    private int iPolicyID = -1;

    public PolicyTreeNodeInfo(String sNodeName) {
        this.iNodeType = -1;
        this.sNodeName = sNodeName;
    }

    public PolicyTreeNodeInfo(PolicyInfo oPolicyInfo) {
        this.iNodeType = 0;
        this.oPolicyInfo = oPolicyInfo;
        this.sNodeName = oPolicyInfo.getPolicyName();
    }

    public PolicyTreeNodeInfo(int iPolicyID, SubMapInfo oSubMapInfo) {
        this.iNodeType = 1;
        this.oSubMapInfo = oSubMapInfo;
        this.iPolicyID = iPolicyID;
        this.sNodeName = oSubMapInfo.m_strSubMapName;
    }

    public int getNodeType() {
        return this.iNodeType;
    }

    public void setNodeType(int iNodeType) {
        this.iNodeType = iNodeType;
    }

    public String getNodeName() {
        return this.sNodeName;
    }

    public void setNodeName(String sNodeName) {
        this.sNodeName = sNodeName;
    }

    public PolicyInfo getPolicyInfo() {
        return this.oPolicyInfo;
    }

    public SubMapInfo getSubMapInfo() {
        return this.oSubMapInfo;
    }

    public int getPolicyID() {
        switch (this.iNodeType) {
            case -1: {
                return -1;
            }
            case 0: {
                if (null != this.oPolicyInfo) {
                    return this.oPolicyInfo.getPolicyID();
                }
                DCDebugTracer.traceError(this.toString());
                DCDebugTracer.traceStack();
                break;
            }
            case 1: {
                return this.iPolicyID;
            }
            default: {
                DCDebugTracer.trace("Error node type : -1");
            }
        }
        return this.iPolicyID;
    }

    public String getSubmapID() {
        if (null == this.oSubMapInfo) {
            return "";
        }
        return this.oSubMapInfo.m_strSubMapID;
    }

    public String toString() {
        return this.sNodeName;
    }

    public void setToNull() {
        this.oPolicyInfo = null;
        this.oSubMapInfo = null;
    }
}

