/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.deviceinfo.VisualData;
import com.huawei.dc.policy.controller.BooleanColumnRederer;
import com.huawei.dc.policy.controller.IPolicyChangeListener;
import com.huawei.dc.policy.controller.PolicyEventObject;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyTableMenuItemHandler;
import com.huawei.dc.policy.controller.PolicyTablePopupManager;
import com.huawei.dc.policy.controller.PolicyTreeEventListener;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.LinkColumnRender;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.PolicyTreeNodeInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PolicyTablePanel
extends JPanel
implements PolicyTreeEventListener,
IPolicyChangeListener {
    private static final long serialVersionUID = -4860396331072181196L;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private List<PolicyInfo> m_oPolicyLst = null;
    private JPanel m_oNETyePanel = null;
    private JLabel m_oNETypeLbl = null;
    private ComboBoxWithToolTip m_oNETypeCombox = null;
    private DCExtendedTable m_oPolicyTable = null;
    private DCSortableTableModel m_oPolicyTableModel = null;
    private JScrollPane m_oPolicyInfoScrollPane = null;
    private JLabel m_oSelectCountLabel = null;
    private String m_oSelectCountTxt = null;
    private JButton m_oCreateBtn = null;
    private JButton m_oMoveToBtn = null;
    private JButton m_oSaveBtn = null;
    private DefaultComboBoxModel m_oNETypeModel;
    private PolicyTableMenuItemHandler m_oPolicyTableMenuItemHandler = null;
    private PolicyTablePopupManager m_oPopupManager = null;
    private JPopupMenu m_oPolicyTablePopupMenu;
    private int m_iSelectTreeNodeType = 0;
    private int m_iCurrentPolicyID = 0;
    private String m_sCurrentSubmapID = "";
    private transient ItemListener m_ONETypeCombxoListener = null;
    private String m_oSelectedNEType = "";
    private TIntArrayList m_oSelectDevIDLst = null;
    private List<Integer> moveDeviceIDList = new ArrayList<Integer>();
    private boolean m_hasPolicyMgrPrivilege = true;
    private final String MANUAL_DELETE_BACKUP_FILE = ResourceManager.getInstance().getResString("POOICY_MAX_COPIES_NUM_NO_LIMIT");
    private static final int POLICY_ID_COL = 0;
    private static final int RESOURCE_NAME_COL = 1;
    private String strdate = "";
    private final String STRING_FALSE = ResourceManager.getInstance().getResString("FALSE");
    private final String STRING_TRUE = ResourceManager.getInstance().getResString("TRUE");

    public PolicyTablePanel(List<PolicyInfo> oPolicyLst) {
        this.m_oPolicyLst = oPolicyLst;
        this.initGUI();
        this.initPopupMenuManager();
        this.addActionListener();
    }

    public void initData(List<PolicyInfo> oPolicyInfoLst) {
        this.m_oPolicyLst = oPolicyInfoLst;
        this.initData(this.getPolicy(this.m_oPolicyLst, 0), "", "");
    }

    private synchronized void initData(PolicyInfo oPolicyInfo, String sDevTypeName, String sSubmapID) {
        this.m_oPolicyTableModel.getDataVector().clear();
        ArrayList<PolicyInfo> oPolicyLst = new ArrayList<PolicyInfo>();
        oPolicyLst.add(oPolicyInfo);
        List<String> oNETypeLst = this.generateNETypeLst(oPolicyLst);
        this.initDevTypeCombox(oNETypeLst, sDevTypeName);
        this.initTableData(oPolicyInfo, this.m_oSelectedNEType, sSubmapID);
        this.updateGUI();
    }

    private void initTableData(PolicyInfo oPolicyInfo, String sDevTypeName, String sSubmapID) {
        if (null == oPolicyInfo) {
            return;
        }
        THashMap<Integer, DevicePolicyState> oDevPolicyStateHm = null;
        HashSet<Integer> iDevIdLst = new HashSet<Integer>();
        String sRunState = ResourceManager.getInstance().getResString("POLICY_STATUS_RUN");
        String sStopState = ResourceManager.getInstance().getResString("POLICY_STATUS_STOP");
        String sNEName = "";
        String sNEIP = "";
        String sNEType = "";
        String sSavePeriod = "";
        int iSaveStatus = -1;
        String sBackupPeriod = "";
        int iBackupStatus = -1;
        String sBackupType = "--";
        String sDestination = "";
        Object oSaveBeforeBackup = false;
        boolean bConfigChange = false;
        oDevPolicyStateHm = oPolicyInfo.getDevicePolicyStateHm(sSubmapID);
        if (null == oDevPolicyStateHm || oDevPolicyStateHm.size() == 0) {
            return;
        }
        int iPolicyID = oPolicyInfo.getPolicyID();
        sSavePeriod = oPolicyInfo.getPolicyPeriodInfo(1);
        sBackupPeriod = oPolicyInfo.getPolicyPeriodInfo(0);
        int iDevTypeID = 0;
        int iDevId = 0;
        PolicyDevTypeProperties oDevPro = null;
        DevicePolicyState oDevPolicyState = null;
        Vector oDataVct = new Vector();
        Vector<Object> oRowVct = null;
        THashMap<Integer, DevicePolicyState> tmp = oDevPolicyStateHm;
        Set oDevSet = tmp.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        while (oDevItor.hasNext()) {
            String sMaxBackupNumber = this.MANUAL_DELETE_BACKUP_FILE;
            element = (Map.Entry)oDevItor.next();
            oDevPolicyState = (DevicePolicyState)element.getValue();
            iSaveStatus = oDevPolicyState.getSavePolicyState();
            iBackupStatus = oDevPolicyState.getBakcupPolicyState();
            sNEName = oDevPolicyState.getNEName();
            sNEIP = oDevPolicyState.getIPAdress();
            sNEType = oDevPolicyState.getNETypeName();
            if (!"".equals(sDevTypeName) && !sNEType.equals(sDevTypeName)) continue;
            oRowVct = new Vector<Object>();
            iDevTypeID = oDevPolicyState.getDevTypeID();
            iDevId = oDevPolicyState.getDevID();
            oDevPro = oPolicyInfo.getDevPropreties(iDevTypeID);
            DCDebugTracer.trace("PolicyTablePanel#initTableData:iDevId = " + iDevId + " and iDevTypeID = " + iDevTypeID);
            if (null == oDevPro) {
                DCDebugTracer.trace("PolicyTablePanel#initTableData:oDevPro is null! ");
                continue;
            }
            sMaxBackupNumber = null != oDevPro && oDevPro.getNumOfBackupCopies() != 0 ? String.valueOf(oDevPro.getNumOfBackupCopies()) : this.m_oRes.getResString("POOICY_MAX_COPIES_NUM_NO_LIMIT");
            List<ConfigChangePolicyInfo> oSpecLst = null;
            if (null != oDevPro) {
                sBackupType = oDevPro.getBackupContentTypeName();
                oSaveBeforeBackup = oDevPro.isSaveBeforeBackup();
                oSpecLst = oDevPro.getSpecialPolicyLst();
                sDestination = oDevPro.getStrDestination();
            }
            boolean bSupportConfigChange = false;
            if (null != oSpecLst) {
                for (ConfigChangePolicyInfo oSpecInfo : oSpecLst) {
                    if (null == oSpecInfo || oSpecInfo.getSpecificPolicyType() != 1) continue;
                    bSupportConfigChange = true;
                    if (oSpecInfo.getBackupPolicyStatus() == 0) {
                        bConfigChange = true;
                        break;
                    }
                    if (oSpecInfo.getBackupPolicyStatus() == 1) {
                        bConfigChange = false;
                        break;
                    }
                    DCDebugTracer.trace("PolicyTablePanel#initTableData");
                    break;
                }
            }
            oRowVct.add(iPolicyID);
            oRowVct.add(sNEName);
            oRowVct.add(PolicyTablePanel.getShowIP(sNEIP));
            oRowVct.add(sNEType);
            iDevIdLst.add(iDevId);
            if (null == oSaveBeforeBackup) {
                oRowVct.add("--");
                oRowVct.add("--");
            } else {
                oRowVct.add(sSavePeriod);
                if (iSaveStatus == 0) {
                    oRowVct.add(sRunState);
                } else if (iSaveStatus == 1) {
                    oRowVct.add(sStopState);
                } else {
                    oRowVct.add("--");
                }
            }
            oRowVct.add(sBackupPeriod);
            if (iBackupStatus == 0) {
                oRowVct.add(sRunState);
            } else if (iBackupStatus == 1) {
                oRowVct.add(sStopState);
            } else {
                oRowVct.add("--");
            }
            oRowVct.add(sBackupType);
            oRowVct.add(sDestination);
            oRowVct.add(sMaxBackupNumber);
            this.initSaveBeforeBackup(oSaveBeforeBackup, oRowVct);
            if (bSupportConfigChange) {
                oRowVct.add(bConfigChange);
            } else {
                oRowVct.add("--");
            }
            oRowVct.add(oDevPolicyState);
            oDataVct.add(oRowVct);
        }
        this.refreshData(iDevIdLst, oDataVct);
    }

    private void initSaveBeforeBackup(Object oSaveBeforeBackup, Vector oRowVct) {
        if (null == oSaveBeforeBackup) {
            oRowVct.add("--");
        } else {
            boolean bValue = (Boolean)oSaveBeforeBackup;
            if (bValue) {
                oRowVct.add(this.STRING_TRUE);
            } else {
                oRowVct.add(this.STRING_FALSE);
            }
        }
    }

    private void refreshData(HashSet<Integer> iDevIdLst, Vector oDataVct) {
        PolicyUtil.setSelDevLst(iDevIdLst);
        if (!oDataVct.isEmpty()) {
            try {
                this.m_oPolicyTableModel.addRows(oDataVct);
            }
            catch (Exception ex) {
                DCDebugTracer.trace("ignore it." + ex);
            }
        }
        this.refreshSelecDevice();
        if (this.m_hasPolicyMgrPrivilege) {
            this.refreshBtnStatus(this.m_oPolicyTable.getRowCount() > 0);
        }
    }

    private PolicyInfo getPolicy(List<PolicyInfo> oPolicyInfoLst, int iPolicyID) {
        if (null == oPolicyInfoLst || oPolicyInfoLst.isEmpty()) {
            return null;
        }
        PolicyInfo oPolicy = null;
        for (int i = 0; i < oPolicyInfoLst.size(); ++i) {
            oPolicy = oPolicyInfoLst.get(i);
            if (null == oPolicy || oPolicy.getPolicyID() != iPolicyID) continue;
            return oPolicy;
        }
        return null;
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponents();
        this.addComponent();
    }

    private void initComponent() {
        this.m_oNETypeLbl = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_DEVICETYPE_LBL"));
        this.m_oNETypeModel = new DefaultComboBoxModel();
        this.m_oNETypeCombox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oNETypeModel);
        this.m_oNETypeCombox.setName("PolicyTablePanel_m_oNETypeCombox");
        this.m_oNETyePanel = new JPanel();
        this.m_oNETyePanel.setLayout(new GridBagLayout());
        this.m_oNETyePanel.setName("PolicyTablePanel_m_oNETypePanel");
        this.m_oNETyePanel.add((Component)this.m_oNETypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.m_oNETyePanel.add((Component)this.m_oNETypeCombox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oNETyePanel.setSize(300, 20);
        this.m_oPolicyTableModel = new DCSortableTableModel(this.getColumn(), 0){
            private static final long serialVersionUID = 6157199232774907727L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oPolicyTable = new DCExtendedTable((SortableTableModel)this.m_oPolicyTableModel);
        this.m_oPolicyTable.setColumnSortable(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, true);
        this.m_oPolicyTable.setSortableClickCount(1);
        JTableHeader header = this.m_oPolicyTable.getTableHeader();
        header.setReorderingAllowed(false);
        this.m_oPolicyTable.setScrolls(false);
        this.m_oPolicyTable.setUpDateSelectedRow(true);
        this.m_oPolicyTable.setInvalidedForeground(Color.BLACK);
        this.m_oPolicyTable.setColAutoResizeMode(2);
        this.m_oPolicyTable.getColumnModel().getColumn(11).setCellRenderer(new BooleanColumnRederer(false));
        this.m_oPolicyTable.getColumnModel().getColumn(12).setCellRenderer(new BooleanColumnRederer(false));
        this.m_oPolicyTable.getColumnModel().getColumn(13).setCellRenderer(new LinkColumnRender());
        this.m_oPolicyTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.m_oPolicyTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.m_oPolicyTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.m_oPolicyInfoScrollPane = new JScrollPane((Component)this.m_oPolicyTable);
        this.m_oPolicyInfoScrollPane.setName("PolicyTablePanel_m_oPolicyInfoScrollPane");
        this.m_oPolicyInfoScrollPane.setVerticalScrollBarPolicy(20);
        this.m_oPolicyInfoScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oSelectCountLabel = new JLabel();
        this.m_oSelectCountTxt = this.m_oRes.getResString("LBL_SELECT_POLICY_COUNT");
        String sInitCount = MessageFormat.format(this.m_oSelectCountTxt, "0", "0", "0", "0");
        this.m_oSelectCountLabel.setText(sInitCount);
        this.m_oCreateBtn = new JButton();
        this.m_oCreateBtn.setText(this.m_oRes.getResString("POLICY_TREE_POPUP_MENU_ITEM_NEW_POLICY"));
        this.m_oCreateBtn.setToolTipText(this.m_oRes.getResString("POLICY_CREATE_BTN_TOOLTIP"));
        this.m_oCreateBtn.setMnemonic('N');
        this.m_oCreateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicyTablePanel.this.m_oPolicyTableMenuItemHandler.newPolicy();
            }
        });
        this.m_oMoveToBtn = new JButton();
        this.m_oMoveToBtn.setText(this.m_oRes.getResString("POLICY_MOVE_BTN"));
        this.m_oMoveToBtn.setToolTipText(this.m_oRes.getResString("POLICY_MOVE_BTN_TOOLTIP"));
        this.m_oMoveToBtn.setMnemonic('T');
        this.m_oMoveToBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicyTablePanel.this.m_oPolicyTableMenuItemHandler.movePolicy();
            }
        });
        this.m_oSaveBtn = new JButton();
        this.m_oSaveBtn.setText(this.m_oRes.getResString("EXPORT_LIST_BTN"));
        this.m_oSaveBtn.setToolTipText(this.m_oRes.getResString("EXPORT_LIST_BTN_TOOLTIP"));
        this.m_oSaveBtn.setMnemonic('L');
        this.m_oSaveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PolicyTablePanel.this.m_oPolicyTableMenuItemHandler.saveAsPolicy();
            }
        });
        this.customerColumn();
        this.checkButtonPrivilege();
        TableCustomizer oTableCustomizer = new TableCustomizer((JTable)this.m_oPolicyTable, "conf/dc/policy_table.xml");
        TableColumn[] oTableColumns = new TableColumn[]{this.m_oPolicyTable.getColumnModel().getColumn(0), this.m_oPolicyTable.getColumnModel().getColumn(1)};
        oTableCustomizer.setNotAllowCustomizedColumns(Arrays.asList(oTableColumns));
        oTableCustomizer.setColumnNotVisibleInMenuAndSettingDlg(oTableColumns[0]);
    }

    private void customerColumn() {
        boolean bTtrans;
        int iServerDeployDomian = DCFrameWorkUtil.getServerDeployDomain();
        boolean bAccess = (iServerDeployDomian & 1) != 0;
        boolean bRoute = (iServerDeployDomian & 2) != 0;
        boolean bl = bTtrans = (iServerDeployDomian & 4) != 0;
        if (!bRoute) {
            this.setColumnDefultWidth(13);
            if (!bTtrans) {
                this.setColumnDefultWidth(12);
            }
            if (!bAccess) {
                this.setColumnDefultWidth(11);
                this.setColumnDefultWidth(5);
                this.setColumnDefultWidth(4);
            }
        }
    }

    private void setColumnDefultWidth(int iColID) {
        this.m_oPolicyTable.getColumnModel().getColumn(iColID).setPreferredWidth(0);
        this.m_oPolicyTable.getColumnModel().getColumn(iColID).setMinWidth(0);
        this.m_oPolicyTable.getColumnModel().getColumn(iColID).setMaxWidth(0);
    }

    private void checkButtonPrivilege() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_hasPolicyMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43976);
        this.m_oCreateBtn.setEnabled(this.m_hasPolicyMgrPrivilege);
        this.m_oMoveToBtn.setEnabled(this.m_hasPolicyMgrPrivilege);
        this.m_oSaveBtn.setEnabled(this.m_hasPolicyMgrPrivilege);
    }

    private void initPopupMenuManager() {
        this.m_oPolicyTableMenuItemHandler = new PolicyTableMenuItemHandler(this);
        this.m_oPopupManager = new PolicyTablePopupManager(this.m_oPolicyTableMenuItemHandler);
    }

    private String[] getColumn() {
        String[] sColunms = new String[]{this.m_oRes.getResString("POLICY_ID"), this.m_oRes.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), this.m_oRes.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"), this.m_oRes.getResString("DEVICE_TABLE_HEADER_RESOURCE_TYPE"), this.m_oRes.getResString("POLICY_INFO_SAVE_PERIOD"), this.m_oRes.getResString("SAVEINFOPAN_TABLE_SAVE_STATUS"), this.m_oRes.getResString("POLICY_INFO_BACKUP_PERIOD"), this.m_oRes.getResString("POLICYINFOPAN_TABLE_BACKUP_POLICY_STATUS"), this.m_oRes.getResString("POLICY_BACKUP_TYPE"), this.m_oRes.getResString("PATHHEADER"), this.m_oRes.getResString("POLICY_BACKUP_MAX_NUM"), this.m_oRes.getResString("SAVE_BEFORE_BACKUP"), this.m_oRes.getResString("POLICY_CONFIG_CHANGE_BAKCUP"), this.m_oRes.getResString("POLICY_TIMER_BAKCUP")};
        return sColunms;
    }

    private void alignComponents() {
        this.setLayout(new GridBagLayout());
        this.m_oNETypeLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oNETypeLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oNETypeCombox.setPreferredSize(new Dimension(150, 20));
        this.m_oNETypeCombox.setMinimumSize(new Dimension(100, 20));
        this.m_oCreateBtn.setPreferredSize(new Dimension(150, 21));
        this.m_oCreateBtn.setMinimumSize(new Dimension(150, 21));
        this.m_oMoveToBtn.setPreferredSize(new Dimension(160, 21));
        this.m_oMoveToBtn.setMinimumSize(new Dimension(160, 21));
        this.m_oSaveBtn.setPreferredSize(new Dimension(150, 21));
        this.m_oSaveBtn.setMinimumSize(new Dimension(150, 21));
    }

    private void addComponent() {
        this.add((Component)this.m_oNETyePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.m_oPolicyInfoScrollPane, new GridBagConstraints(0, 1, 5, 4, 1.0, 1.0, 11, 1, new Insets(12, 2, 0, 0), 0, 0));
        this.add((Component)this.m_oSelectCountLabel, new GridBagConstraints(0, 7, 1, 4, 1.0, 0.0, 17, 1, new Insets(12, 12, 12, 0), 0, 0));
        this.add((Component)this.m_oCreateBtn, new GridBagConstraints(1, 7, 1, 4, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.add((Component)this.m_oMoveToBtn, new GridBagConstraints(2, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 0), 0, 0));
        this.add((Component)this.m_oSaveBtn, new GridBagConstraints(3, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 12), 0, 0));
    }

    private void addActionListener() {
        this.m_oPolicyTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oPolicyTable.getSelectionModel().addListSelectionListener(new TableSelectionListener(this));
        this.m_oPolicyTable.addMouseListener((MouseListener)new OperationTableMouseListener());
        this.m_oPolicyTable.addMouseMotionListener((MouseMotionListener)new OperationTableMouseMotionListener());
        this.m_ONETypeCombxoListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object oSelectObj = ((ComboBoxWithToolTip)e.getSource()).getSelectedItem();
                if (null != oSelectObj) {
                    PolicyTablePanel.this.handleNETypeChange(oSelectObj.toString());
                }
            }
        };
        this.m_oNETypeCombox.addItemListener(this.m_ONETypeCombxoListener);
        PolicyManager.getInstance().registerPolicyChangeListener(this);
    }

    private MouseListener generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                PolicyTablePanel.this.policyTableMousePressed(oMouseEvent);
            }
        };
    }

    protected void policyTableMousePressed(MouseEvent oMouseEvent) {
        if (oMouseEvent.getClickCount() == 2 && 0 != (0x10 & oMouseEvent.getModifiers())) {
            int iClickedRow = this.m_oPolicyTable.rowAtPoint(oMouseEvent.getPoint());
            PolicyUtil.viewDetailsPolicy(iClickedRow, this.m_oPolicyTable);
            return;
        }
        if (!oMouseEvent.isPopupTrigger() && 0 != (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        int iClickedRow = this.m_oPolicyTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oPolicyTable.getSelectedRows();
        if (nRows.length > 1) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected) {
            ListSelectionModel selectionModel = this.m_oPolicyTable.getSelectionModel();
            selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        this.m_oPolicyTablePopupMenu = this.m_oPopupManager.loadMenu();
        this.m_oPolicyTablePopupMenu.setName("Policy_PolicytablePanel_m_oPolicyTablePopupMenu");
        this.m_oPolicyTablePopupMenu.show((Component)this.m_oPolicyTable, oMouseEvent.getX(), oMouseEvent.getY());
    }

    private void initDevTypeCombox(List<String> oNETypeLst, String sSeleNETypeName) {
        if (null == this.m_oNETypeCombox) {
            return;
        }
        this.m_oNETypeCombox.setEnabled(true);
        this.m_oNETypeCombox.removeAllItems();
        if (null == oNETypeLst || oNETypeLst.isEmpty()) {
            this.m_oNETypeCombox.setEnabled(false);
            return;
        }
        this.m_oNETypeCombox.setEnabled(true);
        this.m_oNETypeCombox.addItem(DCConstants.ALL_TYPE);
        Collections.sort(oNETypeLst);
        for (String sNEType : oNETypeLst) {
            this.m_oNETypeCombox.addItem(sNEType);
        }
        if (oNETypeLst.contains(sSeleNETypeName)) {
            this.m_oNETypeCombox.setSelectedItem(sSeleNETypeName);
            this.m_oSelectedNEType = sSeleNETypeName;
        } else {
            this.m_oNETypeCombox.setSelectedIndex(0);
            this.m_oSelectedNEType = "";
        }
    }

    private void refreshSelectedDevCountLabel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iSelectCount = PolicyTablePanel.this.m_oPolicyTable.getSelectedRowCount();
                int iTotolCount = PolicyTablePanel.this.m_oPolicyTable.getRowCount();
                if (iTotolCount == 0) {
                    iSelectCount = 0;
                }
                int iSelectCurRow = 0;
                int[] arrSelectedRows = PolicyTablePanel.this.m_oPolicyTable.getSelectedRows();
                if (iSelectCount > 0) {
                    iSelectCurRow = arrSelectedRows[0] + 1;
                }
                String strDeviceCountMsg = MessageFormat.format(PolicyTablePanel.this.m_oSelectCountTxt, "" + iSelectCurRow, "" + iTotolCount, "" + iSelectCount, "" + PolicyTablePanel.this.strdate);
                PolicyTablePanel.this.m_oSelectCountLabel.setText(StringUtils.getHtmlString(strDeviceCountMsg));
            }
        });
    }

    private void refreshSelecDevice() {
        if (null == this.m_oSelectDevIDLst || this.m_oSelectDevIDLst.size() == 0) {
            if (this.m_oPolicyTable.getRowCount() > 0) {
                this.m_oPolicyTable.setRowSelectionInterval(0, 0);
                DevicePolicyState oDevicePolicyState = (DevicePolicyState)((Vector)this.m_oPolicyTableModel.getDataVector().get(0)).get(13);
                int iDevID = oDevicePolicyState.getDevID();
                this.m_oSelectDevIDLst = new TIntArrayList();
                this.m_oSelectDevIDLst.add(iDevID);
            }
        } else {
            for (int i = this.m_oSelectDevIDLst.size() - 1; i >= 0; --i) {
                int iDevID = this.m_oSelectDevIDLst.get(i);
                boolean bSetResult = this.setDevSelected(iDevID);
                if (bSetResult) continue;
                this.m_oSelectDevIDLst.remove(i);
            }
            int iSelectRowCount = this.m_oPolicyTable.getSelectedRowCount();
            if (iSelectRowCount < 1 && this.m_oPolicyTable.getRowCount() > 0) {
                this.m_oPolicyTable.setRowSelectionInterval(0, 0);
                DevicePolicyState oDevicePolicyState = (DevicePolicyState)this.m_oPolicyTable.getValueAt(0, 13);
                int iDevID = oDevicePolicyState.getDevID();
                this.m_oSelectDevIDLst = new TIntArrayList();
                this.m_oSelectDevIDLst.add(iDevID);
            }
        }
        this.setMoveDeviceSelected();
    }

    private boolean setDevSelected(int iDevID) {
        int iRowCount = this.m_oPolicyTable.getRowCount();
        if (iRowCount < 1) {
            return false;
        }
        DevicePolicyState oDevicePolicyState = null;
        int iDestDevID = 0;
        for (int i = 0; i < iRowCount; ++i) {
            oDevicePolicyState = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(i, 13);
            iDestDevID = oDevicePolicyState.getDevID();
            if (iDevID != iDestDevID) continue;
            if (!this.m_oSelectDevIDLst.contains(iDevID)) {
                this.m_oSelectDevIDLst.add(iDevID);
            }
            this.m_oPolicyTable.addRowSelectionInterval(i, i);
            return true;
        }
        return false;
    }

    @Override
    public void onTreeNodeSelection(PolicyEventObject oEventObject) {
        int iNodeType;
        this.m_oNETypeCombox.removeItemListener(this.m_ONETypeCombxoListener);
        PolicyTreeNodeInfo oPolicyNode = (PolicyTreeNodeInfo)oEventObject.getSource();
        this.m_iSelectTreeNodeType = iNodeType = oPolicyNode.getNodeType();
        switch (iNodeType) {
            case -1: {
                this.handleRootNodeSelection(this.m_oSelectedNEType);
                break;
            }
            case 0: 
            case 1: {
                int iPolicyID = oPolicyNode.getPolicyID();
                String sSubmapID = oPolicyNode.getSubmapID();
                this.handlePolicyNodeSelection(iPolicyID, sSubmapID);
                break;
            }
        }
        this.m_oNETypeCombox.addItemListener(this.m_ONETypeCombxoListener);
    }

    private void handlePolicyNodeSelection(int iPolcyNode, String sSubmapID) {
        this.m_iCurrentPolicyID = iPolcyNode;
        this.m_sCurrentSubmapID = sSubmapID;
        PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo(iPolcyNode);
        this.initData(oPolicy, this.m_oSelectedNEType, sSubmapID);
    }

    private void handleRootNodeSelection(String sNETypeName) {
        this.m_sCurrentSubmapID = "";
        this.m_oPolicyTableModel.getDataVector().clear();
        List<PolicyInfo> oPolicyInfoLst = PolicyManager.getInstance().getPolicyInfoLst();
        List<String> oNETypeLst = this.generateNETypeLst(oPolicyInfoLst);
        this.initDevTypeCombox(oNETypeLst, sNETypeName);
        for (PolicyInfo oPolicyInfo : oPolicyInfoLst) {
            this.initTableData(oPolicyInfo, this.m_oSelectedNEType, this.m_sCurrentSubmapID);
        }
        this.setAllDevIDList();
        this.updateGUI();
    }

    private List<String> generateNETypeLst(List<PolicyInfo> oPolicyInfoLst) {
        ArrayList<String> oNETypeLst = new ArrayList<String>();
        if (null == oPolicyInfoLst || oPolicyInfoLst.isEmpty()) {
            return oNETypeLst;
        }
        for (PolicyInfo oPolicy : oPolicyInfoLst) {
            THashMap<Integer, DevicePolicyState> oDevHm;
            if (null == oPolicy || null == (oDevHm = oPolicy.getDevicePolicyStateHm()) || oDevHm.size() == 0) continue;
            THashMap<Integer, DevicePolicyState> tmp = oDevHm;
            Set oDevSet = tmp.entrySet();
            Iterator oDevItor = oDevSet.iterator();
            Map.Entry element = null;
            String sDevTypeName = "";
            while (oDevItor.hasNext()) {
                element = (Map.Entry)oDevItor.next();
                sDevTypeName = ((DevicePolicyState)element.getValue()).getNETypeName();
                if (oNETypeLst.contains(sDevTypeName)) continue;
                oNETypeLst.add(sDevTypeName);
            }
        }
        return oNETypeLst;
    }

    private void handleNETypeChange(String sNETypeName) {
        String sDestNeTypeName = sNETypeName;
        boolean bSelectAllType = Collator.getInstance().equals(sDestNeTypeName, DCConstants.ALL_TYPE);
        if (bSelectAllType) {
            sDestNeTypeName = "";
        }
        this.m_oSelectedNEType = sDestNeTypeName;
        this.m_oPolicyTableModel.getDataVector().clear();
        DCDebugTracer.trace("[POLICY] handleNETypeChange " + this.m_iSelectTreeNodeType + " " + sNETypeName + " " + this.m_iCurrentPolicyID + " " + this.m_sCurrentSubmapID);
        switch (this.m_iSelectTreeNodeType) {
            case -1: {
                List<PolicyInfo> oPolicyInfoLst = PolicyManager.getInstance().getPolicyInfoLst();
                for (PolicyInfo oPolicyInfo : oPolicyInfoLst) {
                    this.initTableData(oPolicyInfo, sDestNeTypeName, this.m_sCurrentSubmapID);
                }
                this.updateGUI();
                break;
            }
            case 0: 
            case 1: {
                PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo(this.m_iCurrentPolicyID);
                this.initTableData(oPolicy, sDestNeTypeName, this.m_sCurrentSubmapID);
                this.updateGUI();
                break;
            }
        }
    }

    private void updateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyTablePanel.this.m_oPolicyTable.updateUI();
                PolicyTablePanel.this.m_oPolicyInfoScrollPane.updateUI();
                PolicyTablePanel.this.setRefreshDateTime();
            }
        });
    }

    public DCExtendedTable getPolicyTable() {
        return this.m_oPolicyTable;
    }

    public THashMap<Integer, DevicePolicyState> getSelectedDeviceHm() {
        THashMap oDevHm = new THashMap();
        int[] arrRows = this.m_oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        DevicePolicyState oDev = null;
        for (int index = 0; index < iLength; ++index) {
            oDev = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(arrRows[index], 13);
            oDevHm.put((Object)oDev.getDevID(), (Object)oDev);
        }
        return oDevHm;
    }

    public THashMap<Integer, DevicePolicyState> getCurTableDeviceHm() {
        THashMap oDevHm = new THashMap();
        int iLength = this.m_oPolicyTable.getActualRowCount();
        DevicePolicyState oDev = null;
        for (int index = 0; index < iLength; ++index) {
            oDev = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(index, 13);
            oDevHm.put((Object)oDev.getDevID(), (Object)oDev);
        }
        return oDevHm;
    }

    public THashSet<Resource> getSelectedDeviceHs() {
        int iRowCOunt = this.m_oPolicyTable.getRowCount();
        if (iRowCOunt == 0) {
            return null;
        }
        THashSet oResHs = new THashSet();
        int[] arrRows = this.m_oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        Resource oResource = null;
        int iDevID = 0;
        DevicePolicyState oDevicePolicyState = null;
        for (int index = 0; index < iLength; ++index) {
            oDevicePolicyState = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(arrRows[index], 13);
            iDevID = oDevicePolicyState.getDevID();
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iDevID);
            if (null == oResource) continue;
            oResHs.add((Object)oResource);
        }
        return oResHs;
    }

    public TIntArrayList getSelectedDevIDLst() {
        int iRowCount = this.m_oPolicyTable.getRowCount();
        if (iRowCount < 1) {
            return null;
        }
        TIntArrayList oDevIDLst = new TIntArrayList();
        int[] arrRows = this.m_oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        DevicePolicyState oDev = null;
        int iDevID = 0;
        Object obj = null;
        for (int index = 0; index < iLength; ++index) {
            obj = this.m_oPolicyTableModel.getValueAt(arrRows[index], 13);
            if (!(obj instanceof DevicePolicyState)) continue;
            oDev = (DevicePolicyState)obj;
            iDevID = oDev.getDevID();
            oDevIDLst.add(iDevID);
        }
        return oDevIDLst;
    }

    public List<Resource> getSelectedResources() {
        ArrayList<Resource> oResourcelist = new ArrayList<Resource>(0);
        int iRowCOunt = this.m_oPolicyTable.getRowCount();
        if (iRowCOunt == 0) {
            return oResourcelist;
        }
        int[] arrRows = this.m_oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        Resource oResource = null;
        int iDevID = 0;
        DevicePolicyState oDevicePolicyState = null;
        for (int index = 0; index < iLength; ++index) {
            oDevicePolicyState = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(arrRows[index], 13);
            iDevID = oDevicePolicyState.getDevID();
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iDevID);
            if (null == oResource) continue;
            oResourcelist.add(oResource);
        }
        return oResourcelist;
    }

    public TIntArrayList getSelectedPolicyIDs() {
        TIntArrayList oPolicyIDLst = new TIntArrayList();
        int[] arrRows = this.m_oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        int iPolicyID = 0;
        for (int index = 0; index < iLength; ++index) {
            iPolicyID = (Integer)this.m_oPolicyTableModel.getValueAt(arrRows[index], 0);
            if (oPolicyIDLst.contains(iPolicyID)) continue;
            oPolicyIDLst.add(iPolicyID);
        }
        return oPolicyIDLst;
    }

    public void refreshDevProgress(int iDevID) {
        int iRowCount = this.m_oPolicyTable.getRowCount();
        int iDestDevID = -1;
        DevicePolicyState oDevicePolicyState = null;
        for (int i = 0; i < iRowCount; ++i) {
            oDevicePolicyState = (DevicePolicyState)this.m_oPolicyTableModel.getValueAt(i, 13);
            iDestDevID = oDevicePolicyState.getDevID();
            if (iDestDevID != iDevID) continue;
            PolicyInfo oPolicyInfo = PolicyManager.getInstance().getPolicyInfoByDevID(iDevID);
            DevicePolicyState oDev = oPolicyInfo.getDevicePolicyState(iDevID);
            if (null == oDev) break;
            this.m_oPolicyTableModel.setValueAt((Object)oDev, i, 13);
            break;
        }
        this.updateGUI();
    }

    private void refreshBtnStatus(boolean bEnable) {
        DeviceInfo[] oDevInfos = DeviceInfoManagerImpl.getInstance().getDevices();
        if (null == oDevInfos || oDevInfos.length == 0) {
            this.m_oCreateBtn.setEnabled(false);
        } else {
            this.m_oCreateBtn.setEnabled(true);
        }
        this.m_oMoveToBtn.setEnabled(bEnable);
        this.m_oSaveBtn.setEnabled(bEnable);
    }

    @Override
    public void notifyEvent(PolicyEventObject oEventObject) {
    }

    private static VisualData getShowIP(String ip) {
        if (StringUtils.isNullOrEmptyStr(ip)) {
            return new VisualData(0, ip);
        }
        String[] ipSegs = ip.split("\\.");
        int value = 0;
        int bit_in_byte = 8;
        int byte_in_int = 4;
        try {
            for (int i = 0; i < ipSegs.length; ++i) {
                int seg = Integer.parseInt(ipSegs[i]);
                int byteIndex = i + 1;
                int shift = (4 - byteIndex) * 8;
                value |= seg << shift;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return new VisualData(0, ip);
        }
        return new VisualData(value, ip);
    }

    private void refreshDevPolicyState(Object oEventObj) {
        if (!(oEventObj instanceof List)) {
            return;
        }
        List oPolicyLst = (List)oEventObj;
        if (oPolicyLst.isEmpty()) {
            return;
        }
        Vector oDataVct = this.m_oPolicyTableModel.getDataVector();
        DevicePolicyState oSourceDev = null;
        DevicePolicyState oDestDev = null;
        int iDevID = 0;
        for (int i = 0; i < oDataVct.size(); ++i) {
            Vector oRowVct = (Vector)oDataVct.get(i);
            int iPolicyID = Integer.parseInt(oRowVct.get(0).toString());
            oDestDev = this.getDevicePolicyState(oPolicyLst, iPolicyID, iDevID = (oSourceDev = (DevicePolicyState)oRowVct.get(oRowVct.size() - 1)).getDevID());
            if (null == oDestDev) continue;
            String sSaveState = this.getStateString(oDestDev.getSavePolicyState());
            String sBackupState = this.getStateString(oDestDev.getBakcupPolicyState());
            oRowVct.setElementAt(sSaveState, 5);
            oRowVct.setElementAt(sBackupState, 7);
            oSourceDev = oDestDev;
        }
        this.m_oPolicyTableModel.fireTableDataChanged();
        DCFrameWorkUtil.repaint(this);
    }

    private DevicePolicyState getDevicePolicyState(List<PolicyInfo> oPolicyLst, int iPolicyID, int iDevID) {
        for (int i = 0; i < oPolicyLst.size(); ++i) {
            PolicyInfo oPolicy = oPolicyLst.get(i);
            if (null == oPolicy || oPolicy.getPolicyID() != iPolicyID) continue;
            oPolicy.setIsDevChange(false);
            return oPolicy.getDevicePolicyState(iDevID);
        }
        return null;
    }

    private String getStateString(int iState) {
        String sState = "--";
        switch (iState) {
            case 0: {
                sState = ResourceManager.getInstance().getResString("POLICY_STATUS_RUN");
                break;
            }
            case 1: {
                sState = ResourceManager.getInstance().getResString("POLICY_STATUS_STOP");
                break;
            }
        }
        return sState;
    }

    @Override
    public void handleDeviceConfigNotification(PolicyEventObject oPolicyEvent) {
        int iEventType = oPolicyEvent.getEventType();
        Object oEventObj = oPolicyEvent.getSource();
        switch (iEventType) {
            case 6: {
                this.refreshDevPolicyState(oEventObj);
                break;
            }
            case 2: 
            case 5: {
                PolicyInfo oPolicyInfo = (PolicyInfo)oEventObj;
                if (this.m_iCurrentPolicyID == oPolicyInfo.getPolicyID()) {
                    this.m_oPolicyTableModel.getDataVector().clear();
                    if (5 == iEventType) {
                        THashMap<Integer, DevicePolicyState> oDevicePolicyStateLst = oPolicyInfo.getDevicePolicyStateHm();
                        oDevicePolicyStateLst.remove((Object)oPolicyInfo.getChangedDevIdLst().get(0));
                        oPolicyInfo.setDevicePolicyStateHm(oDevicePolicyStateLst);
                    }
                    this.initTableData(oPolicyInfo, "", this.m_sCurrentSubmapID);
                }
                oPolicyInfo.setIsDevChange(false);
                break;
            }
        }
    }

    public void disposePanel() {
        if (null != this.m_oPolicyLst) {
            this.m_oPolicyLst.clear();
            this.m_oPolicyLst = null;
        }
        if (null != this.m_oNETypeModel) {
            this.m_oNETypeModel.removeAllElements();
            this.m_oNETypeModel = null;
        }
        if (null != this.m_oNETyePanel) {
            this.m_oNETyePanel.removeAll();
            this.m_oNETyePanel = null;
        }
        if (null != this.m_oNETypeCombox) {
            this.m_oNETypeCombox.removeAll();
            this.m_oNETypeCombox = null;
        }
        if (null != this.m_oPolicyTable) {
            this.m_oPolicyTable.removeAll();
            this.m_oPolicyTable = null;
        }
        if (null != this.m_oPolicyTableModel) {
            this.m_oPolicyTableModel.getDataVector().clear();
            this.m_oPolicyTableModel = null;
        }
        if (null != this.m_oPolicyTableMenuItemHandler) {
            this.m_oPolicyTableMenuItemHandler.clearUpObject();
            this.m_oPolicyTableMenuItemHandler = null;
        }
        if (null != this.m_oPolicyInfoScrollPane) {
            this.m_oPolicyInfoScrollPane.removeAll();
            this.m_oPolicyInfoScrollPane = null;
        }
        if (null != this.m_oPopupManager) {
            this.m_oPopupManager.cleanUp();
            this.m_oPopupManager = null;
        }
        if (null != this.m_oPolicyTablePopupMenu) {
            this.m_oPolicyTablePopupMenu.removeAll();
            this.m_oPolicyTablePopupMenu = null;
        }
        if (null != this.m_oSelectDevIDLst) {
            this.m_oSelectDevIDLst.clear();
            this.m_oSelectDevIDLst = null;
        }
        PolicyManager.getInstance().unRegisterPolicyChangeListener(this);
        this.removeAll();
    }

    public String getCurSubMap() {
        return this.m_sCurrentSubmapID;
    }

    public void setRefreshDateTime() {
        this.strdate = DeviceTableUtil.getCurDateTimeStr();
        this.refreshSelectedDevCountLabel();
    }

    public List<Integer> getMoveDeviceIDList() {
        return this.moveDeviceIDList;
    }

    public void setMoveDeviceIDList(List<Integer> moveDeviceIDList) {
        this.moveDeviceIDList = moveDeviceIDList;
    }

    public void setMoveDeviceSelected() {
        if (null != this.m_oPolicyTable && this.getMoveDeviceIDList().size() > 0) {
            this.m_oPolicyTable.clearSelection();
        }
        for (Integer deviceID : this.getMoveDeviceIDList()) {
            this.setDevSelected(deviceID);
        }
        this.getMoveDeviceIDList().clear();
    }

    private void setAllDevIDList() {
        HashSet<Integer> allDevIDList = new HashSet<Integer>();
        int size = this.m_oPolicyTableModel.getDataVector().size();
        DevicePolicyState oDevicePolicyState = null;
        for (int i = 0; i < size; ++i) {
            oDevicePolicyState = (DevicePolicyState)((Vector)this.m_oPolicyTableModel.getDataVector().get(i)).get(13);
            if (null == oDevicePolicyState) continue;
            allDevIDList.add(oDevicePolicyState.getDevID());
        }
        PolicyUtil.setSelDevLst(allDevIDList);
    }

    public DCSortableTableModel getPolicyTableModel() {
        return this.m_oPolicyTableModel;
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            TableColumnModel columnModel;
            int viewColumn;
            Point oPoint = oMouseEvent.getPoint();
            JTable tableView = (JTable)oMouseEvent.getSource();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(oMouseEvent.getX()));
            if (column == 13) {
                DevicePolicyState oDev;
                Collator oCol = Collator.getInstance();
                int iRowNum = tableView.rowAtPoint(oPoint);
                Object oCellObj = PolicyTablePanel.this.m_oPolicyTableModel.getValueAt(iRowNum, column);
                if (oCellObj instanceof DevicePolicyState && null != (oDev = (DevicePolicyState)oCellObj).getPropressInfo() && !oCol.equals("", oDev.getPropressInfo().getErrorMsg())) {
                    Cursor oCur = new Cursor(12);
                    DCFrameWorkUtil.setCursor(PolicyTablePanel.this.getParent(), oCur);
                    return;
                }
            }
            Cursor oCur = new Cursor(0);
            DCFrameWorkUtil.setCursor(PolicyTablePanel.this.getParent(), oCur);
        }
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent oMouseEvent) {
            DCFrameWorkUtil.setCursor(PolicyTablePanel.this.getParent(), Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent oMouseEvent) {
            DevicePolicyState oDev;
            TableColumnModel columnModel;
            int viewColumn;
            JTable tableView = (JTable)oMouseEvent.getSource();
            int column = tableView.convertColumnIndexToModel(viewColumn = (columnModel = tableView.getColumnModel()).getColumnIndexAtX(oMouseEvent.getX()));
            if (column < 13) {
                return;
            }
            int iRowNum = PolicyTablePanel.this.m_oPolicyTable.getSelectedRow();
            Object oCellObj = PolicyTablePanel.this.m_oPolicyTableModel.getValueAt(iRowNum, column);
            if (oCellObj instanceof DevicePolicyState && null != (oDev = (DevicePolicyState)oCellObj).getPropressInfo() && !"".equals(oDev.getPropressInfo().getErrorMsg())) {
                String strMessage = oDev.getPropressInfo().getErrorMsg();
                ViewCommandResultDialog dialog = new ViewCommandResultDialog(strMessage);
                dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                dialog.getContentTextArea().setLineWrap(true);
                dialog.setVisible(true);
                return;
            }
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        private PolicyTablePanel m_oPalicyTablePanelRef;

        public TableSelectionListener(PolicyTablePanel parent) {
            this.m_oPalicyTablePanelRef = parent;
        }

        @Override
        public void valueChanged(ListSelectionEvent oListSelectionEvent) {
            if (!oListSelectionEvent.getValueIsAdjusting() && null != this.m_oPalicyTablePanelRef) {
                PolicyTablePanel.this.refreshSelectedDevCountLabel();
                PolicyTablePanel.this.m_oSelectDevIDLst = PolicyTablePanel.this.getSelectedDevIDLst();
            }
        }
    }
}

