/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.HAServerSettingPanel;
import com.huawei.dc.policy.view.PolicyTablePanel;
import com.huawei.dc.policy.view.PolicyTreePanel;
import com.swimap.mdi.ExtendedWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class PolicyMgmtPanel
extends ExtendedWindow {
    private static final long serialVersionUID = -8416220017496589353L;
    private PolicyTreePanel m_oPolicyTreePanel = null;
    private PolicyTablePanel m_oPolicyTablePanel = null;
    private JSplitPane m_oHorizontalSplitPane;
    private JTabbedPane m_oTabPane = null;
    HAServerSettingPanel m_oHAServerSettingPanel = null;

    public PolicyMgmtPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponent();
        this.addComponent();
        this.setName("Componenets_DataCenterMainPanel_PolicyMgmtPanel");
        this.setTitle(ResourceManager.getInstance().getResString("POLICY_MANAGEMENT_TAB"));
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)this), "HELP_TOPIC_POLICY");
    }

    public void getPolicyFromServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int reqId = DCFrameWorkUtil.generateRequestId();
                PolicyManager.getInstance().initProgressDlg(reqId);
                PolicyManager.getInstance().showProgressDlg();
                DeviceInfoManagerImpl.getInstance().getDeviceFromDCServerWithParent(2);
                int iErrorCode = PolicyManager.getInstance().getPolicyInfoFromServer(reqId);
                if (iErrorCode != 0) {
                    DCDebugTracer.trace("DC::get policy form server faild " + iErrorCode);
                }
            }
        }).start();
        this.requestFocus();
    }

    public synchronized void initData(List<PolicyInfo> oPolicyLst) {
        long curTime = System.currentTimeMillis();
        DCDebugTracer.trace("initData Time Start:" + curTime);
        this.m_oPolicyTreePanel.initData(oPolicyLst, true);
        DCDebugTracer.trace("initData Time End:" + (System.currentTimeMillis() - curTime));
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
    }

    private void initComponent() {
        this.m_oPolicyTreePanel = new PolicyTreePanel(null);
        this.m_oPolicyTablePanel = new PolicyTablePanel(null);
        this.m_oPolicyTreePanel.registerDCEventListener(this.m_oPolicyTablePanel);
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setName("PolicyMgmtPanel_m_oHorizontalSplitPane");
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(225);
        this.m_oHorizontalSplitPane.setDividerSize(6);
        this.m_oHAServerSettingPanel = new HAServerSettingPanel();
        this.m_oTabPane = new JTabbedPane();
    }

    private void alignComponent() {
        this.setLayout(new GridLayout());
        this.m_oPolicyTreePanel.setPreferredSize(new Dimension(200, 230));
        this.m_oPolicyTreePanel.setMinimumSize(new Dimension(200, 230));
        this.m_oPolicyTablePanel.setPreferredSize(new Dimension(800, 350));
        this.m_oPolicyTablePanel.setMinimumSize(new Dimension(800, 550));
        this.m_oHorizontalSplitPane.setMinimumSize(new Dimension(800, 100));
        this.m_oHorizontalSplitPane.setPreferredSize(new Dimension(800, 800));
    }

    public void refreshPolicyMainPanel() {
        this.getPolicyFromServer();
    }

    public PolicyTablePanel getPolicyTablePanel() {
        return this.m_oPolicyTablePanel;
    }

    private void addComponent() {
        this.m_oHorizontalSplitPane.add((Component)this.m_oPolicyTreePanel, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_oPolicyTablePanel, "right");
        this.m_oTabPane.add(ResourceManager.getInstance().getResString("POLICY_MANAGEMENT_AUTO_BACKUP_TAB"), this.m_oHorizontalSplitPane);
        this.m_oTabPane.add(ResourceManager.getInstance().getResString("POLICY_MANAGEMENT_HA_SERVER_TAB"), this.m_oHAServerSettingPanel);
        this.add(this.m_oTabPane, null);
    }

    public void windowActivated() {
        super.windowActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getDCModuleManager().setToolBarIconVisible(true);
            }
        });
        MenuUtil.enableMenuItem(DCFrameWorkUtil.getDCModuleManager().getDataCenterMenu(), "BackupPolicyManagement", false);
        DCFrameWorkUtil.getToolBarButton("policyManagement").setEnabled(false);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
    }

    public void windowDeactivated() {
        super.windowDeactivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getDCModuleManager().setToolBarIconVisible(false);
            }
        });
        MenuUtil.enableMenuItem(DCFrameWorkUtil.getDCModuleManager().getDataCenterMenu(), "BackupPolicyManagement", true);
        DCFrameWorkUtil.getToolBarButton("policyManagement").setEnabled(true);
    }

    public void windowClosed() {
        this.disposePanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getDCModuleManager().setToolBarIconVisible(false);
            }
        });
        DCFrameWorkUtil.getDCModuleManager().closePanel("PolicyInfoPanel");
    }

    public void disposePanel() {
        if (null != this.m_oTabPane) {
            this.m_oTabPane.removeAll();
            this.m_oTabPane = null;
        }
        if (null != this.m_oHorizontalSplitPane) {
            this.m_oHorizontalSplitPane.removeAll();
            this.m_oHorizontalSplitPane = null;
        }
        if (null != this.m_oPolicyTreePanel) {
            this.m_oPolicyTreePanel.disposePanel();
            this.m_oPolicyTreePanel = null;
        }
        if (null != this.m_oPolicyTablePanel) {
            this.m_oPolicyTablePanel.disposePanel();
            this.m_oPolicyTablePanel = null;
        }
        if (null != this.m_oHAServerSettingPanel) {
            this.m_oHAServerSettingPanel.disposePanel();
            this.m_oHAServerSettingPanel = null;
        }
        if (null != PolicyUtil.getSelDevLst()) {
            PolicyUtil.setNull();
        }
        ObjectStore.getInstance().removeObjectInstance("PolicyInfoPanel");
    }

    public void windowOpened() {
        DCFrameWorkUtil.getDCModuleManager().openPanel("PolicyInfoPanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCFrameWorkUtil.getDCModuleManager().setToolBarIconVisible(true);
            }
        });
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }
}

