/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PolicyDetailDlg
extends DCModalDialog {
    private static final long serialVersionUID = 8248042673365827896L;
    private JLabel mPolicyBackupPeriod = null;
    private JLabel mPolicyBackupDay = null;
    private JLabel mPolicyBackupStartTime = null;
    private JLabel mPolicyBackupEndTime = null;
    private JTextField mPolicyBackupPeriodText = null;
    private JTextField mPolicyBackupDayText = null;
    private JTextField mPolicyBackupStartTimeText = null;
    private JTextField mPolicyBackupEndTimeText = null;
    private JLabel mPolicySavePeriod = null;
    private JLabel mPolicySaveDay = null;
    private JLabel mPolicySaveStartTime = null;
    private JLabel mPolicySaveEndTime = null;
    private JTextField mPolicySavePeriodText = null;
    private JTextField mPolicySaveDayText = null;
    private JTextField mPolicySaveStartTimeText = null;
    private JTextField mPolicySaveEndTimeText = null;
    private JPanel mDetailPanel = null;
    private JPanel mButtonPanel = null;
    private static ResourceManager mRes = ResourceManager.getInstance();
    private String sMonthPeriod = mRes.getResString("POLICY_PERIOD_MONTHLY");
    private String sWeekPeriod = mRes.getResString("POLICY_PERIOD_WEEKLY");
    private String sDayPeriod = mRes.getResString("POLICY_PERIOD_DAILY");
    private static final int DEFAULT_DAY = -1;
    private static final int DEFAULT_LENGTH = 1;
    private static final int FIRST = 0;
    private static final int SUNDAY = 0;
    private static final int SATURDAY = 6;
    private static String[] days = new String[7];

    public PolicyDetailDlg() {
        this.initGUI();
        this.addListener();
    }

    public PolicyDetailDlg(PolicyInfo oPolicyInfo) {
        this.initGUI();
        this.initData(oPolicyInfo);
        this.addListener();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponent();
    }

    private void initComponent() {
        this.mDetailPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mPolicyBackupPeriod = new JLabel();
        this.mPolicyBackupPeriod.setText(mRes.getResString("POLICY_BACKUP_TYPE"));
        this.mPolicyBackupDay = new JLabel();
        this.mPolicyBackupDay.setText(mRes.getResString("POLICY_BACKUP_DATE"));
        this.mPolicyBackupStartTime = new JLabel();
        this.mPolicyBackupStartTime.setText(mRes.getResString("BACKUP") + mRes.getResString("START_TIME"));
        this.mPolicyBackupEndTime = new JLabel();
        this.mPolicyBackupEndTime.setText(mRes.getResString("BACKUP") + mRes.getResString("END_TIME"));
        this.mPolicySavePeriod = new JLabel();
        this.mPolicySavePeriod.setText(mRes.getResString("POLICY_SAVE_TYPE"));
        this.mPolicySaveDay = new JLabel();
        this.mPolicySaveDay.setText(mRes.getResString("POLICY_SAVE_DATE"));
        this.mPolicySaveStartTime = new JLabel();
        this.mPolicySaveStartTime.setText(mRes.getResString("SAVE") + mRes.getResString("START_TIME"));
        this.mPolicySaveEndTime = new JLabel();
        this.mPolicySaveEndTime.setText(mRes.getResString("SAVE") + mRes.getResString("END_TIME"));
        this.mPolicyBackupPeriodText = new JTextField();
        this.mPolicyBackupDayText = new JTextField();
        this.mPolicyBackupStartTimeText = new JTextField();
        this.mPolicyBackupEndTimeText = new JTextField();
        this.mPolicyBackupPeriodText.setEditable(false);
        this.mPolicyBackupDayText.setEditable(false);
        this.mPolicyBackupStartTimeText.setEditable(false);
        this.mPolicyBackupEndTimeText.setEditable(false);
        this.mPolicySavePeriodText = new JTextField();
        this.mPolicySaveDayText = new JTextField();
        this.mPolicySaveStartTimeText = new JTextField();
        this.mPolicySaveEndTimeText = new JTextField();
        this.mPolicySavePeriodText.setEditable(false);
        this.mPolicySaveDayText.setEditable(false);
        this.mPolicySaveStartTimeText.setEditable(false);
        this.mPolicySaveEndTimeText.setEditable(false);
    }

    private void alignComponent() {
        this.setTitle(mRes.getResString("POLICY_VIEW_DETAILS"));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 200));
        this.mDetailPanel.setPreferredSize(new Dimension(750, 180));
        this.mDetailPanel.setMaximumSize(new Dimension(750, 180));
        this.mDetailPanel.setMinimumSize(new Dimension(750, 180));
        this.mButtonPanel.setPreferredSize(new Dimension(180, 30));
        this.mButtonPanel.setMaximumSize(new Dimension(180, 30));
        this.mButtonPanel.setMinimumSize(new Dimension(180, 30));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 20));
        this.m_oOKBtn.setMaximumSize(new Dimension(85, 20));
        this.alignBackupComponent();
        this.alignSaveComponent();
        this.mDetailPanel.add((Component)this.mPolicyBackupPeriod, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupPeriodText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySavePeriod, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySavePeriodText, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupDay, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupDayText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveDay, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveDayText, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupStartTime, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupStartTimeText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveStartTime, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveStartTimeText, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupEndTime, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicyBackupEndTimeText, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveEndTime, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.mDetailPanel.add((Component)this.mPolicySaveEndTimeText, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oOKBtn.setText(mRes.getResString("OK_BTN"));
        FlowLayout flowLayout = new FlowLayout(2);
        this.mButtonPanel.setLayout(flowLayout);
        this.mButtonPanel.add(this.m_oOKBtn);
        this.add(this.mDetailPanel, "Center");
        this.add(this.mButtonPanel, "South");
    }

    private void alignSaveComponent() {
        this.adjustComponentSize(this.mPolicySavePeriod, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicySaveDay, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicySaveStartTime, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicySaveEndTime, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicySavePeriodText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicySaveDayText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicySaveStartTimeText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicySaveEndTimeText, new Dimension(270, 20));
    }

    private void alignBackupComponent() {
        this.adjustComponentSize(this.mPolicyBackupPeriod, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicyBackupDay, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicyBackupStartTime, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicyBackupEndTime, new Dimension(100, 20));
        this.adjustComponentSize(this.mPolicyBackupPeriodText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicyBackupDayText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicyBackupStartTimeText, new Dimension(270, 20));
        this.adjustComponentSize(this.mPolicyBackupEndTimeText, new Dimension(270, 20));
    }

    private void adjustComponentSize(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMinimumSize(dimension);
    }

    private void addListener() {
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyDetailDlg.this.dispose();
            }
        });
    }

    private void initData(PolicyInfo oPolicyInfo) {
        List<PolicyTypeInfo> policyTypeList = oPolicyInfo.getPolicyTypeInfoLst();
        ArrayList<PolicyTypeInfo> backupPolicyTypeList = new ArrayList<PolicyTypeInfo>();
        ArrayList<PolicyTypeInfo> savePolicyTypeList = new ArrayList<PolicyTypeInfo>();
        for (int index = 0; index < policyTypeList.size(); ++index) {
            PolicyTypeInfo mPolicyTypeInfo = policyTypeList.get(index);
            if (0 == mPolicyTypeInfo.getPolicyType()) {
                backupPolicyTypeList.add(mPolicyTypeInfo);
            }
            if (1 != mPolicyTypeInfo.getPolicyType()) continue;
            savePolicyTypeList.add(mPolicyTypeInfo);
        }
        this.initBackupPolicyData(backupPolicyTypeList);
        this.initSavePolicyData(savePolicyTypeList);
        this.initNullText();
    }

    private void initSavePolicyData(List<PolicyTypeInfo> savePolicyTypeList) {
        if (savePolicyTypeList.isEmpty()) {
            return;
        }
        this.initTimeFromPolicyList(savePolicyTypeList, this.mPolicySaveStartTimeText, this.mPolicySaveEndTimeText, this.mPolicySavePeriodText);
        this.initDayFromPolicyList(savePolicyTypeList, this.mPolicySaveDayText);
    }

    private void initBackupPolicyData(List<PolicyTypeInfo> backupPolicyTypeList) {
        if (backupPolicyTypeList.isEmpty()) {
            return;
        }
        this.initTimeFromPolicyList(backupPolicyTypeList, this.mPolicyBackupStartTimeText, this.mPolicyBackupEndTimeText, this.mPolicyBackupPeriodText);
        this.initDayFromPolicyList(backupPolicyTypeList, this.mPolicyBackupDayText);
    }

    private void initTimeFromPolicyList(List<PolicyTypeInfo> policyTypeList, JTextField start, JTextField end, JTextField period) {
        if (policyTypeList.isEmpty()) {
            return;
        }
        PolicyTypeInfo tempPolicyTypeInfo = policyTypeList.get(0);
        start.setText(tempPolicyTypeInfo.getPolicyTime());
        end.setText(tempPolicyTypeInfo.getEndTime());
        if (0 == tempPolicyTypeInfo.getPolicyPeriod()) {
            period.setText(this.sMonthPeriod);
        }
        if (1 == tempPolicyTypeInfo.getPolicyPeriod()) {
            period.setText(this.sWeekPeriod);
        }
        if (2 == tempPolicyTypeInfo.getPolicyPeriod()) {
            period.setText(this.sDayPeriod);
        }
    }

    private void initDayFromPolicyList(List<PolicyTypeInfo> policyTypeList, JTextField mText) {
        StringBuilder dayBuffer = new StringBuilder();
        for (int saveIndex = 0; saveIndex < policyTypeList.size(); ++saveIndex) {
            PolicyTypeInfo mPolicyTypeInfo = policyTypeList.get(saveIndex);
            if (1 == mPolicyTypeInfo.getPolicyPeriod()) {
                dayBuffer.append(this.decodeDayInWeek(mPolicyTypeInfo.getPolicyDayInWeek()));
                dayBuffer.append(",");
            }
            if (0 == mPolicyTypeInfo.getPolicyPeriod() && mPolicyTypeInfo.getPolicyDayInMonth() != -1) {
                dayBuffer.append(mPolicyTypeInfo.getPolicyDayInMonth());
                dayBuffer.append(",");
            }
            if (2 != mPolicyTypeInfo.getPolicyPeriod()) continue;
            mText.setText("--");
            return;
        }
        if (dayBuffer.length() > 1) {
            mText.setText(dayBuffer.substring(0, dayBuffer.length() - 1));
        } else {
            mText.setText("--");
        }
    }

    public void setNotSupportSave() {
        this.initNullTextField(this.mPolicySavePeriodText);
        this.initNullTextField(this.mPolicySaveDayText);
        this.initNullTextField(this.mPolicySaveStartTimeText);
        this.initNullTextField(this.mPolicySaveEndTimeText);
    }

    private void initNullText() {
        this.initNullTextField(this.mPolicySavePeriodText);
        this.initNullTextField(this.mPolicySaveDayText);
        this.initNullTextField(this.mPolicySaveStartTimeText);
        this.initNullTextField(this.mPolicySaveEndTimeText);
        this.initNullTextField(this.mPolicyBackupPeriodText);
        this.initNullTextField(this.mPolicyBackupDayText);
        this.initNullTextField(this.mPolicyBackupStartTimeText);
        this.initNullTextField(this.mPolicyBackupEndTimeText);
    }

    private void initNullTextField(JTextField mText) {
        if (null == mText.getText() || "".endsWith(mText.getText())) {
            mText.setText("--");
        }
    }

    private String decodeDayInWeek(int weekDay) {
        if (weekDay >= 0 && weekDay <= 6) {
            return days[weekDay];
        }
        return "";
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    static {
        for (int i = 0; i < 7; ++i) {
            PolicyDetailDlg.days[i] = mRes.getResString("POLICY_WEEK_DAY_" + i);
        }
    }
}

