/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCButtonUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.policy.view.BasicPolicyPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PolicyDaySelectDayDlg
extends DCModalDialog {
    private static final long serialVersionUID = -1162255221519150296L;
    private JPanel mDayPanel = null;
    private JScrollPane mDayScrollPanel = null;
    private JPanel mButtonPanel = null;
    private JLabel mMultiSelLabel = null;
    private JList mSelectDayList = null;
    private Vector<String> allDay = null;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private BasicPolicyPanel mBasicPolicyPanel = null;
    private static final int DEFAULT_LENGTH = 1;

    public PolicyDaySelectDayDlg(BasicPolicyPanel basicPolicyPanel) {
        this.setmBasicPolicyPanel(basicPolicyPanel);
        this.initGUI(this.mBasicPolicyPanel.getSelectType());
        this.addListener();
    }

    private void initGUI(int mWeekOrMonth) {
        this.setTitle(this.m_oRes.getResString("SELECT_DATE"));
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(210, 360));
        this.mDayPanel = new JPanel();
        this.mDayPanel.setPreferredSize(new Dimension(180, 230));
        this.mDayPanel.setMinimumSize(new Dimension(180, 230));
        this.mSelectDayList = new JList();
        this.initSelectDay(mWeekOrMonth);
        this.mDayScrollPanel = new JScrollPane(this.mSelectDayList);
        this.mDayScrollPanel.setPreferredSize(new Dimension(170, 225));
        this.mDayScrollPanel.setMinimumSize(new Dimension(170, 225));
        this.mDayScrollPanel.setVerticalScrollBarPolicy(20);
        this.mDayPanel.add((Component)this.mDayScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.mButtonPanel = new JPanel();
        DCButtonUtil.getInstance().initButton(this.m_oOKBtn, this.m_oRes.getResString("OK_BTN"));
        DCButtonUtil.getInstance().initButton(this.m_oCancelBtn, this.m_oRes.getResString("CANCEL_BTN"));
        this.mButtonPanel.setPreferredSize(new Dimension(200, 25));
        this.mButtonPanel.setMinimumSize(new Dimension(200, 25));
        FlowLayout flowLayout = new FlowLayout(1);
        this.mButtonPanel.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.mButtonPanel.add(this.m_oOKBtn);
        this.mButtonPanel.add(this.m_oCancelBtn);
        this.mMultiSelLabel = new JLabel(StringUtils.getHtmlString(this.m_oRes.getResString("POLICY_MULTI_SELECT_DATE_LABEL")));
        this.add(this.mDayPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.mMultiSelLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 1, new Insets(8, 12, 0, 8), 0, 0));
        this.add(this.mButtonPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 1, new Insets(12, 12, 0, 12), 0, 0));
    }

    private void initSelectDay(int mWeekOrMonth) {
        if (1 == mWeekOrMonth) {
            this.allDay = new Vector();
            for (int i = 0; i < 7; ++i) {
                this.allDay.add(this.m_oRes.getResString("POLICY_WEEK_DAY_" + i));
            }
        } else if (0 == mWeekOrMonth) {
            this.allDay = new Vector();
            for (int index = 1; index <= 31; ++index) {
                this.allDay.add(String.valueOf(index));
            }
        }
        this.mSelectDayList.setListData(this.allDay);
    }

    private void setmBasicPolicyPanel(BasicPolicyPanel mBasicPolicyPanel) {
        this.mBasicPolicyPanel = mBasicPolicyPanel;
    }

    public String getDaySelect() {
        if (null == this.mSelectDayList || this.mSelectDayList.isSelectionEmpty()) {
            return "";
        }
        StringBuilder selectDayBuffer = new StringBuilder();
        Object[] allSelectDay = this.mSelectDayList.getSelectedValues();
        if (null == allSelectDay) {
            return "";
        }
        for (int index = 0; index < allSelectDay.length; ++index) {
            selectDayBuffer.append(allSelectDay[index].toString());
            selectDayBuffer.append(",");
        }
        int mStart = 0;
        int mEnd = selectDayBuffer.length();
        if (selectDayBuffer.length() > 1) {
            return selectDayBuffer.substring(mStart, mEnd - 1);
        }
        return "";
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    private boolean validateSecleDay() {
        if (null == this.mSelectDayList || this.mSelectDayList.isSelectionEmpty()) {
            return false;
        }
        Object[] selectDays = this.mSelectDayList.getSelectedValues();
        if (null == selectDays) {
            return false;
        }
        return selectDays.length > 0;
    }

    private void addListener() {
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyDaySelectDayDlg.this.handleOKButton_Clicked();
            }
        });
    }

    private void handleOKButton_Clicked() {
        if (!this.validateSecleDay()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.m_oRes.getResString("NOT_SELECT_DATE"), this.m_oRes.getResString("ERROR"), 0);
        } else {
            this.mBasicPolicyPanel.setSelectDay(this.getDaySelect());
            this.dispose();
        }
    }
}

