/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.asndatacenter.AsnDCPolicyDevIdBakNumLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.commustru.fstru.FStruct;

public class MovePolicyDlg
extends DCModalDialog {
    private static final long serialVersionUID = 490749075747143240L;
    private JLabel m_oNoticeInfoLbl = null;
    private JLabel m_oDestPolicyLbl = null;
    private ComboBoxWithToolTip m_oDestPolicyCombox = null;
    private JPanel m_oButtonPnl = null;
    private int m_iSourePolicyID = -1;
    private THashMap<Integer, DevicePolicyState> m_oDevHm = null;

    public MovePolicyDlg(THashMap<Integer, DevicePolicyState> oDevHm) {
        this.m_oDevHm = oDevHm;
        this.initGUI();
        this.initData();
        this.setDefaultCloseOperation(2);
    }

    public MovePolicyDlg(THashMap<Integer, DevicePolicyState> oDevHm, int iSourcePolicyID) {
        this.m_iSourePolicyID = iSourcePolicyID;
        this.m_oDevHm = oDevHm;
        this.initGUI();
        this.initData();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        ResourceManager oRes = ResourceManager.getInstance();
        this.setTitle(oRes.getResString("POLICY_MOVE_DLG_TLE"));
        this.setSize(new Dimension(600, 160));
        this.m_oNoticeInfoLbl = new JLabel();
        this.m_oNoticeInfoLbl.setText(StringUtils.getHtmlString(oRes.getResString("POLICY_MOVE_NOTICE")));
        this.m_oDestPolicyLbl = new JLabel();
        this.m_oDestPolicyLbl.setText(oRes.getResString("POLICY_MOVE_DEST_LBL"));
        this.m_oDestPolicyLbl.setPreferredSize(new Dimension(200, 20));
        this.m_oDestPolicyLbl.setMinimumSize(new Dimension(200, 20));
        this.m_oDestPolicyCombox = new ComboBoxWithToolTip();
        this.m_oDestPolicyCombox.setName("policy_MovePolicyDlg_m_oDestPolicyCombox");
        this.m_oDestPolicyCombox.setPreferredSize(new Dimension(400, 20));
        this.m_oDestPolicyCombox.setMinimumSize(new Dimension(400, 20));
        JSeparator oSeparator = new JSeparator(0);
        oSeparator.setPreferredSize(new Dimension(600, 5));
        oSeparator.setMinimumSize(new Dimension(600, 5));
        this.initButtonPanel();
        this.add(this.m_oNoticeInfoLbl, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oDestPolicyLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add(this.m_oDestPolicyCombox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add(oSeparator, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oButtonPnl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 7), 0, 0));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void initButtonPanel() {
        this.m_oButtonPnl = new JPanel();
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oButtonPnl.setPreferredSize(new Dimension(300, 21));
        this.m_oButtonPnl.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oButtonPnl.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_oButtonPnl.add(this.m_oOKBtn);
        this.m_oButtonPnl.add(this.m_oCancelBtn);
    }

    private void initData() {
        List<PolicyInfo> oAllPolicyLst = PolicyManager.getInstance().getPolicyInfoLst();
        this.m_oDestPolicyCombox.addItem("");
        for (PolicyInfo oPolicy : oAllPolicyLst) {
            if (null == oPolicy || oPolicy.getPolicyID() == -1 || oPolicy.getPolicyID() == this.m_iSourePolicyID) continue;
            this.m_oDestPolicyCombox.addItem(oPolicy);
        }
    }

    @Override
    protected void oKButton_ActionPerformed() {
        Object oDestPolicy = this.m_oDestPolicyCombox.getSelectedItem();
        if (oDestPolicy instanceof String) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_MOVE_NO_DEST"), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            return;
        }
        if (oDestPolicy instanceof PolicyInfo) {
            PolicyInfo oPolicy = (PolicyInfo)oDestPolicy;
            AsnDCPolicyDevIdBakNumLst oAsnDevNumLst = PolicyUtil.getPolicyDevIdBakNumLst(oPolicy, this.m_oDevHm);
            boolean bCheckDistRoomContinue = PolicyManager.getInstance().isCheckDistRoomOK(44093, (FStruct)oAsnDevNumLst);
            if (!bCheckDistRoomContinue) {
                return;
            }
            PolicyManager.getInstance().moveDeviceToPolicy(this.m_oDevHm, oPolicy);
            this.dispose();
        }
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

