/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.configuration.system.HAServerInfo;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.swimap.imap12.util.dateChooser.InmDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HAServerSettingPanel
extends JScrollPane {
    private static final long serialVersionUID = -4349389091687044863L;
    private ISystemManager m_oSystemMgr = null;
    private JCheckBox m_oHAServerSettingCheckBox = null;
    private JPanel m_oBackupPolicyPanel = null;
    private JLabel m_oServerNameLbl = null;
    private ComboBoxWithToolTip m_oServerNameComboBox = null;
    private JLabel m_oBackupPolicyInfoLbl = null;
    private JLabel m_oPeriodLabel = null;
    private ComboBoxWithToolTip m_oPeriodDropDown = null;
    private JLabel m_oDayLabel = null;
    private ComboBoxWithToolTip m_oDayDropDown = null;
    private JLabel m_oTimeLabel = null;
    private InmDateChooser m_oDateTimeSpinner = null;
    private DefaultComboBoxModel m_oWeeklyDaysModel = null;
    private DefaultComboBoxModel m_oMonthlyDaysModel = null;
    private DefaultComboBoxModel m_oDailyDaysEmptyModel = null;
    private boolean m_bShowConfirmation = true;
    private HAServerInfo m_oServerInfo = null;
    private JButton m_oApplyBtn = null;
    private JPanel m_mainPolicyPanel = null;
    private boolean m_hasPolicyMgrPrivilege = true;

    public HAServerSettingPanel() {
        this.checkUserPrivilege();
        this.initializeSystemManager();
        this.jbinit();
    }

    private void initializeSystemManager() {
        this.m_oSystemMgr = new SystemManager();
    }

    public void checkUserPrivilege() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_hasPolicyMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43976);
    }

    private void jbinit() {
        this.m_oServerInfo = this.m_oSystemMgr.getHAServerInfo();
        this.initApplyBtn();
        this.initializeCheckBox();
        this.initializeBackupPolicyPanel();
        this.addComponent();
        this.setComponentsName();
        this.setDefaultValues();
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_POLICY_HA_POLICY");
        this.m_oApplyBtn.setEnabled(false);
    }

    private void addComponent() {
        this.m_mainPolicyPanel = new JPanel();
        this.m_mainPolicyPanel.setLayout(new GridBagLayout());
        this.m_oBackupPolicyPanel.setPreferredSize(new Dimension(150, 250));
        this.m_mainPolicyPanel.add((Component)this.m_oHAServerSettingCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_mainPolicyPanel.add((Component)this.m_oBackupPolicyPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        JSeparator oSeparator = new JSeparator(0);
        this.m_mainPolicyPanel.add((Component)oSeparator, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.m_mainPolicyPanel.add((Component)this.m_oApplyBtn, new GridBagConstraints(0, 4, 2, 1, 1.0, 10.0, 12, 0, new Insets(12, 12, 12, 12), 0, 0));
        this.getViewport().setView(this.m_mainPolicyPanel);
        this.setAutoscrolls(true);
    }

    private void setDefaultValues() {
        this.m_oHAServerSettingCheckBox.setSelected(this.m_oServerInfo.isEnable());
        if (this.m_oServerInfo.isEnable()) {
            this.enableAllComponents(this.m_hasPolicyMgrPrivilege);
            int iPolicyPeriod = this.m_oServerInfo.getPolicyPeriod();
            this.setPeriodToDropDown(iPolicyPeriod);
            if (-1 == this.m_oPeriodDropDown.getSelectedIndex()) {
                this.m_oPeriodDropDown.setSelectedIndex(0);
            }
            this.initializeDayDropdownForPeriod(((CodeValue)this.m_oPeriodDropDown.getSelectedItem()).getCode());
            if (2 != iPolicyPeriod) {
                this.m_oDayDropDown.setSelectedIndex(this.m_oServerInfo.getPolicyDay());
            }
            this.setPolicyTimeChooser(this.m_oServerInfo.getPolicyTime());
        } else {
            this.enableAllComponents(false);
        }
        this.m_oApplyBtn.setEnabled(this.m_oServerInfo.isEnable() && this.m_hasPolicyMgrPrivilege);
    }

    private void setPeriodToDropDown(int iPolicyPeriod) {
        int iSize = this.m_oPeriodDropDown.getItemCount();
        for (int i = 0; i < iSize; ++i) {
            CodeValue oCodeValue = (CodeValue)this.m_oPeriodDropDown.getItemAt(i);
            if (iPolicyPeriod != oCodeValue.getCode()) continue;
            this.m_oPeriodDropDown.setSelectedItem(oCodeValue);
            break;
        }
    }

    private void setPolicyTimeChooser(String policyTime) {
        if (!this.m_oDateTimeSpinner.is12_HourLock()) {
            this.m_oDateTimeSpinner.getTextField().setText(policyTime);
        } else {
            Calendar oCalObj = this.m_oDateTimeSpinner.getCalendar();
            String strHour = policyTime.substring(0, 2);
            int iHour = Integer.parseInt(strHour);
            String strMinute = policyTime.substring(3, 5);
            int iMinute = Integer.parseInt(strMinute);
            oCalObj.set(11, iHour);
            oCalObj.set(12, iMinute);
            this.m_oDateTimeSpinner.setCalendar(oCalObj);
        }
    }

    private void setComponentsName() {
        this.m_oHAServerSettingCheckBox.setName("SystemSetting_HAServerSettingPanel_m_oHAServerSettingCheckBox");
        this.m_oServerNameComboBox.setName("SystemSetting_HAServerSettingPanel_m_oServerNameComboBox");
        this.m_oBackupPolicyPanel.setName("SystemSetting_HAServerSettingPanel_m_oBackupPolicyPanel");
        this.m_oPeriodDropDown.setName("SystemSetting_HAServerSettingPanel_m_oPeriodDropDown");
        this.m_oDayDropDown.setName("SystemSetting_HAServerSettingPanel_m_oDayDropDown");
        this.m_oDateTimeSpinner.setName("SystemSetting_HAServerSettingPanel_m_oDateTimeSpinner");
    }

    private void initializeCheckBox() {
        this.m_oHAServerSettingCheckBox = new JCheckBox();
        this.m_oHAServerSettingCheckBox.setText(DCFrameWorkUtil.getLocalizedString("POLICY_HA_SERVER_ENABLE"));
        this.m_oHAServerSettingCheckBox.setFocusable(false);
        this.m_oHAServerSettingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemevent) {
                if (HAServerSettingPanel.this.m_oHAServerSettingCheckBox.isSelected()) {
                    if (HAServerSettingPanel.this.isConfigExternalFTP()) {
                        HAServerSettingPanel.this.enableAllComponents(true);
                        HAServerSettingPanel.this.setAplLicener();
                    } else {
                        HAServerSettingPanel.this.m_oHAServerSettingCheckBox.setSelected(false);
                    }
                } else {
                    HAServerSettingPanel.this.enableAllComponents(false);
                }
                if (null != HAServerSettingPanel.this.m_oApplyBtn) {
                    HAServerSettingPanel.this.m_oApplyBtn.setEnabled(true);
                }
            }
        });
        this.m_oHAServerSettingCheckBox.setPreferredSize(new Dimension(250, 20));
        this.m_oHAServerSettingCheckBox.setEnabled(this.m_hasPolicyMgrPrivilege);
    }

    private void initializeBackupPolicyPanel() {
        this.m_oBackupPolicyPanel = new JPanel();
        this.m_oBackupPolicyPanel.setLayout(new GridBagLayout());
        TitledBorder oHABackupPolicyBorder = BorderFactory.createTitledBorder(DCFrameWorkUtil.getLocalizedString("HA_BACKUP_POLICY_TITLE"));
        this.m_oBackupPolicyPanel.setBorder(oHABackupPolicyBorder);
        this.initializeBackupPolicyPanelComponents();
        this.m_oBackupPolicyPanel.add((Component)this.m_oBackupPolicyInfoLbl, new GridBagConstraints(0, 0, 5, 1, 1.0, 1.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oServerNameLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oServerNameComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oPeriodLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oPeriodDropDown, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oDayLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oDayDropDown, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oTimeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.m_oBackupPolicyPanel.add((Component)this.m_oDateTimeSpinner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 12), 0, 0));
    }

    private void initApplyBtn() {
        this.m_oApplyBtn = new JButton();
        this.m_oApplyBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oApplyBtn.setMnemonic('P');
        this.m_oApplyBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oApplyBtn.setText(ResourceManager.getInstance().getResString("APPLYBUTTON"));
        this.m_oApplyBtn.setEnabled(false);
        this.m_oApplyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HAServerSettingPanel.this.okButton_ActionPerformed();
            }
        });
    }

    private void okButton_ActionPerformed() {
        this.setHAServerInfo();
        this.m_oApplyBtn.setEnabled(false);
    }

    private void initializeBackupPolicyPanelComponents() {
        this.initializeBakcupPolicyInfoFields();
        this.initializeServerNameFields();
        this.initializePeriodFields();
        this.initializeDayFields();
        this.initializeTimeFields();
        this.policyPeriodChanged();
    }

    private void initializeBakcupPolicyInfoFields() {
        this.m_oBackupPolicyInfoLbl = new JLabel(DCFrameWorkUtil.getLocalizedString("POLICY_HA_BACKUP_POLICY_LBL"));
        this.m_oBackupPolicyInfoLbl.setPreferredSize(new Dimension(150, 50));
        this.m_oBackupPolicyInfoLbl.setPreferredSize(new Dimension(150, 50));
    }

    private void initializeServerNameFields() {
        this.m_oServerNameLbl = new JLabel(ResourceManager.getInstance().getResString("SELECT_EXTERNAL_FTP_SERVER"));
        this.m_oServerNameLbl.setPreferredSize(new Dimension(150, 20));
        this.m_oServerNameComboBox = new ComboBoxWithToolTip();
        this.m_oServerNameComboBox.setPreferredSize(new Dimension(150, 20));
        this.m_oServerNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HAServerSettingPanel.this.m_oApplyBtn.setEnabled(true);
            }
        });
        try {
            ExternalFTPInfo[] oExternalFTPInfos = this.m_oSystemMgr.getExternalFTPInfos();
            String strServerName = this.m_oServerInfo.getServerName();
            int index = 0;
            int iSelectIndex = -1;
            for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
                if (strServerName.equals(oExternalFTPInfo.getServerName())) {
                    iSelectIndex = index;
                }
                this.m_oServerNameComboBox.addItem(oExternalFTPInfo);
                ++index;
            }
            if (0 <= iSelectIndex) {
                this.m_oServerNameComboBox.setSelectedIndex(iSelectIndex);
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    private void initializePeriodFields() {
        this.m_oPeriodLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("CONFIGURE_POLICY_PERIOD_LABEL"));
        this.m_oPeriodLabel.setPreferredSize(new Dimension(150, 20));
        this.m_oPeriodDropDown = new ComboBoxWithToolTip();
        this.populatePeriodOptions();
        this.m_oPeriodDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HAServerSettingPanel.this.policyPeriodChanged();
            }
        });
        this.m_oPeriodDropDown.setPreferredSize(new Dimension(150, 20));
    }

    private void populatePeriodOptions() {
        this.m_oPeriodDropDown.addItem(this.getCodeValueFor(1, DCFrameWorkUtil.getLocalizedString("POLICY_PERIOD_WEEKLY")));
        this.m_oPeriodDropDown.addItem(this.getCodeValueFor(2, DCFrameWorkUtil.getLocalizedString("POLICY_PERIOD_DAILY")));
    }

    private void policyPeriodChanged() {
        this.m_oDayDropDown.setEnabled(true);
        int iSelectedItem = ((CodeValue)this.m_oPeriodDropDown.getSelectedItem()).getCode();
        this.initializeDayDropdownForPeriod(iSelectedItem);
    }

    private CodeValue getCodeValueFor(int iCode, String strValue) {
        CodeValue oCodeValue = new CodeValue();
        oCodeValue.setCode(iCode);
        oCodeValue.setValue(strValue);
        return oCodeValue;
    }

    private void initializeDayDropdownForPeriod(int iPeriodType) {
        switch (iPeriodType) {
            case 2: {
                this.populateDaysForDailyPeriod();
                break;
            }
            case 1: {
                this.populateDaysForWeeklyPeriod();
                break;
            }
            case 0: {
                this.populateDaysForMonthlyPeriod();
                break;
            }
        }
    }

    private void populateDaysForWeeklyPeriod() {
        if (null == this.m_oWeeklyDaysModel) {
            CodeValue[] m_weekDaysCodeValue = new CodeValue[7];
            for (int i = 0; i < 7; ++i) {
                m_weekDaysCodeValue[i] = this.getCodeValueFor(i, DCFrameWorkUtil.getLocalizedString("POLICY_WEEK_DAY_" + i));
            }
            this.m_oWeeklyDaysModel = new DefaultComboBoxModel<CodeValue>(m_weekDaysCodeValue);
        }
        this.m_oDayDropDown.setModel(this.m_oWeeklyDaysModel);
        this.m_oDayDropDown.setSelectedIndex(0);
    }

    private void populateDaysForMonthlyPeriod() {
        if (null == this.m_oMonthlyDaysModel) {
            String[] arrMonthlyDays = new String[31];
            for (int i = 1; i <= 31; ++i) {
                arrMonthlyDays[i - 1] = String.valueOf(i);
            }
            this.m_oMonthlyDaysModel = new DefaultComboBoxModel<String>(arrMonthlyDays);
        }
        this.m_oDayDropDown.setModel(this.m_oMonthlyDaysModel);
        this.m_oDayDropDown.setSelectedIndex(0);
    }

    private void populateDaysForDailyPeriod() {
        if (null == this.m_oDailyDaysEmptyModel) {
            this.m_oDailyDaysEmptyModel = new DefaultComboBoxModel();
        }
        this.m_oDayDropDown.setModel(this.m_oDailyDaysEmptyModel);
        this.m_oDayDropDown.setEnabled(false);
    }

    private void initializeDayFields() {
        this.m_oDayLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("CONFIGURE_POLICY_DATE_LABEL"));
        this.m_oDayLabel.setPreferredSize(new Dimension(150, 20));
        this.m_oDayDropDown = new ComboBoxWithToolTip();
        int iDropDownMaxRowCount = 7;
        this.m_oDayDropDown.setMaximumRowCount(7);
        this.m_oDayDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.m_oDayDropDown.setPreferredSize(new Dimension(150, 20));
    }

    private void initializeTimeFields() {
        this.m_oTimeLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("CONFIGURE_POLICY_TIME_LABEL"));
        this.m_oTimeLabel.setPreferredSize(new Dimension(150, 20));
        if (!DCTimeDateUtil.is12HrFormat()) {
            this.m_oDateTimeSpinner = new InmDateChooser(6);
            this.m_oDateTimeSpinner.setPreferredSize(new Dimension(150, 21));
        } else {
            this.m_oDateTimeSpinner = new InmDateChooser(14);
            this.m_oDateTimeSpinner.setPreferredSize(new Dimension(150, 21));
        }
        this.m_oDateTimeSpinner.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DCDebugTracer.trace("modify time and enable apply button!");
                HAServerSettingPanel.this.m_oApplyBtn.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HAServerSettingPanel.this.m_oApplyBtn.setEnabled(true);
            }
        });
    }

    public void setShowConfirmation(boolean bVal) {
        this.m_bShowConfirmation = bVal;
    }

    public boolean setHAServerInfo() {
        boolean bIsSuccess = true;
        try {
            HAServerInfo oHAServerInfo = new HAServerInfo();
            oHAServerInfo.setEnable(this.m_oHAServerSettingCheckBox.isSelected());
            if (this.m_oHAServerSettingCheckBox.isSelected()) {
                ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)this.m_oServerNameComboBox.getSelectedItem();
                oHAServerInfo.setServerName(oExternalFTPInfo.getServerName());
                oHAServerInfo.setPolicyPeriod(((CodeValue)this.m_oPeriodDropDown.getSelectedItem()).getCode());
                oHAServerInfo.setPolicyDay(this.m_oDayDropDown.getSelectedIndex());
                oHAServerInfo.setPolicyTime(this.getFormattedPolicyTime());
            }
            int iErrorCode = this.m_oSystemMgr.setHAServerInfo(oHAServerInfo);
            this.displayMessageResult(iErrorCode);
        }
        catch (DCException oDCException) {
            this.showMessageDialog(oDCException.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            bIsSuccess = false;
        }
        return bIsSuccess;
    }

    public void disposePanel() {
        this.m_oSystemMgr = null;
        this.m_oHAServerSettingCheckBox = null;
        DCCleanupUtil.cleanUpPanel(this.m_oBackupPolicyPanel);
        this.m_oBackupPolicyPanel = null;
        this.m_oPeriodLabel = null;
        this.m_oPeriodDropDown = null;
        this.m_oDayLabel = null;
        this.m_oDayDropDown = null;
        this.m_oTimeLabel = null;
        this.m_oDateTimeSpinner = null;
        this.m_oWeeklyDaysModel = null;
        this.m_oMonthlyDaysModel = null;
        this.m_oDailyDaysEmptyModel = null;
    }

    private void displayMessageResult(int iErrorCode) {
        if (iErrorCode == 0) {
            if (this.m_bShowConfirmation) {
                this.showMessageDialog(DCFrameWorkUtil.getLocalizedString("OPERTION_SUCCESS"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            }
        } else {
            this.showMessageDialog(iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
    }

    private void showMessageDialog(String strMessgae, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strMessgae, strErrorType, iOptionType);
    }

    private void showMessageDialog(int iErrorCode, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, strErrorType, iOptionType);
    }

    private void enableAllComponents(boolean bEnable) {
        this.m_oPeriodDropDown.setEnabled(bEnable);
        this.m_oDayDropDown.setEnabled(bEnable);
        this.m_oDateTimeSpinner.setEnabled(bEnable);
        this.m_oServerNameComboBox.setEnabled(bEnable);
    }

    private void setAplLicener() {
        ItemListener apItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                HAServerSettingPanel.this.m_oApplyBtn.setEnabled(true);
            }
        };
        this.m_oPeriodDropDown.addItemListener(apItemListener);
        this.m_oDayDropDown.addItemListener(apItemListener);
    }

    private String getFormattedPolicyTime() {
        String strTimeInTextField = this.m_oDateTimeSpinner.getTextField().getText();
        String strFormattedTime = DCTimeDateUtil.convertTo24HrFormat(strTimeInTextField, this.m_oDateTimeSpinner.getHour());
        return strFormattedTime;
    }

    private boolean isConfigExternalFTP() {
        SystemManager oSysMgr = new SystemManager();
        try {
            this.m_oServerNameComboBox.removeAllItems();
            ExternalFTPInfo[] oExternalFTPInfos = oSysMgr.getExternalFTPInfos();
            if (0 == oExternalFTPInfos.length) {
                if (DCFrameWorkUtil.getIsSingleClient()) {
                    int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("THIRD_PARTY_FTP_NOT_CONFIGURED_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                    if (0 != iConfirm) {
                        return false;
                    }
                    SystemSettingDlg oSystemSettingDlg = new SystemSettingDlg();
                    oSystemSettingDlg.setTabSelectedIndex(oSystemSettingDlg.getBoardTabIndex());
                    oSystemSettingDlg.setVisible(true);
                    oExternalFTPInfos = oSysMgr.getExternalFTPInfos();
                    if (0 == oExternalFTPInfos.length) {
                        DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("NOT_CONFIG_EXTERNAL_FTP"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                        return false;
                    }
                } else {
                    DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("NOT_CONFIG_EXTERNAL_FTP"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                    return false;
                }
            }
            String strServerName = this.m_oServerInfo.getServerName();
            int index = 0;
            int iSelectIndex = -1;
            for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
                if (strServerName.equals(oExternalFTPInfo.getServerName())) {
                    iSelectIndex = index;
                }
                this.m_oServerNameComboBox.addItem(oExternalFTPInfo);
                ++index;
            }
            if (0 <= iSelectIndex) {
                this.m_oServerNameComboBox.setSelectedIndex(iSelectIndex);
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), ResourceManager.getInstance().getResString("FAIL_TO_GET_EXTERNAL_FTP_SERVER_INFO"), 0);
            return false;
        }
        return true;
    }
}

