/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeButtonInfo;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreeToolBarModel;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.CommonPolicyDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;

public class CreatePolicyDlg
extends DCModalDialog {
    private static final long serialVersionUID = -5367931911081105215L;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private DeviceSelectionPanel m_oDeviceSelectionPanel;
    private JButton m_oNextBtn;
    private CommonPolicyDlg m_oPolicyDlg = null;
    private PolicyInfo m_oPolicy = null;
    private DeviceType m_oSelDeviceType = null;
    private int m_iCmdType = 0;
    private static final int STATIC_POLICY_ID = -1;

    public CreatePolicyDlg(int iCmdType, PolicyInfo oPolicy, DeviceType oDevType) {
        this.m_iCmdType = iCmdType;
        this.m_oPolicy = oPolicy;
        this.m_oSelDeviceType = oDevType;
        this.initGUI();
        this.addComponent();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new GridBagLayout());
        switch (this.m_iCmdType) {
            case 0: {
                this.setTitle(this.m_oRes.getResString("POLICY_CREATE_SELECT_NE_DLG_TLE"));
                break;
            }
            case 2: {
                this.setTitle(this.m_oRes.getResString("POLICY_MODIFY_SELECT_NE_DLG_TLE"));
                break;
            }
            default: {
                this.setTitle(this.m_oRes.getResString("POLICY_CREATE_SELECT_NE_DLG_TLE"));
            }
        }
        this.setResizable(true);
        this.setSize(new Dimension(730, 450));
        this.setMinimumSize(new Dimension(730, 450));
        this.createDeviceSelectionPanel();
        this.createButtons();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void addComponent() {
        this.m_oDeviceSelectionPanel.setPreferredSize(new Dimension(670, 311));
        this.m_oDeviceSelectionPanel.setMinimumSize(new Dimension(670, 311));
        this.m_oNextBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oNextBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(90, 21));
        this.getContentPane().add((Component)this.m_oDeviceSelectionPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oNextBtn, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(12, 10, 12, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(12, 10, 12, 12), 0, 0));
    }

    private void createDeviceSelectionPanel() {
        try {
            this.m_oDeviceSelectionPanel = new DeviceSelectionPanel(this.generateToolBarModelForTreePanel(), true, 3, true, ResourceManager.getInstance().getResString("DEVICE_TREE_PAN_ROOT_NODE"), -2);
            if (null != this.m_oSelDeviceType) {
                this.m_oDeviceSelectionPanel.initializePanelForDeviceType(this.m_oSelDeviceType, -1, 0);
            }
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("DC::createDeviceSelectionPanel::throw exception::" + e.getMessage());
            return;
        }
    }

    private void createButtons() {
        this.createNextButton();
        this.createCancelButton();
    }

    private void createNextButton() {
        this.m_oNextBtn = new JButton();
        this.m_oNextBtn.setName("Policy_UserDefinedPolicyDlg_m_oNextBtn");
        this.m_oNextBtn.setMnemonic('N');
        this.m_oNextBtn.setText(this.m_oRes.getResString("POLICY_INFO_NEXT_BUTTON"));
        this.m_oNextBtn.setEnabled(true);
        this.m_oNextBtn.setVisible(true);
        this.m_oNextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreatePolicyDlg.this.nextButton_ActionPerformed();
            }
        });
    }

    private void createCancelButton() {
        this.m_oCancelBtn.setText(this.m_oRes.getResString("CANCEL_BUTTON"));
        this.m_oCancelBtn.setName("Policy_UserDefinedPolicyDlg_m_oCancelBtn");
    }

    private DeviceTreeToolBarModel generateToolBarModelForTreePanel() {
        DeviceTreeToolBarModel oButtonModel = new DeviceTreeToolBarModel();
        if (!DCFrameWorkUtil.getIsSingleClient() || DCFrameWorkUtil.isShowSubMap()) {
            DeviceTreeButtonInfo oSubmapButton = new DeviceTreeButtonInfo(1);
            oButtonModel.addButton(oSubmapButton);
        }
        DeviceTreeButtonInfo oDeviceButton = new DeviceTreeButtonInfo(0);
        oButtonModel.addButton(oDeviceButton);
        oButtonModel.addVerticalSeperator();
        DeviceTreeButtonInfo oImportButton = new DeviceTreeButtonInfo(6);
        oButtonModel.addButton(oImportButton);
        DeviceTreeButtonInfo oExportButton = new DeviceTreeButtonInfo(7);
        oButtonModel.addButton(oExportButton);
        return oButtonModel;
    }

    private void nextButton_ActionPerformed() {
        if (!this.initDevForPolicy()) {
            return;
        }
        if (!this.isExist()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NOT_FIND_DEVICE_POLICY"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 2);
            return;
        }
        this.dispose();
        if (null == this.m_oPolicyDlg) {
            this.m_oPolicyDlg = new CommonPolicyDlg(this.m_iCmdType, this.m_oPolicy, this);
        }
        this.m_oPolicyDlg.setVisible(true);
    }

    private boolean isExist() {
        int i;
        boolean isExist = true;
        Resource[] oResources = null;
        List<PolicyDevTypeProperties> oDevProLst = null;
        HashMap<Integer, PolicyDevTypeProperties> policyMap = new HashMap<Integer, PolicyDevTypeProperties>();
        if (null == this.m_oDeviceSelectionPanel) {
            return false;
        }
        oResources = this.m_oDeviceSelectionPanel.getCurrentDevices();
        if (null != this.m_oPolicy) {
            oDevProLst = PolicyManager.getInstance().getPolicyInfo(-1).getPolicyDevTypePropLst();
            if (null == oDevProLst) {
                return false;
            }
            for (i = 0; i < oDevProLst.size(); ++i) {
                PolicyDevTypeProperties policyProp = oDevProLst.get(i);
                policyMap.put(policyProp.getDevTypeID(), policyProp);
            }
        } else {
            return false;
        }
        for (i = 0; i < oResources.length; ++i) {
            DeviceTypeInfo deviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByDevId(oResources[i].getDeviceID());
            if (policyMap.containsKey(deviceTypeInfo.getDevTypeID())) continue;
            return false;
        }
        return isExist;
    }

    private boolean initDevForPolicy() {
        Resource[] oResources;
        if (null == this.m_oPolicy) {
            this.m_oPolicy = new PolicyInfo();
            this.m_oPolicy.setPolicyID(-1);
        }
        if (null == (oResources = this.m_oDeviceSelectionPanel.getCurrentDevices()) || oResources.length == 0) {
            DCOptionPane.showErrorDialog((Component)((Object)this), this.m_oRes.getResString("NO_DEVICES_SELECTED"));
            return false;
        }
        int iDevID = 0;
        Resource oResource = null;
        THashMap oDevPolicyStateHm = new THashMap();
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DevicePolicyState oDevPolicyState = null;
        DeviceTypeInfo oDevType = null;
        DeviceInfo oDev = null;
        for (int i = 0; i < oResources.length; ++i) {
            oResource = oResources[i];
            iDevID = oResource.getDeviceID();
            oDevPolicyState = new DevicePolicyState();
            oDevPolicyState.setDevID(iDevID);
            oDevPolicyStateHm.put((Object)iDevID, (Object)oDevPolicyState);
            oDev = oDevMgr.getDevice(iDevID);
            if (null == oDev) continue;
            oDevPolicyState.setNEName(oDev.getDevName());
            oDevPolicyState.setIPAdress(oDev.getDevIPAddress());
            oDevType = oDev.getDeviceTypeInfo();
            oDevPolicyState.setDevTypeID(oDevType.getDevTypeID());
            oDevPolicyState.setDevTypeVerID(oDevType.getDevTypeVersionId());
            oDevPolicyState.setNETypeName(oDevType.getDevTypeName());
        }
        this.m_oPolicy.setDevicePolicyStateHm((THashMap<Integer, DevicePolicyState>)oDevPolicyStateHm);
        return true;
    }

    public PolicyInfo getPolicy() {
        return this.m_oPolicy;
    }

    public void setPolicy(PolicyInfo mOPolicy) {
        this.m_oPolicy = mOPolicy;
    }

    @Override
    protected String getCurrentContext() {
        String sKey = "";
        switch (this.m_iCmdType) {
            case 0: {
                sKey = "HELP_TOPIC_POLICY_CREATE";
                break;
            }
            case 2: {
                sKey = "HELP_TOPIC_POLICY_MODIFY";
                break;
            }
        }
        return sKey;
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
        this.m_oSelDeviceType.clearResources();
        this.m_oSelDeviceType = null;
        this.m_oDeviceSelectionPanel.disposePanel();
    }
}

