/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import com.huawei.dc.policy.view.BasicPolicyPanel;
import com.huawei.dc.policy.view.CreatePolicyDlg;
import com.huawei.dc.policy.view.advanced.AdvancedSettingDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CommonPolicyDlg
extends DCModalDialog {
    private static final long serialVersionUID = 4991342281918752018L;
    private JLabel m_oPolicyNameLbl = null;
    private JTextField m_oPolicyNameTextField = null;
    private BasicPolicyPanel oBackupBasePolicyPanel = null;
    private BasicPolicyPanel oSaveBasePolicyPanel = null;
    private JLabel m_oHighPropertiesLbl = null;
    private JLabel m_oBackupAndSaveLbl = null;
    private JButton m_oHighPropertiesBtn = null;
    private JSeparator m_oSeparator = null;
    private JPanel m_oButtonPnl = null;
    private PolicyInfo m_oPolicyInfo = null;
    private JButton m_oPreBtn = null;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private CreatePolicyDlg m_oCreatePolicyDlg = null;
    private int m_iCmdType = 0;

    public CommonPolicyDlg(PolicyInfo oPolicyInfo, int iCmdType) {
        this.m_oPolicyInfo = oPolicyInfo;
        this.m_iCmdType = iCmdType;
        this.initGUI();
    }

    public CommonPolicyDlg(int iCmdType, PolicyInfo oPolicyInfo, CreatePolicyDlg oCreatePolicyDlg) {
        this.m_iCmdType = iCmdType;
        this.m_oPolicyInfo = oPolicyInfo;
        this.m_oCreatePolicyDlg = oCreatePolicyDlg;
        this.initGUI();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponent();
        this.addComponent();
        this.initData(this.m_oPolicyInfo);
        this.enableComponent(this.m_iCmdType != 1);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initComponent() {
        String sDlgTitle = "";
        switch (this.m_iCmdType) {
            case 0: {
                sDlgTitle = this.m_oRes.getResString("POLICY_CREATE_SET_DLG_TLE");
                break;
            }
            case 1: {
                sDlgTitle = this.m_oRes.getResString("POLICY_VIEW_DLG_TLE");
                break;
            }
            case 2: {
                sDlgTitle = this.m_oRes.getResString("POLICY_MODIFY_DLG_TLE");
                break;
            }
        }
        this.setTitle(sDlgTitle);
        this.m_oPolicyNameLbl = new JLabel(this.m_oRes.getResString("POLICY_NAME_LBL"));
        this.m_oPolicyNameTextField = new JTextField();
        this.m_oPolicyNameTextField.setName("CommonPolicyDlg_m_oPolicyNameTextField");
        this.oBackupBasePolicyPanel = new BasicPolicyPanel(this.m_oPolicyInfo, 0);
        this.oSaveBasePolicyPanel = new BasicPolicyPanel(this.m_oPolicyInfo, 1);
        this.m_oBackupAndSaveLbl = new JLabel(StringUtils.getHtmlString(this.m_oRes.getResString("BACKUP_SAVE_DEFAULT_TIME")));
        this.m_oHighPropertiesLbl = new JLabel(StringUtils.getHtmlString(this.m_oRes.getResString("POLICY_ADVANCED_SETTINGS_LBL")));
        this.m_oHighPropertiesBtn = new JButton();
        this.m_oHighPropertiesBtn.setText(this.m_oRes.getResString("POLICY_ADVANCED_SETTINGS_BTN"));
        this.m_oHighPropertiesBtn.setMnemonic('S');
        this.m_oHighPropertiesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonPolicyDlg.this.handleHighPropertiesBtnAction();
            }
        });
        this.m_oSeparator = new JSeparator(0);
        this.initButtonPanel();
    }

    private void initButtonPanel() {
        DCDebugTracer.trace("Entering initButtonPanel");
        this.m_oPreBtn = new JButton();
        this.m_oPreBtn.setText(this.m_oRes.getResString("POLICY_INFO_PREVIOUS_BUTTON"));
        this.m_oPreBtn.setMnemonic('P');
        this.m_oPreBtn.setMaximumSize(new Dimension(90, 21));
        this.m_oPreBtn.setMinimumSize(new Dimension(90, 21));
        this.m_oPreBtn.setPreferredSize(new Dimension(90, 21));
        this.m_oPreBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonPolicyDlg.this.preBtnEventHandle();
            }
        });
        this.m_oButtonPnl = new JPanel();
        this.m_oOKBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(this.m_oRes.getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(this.m_oRes.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oButtonPnl.setPreferredSize(new Dimension(300, 21));
        this.m_oButtonPnl.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oButtonPnl.setLayout(flowLayout);
        flowLayout.setVgap(0);
        if (!(null != this.m_oPolicyInfo && this.m_iCmdType == 1 || null != this.m_oPolicyInfo && this.m_oPolicyInfo.getPolicyID() == 0 && this.m_iCmdType == 2)) {
            this.m_oButtonPnl.add(this.m_oPreBtn);
        }
        this.m_oButtonPnl.add(this.m_oOKBtn);
        this.m_oButtonPnl.add(this.m_oCancelBtn);
    }

    private void alignComponent() {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(850, 550));
        this.m_oPolicyNameLbl.setPreferredSize(new Dimension(150, 20));
        this.m_oPolicyNameLbl.setMinimumSize(new Dimension(150, 20));
        this.m_oPolicyNameTextField.setPreferredSize(new Dimension(200, 20));
        this.m_oPolicyNameTextField.setMinimumSize(new Dimension(200, 20));
        this.oBackupBasePolicyPanel.setPreferredSize(new Dimension(480, 150));
        this.oBackupBasePolicyPanel.setMinimumSize(new Dimension(480, 150));
        this.oSaveBasePolicyPanel.setPreferredSize(new Dimension(480, 150));
        this.oSaveBasePolicyPanel.setMinimumSize(new Dimension(480, 150));
        this.m_oHighPropertiesLbl.setPreferredSize(new Dimension(500, 50));
        this.m_oHighPropertiesLbl.setMinimumSize(new Dimension(500, 50));
        this.m_oBackupAndSaveLbl.setPreferredSize(new Dimension(500, 50));
        this.m_oBackupAndSaveLbl.setMinimumSize(new Dimension(500, 50));
        this.m_oHighPropertiesBtn.setPreferredSize(new Dimension(150, 21));
        this.m_oHighPropertiesBtn.setMinimumSize(new Dimension(150, 21));
        this.m_oSeparator.setPreferredSize(new Dimension(150, 5));
        this.m_oSeparator.setMinimumSize(new Dimension(150, 5));
    }

    private void addComponent() {
        JPanel oPolicyNamePanel = new JPanel();
        oPolicyNamePanel.add(this.m_oPolicyNameLbl);
        oPolicyNamePanel.add(this.m_oPolicyNameTextField);
        int i = 0;
        this.add(oPolicyNamePanel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add(this.m_oBackupAndSaveLbl, new GridBagConstraints(0, ++i, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.oBackupBasePolicyPanel, new GridBagConstraints(0, ++i, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.oSaveBasePolicyPanel, new GridBagConstraints(0, ++i, 2, 1, 1.0, 0.0, 17, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oHighPropertiesLbl, new GridBagConstraints(0, ++i, 2, 1, 0.0, 0.0, 17, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oHighPropertiesBtn, new GridBagConstraints(0, i, 2, 2, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add(this.m_oSeparator, new GridBagConstraints(0, ++i, 2, 1, 0.0, 0.0, 13, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oButtonPnl, new GridBagConstraints(0, ++i, 2, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 7), 0, 0));
    }

    private void initData(PolicyInfo oPolicyInfo) {
        if (this.m_iCmdType != 0) {
            String sPolicyName = oPolicyInfo.getPolicyName();
            this.m_oPolicyNameTextField.setText(sPolicyName);
        }
        if (oPolicyInfo.isDefaultPolicy() && this.m_iCmdType == 2) {
            this.m_oPolicyNameTextField.setEnabled(false);
        }
        if (null == this.m_oPolicyInfo.getPolicyDevTypePropLst() || this.m_oPolicyInfo.getPolicyDevTypePropLst().size() == 0) {
            List<PolicyDevTypeProperties> oDevProLst = PolicyManager.getInstance().getDeVTypeProList(-1);
            ArrayList<String> oStrDevTypeNameLst = new ArrayList<String>();
            DeviceTypeInfo[] oDevIDLst = DeviceInfoManagerImpl.getInstance().getExistDeviceTypes();
            if (null != oDevIDLst) {
                for (DeviceTypeInfo tmpDeviceTypeInfo : oDevIDLst) {
                    String strDevTypeName;
                    if (tmpDeviceTypeInfo == null || oStrDevTypeNameLst.contains(strDevTypeName = tmpDeviceTypeInfo.getDevTypeName())) continue;
                    oStrDevTypeNameLst.add(strDevTypeName);
                }
            }
            ArrayList<PolicyDevTypeProperties> oDevProLstForCurPolicy = new ArrayList<PolicyDevTypeProperties>();
            for (int i = 0; i < oDevProLst.size(); ++i) {
                PolicyDevTypeProperties oPolicyDevTypeProperties = oDevProLst.get(i);
                for (int j = 0; j < oStrDevTypeNameLst.size(); ++j) {
                    if (!oPolicyDevTypeProperties.getDevTypeName().equals(oStrDevTypeNameLst.get(j)) || oDevProLstForCurPolicy.contains(oPolicyDevTypeProperties)) continue;
                    oDevProLstForCurPolicy.add(oPolicyDevTypeProperties);
                }
                if (oDevProLstForCurPolicy.size() == oStrDevTypeNameLst.size()) break;
            }
            List oCloneProLst = (List)CloneUtil.getClone(oDevProLstForCurPolicy);
            this.m_oPolicyInfo.setPolicyDevTypePropLst(oCloneProLst);
        }
    }

    public void reinitBtnPanel() {
        this.m_oOKBtn.setText(this.m_oRes.getResString("POLICY_INFO_FINISH_BUTTON"));
        this.m_oButtonPnl.add(this.m_oPreBtn);
        this.m_oButtonPnl.repaint();
    }

    private void preBtnEventHandle() {
        List<PolicyTypeInfo> oBackupPolicyTypeInfo = this.oBackupBasePolicyPanel.getPolicyTypeInfoList();
        List<PolicyTypeInfo> oSavePolicyTypeInfo = this.oSaveBasePolicyPanel.getPolicyTypeInfoList();
        ArrayList<PolicyTypeInfo> oPolicyTypeInfoLst = new ArrayList<PolicyTypeInfo>();
        oPolicyTypeInfoLst.addAll(oBackupPolicyTypeInfo);
        oPolicyTypeInfoLst.addAll(oSavePolicyTypeInfo);
        this.m_oPolicyInfo.setPolicyTypeInfoLst(oPolicyTypeInfoLst);
        this.setVisible(false);
        if (null != this.m_oCreatePolicyDlg) {
            this.m_oCreatePolicyDlg.setVisible(true);
        }
    }

    private boolean validateSelectDay(PolicyTypeInfo mPolicyTypeInfo) {
        boolean result = true;
        if (null == mPolicyTypeInfo) {
            return false;
        }
        if (mPolicyTypeInfo.getPolicyPeriod() == 0) {
            return mPolicyTypeInfo.getPolicyDayInMonth() >= 0 && mPolicyTypeInfo.getPolicyDayInMonth() <= 31;
        }
        if (mPolicyTypeInfo.getPolicyPeriod() == 1) {
            return mPolicyTypeInfo.getPolicyDayInWeek() >= 0 && mPolicyTypeInfo.getPolicyDayInWeek() <= 6;
        }
        return result;
    }

    private boolean validatePolicyTime(PolicyTypeInfo mPolicyTypeInfo) {
        if (null == mPolicyTypeInfo) {
            return false;
        }
        String startTime = mPolicyTypeInfo.getPolicyTime();
        String endTime = mPolicyTypeInfo.getEndTime();
        if (null == endTime || "".equals(endTime)) {
            return true;
        }
        return this.parseTime(endTime) - this.parseTime(startTime) > 0;
    }

    private int parseTime(String time) {
        int realTime = 0;
        String hour = time.substring(0, 2);
        String minute = time.substring(3);
        realTime = Integer.parseInt(hour) * 60 + Integer.parseInt(minute);
        return realTime;
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (this.m_iCmdType == 1) {
            this.dispose();
            return;
        }
        this.m_oPolicyInfo.setPolicyDevTypePropLst(PolicyManager.getInstance().getPolicyInfo(this.m_oPolicyInfo.getPolicyID()).getPolicyDevTypePropLst());
        this.m_oPolicyInfo.setPolicyName(this.m_oPolicyNameTextField.getText());
        if (!this.m_oPolicyInfo.isDefaultPolicy() && !this.isPolicyNameValid()) {
            return;
        }
        List<PolicyTypeInfo> oBackupPolicyTypeInfo = this.oBackupBasePolicyPanel.getPolicyTypeInfoList();
        List<PolicyTypeInfo> oSavePolicyTypeInfo = this.oSaveBasePolicyPanel.getPolicyTypeInfoList();
        if (!this.validatePolicyTime(oBackupPolicyTypeInfo.get(0)) || !this.validatePolicyTime(oSavePolicyTypeInfo.get(0))) {
            DCOptionPane.showErrorDialog((Component)((Object)this), this.m_oRes.getResString("INVALIDATE_TIME"));
            return;
        }
        if (!this.validateSelectDay(oBackupPolicyTypeInfo.get(0)) || !this.validateSelectDay(oSavePolicyTypeInfo.get(0))) {
            DCOptionPane.showErrorDialog((Component)((Object)this), this.m_oRes.getResString("NOT_SELECT_DATE"));
            return;
        }
        ArrayList<PolicyTypeInfo> oPolicyTypeLst = new ArrayList<PolicyTypeInfo>();
        oPolicyTypeLst.addAll(oBackupPolicyTypeInfo);
        oPolicyTypeLst.addAll(oSavePolicyTypeInfo);
        if (this.isPolicyTimeInSameDay(oBackupPolicyTypeInfo, oSavePolicyTypeInfo) && !this.isPolicyTimeValid(oBackupPolicyTypeInfo, oSavePolicyTypeInfo)) {
            return;
        }
        this.m_oPolicyInfo.setPolicyTypeInfoLst(oPolicyTypeLst);
        PolicyManager.getInstance().createOrModifyPolicy(this.m_iCmdType, this.m_oPolicyInfo);
        this.dispose();
        if (null != this.m_oCreatePolicyDlg) {
            this.m_oCreatePolicyDlg.dispose();
        }
    }

    private boolean isPolicyNameValid() {
        String sPoicyName = this.m_oPolicyNameTextField.getText();
        boolean bPolicyNameValid = StringUtils.isNullOrEmptyStr(sPoicyName);
        if (bPolicyNameValid) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_NAME_NULL_CHECK"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
            return false;
        }
        boolean isPolicyNameValidName = sPoicyName.matches("[-\\w|\\u4e00-\\u9fa5|\\p{Space}]+");
        if (!isPolicyNameValidName) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_NAME_TIP"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
            return false;
        }
        List<PolicyInfo> oPolicyInfoLst = PolicyManager.getInstance().getPolicyInfoLst();
        String sExistName = "";
        Collator oCol = Collator.getInstance();
        if (null != oPolicyInfoLst) {
            for (PolicyInfo oPolicy : oPolicyInfoLst) {
                if (null == oPolicy || oPolicy.getPolicyID() == this.m_oPolicyInfo.getPolicyID() && this.m_oPolicyInfo.getPolicyID() != -1 || !oCol.equals(sPoicyName, sExistName = oPolicy.getPolicyName())) continue;
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_NAME_ALREADY_EXIST"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
                return false;
            }
        }
        if (sPoicyName.trim().length() > 50) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_NAME_TIP"), DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE"), 0);
            return false;
        }
        return true;
    }

    private boolean isPolicyTimeValid(List<PolicyTypeInfo> oBackupPolicyTypeInfo, List<PolicyTypeInfo> oSavePolicyTypeInfo) {
        boolean bValid = true;
        String sBackupTime = oBackupPolicyTypeInfo.get(0).getPolicyTime();
        String sSaveTime = oSavePolicyTypeInfo.get(0).getPolicyTime();
        if (Collator.getInstance().equals(sBackupTime, sSaveTime)) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("POLICY_TIME_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            bValid = false;
        }
        return bValid;
    }

    private boolean isPolicyTimeInSameDay(List<PolicyTypeInfo> oBackupPolicyTypeInfo, List<PolicyTypeInfo> oSavePolicyTypeInfo) {
        int iSavePeriod;
        boolean bValid = false;
        int iBackupPeriod = oBackupPolicyTypeInfo.get(0).getPolicyPeriod();
        if (iBackupPeriod != (iSavePeriod = oSavePolicyTypeInfo.get(0).getPolicyPeriod())) {
            return true;
        }
        if (iBackupPeriod == 0) {
            for (int i = 0; i < oBackupPolicyTypeInfo.size(); ++i) {
                int iDayInWeek = oBackupPolicyTypeInfo.get(i).getPolicyDayInMonth();
                for (int j = 0; j < oSavePolicyTypeInfo.size(); ++j) {
                    int jDayInWeek = oSavePolicyTypeInfo.get(j).getPolicyDayInMonth();
                    if (iDayInWeek != jDayInWeek) continue;
                    return true;
                }
            }
        } else if (iBackupPeriod == 1) {
            for (int i = 0; i < oBackupPolicyTypeInfo.size(); ++i) {
                int iDayInWeek = oBackupPolicyTypeInfo.get(i).getPolicyDayInWeek();
                for (int j = 0; j < oSavePolicyTypeInfo.size(); ++j) {
                    int jDayInWeek = oSavePolicyTypeInfo.get(j).getPolicyDayInWeek();
                    if (iDayInWeek != jDayInWeek) continue;
                    return true;
                }
            }
        } else if (iBackupPeriod == 2) {
            return true;
        }
        return bValid;
    }

    private void enableComponent(boolean bEnable) {
        if (bEnable) {
            return;
        }
        this.m_oPolicyNameTextField.setEnabled(bEnable);
        this.oBackupBasePolicyPanel.enableComponent(bEnable);
        this.oSaveBasePolicyPanel.enableComponent(bEnable);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SETTING_POLICY";
    }

    private void handleHighPropertiesBtnAction() {
        final AdvancedSettingDlg oDlg = new AdvancedSettingDlg(this.m_oPolicyInfo, this.m_iCmdType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oDlg.setVisible(true);
            }
        });
    }
}

