/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.view;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.policy.controller.PolicyConstants;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import com.huawei.dc.policy.view.PolicyDaySelectDayDlg;
import com.swimap.imap12.util.dateChooser.InmDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class BasicPolicyPanel
extends JPanel {
    private static final long serialVersionUID = -2808109370918383293L;
    private int m_iPolicyType = 0;
    private PolicyTypeInfo m_oPolicyTypeInfo = null;
    private PolicyInfo mPolicyInfo = null;
    private JLabel m_oPolicyTypeLbl = null;
    private JLabel m_oPeriodLbl = null;
    private JLabel m_oDayLbl = null;
    private JLabel mTimeLabel = null;
    private JLabel mStartTimeLbl = null;
    private JLabel mEndTimeLbl = null;
    private JLabel m_oPolicyStatusLbl = null;
    private JCheckBox mEnableEndTimeChoose = null;
    private JComboBox m_oPeriodCombox = null;
    private JTextField mSelectDay = null;
    private InmDateChooser mStartTimeChooser = null;
    private InmDateChooser mEndTimeChooser = null;
    private JButton mSelectButton = null;
    private PolicyDaySelectDayDlg mSelectDayList = null;
    private JRadioButton oRunPolicyStatusRadioBtn = null;
    private JRadioButton oStopPolicyStatusRadioBtn = null;
    private ButtonGroup m_oRadioBtnGroup = null;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private String sMonthPeriod = this.m_oRes.getResString("POLICY_PERIOD_MONTHLY");
    private String sWeekPeriod = this.m_oRes.getResString("POLICY_PERIOD_WEEKLY");
    private String sDayPeriod = this.m_oRes.getResString("POLICY_PERIOD_DAILY");
    private static final int[] DEFAULT_DAY = new int[]{-1};

    public BasicPolicyPanel(PolicyTypeInfo oPolicyTypeInfo, int iPolicyType) {
        this.m_oPolicyTypeInfo = oPolicyTypeInfo;
        this.m_iPolicyType = iPolicyType;
        this.initGUI();
        this.initData(this.m_oPolicyTypeInfo);
        this.addActionListener();
    }

    public BasicPolicyPanel(PolicyInfo oPolicyInfo, int iPolicyType) {
        this.mPolicyInfo = oPolicyInfo;
        this.m_oPolicyTypeInfo = oPolicyInfo.getPolicyTypeInfo(iPolicyType);
        this.m_iPolicyType = iPolicyType;
        this.initGUI();
        this.initData(this.m_oPolicyTypeInfo);
        this.addActionListener();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponent();
        this.addComponent();
    }

    private void initComponent() {
        String sBorderTitle = "";
        String sPeridLbl = "";
        if (this.m_iPolicyType == 0) {
            sBorderTitle = this.m_oRes.getResString("POLICY_BORDER_TITLE_BACKUP");
            sPeridLbl = this.m_oRes.getResString("BACKUP_PERIOD_LBL");
        } else if (this.m_iPolicyType == 1) {
            sBorderTitle = this.m_oRes.getResString("POLICY_BORDER_TITLE_SAVE");
            sPeridLbl = this.m_oRes.getResString("SAVE_PERIOD_LBL");
        }
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, PolicyConstants.PANEL_BORDER_COLOR), sBorderTitle);
        this.setBorder(oBorder);
        this.m_oPolicyTypeLbl = new JLabel(sPeridLbl);
        this.m_oPeriodLbl = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_PERIOD_LBL"));
        this.m_oDayLbl = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_DATE_LBL"));
        this.mTimeLabel = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_TIME_LBL"));
        this.mStartTimeLbl = new JLabel(this.m_oRes.getResString("START_TIME"));
        this.mEndTimeLbl = new JLabel(this.m_oRes.getResString("END_TIME"));
        this.m_oPolicyStatusLbl = new JLabel(this.m_oRes.getResString("POLICY_STATUS_LABEL"));
        this.mSelectDay = new JTextField();
        this.mSelectDay.setText("");
        this.mSelectDay.setEditable(false);
        this.mSelectButton = new JButton("...");
        this.enableSelectButton();
        this.mSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicPolicyPanel.this.getSelectDay();
            }
        });
        this.mEnableEndTimeChoose = new JCheckBox();
        this.mEnableEndTimeChoose.setSelected(false);
        this.mEnableEndTimeChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicPolicyPanel.this.enableEndTimeChooser();
            }
        });
        this.m_oPeriodCombox = new JComboBox();
        this.m_oPeriodCombox.setName("policy_BasicPolicyPanel_m_oPeriodCombox");
        this.m_oPeriodCombox.setName("policy_BasicPolicyPanel_m_oDayCombox");
        this.mStartTimeChooser = !DCTimeDateUtil.is12HrFormat() ? new InmDateChooser(6) : new InmDateChooser(14);
        this.mStartTimeChooser.setName("policy_BasicPolicyPanel_m_oTimeChooser");
        this.mEndTimeChooser = !DCTimeDateUtil.is12HrFormat() ? new InmDateChooser(6) : new InmDateChooser(14);
        this.mEndTimeChooser.setName("policy_BasicPolicyPanel_m_oTimeChooser");
        this.mEndTimeChooser.setEnabled(false);
        this.oRunPolicyStatusRadioBtn = new JRadioButton();
        this.oRunPolicyStatusRadioBtn.setName("policy_BasicPolicyPanel_oRunPolicyStatusRadioBtn");
        this.oRunPolicyStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_RUN"));
        this.oStopPolicyStatusRadioBtn = new JRadioButton();
        this.oStopPolicyStatusRadioBtn.setName("policy_BasicPolicyPanel_oStopPolicyStatusRadioBtn");
        this.oStopPolicyStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_STOP"));
        this.m_oRadioBtnGroup = new ButtonGroup();
        this.m_oRadioBtnGroup.add(this.oRunPolicyStatusRadioBtn);
        this.m_oRadioBtnGroup.add(this.oStopPolicyStatusRadioBtn);
    }

    private void alignComponent() {
        this.setLayout(new GridBagLayout());
        this.m_oPolicyTypeLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oPolicyTypeLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oPeriodLbl.setPreferredSize(new Dimension(50, 20));
        this.m_oPeriodLbl.setMinimumSize(new Dimension(50, 20));
        this.m_oDayLbl.setPreferredSize(new Dimension(50, 20));
        this.m_oDayLbl.setMinimumSize(new Dimension(50, 20));
        this.mTimeLabel.setPreferredSize(new Dimension(130, 20));
        this.mTimeLabel.setMinimumSize(new Dimension(130, 20));
        this.mStartTimeLbl.setPreferredSize(new Dimension(60, 20));
        this.mStartTimeLbl.setMinimumSize(new Dimension(60, 20));
        this.mEndTimeLbl.setPreferredSize(new Dimension(60, 20));
        this.mEndTimeLbl.setMinimumSize(new Dimension(60, 20));
        this.m_oPolicyStatusLbl.setPreferredSize(new Dimension(220, 20));
        this.m_oPolicyStatusLbl.setMinimumSize(new Dimension(220, 20));
        this.m_oPeriodCombox.setPreferredSize(new Dimension(160, 20));
        this.m_oPeriodCombox.setMinimumSize(new Dimension(160, 20));
        this.mSelectDay.setPreferredSize(new Dimension(160, 20));
        this.mSelectDay.setMinimumSize(new Dimension(160, 20));
        this.mSelectButton.setPreferredSize(new Dimension(20, 20));
        this.mSelectButton.setMinimumSize(new Dimension(20, 20));
        this.mEnableEndTimeChoose.setPreferredSize(new Dimension(40, 40));
        this.mEnableEndTimeChoose.setMinimumSize(new Dimension(40, 40));
        this.mStartTimeChooser.setPreferredSize(new Dimension(160, 21));
        this.mStartTimeChooser.setMinimumSize(new Dimension(160, 21));
        this.mEndTimeChooser.setPreferredSize(new Dimension(160, 21));
        this.mEndTimeChooser.setMinimumSize(new Dimension(160, 21));
    }

    private void addComponent() {
        this.add((Component)this.m_oPolicyTypeLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oPeriodLbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.m_oPeriodCombox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 10, 0, 80), 0, 0));
        this.add((Component)this.m_oDayLbl, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 5, 0, 12), 0, 0));
        this.add((Component)this.mSelectDay, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.mSelectButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.mTimeLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.mStartTimeLbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.mStartTimeChooser, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 10, 0, 0), 0, 0));
        this.add((Component)this.mEndTimeLbl, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 5, 0, 0), 0, 0));
        this.add((Component)this.mEndTimeChooser, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.mEnableEndTimeChoose, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.m_oPolicyStatusLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.oRunPolicyStatusRadioBtn, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.oStopPolicyStatusRadioBtn, new GridBagConstraints(3, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
    }

    private void getSelectDay() {
        this.mSelectDayList = new PolicyDaySelectDayDlg(this);
        this.mSelectDayList.setVisible(true);
    }

    public int getSelectType() {
        String sMonthPeriod = this.m_oRes.getResString("POLICY_PERIOD_MONTHLY");
        String sWeekPeriod = this.m_oRes.getResString("POLICY_PERIOD_WEEKLY");
        String selectText = this.m_oPeriodCombox.getSelectedItem().toString();
        if (selectText.equals(sMonthPeriod)) {
            return 0;
        }
        if (selectText.equals(sWeekPeriod)) {
            return 1;
        }
        return 1;
    }

    public void setSelectDay(String selectDays) {
        this.mSelectDay.setText(selectDays);
    }

    private void initData(PolicyTypeInfo oPolicyTypeInfo) {
        if (null == oPolicyTypeInfo) {
            this.initDefaultData();
            return;
        }
        this.m_oPeriodCombox.addItem(this.sMonthPeriod);
        this.m_oPeriodCombox.addItem(this.sWeekPeriod);
        this.m_oPeriodCombox.addItem(this.sDayPeriod);
        int iPolicyPeriod = oPolicyTypeInfo.getPolicyPeriod();
        this.m_oPeriodCombox.setSelectedIndex(iPolicyPeriod);
        int iPolicyStatus = oPolicyTypeInfo.getPolicyStatus();
        boolean bPolicyRun = iPolicyStatus == 0;
        this.oRunPolicyStatusRadioBtn.setSelected(bPolicyRun);
        this.oStopPolicyStatusRadioBtn.setSelected(!bPolicyRun);
        this.setPolicyTimeChooser(oPolicyTypeInfo.getPolicyTime(), this.mStartTimeChooser);
        this.setPolicyTimeChooser(oPolicyTypeInfo.getEndTime(), this.mEndTimeChooser);
        if (null == oPolicyTypeInfo.getEndTime() || "".equals(oPolicyTypeInfo.getEndTime())) {
            this.mEnableEndTimeChoose.setSelected(false);
            this.mEndTimeChooser.setEnabled(false);
        } else {
            this.mEnableEndTimeChoose.setSelected(true);
            this.mEndTimeChooser.setEnabled(true);
        }
        if (null == this.mPolicyInfo) {
            return;
        }
        this.setSelectDay(this.getSelectDayFromPolicyInfo());
        this.enableSelectButton();
    }

    private int[] getChooseDay() {
        String chooseDay = this.mSelectDay.getText();
        if (null == chooseDay || chooseDay.equals("")) {
            return DEFAULT_DAY;
        }
        String[] chooseDays = chooseDay.split(",");
        int[] days = new int[chooseDays.length];
        Object value = this.m_oPeriodCombox.getSelectedItem();
        if (value instanceof String) {
            if (value.toString().equals(this.sMonthPeriod)) {
                for (int i = 0; i < chooseDays.length; ++i) {
                    days[i] = Integer.parseInt(chooseDays[i]);
                }
            } else if (value.toString().equals(this.sWeekPeriod)) {
                for (int i = 0; i < chooseDays.length; ++i) {
                    days[i] = this.parseDayInWeek(chooseDays[i]);
                }
            }
            return days;
        }
        return DEFAULT_DAY;
    }

    private int parseDayInWeek(String weekDay) {
        int day = -1;
        if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_0"))) {
            day = 0;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_1"))) {
            day = 1;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_2"))) {
            day = 2;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_3"))) {
            day = 3;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_4"))) {
            day = 4;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_5"))) {
            day = 5;
        } else if (weekDay.equals(this.m_oRes.getResString("POLICY_WEEK_DAY_6"))) {
            day = 6;
        }
        return day;
    }

    private String getSelectDayFromPolicyInfo() {
        if (null == this.mPolicyInfo) {
            return "";
        }
        StringBuffer dayBuffer = new StringBuffer();
        List<PolicyTypeInfo> policyTypeInfoList = this.mPolicyInfo.getPolicyTypeInfoLst();
        if (null == policyTypeInfoList || policyTypeInfoList.size() == 0) {
            return "";
        }
        PolicyTypeInfo policyTypeInfo = null;
        for (int index = 0; index < policyTypeInfoList.size(); ++index) {
            policyTypeInfo = policyTypeInfoList.get(index);
            if (this.m_iPolicyType != policyTypeInfo.getPolicyType()) continue;
            if (policyTypeInfo.getPolicyPeriod() == 1) {
                int iDayInWeek = policyTypeInfo.getPolicyDayInWeek();
                dayBuffer.append(this.m_oRes.getResString("POLICY_WEEK_DAY_" + iDayInWeek));
            } else if (policyTypeInfo.getPolicyPeriod() == 0) {
                dayBuffer.append(policyTypeInfo.getPolicyDayInMonth());
            } else if (policyTypeInfo.getPolicyPeriod() == 2) {
                dayBuffer.append("");
            }
            dayBuffer.append(",");
        }
        if (dayBuffer.length() < 1) {
            return "";
        }
        return dayBuffer.substring(0, dayBuffer.length() - 1);
    }

    private void initDefaultData() {
        PolicyTypeInfo oDefaultPolicy = new PolicyTypeInfo();
        oDefaultPolicy.setPolicyPeriod(2);
        oDefaultPolicy.setPolicyStatus(0);
        String sPolicyTime = "";
        if (this.m_iPolicyType == 0) {
            sPolicyTime = "02:00";
        } else if (this.m_iPolicyType == 1) {
            sPolicyTime = "01:00";
        } else {
            sPolicyTime = "00:01";
            DCDebugTracer.trace("initDefaultData#m_iPolicyType =" + this.m_iPolicyType);
        }
        oDefaultPolicy.setPolicyTime(sPolicyTime);
        this.initData(oDefaultPolicy);
    }

    private void setPolicyTimeChooser(String policyTime, InmDateChooser timeChooser) {
        if (!timeChooser.is12_HourLock()) {
            timeChooser.getTextField().setText(policyTime);
        } else {
            if (null == policyTime || 0 == policyTime.length()) {
                policyTime = "00:01";
                DCDebugTracer.trace("setPolicyTimeChooser#policyTime is null,set to 00:01");
            }
            DCDebugTracer.trace("setPolicyTimeChooser:" + policyTime);
            Calendar oCalObj = timeChooser.getCalendar(true);
            String strHour = policyTime.substring(0, 2);
            int iHour = Integer.parseInt(strHour);
            String strMinute = policyTime.substring(3, 5);
            int iMinute = Integer.parseInt(strMinute);
            oCalObj.set(11, iHour);
            oCalObj.set(12, iMinute);
            timeChooser.setCalendar(oCalObj);
        }
    }

    private void addActionListener() {
        this.m_oPeriodCombox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BasicPolicyPanel.this.policyPeriodChanged();
            }
        });
    }

    public PolicyTypeInfo getPolicyTypeInfo(int periodDay) {
        PolicyTypeInfo oPolicyTypeInfo = new PolicyTypeInfo();
        oPolicyTypeInfo.setPolicyType(this.m_iPolicyType);
        int iPeriod = this.m_oPeriodCombox.getSelectedIndex();
        oPolicyTypeInfo.setPolicyPeriod(iPeriod);
        switch (iPeriod) {
            case 0: {
                oPolicyTypeInfo.setPolicyDayInMonth(periodDay);
                break;
            }
            case 1: {
                oPolicyTypeInfo.setPolicyDayInWeek(periodDay);
                break;
            }
        }
        String mStartTime = DCTimeDateUtil.convertTo24HrFormat(this.mStartTimeChooser.getText());
        if (this.mStartTimeChooser.isEnabled()) {
            oPolicyTypeInfo.setPolicyTime(mStartTime);
        } else {
            oPolicyTypeInfo.setPolicyTime("");
        }
        String mEndTime = DCTimeDateUtil.convertTo24HrFormat(this.mEndTimeChooser.getText());
        if (this.mEndTimeChooser.isEnabled()) {
            oPolicyTypeInfo.setEndTime(mEndTime);
        } else {
            oPolicyTypeInfo.setEndTime("");
        }
        int iStatus = this.oRunPolicyStatusRadioBtn.isSelected() ? 0 : 1;
        oPolicyTypeInfo.setPolicyStatus(iStatus);
        return oPolicyTypeInfo;
    }

    public List<PolicyTypeInfo> getPolicyTypeInfoList() {
        ArrayList<PolicyTypeInfo> policyTypeInfoList = new ArrayList<PolicyTypeInfo>();
        int[] days = this.getChooseDay();
        for (int i = 0; i < days.length; ++i) {
            PolicyTypeInfo policyTypeInfo = this.getPolicyTypeInfo(days[i]);
            policyTypeInfoList.add(policyTypeInfo);
        }
        return policyTypeInfoList;
    }

    private void policyPeriodChanged() {
        this.enableSelectButton();
        this.mSelectDay.setText("");
    }

    private void enableSelectButton() {
        if (null == this.m_oPolicyTypeInfo && null == this.m_oPeriodCombox) {
            this.mSelectButton.setEnabled(false);
        } else if (null == this.m_oPeriodCombox) {
            this.mSelectButton.setEnabled(false);
        } else {
            String iSelectedItem = this.m_oPeriodCombox.getSelectedItem().toString();
            if (iSelectedItem.equals(this.sDayPeriod)) {
                this.mSelectButton.setEnabled(false);
            } else {
                this.mSelectButton.setEnabled(true);
            }
        }
    }

    private void enableEndTimeChooser() {
        this.mEndTimeChooser.setEnabled(this.mEnableEndTimeChoose.isSelected());
    }

    public void enableComponent(boolean bEnable) {
        this.m_oPeriodCombox.setEnabled(bEnable);
        this.mSelectButton.setEnabled(false);
        this.mStartTimeChooser.setEnabled(false);
        this.mEndTimeChooser.setEnabled(false);
        this.mEnableEndTimeChoose.setEnabled(false);
        this.oRunPolicyStatusRadioBtn.setEnabled(false);
        this.oStopPolicyStatusRadioBtn.setEnabled(false);
    }
}

