/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMEventListener;
import com.huawei.dc.sam.event.SAMEvent;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ShowDeletedSoftwareLstDlg
extends DCModalDialog
implements ISAMEventListener {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel m_oTableModel;
    private JTable m_oTable;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private JScrollPane m_oTableScrollPane = new JScrollPane();
    private List<MxuPolicyInfo> m_oMxuPolicyLst = null;

    public ShowDeletedSoftwareLstDlg(List<MxuPolicyInfo> oMxuPolicyLst) {
        this.m_oMxuPolicyLst = oMxuPolicyLst;
        SAMManager.getInstance().addSAMEventListener(this);
        SAMManager.getInstance().registerForFileDeleteNtfn();
        this.setSize(500, 300);
        this.getContentPane().setLayout(null);
        this.setModal(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.getLocalisedString("DELETED_SOFTWARE_LIST"));
        this.jInit();
    }

    private void jInit() {
        JLabel oInfoLabel = new JLabel();
        String strText = StringUtils.getHtmlString(this.getLocalisedString("DELETED_SOFTWARE_INFO"));
        oInfoLabel.setText(strText);
        oInfoLabel.setBounds(10, 10, 480, 40);
        this.showDeletedFileInfo();
        this.m_oTableScrollPane.setBounds(0, 60, 495, 165);
        this.m_oTableScrollPane.setBorder(BorderFactory.createEtchedBorder());
        JButton oCloseBtn = new JButton(this.getLocalisedString("CLOSE"));
        oCloseBtn.setName("Policy_ShowDeletedSoftwareLstDlg_oCloseBtn");
        oCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                ShowDeletedSoftwareLstDlg.this.closeDialog();
            }
        });
        oCloseBtn.setBounds(380, 235, 80, 21);
        this.getContentPane().add(oCloseBtn);
        this.getContentPane().add(oInfoLabel);
        this.getContentPane().add(this.m_oTableScrollPane);
    }

    @Override
    public void closeDialog() {
        this.m_oTableModel = null;
        this.m_oTable = null;
        this.m_oResourceManager = null;
        this.m_oTableScrollPane = null;
        SAMManager.getInstance().removeSAMEventListener(this);
        super.closeDialog();
    }

    private void showDeletedFileInfo() {
        this.createTableModel();
        this.createTable();
        this.addDataToTable();
    }

    private void addDataToTable() {
        IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        String sSubmapName = "";
        String sDevType = "";
        String sDestVer = "";
        String sFileName = "";
        String sContentType = "";
        for (MxuPolicyInfo oMxuPolicy : this.m_oMxuPolicyLst) {
            SubMapInfo oSubMapInfo = oDevInfoMgr.getSubmapForID(oMxuPolicy.getSubmapId());
            sSubmapName = null != oSubMapInfo ? oSubMapInfo.m_strSubMapName : oMxuPolicy.getSubmapId();
            sDevType = oMxuPolicy.getDevTypeInfo().getDevTypeName() + "(" + oMxuPolicy.getDevTypeInfo().getDevTypeVersionName() + ")";
            sDestVer = oMxuPolicy.getUpgradeDevVersion();
            List<FileInfo> oUpgradeFileInfoLst = oMxuPolicy.getUpgradeFileInfoLst();
            for (FileInfo oFile : oUpgradeFileInfoLst) {
                Vector<String> v = new Vector<String>(5);
                sFileName = oFile.getFileName();
                sContentType = oFile.getContentType();
                v.add(sSubmapName);
                v.add(sDevType);
                v.add(sDestVer);
                v.add(sFileName);
                v.add(sContentType);
                this.m_oTableModel.addRow(v);
            }
        }
    }

    private void createTable() {
        this.m_oTable = new JTable(this.m_oTableModel){
            private static final long serialVersionUID = -2142386765059631316L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oTable.setName("Policy_ShowDeletedSoftwareLstDlg_m_oTable");
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTableScrollPane.getViewport().add(this.m_oTable);
        this.m_oTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oTableScrollPane.setHorizontalScrollBarPolicy(32);
        this.m_oTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oTable.setRowHeight(21);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
    }

    private void createTableModel() {
        Object[] arrColHeaders = new String[]{this.getLocalisedString("SEARCH_TABLE_SUBMAP"), this.getLocalisedString("TASK_TABLE_COLUMN_DEVICE_TYPE"), this.getLocalisedString("UPGRADE_VERSION"), this.getLocalisedString("TASK_TABLE_COLUMN_SOFTWARE_NAME"), this.getLocalisedString("CONTENT_TYPE")};
        this.m_oTableModel = new DefaultTableModel(arrColHeaders, 0);
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("HELP_TOPIC_DELETE_FILE_LIST", "helpmapfile");
    }

    private String getLocalisedString(String key) {
        return this.m_oResourceManager.getResString(key);
    }

    @Override
    public void onSAMEvent(SAMEvent oEvent) {
    }
}

