/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.policy.mxupolicy.MXUPolicyMainPanel;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.policy.mxupolicy.MxuPolicyTableMenuItemHandler;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MxuPolicyTablePopupManager {
    private MXUPolicyMainPanel m_oPolicyTablePanel = null;
    private HashMap m_oPolicyMenuMap;
    private static final String POLICY_TABLE_POPUP_MENU_FILE = "mxupolicytablepopupmenu";
    private JPopupMenu m_oPolicyTablePopupMenu;

    public MxuPolicyTablePopupManager(MxuPolicyTableMenuItemHandler oPolicyTableMenuItemHandler) {
        this.m_oPolicyTablePanel = oPolicyTableMenuItemHandler.getPolicyTablePanel();
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oPolicyTablePopupMenu = oPopupMenuManager.load(oPolicyTableMenuItemHandler, POLICY_TABLE_POPUP_MENU_FILE);
        this.m_oPolicyMenuMap = oPopupMenuManager.getMenuItemMap();
    }

    public JPopupMenu loadMenu() {
        this.enableAllMenuItem(true);
        this.setStartAndStopMenuItem();
        this.setModifymenuItemStates();
        return this.m_oPolicyTablePopupMenu;
    }

    private void setStartAndStopMenuItem() {
        int iStateRun = 0;
        int iStateStop = 0;
        int iStateNotConfig = 0;
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getTable();
        int[] arrRows = oPolicyTable.getSelectedRows();
        int iLength = arrRows.length;
        for (int index = 0; index < iLength; ++index) {
            Object oo = oPolicyTable.getValueAt(arrRows[index], 0);
            if (!(oo instanceof MxuPolicyInfo)) continue;
            MxuPolicyInfo oMxuPolicy = (MxuPolicyInfo)oPolicyTable.getValueAt(arrRows[index], 0);
            if (!oMxuPolicy.isConfig()) {
                ++iStateNotConfig;
                continue;
            }
            int iState = oMxuPolicy.getPolicyState();
            if (iState == 0) {
                ++iStateRun;
                continue;
            }
            ++iStateStop;
        }
        boolean bStartEnable = iStateRun != iLength && iStateRun + iStateNotConfig != iLength;
        boolean bStopEnable = iStateStop != iLength && iStateStop + iStateNotConfig != iLength;
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartMxuPolicy"), bStartEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopMxuPolicy"), bStopEnable);
    }

    private void setModifymenuItemStates() {
        List<MxuPolicyInfo> oSelectedMxuLst = this.m_oPolicyTablePanel.getSelecteDMxuPolicyLst();
        boolean bEnable = true;
        if (null == oSelectedMxuLst || oSelectedMxuLst.size() == 0) {
            bEnable = false;
        } else if (oSelectedMxuLst.size() == 1) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyMxuPolicy"), true);
        } else {
            MxuPolicyInfo oFirstMxuPolicy = oSelectedMxuLst.get(0);
            MxuPolicyInfo oTmpPolicy = null;
            for (int i = 1; i < oSelectedMxuLst.size(); ++i) {
                oTmpPolicy = oSelectedMxuLst.get(i);
                if (null == oTmpPolicy || oTmpPolicy.getDevTypeID() == oFirstMxuPolicy.getDevTypeID() && oTmpPolicy.getDevTypeVerID() == oFirstMxuPolicy.getDevTypeVerID()) continue;
                bEnable = false;
                break;
            }
        }
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ModifyMxuPolicy"), bEnable);
    }

    private void enableAllMenuItem(boolean bEnable) {
        for (String strMenuItemID : this.m_oPolicyMenuMap.keySet()) {
            JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
            MenuUtil.enableMenuItem((Component)oMenuItem, bEnable);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        return (JMenuItem)this.m_oPolicyMenuMap.get(strMenuItemID);
    }

    public boolean isMenuItemEnable(String sMenuItemID) {
        JMenuItem oMenuItem = this.getMenuItemForID(sMenuItemID);
        if (null != oMenuItem) {
            return oMenuItem.isEnabled();
        }
        return false;
    }
}

