/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.file.util.SaveAsFileUtil;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.mxupolicy.MXUPolicyMainPanel;
import com.huawei.dc.policy.mxupolicy.ModifyMxuPolicyDlg;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class MxuPolicyTableMenuItemHandler {
    private MXUPolicyMainPanel m_oPolicyTablePanel = null;
    private SaveAsFileUtil oSaveAsFileUtil = new SaveAsFileUtil();

    public MxuPolicyTableMenuItemHandler(MXUPolicyMainPanel oPolicyTablePanel) {
        this.m_oPolicyTablePanel = oPolicyTablePanel;
    }

    public MXUPolicyMainPanel getPolicyTablePanel() {
        return this.m_oPolicyTablePanel;
    }

    public void modifyMxuPolicy() {
        List<MxuPolicyInfo> oSelectedPolicyLst = this.m_oPolicyTablePanel.getSelecteDMxuPolicyLst();
        final ModifyMxuPolicyDlg oModifyDlg = new ModifyMxuPolicyDlg(this.m_oPolicyTablePanel, oSelectedPolicyLst);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oModifyDlg.setVisible(true);
            }
        });
    }

    public void startMxuPolicy() {
        List<MxuPolicyInfo> oSelectedPolicyLst = this.m_oPolicyTablePanel.getSelecteDMxuPolicyLst();
        for (MxuPolicyInfo oPolicy : oSelectedPolicyLst) {
            if (null == oPolicy) continue;
            oPolicy.setPolicyState(0);
        }
        PolicyManager.getInstance().setMxuInfoToServer(oSelectedPolicyLst);
    }

    public void stopMxuPolicy() {
        List<MxuPolicyInfo> oSelectedPolicyLst = this.m_oPolicyTablePanel.getSelecteDMxuPolicyLst();
        for (MxuPolicyInfo oPolicy : oSelectedPolicyLst) {
            if (null == oPolicy) continue;
            oPolicy.setPolicyState(1);
        }
        PolicyManager.getInstance().setMxuInfoToServer(oSelectedPolicyLst);
    }

    public void saveAsMxuPolicy() {
        ResourceManager oRes = ResourceManager.getInstance();
        String strFileName = this.oSaveAsFileUtil.getSelectFileName(oRes.getResString("POLICY_INFO"));
        if (null != strFileName) {
            this.savePolicyInfo(strFileName);
        }
    }

    private void savePolicyInfo(final String sFileName) {
        final String[] sTableHearders = this.getArrHeaderFields();
        final Vector oDataVct = this.getPolicyInfoVector();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MxuPolicyTableMenuItemHandler.this.oSaveAsFileUtil.saveAsInFile(oDataVct, ResourceManager.getInstance().getResString("POLICY_SAVE_HEARDER"), sTableHearders, sFileName);
            }
        });
    }

    private String[] getArrHeaderFields() {
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getTable();
        int columnCount = oPolicyTable.getColumnCount();
        int iOffset = 1;
        String[] arrHeaderFields = new String[columnCount - iOffset];
        for (int i = 0; i < columnCount - iOffset; ++i) {
            arrHeaderFields[i] = oPolicyTable.getColumnName(i + iOffset);
        }
        return arrHeaderFields;
    }

    private Vector getPolicyInfoVector() {
        Vector oDataVct = new Vector();
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getTable();
        int iRowCount = oPolicyTable.getRowCount();
        Vector<String> oRowVct = null;
        for (int i = 0; i < iRowCount; ++i) {
            oRowVct = new Vector<String>();
            oRowVct.add((String)oPolicyTable.getValueAt(i, 1));
            oRowVct.add((String)oPolicyTable.getValueAt(i, 2));
            oRowVct.add((String)oPolicyTable.getValueAt(i, 3));
            oRowVct.add((String)oPolicyTable.getValueAt(i, 4));
            oDataVct.add(oRowVct);
        }
        return oDataVct;
    }
}

