/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;

public class MxuPolicyInfo {
    private String sSubmapId = "";
    private int iDevTypeID = 0;
    private int iDevTypeVerID = 0;
    private String sUpgradeDevVersion = "";
    private List<FileInfo> oUpgradeFileInfoLst = new ArrayList<FileInfo>();
    private int iPolicyState = 1;

    public MxuPolicyInfo(String sSummapID, int iDevTypeID, int iDevTypeVerID) {
        this.sSubmapId = sSummapID;
        this.iDevTypeID = iDevTypeID;
        this.iDevTypeVerID = iDevTypeVerID;
    }

    public String getSubmapId() {
        return this.sSubmapId;
    }

    public void setSubmapId(String sSubmapId) {
        this.sSubmapId = sSubmapId;
    }

    public int getDevTypeID() {
        return this.iDevTypeID;
    }

    public void setDevTypeID(int iDevTypeID) {
        this.iDevTypeID = iDevTypeID;
    }

    public int getDevTypeVerID() {
        return this.iDevTypeVerID;
    }

    public void setDevTypeVerID(int iDevTypeVerID) {
        this.iDevTypeVerID = iDevTypeVerID;
    }

    public String getUpgradeDevVersion() {
        return this.sUpgradeDevVersion;
    }

    public void setUpgradeDevVersion(String sUpgradeDevVersion) {
        this.sUpgradeDevVersion = sUpgradeDevVersion;
    }

    public List<FileInfo> getUpgradeFileInfoLst() {
        return this.oUpgradeFileInfoLst;
    }

    public void setUpgradeFileInfoLst(List<FileInfo> oUpgradeFileInfoLst) {
        this.oUpgradeFileInfoLst = oUpgradeFileInfoLst;
    }

    public int getPolicyState() {
        return this.iPolicyState;
    }

    public void setPolicyState(int iPolicyState) {
        this.iPolicyState = iPolicyState;
    }

    public String getDevTypeName() {
        DeviceTypeInfo oDevType = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(this.iDevTypeID, this.iDevTypeVerID);
        if (null == oDevType) {
            return "";
        }
        return oDevType.getDevTypeName();
    }

    public DeviceTypeInfo getDevTypeInfo() {
        return DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(this.iDevTypeID, this.iDevTypeVerID);
    }

    public boolean isConfig() {
        return !Collator.getInstance().equals("", this.sUpgradeDevVersion);
    }

    public String getFullSubmapName() {
        SubMapInfo oOLTSubmap;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        SubMapInfo oSubmap = oDevMgr.getSubmapForID(this.sSubmapId, oOLTSubmap = oDevMgr.getOLTSubmapInfo());
        if (null == oSubmap) {
            return "";
        }
        String sSubmapName = oSubmap.m_strSubMapName;
        SubMapInfo oParent = null;
        while (null != oSubmap && !oSubmap.m_strParentSubMapID.equals("")) {
            oParent = oDevMgr.getSubmapForID(oSubmap.m_strParentSubMapID, oOLTSubmap);
            if (null != oParent && !oParent.m_strParentSubMapID.equals("")) {
                sSubmapName = oParent.m_strSubMapName + "/" + sSubmapName;
            }
            oSubmap = oParent;
        }
        return sSubmapName;
    }

    public String getShowUpgradeVersion() {
        String sRtnVersion = this.sUpgradeDevVersion;
        if (Collator.getInstance().equals(this.sUpgradeDevVersion, "")) {
            sRtnVersion = DCFrameWorkUtil.getLocalizedString("Not Config");
        }
        return sRtnVersion;
    }

    public String getShowPolicyState() {
        String sPolicyState = "";
        switch (this.iPolicyState) {
            case 0: {
                sPolicyState = DCFrameWorkUtil.getLocalizedString("POLICY_STATUS_RUN");
                break;
            }
            case 1: {
                sPolicyState = DCFrameWorkUtil.getLocalizedString("POLICY_STATUS_STOP");
                break;
            }
        }
        return sPolicyState;
    }
}

