/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfoList;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileUpdateInfoLst;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMVersion;
import com.huawei.dc.common.asndatacenter.AsnSAMVersionLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.policy.controller.PolicyConstants;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.policy.mxupolicy.MXUPolicyMainPanel;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.policy.mxupolicy.ShowDeletedSoftwareLstDlg;
import com.huawei.dc.policy.view.advanced.CheckBoxHeader;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMChangeEventListener;
import com.huawei.dc.sam.event.SAMChangeEventReceiver;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.view.common.TargetVersionButton;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ModifyMxuPolicyDlg
extends DCModalDialog
implements ISAMChangeEventListener {
    private static final long serialVersionUID = 1257131526114938497L;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private JPanel m_oTopPanel = null;
    private JLabel m_oPolicyStatusLbl = null;
    private JRadioButton oRunPolicyStatusRadioBtn = null;
    private JRadioButton oStopPolicyStatusRadioBtn = null;
    private ButtonGroup m_oRadioBtnGroup = null;
    private JLabel m_oNETypeLbl = null;
    private JTextField m_oNETypeTextField = null;
    private JPanel m_oTablePanel = null;
    private JLabel m_oTargetVerLbl = null;
    private ComboBoxWithToolTip m_oTargetVerComboBox = null;
    private JButton m_oTargetVerBtn = null;
    private List<MxuPolicyInfo> m_oMxuPoilcyInfoLst = null;
    private DCExtendedTable m_oFileTable = null;
    private DCSortableTableModel m_oFileTableModel = null;
    private JScrollPane m_oTableScrollPane = null;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private JButton m_oMoveUpButton = null;
    private JButton m_oMoveDownButton = null;
    private JButton m_oMoveToBottomButton = null;
    private JButton m_oMoveToTopButton = null;
    private JPanel m_oButtonPnl = null;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private int m_iSelectionType = 2;
    private boolean m_bFileSelOption = false;
    private int m_iNoOfFilesSelected = 0;
    private static final int TABLE_COLUMN_INDEX_OBJ = 0;
    private static final int TABLE_COLOMN_INDEX_SERIAL_NO = 1;
    private MXUPolicyMainPanel m_oPolicyTablePanel = null;
    private static ActionListener m_oTargetVersioChangeListenr = null;

    public ModifyMxuPolicyDlg(MXUPolicyMainPanel oPolicyTablePanel, List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        this.m_oPolicyTablePanel = oPolicyTablePanel;
        this.m_oMxuPoilcyInfoLst = oMxuPolicyInfoLst;
        this.initGUI();
        this.initData(oMxuPolicyInfoLst);
        this.addmsgListener();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponent();
        this.initTopPanel();
        this.initTablePanel();
        this.initButtonPanel();
        this.addComponent();
    }

    private void addmsgListener() {
        SAMChangeEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        this.addVersionChangeListener();
    }

    private void addVersionChangeListener() {
        if (null == m_oTargetVersioChangeListenr) {
            m_oTargetVersioChangeListenr = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModifyMxuPolicyDlg.this.handleVersionChange();
                }
            };
        }
        this.m_oTargetVerComboBox.addActionListener(m_oTargetVersioChangeListenr);
    }

    private void removeVersionChangeListener() {
        if (null != m_oTargetVersioChangeListenr) {
            this.m_oTargetVerComboBox.removeActionListener(m_oTargetVersioChangeListenr);
        }
    }

    private void initTopPanel() {
        this.m_oTopPanel = new JPanel();
        this.m_oTopPanel.setLayout(new GridBagLayout());
        this.m_oTopPanel.add((Component)this.m_oPolicyStatusLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTopPanel.add((Component)this.oRunPolicyStatusRadioBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTopPanel.add((Component)this.oStopPolicyStatusRadioBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 100), 0, 0));
        this.m_oTopPanel.add((Component)this.m_oNETypeLbl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTopPanel.add((Component)this.m_oNETypeTextField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
    }

    private void initComponent() {
        this.m_oPolicyStatusLbl = new JLabel(this.m_oRes.getResString("NXU_MODIFY_POLICY_STATE_LBL"));
        this.oRunPolicyStatusRadioBtn = new JRadioButton();
        this.oRunPolicyStatusRadioBtn.setName("policy_BasicPolicyPanel_oRunPolicyStatusRadioBtn");
        this.oRunPolicyStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_RUN"));
        this.oStopPolicyStatusRadioBtn = new JRadioButton();
        this.oStopPolicyStatusRadioBtn.setName("policy_BasicPolicyPanel_oStopPolicyStatusRadioBtn");
        this.oStopPolicyStatusRadioBtn.setText(this.m_oRes.getResString("POLICY_STATUS_STOP"));
        this.m_oRadioBtnGroup = new ButtonGroup();
        this.m_oRadioBtnGroup.add(this.oRunPolicyStatusRadioBtn);
        this.m_oRadioBtnGroup.add(this.oStopPolicyStatusRadioBtn);
        this.m_oNETypeLbl = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_DEVICETYPE_LBL"));
        this.m_oNETypeTextField = new JTextField();
        this.m_oNETypeTextField.setEnabled(false);
        this.m_oNETypeTextField.setName("ModifyMxuPolicyDlg_m_oNETypeTextField");
        this.m_oTargetVerLbl = new JLabel();
        this.m_oTargetVerLbl.setText(this.m_oRes.getResString("TARGET_VERSION_LABEL"));
        this.m_oTargetVerComboBox = new ComboBoxWithToolTip();
        this.m_oTargetVerComboBox.setName("ModifyMxuPolicyDlg_m_oTargetVerComboBox");
        DeviceTypeInfo oDevTypeInfo = this.m_oMxuPoilcyInfoLst.get(0).getDevTypeInfo();
        ArrayList<DeviceTypeInfo> oDevTypeLst = new ArrayList<DeviceTypeInfo>();
        oDevTypeLst.add(oDevTypeInfo);
        this.m_oTargetVerBtn = new TargetVersionButton(oDevTypeLst);
        this.m_oFileTableModel = new DCSortableTableModel(this.getColumn(), 0){
            private static final long serialVersionUID = 7061642463497010985L;

            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.m_oFileTable = new DCExtendedTable((SortableTableModel)this.m_oFileTableModel);
        this.m_oFileTable.setSortableClickCount(1);
        JTableHeader header = this.m_oFileTable.getTableHeader();
        header.setReorderingAllowed(false);
        this.m_oFileTable.setScrolls(false);
        this.m_oFileTable.setUpDateSelectedRow(true);
        this.m_oFileTable.setInvalidedForeground(Color.BLACK);
        this.addListenersToTable();
        this.m_oFileTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.m_oFileTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.m_oFileTable.getColumnModel().getColumn(0).setMaxWidth(0);
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oFileTable.getColumnModel().getColumn(1);
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, true, this, this.m_oFileTable.getTableHeader().getBackground(), 1);
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        this.m_oFileTable.getColumnModel().getColumn(1).setCellRenderer(new FileSeclectionCheckBoxRenderer());
        this.m_oFileTable.getColumnModel().getColumn(1).setCellEditor(new FileSeclectionCheckBoxEditor());
        this.m_oFileTable.getTableHeader().setPreferredSize(new Dimension(this.m_oFileTable.getSize().width, 28));
        this.m_oTableScrollPane = new JScrollPane();
        this.m_oTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oTableScrollPane.setHorizontalScrollBarPolicy(32);
        this.m_oTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oTableScrollPane.getViewport().setView((Component)this.m_oFileTable);
        this.initMoveButtons();
    }

    private void alignComponent() {
        this.m_oPolicyStatusLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oPolicyStatusLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oNETypeLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oNETypeLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oNETypeTextField.setPreferredSize(new Dimension(200, 20));
        this.m_oNETypeTextField.setMinimumSize(new Dimension(200, 20));
        this.m_oTargetVerLbl.setPreferredSize(new Dimension(97, 20));
        this.m_oTargetVerLbl.setMinimumSize(new Dimension(97, 20));
        this.m_oTargetVerComboBox.setPreferredSize(new Dimension(180, 20));
        this.m_oTargetVerComboBox.setMinimumSize(new Dimension(180, 20));
        this.m_oTargetVerBtn.setPreferredSize(new Dimension(20, 20));
        this.m_oTargetVerBtn.setMinimumSize(new Dimension(20, 20));
        this.m_oMoveUpButton.setPreferredSize(new Dimension(23, 23));
        this.m_oMoveUpButton.setMinimumSize(new Dimension(23, 23));
        this.m_oMoveDownButton.setPreferredSize(new Dimension(23, 23));
        this.m_oMoveDownButton.setMinimumSize(new Dimension(23, 23));
        this.m_oMoveToBottomButton.setPreferredSize(new Dimension(23, 23));
        this.m_oMoveToBottomButton.setMinimumSize(new Dimension(23, 23));
        this.m_oMoveToTopButton.setPreferredSize(new Dimension(23, 23));
        this.m_oMoveToTopButton.setMinimumSize(new Dimension(23, 23));
    }

    private void initButtonPanel() {
        this.m_oButtonPnl = new JPanel();
        this.m_oOKBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oOKBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.m_oOKBtn.setEnabled(true);
        this.m_oCancelBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCancelBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setEnabled(true);
        this.m_oButtonPnl.setPreferredSize(new Dimension(300, 21));
        this.m_oButtonPnl.setMinimumSize(new Dimension(300, 21));
        FlowLayout flowLayout = new FlowLayout(2);
        this.m_oButtonPnl.setLayout(flowLayout);
        flowLayout.setVgap(0);
        this.m_oButtonPnl.add(this.m_oOKBtn);
        this.m_oButtonPnl.add(this.m_oCancelBtn);
    }

    private void initMoveButtons() {
        this.createMoveUpButton();
        this.createMoveDownButton();
        this.createMoveToTopButton();
        this.createMoveToBottomButton();
    }

    private void createMoveUpButton() {
        this.m_oMoveUpButton = new JButton();
        this.m_oMoveUpButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveUpButton");
        ImageIcon moveUpIcon = this.m_oRes.getImage("autoupgrade_moveup.gif");
        this.m_oMoveUpButton.setIcon(moveUpIcon);
        this.m_oMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyMxuPolicyDlg.this.moveUpButton_ActionPerformed();
            }
        });
        this.m_oMoveUpButton.setToolTipText(this.m_oRes.getResString("PROGRAM_SELECTION_MOVE_UP_BTN_TOOL_TIP"));
        this.m_oMoveUpButton.setEnabled(false);
    }

    private void createMoveDownButton() {
        this.m_oMoveDownButton = new JButton();
        this.m_oMoveDownButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveDownButton");
        ImageIcon moveDownIcon = this.m_oRes.getImage("autoupgrade_movedown.gif");
        this.m_oMoveDownButton.setIcon(moveDownIcon);
        this.m_oMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyMxuPolicyDlg.this.moveDownButton_ActionPerformed();
            }
        });
        this.m_oMoveDownButton.setToolTipText(this.m_oRes.getResString("PROGRAM_SELECTION_MOVE_DOWN_BTN_TOOL_TIP"));
        this.m_oMoveDownButton.setEnabled(false);
    }

    private void createMoveToTopButton() {
        this.m_oMoveToTopButton = new JButton();
        this.m_oMoveToTopButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveToTopButton");
        this.m_oMoveToTopButton.setToolTipText(this.m_oRes.getResString("AUTO_UPGRADE_MOVE_UPMOST_BUTTON"));
        this.m_oMoveToTopButton.setVerifyInputWhenFocusTarget(true);
        this.m_oMoveToTopButton.setMnemonic('F');
        this.m_oMoveToTopButton.setEnabled(false);
        ImageIcon upMostIcon = this.m_oRes.getImage("movetofirst.gif");
        this.m_oMoveToTopButton.setIcon(upMostIcon);
        this.m_oMoveToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyMxuPolicyDlg.this.moveToTopButton_ActionPerformed();
            }
        });
    }

    private void createMoveToBottomButton() {
        this.m_oMoveToBottomButton = new JButton();
        this.m_oMoveToBottomButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveToBottomButton");
        this.m_oMoveToBottomButton.setToolTipText(this.m_oRes.getResString("AUTO_UPGRADE_MOVE_DOWNMOST_BUTTON"));
        this.m_oMoveToBottomButton.setMnemonic('L');
        this.m_oMoveToBottomButton.setEnabled(false);
        ImageIcon downMostIcon = this.m_oRes.getImage("movetolast.gif");
        this.m_oMoveToBottomButton.setIcon(downMostIcon);
        this.m_oMoveToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyMxuPolicyDlg.this.moveToBottomButton_ActionPerformed();
            }
        });
    }

    private void initTablePanel() {
        this.m_oTablePanel = new JPanel();
        this.m_oTablePanel.setLayout(new GridBagLayout());
        TitledBorder oBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, PolicyConstants.PANEL_BORDER_COLOR), this.m_oRes.getResString("MXU_MODIFY_SELECT_FILE_BORDER_TLE"));
        this.m_oTablePanel.setBorder(oBorder);
        this.m_oTablePanel.add((Component)this.m_oTargetVerLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oTargetVerComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oTargetVerBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oTableScrollPane, new GridBagConstraints(0, 1, 5, 10, 1.0, 1.0, 17, 1, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oMoveToTopButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oMoveUpButton, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oMoveDownButton, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.m_oTablePanel.add((Component)this.m_oMoveToBottomButton, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 12), 0, 0));
    }

    private void addComponent() {
        this.setLayout(new GridBagLayout());
        this.setTitle(this.m_oRes.getResString("POLICY_MODIFY_DLG_TLE"));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setSize(800, 600);
        this.setResizable(true);
        this.add(this.m_oTopPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oTablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add(this.m_oButtonPnl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(12, 12, 12, 12), 0, 0));
    }

    private void initData(List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        if (null == oMxuPolicyInfoLst) {
            return;
        }
        this.m_oMxuPoilcyInfoLst = oMxuPolicyInfoLst;
        this.initPolicyState(oMxuPolicyInfoLst);
        String sDevTypeName = oMxuPolicyInfoLst.get(0).getDevTypeName();
        this.m_oNETypeTextField.setText(sDevTypeName);
        this.initTargerVersion(oMxuPolicyInfoLst);
        String sTargetVersion = (String)this.m_oTargetVerComboBox.getSelectedItem();
        if (null == sTargetVersion || Collator.getInstance().equals("", sTargetVersion)) {
            return;
        }
        MxuPolicyInfo oPolicyInfo = PolicyUtil.getMxuPolicyInfo(sTargetVersion, oMxuPolicyInfoLst);
        if (null == oPolicyInfo) {
            return;
        }
        List<FileInfo> oUpgradeFileInfoLst = oPolicyInfo.getUpgradeFileInfoLst();
        this.initTableData(oUpgradeFileInfoLst);
    }

    private void initTableData(List<FileInfo> oUpgradeFileInfoLst) {
        this.m_oFileTableModel.getDataVector().clear();
        if (null != oUpgradeFileInfoLst && oUpgradeFileInfoLst.size() > 0) {
            Vector oDataVct = new Vector();
            Vector<Object> oRowVct = null;
            for (FileInfo oFile : oUpgradeFileInfoLst) {
                if (null == oFile) continue;
                oRowVct = new Vector<Object>();
                oRowVct.add(oFile);
                oRowVct.add(oFile.getSeqNumber());
                oRowVct.add(oFile.getFileName());
                oRowVct.add(oFile.getContentType());
                oDataVct.add(oRowVct);
            }
            if (!oDataVct.isEmpty()) {
                this.m_oFileTableModel.addRows(oDataVct);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModifyMxuPolicyDlg.this.m_oFileTable.updateUI();
                ModifyMxuPolicyDlg.this.m_oFileTable.getTableHeader().repaint();
                ModifyMxuPolicyDlg.this.m_oTableScrollPane.updateUI();
            }
        });
    }

    private void initTargerVersion(List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        DeviceTypeInfo oDevTypeInfo = oMxuPolicyInfoLst.get(0).getDevTypeInfo();
        ISAMManager oManager = SAMManager.getInstance();
        SAMFileInfo oFileInfo = new SAMFileInfo();
        oFileInfo.setDeviceTypeInfo(oDevTypeInfo);
        AsnSAMGetVersionRsp oRsp = oManager.getAsnSAMGetVersionReq(oFileInfo, 0);
        oRsp = this.validateTargetVersions(oRsp, oDevTypeInfo);
        List<String> oSamVerLst = this.decodeSAMVersionLst(oRsp.oAsnSAMVersionLst);
        ArrayList<MxuPolicyInfo> oDeleteMxuLst = new ArrayList<MxuPolicyInfo>();
        String sFirstVersion = "";
        String sVer = "";
        boolean bSameVersion = true;
        int i = 0;
        for (MxuPolicyInfo oMxuPolicy : oMxuPolicyInfoLst) {
            sVer = oMxuPolicy.getUpgradeDevVersion();
            if (Collator.getInstance().equals("", sVer)) continue;
            if (i == 0) {
                sFirstVersion = sVer;
            } else if (bSameVersion && !Collator.getInstance().equals(sFirstVersion, sVer)) {
                bSameVersion = false;
                sFirstVersion = "";
            }
            if (!oSamVerLst.contains(sVer)) {
                oDeleteMxuLst.add(oMxuPolicy);
            }
            ++i;
        }
        int iTargetVersionNum = oSamVerLst.size();
        if (0 == iTargetVersionNum) {
            if (oDeleteMxuLst.size() == 0) {
                DCOptionPane.showMessageDialog((Component)((Object)this), this.m_oRes.getResString("IMPORT_FILES_TO_SAM"), this.m_oRes.getResString("INFO"), 1);
            } else {
                this.showDeleteFileInfoLst(oDeleteMxuLst);
            }
            return;
        }
        if (oDeleteMxuLst.size() > 0) {
            this.showDeleteFileInfoLst(oDeleteMxuLst);
        }
        if ("".equals(sFirstVersion)) {
            this.m_oTargetVerComboBox.addItem("");
        }
        String strItem = "";
        for (int j = 0; j < oSamVerLst.size(); ++j) {
            strItem = oSamVerLst.get(j);
            this.m_oTargetVerComboBox.addItem(strItem);
            if (!Collator.getInstance().equals(strItem, sFirstVersion)) continue;
            this.m_oTargetVerComboBox.setSelectedItem(strItem);
        }
    }

    private void showDeleteFileInfoLst(List<MxuPolicyInfo> oMxuPolicyLst) {
        final ShowDeletedSoftwareLstDlg oDeleteFileDlg = new ShowDeletedSoftwareLstDlg(oMxuPolicyLst);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oDeleteFileDlg.setVisible(true);
            }
        });
    }

    public List<String> decodeSAMVersionLst(AsnSAMVersionLst oAsnSAMVersionLst) {
        ArrayList<String> oRtnVerLst = new ArrayList<String>();
        AsnSAMVersion oAsnSAMVersion = null;
        for (int i = 0; i < oAsnSAMVersionLst.size(); ++i) {
            oAsnSAMVersion = (AsnSAMVersion)oAsnSAMVersionLst.get(i);
            oRtnVerLst.add(new String(oAsnSAMVersion.stringSWVersion));
        }
        return oRtnVerLst;
    }

    private AsnSAMGetVersionRsp validateTargetVersions(AsnSAMGetVersionRsp oasnSAMGetVersionRsp, DeviceTypeInfo oDevTypeInfo) {
        AsnSAMGetVersionRsp oFilterRsp = oasnSAMGetVersionRsp;
        int iNoOfTargetVersions = oFilterRsp.oAsnSAMVersionLst.size();
        AsnSAMVersion oAsnSAMVersion = null;
        int i = 0;
        int j = 0;
        while (j < iNoOfTargetVersions) {
            oAsnSAMVersion = (AsnSAMVersion)oFilterRsp.oAsnSAMVersionLst.get(i);
            String oTargetVersion = new String(oAsnSAMVersion.stringSWVersion);
            ISAMManager oManager = SAMManager.getInstance();
            SAMFileInfo oFileInfo = new SAMFileInfo();
            oFileInfo.setDeviceTypeInfo(oDevTypeInfo);
            oFileInfo.setVersion(oTargetVersion);
            AsnSAMGetVersionFileLstRsp oFileListRsp = oManager.getAsnSAMDeviceVersionFileReq(oFileInfo);
            if (0 == oFileListRsp.oAsnSAMFileInfoLst.size()) {
                oFilterRsp.oAsnSAMVersionLst.remove(i);
                --i;
            }
            ++j;
            ++i;
        }
        return oFilterRsp;
    }

    private String[] getColumn() {
        String[] sColunms = new String[]{this.m_oRes.getResString("hideColumn"), this.m_oRes.getResString("SERIAL_NO"), this.m_oRes.getResString("LOAD_FILE"), this.m_oRes.getResString("LOAD_DATA_CONTENT_TYPE")};
        return sColunms;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    private void setCheckBoxonClick() {
        int iRowCount = this.m_oFileTable.getRowCount();
        this.m_iNoOfFilesSelected = !this.m_bFileSelOption ? 0 : iRowCount;
        for (int i = 0; i < iRowCount; ++i) {
            FileInfo oFile = (FileInfo)this.m_oFileTableModel.getValueAt(i, 0);
            oFile.setFileSelected(this.m_bFileSelOption);
        }
    }

    public int getHeardStatus() {
        int iRowCount = this.m_oFileTableModel.getRowCount();
        this.m_iSelectionType = 0 == iRowCount ? 2 : (this.m_iNoOfFilesSelected == iRowCount ? 0 : (this.m_iNoOfFilesSelected < iRowCount && this.m_iNoOfFilesSelected != 0 ? 1 : 2));
        return this.m_iSelectionType;
    }

    private void addListenersToTable() {
        this.m_oFileTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (ModifyMxuPolicyDlg.this.m_oFileTable.hasFocus()) {
                    ModifyMxuPolicyDlg.this.updateStatusOfButtons();
                }
            }
        });
        this.m_oFileTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ModifyMxuPolicyDlg.this.updateStatusOfButtons();
            }
        });
        this.m_oFileTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                ModifyMxuPolicyDlg.this.updateStatusOfButtons();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = ModifyMxuPolicyDlg.this.m_oFileTable.columnAtPoint(p);
                int hitRowIndex = ModifyMxuPolicyDlg.this.m_oFileTable.rowAtPoint(p);
                Object str = ModifyMxuPolicyDlg.this.m_oFileTable.getValueAt(hitRowIndex, hitColumnIndex);
                ModifyMxuPolicyDlg.this.m_oFileTable.setToolTipText(str.toString());
            }
        });
    }

    private void updateStatusOfButtons() {
        int[] updatedrows = this.m_oFileTable.getSelectedRows();
        int iRowCount = this.m_oFileTable.getRowCount();
        if (updatedrows.length >= 1) {
            this.m_oMoveDownButton.setEnabled(true);
            this.m_oMoveToBottomButton.setEnabled(true);
            this.m_oMoveUpButton.setEnabled(true);
            this.m_oMoveToTopButton.setEnabled(true);
            if (iRowCount >= 1) {
                int iLastSelectedRowIndex = updatedrows[updatedrows.length - 1];
                if (iRowCount - 1 == iLastSelectedRowIndex) {
                    this.m_oMoveDownButton.setEnabled(false);
                    this.m_oMoveToBottomButton.setEnabled(false);
                }
                if (0 == updatedrows[0]) {
                    this.m_oMoveUpButton.setEnabled(false);
                    this.m_oMoveToTopButton.setEnabled(false);
                }
            }
        } else {
            this.m_oMoveUpButton.setEnabled(false);
            this.m_oMoveToTopButton.setEnabled(false);
            this.m_oMoveDownButton.setEnabled(false);
            this.m_oMoveToBottomButton.setEnabled(false);
        }
        this.m_oFileTable.repaint();
    }

    private void moveUpButton_ActionPerformed() {
        int[] arrRows = this.m_oFileTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iCount = arrRows[0];
        if (0 == iCount) {
            return;
        }
        int iLastCount = arrRows[arrRows.length - 1];
        this.m_oFileTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], iCount - 1);
        this.m_oFileTable.setColumnSelectionAllowed(false);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.setRowSelectionInterval(iCount - 1, iLastCount - 1);
        Rectangle oRect = this.m_oFileTable.getCellRect(iCount - 1, 0, true);
        this.m_oFileTable.scrollRectToVisible(oRect);
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    private void moveDownButton_ActionPerformed() {
        int[] arrRows = this.m_oFileTable.getSelectedRows();
        int iCount = arrRows.length;
        if (0 == iCount) {
            return;
        }
        int iFirstRow = arrRows[0];
        if (arrRows[arrRows.length - 1] == this.m_oFileTable.getRowCount() - 1) {
            return;
        }
        this.m_oFileTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], iFirstRow + 1);
        this.m_oFileTable.setColumnSelectionAllowed(false);
        this.m_oFileTable.setRowSelectionAllowed(true);
        this.m_oFileTable.setRowSelectionInterval(iFirstRow + 1, iCount + iFirstRow);
        Rectangle oRect = this.m_oFileTable.getCellRect(iCount + iFirstRow, 0, true);
        this.m_oFileTable.scrollRectToVisible(oRect);
        this.m_oFileTable.repaint();
        this.updateStatusOfButtons();
    }

    protected void moveToBottomButton_ActionPerformed() {
        int[] arrRows = this.m_oFileTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iLastRow = arrRows[arrRows.length - 1];
        int iFirstRow = arrRows[0];
        if (this.m_oFileTable.getRowCount() - 1 != arrRows[arrRows.length - 1]) {
            if (arrRows[0] == arrRows[arrRows.length - 1]) {
                this.m_oFileTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], this.m_oFileTable.getRowCount() - 1);
            } else {
                this.m_oFileTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], this.m_oFileTable.getRowCount() - arrRows.length);
            }
            this.m_oFileTable.setColumnSelectionAllowed(false);
            this.m_oFileTable.setRowSelectionAllowed(true);
            this.m_oFileTable.setRowSelectionInterval(this.m_oFileTable.getRowCount() - 1, iFirstRow + (this.m_oFileTable.getRowCount() - 1 - iLastRow));
            JScrollBar oVertScrollBar = this.m_oTableScrollPane.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMaximum());
            this.m_oFileTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    protected void moveToTopButton_ActionPerformed() {
        int[] arrRows = this.m_oFileTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iLastRow = arrRows[arrRows.length - 1];
        int iFirstRow = arrRows[0];
        if (0 != arrRows[0]) {
            this.m_oFileTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], 0);
            this.m_oFileTable.setColumnSelectionAllowed(false);
            this.m_oFileTable.setRowSelectionAllowed(true);
            this.m_oFileTable.setRowSelectionInterval(0, iLastRow - iFirstRow);
            JScrollBar oVertScrollBar = this.m_oTableScrollPane.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMinimum());
            this.m_oFileTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    private void initPolicyState(List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        boolean iPolicyState = true;
        for (MxuPolicyInfo oPolicy : oMxuPolicyInfoLst) {
            if (oPolicy.getPolicyState() != 0) continue;
            iPolicyState = false;
            break;
        }
        if (!iPolicyState) {
            this.oRunPolicyStatusRadioBtn.setSelected(true);
        } else {
            this.oStopPolicyStatusRadioBtn.setSelected(true);
        }
    }

    @Override
    protected void oKButton_ActionPerformed() {
        int iPolicyState = this.oRunPolicyStatusRadioBtn.isSelected() ? 0 : 1;
        Object oTarVersion = this.m_oTargetVerComboBox.getSelectedItem();
        if (null == oTarVersion) {
            this.dispose();
            return;
        }
        String sTargetVersion = this.m_oTargetVerComboBox.getSelectedItem().toString();
        int iRowCount = this.m_oFileTable.getRowCount();
        ArrayList<FileInfo> oFileLst = new ArrayList<FileInfo>();
        FileInfo oFile = null;
        int iStartSeq = 0;
        for (int i = 0; i < iRowCount; ++i) {
            oFile = (FileInfo)this.m_oFileTable.getValueAt(i, 0);
            if (!oFile.isFileSelected()) continue;
            oFile.setSeqNumber(++iStartSeq);
            oFileLst.add(oFile);
        }
        if (oFileLst.size() == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("SELECT_ALTEAST_ONE_FILE"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            return;
        }
        boolean isValidFiles = PolicyUtil.validateFileList(oFileLst);
        if (!isValidFiles) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString("FILE_SELECTION_NOT_CORRECT"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            return;
        }
        DeviceTypeInfo oCurDevTypeInfo = this.m_oMxuPoilcyInfoLst.get(0).getDevTypeInfo();
        boolean isValidFileTypes = PolicyUtil.validateFileTypes(oCurDevTypeInfo, oFileLst);
        if (!isValidFileTypes) {
            return;
        }
        for (MxuPolicyInfo oPolicy : this.m_oMxuPoilcyInfoLst) {
            oPolicy.setPolicyState(iPolicyState);
            oPolicy.setUpgradeDevVersion(sTargetVersion);
            oPolicy.setUpgradeFileInfoLst(oFileLst);
        }
        boolean bResult = PolicyManager.getInstance().setMxuInfoToServer(this.m_oMxuPoilcyInfoLst);
        if (!bResult) {
            return;
        }
        for (MxuPolicyInfo oPolicy : this.m_oMxuPoilcyInfoLst) {
            this.m_oPolicyTablePanel.modifyPolicy(oPolicy);
        }
        this.m_oPolicyTablePanel.updateGUI();
        this.dispose();
    }

    private void handleSamChange(AsnSAMFileUpdateInfoLst oAsnSAMFileInfoLst, int iEventType) {
        if (null == oAsnSAMFileInfoLst || oAsnSAMFileInfoLst.size() == 0) {
            return;
        }
        DeviceTypeInfo oCurDevTypeInfo = this.m_oMxuPoilcyInfoLst.get(0).getDevTypeInfo();
        AsnSAMFileUpdateInfo oAsnSAMFileUpdateInfo = null;
        AsnDevTypeIdInfoList oAsnDevTypeList = null;
        Iterator iterator = oAsnSAMFileInfoLst.iterator();
        Iterator itrDevType = null;
        AsnDevTypeIdInfo oAsnDevTypeIdInfo = null;
        AsnSAMFileInfo oAsnSamFileInfo = null;
        int iDevTypeID = 0;
        int iDevTypeVerId = 0;
        String sDestVer = "";
        block0: while (iterator.hasNext()) {
            oAsnSAMFileUpdateInfo = (AsnSAMFileUpdateInfo)iterator.next();
            oAsnDevTypeList = oAsnSAMFileUpdateInfo.oDevTypeIdInfoList;
            itrDevType = oAsnDevTypeList.iterator();
            oAsnSamFileInfo = oAsnSAMFileUpdateInfo.oFileInfo;
            sDestVer = new String(oAsnSamFileInfo.strVersion);
            while (itrDevType.hasNext()) {
                oAsnDevTypeIdInfo = (AsnDevTypeIdInfo)itrDevType.next();
                iDevTypeID = oAsnDevTypeIdInfo.iDevTypeId.intValue();
                iDevTypeVerId = oAsnDevTypeIdInfo.iDevTypeVerId.intValue();
                if (null == oCurDevTypeInfo || oCurDevTypeInfo.getDevTypeID() != iDevTypeID || oCurDevTypeInfo.getDevTypeVersionId() != iDevTypeVerId) continue;
                this.handelSamNotify(sDestVer, oAsnSamFileInfo, iEventType);
                continue block0;
            }
        }
    }

    @Override
    public void handleDeleteSAMFileNotification(AsnSAMFileUpdateInfoLst oAsnSAMFileInfoLst) {
        this.handleSamChange(oAsnSAMFileInfoLst, 1);
    }

    @Override
    public void handleImportSAMFileNotification(AsnSAMFileUpdateInfoLst oAsnSAMFileInfoLst) {
        this.handleSamChange(oAsnSAMFileInfoLst, 0);
    }

    @Override
    public void handleUpdateSAMFileNotification(AsnSAMFileUpdateInfoLst oAsnSAMFileInfoLst) {
        this.handleSamChange(oAsnSAMFileInfoLst, 2);
    }

    private void handelSamNotify(String sDestVersion, AsnSAMFileInfo oFileInfo, int iEventType) {
        switch (iEventType) {
            case 0: {
                this.handleSamAdd(sDestVersion);
                break;
            }
            case 1: {
                this.handleSamDelete(sDestVersion);
                break;
            }
            case 2: {
                this.handleSamUpdate(sDestVersion, oFileInfo);
                break;
            }
        }
    }

    private void handleSamAdd(String sDestVersion) {
        this.removeVersionChangeListener();
        this.m_oTargetVerComboBox.addItem(sDestVersion);
        int iSelectIndex = this.m_oTargetVerComboBox.getSelectedIndex();
        if (-1 == iSelectIndex || StringUtils.isNullOrEmptyStr(this.m_oTargetVerComboBox.getSelectedItem().toString())) {
            this.m_oTargetVerComboBox.setSelectedItem(sDestVersion);
        } else {
            this.m_oTargetVerComboBox.setSelectedIndex(iSelectIndex);
        }
        this.handleVersionChange();
        this.addVersionChangeListener();
    }

    private void handleSamDelete(String sDestVersion) {
        int iItemCount = this.m_oTargetVerComboBox.getItemCount();
        String sCurVersion = "";
        Collator oCol = Collator.getInstance();
        for (int i = 0; i < iItemCount; ++i) {
            sCurVersion = (String)this.m_oTargetVerComboBox.getItemAt(i);
            if (!oCol.equals(sDestVersion, sCurVersion)) continue;
            this.m_oTargetVerComboBox.remove(i);
            break;
        }
    }

    private void handleVersionChange() {
        String oTargetVersion = (String)this.m_oTargetVerComboBox.getSelectedItem();
        DeviceTypeInfo oCurDevTypeInfo = this.m_oMxuPoilcyInfoLst.get(0).getDevTypeInfo();
        List<FileInfo> oFileLst = PolicyUtil.getSamFileInfoLst(oCurDevTypeInfo, oTargetVersion);
        this.initTableData(oFileLst);
    }

    private void handleSamUpdate(String sDestVersion, AsnSAMFileInfo oFileInfo) {
        String sCurentVer = (String)this.m_oTargetVerComboBox.getSelectedItem();
        if (!Collator.getInstance().equals(sDestVersion, sCurentVer)) {
            return;
        }
        DeviceTypeInfo oCurDevTypeInfo = this.m_oMxuPoilcyInfoLst.get(0).getDevTypeInfo();
        List<FileInfo> oFileLst = PolicyUtil.getSamFileInfoLst(oCurDevTypeInfo, sCurentVer);
        this.initTableData(oFileLst);
    }

    @Override
    protected void closeDialog() {
        this.removeVersionChangeListener();
        m_oTargetVersioChangeListenr = null;
        super.closeDialog();
        SAMChangeEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.setVisible(false);
        this.dispose();
    }

    private class FileSeclectionCheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox m_oSelectionCheckBox = new JCheckBox();
        private boolean m_bIsSelected = false;
        private int iSerialNo = -1;
        private FileInfo oFileInfo = null;

        FileSeclectionCheckBoxEditor() {
            this.m_oSelectionCheckBox.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean bSelected, int iRowNo, int iCcolNo) {
            this.oFileInfo = (FileInfo)ModifyMxuPolicyDlg.this.m_oFileTableModel.getValueAt(iRowNo, 0);
            this.m_bIsSelected = this.oFileInfo.isFileSelected();
            this.iSerialNo = iRowNo;
            this.m_oSelectionCheckBox.setBackground(ModifyMxuPolicyDlg.this.m_oFileTable.getBackground());
            this.m_oSelectionCheckBox.setText("" + (iRowNo + 1));
            this.m_oSelectionCheckBox.setSelected(this.m_bIsSelected);
            return this.m_oSelectionCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_oSelectionCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent oActionEvent) {
            boolean bl = this.m_bIsSelected = !this.m_bIsSelected;
            if (this.m_bIsSelected) {
                ModifyMxuPolicyDlg.this.m_iNoOfFilesSelected++;
            }
            if (ModifyMxuPolicyDlg.this.m_iNoOfFilesSelected > 0 && !this.m_bIsSelected) {
                ModifyMxuPolicyDlg.this.m_iNoOfFilesSelected--;
            }
            ModifyMxuPolicyDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges(1);
            this.oFileInfo.setFileSelected(this.m_bIsSelected);
            this.m_oSelectionCheckBox.setBackground(ModifyMxuPolicyDlg.this.m_oFileTable.getBackground());
            this.m_oSelectionCheckBox.setText("" + (this.iSerialNo + 1));
            this.m_oSelectionCheckBox.setSelected(this.m_bIsSelected);
            this.fireEditingStopped();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModifyMxuPolicyDlg.this.m_oFileTable.repaint();
                    ModifyMxuPolicyDlg.this.m_oFileTable.getTableHeader().repaint();
                }
            });
        }
    }

    private class FileSeclectionCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private FileSeclectionCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            FileInfo oFileInfo = (FileInfo)ModifyMxuPolicyDlg.this.m_oFileTableModel.getValueAt(iRow, 0);
            if (bIsSelected) {
                this.setBackground(oOpTable.getSelectionBackground());
            } else {
                this.setBackground(oOpTable.getBackground());
            }
            this.setSelected(oFileInfo.isFileSelected());
            this.setText("" + (iRow + 1));
            this.setToolTipText(this.getText());
            return this;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                if (0 == ModifyMxuPolicyDlg.this.m_iSelectionType) {
                    ModifyMxuPolicyDlg.this.m_bFileSelOption = false;
                } else if (2 == ModifyMxuPolicyDlg.this.m_iSelectionType || 1 == ModifyMxuPolicyDlg.this.m_iSelectionType) {
                    ModifyMxuPolicyDlg.this.m_bFileSelOption = true;
                }
            } else {
                return;
            }
            ModifyMxuPolicyDlg.this.setCheckBoxonClick();
            ModifyMxuPolicyDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModifyMxuPolicyDlg.this.m_oFileTable.repaint();
                    ModifyMxuPolicyDlg.this.m_oFileTable.getTableHeader().repaint();
                }
            });
        }
    }
}

