/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.mxupolicy.MXUPolicyDlg;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.policy.mxupolicy.MxuPolicyTableMenuItemHandler;
import com.huawei.dc.policy.mxupolicy.MxuPolicyTablePopupManager;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;

public class MXUPolicyMainPanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = -5517696924899596219L;
    ResourceManager m_oRes = ResourceManager.getInstance();
    private JPanel m_oNETyePanel = null;
    JLabel m_oNETypeLbl = null;
    ComboBoxWithToolTip m_oNETypeCombox = null;
    private transient ItemListener m_ONETypeCombxoListener = null;
    private DCExtendedTable m_oTable = null;
    private DCSortableTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private JLabel m_oSelectCountLabel = null;
    private String m_oSelectCountTxt = null;
    private JButton m_oModifyBtn = null;
    private JButton m_oStartBtn = null;
    private JButton m_oSuspendBtn = null;
    private JButton m_oSaveBtn = null;
    private JButton m_oCloseBtn = null;
    private DefaultComboBoxModel m_oNETypeModel;
    private static final int TABLE_COLUMN_INDEX_POLICY = 0;
    private MxuPolicyTableMenuItemHandler m_oPolicyTableMenuItemHandler = null;
    private MxuPolicyTablePopupManager m_oPopupManager = null;
    private JPopupMenu m_oPolicyTablePopupMenu;
    private String m_sSelectedSubmapID = "";
    private String m_sSelectedNEType = "";
    private List<MxuPolicyInfo> m_oSelectedMxuPolicyLst = null;

    public MXUPolicyMainPanel() {
        this.initGUI();
        this.initPopupMenuManager();
        this.addActionListener();
    }

    private void initGUI() {
        this.initComponent();
        this.alignComponents();
        this.addComponent();
    }

    private void initPopupMenuManager() {
        this.m_oPolicyTableMenuItemHandler = new MxuPolicyTableMenuItemHandler(this);
        this.m_oPopupManager = new MxuPolicyTablePopupManager(this.m_oPolicyTableMenuItemHandler);
    }

    private void addActionListener() {
        this.m_oTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oTable.getSelectionModel().addListSelectionListener(new TableSelectionListener(this));
        this.m_ONETypeCombxoListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object oSelectObj = ((ComboBoxWithToolTip)e.getSource()).getSelectedItem();
                if (null != oSelectObj) {
                    MXUPolicyMainPanel.this.handleNETypeChange(oSelectObj.toString());
                }
            }
        };
        this.m_oNETypeCombox.addItemListener(this.m_ONETypeCombxoListener);
    }

    private void handleNETypeChange(String sNETypeName) {
        boolean bSelectAllType = Collator.getInstance().equals(sNETypeName, DCConstants.ALL_TYPE);
        if (bSelectAllType) {
            sNETypeName = "";
        }
        this.m_sSelectedNEType = sNETypeName;
        List<MxuPolicyInfo> oPolicyLst = null;
        SubMapInfo oSubmapInfo = DeviceInfoManagerImpl.getInstance().getSubmapForID(this.m_sSelectedSubmapID, DeviceInfoManagerImpl.getInstance().getOLTSubmapInfo());
        String sParentSubmapID = "";
        if (null != oSubmapInfo) {
            sParentSubmapID = oSubmapInfo.m_strParentSubMapID;
        }
        if (Collator.getInstance().equals("", sParentSubmapID) || Collator.getInstance().equals("", this.m_sSelectedSubmapID)) {
            oPolicyLst = PolicyManager.getInstance().generateAllMxuPolicyLst();
            this.initDate(oPolicyLst, sNETypeName);
        } else {
            oPolicyLst = PolicyUtil.generateMxuPolicyLst(this.m_sSelectedSubmapID);
            this.initDate(oPolicyLst, sNETypeName);
        }
    }

    private MouseListener generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                MXUPolicyMainPanel.this.policyTable_MousePressed(oMouseEvent);
            }
        };
    }

    protected void policyTable_MousePressed(MouseEvent oMouseEvent) {
        if (!oMouseEvent.isPopupTrigger() && 0 != (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        int iClickedRow = this.m_oTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oTable.getSelectedRows();
        if (nRows.length > 1) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected) {
            ListSelectionModel selectionModel = this.m_oTable.getSelectionModel();
            selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        this.m_oSelectedMxuPolicyLst = this.getSelecteDMxuPolicyLst();
        this.m_oPolicyTablePopupMenu = this.m_oPopupManager.loadMenu();
        this.m_oPolicyTablePopupMenu.setName("Policy_PolicytablePanel_m_oPolicyTablePopupMenu");
        this.m_oPolicyTablePopupMenu.show((Component)this.m_oTable, oMouseEvent.getX(), oMouseEvent.getY());
    }

    public void modifyPolicy(MxuPolicyInfo oMxuPolicyInfo) {
        Collator oCol = Collator.getInstance();
        int[] arrRows = this.m_oTable.getSelectedRows();
        int iLength = arrRows.length;
        MxuPolicyInfo oMxuPolicy = null;
        for (int index = 0; index < iLength; ++index) {
            Object oo = this.m_oTable.getValueAt(arrRows[index], 0);
            if (!(oo instanceof MxuPolicyInfo) || !oCol.equals((oMxuPolicy = (MxuPolicyInfo)oo).getSubmapId(), oMxuPolicyInfo.getSubmapId()) || oMxuPolicy.getDevTypeID() != oMxuPolicyInfo.getDevTypeID() || oMxuPolicy.getDevTypeVerID() != oMxuPolicyInfo.getDevTypeVerID()) continue;
            oMxuPolicy.setPolicyState(oMxuPolicyInfo.getPolicyState());
            oMxuPolicy.setUpgradeDevVersion(oMxuPolicyInfo.getUpgradeDevVersion());
            oMxuPolicy.setUpgradeFileInfoLst(oMxuPolicyInfo.getUpgradeFileInfoLst());
            this.m_oTable.setValueAt((Object)oMxuPolicyInfo.getShowUpgradeVersion(), arrRows[index], 3);
            this.m_oTable.setValueAt((Object)oMxuPolicyInfo.getShowPolicyState(), arrRows[index], 4);
        }
    }

    public List<MxuPolicyInfo> getSelecteDMxuPolicyLst() {
        int iRowCount = this.m_oTable.getRowCount();
        if (iRowCount < 1) {
            return null;
        }
        ArrayList<MxuPolicyInfo> oSelectedMxuPolicyLst = new ArrayList<MxuPolicyInfo>();
        int[] arrRows = this.m_oTable.getSelectedRows();
        int iLength = arrRows.length;
        MxuPolicyInfo oMxuPolicy = null;
        for (int index = 0; index < iLength; ++index) {
            Object oo = this.m_oTable.getValueAt(arrRows[index], 0);
            if (!(oo instanceof MxuPolicyInfo)) continue;
            oMxuPolicy = (MxuPolicyInfo)this.m_oTable.getValueAt(arrRows[index], 0);
            oSelectedMxuPolicyLst.add(oMxuPolicy);
        }
        return oSelectedMxuPolicyLst;
    }

    private void initComponent() {
        this.m_oNETypeLbl = new JLabel(this.m_oRes.getResString("POLICYINFOPAN_DEVICETYPE_LBL"));
        this.m_oNETypeModel = new DefaultComboBoxModel();
        this.m_oNETypeCombox = new ComboBoxWithToolTip((ComboBoxModel)this.m_oNETypeModel);
        this.m_oNETypeCombox.setName("PolicyTablePanel_m_oNETypeCombox");
        this.m_oNETypeLbl.setPreferredSize(new Dimension(150, 20));
        this.m_oNETypeLbl.setMinimumSize(new Dimension(150, 20));
        this.m_oNETyePanel = new JPanel();
        this.m_oNETyePanel.setLayout(new GridBagLayout());
        this.m_oNETyePanel.setName("PolicyTablePanel_m_oNETypePanel");
        this.m_oNETyePanel.add((Component)this.m_oNETypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.m_oNETyePanel.add((Component)this.m_oNETypeCombox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.m_oTableModel = new DCSortableTableModel(this.getColumn(), 0){
            private static final long serialVersionUID = 6591890669198709074L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable = new DCExtendedTable((SortableTableModel)this.m_oTableModel);
        this.m_oTableModel.setColumnSortable(new int[]{0, 1, 2, 3, 4}, true);
        this.m_oTable.setSortableClickCount(1);
        JTableHeader header = this.m_oTable.getTableHeader();
        header.setReorderingAllowed(false);
        this.m_oTable.setScrolls(false);
        this.m_oTable.setUpDateSelectedRow(true);
        this.m_oTable.setInvalidedForeground(Color.BLACK);
        this.m_oTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.m_oTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.m_oTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.m_oScrollPane = new JScrollPane((Component)this.m_oTable);
        this.m_oScrollPane.setName("PolicyTablePanel_m_oPolicyInfoScrollPane");
        this.m_oScrollPane.setVerticalScrollBarPolicy(20);
        this.m_oScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oSelectCountLabel = new JLabel();
        this.m_oSelectCountTxt = this.m_oRes.getResString("LBL_SELECT_DEVICE_COUNT");
        String sInitText = MessageFormat.format(this.m_oSelectCountTxt, "0", "0");
        this.m_oSelectCountLabel.setText(sInitText);
        this.m_oModifyBtn = new JButton();
        this.m_oModifyBtn.setMinimumSize(new Dimension(120, 21));
        this.m_oModifyBtn.setPreferredSize(new Dimension(120, 21));
        this.m_oModifyBtn.setText(this.m_oRes.getResString("POLICY_MODIFY_BTN"));
        this.m_oModifyBtn.setToolTipText(this.m_oRes.getResString("POLICY_MODIFY_BTN_TOOLTIP"));
        this.m_oModifyBtn.setMnemonic('M');
        this.m_oModifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MXUPolicyMainPanel.this.modifyBtnActinPerformed();
            }
        });
        this.m_oStartBtn = new JButton();
        this.m_oStartBtn.setMinimumSize(new Dimension(120, 21));
        this.m_oStartBtn.setPreferredSize(new Dimension(120, 21));
        this.m_oStartBtn.setText(this.m_oRes.getResString("POLICY_RUN_BTN"));
        this.m_oStartBtn.setToolTipText(this.m_oRes.getResString("POLICY_RUN_BTN_TOOLTIP"));
        this.m_oStartBtn.setMnemonic('E');
        this.m_oStartBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MXUPolicyMainPanel.this.startBtnActinPerformed();
            }
        });
        this.m_oSuspendBtn = new JButton();
        this.m_oSuspendBtn.setMinimumSize(new Dimension(125, 21));
        this.m_oSuspendBtn.setPreferredSize(new Dimension(125, 21));
        this.m_oSuspendBtn.setText(this.m_oRes.getResString("POLICY_STOP_BTN"));
        this.m_oSuspendBtn.setToolTipText(this.m_oRes.getResString("POLICY_STOP_BTN_TOOLTIP"));
        this.m_oSuspendBtn.setMnemonic('D');
        this.m_oSuspendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MXUPolicyMainPanel.this.suspendBtnActinPerformed();
            }
        });
        this.m_oSaveBtn = new JButton();
        this.m_oSaveBtn.setMinimumSize(new Dimension(120, 21));
        this.m_oSaveBtn.setPreferredSize(new Dimension(120, 21));
        this.m_oSaveBtn.setText(this.m_oRes.getResString("EXPORT_LIST_BTN"));
        this.m_oSaveBtn.setToolTipText(this.m_oRes.getResString("EXPORT_LIST_BTN_TOOLTIP"));
        this.m_oSaveBtn.setMnemonic('L');
        this.m_oSaveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MXUPolicyMainPanel.this.saveBtnActinPerformed();
            }
        });
        this.m_oCloseBtn = new JButton();
        this.m_oCloseBtn.setMaximumSize(new Dimension(85, 21));
        this.m_oCloseBtn.setMinimumSize(new Dimension(85, 21));
        this.m_oCloseBtn.setPreferredSize(new Dimension(85, 21));
        this.m_oCloseBtn.setText(ResourceManager.getInstance().getResString("CLOSE"));
        this.m_oCloseBtn.setEnabled(true);
        this.m_oCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MXUPolicyMainPanel.this.closeBtnActionPerformed();
            }
        });
    }

    public void initTableData(List<MxuPolicyInfo> oMxuPolicyInfoLst, String sDevTypeName) {
        if (null == oMxuPolicyInfoLst || oMxuPolicyInfoLst.size() == 0) {
            this.refreshSelectedMxuPolicyLst();
            this.refreshBtnStatus();
            return;
        }
        this.m_oTableModel.getDataVector().clear();
        int iColumnCount = this.getColumnSize();
        Object[] oCellData = null;
        IDeviceInfoManager odevMgr = DeviceInfoManagerImpl.getInstance();
        String sRunState = DCFrameWorkUtil.getLocalizedString("POLICY_STATUS_RUN");
        String sSuspendState = DCFrameWorkUtil.getLocalizedString("POLICY_STATUS_STOP");
        for (MxuPolicyInfo oPolicyInfo : oMxuPolicyInfoLst) {
            String sDeviceTypeName;
            int iDevTypeVerId;
            if (null == oPolicyInfo) continue;
            oCellData = new Object[iColumnCount];
            oCellData[0] = oPolicyInfo;
            oCellData[1] = oPolicyInfo.getFullSubmapName();
            int iDevTypeID = oPolicyInfo.getDevTypeID();
            DeviceTypeInfo oDevType = odevMgr.getDeviceTypeInfo(iDevTypeID, iDevTypeVerId = oPolicyInfo.getDevTypeVerID());
            String string = sDeviceTypeName = null != oDevType ? oDevType.getDevTypeName() : "";
            if (!"".equals(sDevTypeName) && !Collator.getInstance().equals(sDeviceTypeName, sDevTypeName)) continue;
            oCellData[2] = sDeviceTypeName;
            oCellData[3] = oPolicyInfo.getShowUpgradeVersion();
            int iPolicyState = oPolicyInfo.getPolicyState();
            String sPolicyStete = iPolicyState == 0 ? sRunState : sSuspendState;
            oCellData[4] = sPolicyStete;
            this.m_oTableModel.addRow(oCellData);
        }
        this.refreshSelectedMxuPolicyLst();
        this.refreshBtnStatus();
    }

    private void initDevTypeCombox(List<MxuPolicyInfo> oMxuPolicyInfoLst, String sDevTypeName) {
        if (null == this.m_oNETypeCombox) {
            return;
        }
        this.m_oNETypeCombox.setEnabled(true);
        this.m_oNETypeCombox.removeAllItems();
        if (null == oMxuPolicyInfoLst || oMxuPolicyInfoLst.size() == 0) {
            this.m_oNETypeCombox.setEnabled(false);
            return;
        }
        this.m_oNETypeCombox.setEnabled(true);
        this.m_oNETypeCombox.addItem(DCConstants.ALL_TYPE);
        ArrayList<String> oDevTypeNameLst = new ArrayList<String>();
        String sDestDevTypeName = "";
        for (MxuPolicyInfo oMxuPolicy : oMxuPolicyInfoLst) {
            if (null == oMxuPolicy || oDevTypeNameLst.contains(sDestDevTypeName = oMxuPolicy.getDevTypeName())) continue;
            this.m_oNETypeCombox.addItem(sDestDevTypeName);
            oDevTypeNameLst.add(sDestDevTypeName);
            if (!Collator.getInstance().equals(sDevTypeName, sDestDevTypeName)) continue;
            this.m_oNETypeCombox.setSelectedItem(sDestDevTypeName);
        }
    }

    public void cleardata() {
        this.m_oTableModel.getDataVector().clear();
    }

    private void refreshBtnStatus() {
        int iSelectCount = this.m_oTable.getSelectedRowCount();
        boolean bEanble = iSelectCount > 0;
        this.m_oSaveBtn.setEnabled(bEanble);
        this.m_oPopupManager.loadMenu();
        this.m_oModifyBtn.setEnabled(this.m_oPopupManager.isMenuItemEnable("ModifyMxuPolicy"));
        this.m_oStartBtn.setEnabled(this.m_oPopupManager.isMenuItemEnable("StartMxuPolicy"));
        this.m_oSuspendBtn.setEnabled(this.m_oPopupManager.isMenuItemEnable("StopMxuPolicy"));
    }

    private void alignComponents() {
        this.setLayout(new GridBagLayout());
        this.m_oNETypeLbl.setPreferredSize(new Dimension(100, 20));
        this.m_oNETypeLbl.setMinimumSize(new Dimension(100, 20));
        this.m_oNETypeCombox.setPreferredSize(new Dimension(200, 20));
        this.m_oNETypeCombox.setMinimumSize(new Dimension(200, 20));
    }

    private void addComponent() {
        this.add((Component)this.m_oNETyePanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 1, 6, 4, 1.0, 1.0, 11, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.m_oSelectCountLabel, new GridBagConstraints(0, 7, 1, 4, 1.0, 0.0, 17, 1, new Insets(12, 12, 12, 0), 0, 0));
        this.add((Component)this.m_oModifyBtn, new GridBagConstraints(1, 7, 1, 4, 0.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.add((Component)this.m_oStartBtn, new GridBagConstraints(2, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 0), 0, 0));
        this.add((Component)this.m_oSuspendBtn, new GridBagConstraints(3, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 0), 0, 0));
        this.add((Component)this.m_oSaveBtn, new GridBagConstraints(4, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 0), 0, 0));
        this.add((Component)this.m_oCloseBtn, new GridBagConstraints(5, 7, 1, 4, 0.0, 0.0, 10, 0, new Insets(12, 4, 12, 12), 0, 0));
    }

    private String[] getColumn() {
        String[] sColunms = new String[]{this.m_oRes.getResString("hidenColumn"), this.m_oRes.getResString("MXU_TABLE_COLUMN_PHYSICAL_PATH"), this.m_oRes.getResString("DEVICE_TYPE"), this.m_oRes.getResString("TASK_TABLE_COLUMN_UPGRADE_VERSION"), this.m_oRes.getResString("POLICY_STATE")};
        return sColunms;
    }

    private int getColumnSize() {
        return this.getColumn().length;
    }

    public DCExtendedTable getTable() {
        return this.m_oTable;
    }

    public DCSortableTableModel getTableModel() {
        return this.m_oTableModel;
    }

    private void refreshSelectedDevCountLabel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int iSelectCount = MXUPolicyMainPanel.this.m_oTable.getSelectedRowCount();
                int iTotolCount = MXUPolicyMainPanel.this.m_oTable.getRowCount();
                if (iTotolCount == 0) {
                    iSelectCount = 0;
                }
                String strDeviceCountMsg = MessageFormat.format(MXUPolicyMainPanel.this.m_oSelectCountTxt, "" + iSelectCount, "" + iTotolCount);
                MXUPolicyMainPanel.this.m_oSelectCountLabel.setText("<HTML>" + strDeviceCountMsg + "</HTML>");
            }
        });
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        if (null == oEventObject || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject)) {
            DCFrameWorkUtil.defaultCursor();
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        TreeNodeInfo oNodeInfo = (TreeNodeInfo)oEventObject.getSource();
        SubMapNodeInfo oSubmapNode = oNodeInfo.m_oSubMapNodeInfo;
        if (null == oSubmapNode) {
            this.m_sSelectedSubmapID = "";
            List<MxuPolicyInfo> oPolicyLst = PolicyManager.getInstance().generateAllMxuPolicyLst();
            this.initDate(oPolicyLst, this.m_sSelectedNEType);
            DCFrameWorkUtil.defaultCursor();
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.m_sSelectedSubmapID = oSubmapNode.m_submapId;
        List<MxuPolicyInfo> oPolicyLst = null;
        SubMapInfo oSubmapInfo = DeviceInfoManagerImpl.getInstance().getSubmapForID(this.m_sSelectedSubmapID, DeviceInfoManagerImpl.getInstance().getOLTSubmapInfo());
        String sParentSubmapID = oSubmapInfo.m_strParentSubMapID;
        if (Collator.getInstance().equals("", sParentSubmapID) || Collator.getInstance().equals("", this.m_sSelectedSubmapID)) {
            oPolicyLst = PolicyManager.getInstance().generateAllMxuPolicyLst();
            this.initDate(oPolicyLst, this.m_sSelectedNEType);
        } else {
            oPolicyLst = PolicyUtil.generateMxuPolicyLst(this.m_sSelectedSubmapID);
            this.initDate(oPolicyLst, this.m_sSelectedNEType);
        }
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initDate(List<MxuPolicyInfo> oPolicyLst, String sDevTypeName) {
        this.m_oNETypeCombox.removeItemListener(this.m_ONETypeCombxoListener);
        this.initTableData(oPolicyLst, sDevTypeName);
        this.initDevTypeCombox(oPolicyLst, sDevTypeName);
        this.m_oNETypeCombox.addItemListener(this.m_ONETypeCombxoListener);
        this.updateGUI();
    }

    public void updateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MXUPolicyMainPanel.this.m_oTable.updateUI();
                MXUPolicyMainPanel.this.m_oScrollPane.updateUI();
            }
        });
    }

    private void refreshSelectedMxuPolicyLst() {
        if (null == this.m_oSelectedMxuPolicyLst || this.m_oSelectedMxuPolicyLst.size() == 0) {
            if (this.m_oTable.getRowCount() > 0) {
                this.m_oTable.setRowSelectionInterval(0, 0);
                MxuPolicyInfo oMxuPolicy = (MxuPolicyInfo)this.m_oTable.getValueAt(0, 0);
                this.m_oSelectedMxuPolicyLst = new ArrayList<MxuPolicyInfo>();
                this.m_oSelectedMxuPolicyLst.add(oMxuPolicy);
            }
        } else {
            for (int i = this.m_oSelectedMxuPolicyLst.size() - 1; i >= 0; --i) {
                MxuPolicyInfo oPolicyInfo = this.m_oSelectedMxuPolicyLst.get(i);
                boolean bSetResult = this.setPolicySelected(oPolicyInfo);
                if (bSetResult) continue;
                this.m_oSelectedMxuPolicyLst.remove(i);
            }
            int iSelectRowCount = this.m_oTable.getSelectedRowCount();
            if (iSelectRowCount < 1 && this.m_oTable.getRowCount() > 0) {
                this.m_oTable.setRowSelectionInterval(0, 0);
                MxuPolicyInfo oMxuPolicy = (MxuPolicyInfo)this.m_oTable.getValueAt(0, 0);
                this.m_oSelectedMxuPolicyLst = new ArrayList<MxuPolicyInfo>();
                this.m_oSelectedMxuPolicyLst.add(oMxuPolicy);
            }
        }
    }

    private boolean setPolicySelected(MxuPolicyInfo oPolicyInfo) {
        int iRowCount = this.m_oTable.getRowCount();
        if (iRowCount < 1) {
            return false;
        }
        MxuPolicyInfo oPolicy = null;
        for (int i = 0; i < iRowCount; ++i) {
            oPolicy = (MxuPolicyInfo)this.m_oTable.getValueAt(i, 0);
            if (!oPolicy.getSubmapId().equals(oPolicyInfo.getSubmapId()) || oPolicy.getDevTypeID() != oPolicyInfo.getDevTypeID() || oPolicy.getDevTypeVerID() != oPolicyInfo.getDevTypeVerID()) continue;
            this.m_oTable.addRowSelectionInterval(i, i);
            return true;
        }
        return false;
    }

    private void modifyBtnActinPerformed() {
        this.m_oPolicyTableMenuItemHandler.modifyMxuPolicy();
    }

    private void startBtnActinPerformed() {
        this.m_oPolicyTableMenuItemHandler.startMxuPolicy();
    }

    private void suspendBtnActinPerformed() {
        this.m_oPolicyTableMenuItemHandler.stopMxuPolicy();
    }

    private void saveBtnActinPerformed() {
        this.m_oPolicyTableMenuItemHandler.saveAsMxuPolicy();
    }

    private void closeBtnActionPerformed() {
        MXUPolicyDlg oMainDlg = DCFrameWorkUtil.getMXUPolicyDlg();
        if (null != oMainDlg) {
            oMainDlg.dispose();
        }
        DCFrameWorkUtil.setMXUPolicyDlg(null);
    }

    class TableSelectionListener
    implements ListSelectionListener {
        private MXUPolicyMainPanel m_oPalicyTablePanelRef;

        public TableSelectionListener(MXUPolicyMainPanel parent) {
            this.m_oPalicyTablePanelRef = parent;
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (!arg0.getValueIsAdjusting() && null != this.m_oPalicyTablePanelRef) {
                MXUPolicyMainPanel.this.refreshSelectedDevCountLabel();
                MXUPolicyMainPanel.this.refreshBtnStatus();
            }
        }
    }
}

