/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.mxupolicy;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeFactory;
import com.huawei.dc.common.components.tree.devicetree.descriptor.MXUDeviceTreeDescriptor;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.TreeHelper;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.mxupolicy.MXUPolicyMainPanel;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MXUPolicyDlg
extends DCModalDialog {
    private static final long serialVersionUID = 8906217909167842830L;
    private JPanel m_oSubmapTreePanel = null;
    private MXUPolicyMainPanel m_oMainPanel = null;
    private DeviceTree m_oSubMapTree = null;
    private IDeviceInfoManager m_oDevInfoMgr = null;
    private JSplitPane m_oHorizontalSplitPane;
    JButton m_oApplyBtn = null;
    private static final int WIDTH = 1000;
    private static final int HEIGHT = 618;

    public MXUPolicyDlg() {
        this.initGUI();
        this.initData();
    }

    public void initGUI() {
        this.initSubmapTreePanel();
        this.initMainPanel();
        this.addComponent();
        this.addMsgListener();
        DCFrameWorkUtil.setMXUPolicyDlg(this);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void initData() {
        SubMapInfo oOLTSubmap = DeviceInfoManagerImpl.getInstance().getOLTSubmapInfo();
        if (null == oOLTSubmap.m_SubMapList || null == oOLTSubmap.m_strSubMapID) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("MXU_NO_OLT_SUBMAP"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        DefaultMutableTreeNode oRootNode = this.m_oSubMapTree.getRoot();
        this.m_oSubMapTree.notifyNodeSelection(oRootNode);
    }

    private void initSubmapTreePanel() {
        MXUDeviceTreeDescriptor oCurrentTreeDes = new MXUDeviceTreeDescriptor(7);
        oCurrentTreeDes.setTreeSelectable(true);
        this.m_oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        this.m_oSubMapTree = DeviceTreeFactory.createDeviceTree(oCurrentTreeDes, this.m_oDevInfoMgr, ResourceManager.getInstance().getResString("DEVICE_TREE_PAN_ROOT_NODE"));
        this.m_oSubMapTree.setName("policy_MXUPolicyDlg_m_oSubmapTree");
        DefaultMutableTreeNode oRootNode = this.m_oSubMapTree.getRoot();
        TreePath trePath = new TreePath(oRootNode);
        TreeHelper.expandAll(this.m_oSubMapTree, trePath, true);
        TreePath oTreePath = new TreePath(oRootNode.getPath());
        this.m_oSubMapTree.setSelectionPath(oTreePath);
        this.m_oSubMapTree.expandPath(oTreePath);
        this.m_oSubMapTree.scrollPathToVisible(oTreePath);
        this.m_oSubmapTreePanel = new JPanel();
        this.m_oSubmapTreePanel.setLayout(new BorderLayout());
        JScrollPane oScrollPane = new JScrollPane(this.m_oSubMapTree);
        Border oBorder = BorderFactory.createEtchedBorder(1);
        this.m_oSubmapTreePanel.setMinimumSize(new Dimension(150, 200));
        this.m_oSubmapTreePanel.setBorder(oBorder);
        this.m_oSubmapTreePanel.add(oScrollPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != MXUPolicyDlg.this.m_oSubMapTree) {
                    MXUPolicyDlg.this.m_oSubMapTree.updateUI();
                }
            }
        });
    }

    private void addMsgListener() {
        if (null == this.m_oSubMapTree) {
            return;
        }
        this.m_oSubMapTree.registerForTreeSelectionEvent(this.m_oMainPanel);
    }

    private void initMainPanel() {
        this.m_oMainPanel = new MXUPolicyMainPanel();
    }

    private void addComponent() {
        this.setTitle(DCFrameWorkUtil.getLocalizedString("MXU_CONFIG_DLG_TLE"));
        this.setLayout(new GridBagLayout());
        this.setSize(1000, 618);
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setName("PolicyMgmtPanel_m_oHorizontalSplitPane");
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(200);
        this.m_oHorizontalSplitPane.setDividerSize(6);
        this.m_oHorizontalSplitPane.add((Component)this.m_oSubmapTreePanel, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_oMainPanel, "right");
        TitledBorder oHABackupPolicyBorder = BorderFactory.createTitledBorder(DCFrameWorkUtil.getLocalizedString(""));
        this.m_oHorizontalSplitPane.setBorder(oHABackupPolicyBorder);
        this.getContentPane().add((Component)this.m_oHorizontalSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 12, 12, 12), 0, 0));
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    public void modifyPolicy(MxuPolicyInfo oMxuPolicyInfo) {
        if (null != this.m_oMainPanel) {
            this.m_oMainPanel.modifyPolicy(oMxuPolicyInfo);
        }
    }

    public void updateTabel() {
        if (null != this.m_oMainPanel) {
            this.m_oMainPanel.updateGUI();
        }
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_MXU_POLICY_BMS";
    }
}

