/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.model;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyProgressInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PolicyInfo
implements Serializable {
    private static final long serialVersionUID = -5801690779501949204L;
    private int iPolicyID = -1;
    private String sPolicyName = "";
    private List<PolicyTypeInfo> m_oPolicyTypeInfoLst = new ArrayList<PolicyTypeInfo>();
    private List<PolicyDevTypeProperties> m_oPolicyDevTypePropLst = null;
    private THashMap<Integer, DevicePolicyState> oDevPolicyStateHm = null;
    private List<Integer> m_iChangedDevIdLst = null;
    private boolean m_isDevChange = false;
    private HashMap<String, TIntHashSet> m_oDevListForEverySubnet = new HashMap();
    private Vector<String> m_oEmptySubnetVec = new Vector();

    public int getPolicyID() {
        return this.iPolicyID;
    }

    public void setPolicyID(int iPolicyID) {
        this.iPolicyID = iPolicyID;
    }

    public String getPolicyName() {
        return this.sPolicyName;
    }

    public void setPolicyName(String sPolicyName) {
        this.sPolicyName = sPolicyName;
    }

    public List<PolicyTypeInfo> getPolicyTypeInfoLst() {
        return this.m_oPolicyTypeInfoLst;
    }

    public void setPolicyTypeInfoLst(List<PolicyTypeInfo> mOPolicyTypeInfoLst) {
        this.m_oPolicyTypeInfoLst = mOPolicyTypeInfoLst;
    }

    public List<PolicyDevTypeProperties> getPolicyDevTypePropLst() {
        return this.m_oPolicyDevTypePropLst;
    }

    public void setPolicyDevTypePropLst(List<PolicyDevTypeProperties> mOPolicyDevTypePropLst) {
        this.m_oPolicyDevTypePropLst = mOPolicyDevTypePropLst;
    }

    public PolicyTypeInfo getPolicyTypeInfo(int iPolicyType) {
        for (PolicyTypeInfo oPolicyTypeInfo : this.m_oPolicyTypeInfoLst) {
            if (oPolicyTypeInfo.getPolicyType() != iPolicyType) continue;
            return oPolicyTypeInfo;
        }
        return null;
    }

    public THashMap<Integer, DevicePolicyState> getDevicePolicyStateHm(String sSubmapID) {
        DCDebugTracer.trace("PolicyInfo::getDevicePolicyStateHm::begin");
        if (null == this.oDevPolicyStateHm) {
            DCDebugTracer.trace("PolicyInfo::getDevicePolicyStateHm::oDevPolicyStateHm->null.");
            return null;
        }
        THashMap oDevHm = new THashMap();
        TIntHashSet oDevIDSet = this.m_oDevListForEverySubnet.get(sSubmapID);
        if (null == oDevIDSet || 0 == oDevIDSet.size()) {
            return this.oDevPolicyStateHm;
        }
        DCDebugTracer.trace("PolicyInfo::getDevicePolicyStateHm->" + oDevIDSet.size() + "name->" + this.getPolicyName());
        Set oDevSet = this.oDevPolicyStateHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            if (!oDevIDSet.contains(((Integer)element.getKey()).intValue())) continue;
            oDevHm.put(element.getKey(), element.getValue());
        }
        DCDebugTracer.trace("PolicyInfo::getDevicePolicyStateHm::end");
        return oDevHm;
    }

    public THashMap<Integer, DevicePolicyState> getDevicePolicyStateHm() {
        return this.oDevPolicyStateHm;
    }

    public void setDevicePolicyStateHm(THashMap<Integer, DevicePolicyState> oDevicePolicyStateHm) {
        this.oDevPolicyStateHm = oDevicePolicyStateHm;
    }

    public TIntHashSet getDevIDLst() {
        if (null == this.oDevPolicyStateHm) {
            return null;
        }
        Set oDevSet = this.oDevPolicyStateHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        TIntHashSet oDevIDLst = new TIntHashSet(oDevSet.size());
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            if (null == element.getValue()) continue;
            oDevIDLst.add(((Integer)element.getKey()).intValue());
        }
        return oDevIDLst;
    }

    public void removeDevice(int iDevID) {
        if (null == this.oDevPolicyStateHm || this.oDevPolicyStateHm.size() == 0) {
            return;
        }
        DCDebugTracer.trace("PolicyInfo :: removeDevice devID->" + iDevID);
        this.oDevPolicyStateHm.remove((Object)iDevID);
        this.removeDeviceFormSubnet(iDevID);
    }

    private void removeDeviceFormSubnet(int iDevID) {
        if (null == this.m_oDevListForEverySubnet || 0 == this.m_oDevListForEverySubnet.size()) {
            DCDebugTracer.trace("PolicyInfo :: removeDeviceFormSubnet :: return.");
            return;
        }
        Set<Map.Entry<String, TIntHashSet>> oDevListForEverySubnetSet = this.m_oDevListForEverySubnet.entrySet();
        Iterator<Map.Entry<String, TIntHashSet>> oDevListForEverySubnetSetItor = oDevListForEverySubnetSet.iterator();
        Map.Entry<String, TIntHashSet> element = null;
        while (oDevListForEverySubnetSetItor.hasNext()) {
            element = oDevListForEverySubnetSetItor.next();
            if (null == element.getValue() || !element.getValue().contains(iDevID)) continue;
            element.getValue().remove(iDevID);
            if (0 != element.getValue().size()) continue;
            this.m_oEmptySubnetVec.add(element.getKey());
        }
        if (0 < this.m_oEmptySubnetVec.size()) {
            for (String submapID : this.m_oEmptySubnetVec) {
                this.m_oDevListForEverySubnet.remove(submapID);
            }
        }
    }

    public void removeDevice(TIntArrayList oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            return;
        }
        int iDevID = -1;
        for (int i = 0; i < oDevIDLst.size(); ++i) {
            iDevID = oDevIDLst.get(i);
            this.removeDevice(iDevID);
        }
    }

    public boolean addDevice(DeviceInfo oDev) {
        int iDevID;
        boolean bExist;
        if (null == oDev) {
            return false;
        }
        if (null == this.oDevPolicyStateHm) {
            this.oDevPolicyStateHm = new THashMap();
        }
        if (bExist = this.isContainsDevice(iDevID = oDev.getDevId())) {
            return false;
        }
        DevicePolicyState oDevInfo = new DevicePolicyState();
        oDevInfo.setDevID(iDevID);
        oDevInfo.setNEName(oDev.getDevName());
        oDevInfo.setIPAdress(oDev.getDevIPAddress());
        DeviceTypeInfo oDevType = oDev.getDeviceTypeInfo();
        oDevInfo.setDevTypeID(oDevType.getDevTypeID());
        oDevInfo.setDevTypeVerID(oDevType.getDevTypeVersionId());
        oDevInfo.setNETypeName(oDevType.getDevTypeName());
        oDevInfo.setBakcupPolicyState(this.getPolicyState(0));
        oDevInfo.setSavePolicyState(this.getPolicyState(1));
        SubMapInfo oMainSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
        SubMapInfo oSubmap = DeviceInfoManagerImpl.getInstance().getSubMapInfoByDevID(oMainSubmap, iDevID);
        oDevInfo.setSubMapId(oSubmap.m_strSubMapID);
        this.oDevPolicyStateHm.put((Object)iDevID, (Object)oDevInfo);
        this.addDeviceToSubnet(oMainSubmap, oSubmap.m_strSubMapID, iDevID);
        return true;
    }

    public boolean addDevice(THashMap<Integer, DevicePolicyState> oDevHm) {
        if (null == oDevHm) {
            return false;
        }
        Set oDevSet = oDevHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        while (oDevItor.hasNext()) {
            this.addDevice((DevicePolicyState)((Map.Entry)oDevItor.next()).getValue());
        }
        return true;
    }

    public boolean addDevice(DevicePolicyState oDev) {
        Map<Integer, SubMapInfo> m_oSubMapList;
        SubMapInfo oSubMapInfo;
        int iDevID;
        boolean bExist;
        if (null == this.oDevPolicyStateHm) {
            this.oDevPolicyStateHm = new THashMap();
        }
        if (bExist = this.isContainsDevice(iDevID = oDev.getDevID())) {
            return false;
        }
        oDev.setBakcupPolicyState(this.getPolicyState(0));
        oDev.setSavePolicyState(this.getPolicyState(1));
        if (null == oDev.getSubMapId() && null != (oSubMapInfo = (m_oSubMapList = DeviceInfoManagerImpl.getInstance().getSubMapList()).get(iDevID))) {
            oDev.setSubMapId(oSubMapInfo.m_strSubMapID);
            SubMapInfo oMainSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubMapInfo();
            this.addDeviceToSubnet(oMainSubMapInfo, oSubMapInfo.m_strSubMapID, iDevID);
        }
        this.oDevPolicyStateHm.put((Object)iDevID, (Object)oDev);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDeviceToSubnet(SubMapInfo oMainSubMapInfo, String strChildSubMapID, int iDeviceID) {
        SubMapInfo oChildSubMapInfo = DeviceInfoManagerImpl.getInstance().getSubmapForID(strChildSubMapID);
        if (null != oChildSubMapInfo) {
            if (this.m_oDevListForEverySubnet.containsKey(oChildSubMapInfo.m_strSubMapID)) {
                this.m_oDevListForEverySubnet.get(oChildSubMapInfo.m_strSubMapID).add(iDeviceID);
            } else {
                TIntHashSet devsIDSet = new TIntHashSet();
                devsIDSet.add(iDeviceID);
                this.m_oDevListForEverySubnet.put(oChildSubMapInfo.m_strSubMapID, devsIDSet);
            }
            if ("".equals(oChildSubMapInfo.m_strParentSubMapID)) return;
            this.addDeviceToSubnet(oMainSubMapInfo, oChildSubMapInfo.m_strParentSubMapID, iDeviceID);
            return;
        } else {
            DCDebugTracer.trace("PolicyInfo::addDeviceToSubnet::oChildSubMapInfo is null->SubMapID::" + strChildSubMapID);
        }
    }

    public boolean addDevice(int iDevID) {
        boolean bExist;
        if (null == this.oDevPolicyStateHm) {
            this.oDevPolicyStateHm = new THashMap();
        }
        if (bExist = this.isContainsDevice(iDevID)) {
            return false;
        }
        DevicePolicyState oDev = new DevicePolicyState();
        oDev.setDevID(iDevID);
        oDev.setBakcupPolicyState(this.getPolicyState(0));
        oDev.setSavePolicyState(this.getPolicyState(1));
        this.oDevPolicyStateHm.put((Object)iDevID, (Object)oDev);
        return true;
    }

    public void addDevice(TIntArrayList oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            return;
        }
        int iDevID = -1;
        for (int i = 0; i < oDevIDLst.size(); ++i) {
            iDevID = oDevIDLst.get(i);
            this.addDevice(iDevID);
        }
    }

    public int getPolicyState(int iPolicyType) {
        for (PolicyTypeInfo oPolicyType : this.m_oPolicyTypeInfoLst) {
            if (oPolicyType.getPolicyType() != iPolicyType) continue;
            return oPolicyType.getPolicyStatus();
        }
        return -1;
    }

    public PolicyDevTypeProperties getDevPropreties(int iDevTypeID) {
        if (null == this.m_oPolicyDevTypePropLst) {
            return null;
        }
        for (PolicyDevTypeProperties oDevProperties : this.m_oPolicyDevTypePropLst) {
            if (null == oDevProperties || oDevProperties.getDevTypeID() != iDevTypeID) continue;
            return oDevProperties;
        }
        return null;
    }

    public boolean isDevSupportSavePolicy(DevicePolicyState oDev, int iPolicyType) {
        boolean bSupport = false;
        if (null == this.m_oPolicyDevTypePropLst) {
            return false;
        }
        int iDevTypeID = oDev.getDevTypeID();
        PolicyDevTypeProperties oDevPro = null;
        for (int i = 0; i < this.m_oPolicyDevTypePropLst.size(); ++i) {
            oDevPro = this.m_oPolicyDevTypePropLst.get(i);
            if (null == oDevPro || oDevPro.getDevTypeID() != iDevTypeID) continue;
            Object oSave = oDevPro.isSaveBeforeBackup();
            return null != oSave;
        }
        return bSupport;
    }

    public List<PolicyDevTypeProperties> getDevTypeProLst(int iDevDomain) {
        if (null == this.m_oPolicyDevTypePropLst || this.m_oPolicyDevTypePropLst.size() == 0) {
            return null;
        }
        int iDevTypeID = 0;
        int iDevTypeVerID = 0;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo oDevTypeInfo = null;
        ArrayList<PolicyDevTypeProperties> oDevTypeProLst = new ArrayList<PolicyDevTypeProperties>();
        for (PolicyDevTypeProperties oDevTypePro : this.m_oPolicyDevTypePropLst) {
            iDevTypeID = oDevTypePro.getDevTypeID();
            oDevTypeInfo = oDevMgr.getDeviceTypeInfo(iDevTypeID, iDevTypeVerID = oDevMgr.getDeviceTypeVersionId(iDevTypeID));
            if (null == oDevTypeInfo || oDevTypeInfo.getDevDomain() != iDevDomain) continue;
            oDevTypeProLst.add(oDevTypePro);
        }
        return oDevTypeProLst;
    }

    public List<PolicyDevTypeProperties> getDevTypeProLst() {
        if (null == this.m_oPolicyDevTypePropLst || this.m_oPolicyDevTypePropLst.size() == 0) {
            return null;
        }
        int iDevTypeID = 0;
        int iDevTypeVerID = 0;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo oDevTypeInfo = null;
        ArrayList<PolicyDevTypeProperties> oDevTypeProLst = new ArrayList<PolicyDevTypeProperties>();
        for (PolicyDevTypeProperties oDevTypePro : this.m_oPolicyDevTypePropLst) {
            iDevTypeID = oDevTypePro.getDevTypeID();
            oDevTypeInfo = oDevMgr.getDeviceTypeInfo(iDevTypeID, iDevTypeVerID = oDevMgr.getDeviceTypeVersionId(iDevTypeID));
            if (null == oDevTypeInfo) continue;
            oDevTypeProLst.add(oDevTypePro);
        }
        return oDevTypeProLst;
    }

    public boolean isContainsDevice(int iDevID) {
        if (null == this.oDevPolicyStateHm || this.oDevPolicyStateHm.size() == 0) {
            return false;
        }
        return this.oDevPolicyStateHm.containsKey((Object)iDevID);
    }

    public boolean isDefaultPolicy() {
        return this.iPolicyID == 0;
    }

    public String toString() {
        return this.sPolicyName;
    }

    public ConfigChangePolicyInfo getConfigChangeInfo(int iDevTypeID, int iConfigChangeType) {
        PolicyDevTypeProperties oDevpro = this.getDevPropreties(iDevTypeID);
        if (null != oDevpro) {
            ConfigChangePolicyInfo oConfigChange = oDevpro.getConfigChangePolicyInfo(0);
            return oConfigChange;
        }
        return null;
    }

    public void setDeviceProgress(int iDevID, PolicyProgressInfo oPregress) {
        if (null == this.oDevPolicyStateHm) {
            return;
        }
        DevicePolicyState oDev = (DevicePolicyState)this.oDevPolicyStateHm.get((Object)iDevID);
        if (null != oDev) {
            oDev.setPropressInfo(oPregress);
        }
    }

    public void refreshDevStatus(PolicyProgressInfo oPolicyProgressInfo) {
        DCDebugTracer.trace("[POLICY]PolicyInfo#refreshDevStatus:in");
        if (null == this.oDevPolicyStateHm) {
            DCDebugTracer.trace("[POLICY]PolicyInfo#refreshDevStatus:---->null == oDevPolicyStateHm");
            return;
        }
        int iDevTypeID = -1;
        int iConfigChangeType = 0;
        ConfigChangePolicyInfo oConfigInfo = null;
        Set oDevSet = this.oDevPolicyStateHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        DevicePolicyState oDev = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            oDev = (DevicePolicyState)element.getValue();
            if (null == oDev || null == (oConfigInfo = this.getConfigChangeInfo(iDevTypeID = oDev.getDevTypeID(), iConfigChangeType)) || !oConfigInfo.isSelected()) continue;
            oDev.setPropressInfo(oPolicyProgressInfo);
        }
        DCDebugTracer.trace("[POLICY]PolicyInfo#refreshDevStatus:out");
    }

    public DevicePolicyState getDevicePolicyState(int iDevID) {
        if (null == this.oDevPolicyStateHm) {
            return null;
        }
        return (DevicePolicyState)this.oDevPolicyStateHm.get((Object)iDevID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.iPolicyID;
        result = 31 * result + (this.m_oPolicyDevTypePropLst == null ? 0 : ((Object)this.m_oPolicyDevTypePropLst).hashCode());
        result = 31 * result + (this.m_oPolicyTypeInfoLst == null ? 0 : ((Object)this.m_oPolicyTypeInfoLst).hashCode());
        result = 31 * result + (this.oDevPolicyStateHm == null ? 0 : this.oDevPolicyStateHm.hashCode());
        result = 31 * result + (this.sPolicyName == null ? 0 : this.sPolicyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolicyInfo other = (PolicyInfo)obj;
        if (this.iPolicyID != other.iPolicyID) {
            return false;
        }
        if (this.m_oPolicyDevTypePropLst == null ? other.m_oPolicyDevTypePropLst != null : !((Object)this.m_oPolicyDevTypePropLst).equals(other.m_oPolicyDevTypePropLst)) {
            return false;
        }
        if (this.m_oPolicyTypeInfoLst == null ? other.m_oPolicyTypeInfoLst != null : !((Object)this.m_oPolicyTypeInfoLst).equals(other.m_oPolicyTypeInfoLst)) {
            return false;
        }
        if (this.oDevPolicyStateHm == null ? other.oDevPolicyStateHm != null : !this.oDevPolicyStateHm.equals(other.oDevPolicyStateHm)) {
            return false;
        }
        return !(this.sPolicyName == null ? other.sPolicyName != null : !this.sPolicyName.equals(other.sPolicyName));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getPolicyPeriodInfo(int iPolicyPeriodType) {
        String sPeriod = "";
        if (this.m_oPolicyTypeInfoLst.size() <= 0) {
            return sPeriod;
        }
        ArrayList<PolicyTypeInfo> backupTypeInfoList = new ArrayList<PolicyTypeInfo>();
        ArrayList<PolicyTypeInfo> saveTypeInfoList = new ArrayList<PolicyTypeInfo>();
        for (PolicyTypeInfo oPolicyTypeInfo : this.m_oPolicyTypeInfoLst) {
            if (oPolicyTypeInfo.getPolicyType() == 0) {
                backupTypeInfoList.add(oPolicyTypeInfo);
            }
            if (oPolicyTypeInfo.getPolicyType() != 1) continue;
            saveTypeInfoList.add(oPolicyTypeInfo);
        }
        if (iPolicyPeriodType == 0) {
            sPeriod = this.getPeriodPolicyInfo(sPeriod, backupTypeInfoList);
        }
        if (iPolicyPeriodType == 1) {
            sPeriod = this.getPeriodPolicyInfo(sPeriod, saveTypeInfoList);
        }
        return sPeriod;
    }

    private String getPeriodPolicyInfo(String sPeriod, List<PolicyTypeInfo> oPolicyTypeInfoList) {
        if (oPolicyTypeInfoList.size() < 1) {
            return "";
        }
        PolicyTypeInfo oPolicyTypeInfo = oPolicyTypeInfoList.get(0);
        if (oPolicyTypeInfo.getPolicyPeriod() == 0) {
            sPeriod = this.getPolicyPeriodInfoByMonth(oPolicyTypeInfoList);
        } else if (oPolicyTypeInfo.getPolicyPeriod() == 1) {
            sPeriod = this.getPolicyPeriodInfoByWeek(oPolicyTypeInfoList);
        } else if (oPolicyTypeInfo.getPolicyPeriod() == 2) {
            sPeriod = this.getPolicyPeriodInfoByDay(oPolicyTypeInfo);
        }
        return sPeriod;
    }

    private String getPolicyPeriodInfoByDay(PolicyTypeInfo oPolicyTypeInfo) {
        StringBuffer sPolicyBuf = new StringBuffer(0);
        String seperator = ",";
        String sPeriod = ResourceManager.getInstance().getResString("POLICY_PERIOD_DAILY");
        sPolicyBuf.append(sPeriod).append(seperator);
        String sTime = DCTimeDateUtil.convertTo12HrFormat(oPolicyTypeInfo.getPolicyTime());
        sPolicyBuf.append(sTime);
        return sPolicyBuf.toString();
    }

    private String getPolicyPeriodInfoByWeek(List<PolicyTypeInfo> oWeekPolicyTypeInfo) {
        StringBuffer sPolicyBuf = new StringBuffer(0);
        PolicyTypeInfo oPolicyTypeInfo = oWeekPolicyTypeInfo.get(0);
        String seperator = ",";
        String sPeriod = ResourceManager.getInstance().getResString("POLICY_PERIOD_WEEKLY");
        sPolicyBuf.append(sPeriod).append(seperator);
        for (PolicyTypeInfo policyTypeInfo : oWeekPolicyTypeInfo) {
            int iDayInWeek = policyTypeInfo.getPolicyDayInWeek();
            sPolicyBuf.append(this.getDayForWeek(iDayInWeek));
            sPolicyBuf.append(seperator);
        }
        String sTime = DCTimeDateUtil.convertTo12HrFormat(oPolicyTypeInfo.getPolicyTime());
        sPolicyBuf.append(sTime);
        return sPolicyBuf.toString();
    }

    private String getPolicyPeriodInfoByMonth(List<PolicyTypeInfo> oMonthPolicyTypeInfo) {
        StringBuffer sPolicyBuf = new StringBuffer(0);
        PolicyTypeInfo oPolicyTypeInfo = oMonthPolicyTypeInfo.get(0);
        String seperator = ",";
        String space = "  ";
        int start = 0;
        String sPeriod = ResourceManager.getInstance().getResString("POLICY_PERIOD_MONTHLY");
        sPolicyBuf.append(sPeriod).append(seperator);
        for (PolicyTypeInfo policyTypeInfo : oMonthPolicyTypeInfo) {
            sPolicyBuf.append(policyTypeInfo.getPolicyDayInMonth());
            sPolicyBuf.append(seperator);
        }
        String sTime = DCTimeDateUtil.convertTo12HrFormat(oPolicyTypeInfo.getPolicyTime());
        String sdays = sPolicyBuf.toString();
        sdays = sdays.endsWith(seperator) ? sdays.substring(start, sdays.length() - 1) + space + sTime : sdays + space + sTime;
        return sdays;
    }

    private String getDayForWeek(int iDayInWeek) {
        return ResourceManager.getInstance().getResString("POLICY_WEEK_DAY_" + iDayInWeek);
    }

    private String getPeriod(int iPeriod) {
        String sPeriod = "";
        switch (iPeriod) {
            case 0: {
                return ResourceManager.getInstance().getResString("POLICY_PERIOD_MONTHLY");
            }
            case 1: {
                return ResourceManager.getInstance().getResString("POLICY_PERIOD_WEEKLY");
            }
            case 2: {
                return ResourceManager.getInstance().getResString("POLICY_PERIOD_DAILY");
            }
        }
        return sPeriod;
    }

    public List<Integer> getChangedDevIdLst() {
        return this.m_iChangedDevIdLst;
    }

    public void setChangedDevIdLst(List<Integer> iChangedDevIdLst) {
        this.m_iChangedDevIdLst = iChangedDevIdLst;
    }

    public boolean isDevChange() {
        return this.m_isDevChange;
    }

    public void setIsDevChange(boolean devChange) {
        this.m_isDevChange = devChange;
    }

    public HashMap<String, TIntHashSet> getDevListForEverySubnet() {
        return this.m_oDevListForEverySubnet;
    }

    public void setDevListForEverySubnet(HashMap<String, TIntHashSet> m_oDevListForEverySubnet) {
        this.m_oDevListForEverySubnet = m_oDevListForEverySubnet;
    }

    public Vector<String> getEmptySubnetVec() {
        return this.m_oEmptySubnetVec;
    }

    public void clearObject() {
        if (null != this.m_oPolicyTypeInfoLst) {
            this.m_oPolicyTypeInfoLst.clear();
            this.m_oPolicyTypeInfoLst = null;
        }
        if (null != this.m_oPolicyDevTypePropLst) {
            this.m_oPolicyDevTypePropLst.clear();
            this.m_oPolicyDevTypePropLst = null;
        }
        if (null != this.oDevPolicyStateHm) {
            this.oDevPolicyStateHm.clear();
            this.oDevPolicyStateHm = null;
        }
        if (null != this.m_iChangedDevIdLst) {
            this.m_iChangedDevIdLst.clear();
            this.m_iChangedDevIdLst = null;
        }
        if (null != this.m_oDevListForEverySubnet) {
            this.m_oDevListForEverySubnet.clear();
            this.m_oDevListForEverySubnet = null;
        }
        if (null != this.m_oEmptySubnetVec) {
            this.m_oEmptySubnetVec.clear();
            this.m_oEmptySubnetVec = null;
        }
    }
}

