/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.model;

import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PolicyDevTypeProperties
implements Serializable,
Comparable {
    private static final long serialVersionUID = -329739877012413942L;
    private int iDevTypeID = -1;
    private String sDevTypeName = "";
    private int iBackupContentType = -1;
    private int iSaveContentType = -1;
    private Object oSaveBeforeBackup = null;
    private int iNumOfBackupCopies = 0;
    private List<ConfigChangePolicyInfo> oSpecialPolicyLst = null;
    private List<ContentType> oBackupCotentTypeLst = null;
    private boolean isBackupToExternalFTP = false;
    private String strDestination = IUpdateDestinationListener.DESTINATION_NMS_SERVER;

    public int getDevTypeID() {
        return this.iDevTypeID;
    }

    public void setDevTypeID(int iDevTypeID) {
        this.iDevTypeID = iDevTypeID;
    }

    public String getDevTypeName() {
        return this.sDevTypeName;
    }

    public void setDevTypeName(String sDevTypeName) {
        this.sDevTypeName = sDevTypeName;
    }

    public int getBackupContentType() {
        return this.iBackupContentType;
    }

    public void setBackupContentType(int iBackupContentType) {
        this.iBackupContentType = iBackupContentType;
    }

    public int getSaveContentType() {
        return this.iSaveContentType;
    }

    public void setSaveContentType(int iSaveContentType) {
        this.iSaveContentType = iSaveContentType;
    }

    public Object isSaveBeforeBackup() {
        return this.oSaveBeforeBackup;
    }

    public void setSaveBeforeBackup(Object oSaveBeforeBackup) {
        this.oSaveBeforeBackup = oSaveBeforeBackup;
    }

    public boolean isBackupToExternalFTP() {
        return this.isBackupToExternalFTP;
    }

    public void setBackupToExternalFTP(boolean isBackupToExternalFTP) {
        this.isBackupToExternalFTP = isBackupToExternalFTP;
    }

    public String getStrDestination() {
        return this.strDestination;
    }

    public void setStrDestination(String strDestination) {
        this.strDestination = strDestination;
    }

    public int getNumOfBackupCopies() {
        return this.iNumOfBackupCopies;
    }

    public void setNumOfBackupCopies(int iNumOfBackupCopies) {
        this.iNumOfBackupCopies = iNumOfBackupCopies;
    }

    public List<ConfigChangePolicyInfo> getSpecialPolicyLst() {
        return this.oSpecialPolicyLst;
    }

    public void setSpecialPolicyLst(List<ConfigChangePolicyInfo> oSpecialPolicyLst) {
        this.oSpecialPolicyLst = oSpecialPolicyLst;
    }

    public List<ContentType> getBackupCotentTypeLst() {
        return this.oBackupCotentTypeLst;
    }

    public void setBackupCotentTypeLst(List<ContentType> oBackupCotentTypeLst) {
        this.oBackupCotentTypeLst = oBackupCotentTypeLst;
    }

    public ConfigChangePolicyInfo getConfigChangePolicyInfo(int iSpecialPolicyType) {
        if (null == this.oSpecialPolicyLst || this.oSpecialPolicyLst.size() == 0) {
            return null;
        }
        for (ConfigChangePolicyInfo oConfigChange : this.oSpecialPolicyLst) {
            if (oConfigChange.getSpecificPolicyType() != iSpecialPolicyType) continue;
            return oConfigChange;
        }
        return null;
    }

    public void setConfigChangeInfo(int iSpecialPolicyType, ConfigChangePolicyInfo oConfigInfo) {
        if (null == this.oSpecialPolicyLst) {
            this.oSpecialPolicyLst = new ArrayList<ConfigChangePolicyInfo>();
            this.oSpecialPolicyLst.add(oConfigInfo);
            return;
        }
        for (ConfigChangePolicyInfo oConfig : this.oSpecialPolicyLst) {
            if (null == oConfig || oConfig.getSpecificPolicyType() != iSpecialPolicyType) continue;
            this.oSpecialPolicyLst.remove(oConfig);
            break;
        }
        this.oSpecialPolicyLst.add(oConfigInfo);
    }

    public int getSpecialPolicyStatus(int iSpecialPolicyType) {
        if (null == this.oSpecialPolicyLst || this.oSpecialPolicyLst.size() == 0) {
            return -1;
        }
        for (ConfigChangePolicyInfo oConfigChange : this.oSpecialPolicyLst) {
            if (oConfigChange.getSpecificPolicyType() != iSpecialPolicyType) continue;
            return oConfigChange.getBackupPolicyStatus();
        }
        return -1;
    }

    public ConfigChangePolicyInfo getSpecialPolicy(int iSpecialPolicyType) {
        if (null == this.oSpecialPolicyLst || this.oSpecialPolicyLst.size() == 0) {
            return null;
        }
        for (ConfigChangePolicyInfo oConfigChange : this.oSpecialPolicyLst) {
            if (oConfigChange.getSpecificPolicyType() != iSpecialPolicyType) continue;
            return oConfigChange;
        }
        return null;
    }

    public void setConfigChangeBakcupStatus(int iConfChangePolicyType, int iBackupPolicyStatus) {
        if (null == this.oSpecialPolicyLst) {
            this.oSpecialPolicyLst = new ArrayList<ConfigChangePolicyInfo>();
            ConfigChangePolicyInfo oConfChangePolicy = new ConfigChangePolicyInfo();
            oConfChangePolicy.setSpecificPolicyType(iConfChangePolicyType);
            oConfChangePolicy.setBackupPolicyStatus(iBackupPolicyStatus);
            this.oSpecialPolicyLst.add(oConfChangePolicy);
            return;
        }
        boolean bFound = false;
        for (ConfigChangePolicyInfo oConfChangePolicy : this.oSpecialPolicyLst) {
            if (oConfChangePolicy.getSpecificPolicyType() != iConfChangePolicyType) continue;
            bFound = true;
            oConfChangePolicy.setBackupPolicyStatus(iBackupPolicyStatus);
            break;
        }
        if (!bFound) {
            ConfigChangePolicyInfo oConfChangePolicy = new ConfigChangePolicyInfo();
            oConfChangePolicy.setSpecificPolicyType(iConfChangePolicyType);
            oConfChangePolicy.setBackupPolicyStatus(iBackupPolicyStatus);
            this.oSpecialPolicyLst.add(oConfChangePolicy);
        }
    }

    public String getBackupContentTypeName() {
        if (null == this.oBackupCotentTypeLst || this.oBackupCotentTypeLst.size() == 0) {
            return "--";
        }
        DeviceTypeInfo oDevType = DeviceInfoManagerImpl.getInstance().getFirstDeviceTypeInfo(this.iDevTypeID);
        if (null == oDevType) {
            return "--";
        }
        ResourceManager oRes = ResourceManager.getInstance();
        for (ContentType oContentType : this.oBackupCotentTypeLst) {
            if (null == oContentType || oContentType.getContentTypeCode() != this.iBackupContentType) continue;
            String keyContentType = oContentType.getStrContentType();
            return oRes.getResString(oDevType, keyContentType);
        }
        return "--";
    }

    public void refreshBackupContentType(int iBackupContentType) {
        if (null == this.oBackupCotentTypeLst || this.oBackupCotentTypeLst.size() == 0) {
            return;
        }
        for (ContentType oContentType : this.oBackupCotentTypeLst) {
            if (null == oContentType || oContentType.getContentTypeCode() != iBackupContentType) continue;
            this.setBackupContentType(iBackupContentType);
            break;
        }
    }

    public void refreshSaveBeforeBackup(Object bSaveBeforebackup) {
        if (null == this.oSaveBeforeBackup || null == bSaveBeforebackup) {
            return;
        }
        this.oSaveBeforeBackup = bSaveBeforebackup;
    }

    public void refreshConfigChange(int iSpecialPolicyType, Object bConfigChange) {
        if (null == bConfigChange) {
            return;
        }
        ConfigChangePolicyInfo oConfigChange = this.getSpecialPolicy(iSpecialPolicyType);
        if (null == oConfigChange) {
            return;
        }
        if (bConfigChange instanceof Boolean) {
            if (((Boolean)bConfigChange).booleanValue()) {
                oConfigChange.setBackupPolicyStatus(0);
            } else {
                oConfigChange.setBackupPolicyStatus(1);
            }
        } else if (bConfigChange instanceof ConfigChangePolicyInfo) {
            this.setConfigChangeInfo(iSpecialPolicyType, (ConfigChangePolicyInfo)bConfigChange);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.iBackupContentType;
        result = 31 * result + this.iDevTypeID;
        result = 31 * result + this.iNumOfBackupCopies;
        result = 31 * result + this.iSaveContentType;
        result = 31 * result + (this.oBackupCotentTypeLst == null ? 0 : ((Object)this.oBackupCotentTypeLst).hashCode());
        result = 31 * result + (this.oSaveBeforeBackup == null ? 0 : this.oSaveBeforeBackup.hashCode());
        result = 31 * result + (this.oSpecialPolicyLst == null ? 0 : ((Object)this.oSpecialPolicyLst).hashCode());
        result = 31 * result + (this.sDevTypeName == null ? 0 : this.sDevTypeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolicyDevTypeProperties other = (PolicyDevTypeProperties)obj;
        if (this.iBackupContentType != other.iBackupContentType) {
            return false;
        }
        if (this.iDevTypeID != other.iDevTypeID) {
            return false;
        }
        if (this.iNumOfBackupCopies != other.iNumOfBackupCopies) {
            return false;
        }
        if (this.iSaveContentType != other.iSaveContentType) {
            return false;
        }
        if (this.oBackupCotentTypeLst == null ? other.oBackupCotentTypeLst != null : !((Object)this.oBackupCotentTypeLst).equals(other.oBackupCotentTypeLst)) {
            return false;
        }
        if (this.oSaveBeforeBackup == null ? other.oSaveBeforeBackup != null : !this.oSaveBeforeBackup.equals(other.oSaveBeforeBackup)) {
            return false;
        }
        if (this.oSpecialPolicyLst == null ? other.oSpecialPolicyLst != null : !((Object)this.oSpecialPolicyLst).equals(other.oSpecialPolicyLst)) {
            return false;
        }
        return !(this.sDevTypeName == null ? other.sDevTypeName != null : !this.sDevTypeName.equals(other.sDevTypeName));
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        PolicyDevTypeProperties that = (PolicyDevTypeProperties)obj;
        return this.getDevTypeName().compareTo(that.getDevTypeName());
    }
}

