/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.DCConfigFileParser;
import com.huawei.dc.common.asndatacenter.AsnConfigChangePolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCAllPolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCBackupContentType;
import com.huawei.dc.common.asndatacenter.AsnDCBackupContentTypeLst;
import com.huawei.dc.common.asndatacenter.AsnDCDevicePolicyState;
import com.huawei.dc.common.asndatacenter.AsnDCDevicePolicyStateLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyDayEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyDevIdBakNum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyDevIdBakNumLst;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyPeriodEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyPropertiesForDevType;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyPropertiesForDevTypeLst;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyStateEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyUnitForBackupTimeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicytypeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCPolicytypeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCSetOrGetPolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileLst;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.asndatacenter.AsnSpecificBackupPolicyLst;
import com.huawei.dc.common.asndatacenter.AsnSpecificPolicyEnum;
import com.huawei.dc.common.components.dialog.fileselection.IUpdateDestinationListener;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.policy.view.PolicyDetailDlg;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolicyUtil {
    private static HashSet<Integer> iDevIdLst = new HashSet();

    public static List<PolicyInfo> decodePolicyInfoLst(AsnDCAllPolicyInfoLst oAsnDCAllPolicyInfoLst) {
        ArrayList<PolicyInfo> oRtnPolicyInfoLst = null;
        if (null == oAsnDCAllPolicyInfoLst || oAsnDCAllPolicyInfoLst.size() == 0) {
            return null;
        }
        AsnDCSetOrGetPolicyInfo oAsnDCSetOrGetPolicyInfo = null;
        oRtnPolicyInfoLst = new ArrayList<PolicyInfo>();
        PolicyInfo oPolicy = null;
        int iSize = oAsnDCAllPolicyInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnDCSetOrGetPolicyInfo = (AsnDCSetOrGetPolicyInfo)oAsnDCAllPolicyInfoLst.get(i);
            oPolicy = PolicyUtil.decode2PolicyInfo(oAsnDCSetOrGetPolicyInfo);
            if (null == oPolicy) continue;
            oRtnPolicyInfoLst.add(oPolicy);
        }
        return oRtnPolicyInfoLst;
    }

    public static PolicyInfo decode2PolicyInfo(AsnDCSetOrGetPolicyInfo oAsnDCSetOrGetPolicyInfo) {
        if (null == oAsnDCSetOrGetPolicyInfo) {
            return null;
        }
        PolicyInfo oPolicy = PolicyUtil.decodePolicyInfo(oAsnDCSetOrGetPolicyInfo.oAsnDCPolicyInfo);
        if (null != oPolicy) {
            AsnDCDevicePolicyStateLst oDevPolicyStateLst = oAsnDCSetOrGetPolicyInfo.iDevicePolicyStateLst;
            oPolicy.setDevicePolicyStateHm(PolicyUtil.decodeDevPolicyStateLst(oDevPolicyStateLst));
        }
        return oPolicy;
    }

    private static THashMap<Integer, DevicePolicyState> decodeDevPolicyStateLst(AsnDCDevicePolicyStateLst oAsnDCDevicePolicyStateLst) {
        THashMap oDevPolicyStateLst = null;
        if (null == oAsnDCDevicePolicyStateLst || oAsnDCDevicePolicyStateLst.size() == 0) {
            DCDebugTracer.trace("[POLICY]:oAsnDCDevicePolicyStateLst is null");
            return null;
        }
        int iSize = oAsnDCDevicePolicyStateLst.size();
        oDevPolicyStateLst = new THashMap(iSize);
        AsnDCDevicePolicyState oAsnDCDevicePolicyState = null;
        DevicePolicyState oDevPolicyState = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnDCDevicePolicyState = (AsnDCDevicePolicyState)oAsnDCDevicePolicyStateLst.get(i);
            oDevPolicyState = new DevicePolicyState();
            oDevPolicyState.setDevID(oAsnDCDevicePolicyState.iDevID.intValue());
            DCDebugTracer.trace("[POLICY]:devID" + oAsnDCDevicePolicyState.iDevID.intValue());
            if (null != oAsnDCDevicePolicyState.enBackupPolicyStatus) {
                oDevPolicyState.setBakcupPolicyState(oAsnDCDevicePolicyState.enBackupPolicyStatus.value);
                if (null != oAsnDCDevicePolicyState.enBackupPolicyStatus && 0 != oAsnDCDevicePolicyState.enBackupPolicyStatus.value && 1 != oAsnDCDevicePolicyState.enBackupPolicyStatus.value) {
                    DCDebugTracer.trace("[POLICY]backup policy state not correct:" + oAsnDCDevicePolicyState.enBackupPolicyStatus.value);
                }
            } else {
                DCDebugTracer.trace("[POLICY]:+oAsnDCDevicePolicyState.enBackupPolicyStatus is null");
            }
            if (null != oAsnDCDevicePolicyState.enSavePolicyStatus) {
                oDevPolicyState.setSavePolicyState(oAsnDCDevicePolicyState.enSavePolicyStatus.value);
                if (null != oAsnDCDevicePolicyState.enSavePolicyStatus && 0 != oAsnDCDevicePolicyState.enSavePolicyStatus.value && 1 != oAsnDCDevicePolicyState.enSavePolicyStatus.value) {
                    DCDebugTracer.trace("[POLICY]save policy state not correct:" + oAsnDCDevicePolicyState.enSavePolicyStatus.value);
                }
            } else {
                DCDebugTracer.trace("[POLICY]:+oAsnDCDevicePolicyState.enSavePolicyStatus is null");
            }
            oDevPolicyState.setNEName(new String(oAsnDCDevicePolicyState.strDevName));
            oDevPolicyState.setIPAdress(new String(oAsnDCDevicePolicyState.strDevIPAddress));
            oDevPolicyState.setNETypeName(new String(oAsnDCDevicePolicyState.strDevTypeName));
            oDevPolicyState.setDevTypeID(oAsnDCDevicePolicyState.iDevTypeId.intValue());
            oDevPolicyState.setDevTypeVerID(oAsnDCDevicePolicyState.iDevTypeVersionId.intValue());
            oDevPolicyStateLst.put((Object)oDevPolicyState.getDevID(), (Object)oDevPolicyState);
        }
        return oDevPolicyStateLst;
    }

    private static PolicyInfo decodePolicyInfo(AsnDCPolicyInfo oAsnDCPolicyInfo) {
        String sPolicyName;
        if (null == oAsnDCPolicyInfo) {
            return null;
        }
        PolicyInfo oPolicyInfo = new PolicyInfo();
        int iPolicyID = oAsnDCPolicyInfo.iPolicyID.intValue();
        String string = sPolicyName = null != oAsnDCPolicyInfo.strPolicyName ? new String(oAsnDCPolicyInfo.strPolicyName) : "";
        if (iPolicyID == 0) {
            sPolicyName = ResourceManager.getInstance().getResString("POLICY_DEFAULT_NAME");
        }
        oPolicyInfo.setPolicyID(iPolicyID);
        oPolicyInfo.setPolicyName(sPolicyName);
        AsnDCPolicytypeInfoLst oAsnDCPolicytypeInfoLst = oAsnDCPolicyInfo.oAsnDCPolicytypeInfoLst;
        AsnDCPolicytypeInfo oAsnDCPolicytypeInfo = null;
        for (int i = 0; i < oAsnDCPolicytypeInfoLst.size(); ++i) {
            oAsnDCPolicytypeInfo = (AsnDCPolicytypeInfo)oAsnDCPolicytypeInfoLst.get(i);
            PolicyTypeInfo oPTypeInfo = new PolicyTypeInfo();
            oPTypeInfo.setPolicyType(oAsnDCPolicytypeInfo.enAsnDCPolicyTypeEnum.value);
            oPTypeInfo.setPolicyStatus(oAsnDCPolicytypeInfo.enpPolicyStatus.value);
            oPTypeInfo.setPolicyPeriod(oAsnDCPolicytypeInfo.oPolicyPeriod.value);
            int iDayInWeek = null != oAsnDCPolicytypeInfo.oPolicyDayInAWeek ? oAsnDCPolicytypeInfo.oPolicyDayInAWeek.value : -1;
            int iDayInMonth = null != oAsnDCPolicytypeInfo.iPolicyDayInAMonth ? oAsnDCPolicytypeInfo.iPolicyDayInAMonth.intValue() : -1;
            oPTypeInfo.setPolicyDayInWeek(iDayInWeek);
            oPTypeInfo.setPolicyDayInMonth(iDayInMonth);
            oPTypeInfo.setPolicyTime(new String(oAsnDCPolicytypeInfo.strPolicyTime));
            oPTypeInfo.setEndTime(new String(oAsnDCPolicytypeInfo.strPolicyEndTime));
            oPolicyInfo.getPolicyTypeInfoLst().add(oPTypeInfo);
        }
        AsnDCPolicyPropertiesForDevTypeLst oAsnProDevTypeLst = null;
        oAsnProDevTypeLst = !oPolicyInfo.isDefaultPolicy() && iPolicyID != -1 ? PolicyUtil.filterSupportDeviceType(oAsnDCPolicyInfo.oAsnDCPolicyPropertiesForDevTypeLst) : oAsnDCPolicyInfo.oAsnDCPolicyPropertiesForDevTypeLst;
        AsnDCPolicyPropertiesForDevType oAsnProDevType = null;
        if (null != oAsnProDevTypeLst) {
            ArrayList<PolicyDevTypeProperties> oDevTypeProLst = new ArrayList<PolicyDevTypeProperties>();
            PolicyDevTypeProperties oDevPro = null;
            for (int i = 0; i < oAsnProDevTypeLst.size(); ++i) {
                oAsnProDevType = (AsnDCPolicyPropertiesForDevType)oAsnProDevTypeLst.get(i);
                oDevPro = new PolicyDevTypeProperties();
                oDevPro.setDevTypeID(oAsnProDevType.iDevTypeID.intValue());
                oDevPro.setDevTypeName(new String(oAsnProDevType.strDevTypeName));
                int iBContentType = null != oAsnProDevType.iBackupContentType ? oAsnProDevType.iBackupContentType.intValue() : -1;
                int iSContentType = null != oAsnProDevType.iSaveContentType ? oAsnProDevType.iSaveContentType.intValue() : -1;
                oDevPro.setBackupContentType(iBContentType);
                oDevPro.setSaveContentType(iSContentType);
                if (!oAsnProDevType.bSupportSaveOperation) {
                    oDevPro.setSaveBeforeBackup(null);
                } else {
                    oDevPro.setSaveBeforeBackup(oAsnProDevType.bSaveBeforeBackup);
                }
                oDevPro.setNumOfBackupCopies(oAsnProDevType.iNumberOfBackupCopies.intValue());
                oDevPro.setSpecialPolicyLst(PolicyUtil.decodeConfigChangePolicyInfo(oAsnProDevType.oAsnSpecificBackupPolicyLst));
                oDevPro.setBackupCotentTypeLst(PolicyUtil.decodeBakcupContentType(oAsnProDevType.oBackupContentTypeLst));
                oDevPro.setBackupToExternalFTP(oAsnProDevType.bBackupToExternalFTP);
                String strDestination = new String(oAsnProDevType.strServerName);
                if (!"".equals(strDestination)) {
                    oDevPro.setStrDestination(strDestination);
                }
                oDevTypeProLst.add(oDevPro);
            }
            oPolicyInfo.setPolicyDevTypePropLst(oDevTypeProLst);
        }
        return oPolicyInfo;
    }

    private static List<DeviceTypeInfo> getAllDeviceTypeInfoByPolicy() {
        DeviceInfo[] allDevices = DeviceInfoManagerImpl.getInstance().getDevices();
        ArrayList<DeviceTypeInfo> deviceTypeInfoList = new ArrayList<DeviceTypeInfo>();
        for (int i = 0; i < allDevices.length; ++i) {
            if (deviceTypeInfoList.contains(allDevices[i].getDeviceTypeInfo())) continue;
            deviceTypeInfoList.add(allDevices[i].getDeviceTypeInfo());
        }
        return deviceTypeInfoList;
    }

    private static AsnDCPolicyPropertiesForDevTypeLst filterSupportDeviceType(AsnDCPolicyPropertiesForDevTypeLst oAsnDCPolicyPropertiesForDevTypeLst) {
        List<DeviceTypeInfo> deviceTypeInfoList = PolicyUtil.getAllDeviceTypeInfoByPolicy();
        AsnDCPolicyPropertiesForDevTypeLst supportDeviceTypeList = new AsnDCPolicyPropertiesForDevTypeLst();
        if (oAsnDCPolicyPropertiesForDevTypeLst.size() < 0 || deviceTypeInfoList.size() < 0) {
            return supportDeviceTypeList;
        }
        block0: for (int index = 0; index < oAsnDCPolicyPropertiesForDevTypeLst.size(); ++index) {
            AsnDCPolicyPropertiesForDevType policyPropForDevType = (AsnDCPolicyPropertiesForDevType)oAsnDCPolicyPropertiesForDevTypeLst.get(index);
            int dIndex = 0;
            for (dIndex = 0; dIndex < deviceTypeInfoList.size(); ++dIndex) {
                DeviceTypeInfo deviceTypeInfo = deviceTypeInfoList.get(dIndex);
                if (policyPropForDevType.iDevTypeID.intValue() != deviceTypeInfo.getDevTypeID()) continue;
                if (supportDeviceTypeList.contains((Object)policyPropForDevType)) continue block0;
                supportDeviceTypeList.add((Object)policyPropForDevType);
                continue block0;
            }
        }
        return supportDeviceTypeList;
    }

    private static List<ConfigChangePolicyInfo> decodeConfigChangePolicyInfo(AsnSpecificBackupPolicyLst oAsnSpecificBackupPolicyLst) {
        ArrayList<ConfigChangePolicyInfo> oSpecianBackupPolicyLst = null;
        if (null == oAsnSpecificBackupPolicyLst || oAsnSpecificBackupPolicyLst.isEmpty()) {
            return null;
        }
        AsnConfigChangePolicyInfo oAsnSpecialInfo = null;
        oSpecianBackupPolicyLst = new ArrayList<ConfigChangePolicyInfo>();
        for (int i = 0; i < oAsnSpecificBackupPolicyLst.size(); ++i) {
            oAsnSpecialInfo = (AsnConfigChangePolicyInfo)oAsnSpecificBackupPolicyLst.get(i);
            if (null == oAsnSpecialInfo) {
                DCDebugTracer.trace("decodeConfigChangePolicyInfo decodeConfigChangePolicyInfo is NULL: ");
                continue;
            }
            ConfigChangePolicyInfo oSpecialInfo = new ConfigChangePolicyInfo();
            DCDebugTracer.trace("oAsnSpecialInfo.bselected = " + oAsnSpecialInfo.bselected);
            oSpecialInfo.setSelected(oAsnSpecialInfo.bselected);
            oSpecialInfo.setSpecificPolicyType(oAsnSpecialInfo.oAsnSpecificPolicyEnum.value);
            oSpecialInfo.setBackupPolicyStatus(oAsnSpecialInfo.enCfgChangeBackupPolicyStatus.value);
            if (null != oAsnSpecialInfo.enSpecificBackupPeriod) {
                oSpecialInfo.setSpecificBackupPeriod(oAsnSpecialInfo.enSpecificBackupPeriod.value);
            }
            if (null != oAsnSpecialInfo.oSpecificBackupPolicyTime) {
                oSpecialInfo.setSpecificBackupPolicyTime(new String(oAsnSpecialInfo.oSpecificBackupPolicyTime));
            }
            if (null != oAsnSpecialInfo.enSpecificStaticBackupPeriod) {
                oSpecialInfo.setSpecificStaticBackupPeriod(oAsnSpecialInfo.enSpecificStaticBackupPeriod.value);
            }
            if (null != oAsnSpecialInfo.oSpecificStaticBackupPolicyTime) {
                oSpecialInfo.setSpecificStaticBackupPolicyTime(new String(oAsnSpecialInfo.oSpecificStaticBackupPolicyTime));
            }
            oSpecianBackupPolicyLst.add(oSpecialInfo);
        }
        return oSpecianBackupPolicyLst;
    }

    private static List<ContentType> decodeBakcupContentType(AsnDCBackupContentTypeLst oAsnDCBackupContentTypeLst) {
        ArrayList<ContentType> oBakcupContentTypeLst = null;
        if (null == oAsnDCBackupContentTypeLst || oAsnDCBackupContentTypeLst.size() == 0) {
            return null;
        }
        AsnDCBackupContentType oAsnDCBackupContentType = null;
        oBakcupContentTypeLst = new ArrayList<ContentType>();
        ContentType oBakcupContentType = null;
        for (int i = 0; i < oAsnDCBackupContentTypeLst.size(); ++i) {
            oAsnDCBackupContentType = (AsnDCBackupContentType)oAsnDCBackupContentTypeLst.get(i);
            if (null == oAsnDCBackupContentType) continue;
            oBakcupContentType = new ContentType(oAsnDCBackupContentType.iBackupContentType.intValue(), new String(oAsnDCBackupContentType.strBackupContentTypeName));
            oBakcupContentTypeLst.add(oBakcupContentType);
        }
        return oBakcupContentTypeLst;
    }

    public static MxuPolicyInfo decodeMxuUpgradePolicyInfo(AsnDCMxuUpgradePolicyInfo oAsn) {
        if (null == oAsn) {
            return null;
        }
        MxuPolicyInfo oPolicyInfo = new MxuPolicyInfo(new String(oAsn.strSubMapId), oAsn.iDevicetypeId.intValue(), oAsn.iDeviceTypeVerId.intValue());
        oPolicyInfo.setUpgradeDevVersion(new String(oAsn.strUpgradeDevVersion));
        oPolicyInfo.setPolicyState(oAsn.iPolicyState.intValue());
        AsnLoadFileLst strUpgradeFileList = oAsn.strUpgradeFileList;
        ArrayList<FileInfo> oFileLst = new ArrayList<FileInfo>();
        AsnLoadFileInfo oAsnFile = null;
        FileInfo oFile = null;
        int iDevTypeID = oAsn.iDevicetypeId.intValue();
        int iDevTypeVerID = oAsn.iDeviceTypeVerId.intValue();
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo oDevTypeInfo = oDevMgr.getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
        for (int i = 0; i < strUpgradeFileList.size(); ++i) {
            oAsnFile = (AsnLoadFileInfo)strUpgradeFileList.get(i);
            if (null == oAsnFile) continue;
            oFile = new FileInfo();
            oFile.setSeqNumber(oAsnFile.iSequence.intValue());
            oFile.setFileName(new String(oAsnFile.strFileName));
            int iContentType = oAsnFile.iContentType.intValue();
            oFile.setIContentType(iContentType);
            ContentType oContentType = SAMUtil.getFileTypeObj(oDevTypeInfo, iContentType);
            if (null != oContentType) {
                oFile.setContentType(oContentType.getStrContentType());
            }
            oFileLst.add(oFile);
        }
        oPolicyInfo.setUpgradeFileInfoLst(oFileLst);
        return oPolicyInfo;
    }

    public static String getContentType(DeviceTypeInfo oDevTypeInfo, int iContentType, int iOperationID) {
        ResourceManager oRes = ResourceManager.getInstance();
        String sContentType = "";
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDevTypeInfo, null);
        IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(0, iOperationID);
        if (null == oOperationObj) {
            return "";
        }
        IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
        Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
        for (int i = 0; i < arrParaVals.length; ++i) {
            ContentType oContentType = (ContentType)arrParaVals[i];
            int iTmpContentType = oContentType.getContentTypeCode();
            if (iTmpContentType != iContentType) continue;
            String sc = oContentType.toString();
            sContentType = oRes.getResString(oDevTypeInfo, sc);
            break;
        }
        return sContentType;
    }

    public static AsnDCSetOrGetPolicyInfo encodeAsnDCSetOrGetPolicyInfo(PolicyInfo oPolicyInfo) {
        AsnDCPolicyInfo oAsnDCPolicyInfo;
        AsnDCSetOrGetPolicyInfo oAsnDCSetOrGetPolicyInfo = null;
        if (null == oPolicyInfo) {
            return null;
        }
        oAsnDCSetOrGetPolicyInfo = new AsnDCSetOrGetPolicyInfo();
        oAsnDCSetOrGetPolicyInfo.oAsnDCPolicyInfo = oAsnDCPolicyInfo = PolicyUtil.encodeAsnDCPolicyInfo(oPolicyInfo);
        THashMap<Integer, DevicePolicyState> oDevStateHaspMap = oPolicyInfo.getDevicePolicyStateHm();
        if (null != oDevStateHaspMap) {
            AsnDCDevicePolicyStateLst oDevicePolicyStateLst = new AsnDCDevicePolicyStateLst();
            AsnDCDevicePolicyState oAsnDCDevicePolicyState = null;
            Set oDevSet = oDevStateHaspMap.entrySet();
            Iterator oDevItor = oDevSet.iterator();
            Map.Entry element = null;
            while (oDevItor.hasNext()) {
                element = (Map.Entry)oDevItor.next();
                oAsnDCDevicePolicyState = PolicyUtil.encodeAsnDCDevicePolicyState((DevicePolicyState)element.getValue());
                if (null == oAsnDCDevicePolicyState) continue;
                oDevicePolicyStateLst.add((Object)oAsnDCDevicePolicyState);
            }
            oAsnDCSetOrGetPolicyInfo.iDevicePolicyStateLst = oDevicePolicyStateLst;
        }
        return oAsnDCSetOrGetPolicyInfo;
    }

    private static AsnDCPolicyInfo encodeAsnDCPolicyInfo(PolicyInfo oPolicyInfo) {
        AsnDCPolicyInfo oAsnDCPolicyInfo = null;
        if (null == oPolicyInfo) {
            return null;
        }
        oAsnDCPolicyInfo = new AsnDCPolicyInfo();
        oAsnDCPolicyInfo.iPolicyID = BigInteger.valueOf(oPolicyInfo.getPolicyID());
        oAsnDCPolicyInfo.strPolicyName = oPolicyInfo.getPolicyName().getBytes();
        List<PolicyTypeInfo> oPolicyTypeInfoLst = oPolicyInfo.getPolicyTypeInfoLst();
        AsnDCPolicytypeInfo oAsnDCPolicytypeInfo = null;
        for (PolicyTypeInfo oPolicyType : oPolicyTypeInfoLst) {
            oAsnDCPolicytypeInfo = PolicyUtil.encodeAsnDCPolicytypeInfo(oPolicyType);
            if (null == oAsnDCPolicytypeInfo) continue;
            oAsnDCPolicyInfo.oAsnDCPolicytypeInfoLst.add((Object)oAsnDCPolicytypeInfo);
        }
        List<PolicyDevTypeProperties> oDevProLst = oPolicyInfo.getPolicyDevTypePropLst();
        if (null != oDevProLst) {
            AsnDCPolicyPropertiesForDevTypeLst oAsnDCPolicyPropertiesForDevTypeLst = new AsnDCPolicyPropertiesForDevTypeLst();
            AsnDCPolicyPropertiesForDevType oAsnDCPolicyPropertiesForDevType = null;
            for (PolicyDevTypeProperties odevPro : oDevProLst) {
                oAsnDCPolicyPropertiesForDevType = PolicyUtil.encodeAsnDCPolicyPropertiesForDevType(odevPro);
                if (null == oAsnDCPolicyPropertiesForDevType) continue;
                oAsnDCPolicyPropertiesForDevTypeLst.add((Object)oAsnDCPolicyPropertiesForDevType);
            }
            oAsnDCPolicyInfo.oAsnDCPolicyPropertiesForDevTypeLst = oAsnDCPolicyPropertiesForDevTypeLst;
        }
        return oAsnDCPolicyInfo;
    }

    private static AsnDCPolicytypeInfo encodeAsnDCPolicytypeInfo(PolicyTypeInfo oPolicyTypeInfo) {
        if (null == oPolicyTypeInfo) {
            return null;
        }
        AsnDCPolicytypeInfo oAsnDCPolicytypeInfo = new AsnDCPolicytypeInfo();
        AsnDCPolicyTypeEnum oAsnDCPolicyTypeEnum = new AsnDCPolicyTypeEnum(oPolicyTypeInfo.getPolicyType());
        AsnDCPolicyStateEnum oAsnDCPolicyStateEnum = new AsnDCPolicyStateEnum(oPolicyTypeInfo.getPolicyStatus());
        oAsnDCPolicytypeInfo.enAsnDCPolicyTypeEnum = oAsnDCPolicyTypeEnum;
        oAsnDCPolicytypeInfo.enpPolicyStatus = oAsnDCPolicyStateEnum;
        switch (oPolicyTypeInfo.getPolicyPeriod()) {
            case 0: {
                oAsnDCPolicytypeInfo.oPolicyPeriod = new AsnDCPolicyPeriodEnum(0);
                oAsnDCPolicytypeInfo.iPolicyDayInAMonth = BigInteger.valueOf(oPolicyTypeInfo.getPolicyDayInMonth());
                break;
            }
            case 1: {
                oAsnDCPolicytypeInfo.oPolicyPeriod = new AsnDCPolicyPeriodEnum(1);
                oAsnDCPolicytypeInfo.oPolicyDayInAWeek = new AsnDCPolicyDayEnum(oPolicyTypeInfo.getPolicyDayInWeek());
                break;
            }
            case 2: {
                oAsnDCPolicytypeInfo.oPolicyPeriod = new AsnDCPolicyPeriodEnum(2);
                break;
            }
            default: {
                oAsnDCPolicytypeInfo.oPolicyPeriod = new AsnDCPolicyPeriodEnum(2);
            }
        }
        oAsnDCPolicytypeInfo.strPolicyTime = oPolicyTypeInfo.getPolicyTime().getBytes();
        oAsnDCPolicytypeInfo.strPolicyEndTime = oPolicyTypeInfo.getEndTime().getBytes();
        return oAsnDCPolicytypeInfo;
    }

    private static AsnDCPolicyPropertiesForDevType encodeAsnDCPolicyPropertiesForDevType(PolicyDevTypeProperties oDevTypePro) {
        if (null == oDevTypePro) {
            return null;
        }
        AsnDCPolicyPropertiesForDevType oAsnInfo = new AsnDCPolicyPropertiesForDevType();
        oAsnInfo.iDevTypeID = BigInteger.valueOf(oDevTypePro.getDevTypeID());
        oAsnInfo.strDevTypeName = oDevTypePro.getDevTypeName().getBytes();
        oAsnInfo.iBackupContentType = BigInteger.valueOf(oDevTypePro.getBackupContentType());
        String strDestination = oDevTypePro.getStrDestination();
        if (IUpdateDestinationListener.DESTINATION_NMS_SERVER.equals(strDestination)) {
            strDestination = "";
        }
        oAsnInfo.strServerName = strDestination.getBytes();
        if (oDevTypePro.getSaveContentType() != -1) {
            oAsnInfo.iSaveContentType = BigInteger.valueOf(oDevTypePro.getSaveContentType());
        }
        if (null == oDevTypePro.isSaveBeforeBackup()) {
            oAsnInfo.bSupportSaveOperation = false;
        } else {
            oAsnInfo.bSupportSaveOperation = true;
            oAsnInfo.bSaveBeforeBackup = (Boolean)oDevTypePro.isSaveBeforeBackup();
        }
        oAsnInfo.iNumberOfBackupCopies = BigInteger.valueOf(oDevTypePro.getNumOfBackupCopies());
        List<ConfigChangePolicyInfo> oConfigLst = oDevTypePro.getSpecialPolicyLst();
        if (null != oConfigLst) {
            AsnSpecificBackupPolicyLst oAsnSpecificBackupPolicyLst = new AsnSpecificBackupPolicyLst();
            AsnConfigChangePolicyInfo oAsnConfigInfo = null;
            for (ConfigChangePolicyInfo oConfig : oConfigLst) {
                oAsnConfigInfo = PolicyUtil.encodeAsnConfigChangePolicyInfo(oConfig);
                if (null == oAsnConfigInfo) continue;
                oAsnSpecificBackupPolicyLst.addElement((Object)oAsnConfigInfo);
            }
            oAsnInfo.oAsnSpecificBackupPolicyLst = oAsnSpecificBackupPolicyLst;
        }
        if (null != oDevTypePro.getBackupCotentTypeLst()) {
            List<ContentType> oBackupContentTypeLst = oDevTypePro.getBackupCotentTypeLst();
            AsnDCBackupContentTypeLst oAsnDCBackupContentTypeLst = new AsnDCBackupContentTypeLst();
            AsnDCBackupContentType oAsnDCBackupContentType = null;
            ContentType oBackupContentType = null;
            for (int i = 0; i < oBackupContentTypeLst.size(); ++i) {
                oBackupContentType = oBackupContentTypeLst.get(i);
                if (null == oBackupContentType) continue;
                oAsnDCBackupContentType = new AsnDCBackupContentType();
                oAsnDCBackupContentType.iBackupContentType = BigInteger.valueOf(oBackupContentType.getContentTypeCode());
                oAsnDCBackupContentType.strBackupContentTypeName = oBackupContentType.getStrContentType().getBytes();
                oAsnDCBackupContentTypeLst.add((Object)oAsnDCBackupContentType);
            }
            oAsnInfo.oBackupContentTypeLst = oAsnDCBackupContentTypeLst;
        }
        return oAsnInfo;
    }

    private static AsnConfigChangePolicyInfo encodeAsnConfigChangePolicyInfo(ConfigChangePolicyInfo oConfigInfo) {
        if (null == oConfigInfo) {
            return null;
        }
        AsnConfigChangePolicyInfo oAsnInfo = new AsnConfigChangePolicyInfo();
        oAsnInfo.bselected = oConfigInfo.isSelected();
        oAsnInfo.oAsnSpecificPolicyEnum = new AsnSpecificPolicyEnum(oConfigInfo.getSpecificPolicyType());
        oAsnInfo.enCfgChangeBackupPolicyStatus = new AsnDCPolicyStateEnum(oConfigInfo.getBackupPolicyStatus());
        if (oConfigInfo.getSpecificBackupPeriod() != -1) {
            oAsnInfo.enSpecificBackupPeriod = new AsnDCPolicyUnitForBackupTimeEnum(oConfigInfo.getSpecificBackupPeriod());
            oAsnInfo.oSpecificBackupPolicyTime = oConfigInfo.getSpecificBackupPolicyTime().getBytes();
        }
        if (oConfigInfo.getSpecificStaticBackupPeriod() != -1) {
            oAsnInfo.enSpecificStaticBackupPeriod = new AsnDCPolicyUnitForBackupTimeEnum(oConfigInfo.getSpecificStaticBackupPeriod());
            oAsnInfo.oSpecificStaticBackupPolicyTime = oConfigInfo.getSpecificStaticBackupPolicyTime().getBytes();
        }
        return oAsnInfo;
    }

    private static AsnDCDevicePolicyState encodeAsnDCDevicePolicyState(DevicePolicyState oDevPolicyState) {
        if (null == oDevPolicyState) {
            return null;
        }
        AsnDCDevicePolicyState oAsnInfo = new AsnDCDevicePolicyState();
        oAsnInfo.iDevID = BigInteger.valueOf(oDevPolicyState.getDevID());
        if (oDevPolicyState.getBakcupPolicyState() != -1) {
            oAsnInfo.enBackupPolicyStatus = new AsnDCPolicyStateEnum(oDevPolicyState.getBakcupPolicyState());
        }
        if (oDevPolicyState.getSavePolicyState() != -1) {
            oAsnInfo.enSavePolicyStatus = new AsnDCPolicyStateEnum(oDevPolicyState.getSavePolicyState());
        }
        oAsnInfo.strDevName = oDevPolicyState.getNEName().getBytes();
        oAsnInfo.strDevIPAddress = oDevPolicyState.getIPAdress().getBytes();
        oAsnInfo.strDevTypeName = oDevPolicyState.getNETypeName().getBytes();
        oAsnInfo.iDevTypeId = BigInteger.valueOf(oDevPolicyState.getDevTypeID());
        oAsnInfo.iDevTypeVersionId = BigInteger.valueOf(oDevPolicyState.getDevTypeVerID());
        return oAsnInfo;
    }

    public static AsnDCMxuUpgradePolicyInfoLst encodeAsnDCMxuUpgradePolicyInfoLst(List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        AsnDCMxuUpgradePolicyInfoLst oAsnLst = new AsnDCMxuUpgradePolicyInfoLst();
        if (null == oMxuPolicyInfoLst) {
            return oAsnLst;
        }
        AsnDCMxuUpgradePolicyInfo oAsnInfo = null;
        for (MxuPolicyInfo oMxuInfo : oMxuPolicyInfoLst) {
            if (null == oMxuInfo || "".equals(oMxuInfo.getUpgradeDevVersion())) continue;
            oAsnInfo = new AsnDCMxuUpgradePolicyInfo();
            oAsnInfo.strSubMapId = oMxuInfo.getSubmapId().getBytes();
            oAsnInfo.iDevicetypeId = BigInteger.valueOf(oMxuInfo.getDevTypeID());
            oAsnInfo.iDeviceTypeVerId = BigInteger.valueOf(oMxuInfo.getDevTypeVerID());
            oAsnInfo.strUpgradeDevVersion = oMxuInfo.getUpgradeDevVersion().getBytes();
            oAsnInfo.strUpgradeFileList = PolicyUtil.encodeAsnLoadFileLst(oMxuInfo.getUpgradeFileInfoLst());
            oAsnInfo.iPolicyState = BigInteger.valueOf(oMxuInfo.getPolicyState());
            oAsnLst.add((Object)oAsnInfo);
        }
        return oAsnLst;
    }

    private static AsnLoadFileLst encodeAsnLoadFileLst(List<FileInfo> oFileLst) {
        AsnLoadFileLst oAsnLst = new AsnLoadFileLst();
        if (null == oFileLst) {
            return oAsnLst;
        }
        AsnLoadFileInfo oAsnFile = null;
        for (FileInfo oFile : oFileLst) {
            if (null == oFile) continue;
            oAsnFile = new AsnLoadFileInfo();
            oAsnFile.strFileName = oFile.getFileName().getBytes();
            oAsnFile.iContentType = BigInteger.valueOf(oFile.getIContentType());
            oAsnFile.iSequence = BigInteger.valueOf(oFile.getSeqNumber());
            oAsnLst.add((Object)oAsnFile);
        }
        return oAsnLst;
    }

    public static AsnDCDevicePolicyStateLst initAsnDevLst(THashMap<Integer, DevicePolicyState> oDevHm, int iPolicyType, int iPolicyState) {
        AsnDCDevicePolicyStateLst oAsnDevLst = new AsnDCDevicePolicyStateLst();
        AsnDCDevicePolicyState oAsnDev = null;
        DevicePolicyState oDevicePolicyState = null;
        Set oDevSet = oDevHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        int iDevId = 0;
        while (oDevItor.hasNext()) {
            oAsnDev = new AsnDCDevicePolicyState();
            oDevicePolicyState = (DevicePolicyState)((Map.Entry)oDevItor.next()).getValue();
            oAsnDev.iDevID = BigInteger.valueOf(oDevicePolicyState.getDevID());
            iDevId = oDevicePolicyState.getDevID();
            if (!iDevIdLst.contains(iDevId)) continue;
            if (0 == iPolicyType) {
                oAsnDev.enBackupPolicyStatus = new AsnDCPolicyStateEnum(iPolicyState);
            } else {
                oAsnDev.enSavePolicyStatus = new AsnDCPolicyStateEnum(iPolicyState);
            }
            oAsnDev.strDevName = oDevicePolicyState.getNEName().getBytes();
            oAsnDev.strDevIPAddress = oDevicePolicyState.getIPAdress().getBytes();
            oAsnDev.strDevTypeName = oDevicePolicyState.getNETypeName().getBytes();
            oAsnDev.iDevTypeId = BigInteger.valueOf(oDevicePolicyState.getDevTypeID());
            oAsnDev.iDevTypeVersionId = BigInteger.valueOf(oDevicePolicyState.getDevTypeVerID());
            oAsnDevLst.add((Object)oAsnDev);
        }
        return oAsnDevLst;
    }

    public static THashSet<Resource> getResourceHs(TIntArrayList oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            DCDebugTracer.trace("PolicyUtil#getResourceHs is NULL or size is 0");
            return null;
        }
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        THashSet oResHs = new THashSet();
        int iDevID = 0;
        DeviceInfo oDeviceInfo = null;
        Resource oResource = null;
        for (int i = 0; i < oDevIDLst.size(); ++i) {
            iDevID = oDevIDLst.get(i);
            oDeviceInfo = oDevMgr.getDevice(iDevID);
            if (null == oDeviceInfo) continue;
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(oDeviceInfo);
            oResHs.add((Object)oResource);
        }
        return oResHs;
    }

    public static List<Resource> getResourceLst(TIntArrayList oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            return null;
        }
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        ArrayList<Resource> oResLst = new ArrayList<Resource>();
        int iDevID = 0;
        DeviceInfo oDeviceInfo = null;
        Resource oResource = null;
        for (int i = 0; i < oDevIDLst.size(); ++i) {
            iDevID = oDevIDLst.get(i);
            oDeviceInfo = oDevMgr.getDevice(iDevID);
            if (null == oDeviceInfo) continue;
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(oDeviceInfo.getDevId());
            oResLst.add(oResource);
        }
        return oResLst;
    }

    public static MxuPolicyInfo getMxuPolicyInfo(String sVersion, List<MxuPolicyInfo> oMxuPolicyLst) {
        if (null == oMxuPolicyLst || oMxuPolicyLst.size() == 0) {
            return null;
        }
        for (MxuPolicyInfo oMxuPolicy : oMxuPolicyLst) {
            if (!Collator.getInstance().equals(oMxuPolicy.getUpgradeDevVersion(), sVersion)) continue;
            return oMxuPolicy;
        }
        return null;
    }

    public static List<FileInfo> decodeFileInfo(AsnSAMFileInfo oAsnSAMFileInfo) {
        ArrayList<FileInfo> oRtnFileLst = new ArrayList<FileInfo>();
        return oRtnFileLst;
    }

    public static List<FileInfo> getSamFileInfoLst(DeviceTypeInfo oDevTypeInfo, String sDestVersion) {
        ArrayList<FileInfo> oRtnFileLst = new ArrayList<FileInfo>();
        if (null == sDestVersion || Collator.getInstance().equals("", sDestVersion)) {
            return oRtnFileLst;
        }
        ISAMManager oManager = SAMManager.getInstance();
        SAMFileInfo oFileInfo = new SAMFileInfo();
        oFileInfo.setDeviceTypeInfo(oDevTypeInfo);
        oFileInfo.setVersion(sDestVersion);
        AsnSAMGetVersionFileLstRsp oFileListRsp = oManager.getAsnSAMDeviceVersionFileReq(oFileInfo);
        String strFilename = "";
        int iNoOfFile = oFileListRsp.oAsnSAMFileInfoLst.size();
        FileInfo oFile = null;
        for (int i = 0; i < iNoOfFile; ++i) {
            int iContentType = ((AsnSAMFileInfo)oFileListRsp.oAsnSAMFileInfoLst.get((int)i)).iFileType.intValue();
            SAMUtil.getInstance();
            ContentType oContentType = SAMUtil.getFileTypeObj(oFileInfo.getDeviceTypeInfo(), iContentType);
            if (null == oContentType || oContentType.getId().equals("DBUPDATE") || oContentType.getId().equals("PACKETTOOL")) continue;
            strFilename = new String(((AsnSAMFileInfo)oFileListRsp.oAsnSAMFileInfoLst.get((int)i)).strFileName);
            strFilename = strFilename.replace('\\', '/');
            strFilename = strFilename.substring(strFilename.lastIndexOf(47) + 1);
            oFile = new FileInfo();
            oFile.setFileName(strFilename);
            oFile.setIContentType(iContentType);
            oFile.setContentType(oContentType.getStrContentType());
            oFile.setSeqNumber(i + 1);
            oRtnFileLst.add(oFile);
        }
        return oRtnFileLst;
    }

    public static String getTime(String sTimeFormat) {
        SimpleDateFormat odf = new SimpleDateFormat(sTimeFormat);
        Date oCurDate = new Date();
        return odf.format(oCurDate);
    }

    public static boolean validateFileList(List<FileInfo> fileList) {
        int iNoOfFiles = fileList.size();
        boolean isValidFiles = false;
        String strSPHPatchType = DCFrameWorkUtil.getLocalizedString("SPH_PATCH_TYPE");
        String strSSPPatchType = DCFrameWorkUtil.getLocalizedString("SSP_PATCH_TYPE");
        int iSPHFileCount = 0;
        int iSSPFileCount = 0;
        for (int i = 0; i < iNoOfFiles; ++i) {
            if (fileList.get(i).getFileName().startsWith(strSPHPatchType)) {
                ++iSPHFileCount;
            } else if (fileList.get(i).getFileName().startsWith(strSSPPatchType)) {
                ++iSSPFileCount;
            } else {
                DCDebugTracer.trace("PolicyUtil#validateFileList");
            }
            if (iSSPFileCount <= 1 && iSPHFileCount <= 1) continue;
            return isValidFiles;
        }
        if (iSSPFileCount <= 1 && iSPHFileCount <= 1) {
            isValidFiles = true;
        }
        return isValidFiles;
    }

    public static boolean validateFileTypes(DeviceTypeInfo oDevTypeInfo, List<FileInfo> fileList) {
        int iNoOfFiles = fileList.size();
        boolean isValidFileTypes = false;
        int iNoOfPatches = 0;
        int iNoOfPackets = 0;
        for (int i = 0; i < iNoOfFiles; ++i) {
            SAMUtil.getInstance();
            ContentType oContentType = SAMUtil.getFileTypeObj(oDevTypeInfo, fileList.get(i).getIContentType());
            if (oContentType.getId().equals("PATCH")) {
                ++iNoOfPatches;
                continue;
            }
            if (oContentType.getId().equals("PACKETFILE")) {
                ++iNoOfPackets;
                continue;
            }
            DCDebugTracer.trace("PolicyUtil#validateFileTypes");
        }
        if (iNoOfPatches > 0 && 2 != oDevTypeInfo.getDevDomain()) {
            if (1 == iNoOfPackets) {
                isValidFileTypes = true;
            } else if (0 == iNoOfPackets) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("FILE_TYPE_SELECTED_INVALID"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("PACKET_TYPE_SELECTED_INVALID"), DCFrameWorkUtil.getLocalizedString("INFO"), 1);
            }
        } else {
            isValidFileTypes = true;
        }
        return isValidFileTypes;
    }

    public static void printLogInfo(List<PolicyInfo> oPolicyInfoLst) {
        if (null == oPolicyInfoLst || oPolicyInfoLst.isEmpty()) {
            return;
        }
        DCDebugTracer.trace("DC::policy the policy info as follow");
        int iPolicyID = -1;
        THashMap<Integer, DevicePolicyState> oDevPolicyStateHm = null;
        StringBuilder oDevIDBuf = null;
        for (PolicyInfo oPolicy : oPolicyInfoLst) {
            if (null == oPolicy) continue;
            iPolicyID = oPolicy.getPolicyID();
            DCDebugTracer.trace("policyID= " + iPolicyID);
            oDevPolicyStateHm = oPolicy.getDevicePolicyStateHm();
            if (null == oDevPolicyStateHm) {
                DCDebugTracer.traceError(" this policy contains no device");
                continue;
            }
            oDevIDBuf = new StringBuilder();
            Set oDevSet = oDevPolicyStateHm.entrySet();
            Iterator oDevItor = oDevSet.iterator();
            Map.Entry element = null;
            while (oDevItor.hasNext()) {
                element = (Map.Entry)oDevItor.next();
                oDevIDBuf.append(((DevicePolicyState)element.getValue()).getDevID());
                oDevIDBuf.append(" ");
            }
            DCDebugTracer.trace("dev list is " + oDevIDBuf.toString());
        }
    }

    public static List<MxuPolicyInfo> generateMxuPolicyLst(String sSubmapID) {
        ArrayList<MxuPolicyInfo> oRtnPolicyLst = new ArrayList<MxuPolicyInfo>();
        SubMapInfo oSubmapInfo = DeviceInfoManagerImpl.getInstance().getSubmapForID(sSubmapID, DeviceInfoManagerImpl.getInstance().getOLTSubmapInfo());
        ArrayList<String> oOltSubmapIDLst = new ArrayList<String>();
        oSubmapInfo.getOltSubmapIDLst(oOltSubmapIDLst);
        for (String sOltSubmapID : oOltSubmapIDLst) {
            oRtnPolicyLst.addAll(PolicyUtil.getMxuPolicyLst(sOltSubmapID));
        }
        return oRtnPolicyLst;
    }

    public static List<MxuPolicyInfo> getMxuPolicyLst(String sOltSubmapID) {
        ArrayList<MxuPolicyInfo> oRtnPolicyLst = new ArrayList<MxuPolicyInfo>();
        DeviceTypeInfo[] oDevTypeInfos = DeviceInfoManagerImpl.getInstance().getDeviceTypes();
        if (null == oDevTypeInfos || oDevTypeInfos.length == 0) {
            return null;
        }
        int iLength = oDevTypeInfos.length;
        DeviceTypeInfo oDevType = null;
        MxuPolicyInfo oMxuPolicy = null;
        int iDevTypeID = 0;
        int iDevTypeVerID = 0;
        for (int i = 0; i < iLength; ++i) {
            oDevType = oDevTypeInfos[i];
            if (null == oDevType || !oDevType.getIsMXUDevice() || !oDevType.isBMSDomain()) continue;
            iDevTypeID = oDevType.getDevTypeID();
            iDevTypeVerID = oDevType.getDevTypeVersionId();
            oMxuPolicy = PolicyManager.getInstance().getConfigMxuPolicyInfo(sOltSubmapID, iDevTypeID, iDevTypeVerID);
            if (null == oMxuPolicy) {
                oMxuPolicy = new MxuPolicyInfo(sOltSubmapID, iDevTypeID, iDevTypeVerID);
            }
            oRtnPolicyLst.add(oMxuPolicy);
        }
        return oRtnPolicyLst;
    }

    public static AsnDCPolicyDevIdBakNumLst getPolicyDevIdBakNumLst(PolicyInfo oDestPolicy, THashMap<Integer, DevicePolicyState> m_oDevHm) {
        List<PolicyDevTypeProperties> m_oPolicyDevTypePropLst = oDestPolicy.getPolicyDevTypePropLst();
        AsnDCPolicyDevIdBakNumLst oAsnDevNumLst = new AsnDCPolicyDevIdBakNumLst();
        AsnDCPolicyDevIdBakNum oAsnDevNum = null;
        ArrayList<BigInteger> oDeviceTypeIdLst = new ArrayList<BigInteger>();
        for (int index = 0; index < m_oPolicyDevTypePropLst.size(); ++index) {
            if (null == m_oPolicyDevTypePropLst.get(index)) continue;
            oDeviceTypeIdLst.add(index, BigInteger.valueOf(m_oPolicyDevTypePropLst.get(index).getDevTypeID()));
        }
        Set oDevSet = m_oDevHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        DevicePolicyState oDev = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            oDev = (DevicePolicyState)element.getValue();
            oAsnDevNum = new AsnDCPolicyDevIdBakNum();
            oAsnDevNum.iDeviceId = BigInteger.valueOf(oDev.getDevID());
            int index = oDeviceTypeIdLst.indexOf(BigInteger.valueOf(oDev.getDevTypeID()));
            DCDebugTracer.trace("PolicyUtil#getPolicyDevIdBakNumLst: DevTypeID= " + oDev.getDevTypeID());
            int iNumberOfBackupCopies = DCConfigFileParser.getDefaultBackNum();
            if (index >= 0) {
                iNumberOfBackupCopies = m_oPolicyDevTypePropLst.get(index).getNumOfBackupCopies();
            } else {
                DCDebugTracer.trace("PolicyUtil#getPolicyDevIdBakNumLst: DevTypeID can not find. ");
            }
            oAsnDevNum.iNumberOfBackupCopies = BigInteger.valueOf(iNumberOfBackupCopies);
            oAsnDevNumLst.add((Object)oAsnDevNum);
        }
        return oAsnDevNumLst;
    }

    public static void setSelDevLst(HashSet<Integer> iDevIdList) {
        iDevIdLst = iDevIdList;
    }

    public static HashSet<Integer> getSelDevLst() {
        return iDevIdLst;
    }

    public static void setNull() {
        iDevIdLst = null;
    }

    public static void viewDetailsPolicy(int iClickedRow, DCExtendedTable m_oPolicyTable) {
        Object valueAt = m_oPolicyTable.getValueAt(iClickedRow, 0);
        String savePeriod = m_oPolicyTable.getValueAt(iClickedRow, 4).toString();
        if (valueAt instanceof Integer) {
            PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo((Integer)valueAt);
            PolicyDetailDlg mDetailDlg = new PolicyDetailDlg(oPolicy);
            if (savePeriod.equals("--")) {
                mDetailDlg.setNotSupportSave();
            }
            mDetailDlg.setVisible(true);
        }
    }

    public static void startOrStopBackupOrSavePolicy(THashMap<Integer, DevicePolicyState> oDevHm, int ibackuoOrSave, int irunOrStop) {
        AsnDCDevicePolicyStateLst oAsnDevLst = PolicyUtil.initAsnDevLst(oDevHm, ibackuoOrSave, irunOrStop);
        PolicyManager.getInstance().setDevicePolicyStatus(oAsnDevLst);
    }
}

