/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyTreeMenuItemHandler;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.view.PolicyTreeNodeInfo;
import com.huawei.dc.policy.view.PolicyTreePanel;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PolicyTreePopupManager {
    private PolicyTreePanel m_oPolicyTreePanel = null;
    private HashMap m_oPolicyMenuItemMap;
    private static final String POLICY_TREE_POPUP_MENU_FILE = "policytreepopupmenu";
    private JTree m_oPolicyTree = null;
    private boolean m_hasPolicyMgrPrivilege = true;
    private JPopupMenu m_oPolicyTreePopupMenu;

    public PolicyTreePopupManager(PolicyTreeMenuItemHandler oPolicyTreeMenuItemHandler) {
        this.m_oPolicyTreePanel = oPolicyTreeMenuItemHandler.getPolicyTreePanel();
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oPolicyTreePopupMenu = oPopupMenuManager.load(oPolicyTreeMenuItemHandler, POLICY_TREE_POPUP_MENU_FILE);
        this.m_oPolicyMenuItemMap = oPopupMenuManager.getMenuItemMap();
    }

    private void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_hasPolicyMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43976);
    }

    public JPopupMenu loadMenu() {
        this.checkUserPrivileges();
        this.enableAllMenuItem(this.m_hasPolicyMgrPrivilege);
        this.m_oPolicyTree = this.m_oPolicyTreePanel.getPolicyTree();
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        PolicyTreeNodeInfo oPolicyNodeInfo = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        if (this.m_hasPolicyMgrPrivilege && oPolicyNodeInfo.getNodeType() == 0) {
            this.enablePolicyNodeMenu(oPolicyNodeInfo);
        } else if (this.m_hasPolicyMgrPrivilege && oPolicyNodeInfo.getNodeType() == 1) {
            this.enableSubmapNodeMenu(oPolicyNodeInfo);
        }
        return this.m_oPolicyTreePopupMenu;
    }

    private void enablePolicyNodeMenu(PolicyTreeNodeInfo oPolicyNodeInfo) {
        int iPolicyID = oPolicyNodeInfo.getPolicyID();
        if (iPolicyID == 0) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("DeletePolicy"), false);
        }
        this.setCreateMenuState();
        this.setStartAndStopMenuState(iPolicyID, "");
        this.setMoveMenuState(iPolicyID, "");
    }

    private void enableSubmapNodeMenu(PolicyTreeNodeInfo oPolicyNodeInfo) {
        int iPolicyID = oPolicyNodeInfo.getPolicyID();
        SubMapInfo oSubmap = oPolicyNodeInfo.getSubMapInfo();
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ModifyPolicy"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("ViewPolicy"), false);
        MenuUtil.visibleMenuItem(this.getMenuItemForID("DeletePolicy"), false);
        this.setStartAndStopMenuState(iPolicyID, oSubmap.m_strSubMapID);
        this.setMoveMenuState(iPolicyID, oSubmap.m_strSubMapID);
    }

    private void enableAllMenuItem(boolean bEnable) {
        for (String strMenuItemID : this.m_oPolicyMenuItemMap.keySet()) {
            JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
            MenuUtil.enableMenuItem((Component)oMenuItem, bEnable);
        }
    }

    private void setCreateMenuState() {
        DeviceInfo[] oDevInfos = DeviceInfoManagerImpl.getInstance().getDevices();
        if (null == oDevInfos || oDevInfos.length == 0) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("NewPolicy"), false);
        }
    }

    private void setStartAndStopMenuState(int iPolicyID, String sSubmapID) {
        boolean bRoute;
        PolicyInfo oPolicyInfo = PolicyManager.getInstance().getPolicyInfo(iPolicyID);
        int iSaveRun = 0;
        int iSaveStop = 0;
        int iSaveNotSupport = 0;
        int iBackupRun = 0;
        int iBackupStop = 0;
        int ibackupNotsupport = 0;
        THashMap<Integer, DevicePolicyState> oDevHm = oPolicyInfo.getDevicePolicyStateHm(sSubmapID);
        if (null == oDevHm || oDevHm.size() == 0) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartSavePolicy"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopSavePolicy"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartBackupPolicy"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopBackupPolicy"), false);
            return;
        }
        int iLength = oDevHm.size();
        int iSaveState = -1;
        int iBackupState = -1;
        Set oDevSet = oDevHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        DevicePolicyState oDev = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            oDev = (DevicePolicyState)element.getValue();
            boolean bSupportSave = oPolicyInfo.isDevSupportSavePolicy(oDev, 1);
            iSaveState = oDev.getSavePolicyState();
            iBackupState = oDev.getBakcupPolicyState();
            if (bSupportSave) {
                switch (iSaveState) {
                    case 0: {
                        ++iSaveRun;
                        break;
                    }
                    case 1: {
                        ++iSaveStop;
                        break;
                    }
                }
            } else {
                ++iSaveNotSupport;
            }
            switch (iBackupState) {
                case 0: {
                    ++iBackupRun;
                    break;
                }
                case 1: {
                    ++iBackupStop;
                    break;
                }
                case 3: {
                    ++ibackupNotsupport;
                    break;
                }
            }
        }
        boolean bStartSaveEnable = iSaveRun != iLength && iSaveRun + iSaveNotSupport != iLength;
        boolean bStopSaveEnable = iSaveStop != iLength && iSaveStop + iSaveNotSupport != iLength;
        boolean bStartbackupEnable = iBackupRun != iLength && iBackupRun + ibackupNotsupport != iLength;
        boolean bstopbackupEnable = iBackupStop != iLength && iBackupStop + ibackupNotsupport != iLength;
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartSavePolicy"), bStartSaveEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopSavePolicy"), bStopSaveEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartBackupPolicy"), bStartbackupEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopBackupPolicy"), bstopbackupEnable);
        int iServerDeployDomian = DCFrameWorkUtil.getServerDeployDomain();
        boolean bAccess = (iServerDeployDomian & 1) != 0;
        boolean bl = bRoute = (iServerDeployDomian & 2) != 0;
        if (!bAccess && !bRoute) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartSavePolicy"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopSavePolicy"), false);
        }
    }

    private void setMoveMenuState(int iPolicyID, String sSubmapID) {
        TIntArrayList oDevLst = this.m_oPolicyTreePanel.getSelectedDevIDLst(iPolicyID, sSubmapID);
        int oPolicyLstSize = PolicyManager.getInstance().getPolicyCount();
        if (null == oDevLst || oDevLst.size() == 0 || 0 == oPolicyLstSize || oPolicyLstSize == 2) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("MovePolicy"), false);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        return (JMenuItem)this.m_oPolicyMenuItemMap.get(strMenuItemID);
    }

    public void clearUpObject() {
        this.m_oPolicyTreePanel = null;
        this.m_oPolicyTree = null;
    }
}

