/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.common.asndatacenter.AsnDCSetOrGetPolicyInfoReq;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyTypeInfo;
import com.huawei.dc.policy.view.CommonPolicyDlg;
import com.huawei.dc.policy.view.CreatePolicyDlg;
import com.huawei.dc.policy.view.MovePolicyDlg;
import com.huawei.dc.policy.view.PolicyMgmtPanel;
import com.huawei.dc.policy.view.PolicyTablePanel;
import com.huawei.dc.policy.view.PolicyTreeNodeInfo;
import com.huawei.dc.policy.view.PolicyTreePanel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.util.DebugTracer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.commustru.fstru.FStruct;

public class PolicyTreeMenuItemHandler {
    private PolicyTreePanel m_oPolicyTreePanel = null;
    private JTree m_oPolicyTree = null;
    private boolean m_bCancelPressed = false;
    private SimpleProgressDlg m_oValidationProgressDlg = null;
    private Thread m_oNewPolicyThread = null;
    private THashSet<Resource> m_oSelectResLst = null;
    private DeviceType m_oSelDevType = null;
    private CreatePolicyDlg m_oCreateDlg = null;

    public PolicyTreeMenuItemHandler(PolicyTreePanel oPolicyTreePanel) {
        this.m_oPolicyTreePanel = oPolicyTreePanel;
        this.m_oPolicyTree = this.m_oPolicyTreePanel.getPolicyTree();
    }

    public PolicyTreePanel getPolicyTreePanel() {
        return this.m_oPolicyTreePanel;
    }

    public void newPolicy() {
        this.createOrModifyPolicy(0);
    }

    public void modifyPolicy() {
        this.createOrModifyPolicy(2);
    }

    private void createOrModifyPolicy(final int iCmdType) {
        DCDebugTracer.trace("createOrModifyPolicy#createOrModifyPolicy Start Type:" + iCmdType);
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        PolicyTreeNodeInfo oPolicyNodeInfo = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        final int iPolicyID = oPolicyNodeInfo.getPolicyID();
        final PolicyInfo oPolicy = PolicyManager.getInstance().getPolicyInfo(iPolicyID);
        if (iPolicyID == 0 && iCmdType == 2) {
            DCDebugTracer.trace("createOrModifyPolicy#Modify Default Policy");
            PolicyInfo oClonePolicy = (PolicyInfo)CloneUtil.getClone(oPolicy);
            final CommonPolicyDlg oCommonDlg = new CommonPolicyDlg(oClonePolicy, 2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oCommonDlg.setVisible(true);
                }
            });
            return;
        }
        this.getNEInfo();
        final String sSubmapID = oPolicyNodeInfo.getSubmapID();
        this.m_oNewPolicyThread = new Thread(){

            @Override
            public void run() {
                while (!PolicyTreeMenuItemHandler.this.m_oValidationProgressDlg.isVisible()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
                TIntArrayList oDevIDLst = PolicyTreeMenuItemHandler.this.m_oPolicyTreePanel.getSelectedDevIDLst(iPolicyID, sSubmapID);
                PolicyTreeMenuItemHandler.this.m_oSelectResLst = PolicyUtil.getResourceHs(oDevIDLst);
                PolicyTreeMenuItemHandler.this.m_oSelDevType = DeviceTableUtil.createDeviceTypeModel((THashSet<Resource>)PolicyTreeMenuItemHandler.this.m_oSelectResLst);
                PolicyInfo oClonePolicy = null;
                if (iCmdType == 2) {
                    oClonePolicy = (PolicyInfo)CloneUtil.getClone(oPolicy);
                }
                PolicyTreeMenuItemHandler.this.m_oCreateDlg = new CreatePolicyDlg(iCmdType, oClonePolicy, PolicyTreeMenuItemHandler.this.m_oSelDevType);
                if (null != PolicyTreeMenuItemHandler.this.m_oValidationProgressDlg) {
                    DCDebugTracer.trace("createOrModifyPolicy#m_oValidationProgressDlg.dispose");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PolicyTreeMenuItemHandler.this.m_oValidationProgressDlg.dispose();
                        }
                    });
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                if (null != PolicyTreeMenuItemHandler.this.m_oCreateDlg && !PolicyTreeMenuItemHandler.this.m_bCancelPressed) {
                    DCDebugTracer.trace("createOrModifyPolicy#m_oCreateDlg.setVisible");
                    PolicyTreeMenuItemHandler.this.m_oCreateDlg.setVisible(true);
                }
            }
        };
        this.m_oNewPolicyThread.start();
        DCDebugTracer.trace("createOrModifyPolicy#createOrModifyPolicy End");
    }

    private void getNEInfo() {
        this.m_bCancelPressed = false;
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("TLE_GET_NE_INFORMATION"), true, ResourceManager.getInstance().getResString("GETTING_TLE_GET_NE_INFORMATION")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                PolicyTreeMenuItemHandler.this.m_bCancelPressed = true;
                if (null != PolicyTreeMenuItemHandler.this.m_oNewPolicyThread) {
                    PolicyTreeMenuItemHandler.this.m_oNewPolicyThread.interrupt();
                    if (null != PolicyTreeMenuItemHandler.this.m_oCreateDlg) {
                        PolicyTreeMenuItemHandler.this.m_oCreateDlg.dispose();
                        PolicyTreeMenuItemHandler.this.m_oCreateDlg = null;
                    }
                    PolicyTreeMenuItemHandler.this.m_oSelDevType = null;
                    PolicyTreeMenuItemHandler.this.m_oSelectResLst = null;
                }
            }

            @Override
            protected void closeDialog() {
                this.showConfirmationDialog();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCDebugTracer.trace("createOrModifyPolicy#m_oValidationProgressDlg.setVisible");
                PolicyTreeMenuItemHandler.this.m_oValidationProgressDlg.setVisible(true);
            }
        });
    }

    public void viewPolicy() {
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        PolicyTreeNodeInfo oPolicyNodeInfo = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        PolicyInfo oPolicyInfo = PolicyManager.getInstance().getPolicyInfo(oPolicyNodeInfo.getPolicyID());
        final CommonPolicyDlg oCommonPolicyDlg = new CommonPolicyDlg(oPolicyInfo, 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oCommonPolicyDlg.setVisible(true);
            }
        });
    }

    public void movePolicy() {
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        PolicyTreeNodeInfo oPolicyNodeInfo = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        int iPolicyID = oPolicyNodeInfo.getPolicyID();
        String sSubmapID = oPolicyNodeInfo.getSubmapID();
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTreePanel.getSelectedDeviceHm(iPolicyID, sSubmapID);
        MovePolicyDlg oMovePolicyDlg = null;
        oMovePolicyDlg = new MovePolicyDlg(oDevHm, iPolicyID);
        oMovePolicyDlg.setVisible(true);
    }

    public void deletePolicy() {
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        PolicyTreeNodeInfo oPolicyNodeInfo = (PolicyTreeNodeInfo)oTreeNode.getUserObject();
        PolicyInfo oPolicyInfo = oPolicyNodeInfo.getPolicyInfo();
        int iPolicyID = oPolicyInfo.getPolicyID();
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POLICY_DELETE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM_SELECTION"), 0);
        if (iConfirm != 0) {
            return;
        }
        TIntArrayList oPolicyIDLst = new TIntArrayList();
        oPolicyIDLst.add(iPolicyID);
        PolicyManager.getInstance().deletePolicy(oPolicyIDLst);
    }

    public void startBackupPolicy() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POLICY_RUN_BACKUP_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM_SELECTION"), 0);
        if (iConfirm != 0) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        try {
            THashMap<Integer, DevicePolicyState> oDevHm = this.getCurPolicyTableDevDm();
            if (oDevHm != null) {
                DCDebugTracer.trace("startBackupPolicy#oDevHm Size:" + oDevHm.size());
                PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 0, 0);
            }
        }
        catch (Exception e) {
            DebugTracer.trace((String)e.getMessage());
        }
    }

    private THashMap<Integer, DevicePolicyState> getCurPolicyTableDevDm() {
        PolicyTablePanel m_oPolicyTablePanel;
        THashMap<Integer, DevicePolicyState> oDevHm = null;
        PolicyMgmtPanel oPolicyMgrPanel = DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel();
        if (null != oPolicyMgrPanel && null != (m_oPolicyTablePanel = oPolicyMgrPanel.getPolicyTablePanel())) {
            oDevHm = m_oPolicyTablePanel.getCurTableDeviceHm();
        }
        return oDevHm;
    }

    public void stopBackupPolicy() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POLICY_STOP_BACKUP_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM_SELECTION"), 0);
        if (iConfirm != 0) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        try {
            THashMap<Integer, DevicePolicyState> oDevHm = this.getCurPolicyTableDevDm();
            if (oDevHm != null) {
                DCDebugTracer.trace("stopBackupPolicy#oDevHm Size:" + oDevHm.size());
                PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 0, 1);
            }
        }
        catch (Exception e) {
            DebugTracer.trace((String)e.getMessage());
        }
    }

    public void startSavePolicy() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POLICY_RUN_SAVE_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM_SELECTION"), 0);
        if (iConfirm != 0) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        try {
            THashMap<Integer, DevicePolicyState> oDevHm = this.getCurPolicyTableDevDm();
            if (oDevHm != null) {
                DCDebugTracer.trace("startSavePolicy#oDevHm Size:" + oDevHm.size());
                PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 1, 0);
            }
        }
        catch (Exception e) {
            DebugTracer.trace((String)e.getMessage());
        }
    }

    public void stopSavePolicy() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("POLICY_STOP_SAVE_CONFIRM"), ResourceManager.getInstance().getResString("CONFIRM_SELECTION"), 0);
        if (iConfirm != 0) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)this.m_oPolicyTree.getSelectionPath().getLastPathComponent();
        if (null == oTreeNode) {
            return;
        }
        try {
            THashMap<Integer, DevicePolicyState> oDevHm = this.getCurPolicyTableDevDm();
            if (oDevHm != null) {
                DCDebugTracer.trace("stopSavePolicy#oDevHm Size:" + oDevHm.size());
                PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 1, 1);
            }
        }
        catch (Exception e) {
            DebugTracer.trace((String)e.getMessage());
        }
    }

    private void setPolicyStatus(PolicyInfo oPolicyInfo, int policyType, int devicePolicyState) {
        List<PolicyTypeInfo> policyTypeInfoList = oPolicyInfo.getPolicyTypeInfoLst();
        for (PolicyTypeInfo policyTypeInfo : policyTypeInfoList) {
            if (policyType != policyTypeInfo.getPolicyType()) continue;
            policyTypeInfo.setPolicyStatus(devicePolicyState);
        }
    }

    private void handlePolicyModify(PolicyInfo oPolicyInfo, int policyType, int devicePolicyState) {
        int iCmdCode = 43827;
        int iReqId = DCFrameWorkUtil.generateRequestId();
        this.setPolicyStatus(oPolicyInfo, policyType, devicePolicyState);
        DebugTracer.trace((String)"start or stop backup policy");
        AsnDCSetOrGetPolicyInfoReq oAsnReq = new AsnDCSetOrGetPolicyInfoReq();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnReq.oAsnDCSetOrGetPolicyInfo = PolicyUtil.encodeAsnDCSetOrGetPolicyInfo(oPolicyInfo);
        PolicyManager.getInstance().sendRequestToServer(iReqId, iCmdCode, (FStruct)oAsnReq);
    }

    public void clearUpObject() {
        if (null != this.m_oSelectResLst) {
            this.m_oSelectResLst.clear();
            this.m_oSelectResLst = null;
        }
        this.m_oPolicyTreePanel = null;
        this.m_oPolicyTree = null;
        this.m_oCreateDlg = null;
    }
}

