/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.policy.controller.PolicyManager;
import com.huawei.dc.policy.controller.PolicyTableMenuItemHandler;
import com.huawei.dc.policy.view.PolicyTablePanel;
import java.awt.Component;
import java.text.Collator;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PolicyTablePopupManager {
    private PolicyTablePanel m_oPolicyTablePanel = null;
    private HashMap m_oPolicyMenuMap;
    private static final String POLICY_TABLE_POPUP_MENU_FILE = "policytablepopupmenu";
    private boolean m_hasPolicyMgrPrivilege = true;
    private JPopupMenu m_oPolicyTablePopupMenu;

    public PolicyTablePopupManager(PolicyTableMenuItemHandler oPolicyTableMenuItemHandler) {
        this.m_oPolicyTablePanel = oPolicyTableMenuItemHandler.getPolicyTablePanel();
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oPolicyTablePopupMenu = oPopupMenuManager.load(oPolicyTableMenuItemHandler, POLICY_TABLE_POPUP_MENU_FILE);
        this.m_oPolicyMenuMap = oPopupMenuManager.getMenuItemMap();
    }

    private void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_hasPolicyMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43976);
    }

    public JPopupMenu loadMenu() {
        this.checkUserPrivileges();
        this.enableAllMenuItem(this.m_hasPolicyMgrPrivilege);
        if (this.m_hasPolicyMgrPrivilege) {
            this.setStartAndStopMenuState();
            this.setMoveDeviceMenuState();
        }
        this.enableViewDetailsMenu();
        return this.m_oPolicyTablePopupMenu;
    }

    private void enableAllMenuItem(boolean bEnable) {
        for (String strMenuItemID : this.m_oPolicyMenuMap.keySet()) {
            JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
            MenuUtil.enableMenuItem((Component)oMenuItem, bEnable);
        }
    }

    private void setStartAndStopMenuState() {
        boolean bRoute;
        int iSaveRun = 0;
        int iSaveStop = 0;
        int iSaveNotSupport = 0;
        int iBackupRun = 0;
        int iBackupStop = 0;
        int ibackupNotsupport = 0;
        DCSortableTableModel oPolicyTable = this.m_oPolicyTablePanel.getPolicyTableModel();
        int[] arrRows = this.m_oPolicyTablePanel.getPolicyTable().getSelectedRows();
        int iLength = arrRows.length;
        String sRunState = ResourceManager.getInstance().getResString("POLICY_STATUS_RUN");
        String sStopState = ResourceManager.getInstance().getResString("POLICY_STATUS_STOP");
        Collator oCol = Collator.getInstance();
        String sSaveStateus = "";
        String sBackupStatus = "";
        for (int index = 0; index < iLength; ++index) {
            sSaveStateus = oPolicyTable.getValueAt(arrRows[index], 5).toString();
            sBackupStatus = oPolicyTable.getValueAt(arrRows[index], 7).toString();
            if (oCol.equals(sSaveStateus, sRunState)) {
                ++iSaveRun;
            } else if (oCol.equals(sSaveStateus, sStopState)) {
                ++iSaveStop;
            } else if (oCol.equals(sSaveStateus, "--")) {
                ++iSaveNotSupport;
            }
            if (oCol.equals(sBackupStatus, sRunState)) {
                ++iBackupRun;
                continue;
            }
            if (oCol.equals(sBackupStatus, sStopState)) {
                ++iBackupStop;
                continue;
            }
            if (!oCol.equals(sBackupStatus, "--")) continue;
            ++ibackupNotsupport;
        }
        boolean bStartSaveEnable = iSaveRun != iLength && iSaveRun + iSaveNotSupport != iLength;
        boolean bStopSaveEnable = iSaveStop != iLength && iSaveStop + iSaveNotSupport != iLength;
        boolean bStartbackupEnable = iBackupRun != iLength && iBackupRun + ibackupNotsupport != iLength;
        boolean bstopbackupEnable = iBackupStop != iLength && iBackupStop + ibackupNotsupport != iLength;
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartSavePolicy"), bStartSaveEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopSavePolicy"), bStopSaveEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartBackupPolicy"), bStartbackupEnable);
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopBackupPolicy"), bstopbackupEnable);
        int iServerDeployDomian = DCFrameWorkUtil.getServerDeployDomain();
        boolean bAccess = (iServerDeployDomian & 1) != 0;
        boolean bl = bRoute = (iServerDeployDomian & 2) != 0;
        if (!bAccess && !bRoute) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StartSavePolicy"), false);
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("StopSavePolicy"), false);
        }
    }

    private void setMoveDeviceMenuState() {
        int oPolicyLstSize = PolicyManager.getInstance().getPolicyCount();
        if (0 == oPolicyLstSize || 2 == oPolicyLstSize) {
            MenuUtil.enableMenuItem((Component)this.getMenuItemForID("MovePolicy"), false);
        }
    }

    public JMenuItem getMenuItemForID(String strMenuItemID) {
        return (JMenuItem)this.m_oPolicyMenuMap.get(strMenuItemID);
    }

    public void cleanUp() {
        if (null != this.m_oPolicyTablePopupMenu) {
            this.m_oPolicyTablePopupMenu.removeAll();
            this.m_oPolicyTablePopupMenu = null;
        }
        this.m_oPolicyTablePanel = null;
    }

    private void enableViewDetailsMenu() {
        MenuUtil.enableMenuItem((Component)this.getMenuItemForID("ViewPolicyDetails"), this.compareBackupPolicy());
    }

    private boolean compareBackupPolicy() {
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getPolicyTable();
        Object policyID = null;
        int[] selectRows = oPolicyTable.getSelectedRows();
        if (null == selectRows || 0 == selectRows.length) {
            return false;
        }
        for (int index = 0; index < selectRows.length; ++index) {
            if (null == policyID) {
                policyID = oPolicyTable.getValueAt(selectRows[index], 0);
                continue;
            }
            if (policyID.equals(oPolicyTable.getValueAt(selectRows[index], 0))) continue;
            return false;
        }
        return true;
    }
}

