/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.file.util.SaveAsFileUtil;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.view.CreatePolicyDlg;
import com.huawei.dc.policy.view.MovePolicyDlg;
import com.huawei.dc.policy.view.PolicyTablePanel;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class PolicyTableMenuItemHandler {
    private PolicyTablePanel m_oPolicyTablePanel = null;
    private SimpleProgressDlg m_oValidationProgressDlg = null;
    private Thread m_oNewPolicyThread = null;
    private DeviceType m_oSelDevType = null;
    private THashSet<Resource> m_oSelectResLst = null;
    private boolean m_bCancelPressed = false;
    private CreatePolicyDlg m_oCreateDlg = null;
    private SaveAsFileUtil oSaveAsFileUtil = new SaveAsFileUtil();

    public PolicyTableMenuItemHandler(PolicyTablePanel oPolicyTablePanel) {
        this.m_oPolicyTablePanel = oPolicyTablePanel;
    }

    public PolicyTablePanel getPolicyTablePanel() {
        return this.m_oPolicyTablePanel;
    }

    public void newPolicy() {
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        DeviceInfo[] arrDevInfo = oDeviceInfoMgr.getDevices();
        if (arrDevInfo != null) {
            this.getNEInfo();
        }
        this.m_oNewPolicyThread = new Thread(){

            @Override
            public void run() {
                PolicyTableMenuItemHandler.this.m_oSelectResLst = PolicyTableMenuItemHandler.this.m_oPolicyTablePanel.getSelectedDeviceHs();
                if (null != PolicyTableMenuItemHandler.this.m_oSelectResLst) {
                    PolicyTableMenuItemHandler.this.m_oSelDevType = DeviceTableUtil.createDeviceTypeModel((THashSet<Resource>)PolicyTableMenuItemHandler.this.m_oSelectResLst);
                }
                PolicyTableMenuItemHandler.this.m_oCreateDlg = new CreatePolicyDlg(0, null, PolicyTableMenuItemHandler.this.m_oSelDevType);
                if (null != PolicyTableMenuItemHandler.this.m_oValidationProgressDlg) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PolicyTableMenuItemHandler.this.m_oValidationProgressDlg.dispose();
                        }
                    });
                }
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                if (null != PolicyTableMenuItemHandler.this.m_oCreateDlg && !PolicyTableMenuItemHandler.this.m_bCancelPressed) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PolicyTableMenuItemHandler.this.m_oCreateDlg.setVisible(true);
                        }
                    });
                }
            }
        };
        this.m_oNewPolicyThread.start();
    }

    private void getNEInfo() {
        this.m_bCancelPressed = false;
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("TLE_GET_NE_INFORMATION"), true, ResourceManager.getInstance().getResString("GETTING_TLE_GET_NE_INFORMATION")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                PolicyTableMenuItemHandler.this.m_bCancelPressed = true;
                if (null != PolicyTableMenuItemHandler.this.m_oNewPolicyThread) {
                    PolicyTableMenuItemHandler.this.m_oNewPolicyThread.interrupt();
                    if (null != PolicyTableMenuItemHandler.this.m_oCreateDlg) {
                        PolicyTableMenuItemHandler.this.m_oCreateDlg.dispose();
                        PolicyTableMenuItemHandler.this.m_oCreateDlg = null;
                    }
                    PolicyTableMenuItemHandler.this.m_oSelDevType = null;
                    PolicyTableMenuItemHandler.this.m_oSelectResLst = null;
                }
            }

            @Override
            protected void closeDialog() {
                this.showConfirmationDialog();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyTableMenuItemHandler.this.m_oValidationProgressDlg.setVisible(true);
            }
        });
    }

    public void movePolicy() {
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTablePanel.getSelectedDeviceHm();
        TIntArrayList oPolicyIDLst = this.m_oPolicyTablePanel.getSelectedPolicyIDs();
        MovePolicyDlg oMovePolicyDlg = null;
        if (oPolicyIDLst.size() == 1) {
            int iPolicyID = oPolicyIDLst.get(0);
            oMovePolicyDlg = new MovePolicyDlg(oDevHm, iPolicyID);
        } else if (oPolicyIDLst.size() > 1) {
            oMovePolicyDlg = new MovePolicyDlg(oDevHm);
        } else {
            return;
        }
        if (null != oMovePolicyDlg) {
            oMovePolicyDlg.setLocationRelativeTo(this.m_oPolicyTablePanel);
            oMovePolicyDlg.setVisible(true);
        }
    }

    public void startBackupPolicy() {
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTablePanel.getSelectedDeviceHm();
        PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 0, 0);
    }

    public void stopBackupPolicy() {
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTablePanel.getSelectedDeviceHm();
        PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 0, 1);
    }

    public void startSavePolicy() {
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTablePanel.getSelectedDeviceHm();
        PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 1, 0);
    }

    public void stopSavePolicy() {
        THashMap<Integer, DevicePolicyState> oDevHm = this.m_oPolicyTablePanel.getSelectedDeviceHm();
        PolicyUtil.startOrStopBackupOrSavePolicy(oDevHm, 1, 1);
    }

    public void saveAsPolicy() {
        ResourceManager oRes = ResourceManager.getInstance();
        String strFileName = this.oSaveAsFileUtil.getSelectFileName(oRes.getResString("POLICY_INFO"));
        if (null != strFileName) {
            this.savePolicyInfo(strFileName);
        }
    }

    private void savePolicyInfo(final String sFileName) {
        final String[] sTableHearders = this.getArrHeaderFields();
        final Vector<Object> oDataVct = this.getPolicyInfoVector();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PolicyTableMenuItemHandler.this.oSaveAsFileUtil.saveAsInFile(oDataVct, ResourceManager.getInstance().getResString("POLICY_SAVE_HEARDER"), sTableHearders, sFileName);
            }
        });
    }

    private Vector<Object> getPolicyInfoVector() {
        Vector<Object> oDataVct = new Vector<Object>();
        Vector<String> oRowVct = null;
        Vector oVectorTmp = null;
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getPolicyTable();
        String sYes = ResourceManager.getInstance().getResString("TRUE");
        String sNo = ResourceManager.getInstance().getResString("FALSE");
        int[] iSelRows = oPolicyTable.getSelectedRows();
        List<Resource> oResHs = this.m_oPolicyTablePanel.getSelectedResources();
        if (null == oResHs || 0 == oResHs.size()) {
            return null;
        }
        int iCurRows = oPolicyTable.getColumnModel().getColumnCount();
        int iCurRowIndex = 0;
        boolean RESOURCE_NAME_COL = true;
        for (Resource oRes : oResHs) {
            oRowVct = new Vector<String>();
            oVectorTmp = (Vector)this.m_oPolicyTablePanel.getPolicyTableModel().getDataVector().get(iSelRows[iCurRowIndex++]);
            if (null == oVectorTmp || !oVectorTmp.get(1).equals(oRes.getDeviceName())) {
                oVectorTmp = this.getCurDataVector(oRes);
            }
            if (null == oVectorTmp) continue;
            int index = 0;
            for (int j = 1; j < iCurRows; ++j) {
                index = oPolicyTable.getColumnModel().getColumn(j).getModelIndex();
                if (2 == index) {
                    String strIP = oVectorTmp.get(index).toString();
                    oRowVct.add(strIP);
                    continue;
                }
                if (11 == index) {
                    boolean bSaveBeforeBackup;
                    String sSaveBeforeBackup = "";
                    Object oSaveBefore = oVectorTmp.get(index);
                    sSaveBeforeBackup = null == oSaveBefore ? "--" : (oSaveBefore instanceof Boolean ? ((bSaveBeforeBackup = ((Boolean)oSaveBefore).booleanValue()) ? sYes : sNo) : oSaveBefore.toString());
                    oRowVct.add(sSaveBeforeBackup);
                    continue;
                }
                if (12 == index) {
                    Object oConfig = oVectorTmp.get(index);
                    if (oConfig instanceof Boolean) {
                        Boolean bConfig = (Boolean)oConfig;
                        if (bConfig.booleanValue()) {
                            oRowVct.add(sYes);
                            continue;
                        }
                        oRowVct.add(sNo);
                        continue;
                    }
                    oRowVct.add((String)oConfig);
                    continue;
                }
                if (13 == index) {
                    DevicePolicyState oDev = (DevicePolicyState)oVectorTmp.get(index);
                    String sTimerBackup = "";
                    if (null != oDev) {
                        sTimerBackup = oDev.getShowProgressInfo();
                    }
                    oRowVct.add(sTimerBackup);
                    continue;
                }
                oRowVct.add((String)oVectorTmp.get(index));
            }
            oDataVct.add(oRowVct);
        }
        return oDataVct;
    }

    public void viewPolicyDetails() {
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getPolicyTable();
        int rowNum = oPolicyTable.getSelectedRow();
        PolicyUtil.viewDetailsPolicy(rowNum, oPolicyTable);
    }

    private Vector getCurDataVector(Resource oRes) {
        Vector oTmpVector = null;
        Vector oTableVector = this.m_oPolicyTablePanel.getPolicyTableModel().getDataVector();
        boolean RESOURCE_NAME_COL = true;
        for (int i = 0; i < oTableVector.size(); ++i) {
            oTmpVector = (Vector)oTableVector.get(i);
            if (null == oTmpVector || !oTmpVector.get(1).equals(oRes.getDeviceName())) continue;
            return oTmpVector;
        }
        return oTmpVector;
    }

    private String[] getArrHeaderFields() {
        DCExtendedTable oPolicyTable = this.m_oPolicyTablePanel.getPolicyTable();
        int columnCount = oPolicyTable.getColumnCount();
        int iOffset = 1;
        String[] arrHeaderFields = new String[columnCount - iOffset];
        for (int i = 0; i < columnCount - iOffset; ++i) {
            arrHeaderFields[i] = oPolicyTable.getColumnName(i + iOffset);
        }
        return arrHeaderFields;
    }

    public void clearUpObject() {
        if (null != this.m_oPolicyTablePanel) {
            this.m_oPolicyTablePanel = null;
        }
    }
}

