/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.asndatacenter.AsnDCAllPolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCAllPolicyInfoLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDeletePolcyIDLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDevicePolicyState;
import com.huawei.dc.common.asndatacenter.AsnDCDevicePolicyStateLst;
import com.huawei.dc.common.asndatacenter.AsnDCDevicePolicyStateLstReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoResp;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyPeriodEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyStateEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicyTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCPolicytypeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCReq;
import com.huawei.dc.common.asndatacenter.AsnDCSetOrGetPolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSetOrGetPolicyInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCSetOrGetPolicyInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.MethodUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.policy.controller.IPolicyChangeListener;
import com.huawei.dc.policy.controller.PolicyEventObject;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyDevTypeProperties;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.policy.model.PolicyProgressInfo;
import com.huawei.dc.policy.mxupolicy.MXUPolicyDlg;
import com.huawei.dc.policy.mxupolicy.MxuPolicyInfo;
import com.huawei.dc.policy.view.PolicyMgmtPanel;
import com.huawei.dc.policy.view.PolicyTablePanel;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class PolicyManager
extends AbstractDCMSGReceiver
implements IDeviceConfigChangeListener,
IDCObjectDeallocator {
    private static final int[] COMMAND_CODES = new int[]{43815, 43827, 43987, 43976, 43985, 43828, 43971, 43816};
    private static PolicyManager m_oPolicyMgr = null;
    private List<PolicyInfo> oCurPolicyInfoLst = new ArrayList<PolicyInfo>();
    private byte[] syncPolicy = new byte[0];
    private List<Object> m_oPolicyChangeListenerLst = new ArrayList<Object>();
    private TIntArrayList m_oBusyRequestIDLst = new TIntArrayList();
    private SimpleProgressDlg m_oProgressDlg = null;

    private PolicyManager() {
        super(COMMAND_CODES);
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    public static synchronized PolicyManager getInstance() {
        if (null == m_oPolicyMgr) {
            m_oPolicyMgr = new PolicyManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oPolicyMgr);
        }
        return m_oPolicyMgr;
    }

    protected void processMessage(MSGPacketExt oMsgPacket) {
        try {
            this.processAsnMessage(oMsgPacket);
        }
        catch (Exception ignore) {
            DCDebugTracer.trace(ignore);
            if (null != this.m_oProgressDlg) {
                DCFrameWorkUtil.enableComponent(DCFrameWorkUtil.getToolBarButton("refreshTree"), true);
                this.m_oProgressDlg.dispose();
                this.m_oProgressDlg = null;
            }
            if (null != this.m_oBusyRequestIDLst) {
                this.m_oBusyRequestIDLst.clear();
            }
            DCFrameWorkUtil.defaultCursor();
        }
    }

    private void processAsnMessage(MSGPacketExt oMsgPacket) {
        DCDebugTracer.trace("receive asyn msg cmdCode=" + oMsgPacket.mheader.cmdCode);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace("sleep got error.");
        }
        switch (oMsgPacket.mheader.cmdCode) {
            case 43976: {
                this.handleGetPolicy(oMsgPacket);
                break;
            }
            case 43815: {
                this.handleCreatePolicy(oMsgPacket);
                break;
            }
            case 43987: {
                this.handleDeletePolicy(oMsgPacket);
                break;
            }
            case 43827: {
                this.handleModifyPolicy(oMsgPacket);
                break;
            }
            case 43985: {
                this.handleDevPolicyStateChange(oMsgPacket);
                break;
            }
            case 43828: {
                this.handleDevMove(oMsgPacket);
                break;
            }
            case 43971: {
                this.handleMxuPolicyChange(oMsgPacket);
                break;
            }
            case 43816: {
                this.handleTimerBackupResult(oMsgPacket);
                break;
            }
        }
    }

    public boolean isCheckDistRoomOK(final int iCmdCode, final FStruct oAsnRequest) {
        boolean bCheckDistRoom = true;
        DCDebugTracer.trace("================>DC::CheckDistRoom send syn msg start!");
        final AsnDCErrorCodeInfo oErrorInfo = new AsnDCErrorCodeInfo();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), oAsnRequest, (FStruct)oErrorInfo);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int returnCode = 0;
        if (null != syncCommand.getResult()) {
            returnCode = (Integer)syncCommand.getResult();
        }
        DCDebugTracer.trace("================>DC::CheckDistRoom send syn msg end!");
        if (null != syncCommand.getResult() && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), returnCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            bCheckDistRoom = false;
            return bCheckDistRoom;
        }
        if (oErrorInfo.iErrorNo.intValue() == 0) {
            return bCheckDistRoom;
        }
        String strMsg = DCFrameWorkUtil.getLocalizedString("CHECK_DIST_ROOM_CONFIG1");
        int iConfirmOutputFirst = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutputFirst) {
            bCheckDistRoom = false;
            return bCheckDistRoom;
        }
        strMsg = DCFrameWorkUtil.getLocalizedString("CHECK_DIST_ROOM_CONFIG2");
        int iConfirmOutputSecond = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutputSecond) {
            bCheckDistRoom = false;
            return bCheckDistRoom;
        }
        return bCheckDistRoom;
    }

    public int sendRequestToServer(int iReqId, int iCmdCode, FStruct oAsnRequest) {
        DCDebugTracer.trace("================>DC::policy send syn msg start!");
        PolicyMgmtPanel oPolicyMgrPanel = DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel();
        if (null == this.m_oProgressDlg && null != oPolicyMgrPanel && 43976 != iCmdCode) {
            this.initProgressDlg(iReqId);
        }
        DCFrameWorkUtil.waitCursor();
        DCDebugTracer.trace("DC::policy send syn msg cmdCode=" + iCmdCode);
        AsnDCSyncRsp oMsgRsp = new AsnDCSyncRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(iCmdCode, oAsnRequest, (FStruct)oMsgRsp);
        if (iErrorCode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return iErrorCode;
        }
        AsnDCErrorCodeInfo oAsnDCErrorCodeInfo = oMsgRsp.oErrorInfo;
        iErrorCode = oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnDCErrorCodeInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return iErrorCode;
        }
        int iRequestID = oMsgRsp.oReqID.intValue();
        if (null != this.m_oProgressDlg && !this.m_oProgressDlg.isClosed() && !this.m_oProgressDlg.isVisible()) {
            this.showProgressDlg();
        }
        DCDebugTracer.trace("=======>DC::iRequestID is: " + iRequestID);
        DCDebugTracer.trace("================>DC::policy send syn msg end!");
        return iErrorCode;
    }

    public void initProgressDlg(int iRequestID) {
        this.m_oProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("POLICY_INFO_PROGRESS"), true, ResourceManager.getInstance().getResString("GETTING_POLICY_INFO_PROGRESS")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == PolicyManager.this.m_oProgressDlg) {
                    return;
                }
                PolicyManager.this.m_oProgressDlg.dispose();
                PolicyManager.this.m_oProgressDlg = null;
                this.doCleanUp();
            }
        };
        this.m_oProgressDlg.setProgressDlgId(iRequestID);
        this.m_oProgressDlg.setLocationRelativeTo((Component)((Object)DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel()));
        this.m_oBusyRequestIDLst.add(iRequestID);
    }

    public void showProgressDlg() {
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != PolicyManager.this.m_oProgressDlg) {
                    PolicyTablePanel oTablePanel;
                    PolicyMgmtPanel oPolicyMgrPanel;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace(e);
                    }
                    SimpleProgressDlg simpleProgressDlg = PolicyManager.this.m_oProgressDlg;
                    DCFrameWorkUtil.getDCModuleManager();
                    DCGUIUtil.setInnerModalDialogParent(simpleProgressDlg, 5, true);
                    if (null != PolicyManager.this.m_oProgressDlg) {
                        PolicyManager.this.m_oProgressDlg.setVisible(true);
                    }
                    if (null != (oPolicyMgrPanel = DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel()) && null != (oTablePanel = oPolicyMgrPanel.getPolicyTablePanel())) {
                        oTablePanel.setRefreshDateTime();
                    }
                }
            }
        });
    }

    private void closeProgressDlg(int iRequestID) {
        if (null != this.m_oProgressDlg && this.m_oProgressDlg.getProgressDlgId() == iRequestID) {
            DCFrameWorkUtil.enableComponent(DCFrameWorkUtil.getToolBarButton("refreshTree"), true);
            this.m_oProgressDlg.dispose();
            this.m_oProgressDlg = null;
        }
    }

    private void handleGetPolicy(MSGPacketExt oMsgPacket) {
        AsnDCAllPolicyInfoLstRsp oAsnDCAllPolicyInfoLstRsp = new AsnDCAllPolicyInfoLstRsp();
        long curTime = System.currentTimeMillis();
        DCDebugTracer.trace("Decode Time Start:" + curTime);
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCAllPolicyInfoLstRsp, oMsgPacket.getData());
        DCDebugTracer.trace("Decode Time End:" + (System.currentTimeMillis() - curTime));
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("INFORMATION"), 64);
            DCDebugTracer.trace("DC::policy faild to get policy decode error");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequestID = oAsnDCAllPolicyInfoLstRsp.oReqID.intValue();
        iErrorcode = oAsnDCAllPolicyInfoLstRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::policy faild to get policy decode error");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCAllPolicyInfoLst oAsnDCAllPolicyInfoLst = oAsnDCAllPolicyInfoLstRsp.oAsnDCAllPolicyInfoLst;
        curTime = System.currentTimeMillis();
        DCDebugTracer.trace("decodePolicyInfoLst Time Start:" + curTime);
        List<PolicyInfo> oPolicyLst = PolicyUtil.decodePolicyInfoLst(oAsnDCAllPolicyInfoLst);
        DCDebugTracer.trace("decodePolicyInfoLst Time End:" + (System.currentTimeMillis() - curTime));
        if (null == oPolicyLst) {
            DCDebugTracer.trace("DC::policy faild,receive the list is null.");
            oPolicyLst = new ArrayList<PolicyInfo>();
        }
        boolean bFinalInfo = oAsnDCAllPolicyInfoLstRsp.bIsFinal;
        DCDebugTracer.trace("DC::plicy get policy info is final? " + bFinalInfo);
        curTime = System.currentTimeMillis();
        DCDebugTracer.trace("addPolicy Time Start:" + curTime);
        for (PolicyInfo oPolicy : oPolicyLst) {
            this.addPolicy(oPolicy);
        }
        DCDebugTracer.trace("addPolicy Time End:" + (System.currentTimeMillis() - curTime));
        curTime = System.currentTimeMillis();
        DCDebugTracer.trace("printLogInfo Time Start:" + curTime);
        PolicyUtil.printLogInfo(this.oCurPolicyInfoLst);
        DCDebugTracer.trace("printLogInfo Time End:" + (System.currentTimeMillis() - curTime));
        if (!bFinalInfo) {
            return;
        }
        this.reInitPolicy();
        this.refreshCursorStatus(iRequestID);
    }

    public synchronized void reInitPolicy() {
        DCDebugTracer.trace("Mark::PolidyManager::reInitPolicy::begin");
        if (null != DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel()) {
            DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel().initData(this.oCurPolicyInfoLst);
        }
        DCDebugTracer.trace("Mark::PolidyManager::reInitPolicy::end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolicy(PolicyInfo oPolicy) {
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            DCDebugTracer.trace("Mark::PolidyManager::addPolicy::begin");
            int policySize = this.oCurPolicyInfoLst.size();
            for (int i = policySize - 1; i >= 0; --i) {
                if (this.oCurPolicyInfoLst.get(i).getPolicyID() != oPolicy.getPolicyID()) continue;
                this.oCurPolicyInfoLst.get(i).clearObject();
                this.oCurPolicyInfoLst.remove(i);
            }
            if (-1 == oPolicy.getPolicyID()) {
                this.oCurPolicyInfoLst.add(oPolicy);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            TIntHashSet oDevIDLst = oPolicy.getDevIDLst();
            if (null != oDevIDLst) {
                for (int iDevId : oDevIDLst) {
                    DeviceInfo tmpDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
                    if (null != tmpDeviceInfo) continue;
                    oPolicy.removeDevice(iDevId);
                }
                if (oDevIDLst.size() > 0) {
                    this.oCurPolicyInfoLst.add(oPolicy);
                } else {
                    if (0 == oPolicy.getPolicyID()) {
                        this.oCurPolicyInfoLst.add(oPolicy);
                    }
                    DCDebugTracer.trace("oPolicy : " + oPolicy.getPolicyName() + " device list is empty.");
                }
            } else if (0 == oPolicy.getPolicyID()) {
                this.oCurPolicyInfoLst.add(oPolicy);
            } else {
                DCDebugTracer.trace("oPolicy : " + oPolicy.getPolicyName() + " device list is empty.");
            }
            DCDebugTracer.trace("Mark::PolidyManager::addPolicy::end");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreatePolicy(MSGPacketExt oMsgPacket) {
        DCDebugTracer.trace("DC::policy create new policy start");
        AsnDCSetOrGetPolicyInfoRsp oAsnDCSetOrGetPolicyInfoRsp = new AsnDCSetOrGetPolicyInfoRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCSetOrGetPolicyInfoRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequstID = oAsnDCSetOrGetPolicyInfoRsp.oReqID.intValue();
        iErrorcode = oAsnDCSetOrGetPolicyInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCSetOrGetPolicyInfo oAsnSetOrGetPolicy = oAsnDCSetOrGetPolicyInfoRsp.oAsnDCSetOrGetPolicyInfo;
        PolicyInfo oPolicyInfo = PolicyUtil.decode2PolicyInfo(oAsnSetOrGetPolicy);
        DCDebugTracer.trace("create policy " + oPolicyInfo.getPolicyName());
        PolicyProgressInfo oProgress = new PolicyProgressInfo(0, -1);
        oPolicyInfo.refreshDevStatus(oProgress);
        boolean isThisClientRequest = this.m_oBusyRequestIDLst.contains(iRequstID);
        this.removeDevsFromOtherPolicy(oPolicyInfo, isThisClientRequest);
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            this.oCurPolicyInfoLst.add(oPolicyInfo);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            this.notifyEvent(0, oPolicyInfo, isThisClientRequest, true);
            this.refreshCursorStatus(iRequstID);
            DCDebugTracer.trace("DC::policy create new policy " + oPolicyInfo.getPolicyName());
            return;
        }
    }

    private void handleModifyPolicy(MSGPacketExt oMsgPacket) {
        AsnDCAllPolicyInfoLstRsp oAsnDCAllPolicyInfoLstRsp = new AsnDCAllPolicyInfoLstRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCAllPolicyInfoLstRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequestID = oAsnDCAllPolicyInfoLstRsp.oReqID.intValue();
        boolean isThisClientRequest = this.isThisRequest(iRequestID);
        iErrorcode = oAsnDCAllPolicyInfoLstRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCAllPolicyInfoLst oAsnPolicyLst = oAsnDCAllPolicyInfoLstRsp.oAsnDCAllPolicyInfoLst;
        List<PolicyInfo> oPolicyLst = PolicyUtil.decodePolicyInfoLst(oAsnPolicyLst);
        PolicyInfo oOldPolicy = null;
        for (PolicyInfo oPolicyInfo : oPolicyLst) {
            oOldPolicy = this.getPolicyInfo(oPolicyInfo.getPolicyID());
            DCDebugTracer.trace("modify policy " + oPolicyInfo.toString());
            THashMap<Integer, DevicePolicyState> oDeletedDevHm = new THashMap<Integer, DevicePolicyState>();
            try {
                oDeletedDevHm = this.getDeletedDevInfoHm(oOldPolicy, oPolicyInfo);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
            THashMap<Integer, DevicePolicyState> oAddDevHm = this.getDeletedDevInfoHm(oPolicyInfo, oOldPolicy);
            Set oAddDevSet = oAddDevHm.entrySet();
            PolicyInfo oTmpPolicy = null;
            int iDevID = -1;
            Iterator oAddDevItor = oAddDevSet.iterator();
            while (oAddDevItor.hasNext()) {
                iDevID = (Integer)((Map.Entry)oAddDevItor.next()).getKey();
                oTmpPolicy = this.getPolicyInfoByDevID(iDevID);
                if (null == oTmpPolicy) continue;
                oTmpPolicy.removeDevice(iDevID);
                this.notifyEvent(5, oTmpPolicy, isThisClientRequest, false);
                THashMap<Integer, DevicePolicyState> odevLst = oTmpPolicy.getDevicePolicyStateHm();
                if (null != odevLst && odevLst.size() != 0) continue;
                this.notifyEvent(1, oTmpPolicy, isThisClientRequest, false);
                this.removePolicy(oTmpPolicy);
            }
            PolicyInfo oDefualtPolicy = this.getPolicyInfo(0);
            oDefualtPolicy.addDevice(oDeletedDevHm);
            if (oPolicyLst.get(0).getPolicyName().equals(ResourceManager.getInstance().getResString("POLICY_DEFAULT_NAME"))) {
                oDefualtPolicy.setPolicyTypeInfoLst(oPolicyLst.get(0).getPolicyTypeInfoLst());
            }
            this.notifyEvent(2, oDefualtPolicy, isThisClientRequest, false);
            PolicyProgressInfo oProgress = new PolicyProgressInfo(0, -1);
            oPolicyInfo.refreshDevStatus(oProgress);
            this.modifyPolicy(oPolicyInfo);
            this.notifyEvent(2, oPolicyInfo, isThisClientRequest, true);
        }
        this.refreshCursorStatus(iRequestID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleDeletePolicy(MSGPacketExt oMsgPacket) {
        AsnDCDeletePolcyIDLstRsp oAsnDCDeletePolcyIDLstRsp = new AsnDCDeletePolcyIDLstRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCDeletePolcyIDLstRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequestID = oAsnDCDeletePolcyIDLstRsp.oReqID.intValue();
        boolean isThisClientRequest = this.isThisRequest(iRequestID);
        iErrorcode = oAsnDCDeletePolcyIDLstRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCIntegerLst oAsnPlicyIDLst = oAsnDCDeletePolcyIDLstRsp.oAsnDCDeletePolcyIDLst;
        if (null == oAsnPlicyIDLst) {
            return;
        }
        int iPolicyID = -1;
        PolicyInfo oPolicyInfo = null;
        int i = 0;
        while (true) {
            if (i >= oAsnPlicyIDLst.size()) {
                this.notifyEvent(4, this.getPolicyInfo(0), isThisClientRequest, true);
                this.refreshCursorStatus(iRequestID);
                return;
            }
            iPolicyID = ((BigInteger)oAsnPlicyIDLst.get(i)).intValue();
            oPolicyInfo = this.getPolicyInfo(iPolicyID);
            if (null != oPolicyInfo) {
                DCDebugTracer.trace("delete policy " + oPolicyInfo.toString());
                this.notifyEvent(1, oPolicyInfo, isThisClientRequest, false);
                this.moveDevice(oPolicyInfo, this.getPolicyInfo(0));
                byte[] byArray = this.syncPolicy;
                // MONITORENTER : this.syncPolicy
                this.oCurPolicyInfoLst.remove(oPolicyInfo);
                // MONITOREXIT : byArray
            }
            ++i;
        }
    }

    private void handleDevPolicyStateChange(MSGPacketExt oMsgPacket) {
        DCDebugTracer.trace("=================>set policy status start!");
        AsnDCAllPolicyInfoLstRsp oAsnDCAllPolicyInfoLstRsp = new AsnDCAllPolicyInfoLstRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCAllPolicyInfoLstRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequestID = oAsnDCAllPolicyInfoLstRsp.oReqID.intValue();
        boolean isThisClientRequest = this.isThisRequest(iRequestID);
        DCDebugTracer.trace("=================>response iRequestID is: " + iRequestID);
        iErrorcode = oAsnDCAllPolicyInfoLstRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCAllPolicyInfoLst oAsnPolicyLst = oAsnDCAllPolicyInfoLstRsp.oAsnDCAllPolicyInfoLst;
        List<PolicyInfo> oPolicyLst = PolicyUtil.decodePolicyInfoLst(oAsnPolicyLst);
        THashMap<Integer, DevicePolicyState> oSourceDevStateHm = null;
        int iPolicyID = -1;
        for (PolicyInfo oPolicyInfo : oPolicyLst) {
            if (null == oPolicyInfo || null == (oSourceDevStateHm = oPolicyInfo.getDevicePolicyStateHm()) || oSourceDevStateHm.size() == 0) continue;
            DCDebugTracer.trace("set policy state " + oPolicyInfo.getPolicyName());
            iPolicyID = oPolicyInfo.getPolicyID();
            this.updateDevicePolicyStatus(iPolicyID, oSourceDevStateHm);
        }
        this.notifyEvent(6, oPolicyLst, isThisClientRequest, true);
        this.refreshCursorStatus(iRequestID);
        DCDebugTracer.trace("=================>set policy status end!");
    }

    private void handleDevMove(MSGPacketExt oMsgPacket) {
        PolicyTablePanel oTablePanel;
        AsnDCSetOrGetPolicyInfoRsp oAsnDCSetOrGetPolicyInfoRsp = new AsnDCSetOrGetPolicyInfoRsp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCSetOrGetPolicyInfoRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        int iRequestID = oAsnDCSetOrGetPolicyInfoRsp.oReqID.intValue();
        boolean isThisClientRequest = this.isThisRequest(iRequestID);
        iErrorcode = oAsnDCSetOrGetPolicyInfoRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::POLICY::faild to receive create policy response, decode failed");
            DCFrameWorkUtil.defaultCursor();
            this.m_oBusyRequestIDLst.clear();
            return;
        }
        AsnDCSetOrGetPolicyInfo oAsnSetOrGetPolicy = oAsnDCSetOrGetPolicyInfoRsp.oAsnDCSetOrGetPolicyInfo;
        PolicyInfo oPolicyInfo = PolicyUtil.decode2PolicyInfo(oAsnSetOrGetPolicy);
        this.removeDevsFromOtherPolicy(oPolicyInfo, isThisClientRequest);
        int iPolicyID = oPolicyInfo.getPolicyID();
        THashMap<Integer, DevicePolicyState> oDevPolicyStateHm = oPolicyInfo.getDevicePolicyStateHm();
        PolicyInfo oCuInfo = this.getPolicyInfo(iPolicyID);
        DCDebugTracer.trace("move device to policy: new DeType size:" + oPolicyInfo.getPolicyDevTypePropLst().size());
        DCDebugTracer.trace("move device to policy: old DeType size:" + oCuInfo.getPolicyDevTypePropLst().size());
        oCuInfo.setPolicyDevTypePropLst(oPolicyInfo.getPolicyDevTypePropLst());
        ArrayList<Integer> oDevIDLst = new ArrayList<Integer>();
        Set oDevSet = oDevPolicyStateHm.entrySet();
        Map.Entry element2 = null;
        for (Map.Entry element2 : oDevSet) {
            oCuInfo.addDevice((DevicePolicyState)element2.getValue());
            oDevIDLst.add((Integer)element2.getKey());
        }
        DCDebugTracer.trace("move device to policy " + oCuInfo.getPolicyName());
        this.notifyEvent(4, oCuInfo, isThisClientRequest, true);
        PolicyMgmtPanel oPolicyMgrPanel = DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel();
        if (null != oPolicyMgrPanel && null != (oTablePanel = oPolicyMgrPanel.getPolicyTablePanel())) {
            oTablePanel.setMoveDeviceIDList(oDevIDLst);
        }
        this.refreshCursorStatus(iRequestID);
    }

    private void handleMxuPolicyChange(MSGPacketExt oMsgPacket) {
        AsnDCMxuUpgradePolicyInfoResp oAsnRsp = new AsnDCMxuUpgradePolicyInfoResp();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::policy failed to decode mxu policy change notify");
            return;
        }
        AsnDCMxuUpgradePolicyInfoLst oAsnMxuPolicyLst = oAsnRsp.oUpgradeInfoLst;
        if (null == oAsnMxuPolicyLst || oAsnMxuPolicyLst.size() == 0) {
            return;
        }
        MxuPolicyInfo oMxuPolicy = null;
        AsnDCMxuUpgradePolicyInfo oAsn = null;
        MXUPolicyDlg oMXUPolicyDlg = DCFrameWorkUtil.getMXUPolicyDlg();
        for (int i = 0; i < oAsnMxuPolicyLst.size(); ++i) {
            oAsn = (AsnDCMxuUpgradePolicyInfo)oAsnMxuPolicyLst.get(i);
            oMxuPolicy = PolicyUtil.decodeMxuUpgradePolicyInfo(oAsn);
            if (null == oMxuPolicy) continue;
            this.updateMxuPolicyInfo(oMxuPolicy);
            if (null == oMXUPolicyDlg) continue;
            oMXUPolicyDlg.modifyPolicy(oMxuPolicy);
        }
        if (null != oMXUPolicyDlg) {
            oMXUPolicyDlg.updateTabel();
        }
    }

    private void handleTimerBackupResult(MSGPacketExt oMsgPacket) {
        PolicyTablePanel oTablePanel;
        AsnDCMultiDeviceErr oAsnRsp = new AsnDCMultiDeviceErr();
        int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnRsp, oMsgPacket.getData());
        if (iErrorcode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, DCFrameWorkUtil.getLocalizedString("ERROR_MESSAGE_TITLE"), 0);
            DCDebugTracer.trace("DC::policy failed to decode timer backup result notify");
            return;
        }
        int iDevID = oAsnRsp.iDeviceId.intValue();
        int iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        byte[] oErrorMsg = oAsnRsp.oErrorInfo.strResult;
        String sErrorMsg = null != oErrorMsg ? new String(oErrorMsg) : "";
        DCDebugTracer.trace("iDevID=" + iDevID + " iErrorCode=" + iErrorcode + " errorMsg=" + sErrorMsg);
        PolicyProgressInfo oProgress = new PolicyProgressInfo(1, iErrorCode, sErrorMsg);
        PolicyInfo oPolicy = this.getPolicyInfoByDevID(iDevID);
        oPolicy.setDeviceProgress(iDevID, oProgress);
        PolicyMgmtPanel oPolicyMgrPanel = DCFrameWorkUtil.getDCModuleManager().getPolicyMgmtPanel();
        if (null != oPolicyMgrPanel && null != (oTablePanel = oPolicyMgrPanel.getPolicyTablePanel())) {
            oTablePanel.refreshDevProgress(iDevID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevicePolicyStatus(int iPolicyID, THashMap<Integer, DevicePolicyState> oSourceDevStateHm) {
        if (null == this.oCurPolicyInfoLst || this.oCurPolicyInfoLst.isEmpty() || null == oSourceDevStateHm || oSourceDevStateHm.isEmpty()) {
            return;
        }
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oPolicy : this.oCurPolicyInfoLst) {
                if (null == oPolicy || oPolicy.getPolicyID() != iPolicyID) continue;
                oPolicy.setDevicePolicyStateHm(oSourceDevStateHm);
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void removeDevsFromOtherPolicy(PolicyInfo oPolicyInfo, boolean isThisClientRequest) {
        if (null == oPolicyInfo) {
            DCDebugTracer.trace("PolicyManager::removeDevsFromOtherPolicy::oPolicyInfo == null");
            return;
        }
        int iSourcePolicyID = oPolicyInfo.getPolicyID();
        THashMap<Integer, DevicePolicyState> oDevHm = oPolicyInfo.getDevicePolicyStateHm();
        if (null == oDevHm || oDevHm.size() == 0) {
            this.notifyEvent(1, oPolicyInfo, isThisClientRequest, true);
            this.removePolicy(oPolicyInfo);
            return;
        }
        Set oDevSet = oDevHm.entrySet();
        PolicyInfo oDestPolicy = null;
        Iterator oDevItor = oDevSet.iterator();
        while (oDevItor.hasNext()) {
            THashMap<Integer, DevicePolicyState> oDestDevHm;
            int iDevID = ((DevicePolicyState)((Map.Entry)oDevItor.next()).getValue()).getDevID();
            oDestPolicy = this.getPolicyInfoByDevID(iDevID);
            if (null != oDestPolicy && oDestPolicy.getPolicyID() != iSourcePolicyID) {
                oDestPolicy.removeDevice(iDevID);
                if (0 < oDestPolicy.getEmptySubnetVec().size()) {
                    this.notifyEvent(7, oDestPolicy, isThisClientRequest, false);
                }
            }
            if (null != (oDestDevHm = oDestPolicy.getDevicePolicyStateHm()) && oDestDevHm.size() != 0) continue;
            this.notifyEvent(1, oDestPolicy, isThisClientRequest, false);
            this.removePolicy(oDestPolicy);
        }
    }

    private void moveDevice(PolicyInfo oSourcePolicyInfo, PolicyInfo oDestPolicyInfo) {
        if (null == oSourcePolicyInfo || null == oDestPolicyInfo) {
            return;
        }
        int iDeletePolicyID = oSourcePolicyInfo.getPolicyID();
        PolicyInfo oSourcePolicy = this.getPolicyInfo(iDeletePolicyID);
        THashMap<Integer, DevicePolicyState> oSourceDevHm = oSourcePolicy.getDevicePolicyStateHm();
        if (null == oSourceDevHm || oSourceDevHm.size() == 0) {
            return;
        }
        Set oDevSet = oSourceDevHm.entrySet();
        Map.Entry element2 = null;
        for (Map.Entry element2 : oDevSet) {
            oDestPolicyInfo.addDevice((DevicePolicyState)element2.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePolicy(PolicyInfo oPolicy) {
        if (null == oPolicy || oPolicy.getPolicyID() == 0) {
            return;
        }
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            PolicyInfo oDestPolicy = null;
            Iterator<PolicyInfo> oPolicyItor = this.oCurPolicyInfoLst.iterator();
            while (oPolicyItor.hasNext()) {
                oDestPolicy = oPolicyItor.next();
                if (null == oDestPolicy || oDestPolicy.getPolicyID() != oPolicy.getPolicyID()) continue;
                oDestPolicy.clearObject();
                oPolicyItor.remove();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getPolicyInfoFromServer(int reqId) {
        int iReqId = reqId;
        AsnDCReq oAsnReq = new AsnDCReq();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        int iErrorCode = this.sendRequestToServer(iReqId, 43976, (FStruct)oAsnReq);
        return iErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PolicyDevTypeProperties> getDeVTypeProList(int iPolicyID) {
        if (null == this.oCurPolicyInfoLst || this.oCurPolicyInfoLst.isEmpty()) {
            return null;
        }
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oPolicyInfo : this.oCurPolicyInfoLst) {
                if (oPolicyInfo.getPolicyID() != iPolicyID) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return oPolicyInfo.getPolicyDevTypePropLst();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void createOrModifyPolicy(int iCmdType, PolicyInfo oPolicyInfo) {
        int iCmdCode = 43827;
        if (iCmdType == 0) {
            iCmdCode = 43815;
            oPolicyInfo.setPolicyID(-1);
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        AsnDCSetOrGetPolicyInfoReq oAsnReq = new AsnDCSetOrGetPolicyInfoReq();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnReq.oAsnDCSetOrGetPolicyInfo = PolicyUtil.encodeAsnDCSetOrGetPolicyInfo(oPolicyInfo);
        this.sendRequestToServer(iReqId, iCmdCode, (FStruct)oAsnReq);
    }

    public void deletePolicy(TIntArrayList oPolicyIDLst) {
        AsnDCSyncReq oAsnReq = new AsnDCSyncReq();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        for (int i = 0; i < oPolicyIDLst.size(); ++i) {
            oAsnReq.oDevIDLst.add((Object)BigInteger.valueOf(oPolicyIDLst.get(i)));
        }
        this.sendRequestToServer(iReqId, 43987, (FStruct)oAsnReq);
    }

    public void setDevicePolicyStatus(AsnDCDevicePolicyStateLst oAsnDevLst) {
        AsnDCDevicePolicyStateLstReq oAsnReq = new AsnDCDevicePolicyStateLstReq();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnReq.oDevPolicyStateLst.addAll((Collection)oAsnDevLst);
        this.sendRequestToServer(iReqId, 43985, (FStruct)oAsnReq);
    }

    public void moveDeviceToPolicy(THashMap<Integer, DevicePolicyState> m_oDevHm, PolicyInfo oDestPolicy) {
        AsnDCSetOrGetPolicyInfoReq oAsnReq = new AsnDCSetOrGetPolicyInfoReq();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        AsnDCSetOrGetPolicyInfo oAsnDCSetOrGetPolicyInfo = oAsnReq.oAsnDCSetOrGetPolicyInfo;
        AsnDCPolicyInfo oAsnDCPolicyInfo = new AsnDCPolicyInfo();
        oAsnDCPolicyInfo.iPolicyID = new BigInteger("" + oDestPolicy.getPolicyID());
        AsnDCPolicytypeInfo oAsnDCPolicytypeInfo = new AsnDCPolicytypeInfo();
        oAsnDCPolicytypeInfo.enAsnDCPolicyTypeEnum = new AsnDCPolicyTypeEnum(0);
        oAsnDCPolicytypeInfo.enpPolicyStatus = new AsnDCPolicyStateEnum(0);
        oAsnDCPolicytypeInfo.oPolicyPeriod = new AsnDCPolicyPeriodEnum(2);
        oAsnDCPolicytypeInfo.strPolicyTime = "11:00".getBytes();
        oAsnDCPolicyInfo.oAsnDCPolicytypeInfoLst.addElement((Object)oAsnDCPolicytypeInfo);
        oAsnDCSetOrGetPolicyInfo.oAsnDCPolicyInfo = oAsnDCPolicyInfo;
        AsnDCDevicePolicyStateLst oAsnDCDevLst = new AsnDCDevicePolicyStateLst();
        AsnDCDevicePolicyState oAsnDev = null;
        DevicePolicyState oDev = null;
        Set oDevSet = m_oDevHm.entrySet();
        Iterator oDevItor = oDevSet.iterator();
        Map.Entry element = null;
        while (oDevItor.hasNext()) {
            element = (Map.Entry)oDevItor.next();
            oDev = (DevicePolicyState)element.getValue();
            oAsnDev = new AsnDCDevicePolicyState();
            oAsnDev.iDevID = BigInteger.valueOf(oDev.getDevID());
            oAsnDev.strDevName = oDev.getNEName().getBytes();
            oAsnDev.strDevIPAddress = oDev.getIPAdress().getBytes();
            oAsnDev.strDevTypeName = oDev.getNETypeName().getBytes();
            oAsnDev.iDevTypeId = BigInteger.valueOf(oDev.getDevTypeID());
            oAsnDev.iDevTypeVersionId = BigInteger.valueOf(oDev.getDevTypeVerID());
            oAsnDCDevLst.add((Object)oAsnDev);
        }
        oAsnDCSetOrGetPolicyInfo.iDevicePolicyStateLst = oAsnDCDevLst;
        this.sendRequestToServer(iReqId, 43828, (FStruct)oAsnReq);
    }

    public void registerPolicyChangeListener(Object oListener) {
        if (null != oListener && !this.m_oPolicyChangeListenerLst.contains(oListener)) {
            this.m_oPolicyChangeListenerLst.remove(oListener);
            this.m_oPolicyChangeListenerLst.add(oListener);
        }
    }

    public void unRegisterPolicyChangeListener(Object oListener) {
        if (null != oListener && this.m_oPolicyChangeListenerLst.contains(oListener)) {
            this.m_oPolicyChangeListenerLst.remove(oListener);
        }
    }

    private void notifyEvent(int iEventType, Object oEventObj, boolean isThisClientRequest, boolean isNeedRefresh) {
        Iterator<Object> oListItor = this.m_oPolicyChangeListenerLst.iterator();
        IPolicyChangeListener oListener = null;
        PolicyEventObject oPolicyEvent = new PolicyEventObject(oEventObj);
        oPolicyEvent.setEventType(iEventType);
        oPolicyEvent.setThisClientRequest(isThisClientRequest);
        oPolicyEvent.setNeedRefresh(isNeedRefresh);
        Class[] methodSignal = new Class[]{PolicyEventObject.class};
        while (oListItor.hasNext()) {
            oListener = (IPolicyChangeListener)oListItor.next();
            MethodUtil.excMethodNoException(oListener, methodSignal, "handleDeviceConfigNotification", oPolicyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyInfo getPolicyInfo(int iPolicyID) {
        DCDebugTracer.trace("Mark::PolidyManager::getPolicyInfo::begin");
        if (null == this.oCurPolicyInfoLst) {
            return null;
        }
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oPolicy : this.oCurPolicyInfoLst) {
                if (null == oPolicy || oPolicy.getPolicyID() != iPolicyID) continue;
                DCDebugTracer.trace("Mark::PolidyManager::getPolicyInfo::end");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return oPolicy;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            DCDebugTracer.trace("Mark::PolidyManager::getPolicyInfo::end");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyInfo getPolicyInfoByDevID(int iDevID) {
        if (null == this.oCurPolicyInfoLst || this.oCurPolicyInfoLst.isEmpty()) {
            return null;
        }
        THashMap<Integer, DevicePolicyState> oDevHm = null;
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oPolicy : this.oCurPolicyInfoLst) {
                oDevHm = oPolicy.getDevicePolicyStateHm();
                if (null == oDevHm || oDevHm.isEmpty() || !oDevHm.containsKey((Object)iDevID)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return oPolicy;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevicePolicyState getDevicePolicyState(int iDevID) {
        if (null == this.oCurPolicyInfoLst || this.oCurPolicyInfoLst.isEmpty()) {
            return null;
        }
        THashMap<Integer, DevicePolicyState> oDevHm = null;
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oPolicy : this.oCurPolicyInfoLst) {
                oDevHm = oPolicy.getDevicePolicyStateHm();
                if (null == oDevHm || oDevHm.size() == 0) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (DevicePolicyState)oDevHm.get((Object)iDevID);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyPolicy(PolicyInfo oPolicyInfo) {
        if (null == oPolicyInfo || null == this.oCurPolicyInfoLst || this.oCurPolicyInfoLst.isEmpty()) {
            return;
        }
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            for (PolicyInfo oDestPolicy : this.oCurPolicyInfoLst) {
                if (null == oDestPolicy || oDestPolicy.getPolicyID() != oPolicyInfo.getPolicyID()) continue;
                oDestPolicy.setPolicyName(oPolicyInfo.getPolicyName());
                oDestPolicy.setPolicyTypeInfoLst(oPolicyInfo.getPolicyTypeInfoLst());
                oDestPolicy.setPolicyDevTypePropLst(oPolicyInfo.getPolicyDevTypePropLst());
                if (null == oPolicyInfo.getDevicePolicyStateHm()) break;
                THashMap<Integer, DevicePolicyState> mapDevice = oPolicyInfo.getDevicePolicyStateHm();
                THashMap maptmpDevice = new THashMap();
                Set oDevSet = mapDevice.keySet();
                Iterator oDevItor = oDevSet.iterator();
                DevicePolicyState oDevicePolicyState = null;
                while (oDevItor.hasNext()) {
                    Integer oDevID = (Integer)oDevItor.next();
                    DeviceInfo tmpDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oDevID);
                    if (null == tmpDeviceInfo) continue;
                    oDevicePolicyState = (DevicePolicyState)mapDevice.get((Object)oDevID);
                    maptmpDevice.put((Object)oDevID, (Object)oDevicePolicyState);
                }
                oDestPolicy.setDevicePolicyStateHm((THashMap<Integer, DevicePolicyState>)maptmpDevice);
                if (null == oDevicePolicyState) break;
                DCDebugTracer.trace("oDevicePolicyState : " + oDevicePolicyState.getShowProgressInfo());
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PolicyInfo> getPolicyInfoLst() {
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.oCurPolicyInfoLst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPolicyCount() {
        byte[] byArray = this.syncPolicy;
        synchronized (this.syncPolicy) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.oCurPolicyInfoLst.size();
        }
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        switch (iEventType) {
            case 0: {
                this.handleDeviceAdd(oDeviceInfoList);
                break;
            }
            case 1: {
                this.handleDeviceDelete(oDeviceInfoList);
                break;
            }
            case 2: {
                this.handleDeviceModify(oDeviceInfoList);
                break;
            }
        }
    }

    private void handleDeviceAdd(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || oDeviceInfoList.size() == 0) {
            return;
        }
        int iDevCount = oDeviceInfoList.size();
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        DeviceInfo deviceInfo = null;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        PolicyInfo oPolicyInfo = this.getPolicyInfo(0);
        if (null == oPolicyInfo) {
            DCDebugTracer.trace("can not find default policy");
            return;
        }
        ArrayList<Integer> oChangeDevIDLst = new ArrayList<Integer>();
        for (int i = 0; i < iDevCount; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            deviceInfo = oDevMgr.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            boolean bSucess = oPolicyInfo.addDevice(deviceInfo);
            if (!bSucess) continue;
            oChangeDevIDLst.clear();
            oChangeDevIDLst.add(deviceInfo.getDevId());
            oPolicyInfo.setChangedDevIdLst(oChangeDevIDLst);
            oPolicyInfo.setIsDevChange(true);
            this.notifyEvent(2, oPolicyInfo, false, true);
        }
    }

    private void handleDeviceDelete(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || oDeviceInfoList.size() == 0) {
            return;
        }
        int iDevCount = oDeviceInfoList.size();
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        DeviceInfo deviceInfo = null;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        int iDevID = -1;
        PolicyInfo oPolicyInfo = null;
        ArrayList<Integer> oChangeDevIDLst = new ArrayList<Integer>();
        for (int i = 0; i < iDevCount; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            deviceInfo = oDevMgr.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            iDevID = deviceInfo.getDevId();
            oPolicyInfo = this.getPolicyInfoByDevID(iDevID);
            if (null == oPolicyInfo) continue;
            oChangeDevIDLst.clear();
            oChangeDevIDLst.add(iDevID);
            oPolicyInfo.setChangedDevIdLst(oChangeDevIDLst);
            oPolicyInfo.setIsDevChange(true);
            this.notifyEvent(5, oPolicyInfo, false, true);
            oPolicyInfo.removeDevice(iDevID);
            THashMap<Integer, DevicePolicyState> oDevHm = oPolicyInfo.getDevicePolicyStateHm();
            if (null != oDevHm && oDevHm.size() != 0) continue;
            this.removePolicy(oPolicyInfo);
            this.notifyEvent(1, oPolicyInfo, false, true);
        }
    }

    private void handleDeviceModify(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDevCount = oDeviceInfoList.size();
        AsnDCDeviceInfo oAsnDCDeviceInfo = null;
        int iDevID = 0;
        PolicyInfo oPolicy = null;
        ArrayList<Integer> iChangeDevIDLst = new ArrayList<Integer>();
        for (int i = 0; i < iDevCount; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            oAsnDCDeviceInfo = oAsnDeviceInfo.oDeviceInfo;
            iDevID = oAsnDCDeviceInfo.iDevId.intValue();
            oPolicy = this.getPolicyInfoByDevID(iDevID);
            if (null == oPolicy) continue;
            iChangeDevIDLst.clear();
            iChangeDevIDLst.add(iDevID);
            oPolicy.setChangedDevIdLst(iChangeDevIDLst);
            DeviceInfoUtil.updateDeviceInfo(oPolicy, oAsnDCDeviceInfo);
            oPolicy.setIsDevChange(true);
            this.notifyEvent(2, oPolicy, false, true);
        }
    }

    private THashMap<Integer, DevicePolicyState> getDeletedDevInfoHm(PolicyInfo oOldPolicyInfo, PolicyInfo oNewPolicyInfo) {
        THashMap oRtnDevHm = new THashMap();
        THashMap<Integer, DevicePolicyState> oOldDevHm = oOldPolicyInfo.getDevicePolicyStateHm();
        THashMap<Integer, DevicePolicyState> oNewDevHm = oNewPolicyInfo.getDevicePolicyStateHm();
        if (null != oOldDevHm && null != oNewDevHm) {
            Set oOldDevSet = oOldDevHm.entrySet();
            Iterator oOldDevItor = oOldDevSet.iterator();
            Map.Entry element = null;
            int iDevID = -1;
            while (oOldDevItor.hasNext()) {
                element = (Map.Entry)oOldDevItor.next();
                iDevID = (Integer)element.getKey();
                if (null == oNewDevHm || oNewDevHm.containsKey((Object)iDevID)) continue;
                oRtnDevHm.put((Object)iDevID, element.getValue());
            }
        }
        return oRtnDevHm;
    }

    private void refreshCursorStatus(int iRequestID) {
        DCDebugTracer.trace("[POLICY] update mouse status start! requestID=" + iRequestID);
        this.closeProgressDlg(iRequestID);
        if (null == this.m_oBusyRequestIDLst || this.m_oBusyRequestIDLst.size() == 0) {
            DCDebugTracer.trace("[POLICY]PolicyManager#refreshCursorStatus:----->null == m_oBusyRequestIDLst || m_oBusyRequestIDLst.size() == 0");
            DCFrameWorkUtil.defaultCursor();
            return;
        }
        for (int i = 0; i < this.m_oBusyRequestIDLst.size(); ++i) {
            if (iRequestID != this.m_oBusyRequestIDLst.get(i)) continue;
            this.m_oBusyRequestIDLst.remove(i);
        }
        if (null == this.m_oBusyRequestIDLst || this.m_oBusyRequestIDLst.size() == 0) {
            DCFrameWorkUtil.defaultCursor();
        }
        DCDebugTracer.trace("[POLICY] update mouse status end!");
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
        if (null == m_oPolicyMgr) {
            return;
        }
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        if (null != this.oCurPolicyInfoLst) {
            this.oCurPolicyInfoLst.clear();
            this.oCurPolicyInfoLst = null;
        }
        if (null != this.m_oPolicyChangeListenerLst) {
            this.m_oPolicyChangeListenerLst.clear();
            this.m_oPolicyChangeListenerLst = null;
        }
        if (null != this.m_oBusyRequestIDLst) {
            this.m_oBusyRequestIDLst.clear();
            this.m_oBusyRequestIDLst = null;
        }
        m_oPolicyMgr = null;
    }

    public List<MxuPolicyInfo> generateAllMxuPolicyLst() {
        ArrayList<MxuPolicyInfo> oRtnPolicyLst = new ArrayList<MxuPolicyInfo>();
        return oRtnPolicyLst;
    }

    public MxuPolicyInfo getConfigMxuPolicyInfo(String sSubmapID, int iDevTypeID, int iDevTypeVerID) {
        return null;
    }

    public void updateMxuPolicyInfo(MxuPolicyInfo oMxuPolicyInfo) {
    }

    public boolean setMxuInfoToServer(List<MxuPolicyInfo> oMxuPolicyInfoLst) {
        return true;
    }

    private boolean isThisRequest(int iRequestID) {
        return this.m_oBusyRequestIDLst.contains(iRequestID);
    }
}

