/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.policy.controller;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.policy.model.ConfigChangePolicyInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BooleanColumnRederer
extends DefaultTableCellRenderer {
    private static final String STR_FALSE = ResourceManager.getInstance().getResString("FALSE");
    private static final String STR_TRUE = ResourceManager.getInstance().getResString("TRUE");
    private static final String POLICY_OCNFIG_TIME_HOUR = ResourceManager.getInstance().getResString("POLICY_OCNFIG_TIME_HOUR");
    private static final String POLICY_OCNFIG_TIME_MINUT = ResourceManager.getInstance().getResString("POLICY_OCNFIG_TIME_MINUT");
    private static final String POLICY_STATUS_RUN = ResourceManager.getInstance().getResString("POLICY_STATUS_RUN");
    private static final String POLICY_STATUS_STOP = ResourceManager.getInstance().getResString("POLICY_STATUS_STOP");
    private static final long serialVersionUID = 6367192243575000086L;
    private static final String TRUE = ResourceManager.getInstance().getResString("TRUE");
    private boolean m_bShowAsCheckBox = true;
    ResourceManager m_oRes = ResourceManager.getInstance();

    public BooleanColumnRederer() {
    }

    public BooleanColumnRederer(boolean ShowAsCheckBox) {
        this.m_bShowAsCheckBox = ShowAsCheckBox;
        if (!this.m_bShowAsCheckBox) {
            this.setHorizontalAlignment(4);
        }
    }

    private String generateTimerBackupInfo(ConfigChangePolicyInfo oConfig) {
        if (null == oConfig) {
            return "";
        }
        int iStatus = oConfig.getBackupPolicyStatus();
        String sStatus = iStatus == 0 ? POLICY_STATUS_RUN : POLICY_STATUS_STOP;
        int iConfigPerid = oConfig.getSpecificBackupPeriod();
        String sConfigPeriod = "";
        String sConfigValue = oConfig.getSpecificBackupPolicyTime();
        sConfigPeriod = iConfigPerid == 0 ? POLICY_OCNFIG_TIME_HOUR : POLICY_OCNFIG_TIME_MINUT;
        int iNotConfigPeriod = oConfig.getSpecificStaticBackupPeriod();
        String sNotConfigPeriod = "";
        String sNotConfigValue = oConfig.getSpecificStaticBackupPolicyTime();
        sNotConfigPeriod = iNotConfigPeriod == 0 ? POLICY_OCNFIG_TIME_HOUR : POLICY_OCNFIG_TIME_MINUT;
        StringBuffer oStringBuf = new StringBuffer();
        oStringBuf.append(sStatus).append(",").append(sConfigValue).append(sConfigPeriod).append(",").append(sNotConfigValue).append(sNotConfigPeriod);
        return oStringBuf.toString();
    }

    private String getLinkString(String desc, boolean isBule) {
        String strOplink = isBule ? "<html><a href=\"x\">" + desc + "</a>" + "</html>" : "<html><a href=\"x\" color = 'red'>" + desc + "</a>" + "</html>";
        return strOplink;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel oPanel = new JPanel();
        oPanel.setLayout(new GridBagLayout());
        if (isSelected) {
            oPanel.setBackground(table.getSelectionBackground());
        } else {
            oPanel.setBackground(table.getBackground());
        }
        JComponent oComponent = null;
        if (null == value) {
            oComponent = new JLabel("--");
        } else if (value instanceof Boolean) {
            if (this.m_bShowAsCheckBox) {
                oComponent = new JCheckBox();
                ((JCheckBox)oComponent).setSelected((Boolean)value);
            } else {
                boolean bValue = (Boolean)value;
                oComponent = bValue ? new JLabel(STR_TRUE) : new JLabel(STR_FALSE);
            }
        } else if (value instanceof Integer) {
            int iValue = (Integer)value;
            if (iValue == 1 || iValue == 0) {
                oComponent = new JCheckBox();
                ((JCheckBox)oComponent).setSelected(iValue == 0);
            } else {
                oComponent = new JLabel("--");
            }
        } else {
            if (value instanceof ConfigChangePolicyInfo) {
                oComponent = new JPanel();
                JCheckBox oBox = new JCheckBox();
                ConfigChangePolicyInfo oConfig = (ConfigChangePolicyInfo)value;
                boolean bCheckBoxSelected = oConfig.isSelected();
                oBox.setSelected(bCheckBoxSelected);
                String sTextValue = this.generateTimerBackupInfo(oConfig);
                String sHtmlValue = StringUtils.getHtmlString(sTextValue);
                String sLinkTextValue = this.getLinkString(sTextValue, true);
                oComponent.setLayout(new GridBagLayout());
                JLabel oLabel = new JLabel();
                if (bCheckBoxSelected) {
                    oLabel.setText(sLinkTextValue);
                } else {
                    oLabel.setText(sHtmlValue);
                }
                oComponent.setToolTipText(sTextValue);
                int iColumnWidth = table.getColumnModel().getColumn(column).getWidth();
                oLabel.setPreferredSize(new Dimension(iColumnWidth - 15, table.getRowHeight()));
                oLabel.setMinimumSize(new Dimension(iColumnWidth - 15, table.getRowHeight()));
                oComponent.add((Component)oBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                oComponent.add((Component)oLabel, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                oPanel.add((Component)oComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                if (isSelected) {
                    oBox.setBackground(table.getSelectionBackground());
                    oComponent.setBackground(table.getSelectionBackground());
                    oComponent.setForeground(table.getSelectionForeground());
                } else {
                    oBox.setBackground(table.getBackground());
                    oComponent.setBackground(table.getBackground());
                }
                return oPanel;
            }
            oComponent = value instanceof String ? new JLabel(value.toString()) : new JLabel("--");
        }
        if (isSelected) {
            oComponent.setBackground(table.getSelectionBackground());
        } else {
            oComponent.setBackground(table.getBackground());
        }
        int iAlignWay = 10;
        if (!this.m_bShowAsCheckBox) {
            iAlignWay = 17;
        }
        oPanel.add((Component)oComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, iAlignWay, 0, new Insets(0, 0, 0, 0), 0, 0));
        return oPanel;
    }
}

