/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.onlineboard.view;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.adapter.swimap.iview.util.DCXYConstraints;
import com.huawei.dc.adapter.swimap.iview.util.DCXYLayout;
import com.huawei.dc.common.asndatacenter.AsnBoardOperEnum;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLastOperationStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErrLst;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchModel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.onlineboard.controller.OnlineBoardManager;
import com.huawei.dc.onlineboard.model.BoardInfo;
import com.huawei.dc.onlineboard.model.DCFrameInfo;
import com.huawei.dc.onlineboard.model.OnlineBoardInfo;
import com.huawei.dc.onlineboard.model.OnlineBoardUpgradeInfo;
import com.huawei.dc.onlineboard.model.OnlineBoardUtility;
import com.huawei.dc.onlineboard.model.PkgDevInfo;
import com.huawei.dc.onlineboard.model.SubSlotInfo;
import com.huawei.dc.onlineboard.view.DeviceSearchAddDialog;
import com.huawei.dc.onlineboard.view.common.OnlineBoardUpgradePopupMenuManager;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OnlineBoardUpgradeFrame
extends DCModalDialog {
    private static final String ONLINEBOARD_UPGRADE_FRAME = "OnlineBoardUpgradeFrame";
    private DCExtendedTable mOnlineBoardInfoTable;
    private DCExtendedTable mOnlineAccessBoardInfoTable;
    private DCSortableTableModel mOnlineBoardInfoTableModel;
    private DCSortableTableModel mOnlineAccessBoardInfoTableModel;
    private JScrollPane mScrollPane;
    private JScrollPane mAccessScrollPane;
    private JPanel mJPanel;
    private JPanel mAccessJPanel;
    private JPopupMenu mUpgradePopupMenu;
    private String mstrClientLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase();
    private Vector mRowData;
    private JButton mCloseBtn;
    private JButton mAccessCloseBtn;
    private JButton mSearchBtn;
    private OnlineBoardUpgradePopupMenuManager mPopupMenuManager;
    private ArrayList mOnlineBoardInfoLst;
    private static final int ONLINE_BOARD_DEVICE_ID_COLUMN = 0;
    private static final int ONLINE_RES_NAME_COLUMN = 1;
    private static final int ONLINE_BOARD_DEVICE_IP_COLUMN = 2;
    private static final int ONLINE_BOARD_DEVICE_TYPE_COLUMN = 3;
    private static final int ONLINE_BOARD_DEVICE_VERSION_COLUMN = 4;
    private static final int UPGRADE_STATUS_COLUMN = 5;
    private static final int ONLINE_BOARD_Frame_ID_COLUMN = 6;
    private static final int PACKAGE_TYPE_COLUMN_INDEX = 7;
    private static final int ACC_TAB = 1;
    private static final int T2K_TAB = 0;
    private static final Color TASK_STATE_NOT_RUN_COLOR = Color.BLACK;
    private static final Color TASK_STATE_FAILURE_COLOR = new Color(196, 48, 45);
    private static final Color TASK_STATE_SUCCESS_COLOR = new Color(74, 181, 80);
    private JTabbedPane mSettingTabPane = null;
    private Map<BigInteger, AsnDCSyncReq> requestidDevice = new HashMap<BigInteger, AsnDCSyncReq>();
    private boolean mbRetryFlag = false;
    private static final int NOT_RUN_STATUS = 1;
    private static final int NOT_RETRY_STATUS = 1;
    private static final int OTHER_STATUS = 0;

    public OnlineBoardUpgradeFrame(ArrayList oBoardUpgradeInfoLst) {
        super(DCFrameWorkUtil.getMainFrame());
        DataCenterModuleManager DCModuleManager2 = (DataCenterModuleManager)ObjectStore.getInstance().getObjectInstance("DataCenterModule");
        DCModuleManager2.autoMXUUpgradePolicy();
        this.mOnlineBoardInfoLst = oBoardUpgradeInfoLst;
        this.getContentPane().setLayout((LayoutManager)new DCXYLayout());
        super.setLocationRelativeTo((Component)DCFrameWorkUtil.getMainFrame());
        super.setSize(768, 390);
        super.setTitle(ResourceManager.getInstance().getResString("ONLINE_BOARD_UPGRADE"));
        this.setLocation(220, 180);
        super.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setResizable(false);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_ONLINE_BOARD");
        this.jbinit();
        OnlineBoardUpgradeFrame.setOnlineBoardUpgradeFrame(this);
    }

    public static void setOnlineBoardUpgradeFrame(OnlineBoardUpgradeFrame onlineBoardUpgradeFrame) {
        ObjectStore.getInstance().putObjectInstance(ONLINEBOARD_UPGRADE_FRAME, (Object)onlineBoardUpgradeFrame);
    }

    public static OnlineBoardUpgradeFrame getOnlineBoardUpgradeFrame() {
        return (OnlineBoardUpgradeFrame)((Object)ObjectStore.getInstance().getObjectInstance(ONLINEBOARD_UPGRADE_FRAME));
    }

    public synchronized JTable getInfoTable() {
        return this.mOnlineBoardInfoTable;
    }

    public synchronized JTable getAccessInfoTable() {
        return this.mOnlineAccessBoardInfoTable;
    }

    public int getSelectTab() {
        if (this.mSettingTabPane.getTitleAt(this.mSettingTabPane.getSelectedIndex()).trim().equals(ResourceManager.getInstance().getResString("POLICY_ADVANCED_SETTING_TAB_OPTIX").trim())) {
            return 0;
        }
        return 1;
    }

    public JTable getM_oOnlineAccessBoardInfoTable() {
        return this.mOnlineAccessBoardInfoTable;
    }

    public void setM_oOnlineAccessBoardInfoTable(DCExtendedTable m_oOnlineAccessBoardInfoTable) {
        this.mOnlineAccessBoardInfoTable = m_oOnlineAccessBoardInfoTable;
    }

    public DefaultTableModel getM_oOnlineAccessBoardInfoTableModel() {
        return this.mOnlineAccessBoardInfoTableModel;
    }

    public void setM_oOnlineAccessBoardInfoTableModel(DCSortableTableModel m_oOnlineAccessBoardInfoTableModel) {
        this.mOnlineAccessBoardInfoTableModel = m_oOnlineAccessBoardInfoTableModel;
    }

    private void jbinit() {
        boolean bTtrans;
        this.mSettingTabPane = new JTabbedPane();
        this.mSearchBtn = new JButton();
        this.mSearchBtn.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oSearchBtn");
        this.mSearchBtn.setText(ResourceManager.getInstance().getResString("SEARCH_DEVICE_ONLINEBOARD_DIALOG_SEARCH_BUTTON"));
        this.mSearchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineBoardUpgradeFrame.this.openSearchDialog();
            }
        });
        this.mAccessCloseBtn = new JButton();
        this.mAccessCloseBtn.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oAccessCloseBtn");
        this.mAccessCloseBtn.setText(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.mAccessCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineBoardUpgradeFrame.this.closeButtonActionPerformed();
            }
        });
        this.mCloseBtn = new JButton();
        this.mCloseBtn.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oCloseBtn");
        this.mCloseBtn.setText(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.mCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineBoardUpgradeFrame.this.closeButtonActionPerformed();
            }
        });
        this.setColumnsToTable();
        if (null != this.mOnlineBoardInfoLst) {
            DCDebugTracer.trace("DC::OnlineBoardUpgradeFrame::begin to addRow");
            this.addRow();
        }
        this.loadPopupMenu();
        this.addMouseListenerToTable();
        if (this.mOnlineBoardInfoTable.getRowCount() > 0) {
            this.mOnlineBoardInfoTable.setRowSelectionInterval(0, 0);
        }
        if (this.mOnlineAccessBoardInfoTable.getRowCount() > 0) {
            this.mOnlineAccessBoardInfoTable.setRowSelectionInterval(0, 0);
        }
        this.mScrollPane = new JScrollPane();
        this.mScrollPane.getViewport().add((Component)this.mOnlineBoardInfoTable);
        this.mJPanel = new JPanel();
        this.mJPanel.setLayout((LayoutManager)new DCXYLayout());
        this.mJPanel.add((Component)this.mScrollPane, new DCXYConstraints(5, 5, 740, 260));
        this.mJPanel.add((Component)this.mCloseBtn, new DCXYConstraints(650, 272, 80, 21));
        this.mAccessScrollPane = new JScrollPane();
        this.mAccessScrollPane.getViewport().add((Component)this.mOnlineAccessBoardInfoTable);
        this.mAccessJPanel = new JPanel();
        this.mAccessJPanel.setLayout((LayoutManager)new DCXYLayout());
        this.mAccessJPanel.add((Component)this.mAccessScrollPane, new DCXYConstraints(5, 5, 740, 260));
        this.mAccessJPanel.add((Component)this.mSearchBtn, new DCXYConstraints(560, 272, 80, 21));
        this.mAccessJPanel.add((Component)this.mAccessCloseBtn, new DCXYConstraints(650, 272, 80, 21));
        int iServerDeployDomian = DCFrameWorkUtil.getServerDeployDomain();
        boolean bAccess = (iServerDeployDomian & 1) != 0;
        boolean bl = bTtrans = (iServerDeployDomian & 4) != 0;
        if (bTtrans) {
            this.mSettingTabPane.add(ResourceManager.getInstance().getResString("POLICY_ADVANCED_SETTING_TAB_OPTIX"), this.mJPanel);
        }
        if (bAccess) {
            this.mSettingTabPane.add(ResourceManager.getInstance().getResString("POLICY_ADVANCED_SETTING_TAB_ACCESS"), this.mAccessJPanel);
        }
        this.getContentPane().add((Component)this.mSettingTabPane, new DCXYConstraints(12, 12, 740, 345));
        this.escKeyHandler();
    }

    public void setBoardList(ArrayList oOnlineBoardInfoLst) {
        this.mOnlineBoardInfoLst = oOnlineBoardInfoLst;
        this.mOnlineBoardInfoTableModel.getDataVector().clear();
        this.addRow();
        this.updateFrame();
    }

    private void loadPopupMenu() {
        try {
            this.mPopupMenuManager = new OnlineBoardUpgradePopupMenuManager(this);
            this.mUpgradePopupMenu = this.mPopupMenuManager.load();
            this.mUpgradePopupMenu.setDoubleBuffered(false);
            this.mUpgradePopupMenu.setInvoker((Component)this.mOnlineBoardInfoTable);
            this.mUpgradePopupMenu.setInvoker((Component)this.mOnlineAccessBoardInfoTable);
        }
        catch (Exception oException) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("GETRESOURCE_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private void enableUpgradeMenuItem() {
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Upgrade");
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        int[] iArrSelectedRows = this.mOnlineBoardInfoTable.getSelectedRows();
        boolean bEnableUpgrade = true;
        if (null == iArrSelectedRows || 0 == iArrSelectedRows.length) {
            bEnableUpgrade = false;
        } else {
            HashSet<String> oDevIdSet = new HashSet<String>(1);
            String strCurDevId = null;
            String strOperationStatus = null;
            for (int i = 0; i < iArrSelectedRows.length; ++i) {
                strCurDevId = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[i], 0).toString();
                if (null == strCurDevId) {
                    bEnableUpgrade = false;
                    break;
                }
                oDevIdSet.add(strCurDevId);
                strOperationStatus = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[0], 5).toString();
                if (null != strOperationStatus && strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("ONLINE_BOARD_NOT_RUN"))) continue;
                bEnableUpgrade = false;
                break;
            }
        }
        oMenuItem.setEnabled(bEnableUpgrade);
    }

    private void enableAccessUpgradeMenuItem() {
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Upgrade");
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        int[] iArrSelectedRows = this.mOnlineAccessBoardInfoTable.getSelectedRows();
        boolean bEnableUpgrade = true;
        if (null == iArrSelectedRows || 0 == iArrSelectedRows.length) {
            bEnableUpgrade = false;
        } else {
            HashMap<String, Integer> oDevIdMap = new HashMap<String, Integer>();
            String strCurDevId = null;
            String strOperationStatus = null;
            for (int i = 0; i < iArrSelectedRows.length; ++i) {
                strCurDevId = this.mOnlineAccessBoardInfoTable.getValueAt(iArrSelectedRows[i], 0).toString();
                if (null == strCurDevId || oDevIdMap.containsKey(strCurDevId)) {
                    bEnableUpgrade = false;
                    break;
                }
                strOperationStatus = this.mOnlineAccessBoardInfoTable.getValueAt(iArrSelectedRows[i], 5).toString();
                if (null == strOperationStatus || strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("ONLINE_BOARD_NOT_RUN"))) {
                    oDevIdMap.put(strCurDevId, 1);
                    continue;
                }
                oDevIdMap.put(strCurDevId, 0);
            }
            for (Map.Entry entry : oDevIdMap.entrySet()) {
                Object val = entry.getValue();
                if (!(val instanceof Integer) || (Integer)val != 0) continue;
                bEnableUpgrade = false;
                break;
            }
        }
        oMenuItem.setEnabled(bEnableUpgrade);
    }

    private void enableRetryMenuItem() {
        int[] iArrSelectedRows = this.mOnlineBoardInfoTable.getSelectedRows();
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Retry");
        if (null == oMenuItem) {
            return;
        }
        boolean bEnableRetry = true;
        if (null == iArrSelectedRows || 0 == iArrSelectedRows.length) {
            bEnableRetry = false;
        } else {
            HashMap<String, Integer> oDevIdMap = new HashMap<String, Integer>();
            String strCurDevId = null;
            String strOperationStatus = null;
            for (int i = 0; i < iArrSelectedRows.length; ++i) {
                strCurDevId = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[i], 0).toString();
                if (null == strCurDevId || oDevIdMap.containsKey(strCurDevId)) {
                    bEnableRetry = false;
                    break;
                }
                strOperationStatus = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[0], 5).toString();
                if (null == strOperationStatus || strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("ONLINE_BOARD_UPGRADE_FAILED"))) {
                    oDevIdMap.put(strCurDevId, 1);
                    continue;
                }
                oDevIdMap.put(strCurDevId, 0);
            }
            for (Map.Entry entry : oDevIdMap.entrySet()) {
                Object val = entry.getValue();
                if (!(val instanceof Integer) || (Integer)val != 0) continue;
                bEnableRetry = false;
                break;
            }
        }
        oMenuItem.setEnabled(bEnableRetry);
    }

    private void enableAccessRetryMenuItem() {
        int[] iArrSelectedRows = this.mOnlineAccessBoardInfoTable.getSelectedRows();
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Retry");
        if (null == oMenuItem) {
            return;
        }
        boolean bEnableRetry = true;
        if (null == iArrSelectedRows || 0 == iArrSelectedRows.length) {
            bEnableRetry = false;
        } else {
            HashSet<String> oDevIdSet = new HashSet<String>(1);
            String strCurDevId = null;
            String strOperationStatus = null;
            for (int i = 0; i < iArrSelectedRows.length; ++i) {
                strCurDevId = this.mOnlineAccessBoardInfoTable.getValueAt(iArrSelectedRows[i], 0).toString();
                if (null == strCurDevId || oDevIdSet.contains(strCurDevId)) {
                    bEnableRetry = false;
                    break;
                }
                oDevIdSet.add(strCurDevId);
                strOperationStatus = this.mOnlineAccessBoardInfoTable.getValueAt(iArrSelectedRows[0], 5).toString();
                if (null != strOperationStatus && !strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("ONLINE_BOARD_NOT_RUN")) && !strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("TASK_STATUS_RUNNING")) && !strOperationStatus.equalsIgnoreCase(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L)))) continue;
                bEnableRetry = false;
                break;
            }
        }
        oMenuItem.setEnabled(bEnableRetry);
    }

    private void enableRemoveMenuItem() {
        int[] iArrSelectedRows = this.mOnlineBoardInfoTable.getSelectedRows();
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Remove");
        boolean bEnableRemove = true;
        if (null == iArrSelectedRows || 0 == iArrSelectedRows.length) {
            bEnableRemove = false;
        } else {
            HashSet<String> oDevIdSet = new HashSet<String>(1);
            String strCurDevId = null;
            String strOperationStatus = null;
            for (int i = 0; i < iArrSelectedRows.length; ++i) {
                strCurDevId = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[i], 0).toString();
                oDevIdSet.add(strCurDevId);
                strOperationStatus = this.mOnlineBoardInfoTable.getValueAt(iArrSelectedRows[0], 5).toString();
                if (null != strOperationStatus && !strOperationStatus.equalsIgnoreCase(oResourceMgr.getResString("TASK_STATUS_RUNNING"))) continue;
                bEnableRemove = false;
                break;
            }
        }
        oMenuItem.setEnabled(bEnableRemove);
    }

    private void enableAccessRemoveMenuItem() {
        JMenuItem oMenuItem = this.mPopupMenuManager.getMenuItemForID("Remove");
        oMenuItem.setEnabled(false);
    }

    private void addMouseListenerToTable() {
        this.mOnlineBoardInfoTable.addMouseListener((MouseListener)this.getMouseAdaptor());
        this.mOnlineBoardInfoTable.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapterForTable());
        this.mOnlineBoardInfoTable.getTableHeader().addMouseMotionListener(this.getMouseMotionAdapterForHeader());
        this.mOnlineAccessBoardInfoTable.addMouseListener((MouseListener)this.getAccessMouseAdaptor());
        this.mOnlineAccessBoardInfoTable.addMouseMotionListener((MouseMotionListener)this.getMouseMotionAdapterForAccessTable());
        this.mOnlineAccessBoardInfoTable.getTableHeader().addMouseMotionListener(this.getMouseMotionAdapterForAccessHeader());
    }

    private MouseMotionAdapter getMouseMotionAdapterForHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.setToolTipForTableHeader(oEvent);
            }
        };
    }

    private MouseMotionAdapter getMouseMotionAdapterForAccessHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.setToolTipForAccessTableHeader(oEvent);
            }
        };
    }

    private MouseMotionAdapter getMouseMotionAdapterForTable() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.setToolTipForTable(oEvent);
            }
        };
    }

    private MouseMotionAdapter getMouseMotionAdapterForAccessTable() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.setToolTipForAccessTable(oEvent);
            }
        };
    }

    private MouseAdapter getMouseAdaptor() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.onlineBoardTable_MousePressed(oEvent);
                if (OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.getSelectedRowCount() > 0) {
                    return;
                }
                if (0 == (0x10 & oEvent.getModifiers())) {
                    int iRowIndex = OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.rowAtPoint(oEvent.getPoint());
                    OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.setRowSelectionInterval(iRowIndex, iRowIndex);
                }
            }
        };
    }

    private MouseAdapter getAccessMouseAdaptor() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oEvent) {
                OnlineBoardUpgradeFrame.this.onlineAccessBoardTable_MousePressed(oEvent);
                if (OnlineBoardUpgradeFrame.this.mOnlineAccessBoardInfoTable.getSelectedRowCount() > 0) {
                    return;
                }
                if (0 == (0x10 & oEvent.getModifiers())) {
                    int iRowIndex = OnlineBoardUpgradeFrame.this.mOnlineAccessBoardInfoTable.rowAtPoint(oEvent.getPoint());
                    OnlineBoardUpgradeFrame.this.mOnlineAccessBoardInfoTable.setRowSelectionInterval(iRowIndex, iRowIndex);
                }
            }
        };
    }

    private void setToolTipForTableHeader(MouseEvent oEvent) {
        int iColumnIndex = this.mOnlineBoardInfoTable.getTableHeader().columnAtPoint(oEvent.getPoint());
        String strToolTip = this.mOnlineBoardInfoTable.getColumnName(iColumnIndex);
        this.mOnlineBoardInfoTable.getTableHeader().setToolTipText(strToolTip);
    }

    private void setToolTipForAccessTableHeader(MouseEvent oEvent) {
        int iColumnIndex = this.mOnlineAccessBoardInfoTable.getTableHeader().columnAtPoint(oEvent.getPoint());
        String strToolTip = this.mOnlineAccessBoardInfoTable.getColumnName(iColumnIndex);
        this.mOnlineAccessBoardInfoTable.getTableHeader().setToolTipText(strToolTip);
    }

    private void setToolTipForTable(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        String strToolTipText = this.mOnlineBoardInfoTable.getValueAt(this.mOnlineBoardInfoTable.rowAtPoint(oPoint), this.mOnlineBoardInfoTable.columnAtPoint(oPoint)).toString();
        this.mOnlineBoardInfoTable.setToolTipText(strToolTipText);
    }

    private void setToolTipForAccessTable(MouseEvent oEvent) {
        Point oPoint = oEvent.getPoint();
        String strToolTipText = this.mOnlineAccessBoardInfoTable.getValueAt(this.mOnlineAccessBoardInfoTable.rowAtPoint(oPoint), this.mOnlineAccessBoardInfoTable.columnAtPoint(oPoint)).toString();
        this.mOnlineAccessBoardInfoTable.setToolTipText(strToolTipText);
    }

    private void onlineBoardTable_MousePressed(MouseEvent oEvent) {
        if (3 == oEvent.getButton()) {
            this.enableUpgradeMenuItem();
            this.enableRetryMenuItem();
            this.enableRemoveMenuItem();
            this.mUpgradePopupMenu.show((Component)this.mOnlineBoardInfoTable, oEvent.getX(), oEvent.getY());
        }
    }

    private void onlineAccessBoardTable_MousePressed(MouseEvent oEvent) {
        if (3 == oEvent.getButton()) {
            this.enableAccessUpgradeMenuItem();
            this.enableAccessRetryMenuItem();
            this.enableAccessRemoveMenuItem();
            this.mUpgradePopupMenu.show((Component)this.mOnlineAccessBoardInfoTable, oEvent.getX(), oEvent.getY());
        }
    }

    private void escKeyHandler() {
        ActionListener oEscKeyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineBoardUpgradeFrame.this.closeButtonActionPerformed();
            }
        };
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(oEscKeyListener, escKeyStroke, 2);
    }

    private void closeButtonActionPerformed() {
        this.closeDialog();
    }

    @Override
    protected void closeDialog() {
        int iVal;
        if (this.requestidDevice.size() > 0 && 0 != (iVal = DCOptionPane.showConfirmDialog(this.getGlassPane(), ResourceManager.getInstance().getResString("STOP_DELETE_SNMP"), ResourceManager.getInstance().getResString("INFO"), 2))) {
            return;
        }
        ObjectStore.getInstance().removeObjectInstance(ONLINEBOARD_UPGRADE_FRAME);
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
        DataCenterModuleManager DCModuleManager2 = (DataCenterModuleManager)ObjectStore.getInstance().getObjectInstance("DataCenterModule");
        if (!DCModuleManager2.isHaveOpenedDC()) {
            DeviceInfoManagerImpl.getInstance().setToNULL();
        }
        super.closeDialog();
    }

    private void setColumnsToTable() {
        ResourceManager oResManager = ResourceManager.getInstance();
        Object[] strColumns = new String[]{"NE_ID", oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), oResManager.getResString("ONLINE_BOARD_DEVICE_IP"), oResManager.getResString("ONLINE_BOARD_DEVICE_TYPE"), oResManager.getResString("ONLINE_BOARD_DEVICE_VERSION"), oResManager.getResString("ONLINE_BOARD_UPGRADE_STATUS"), "FRAME_ID", "PACKAGE_TYPE"};
        this.mOnlineBoardInfoTableModel = new DCSortableTableModel(strColumns, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.mOnlineBoardInfoTable = new DCExtendedTable((SortableTableModel)this.mOnlineBoardInfoTableModel);
        this.mOnlineBoardInfoTable.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oOnlineBoardInfoTable");
        this.mOnlineBoardInfoTable.getTableHeader().setReorderingAllowed(false);
        this.mOnlineBoardInfoTable.setRowSelectionAllowed(true);
        this.mOnlineBoardInfoTable.setRowHeight(21);
        this.setColumnSortable(this.mOnlineBoardInfoTable, strColumns.length);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(1).setMinWidth(80);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(2).setMinWidth(80);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(4).setMinWidth(80);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(5).setMinWidth(80);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(6).setMaxWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(6).setMinWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(6).setPreferredWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(7).setMaxWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(7).setMinWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(7).setPreferredWidth(0);
        this.mOnlineBoardInfoTable.getColumnModel().getColumn(5).setCellRenderer(OnlineBoardUpgradeFrame.getTableRenderer());
        Object[] strAccessColumns = new String[]{"NE_ID", oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), oResManager.getResString("ONLINE_BOARD_DEVICE_IP"), oResManager.getResString("ONLINE_BOARD_DEVICE_TYPE"), oResManager.getResString("ONLINE_BOARD_DEVICE_VERSION"), oResManager.getResString("ONLINE_BOARD_UPGRADE_STATUS")};
        this.mOnlineAccessBoardInfoTableModel = new DCSortableTableModel(strAccessColumns, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.mOnlineAccessBoardInfoTable = new DCExtendedTable((SortableTableModel)this.mOnlineAccessBoardInfoTableModel);
        this.mOnlineAccessBoardInfoTable.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oOnlineBoardInfoTable");
        this.mOnlineAccessBoardInfoTable.getTableHeader().setReorderingAllowed(false);
        this.mOnlineAccessBoardInfoTable.setRowSelectionAllowed(true);
        this.mOnlineAccessBoardInfoTable.setRowHeight(21);
        this.setColumnSortable(this.mOnlineAccessBoardInfoTable, strAccessColumns.length);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(1).setMinWidth(80);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(2).setMinWidth(80);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(4).setMinWidth(80);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(5).setMinWidth(80);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(5).setCellRenderer(OnlineBoardUpgradeFrame.getTableRenderer());
    }

    private void setColumnSortable(DCExtendedTable sortTable, int length) {
        for (int index = 0; index < length; ++index) {
            sortTable.setColumnSortable(index, true);
        }
    }

    public static TableCellRenderer getTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
                JLabel label = new JLabel();
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(Color.white);
                } else {
                    label.setBackground(table.getBackground());
                    label.setForeground(table.getForeground());
                }
                if (value instanceof String) {
                    String operSuccess = ResourceManager.getInstance().getResString("Error_Code_0");
                    String operSuccessForT2000 = ResourceManager.getInstance().getResString("ONLINE_BOARD_UPGRADE_SUCCESSFUL");
                    String operRunning = ResourceManager.getInstance().getResString("TASK_STATUS_RUNNING");
                    String operNotRun = ResourceManager.getInstance().getResString("ONLINE_BOARD_NOT_RUN");
                    if (value.toString().equals(operSuccess) || value.toString().equals(operSuccessForT2000)) {
                        label.setText(value.toString());
                        label.setForeground(TASK_STATE_SUCCESS_COLOR);
                    } else if (value.toString().equals(operRunning)) {
                        label.setText(value.toString());
                        label.setForeground(TASK_STATE_NOT_RUN_COLOR);
                    } else if (value.toString().equals(operNotRun)) {
                        label.setText(value.toString());
                        label.setForeground(table.getForeground());
                    } else {
                        label.setText(value.toString());
                        label.setForeground(TASK_STATE_FAILURE_COLOR);
                    }
                }
                return label;
            }
        };
    }

    public void onlineBoardUpgrade() {
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        AsnBoardUpgradeReq oAsnBoardUpgradeReq = new AsnBoardUpgradeReq();
        int domain = this.getSelectTab();
        oAsnBoardUpgradeReq.enOperType = this.mbRetryFlag ? new AsnBoardOperEnum(1) : new AsnBoardOperEnum(0);
        DCExtendedTable midTable = null;
        midTable = domain == 0 ? this.mOnlineBoardInfoTable : this.mOnlineAccessBoardInfoTable;
        int[] arrSelectedRows = midTable.getSelectedRows();
        int iDevId = -1;
        int iFrameId = -1;
        int iSlotId = -1;
        int iSubSlotId = -1;
        int iPkgType = -1;
        String strBoardId = null;
        if (domain == 0) {
            LinkedList<PkgDevInfo> oSelectedPkgDevLst = new LinkedList<PkgDevInfo>();
            for (int index = 0; index < arrSelectedRows.length; ++index) {
                iDevId = (Integer)midTable.getValueAt(arrSelectedRows[index], 0);
                if (this.isExistRunningBoard(iDevId)) {
                    DCOptionPane.showMessageDialog((Component)((Object)this), oResourceMgr.getResString(oResourceMgr.getResString("DEVICE_TABLE_HAVE_BOARD_RUNNING")), oResourceMgr.getResString("SYSTEM_INFO_ERROR"), 0);
                    return;
                }
                iFrameId = (Integer)midTable.getValueAt(arrSelectedRows[index], 6);
                strBoardId = midTable.getValueAt(arrSelectedRows[index], 1).toString();
                iPkgType = (Integer)midTable.getValueAt(arrSelectedRows[index], 7);
                if (iPkgType == 1) {
                    iSlotId = -1;
                } else {
                    String[] strToken = strBoardId.split("_");
                    iSlotId = Integer.parseInt(strToken[strToken.length - 1]);
                }
                int[] arrBoardInfoParas = new int[]{iDevId, iFrameId, iSlotId, iSubSlotId};
                OnlineBoardUpgradeInfo onlineBoardInfo = this.getOnlineBoardUpgradeInfo(arrBoardInfoParas);
                AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfoRsp = null;
                PkgDevInfo oPkgDevInfo = new PkgDevInfo(iDevId, iSlotId, iPkgType);
                if (iPkgType == 1) {
                    oSelectedPkgDevLst.add(oPkgDevInfo);
                }
                if (null != onlineBoardInfo) {
                    oAsnBoardUpgradeInfoRsp = OnlineBoardUtility.getInstance().fillAsnBoardUpgrade(onlineBoardInfo, new AsnBoardOperEnum(0), iPkgType);
                }
                oAsnBoardUpgradeReq.oOnlineBoardInfoLst.add(oAsnBoardUpgradeInfoRsp);
            }
            this.populateOtherDevsToHm(oSelectedPkgDevLst, domain);
        } else {
            for (int index = 0; index < arrSelectedRows.length; ++index) {
                iDevId = (Integer)midTable.getValueAt(arrSelectedRows[index], 0);
                AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfoRsp = new AsnBoardUpgradeInfoRsp();
                oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.iDevId = BigInteger.valueOf(iDevId);
                oAsnBoardUpgradeReq.oOnlineBoardInfoLst.add((Object)oAsnBoardUpgradeInfoRsp);
            }
        }
        if (domain == 0) {
            this.sendOnlineBoardUpgrade(oAsnBoardUpgradeReq);
        } else {
            this.sendOnlineAccessBoardUpgrade(oAsnBoardUpgradeReq);
        }
    }

    private OnlineBoardUpgradeInfo getOnlineBoardUpgradeInfo(int[] arrBoardInfoParas) {
        if (null == this.mOnlineBoardInfoLst) {
            return null;
        }
        int iBoardCount = this.mOnlineBoardInfoLst.size();
        OnlineBoardUpgradeInfo oOnlineBoardUpgradeInfo = null;
        for (int index = 0; index < iBoardCount; ++index) {
            ArrayList oFrameList;
            oOnlineBoardUpgradeInfo = (OnlineBoardUpgradeInfo)this.mOnlineBoardInfoLst.get(index);
            if (arrBoardInfoParas[0] != oOnlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevId() || !this.isFramePresentInList(oFrameList = oOnlineBoardUpgradeInfo.getOnlineBoardInfo().getFrameInfoLst(), arrBoardInfoParas)) continue;
            return oOnlineBoardUpgradeInfo;
        }
        return null;
    }

    private boolean isFramePresentInList(List<DCFrameInfo> frameList, int[] arrBoardInfoParas) {
        if (null == frameList || 0 == frameList.size()) {
            return false;
        }
        int iFrameCount = frameList.size();
        DCFrameInfo oFrameInfo = null;
        for (int i = 0; i < iFrameCount; ++i) {
            oFrameInfo = frameList.get(i);
            if (!this.isBoardPresentInList(oFrameInfo.getBoardLst(), arrBoardInfoParas)) continue;
            return true;
        }
        return false;
    }

    private boolean isBoardPresentInList(List<BoardInfo> oBoardList, int[] arrBoardInfoParas) {
        if (null == oBoardList || 0 == oBoardList.size()) {
            return false;
        }
        int iBoardCount = oBoardList.size();
        BoardInfo oBoardInfo = null;
        for (int i = 0; i < iBoardCount; ++i) {
            oBoardInfo = oBoardList.get(i);
            if (arrBoardInfoParas[2] != oBoardInfo.getSlotId()) continue;
            ArrayList oSubSlotList = oBoardInfo.getSlotList();
            if (null == oSubSlotList || 0 == oSubSlotList.size()) {
                return true;
            }
            return this.isSubSlotPresentInList(oSubSlotList, arrBoardInfoParas);
        }
        return false;
    }

    private boolean isSubSlotPresentInList(ArrayList<SubSlotInfo> slotList, int[] arrBoardInfoParas) {
        if (null == slotList || 0 == slotList.size()) {
            return false;
        }
        int iSubSlotCount = slotList.size();
        SubSlotInfo oSubSlotInfo = null;
        for (int i = 0; i < iSubSlotCount; ++i) {
            oSubSlotInfo = slotList.get(i);
            if (arrBoardInfoParas[3] != oSubSlotInfo.getSubSlotId()) continue;
            return true;
        }
        return false;
    }

    private void sendOnlineBoardUpgrade(AsnBoardUpgradeReq oAsnBoardUpgradeReq) {
        OnlineBoardManager.getInstance().sendUpgradeRequest(oAsnBoardUpgradeReq);
    }

    private void sendOnlineAccessBoardUpgrade(AsnBoardUpgradeReq oAsnBoardUpgradeReq) {
        OnlineBoardManager.getInstance().sendAccessUpgradeRequest(oAsnBoardUpgradeReq);
    }

    public synchronized String getOperationStatus(int iOperationStatus) {
        String strOperationStatus = " ";
        switch (iOperationStatus) {
            case 1: {
                strOperationStatus = ResourceManager.getInstance().getResString("ONLINE_BOARD_UPGRADE_FAILED");
                break;
            }
            case 2: {
                strOperationStatus = ResourceManager.getInstance().getResString("ONLINE_BOARD_NOT_RUN");
                break;
            }
            case 0: {
                strOperationStatus = ResourceManager.getInstance().getResString("ONLINE_BOARD_UPGRADE_SUCCESSFUL");
                break;
            }
            case 3: {
                strOperationStatus = ResourceManager.getInstance().getResString("TASK_STATUS_RUNNING");
            }
        }
        return strOperationStatus;
    }

    public void retry() {
        this.mbRetryFlag = true;
        this.onlineBoardUpgrade();
        this.mbRetryFlag = false;
    }

    public void remove() {
        int[] arrSelectedRows = this.mOnlineBoardInfoTable.getSelectedRows();
        AsnBoardUpgradeReq oAsnBoardUpgradeReq = new AsnBoardUpgradeReq();
        int iDevId = -1;
        int iFrameId = -1;
        int iSlotId = -1;
        int iSubSlotId = -1;
        int iPkgType = -1;
        OnlineBoardUpgradeInfo onlineBoardInfo = null;
        for (int index = arrSelectedRows.length - 1; index >= 0; --index) {
            iDevId = (Integer)this.mOnlineBoardInfoTable.getValueAt(arrSelectedRows[index], 0);
            iFrameId = (Integer)this.mOnlineBoardInfoTable.getValueAt(arrSelectedRows[index], 6);
            iPkgType = (Integer)this.mOnlineBoardInfoTable.getValueAt(arrSelectedRows[index], 7);
            String strBoardId = this.mOnlineBoardInfoTable.getValueAt(arrSelectedRows[index], 1).toString();
            if (1 == iPkgType) {
                iSlotId = -1;
            } else {
                String[] strToken = strBoardId.split("_");
                iSlotId = Integer.parseInt(strToken[strToken.length - 1]);
            }
            int[] arrBoardInfoParas = new int[]{iDevId, iFrameId, iSlotId, iSubSlotId};
            onlineBoardInfo = this.getOnlineBoardUpgradeInfo(arrBoardInfoParas);
            AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfoRsp = null;
            oAsnBoardUpgradeInfoRsp = OnlineBoardUtility.getInstance().fillAsnBoardUpgrade(onlineBoardInfo, new AsnBoardOperEnum(2), iPkgType);
            oAsnBoardUpgradeReq.oOnlineBoardInfoLst.add((Object)oAsnBoardUpgradeInfoRsp);
            oAsnBoardUpgradeReq.enOperType = new AsnBoardOperEnum(2);
            OnlineBoardManager onlineBoardMgr = OnlineBoardManager.getInstance();
            AsnDCOpertionRsp oAsnDCOperationRsp = onlineBoardMgr.sendUpgradeRequest(oAsnBoardUpgradeReq);
            AsnDCMultiDeviceErrLst oAsnDCMultiDeviceErrorLst = oAsnDCOperationRsp.oResultOpt;
            AsnDCMultiDeviceErr oAsnDCMultiDeviceErr = null;
            boolean bIsAllBoardSuccessfullyRemoved = true;
            for (int iErrorIndex = 0; iErrorIndex < oAsnDCMultiDeviceErrorLst.size(); ++iErrorIndex) {
                oAsnDCMultiDeviceErr = (AsnDCMultiDeviceErr)oAsnDCMultiDeviceErrorLst.get(iErrorIndex);
                if (0 == oAsnDCMultiDeviceErr.oErrorInfo.iErrorNo.intValue()) continue;
                bIsAllBoardSuccessfullyRemoved = false;
            }
            if (!bIsAllBoardSuccessfullyRemoved) continue;
            this.mOnlineBoardInfoTableModel.removeRow(arrSelectedRows[index]);
        }
        this.sendOnlineBoardUpgrade(oAsnBoardUpgradeReq);
    }

    private void updateFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.updateUI();
            }
        });
    }

    public void addRow() {
        this.getBoardInfo();
        TableColumn oColumn = this.mOnlineBoardInfoTable.getColumnModel().getColumn(0);
        this.mOnlineBoardInfoTable.getTableHeader().getComponent(0).setVisible(false);
        oColumn.setWidth(3);
        TableColumn oAccessColumn = this.mOnlineAccessBoardInfoTable.getColumnModel().getColumn(0);
        this.mOnlineAccessBoardInfoTable.getTableHeader().getComponent(0).setVisible(false);
        oAccessColumn.setWidth(3);
    }

    private void getBoardInfo() {
        OnlineBoardUpgradeInfo oBoardUpgradeInfo = null;
        OnlineBoardInfo oOnlineBoardInfo = null;
        ArrayList oDCFrameLst = null;
        DCFrameInfo oDCFrameInfo = null;
        ArrayList oDCBoardLst = null;
        BoardInfo oBoardInfo = null;
        ArrayList oSubSlotLst = null;
        boolean bisBoardExists = false;
        if (null == this.mOnlineBoardInfoLst) {
            return;
        }
        for (int index = 0; index < this.mOnlineBoardInfoLst.size(); ++index) {
            oBoardUpgradeInfo = (OnlineBoardUpgradeInfo)this.mOnlineBoardInfoLst.get(index);
            oOnlineBoardInfo = oBoardUpgradeInfo.getOnlineBoardInfo();
            oDCFrameLst = oOnlineBoardInfo.getFrameInfoLst();
            int iUpgradeType = oBoardUpgradeInfo.getPkgFileType();
            if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isBMSDomain()) {
                this.mRowData = new Vector(0);
                this.handleDevID(oOnlineBoardInfo);
                this.setAccessResourceName(oOnlineBoardInfo);
                this.setIpAddress(oOnlineBoardInfo);
                DeviceTypeInfo oDevTypeInfo = this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId());
                this.setDeviceType(oDevTypeInfo);
                this.setDeviceVersion(oOnlineBoardInfo);
                this.mRowData.add(ResourceManager.getInstance().getResString("ONLINE_BOARD_NOT_RUN"));
                this.mOnlineAccessBoardInfoTableModel.addRow(this.mRowData);
                continue;
            }
            for (int iFrameIndex = 0; iFrameIndex < oDCFrameLst.size(); ++iFrameIndex) {
                oDCFrameInfo = (DCFrameInfo)oDCFrameLst.get(iFrameIndex);
                oDCBoardLst = oDCFrameInfo.getBoardLst();
                for (int iBoardIndex = 0; iBoardIndex < oDCBoardLst.size(); ++iBoardIndex) {
                    this.mRowData = new Vector(0);
                    oBoardInfo = (BoardInfo)oDCBoardLst.get(iBoardIndex);
                    this.fillBoardInfo(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, iUpgradeType);
                    this.mRowData.add(iUpgradeType);
                    oSubSlotLst = oBoardInfo.getSlotList();
                    if (null != oSubSlotLst) {
                        this.addSubSlotToTable(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, oSubSlotLst);
                        continue;
                    }
                    if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isT2000Domain()) {
                        bisBoardExists = this.isBoardExistsInSlot(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, iUpgradeType);
                    }
                    if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isBMSDomain()) {
                        bisBoardExists = this.isAccessBoardExistsInSlot(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, iUpgradeType);
                    }
                    if (bisBoardExists) {
                        DCDebugTracer.trace("DC::getBoardInfo::bisBoardExists");
                        continue;
                    }
                    DCDebugTracer.trace("DC::getBoardInfo::addRow1");
                    if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isT2000Domain()) {
                        this.mOnlineBoardInfoTableModel.addRow(this.mRowData);
                    }
                    if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isBMSDomain()) {
                        this.mOnlineAccessBoardInfoTableModel.addRow(this.mRowData);
                    }
                    DCDebugTracer.trace("DC::getBoardInfo::addRow2");
                }
            }
        }
    }

    private boolean isBoardExistsInSlot(OnlineBoardInfo oOnlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, int pkgType) {
        String strBoardId = "";
        boolean bIsBoardExists = false;
        int iDevId = -1;
        int iSlotId = -1;
        for (int iRowIndex = 0; iRowIndex < this.mOnlineBoardInfoTable.getRowCount(); ++iRowIndex) {
            iDevId = (Integer)this.mOnlineBoardInfoTable.getValueAt(iRowIndex, 0);
            strBoardId = this.mOnlineBoardInfoTable.getValueAt(iRowIndex, 1).toString();
            int iUpgradeType = (Integer)this.mOnlineBoardInfoTable.getValueAt(iRowIndex, 7);
            if (iUpgradeType != pkgType || iDevId != oOnlineBoardInfo.getDCDeviceInfo().getDevId()) continue;
            if (iUpgradeType == 1) {
                bIsBoardExists = true;
                break;
            }
            String[] strToken = strBoardId.split("_");
            iSlotId = Integer.parseInt(strToken[strToken.length - 1]);
            if (iDevId != oOnlineBoardInfo.getDCDeviceInfo().getDevId() || iSlotId != oBoardInfo.getSlotId()) continue;
            bIsBoardExists = true;
            break;
        }
        return bIsBoardExists;
    }

    private boolean isAccessBoardExistsInSlot(OnlineBoardInfo oOnlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, int pkgType) {
        boolean bIsBoardExists = false;
        int iDevId = -1;
        for (int iRowIndex = 0; iRowIndex < this.mOnlineAccessBoardInfoTable.getRowCount(); ++iRowIndex) {
            iDevId = (Integer)this.mOnlineAccessBoardInfoTable.getValueAt(iRowIndex, 0);
            if (iDevId != oOnlineBoardInfo.getDCDeviceInfo().getDevId()) continue;
            bIsBoardExists = true;
            break;
        }
        return bIsBoardExists;
    }

    private DeviceSearchModel createSearchModel() {
        DeviceSearchModel oModel = new DeviceSearchModel();
        oModel.setDeviceTypeList(this.getDeviceTypeList());
        oModel.setSearchModeList(this.getSearchModeList());
        return oModel;
    }

    private Vector getDeviceTypeList() {
        Vector<String> oTypeList = new Vector<String>(2);
        oTypeList.add(ResourceManager.getInstance().getResString("SEARCH_RESOURCE_TYPE_DEVICE"));
        return oTypeList;
    }

    private Vector getSearchModeList() {
        Vector<String> oModeList = new Vector<String>(2);
        oModeList.add(ResourceManager.getInstance().getResString("SEARCH_DEVICE_MODE_NAME_OPTION"));
        oModeList.add(ResourceManager.getInstance().getResString("SEARCH_DEVICE_MODE_IP_OPTION"));
        return oModeList;
    }

    private void openSearchDialog() {
        DeviceSearchModel oSearchModel = this.createSearchModel();
        DeviceSearchAddDialog oDialog = new DeviceSearchAddDialog((DCModalDialog)this, oSearchModel);
        oDialog.setVisible(true);
    }

    private boolean isBoardExistsInSubSlot(OnlineBoardInfo oOnlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, SubSlotInfo oSubSlotInfo) {
        String strBoardId = "";
        boolean bIsBoardExists = false;
        int iDevId = -1;
        int iFrameId = -1;
        int iSlotId = -1;
        int iSubSlotId = -1;
        DCExtendedTable midTable = null;
        if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isT2000Domain()) {
            midTable = this.mOnlineBoardInfoTable;
        }
        if (this.getDeviceTypeInfo(oOnlineBoardInfo.getDCDeviceInfo().getDevTypeId()).isBMSDomain()) {
            midTable = this.mOnlineAccessBoardInfoTable;
        }
        for (int iRowIndex = 0; iRowIndex < midTable.getRowCount(); ++iRowIndex) {
            iDevId = (Integer)midTable.getValueAt(iRowIndex, 0);
            strBoardId = midTable.getValueAt(iRowIndex, 1).toString();
            String[] strToken = strBoardId.split(":");
            if (3 == strToken.length) {
                iFrameId = Integer.parseInt(strToken[0].substring(5));
                iSlotId = Integer.parseInt(strToken[1].substring(4));
                iSubSlotId = Integer.parseInt(strToken[2].substring(7));
            }
            if (iDevId != oOnlineBoardInfo.getDCDeviceInfo().getDevId() || iFrameId != oDCFrameInfo.getFrameId() || iSlotId != oBoardInfo.getSlotId() || iSubSlotId != oSubSlotInfo.getSubSlotId()) continue;
            bIsBoardExists = true;
            break;
        }
        return bIsBoardExists;
    }

    private void addSubSlotToTable(OnlineBoardInfo oOnlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, ArrayList oSubSlotLst) {
        boolean bisBoardExists = false;
        if (null != oSubSlotLst) {
            for (int iSubSlotIndex = 0; iSubSlotIndex < oSubSlotLst.size(); ++iSubSlotIndex) {
                this.mRowData = new Vector(0);
                SubSlotInfo oSubSlotInfo = (SubSlotInfo)oSubSlotLst.get(iSubSlotIndex);
                bisBoardExists = this.isBoardExistsInSubSlot(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, oSubSlotInfo);
                if (bisBoardExists) continue;
                this.fillSubSlotBoardInfo(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, oSubSlotInfo);
                this.mOnlineBoardInfoTableModel.addRow(this.mRowData);
            }
        }
    }

    private void fillBoardInfo(OnlineBoardInfo onlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oDCBoardInfo, int iUpgradeType) {
        DeviceTypeInfo oDevTypeInfo = null;
        this.handleDevID(onlineBoardInfo);
        this.setResourceName(onlineBoardInfo, oDCBoardInfo, iUpgradeType);
        this.setIpAddress(onlineBoardInfo);
        oDevTypeInfo = this.getDeviceTypeInfo(onlineBoardInfo.getDCDeviceInfo().getDevTypeId());
        this.setDeviceType(oDevTypeInfo);
        this.setDeviceVersion(onlineBoardInfo);
        this.handleLastOperationState(onlineBoardInfo);
        this.setFrameID(oDCFrameInfo);
    }

    private void setDeviceVersion(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevDevVersion()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevDevVersion());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void setDeviceType(DeviceTypeInfo oDevTypeInfo) {
        if (null != oDevTypeInfo) {
            this.mRowData.add(oDevTypeInfo.getDevTypeName());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void setIpAddress(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevIPAddress()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevIPAddress());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void setResourceName(OnlineBoardInfo onlineBoardInfo, BoardInfo oDCBoardInfo, int iUpgradeType) {
        String resourceName = "";
        String devName = "unknown";
        String boardName = "unknown";
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevName()) {
            devName = onlineBoardInfo.getDCDeviceInfo().getDevName();
        }
        if (null != oDCBoardInfo.getStrBoardType()) {
            boardName = oDCBoardInfo.getStrBoardType();
        }
        resourceName = iUpgradeType == 1 ? devName : devName + "_" + boardName + "_" + oDCBoardInfo.getSlotId();
        this.mRowData.add(resourceName);
    }

    private void setAccessResourceName(OnlineBoardInfo onlineBoardInfo) {
        String resourceName = "";
        String devName = "unknown";
        resourceName = null != onlineBoardInfo.getDCDeviceInfo().getDevName() ? onlineBoardInfo.getDCDeviceInfo().getDevName() : devName;
        this.mRowData.add(resourceName);
    }

    private void setFrameID(DCFrameInfo oDCFrameInfo) {
        if (-1 != oDCFrameInfo.getFrameId()) {
            this.mRowData.add(oDCFrameInfo.getFrameId());
        } else {
            this.mRowData.add(0);
        }
    }

    private void fillSubSlotBoardInfo(OnlineBoardInfo onlineBoardInfo, DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, SubSlotInfo oSubSlotInfo) {
        this.handleDevID(onlineBoardInfo);
        this.hanldeSubSlotId(oDCFrameInfo, oBoardInfo, oSubSlotInfo);
        this.handleDisplayInfo(oBoardInfo);
        this.handleDevName(onlineBoardInfo);
        this.handleDevIP(onlineBoardInfo);
        this.hanldeDevTypeName(onlineBoardInfo);
        this.handleDevDevVersion(onlineBoardInfo);
        this.handleLastOperationState(onlineBoardInfo);
    }

    private void hanldeDevTypeName(OnlineBoardInfo onlineBoardInfo) {
        DeviceTypeInfo oDevTypeInfo = null;
        oDevTypeInfo = this.getDeviceTypeInfo(onlineBoardInfo.getDCDeviceInfo().getDevTypeId());
        if (null != oDevTypeInfo) {
            this.mRowData.add(oDevTypeInfo.getDevTypeName());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleLastOperationState(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getLastOperationState()) {
            AsnDCDeviceLastOperationStatusEnum oAsnDCDeviceLastOperationStatus = onlineBoardInfo.getDCDeviceInfo().getLastOperationState();
            String strOperationStatus = this.getOperationStatus(oAsnDCDeviceLastOperationStatus.value);
            this.mRowData.add(strOperationStatus);
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleDevDevVersion(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevDevVersion()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevDevVersion());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleDevIP(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevIPAddress()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevIPAddress());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleDevName(OnlineBoardInfo onlineBoardInfo) {
        if (null != onlineBoardInfo.getDCDeviceInfo().getDevName()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevName());
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleDisplayInfo(BoardInfo oBoardInfo) {
        if (null != oBoardInfo.getStrBoardType()) {
            String strDisplayInfo = oBoardInfo.getStrBoardType();
            this.mRowData.add(strDisplayInfo);
        } else {
            this.mRowData.add(" ");
        }
    }

    private void hanldeSubSlotId(DCFrameInfo oDCFrameInfo, BoardInfo oBoardInfo, SubSlotInfo oSubSlotInfo) {
        if (-1 != oBoardInfo.getSlotId() && -1 != oSubSlotInfo.getSubSlotId()) {
            if (-1 != oDCFrameInfo.getFrameId()) {
                this.mRowData.add("Frame" + oDCFrameInfo.getFrameId() + ":" + "Slot" + oBoardInfo.getSlotId() + ":" + "SubSlot" + oSubSlotInfo.getSubSlotId());
            } else {
                this.mRowData.add("Slot" + oBoardInfo.getSlotId() + ":" + "SubSlot" + oSubSlotInfo.getSubSlotId());
            }
        } else {
            this.mRowData.add(" ");
        }
    }

    private void handleDevID(OnlineBoardInfo onlineBoardInfo) {
        if (0 != onlineBoardInfo.getDCDeviceInfo().getDevId()) {
            this.mRowData.add(onlineBoardInfo.getDCDeviceInfo().getDevId());
        }
    }

    private DeviceTypeInfo getDeviceTypeInfo(int iDeviceTypeId) {
        AbstractDeviceInfoManager oDevInfoManager = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo[] oArrDevTypeInfo = oDevInfoManager.getDeviceTypes();
        DeviceTypeInfo oDevTypeInfo = null;
        for (int index = 0; index < oArrDevTypeInfo.length; ++index) {
            if (iDeviceTypeId != oArrDevTypeInfo[index].getDevTypeID()) continue;
            oDevTypeInfo = oArrDevTypeInfo[index];
            break;
        }
        if (null == oDevTypeInfo) {
            DCDebugTracer.trace("OnlineBoardUpgradeFrame#getDeviceTypeInfo#devTypeInfo is null,iDeviceTypeId = " + iDeviceTypeId);
            return null;
        }
        return oDevTypeInfo;
    }

    public synchronized int isResourceExist(PkgDevInfo oPkgDevInfo) {
        if (null == oPkgDevInfo) {
            return -1;
        }
        int devID = oPkgDevInfo.getDevID();
        int slotID = oPkgDevInfo.getSlotID();
        int pkgType = oPkgDevInfo.getPkgType();
        DCSortableTableModel midModel = null;
        DCExtendedTable midTable = null;
        DeviceTypeInfo devTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByDevId(devID);
        if (null == devTypeInfo) {
            DCDebugTracer.trace("isResourceExist#devTypeInfo is null,devid = " + devID);
            return -1;
        }
        if (devTypeInfo.isBMSDomain()) {
            midModel = this.mOnlineAccessBoardInfoTableModel;
            midTable = this.mOnlineAccessBoardInfoTable;
            int rowCount = midModel.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                int devID_Table = Integer.parseInt(midModel.getValueAt(row, 0).toString());
                if (devID != devID_Table) continue;
                return row;
            }
        } else {
            midModel = this.mOnlineBoardInfoTableModel;
            midTable = this.mOnlineBoardInfoTable;
            int rowCount = midModel.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                int devID_Table = Integer.parseInt(midModel.getValueAt(row, 0).toString());
                String resourceName = midTable.getValueAt(row, 1).toString();
                int pkgType_Table = Integer.parseInt(midModel.getValueAt(row, 7).toString());
                int slotID_Table = -1;
                if (pkgType_Table == 0) {
                    String[] resStr = resourceName.split("_");
                    slotID_Table = Integer.parseInt(resStr[resStr.length - 1]);
                }
                if (devID != devID_Table || slotID != slotID_Table || pkgType != pkgType_Table) continue;
                return row;
            }
        }
        return -1;
    }

    public synchronized int isAccessResourceExist(int devID) {
        DCSortableTableModel midModel = null;
        midModel = this.mOnlineAccessBoardInfoTableModel;
        int rowCount = midModel.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            int devID_Table = Integer.parseInt(midModel.getValueAt(row, 0).toString());
            if (devID != devID_Table) continue;
            return row;
        }
        return -1;
    }

    public synchronized void addRowToTable(ArrayList onlineBoardList) {
        if (null == onlineBoardList) {
            return;
        }
        final ArrayList onlineBrdlist = onlineBoardList;
        new Thread(){

            @Override
            public void run() {
                OnlineBoardUpgradeInfo oBoardUpgradeInfo = null;
                OnlineBoardInfo oOnlineBoardInfo = null;
                ArrayList oDCFrameLst = null;
                DCFrameInfo oDCFrameInfo = null;
                ArrayList oDCBoardLst = null;
                BoardInfo oBoardInfo = null;
                boolean bisBoardExists = false;
                if (null != OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.getCellEditor()) {
                    OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTable.getCellEditor().stopCellEditing();
                }
                for (int index = 0; index < onlineBrdlist.size(); ++index) {
                    oBoardUpgradeInfo = (OnlineBoardUpgradeInfo)onlineBrdlist.get(index);
                    oOnlineBoardInfo = oBoardUpgradeInfo.getOnlineBoardInfo();
                    oDCFrameLst = oOnlineBoardInfo.getFrameInfoLst();
                    int iPkgType = oBoardUpgradeInfo.getPkgFileType();
                    for (int iFrameIndex = 0; iFrameIndex < oDCFrameLst.size(); ++iFrameIndex) {
                        oDCFrameInfo = (DCFrameInfo)oDCFrameLst.get(iFrameIndex);
                        oDCBoardLst = oDCFrameInfo.getBoardLst();
                        for (int iBoardIndex = 0; iBoardIndex < oDCBoardLst.size(); ++iBoardIndex) {
                            OnlineBoardUpgradeFrame.this.mRowData = new Vector(0);
                            oBoardInfo = (BoardInfo)oDCBoardLst.get(iBoardIndex);
                            OnlineBoardUpgradeFrame.this.fillBoardInfo(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, iPkgType);
                            OnlineBoardUpgradeFrame.this.mRowData.add(iPkgType);
                            bisBoardExists = OnlineBoardUpgradeFrame.this.isBoardExistsInSlot(oOnlineBoardInfo, oDCFrameInfo, oBoardInfo, iPkgType);
                            if (bisBoardExists) {
                                DCDebugTracer.trace("DC::addRowToTable::bisBoardExists");
                                continue;
                            }
                            OnlineBoardUpgradeFrame.this.mOnlineBoardInfoLst.add(oBoardUpgradeInfo);
                            OnlineBoardUpgradeFrame.this.mOnlineBoardInfoTableModel.addRow(OnlineBoardUpgradeFrame.this.mRowData);
                        }
                    }
                }
            }
        }.start();
    }

    private boolean isExistRunningBoard(int devID) {
        int rowCount = this.mOnlineBoardInfoTableModel.getRowCount();
        ResourceManager oResourceMgr = ResourceManager.getInstance();
        String upgradeState = "";
        String running = oResourceMgr.getResString("TASK_STATUS_RUNNING");
        for (int row = 0; row < rowCount; ++row) {
            int devID_Table = Integer.parseInt(this.mOnlineBoardInfoTableModel.getValueAt(row, 0).toString());
            if (devID != devID_Table) continue;
            upgradeState = this.mOnlineBoardInfoTableModel.getValueAt(row, 5).toString();
            if (!upgradeState.equals(running)) continue;
            return true;
        }
        return false;
    }

    private void populateOtherDevsToHm(List<PkgDevInfo> oSelectedPkgDevInfoLst, int domainInfo) {
        HashMap<PkgDevInfo, List<PkgDevInfo>> oPkgDevHm = OnlineBoardManager.getInstance().getPkgDevHm();
        if (null == oSelectedPkgDevInfoLst) {
            return;
        }
        PkgDevInfo oSelectPkgDevInfo = null;
        for (int j = 0; j < oSelectedPkgDevInfoLst.size(); ++j) {
            oSelectPkgDevInfo = oSelectedPkgDevInfoLst.get(j);
            List<PkgDevInfo> corrPkgDevInfoLst = this.getCorrelativePkgDevInfo(oSelectPkgDevInfo, oSelectedPkgDevInfoLst, domainInfo);
            if (corrPkgDevInfoLst.size() <= 0) continue;
            oPkgDevHm.put(oSelectPkgDevInfo, corrPkgDevInfoLst);
        }
    }

    private List<PkgDevInfo> getCorrelativePkgDevInfo(PkgDevInfo oSelectPkgDevInfo, List<PkgDevInfo> oSelecPkgDevInfoLst, int domainInfo) {
        LinkedList<PkgDevInfo> oCorrPkgDevInfoLst = new LinkedList<PkgDevInfo>();
        if (null == oSelectPkgDevInfo) {
            return oCorrPkgDevInfoLst;
        }
        int iDevID = -1;
        int iPkgType = -1;
        String strBoardId = "";
        int iSlotId = -1;
        DCExtendedTable midTable = null;
        midTable = this.mOnlineBoardInfoTable;
        PkgDevInfo oPkgDevInfo = null;
        for (int i = 0; i < midTable.getRowCount(); ++i) {
            iDevID = (Integer)midTable.getValueAt(i, 0);
            strBoardId = midTable.getValueAt(i, 1).toString();
            iPkgType = (Integer)midTable.getValueAt(i, 7);
            if (iPkgType == 1) {
                iSlotId = -1;
            } else {
                String[] strToken = strBoardId.split("_");
                iSlotId = Integer.parseInt(strToken[strToken.length - 1]);
            }
            oPkgDevInfo = new PkgDevInfo(iDevID, iSlotId, iPkgType);
            if (oSelectPkgDevInfo.equals(oPkgDevInfo) || oSelectPkgDevInfo.getDevID() != oPkgDevInfo.getDevID() || oSelectPkgDevInfo.getPkgType() != oPkgDevInfo.getPkgType() || oSelecPkgDevInfoLst.contains(oPkgDevInfo) || oCorrPkgDevInfoLst.contains(oPkgDevInfo)) continue;
            oCorrPkgDevInfoLst.add(oPkgDevInfo);
        }
        return oCorrPkgDevInfoLst;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_ONLINE_BOARD";
    }

    public void setRequestidDevice(Map<BigInteger, AsnDCSyncReq> requestidDevice) {
        this.requestidDevice = requestidDevice;
    }

    public Map<BigInteger, AsnDCSyncReq> getRequestidDevice() {
        return this.requestidDevice;
    }
}

